#!/usr/bin/perl
#
# This program is Copyright (c) 2004 by Greg Ferrar.
#
# This script converts from IIS comma-separated log format to IIS W3C log format.
# It is useful when analyzing a dataset containing both IIS comma-separated and IIS W3C log data;
# it can be used to convert the comma-separated to W3C so all data can be analyzed in a
# single profile.
#
# Usage:   iis_csv_to_iis_w3c.pl.pl < infile > outfile
#     or   iis_csv_to_iis_w3c.pl.pl infile > outfile
#
use strict;

# Add W3C header
print "#Software: Microsoft Internet Information Services 6.0\n";
print "#Version: 1.0\n";
print "#Date: 2006-01-01 00:00:00\n";
print "#Fields: date time c-ip cs-username s-sitename s-computername s-ip sc-win32-status sc-bytes cs-bytes time-taken cs-method cs-uri-stem cs-uri-query\n";

# Parse all lines of input
while (<>) {

#    print;

    # Parse the line
    my ($c_ip, $cs_username, $month, $day, $year, $time, $s_sitename, $s_computername, $s_ip, $sc_win32_status, $sc_bytes, $cs_bytes, $sc_status, $time_taken, $cs_method, $cs_uri_stem, $cs_uri_query) =
	/^([^,]+), ([^,]+), ([0-9]+)\/([0-9]+)\/([0-9]+), ([0-9:]+), ([^,]+), ([^,]+), ([^,]+), ([0-9]+), ([0-9]+), ([0-9]+), ([0-9]+), ([0-9]+), ([^,]+), ([^,]+), ([^,]+),/;

#    print "=============================================\n";
#    print "c_ip=$c_ip\n";
#    print "cs_username=$cs_username\n";
#    print "year=$year\n";
#    print "month=$month\n";
#    print "day=$day\n";
#    print "time=$time\n";
#    print "s_sitename=$s_sitename\n";
#    print "s_computername=$s_computername\n";
#    print "s_ip=$s_ip\n";
#    print "sc_win32_status=$sc_win32_status\n";
#    print "sc_bytes=$sc_bytes\n";
#    print "cs_bytes=$cs_bytes\n";
#    print "sc_status=$sc_status\n";
#    print "time_taken=$time_taken\n";
#    print "cs_method=$cs_method\n";
#    print "cs_uri_stem=$cs_uri_stem\n";
#    print "cs_uri_query=$cs_uri_query\n";


    # If this line parsed okay, convert it to W3C
    if ($c_ip) {

	# Convert the date from Apache to W3C format
	my $date;
#	my $w3cdate = "20$year/$month/$day";
	my $w3cdate = sprintf("%04d-%02d-%02d", 2000 + $year, $month, $day);

	if ($time =~ /^[0-9]:/) {
	    $time = '0' . $time;
	}
	
	# Display the W3C line
	print "$w3cdate $time $c_ip $cs_username $s_sitename $s_computername $s_ip $sc_win32_status $sc_bytes $cs_bytes $time_taken $cs_method $cs_uri_stem $cs_uri_query\n";
	
    } # if match
    
    # If the regular expression doesn't match, display a warning:
    else {
	printf STDERR "WARNING: line does not match IIS CSV format; ignoring: $_\n";
    }

} # while <>
