//
// newProfileInfo.js
//
var newProfileInfo = {
	panel: null,
	init: function() {
		var panelObj = {
			panelId: 'new_profile_info:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: '-',
			zIndex: 20,
			isCover: true,
			closeEvent: newProfileInfo.close
		};
		newProfileInfo.panel = new util.Panel3(panelObj);
		YAHOO.util.Event.addListener('new_profile_info:close_btn', 'click', newProfileInfo.close);
	},
	openViaNewProfileWizard: function(newProfileNodeName, profileChanges, userGrants) {
		// This function is called from New Profile Wizard when the profile has been saved.
		// newProfilesDb is up to date which includes the new profile.
		// profiles.createNewProfileCompleted(newProfilesDb);
		// Reset userGrants
		profilesUtil.resetUserGrants(userGrants);
		profiles.handleNewProfile(profileChanges);
		profiles.closeNewProfileWizardWindow();
		// Open new profile info panel
		newProfileInfo.open(newProfileNodeName);
	},
	open: function(newProfileNodeName) {
		//
		// Init newProfileInfo panel
		//
		if (newProfileInfo.panel === null) {
			newProfileInfo.init();
		}
		var newProfileItem = profiles.getProfileItem(newProfileNodeName);
		// util.showObject(newProfileItem);
		// Update the info label
		var label = langVar('lang_admin.profiles.profile_has_been_created');
		label = label.replace(/__PARAM__1/, newProfileItem.label);
		util.updateT('new_profile_info:label', label);
		//
		// Handle View Reports, View Config and Delete link
		//
		// util.showObject(newProfileItem);
		var theProfileGrants = profilesUtil.getProfileGrants(newProfileNodeName);
		var isViewReportsPermission = theProfileGrants.isViewReports;
		var isViewConfigPermission = theProfileGrants.isViewConfig || theProfileGrants.isViewTools;
		if (isViewReportsPermission) {
			var viewReportsBtn = util.getE('new_profile_info:view_reports_btn');
			var viewReportsUrl = '?dp=reports&p=' + newProfileNodeName;
			if (newProfileItem.df != '') {
				viewReportsUrl += '&df=' + newProfileItem.df;
			}
			viewReportsBtn.href = viewReportsUrl;
		}
		if (isViewConfigPermission) {
			// TODO - there may be no permission for page=log_source, check for page permission!
			var viewConfigBtn = util.getE('new_profile_info:view_config_btn');
			var viewConfigUrl = '?dp=config&page=log_source&p=' + newProfileNodeName;
			viewConfigBtn.href = viewConfigUrl;
		}
		util.showE('new_profile_info:view_reports_btn', isViewReportsPermission);
		util.showE('new_profile_info:view_config_btn', isViewConfigPermission);
		//
		// Show profiles list and new profile info
		//
		newProfileInfo.panel.prePositionAtCenter();
		newProfileInfo.panel.open();
	},
	close: function() {
		newProfileInfo.panel.close();
	}
};
/* global profiles: false */
var convertProfile = (function() {
	'use strict';
	var YE = YAHOO.util.Event;
	var panel = null;
	var confirmPanel = null;
	var busyPanel = null;
	var taskId = '';
	var activeProfileName = '';
	function _init() {
		// If not yet initialized
		if (confirmPanel === null) {
			// Create simple progress panel
			busyPanel = new util.BusyPanel();
			// Init the confirm panel
			var panelObj = {
				panelId: 'convert_profiles:panel',
				panelClassName: 'panel-50',
				panelHeaderLabel: langVar('lang_admin.profiles.convert_profiles'),
				left: 80,
				top: 100,
				zIndex: 100,
				isCover: true,
				closeEvent: _cancelProfileConversion
			};
			confirmPanel = new util.Panel3(panelObj);
			YE.addListener('convert_profiles:no_btn', 'click', _cancelProfileConversion);
			YE.addListener('convert_profiles:yes_btn', 'click', _startProfileConversion);
		}
	}
	//
	//
	// Convert v8.0 and 8.1 profiles
	//
	//
	function handleActiveProfileConversion() {
		_init();
		_removeDeleteLinks();
		// This handles an already active profile conversion
		// while the profiles pages has been loaded or reloaded.
		var profileConversionState = pageInfo.profileConversionState;
		taskId = profileConversionState.taskId;
		activeProfileName = profileConversionState.profileName;
		var profileItem = profiles.getProfileItem(activeProfileName);
		var busyPanelText = langVar('lang_admin.profiles.converting_profiles_text') + '<strong>' + profileItem.label + '</strong>';
		busyPanel.showCustom(busyPanelText);
		_checkConvertProfileState(taskId);
	}
	function _getNextProfileNameToConvert() {
		// This gets the next profileName of the profile which has to be converted.
		var profilesDb = profiles.getProfilesDb();
		var profileName = '';
		for (var i = 0, l = profilesDb.length; i < l; i++) {
			var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);
			if (!profileItem.isValidProfile && profileItem.version === '8.0') {
				profileName = profileItem.name;
				break;
			}
		}
		return profileName;
	}
	function confirmProfileConversion() {
		_init();
		confirmPanel.open();
	}
	function _cancelProfileConversion() {
		confirmPanel.close();
	}
	function _startProfileConversion() {
		// Close confirm window
		confirmPanel.close();
		_removeDeleteLinks();
		var profileName = _getNextProfileNameToConvert();
		_convertProfile(profileName);
	}
	function _convertProfile(profileName) {
//		convertProfilesBtn.disable();
//		console.log('_convertProfile() - profileName: ' + profileName);
		// Keep track of the profileName which becomes converted
		activeProfileName = profileName;
		var profileItem = profiles.getProfileItem(activeProfileName);
		var busyPanelText = langVar('lang_admin.profiles.converting_profiles_text') + ' <strong>' + profileItem.label + '</strong>';
		busyPanel.showCustom(busyPanelText);
		var url = '?dp=admin_pages.profiles.convert_profile';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profile_name=' + profileName;
		util.serverPost(url, dat);
	}
	function convertProfileResponse(taskId) {
		// util.showObject(dat);
		// Check task state
		setTimeout(function() {_checkConvertProfileState(taskId)}, 2500);
	}
	function _checkConvertProfileState(taskId) {
		var url = '?dp=admin_pages.profiles.check_convert_profile_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.task_id=' + taskId;
		util.serverPost(url, dat);
	}
	function checkConvertProfileStateResponse(dat) {
		// util.showObject(dat);
		// alert('convertProfileResponse() - taskId: ' + dat.taskId);
		if (dat.isActiveTask) {
			// Recheck task state
			setTimeout(function() {_checkConvertProfileState(taskId)}, 1750);
		}
		else {
			// alert('Task completed.);
			// Mark the active profile as converted by setting version to empty string
			var profilesDb = profiles.getProfilesDb();
			profilesStorage.setProfileArrayItemValues(profilesDb['_' + activeProfileName], {version:''});
			// Continue to convert the next profile, if any
			var nextProfileName = _getNextProfileNameToConvert();
			if (nextProfileName !== '') {
				_convertProfile(nextProfileName);
			}
			else {
				// All profiles converted, get fresh profile data
				var isGetNewChecksum = true;
				activeProfileName = '';
				profiles.getProfileData(isGetNewChecksum);
				busyPanel.stop();
			}
		}
	}
	function _removeDeleteLinks() {
		// This removes the delete links in the profiles list
		var container = util.getE('profiles_profiles_list');
		var aElements = container.getElementsByTagName('a');
		var numberOfElements = aElements.length;
		for (var i = 0; i < numberOfElements; i++) {
			var e = aElements[i];
			// Hide Delete link
			e.style.display = 'none';
		}
	}
	// Return global properties and methods
	return {
		handleActiveProfileConversion: handleActiveProfileConversion,
		confirmProfileConversion: confirmProfileConversion,
		convertProfileResponse: convertProfileResponse,
		checkConvertProfileStateResponse: checkConvertProfileStateResponse
	};
}());
/* global profiles: false */
var deleteProfile = (function() {
	'use strict';
	var YE = YAHOO.util.Event;
	var panel = null;
	var busyPanel = null;
	var profileName = '';
	var savedProfileChanges = {};
	function init() {
		var panelObj = {
			panelId: 'delete_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.delete_profile'),
			// left: 100,
			// top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: cancelDeleteProfile
		};
		panel = new util.Panel3(panelObj);
		busyPanel = new util.BusyPanel();
		YE.addListener('delete_profile:no_btn', 'click', cancelDeleteProfile);
		YE.addListener('delete_profile:yes_btn', 'click', deleteProfile);
	}
	function confirmDelete(theProfileName) {
		// TODO - change the theProfileName to profileItem
//		alert('confirmDelete: ' + theProfileName);
		profileName = theProfileName;
		var profileItem = profiles.getProfileItem(profileName);
		var profileLabel = profileItem.label;
		var databaseType = profileItem.databaseType;
		var databaseName = profileItem.databaseName;
		var message = '';
		var messageContainer = util.getE('delete_profile:confirm_msg');
		var dropDatabaseLabel = '';
		var dropDatabaseLabelContainer;
		var showDropDatabaseSection = false;
		var defaultDropDatabaseValue = false;
		// util.showObject(profileItem);
		if (panel === null) {
			init();
		}
		if (databaseType === 'mysql' || databaseType === 'odbc_mssql') {
			showDropDatabaseSection = true;
			if (databaseType === 'mysql') {
				message = langVar('lang_admin.profiles.confirm_delete_mysql_message');
				dropDatabaseLabel = langVar('lang_admin.profiles.drop_mysql_database');
			}
			else {
				message = langVar('lang_admin.profiles.confirm_delete_mssql_message');
				dropDatabaseLabel = langVar('lang_admin.profiles.drop_mssql_database');
			}
			dropDatabaseLabelContainer = util.getE('delete_profile:drop_database_label');
			dropDatabaseLabel = dropDatabaseLabel.replace(/__PARAM__1/, '<strong>' + databaseName + '</strong>');
			dropDatabaseLabelContainer.innerHTML = dropDatabaseLabel;
			// Check drop database checkbox if profile name matches the database name
			defaultDropDatabaseValue = (profileName === databaseName);
			util.setF('delete_profile:drop_database', defaultDropDatabaseValue);
		}
		else {
			// Internal database and Oracle database server
			message = langVar('lang_admin.profiles.confirm_delete_message');
		}
		message = message.replace(/__PARAM__1/, '<strong>' + profileLabel + '</strong>');
		messageContainer.innerHTML = message;
		util.showE('delete_profile:drop_database_section', showDropDatabaseSection);
		panel.prePositionAtCenter();
		panel.open();
	}
	function cancelDeleteProfile() {
		panel.close();
	}
	function deleteProfile() {
		// util.showObject(profilesDb);
		// make sure no profile conversion is active
		var profileItem = profiles.getProfileItem(profileName);
		var databaseType = profileItem.databaseType;
		var dropDatabase = false;
		if (databaseType === 'mysql' || databaseType === 'odbc_mssql') {
			dropDatabase = util.getF('delete_profile:drop_database');
		}
		panel.close();
		util.hideE('form_section');
		util.showE('deleting_info');
		var url = '?dp=admin_pages.profiles.delete_profile';
		// -p (profile name) is required by erase_database()!
		// Specify "-p" for valid profiles only, else we get a server error!
		if (profileItem.isValidProfile) {
			url += '&p=' + profileItem.name;
		}
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profiles_list_checksum=' + pageInfo.profilesListChecksum;
		dat += '&v.fp.profile_name=' + profileName;
		dat += '&v.fp.is_valid_profile=' + profileItem.isValidProfile;
		dat += '&v.fp.drop_database=' + dropDatabase;
		dat += '&v.fp.version=' + profileItem.version;
		util.serverPost(url, dat);
	}
	function deleteProfileResponse(dat) {
		// util.showObject(dat);
		var profileChanges = dat.profileChanges;
		if (!dat.dropDatabase) {
			profiles.handleDeleteProfileCompleted(profileChanges);
		}
		else {
			// Save profileChanges for later
			savedProfileChanges = util.cloneObject(profileChanges);
			// DROP DATABASE is active, show busy panel and
			// get simple progress
			busyPanel.showCustom(dat.activeTaskMessage);
			// Check task state
			setTimeout('deleteProfile.checkDeleteDatabaseState("' + dat.taskId + '")', 1500);
		}
	}
	function checkDeleteDatabaseState(taskId) {
		var url = '?dp=admin_pages.profiles.check_delete_database_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.task_id=' + taskId;
		util.serverPost(url, dat);
	}
	function checkDeleteDatabaseStateResponse(dat) {
		if (dat.isActiveTask) {
			// Re-check task state
			setTimeout('deleteProfile.checkDeleteDatabaseState("' + dat.taskId + '")', 1500);
		}
		else {
			busyPanel.stop();
			profiles.handleDeleteProfileCompleted(savedProfileChanges);
			// Reset savedProfileChanges
			savedProfileChanges = {};
		}
	}
	// Return global properties and methods
	return {
		confirmDelete: confirmDelete,
		deleteProfileResponse: deleteProfileResponse,
		checkDeleteDatabaseState: checkDeleteDatabaseState,
		checkDeleteDatabaseStateResponse: checkDeleteDatabaseStateResponse
	};
}());
/* global
	profiles: false,
	renameProfileDb: false */
var renameProfile = (function() {
	'use strict';
	var panel = null;
	var validator = null;
	var sourceProfileLabel = '';
	var sourceProfileName = '';
	var existingProfileLabels = [];
	var existingProfileNames = [];
	// database data of the source profile
	var receivedDatabaseData = false;
	var databaseServerType = '';
	var databaseName = '';
	var isRealTimeProcessing = false;
	var initialBuildDone = false;
	var databaseIsReadyForReporting = false;
	// new profile data
	var newProfileName = '';
	var newProfileLabel = '';
	function init() {
		var YE = YAHOO.util.Event;
		var panelObj = {
			panelId: 'rename_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.rename_profile_title'),
			// left: 100,
			// top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: close
		};
		panel = new util.Panel3(panelObj);
		validator = new util.Validator();
		YE.addListener('rename_profile:profile_label', 'keyup', setOkButtonState);
		YE.addListener('rename_profile:ok_btn', 'click', renameAndSaveProfile);
		YE.addListener('rename_profile:cancel_btn', 'click', close);
	}
	function open(profileName, profileLabel) {
		if (panel === null) {
			init();
		}
		var profileInfoText = langVar('lang_admin.profiles.rename_profile_info') + ':';
		profileInfoText = profileInfoText.replace(/__PARAM__1/, profileLabel);
		util.updateT('rename_profile:info_text', profileInfoText);
		util.setF('rename_profile:profile_label', profileLabel);
		// Disable OK button
		util.disableE('rename_profile:ok_btn');
		// util.disableE('rename_profile:cancel_btn');
		// Set/reset global data
		sourceProfileLabel = profileLabel;
		sourceProfileName = profileName;
		receivedDatabaseData = false;
		// Reset existingProfileLabels and existingProfileNames
		existingProfileLabels = [];
		existingProfileNames = [];
		panel.prePositionAtCenter();
		panel.open();
		// Get fresh database data of the source profile
		getDatabaseData();
		// var inputElement = util.getE('rename_profile:profile_label');
		// inputElement.focus();
	}
	function close() {
		validator.reset();
		panel.close();
	}
	function getDatabaseData() {
		var url = '?dp=admin_pages.profiles.rename_get_db_info_data';
		url += '&p=' + sourceProfileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.profile_name=' + sourceProfileName;
		util.serverPost(url, dat);
	}
	function getDatabaseDataResponse(dat) {
//		util.showObject(dat);
		// Make sure that we got the data for the current profile
		if (dat.profileName === sourceProfileName) {
			if (dat.errorMessage === '') {
				receivedDatabaseData = true;
				// Set database variables for later use
				databaseServerType = dat.databaseServerType;
				databaseName = dat.databaseName;
				isRealTimeProcessing = dat.isRealTimeProcessing;
				databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
				initialBuildDone = dat.initialBuildDone;
				// util.enableE('rename_profile:cancel_btn');
			}
			else {
				// Show error message and close window
				alert(dat.errorMessage);
				close();
			}
		}
	}
	function setOkButtonState() {
		newProfileLabel = util.getF('rename_profile:profile_label');
		var makeEnabled = (newProfileLabel !== '' && (sourceProfileLabel !== newProfileLabel));
		util.enableE('rename_profile:ok_btn', makeEnabled);
	}
	function renameAndSaveProfile() {
		validator.reset();
		if (existingProfileLabels.length === 0) {
			// Get existingProfileLabels and existingProfileNames,
			// except for the current profile which becomes deleted upon rename.
			var profilesDb = profiles.getProfilesDb();
			for (var i = 0, len = profilesDb.length; i < len; i++) {
				var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);
				if (profileItem.name !== sourceProfileName) {
					existingProfileNames[i] = profileItem.name;
					existingProfileLabels[i] = profileItem.label;
				}
			}
		}
		// util.showObject(existingProfileLabels);
		// util.showObject(existingProfileNames);
		newProfileLabel = validator.isValue('rename_profile:profile_label');
		newProfileLabel = validator.isUnique('rename_profile:profile_label', existingProfileLabels);
		newProfileName = util.labelToUniqueNodeName(newProfileLabel, existingProfileNames, 'profile');
		// alert('newProfileName: ' + newProfileName);
		if (validator.allValid()) {
			if (newProfileName === sourceProfileName) {
				// alert('newProfileName is equal sourceProfileName');
				// The profile node name does not change, only the case (i.e. profile1 > PROFILE1) changed,
				// this case doesn't require any database action because we only rename the label of the profile.
				// Proceed with renaming the profile on server side
				renameAndSaveProfileFinal('');
			}
			else {
				// If we received up to date database data
				if (receivedDatabaseData) {
					// Allow to rename the database if it is an external server
					// and if the database is not yet build, else we just show a
					// warning message that the database name has to be modified
					// manually.
					// we 
					// Note, we allow to rename Oracle if no database exists
					if (databaseServerType === 'internal_sql') {
						// Proceed with renaming the profile on server side
						renameAndSaveProfileFinal('');
					}
					else {
						// External database server
						if (databaseIsReadyForReporting || initialBuildDone) {
							// We don't allow renaming of the external database server
							// Show an info that the external database server must be renamed manually
							var externalDbMsg = langVar('lang_admin.profiles.cannot_rename_external_database');
							externalDbMsg = externalDbMsg.replace(/__PARAM__1/, databaseName);
							if (confirm(externalDbMsg)) {
								// Proceed with renaming the profile on server side
								renameAndSaveProfileFinal('');
							}
						}
						else {
							// No database exists yet, show rename database window
							renameProfileDb.open(sourceProfileName, databaseName, newProfileName, newProfileLabel);
						}
					}
				}
				else {
					// No response from the server, try again and show an error message
					getDatabaseData();
					alert(langVar('lang_admin.profiles.rename_profile_connection_failed'));
				}
			}
		}
	}
	function renameAndSaveProfileFinal(newDatabaseName) {
		// This function is also called from the rename database window!
		// newDatabaseName is an empty string unless it is a new database name for external db servers
		// alert('newDatabaseName: ' + newDatabaseName);
		close();
		util.hideE('profiles_profiles_list');
		util.showE('saving_info');
		var url = '?dp=admin_pages.profiles.rename_profile';
		// We need to set the source_profile_name as -p option so that
		// database_sql_query knows what profile to use.
		url += '&p=' + sourceProfileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.source_profile_name=' + sourceProfileName;
		dat += '&v.fp.new_profile_name=' + newProfileName;
		dat += '&v.fp.new_profile_label=' + encodeURIComponent(newProfileLabel);
		dat += '&v.fp.new_database_name=' + encodeURIComponent(newDatabaseName);
		util.serverPost(url, dat);
	}
	function renameAndSaveProfileFinalResponse(dat) {
		// Reset userGrants
		profilesUtil.resetUserGrants(dat.userGrants);
		// util.showObject(dat);
		// We always load a new profilesDb when renaming a profile
		// because this is a rare uses case.
		profiles.handleNewProfilesDb(dat.profileChanges);
		var errorMessage = dat.errorMessage;
		if (errorMessage !== '') {
			alert(errorMessage);
		}
	}
	// Return global properties and methods
	return {
		open: open,
		close: close,
		getDatabaseDataResponse: getDatabaseDataResponse,
		renameAndSaveProfile: renameAndSaveProfile,
		renameAndSaveProfileFinal: renameAndSaveProfileFinal,
		renameAndSaveProfileFinalResponse: renameAndSaveProfileFinalResponse,
		setOkButtonState: setOkButtonState
	};
}());
/* global
	profiles: false,
	renameProfile: false */
var renameProfileDb = (function() {
	var panel = null;
	var validator = null;
	var sourceProfileName = '';
	var sourceProfileDatabaseName = '';
	var newProfileName = '';
	function init() {
		var YE = YAHOO.util.Event;
		var panelObj = {
			panelId: 'rename_profile_db:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.rename_profile_database_title'),
			// left: 100,
			// top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: close
		};
		panel = new util.Panel3(panelObj);
		validator = new util.Validator();
		var dbNameButtons = ['rename_profile_db:use_profile_name_btn', 'rename_profile_db:keep_existing_name_btn', 'rename_profile_db:define_custom_name_btn'];
		YE.addListener(dbNameButtons, 'click', toggleDbNameSwitch);
		YE.addListener('rename_profile_db:ok_btn', 'click', rename);
		YE.addListener('rename_profile_db:cancel_btn', 'click', close);
	}
	function open(sourceProfileName, sourceProfileDatabaseName, newProfileName, newProfileLabel) {
		if (panel === null) {
			init();
		}
		// Set Db info
		var infoText = langVar('lang_admin.profiles.rename_profile_database_info');
		infoText = infoText.replace(/__PARAM__1/, '<strong>' + newProfileLabel + '</strong>');
		var containerElement = util.getE('rename_profile_db:rename_db_info');
		containerElement.innerHTML = infoText;
		// Set use profile name label
		var useProfileNameText = langVar('lang_admin.profiles.use_profile_name_for_db_name');
		useProfileNameText = useProfileNameText.replace(/__PARAM__1/, '<strong>' + newProfileName + '</strong>');
		var useProfileNameContainer = util.getE('rename_profile_db:use_profile_name_label');
		useProfileNameContainer.innerHTML = useProfileNameText;
		var keepExistingNameText = langVar('lang_admin.profiles.keep_existing_name_for_db_name');
		keepExistingNameText = keepExistingNameText.replace(/__PARAM__1/, '<strong>' + sourceProfileDatabaseName + '</strong>');
		var keepExistingNameContainer = util.getE('rename_profile_db:keep_existing_name_label');
		keepExistingNameContainer.innerHTML = keepExistingNameText;
		// Set default radio button and field values depending on source profile names
		if (sourceProfileName === sourceProfileDatabaseName) {
			util.setF('rename_profile_db:use_profile_name_btn', true);
		}
		else {
			util.setF('rename_profile_db:keep_existing_name_btn', true);
		}
		util.setF('rename_profile_db:database_name', '');
		toggleDbNameSwitch();
		panel.prePositionAtCenter();
		panel.open();
	}
	function close() {
		validator.reset();
		panel.close();
	}
	function toggleDbNameSwitch() {
		var isCustomDatabaseName = util.getF('rename_profile_db:define_custom_name_btn');
		util.enableE('rename_profile_db:database_name', isCustomDatabaseName);
		// Reset validator if we switch to non-custom database name
		if (!isCustomDatabaseName) {
			validator.reset();
		}
	}
	function getIsUniqueDatabaseName(newDatabaseName) {
		var profilesDb = profiles.getProfilesDb();
		var isUniqueDatabaseName = true;
		for (var i = 0; i < profilesDb.length; i++) {
			var profileItem = profiles.profileArrayItemToObject(profilesDb[i]);
			var profileName = profileItem.name;
			if (profileName !== sourceProfileName) {
				if (profileName === newDatabaseName ||
					profileItem.databaseName === newDatabaseName) {
					// util.showObject(profileItem);
					isUniqueDatabaseName = false;
					break;
				}
			}
		}
		return isUniqueDatabaseName;
	}
	function rename() {
		validator.reset();
		var newDatabaseName = '';
		var isValidated = false;
		// If we don't keep the existing name
		if (!util.getF('rename_profile_db:keep_existing_name_btn')) {
			var databaseName = '';
			if (util.getF('rename_profile_db:use_profile_name_btn')) {
				// We use the new profile node name as new database name
				databaseName = newProfileName;
				if (databaseName !== sourceProfileDatabaseName) {
					// alert('databaseName: ' + databaseName);
					// We still need to check if the new profile node name isn't already used as database name
					if (getIsUniqueDatabaseName(databaseName)) {
						// The databaseName is valid, assign it to newDatabaseName
						isValidated = true;
						newDatabaseName = databaseName;
					}
					else {
						// Show alert
						alert(langVar('lang_admin.database.database_name_already_exists'));
					}
				}
				else {
					// Unlikely but possible, the new profile node name matches the existing database name
					isValidated = true;
				}
			}
			else {
				// Custom database name
				databaseName = validator.isValue('rename_profile_db:database_name');
				if (databaseName !== '' && (databaseName === sourceProfileDatabaseName)) {
					// We keep the existing name, which has been defined manually
					isValidated = true;
				}
				else {
					if (databaseName !== '') {
						// Check for unique database name. The database name should be different than any existing profile name
						// or database name, even if the same name is used in a different database server type.
						if (getIsUniqueDatabaseName(databaseName)) {
							// The databaseName is valid, assign it to newDatabaseName
							newDatabaseName = databaseName;
							isValidated = true;
						}
						else {
							// Throw custom error message
							validator.isCustom('rename_profile_db:database_name', langVar('lang_admin.database.database_name_already_exists'));
						}
					}
					if (validator.allValid()) {
						isValidated = true;
					}
				}
			}
		}
		else {
			// Keep existing database name
			isValidated = true;
		}
		if (isValidated) {
			close();
			renameProfile.renameAndSaveProfileFinal(newDatabaseName);
		}
	}
	// Return global properties and methods
	return {
		open: open
	};
}());
/* global
	profiles: false,
	profilesStorage: false */
var duplicateProfile = (function() {
	'use strict';
	var panel = null;
	var validator = null;
	var sourceProfileName = '';
	var existingProfileLabels = [];
	var existingProfileNames = [];
	function init() {
		var YE = YAHOO.util.Event;
		var panelObj = {
			panelId: 'duplicate_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.duplicate_profile_title'),
			zIndex: 20,
			isCover: true,
			closeEvent: close
		};
		panel = new util.Panel3(panelObj);
		validator = new util.Validator();
		YE.addListener('duplicate_profile:ok_btn', 'click', duplicateAndSave);
		YE.addListener('duplicate_profile:cancel_btn', 'click', close);
	}
	function open(profileName, profileLabel) {
		if (panel === null) {
			init();
		}
		var profileInfoText = langVar('lang_admin.profiles.duplicate_profile_info') + ':';
		profileInfoText = profileInfoText.replace(/__PARAM__1/, profileLabel);
		util.updateT('duplicate_profile:info_text', profileInfoText);
		var defaultProfileLabel = langVar('lang_stats.general.item_copy');
		defaultProfileLabel = defaultProfileLabel.replace(/__PARAM__1/, profileLabel);
		util.setF('duplicate_profile:profile_label', defaultProfileLabel);
		// Set sourceProfileName
		sourceProfileName = profileName;
		// Reset existingProfileLabels and existingProfileNames
		existingProfileLabels = [];
		existingProfileNames = [];
		panel.prePositionAtCenter();
		panel.open();
		var inputElement = util.getE('duplicate_profile:profile_label');
		inputElement.focus();
	}
	function close() {
		validator.reset();
		panel.close();
	}
	function duplicateAndSave() {
		validator.reset();
		if (existingProfileLabels.length === 0) {
			// Get existingProfileLabels and existingProfileNames
			var profilesDb = profiles.getProfilesDb();
			for (var i = 0, len = profilesDb.length; i < len; i++) {
				var profileItem =  profilesStorage.profileArrayItemToObject(profilesDb[i]);
				existingProfileNames[i] = profileItem.name;
				existingProfileLabels[i] = profileItem.label;
			}
		}
//		util.showObject(existingProfileLabels);
//		util.showObject(existingProfileNames);
		var newProfileLabel = validator.isValue('duplicate_profile:profile_label');
		newProfileLabel = validator.isUnique('duplicate_profile:profile_label', existingProfileLabels);
		if (validator.allValid()) {
			close();
			util.hideE('profiles_profiles_list');
			util.showE('saving_info');
			var newProfileName = util.labelToUniqueNodeName(newProfileLabel, existingProfileNames, 'profile');
			// alert('newProfileName: ' + newProfileName);
			var url = '?dp=admin_pages.profiles.duplicate_profile';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			dat += '&v.fp.profiles_list_checksum=' + pageInfo.profilesListChecksum;
			dat += '&v.fp.source_profile_name=' + sourceProfileName;
			dat += '&v.fp.new_profile_name=' + newProfileName;
			dat += '&v.fp.new_profile_label=' + encodeURIComponent(newProfileLabel);
			util.serverPost(url, dat);
		}
	}
	function duplicateAndSaveResponse(dat) {
		// Reset userGrants
		profilesUtil.resetUserGrants(dat.userGrants);
		// util.showObject(dat);
		profiles.handleNewProfile(dat.profileChanges);
		var errorMessage = dat.errorMessage;
		if (errorMessage !== '') {
			alert(errorMessage);
		}
	}
	// Return global properties and methods
	return {
		open: open,
		duplicateAndSave: duplicateAndSave,
		close: close,
		duplicateAndSaveResponse: duplicateAndSaveResponse
	};
}());
/* global
	profiles: false,
	profilesUtil: false,
	profilesStorage: false */
var profilesDashboard = (function() {
	'use strict';
	// This handles profiles dashboard data
	// dashboardData
	// contains databaseInfo and report data.
	// dashboardData is created on client only.
	//
	// [
	// 		{
	// 		name: profile_name
	// 		viewDashboard: view report data permission
	// 		viewDatabaseInfo: view database info permission
	// 		dbInfo: [
	// 			bool isLoaded,
	// 			int db_state 0=not build 1=building 2=built,
	// 			int last_modification_time in epoc
	// 			]
	//		reportCellsCode:
	// 			0 = ignore report cells,
	// 			1 = has or possibly has report cells (will be verified on server)
	// 			2 = requested/generating (labels are already loaded, report is generated on server)
	// 			3 = loaded
	//			// TODO - how to handle report errors?
	//		reportCells: [[bool showValue, string label, string value], [showValue], [showValue, label, value]]
	//		}
	//		showValue in report cell means that a value can be shown or will be shown after loading.
	// ]
	var dashboardData = [];
	var profilesInViewRef = [];
//	var lastRequestDateInMilSec = 0;
	function createDashboardData() {
		// ToDO, if dashboardData already exists
		// then create a backup and use its values for
		// the new one. This would avoid reloading of
		// all database and report data.
		// Though fresh data would'nt be bad either!
		// Report data are cached anyway.
		var isRootAdmin = pageInfo.isRootAdmin;
		var isViewDashboardPermission = isRootAdmin;
		var isViewDatabaseInfoPermission = isRootAdmin;
		dashboardData = [];
		var profilesDb = profiles.getProfilesDb();
		var dashboardView = pageInfo.profilesDashboardView;
//		util.showObject(dashboardView, 'createDashboardData() - dashboardView');
//		var showDatabaseInfo = dashboardView.show_database_info;
		var showDatabaseInfo = pageInfo.permissions.isViewDatabaseInfoColumn && pageInfo.showDatabaseInfoColumn;
//		console.log('showDatabaseInfo: ' + showDatabaseInfo);
		var columns = dashboardView.columns;
		var numColumns = columns.length;
		if (showDatabaseInfo || numColumns > 0) {
			// Handle basic data
			for (var i = 0, len = profilesDb.length; i < len; i++) {
				var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);
				var profileName = profileItem.name;
				var obj = {name:profileName};
				// Check if the profile has permission to view dashboard data.
				if (!isRootAdmin) {
					var profileGrants = profilesUtil.getProfileGrants(profileName);
//					util.showObject(profileGrants);
					isViewDashboardPermission = profileGrants.viewProfilesDashboard;
					isViewDatabaseInfoPermission = profileGrants.viewDatabaseInfoColumn;
				}
				obj.viewDashboard = isViewDashboardPermission;
				obj.viewDatabaseInfo = isViewDatabaseInfoPermission;
				// Always set/get database info because it is required for
				// report generation anyway. So the database info becomes
				// automatically loaded when one or more report columns
				// are shown.
				obj.dbInfo = [false, '', ''];
				// Handle report fields defined in columns
				// which are valid for all rows, unless overridden per profile.
				// Handle columns where report_field is defined
				// in column header, respectively set default
				// columns object.
				if (numColumns > 0) {
					_setDefaultReportCells(columns, numColumns, obj);
				}
				dashboardData[i] = obj;
				// Create lookup by profile name
				var lookupName = '_' + profileName;
				dashboardData[lookupName] = dashboardData[i];
			}
			// Handle individual profile cells
			_setDefaultProfileReportCells(columns, numColumns);
		}
//		util.showObject(dashboardData, 'dashboardData');
	}
	function _setDefaultReportCells(columns, numColumns, obj) {
		// Sets default columns in obj.
		var reportCellsCode = 0; // Default 0=ignore columns
		var reportCells = [];
		for (var i = 0; i < numColumns; i++) {
			var colItem = columns[i];
			// console.log('colItem.expression: ' + colItem.expression);
			if (obj.viewDashboard && colItem.report_field !== '') {
				reportCells[i] = [true, '', ''];
				// Set reportCellsCode to "1 = has or possibly has report cells"
				// (this applies to all cells in row)
				reportCellsCode = 1;
			}
			else {
				reportCells[i] = [false];
			}
		}
		obj.reportCellsCode = reportCellsCode;
		obj.reportCells = reportCells;
	}
	function _setDefaultProfileReportCells(columns, numColumns) {
		// This sets individual profile rows which are defined
		// in dashboardView.columns[i].profiles.
		// Individual profile columns are only loaded if the user has
		// permission. So we don't need to check for permissions here.
//		util.showObject(columns, '_setDefaultProfileReportCells / num of columns: ' + numColumns);
		for (var i = 0; i < numColumns; i++) {
			var colItem = columns[i];
			var colItemProfiles = colItem.profiles;
//			util.showObject(colItemProfiles, 'colItemProfiles');
			for (var k = 0, len = colItemProfiles.length; k < len; k++) {
				var cellItem = colItemProfiles[k];
//				util.showObject(cellItem, 'cellItem');
//				console.log('dashboardItem.reportCellsCode: ' + dashboardItem.reportCellsCode);
				if (cellItem.report_field !== '') {
					var profileName = cellItem.profile_name;
					var dashboardItem = dashboardData[('_' + profileName)];
//					util.showObject(dashboardItem, 'dashboardItem');
					// Set reportCellsCode "1 = has or possibly has report cells"
					// (applies global to all columns in row)
					dashboardItem.reportCellsCode = 1;
					// Set showCell=true
					dashboardItem.reportCells[i] = [true, '', ''];
				}
			}
		}
	}
	function getDashboardDataRef() {
		return dashboardData;
	}
	function getDashboardItemDbState(profileName) {
		var dbInfo = dashboardData['_' + profileName].dbInfo;
		return dbInfo[1];
	}
	function updateDashboardItemDbState(profileName, dbState, dbLastMod, dbOperationCompleted) {
		// This changes the database state. It is called when receiving database
		// info or when updating/building the database.
		var dashboardItem = dashboardData['_' + profileName];
//		util.showObject({dbOperationCompleted:dbOperationCompleted});
//		util.showObject(dashboardItem);
		var dbInfo = dashboardItem.dbInfo;
		dbInfo[1] = dbState;
		dbInfo[2] = dbLastMod;
		// Update profiles row
		profilesList.updateDbInfoCell(profileName, dbState, dbLastMod);
		// Update or Build database completed, update report data, if any.
		if (dbOperationCompleted && dashboardItem.hasOwnProperty('reportCellsCode')) {
			var reportCellsCode = dashboardItem.reportCellsCode;
			// reportCellsCode could be 0 because no database has been built,
			// so we need to ignore reportCellsCode!
//			if (reportCellsCode !== 0) {
				// Update profiles row
//				profilesList.setReportCellsToChangedDataState(profileName);
			// Reset reportCells to 1
			dashboardItem.reportCellsCode = 1;
			_verifyDashboardDataForProfilesInViewFinal();
		}
	}
	function verifyDashboardDataForProfilesInView(profilesInView) {
		// This checks if all dashboard data exist for the current
		// visible profiles. If all data exist then no further action
		// is required, else the missing data are loaded and the
		// profilesList becomes updated.
		// Keep a reference to profilesInView
		profilesInViewRef = profilesInView;
		_verifyDashboardDataForProfilesInViewFinal();
	}
	function _verifyDashboardDataForProfilesInViewFinal() {
		// This checks if all dashboard data exist and are up to date
		// for the current visible profiles.
		// If all data exist and if they are up to date then no further
		// action is required, else the missing data are loaded and the
		// profilesList becomes updated.
//		var dashboardView = pageInfo.profilesDashboardView;
//		console.log('_verifyDashboardDataForProfilesInViewFinal()')
//		util.showObject(dashboardView);
//		util.showObject(profilesInViewRef, 'profilesInViewRef');
//		util.showObject(dashboardData, 'dashboardData');
		// var showDatabaseInfo = dashboardView.show_database_info;
		var showDatabaseInfo = pageInfo.permissions.isViewDatabaseInfoColumn && pageInfo.showDatabaseInfoColumn;
//		console.log('showDatabaseInfo 2: ' + showDatabaseInfo);
		var profilesDat = '';
		// It is possible that there are no dashboardData
		if (dashboardData.length > 0) {
			for (var i = 0, len = profilesInViewRef.length; i < len; i++) {
				var profileName = profilesInViewRef[i];
				var dashboardItem = dashboardData[('_' + profileName)];
//				util.showObject(dashboardItem);
				// If view permission
				if (dashboardItem.viewDashboard || dashboardItem.viewDatabaseInfo) {
					var dbInfo = dashboardItem.dbInfo;
					var dbInfoLoaded = dbInfo[0];
					var dbIsBuilding = (dbInfoLoaded && dbInfo[1] === 1);
					var reportCellsCode = dashboardItem.reportCellsCode;
					var isPossibleReportData = (reportCellsCode === 1);
					var waitingForReportData = (reportCellsCode === 2);
					var requiresDbInfo = (
						(dashboardItem.viewDatabaseInfo && showDatabaseInfo && !dbInfoLoaded) ||
						dbIsBuilding ||
						isPossibleReportData);
					if (requiresDbInfo || isPossibleReportData || waitingForReportData) {
						var path = '&v.fp.profiles.' + profileName;
						profilesDat += path + '.requires_db_info=' + requiresDbInfo;
						profilesDat += path + '.is_possible_report_data=' + isPossibleReportData;
						profilesDat += path + '.waiting_for_report_data=' + waitingForReportData;
					}
				}
			}
		}
		if (profilesDat !== '') {
			_getDashboardData(profilesDat);
		}
	}
	function _getIsLoadDashboardItemData(showDatabaseInfo, dashboardItem) {
		// Returns true if data for dashboardItem needs to be loaded.
		if ((showDatabaseInfo && !dashboardItem.dbInfo[0]) ||
			(dashboardItem.reportCellsCode === 1) ||
			dashboardItem.reportCellsCode === 2) {
			return true;
		}
		return false;
	}
	function _getDashboardData(profilesDat) {
		// Load dashboard data
		var url = '?dp=admin_pages.profiles_dashboard.get_dashboard_data';
		var dat = 'v.fp.active_page=' + pageInfo.page;
		dat += '&v.fp.page_token=' + pageInfo.pageToken;
		dat += profilesDat;
		util.serverPost(url, dat);
	}
	function getDashboardDataResponse(dat) {
		// Update dashboardData
//		util.showObject(dat, 'getDashboardDataResponse()');
		var dashboardView = pageInfo.profilesDashboardView;
//		util.showObject(dashboardView, 'dashboardView');
		var numColumns = dashboardView.columns.length;
		var isProcessing = false;
		// Create defaultReportCells
		var defaultReportCells = [];
		for (var k = 0; k < numColumns; k++) {
			defaultReportCells[k] = [false];
		}
		for (var i = 0, len = dat.length; i < len; i++) {
			var datItem = dat[i];
			var profileName = datItem.name;
			var dbBuilt = datItem.dbBuilt;
			var dbBuilding = datItem.dbBuilding;
			var dbLastMod = datItem.dbLastMod;
			var dbState = 0;
			if (dbBuilding) {
				dbState = 1;
				isProcessing = true;
			}
			else if (dbBuilt) {
				dbState = 2;
			}
			// var newReportCells = [];
			var dashboardItem = dashboardData['_' + profileName];
			var dbInfo = dashboardItem.dbInfo;
			dbInfo[0] = true; // isLoaded
			dbInfo[1] = dbState;
			dbInfo[2] = dbLastMod;
			// Set reportCells
//			console.log('profileName: ' + profileName);
//			console.log('reportCellsCode: ' + reportCellsCode);
			if (numColumns > 0) {
				var reportState = datItem.reportState;
				var reportCells = datItem.reportCells;
				if (reportState === 'ignore') {
					dashboardItem.reportCellsCode = 0;
					dashboardItem.reportCells = util.cloneObject(defaultReportCells);
				}
				else if (reportState === 'update') {
					// Report has been requested, labels are available, if any.
					dashboardItem.reportCellsCode = 2;
					dashboardItem.reportCells = util.cloneObject(reportCells);
					isProcessing = true;
				}
				else if (reportState === 'ready') {
					dashboardItem.reportCellsCode = 3;
					dashboardItem.reportCells = util.cloneObject(reportCells);
				}
				else {
					// reportState === 'unchanged'
					// Report is not yet ready
					isProcessing = true;
				}
			}
		}
		// Update the profilesList if not in edit mode
		if (!profiles.getIsEditViewActive()) {
			profiles.profilesDashboardDataUpdated();
			if (isProcessing) {
				// Re-check dashboard data
				setTimeout(function() {_verifyDashboardDataForProfilesInViewFinal()}, 1000);
			}
		}
	}
	// Public methods
	return {
		createDashboardData: createDashboardData,
		getDashboardDataRef: getDashboardDataRef,
		getDashboardItemDbState: getDashboardItemDbState,
		verifyDashboardDataForProfilesInView: verifyDashboardDataForProfilesInView,
		getDashboardDataResponse: getDashboardDataResponse,
		updateDashboardItemDbState: updateDashboardItemDbState
	};
}());
/* global
	profiles: false
	 profilesStorage: false */
var profilesDashboardEditor = (function() {
	'use strict';
	// This is the profiles view editor
	var YE = YAHOO.util.Event;
//	var busyPanel = null;
	var containerEl = null;
	// profilesDb is a reference to profiles.profilesDb, this contains all profiles
	var profilesDb = [];
	// activeProfilesDb is used to create the list, it may contain all profiles
	// or a filter result from profilesFilter.
	var activeProfilesDb = [];
	// dashboardView is a clone of pageInfo.profilesDashboardView
	var dashboardView = {};
	var idPrefix = '';
	var isDateFilter = false;
	var confirmDeletePanel = null;
	var defaultColumn = {
			profile_name: '',
			show_column_label: true,
			column_label: langVar('lang_admin.profiles.new_column'),
			show_cell_labels: false,
			cell_label: '',
			report_field: '',
			// raw_report_field_label contains the language variable, not expanded
			raw_report_field_label: '',
			// The expanded label, this not saved to server
			report_field_label: '',
//			expression: '',
//			date_filter: '',
			profiles: []
		};
	var indexOfColumnToDelete = -1;
	var isRootAdmin = false;
	var isEditAllProfilesGrants = false;
	function init() {
		// Set permissions/grants. If this is not the root admin and if the user
		// has not edit permission for all profiles then we limit editing
		// to granted profiles only. In this case the user cannot add/delete columns
		// nor edit the column headers.
		isRootAdmin = pageInfo.isRootAdmin;
		if (!isRootAdmin) {
			var allProfilesGrants = pageInfo.userGrants.allProfilesGrants;
			isEditAllProfilesGrants = allProfilesGrants.editProfilesDashboard;
		}
		profilesDb = profiles.getProfilesDb();
		idPrefix = util.getUniqueElementId();
		var confirmDeletePanelObj = {
			panelId: 'delete_column:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.delete_column'),
			left: 100,
			top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: cancelDeleteColumn
		};
		if (isRootAdmin || isEditAllProfilesGrants) {
			YE.addListener('delete_column:yes_btn', 'click', deleteColumn);
			YE.addListener('delete_column:no_btn', 'click', cancelDeleteColumn);
		}
		// Enable/disable Show database info and date filter
//		util.enableE('profiles:show_database_info', isRootAdmin || isEditAllProfilesGrants);
		util.enableE('profiles:date_filter', isRootAdmin || isEditAllProfilesGrants);
		confirmDeletePanel = new util.Panel3(confirmDeletePanelObj);
		containerEl = util.getE('profiles:edit_profiles_view_list');
//		YE.addListener('profiles:toggle_date_filter_btn', 'click', toggleDateFilter);
		YE.addListener('profiles:edit_profiles_view:cancel_btn', 'click', cancelProfilesView);
		YE.addListener('profiles:edit_profiles_view:save_btn', 'click', saveProfilesDashboard);
		YE.addListener('profiles:edit_profiles_view_list', 'click', cellItemClicked);
		// Init profilesViewUtil
		profilesDashboardEditorUtil.init(profilesDb);
	}
	function create(theActiveProfilesDb) {
		activeProfilesDb = theActiveProfilesDb;
		// Clone pageInfo.profilesDashboardView, so that it remains intact.
		dashboardView = util.cloneObject(pageInfo.profilesDashboardView);
		if (containerEl === null) {
			init();
		}
		var columns = dashboardView.columns;
		var numColumns = columns.length;
		if (numColumns === 0) {
			columns[0] = util.cloneObject(defaultColumn);
		}
//		util.showObject(activeProfilesDb);
		createView();
//		util.setF('profiles:show_database_info', dashboardView.show_database_info);
		util.setF('profiles:date_filter', dashboardView.date_filter);
		util.showE('profiles:edit_profiles_view');
	}
	function update(theActiveProfilesDb) {
		// This is called from dashboardView when the profiles become filtered.
		// Replace current dashboardView.
		activeProfilesDb = theActiveProfilesDb;
		createView();
	}
	function cancelProfilesView() {
		util.hideE('profiles:edit_profiles_view');
		var isCancel = true;
		profiles.editViewClosed(isCancel);
	}
	function getColProfilesDat(colPath, colProfiles) {
		var colProfilesDat = '';
		var numProfiles = colProfiles.length;
		if (numProfiles > 0) {
			for (var i = 0; i < numProfiles; i++) {
				var cellItem = colProfiles[i];
				var profileName = cellItem.profile_name;
//				util.showObject(cellItem, 'cellItem');
				var path = colPath + '.profiles.' + profileName;
				colProfilesDat += path + '.profile_name=' + profileName;
				colProfilesDat += path + '.show_label=' + cellItem.show_label;
				colProfilesDat += path + '.label=' + encodeURIComponent(cellItem.label);
				colProfilesDat += path + '.report_field=' + cellItem.report_field;
				// Save raw_report_field_label to report_field_label!
				colProfilesDat += path + '.report_field_label=' + encodeURIComponent(cellItem.raw_report_field_label);
//				colProfilesDat += path + '.expression=' + encodeURIComponent(cellItem.expression);
//				colProfilesDat += path + '.date_filter=' + encodeURIComponent(cellItem.date_filter);
			}
		}
		else {
			colProfilesDat = colPath + '.profiles=';
		}
		return colProfilesDat;
	}
	function saveProfilesDashboard() {
		util.hideE('profiles:edit_profiles_view');
//		util.showObject(dashboardView);
//		var showDatabaseInfo = util.getF('profiles:show_database_info');
		var dateFilter = util.getF('profiles:date_filter');
//		dashboardView.show_database_info = showDatabaseInfo;
		dashboardView.date_filter = dateFilter;
		var columns = dashboardView.columns;
		var columnsDat = '';
		for (var i = 0, len = columns.length; i < len; i++) {
			var colItem = columns[i];
			var colPath = '&v.fp.profiles_dashboard.columns.' + i;
			columnsDat += colPath + '.profile_name=' + colItem.profile_name;
			columnsDat += colPath + '.show_column_label=' + colItem.show_column_label;
			columnsDat += colPath + '.column_label=' + encodeURIComponent(colItem.column_label);
			columnsDat += colPath + '.show_cell_labels=' + colItem.show_cell_labels;
			columnsDat += colPath + '.cell_label=' + encodeURIComponent(colItem.cell_label);
			columnsDat += colPath + '.report_field=' + colItem.report_field;
			// Save raw_report_field_label to report_field_label!
			columnsDat += colPath + '.report_field_label=' + encodeURIComponent(colItem.raw_report_field_label);
//			columnsDat += colPath + '.expression=' + encodeURIComponent(colItem.expression);
//			columnsDat += colPath + '.date_filter=' + encodeURIComponent(colItem.date_filter);
			columnsDat += getColProfilesDat(colPath, colItem.profiles);
		}
		var url = '?dp=admin_pages.profiles_dashboard.save_profiles_dashboard';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
//		dat += '&v.fp.profiles_dashboard.show_database_info=' + showDatabaseInfo;
		dat += '&v.fp.profiles_dashboard.date_filter=' + dateFilter;
		dat += '&v.fp.profiles_dashboard.columns=' + columnsDat;
		util.serverPost(url, dat);
	}
	function saveProfilesDashboardResponse() {
		// Set profilesDashboardView in pageInfo to saved dashboardView
		pageInfo.profilesDashboardView = util.cloneObject(dashboardView);
		var isCancel = false;
		profiles.editViewClosed(isCancel);
	}
//	function toggleDateFilter(evt) {
//
//		var dateFilterBox = util.getE('profiles:date_filter:box');
//		dateFilterBox.style.display = isDateFilter ? 'none' : 'inline';
//		isDateFilter = !isDateFilter;
//	}
	function cellItemClicked(evt) {
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
//		alert('cellItemClicked(): ' + elementId);
		var pattern = /:(add_col|edit_col|delete_col|edit_cell)/;
		if (pattern.test(elementId)) {
			var dat = elementId.split(':');
			var directive = dat[1];
			var colIndex = parseInt(dat[2], 10);
			switch (directive) {
			case 'add_col':
				addColumn(colIndex);
				break;
			case 'edit_col':
				profilesDashboardEditorUtil.editColumn(colIndex, dashboardView.columns[colIndex]);
				break;
			case 'delete_col':
				confirmDeleteColumn(colIndex);
				break;
			case 'edit_cell':
				// Get profile name from tr element Id
				var trElement = element.parentNode;
				// Make sure we get the TR element
				while (trElement.nodeName !== 'TR') {
					trElement = trElement.parentNode;
				}
				var trDat = trElement.id.split(':');
				var profileName = trDat[2];
//				alert('profileName: ' + profileName);
				profilesDashboardEditorUtil.editCell(colIndex, dashboardView.columns[colIndex], profileName);
				break;
			}
		}
	}
	function addColumn(colIndex) {
		dashboardView.columns[colIndex] = util.cloneObject(defaultColumn);
		createView();
	}
	function confirmDeleteColumn(colIndex) {
		indexOfColumnToDelete = colIndex;
		confirmDeletePanel.prePositionAtCenter();
		confirmDeletePanel.open();
	}
	function deleteColumn() {
		dashboardView.columns.splice(indexOfColumnToDelete, 1);
		createView();
		confirmDeletePanel.close();
	}
	function cancelDeleteColumn() {
		confirmDeletePanel.close();
	}
	function saveHeaderCell(colIndex, newColObj) {
		// Override column with newColObj
		var column = dashboardView.columns[colIndex];
		for (var prop in newColObj) {
			column[prop] = newColObj[prop];
		}
//		util.showObject(dashboardView);
	}
	function saveCell(colIndex, newCellObj, profileName) {
		var colProfiles = dashboardView.columns[colIndex].profiles;
		// Remove existing cell with given profileName
		for (var i = 0, len = colProfiles.length; i < len; i++) {
			var cellItem = colProfiles[i];
			if (cellItem.profile_name === profileName) {
				// Remove the cellItem
				colProfiles.splice(i, 1);
				break;
			}
		}
//		util.showObject(newCellObj, 'newCellObj');
		// Add newCellObj if a report_field is defined
		if (newCellObj.report_field !== '') {
			// colProfiles[colProfiles.length] = util.cloneObject(newCellObj);
			colProfiles[colProfiles.length] = newCellObj;
		}
//		util.showObject(dashboardView, 'saved the cell');
	}
	//
	// Create the view
	//
	function createView() {
		// Clear existing view
//		util.removeChildElements(containerEl);
		var columns = dashboardView.columns;
		var numColumns = columns.length;
//		util.showObject(dashboardView);
//		util.showObject(profilesDb);
		var table = '<table class="edit-profiles-view"><tbody>';
//		table += _getPreHeaderRow(columns, numColumns);
		table += _getHeaderRow(columns, numColumns);
		for (var i = 0, len = activeProfilesDb.length; i < len; i++) {
			var profileItem = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			var rowId = idPrefix + ':tr:' + profileItem.name;
			table += '<tr id="' + rowId + '">';
			table += '<td class="profile">' + profileItem.label + '</td>';
			// Add the columns
			table += _getColumns(profileItem.name, columns, numColumns);
			table += '</tr>';
		}
		table += '</tbody></table>';
		containerEl.innerHTML = table;
	}
	function _getPreHeaderRow(columns, numColumns) {
		// This returns the row with the delete buttons
		var row = '<tr>';
		row += '<th class="delete">&nbsp;</th>';
		// Create the column cells
		for (var i = 0; i < numColumns; i++) {
			var column = columns[i];
			var colText = (column.column_label !== '') ? column.column_label : '-';
			row += '<th class="delete">'
			if (isRootAdmin || isEditAllProfilesGrants) {
				row += '<a id="' + idPrefix + ':delete_col:' + i + '" class="link-90" href="javascript:;">' + langVar('lang_stats.btn.delete') + '</a> ';
			}
			row += '</th>';
		}
		row += '</tr>';
		return row;
	}
	function _getHeaderRow(columns, numColumns) {
		// This returns the main header row
//		util.showObject(columns);
		var row = '<tr>';
		row += '<th>';
		row += '<div class="delete">&nbsp;</div>';
		row += '<div class="profile">' + langVar('lang_stats.btn.profiles') + '</div>';
		row += '</th>';
		// Create the column cells
		for (var i = 0; i < numColumns; i++) {
			var column = columns[i];
			var colText = '';
			if (column.column_label !== '') {
				colText = column.column_label;
			}
			else if (column.report_field !== '' &&
					column.report_field_label !== '') {
				colText = column.report_field_label;
			}
			else {
				colText = '(' + langVar('lang_admin.profiles.column') + ' ' + (i + 1) + ')';
			}
			row += '<th>';
			// Delete
			row += '<div class="delete">';
				if (isRootAdmin || isEditAllProfilesGrants) {
					row += '<a id="' + idPrefix + ':delete_col:' + i + '" class="link-90" href="javascript:;">' + langVar('lang_stats.btn.delete') + '</a>';
				}
				else {
					row += '&nbsp;';
				}
			row += '</div>';
			// Label
			row += '<div>';
				if (isRootAdmin || isEditAllProfilesGrants) {
					row += '<a id="' + idPrefix + ':edit_col:' + i + '" class="link-90" href="javascript:;">' + colText + '</a>';
				}
				else {
					row += colText;
				}
			row += '</div>';
			row += '</th>';
		}
		// Create Add Column cell
		row += '<th>';
		if (isRootAdmin || isEditAllProfilesGrants) {
			row += '<div class="delete">&nbsp;</div>';
			row += '<div class="add"><a id="' + idPrefix + ':add_col:' + numColumns + '" class="link-90" href="javascript:;">+ ' + langVar('lang_admin.profiles.add_column') + '</a></div>';
		}
		row += '</th>';
		row += '</tr>';
		return row;
	}
	function _getColumns(profileName, columns, numColumns) {
		var colHTML = '';
		var isEditGrants = isRootAdmin || isEditAllProfilesGrants;
		if (!isEditGrants) {
			// Check if this profile has edit grants
			var theProfileGrants = profilesUtil.getProfileGrants(profileName);
			isEditGrants = theProfileGrants.editProfilesDashboard;
		}
		for (var i = 0; i < numColumns; i++) {
			var id = idPrefix + ':edit_cell:' + i;
			var column = columns[i];
			// Check if this profile has specific cell settings
			var cellItem = _getProfileCellItem(profileName, column);
			var className = '';
			var anchorClassName = '';
//			var reportFieldLabel = '';
			var text = ' ';
			if (cellItem !== null) {
				// Specific report field for profile defined.
//				util.showObject(cellItem, 'cellItem');
//				reportFieldLabel = cellItem.report_field_label;
				className = 'cell-def';
				anchorClassName = 'link-90';
				text = (cellItem.label !== '') ? cellItem.label : cellItem.report_field_label;
			}
			else if (column.report_field !== '') {
				// Report field defined in column header
				className = 'col-def';
				anchorClassName = 'link-90';
				if (column.cell_label !== '') {
					text = '(' + column.cell_label + ')';
				}
				else {
					text = '(' + column.report_field_label + ')';
				}
			}
			else {
				className = 'not-def';
				anchorClassName = 'link-90-lite';
				text = '(' + langVar('lang_stats.btn.none') + ')';
			}
			colHTML += '<td class="' + className + '">';
			if (isEditGrants) {
				colHTML += '<a id="' + id + '" class="' + anchorClassName + '" href="javascript:;">' + text + '</a>';
			}
			else {
				colHTML += text;
			}
			colHTML += '</td>';
		}
		return colHTML;
	}
	function _getProfileCellItem(profileName, column) {
		var profileCellItem = null;
		var profiles = column.profiles;
		for (var i = 0, len = profiles.length; i < len; i++) {
			if (profiles[i].profile_name === profileName) {
				profileCellItem = profiles[i];
				break;
			}
		}
		return profileCellItem;
	}
	// Return global properties and methods
	return {
		create: create,
		update: update,
		createView: createView,
		cellItemClicked: cellItemClicked,
		deleteColumn: deleteColumn,
		cancelDeleteColumn: cancelDeleteColumn,
		saveHeaderCell: saveHeaderCell,
		saveCell: saveCell,
		saveProfilesDashboardResponse: saveProfilesDashboardResponse
	};
}());
/* global
	profilesDashboardEditor: false */
var profilesDashboardEditorUtil = (function() {
	'use strict';
	// This are profiles view editor utilities.
	var YE = YAHOO.util.Event;
	var editPanel = null;
	var isHeaderCell = false;
	var activeColIndex = 0;
	var reportFieldsByProfile = {}; // Note, this contains aggregating report fields only!
	var activeProfileName = '';
	function init(profilesDb) {
		var panelObj = {
			panelId: 'edit_cell:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			zIndex: 30,
			isCover: true,
			closeEvent: _closeEditCell
		};
		editPanel = new util.Panel3(panelObj);
		// Populate profiles list
		var a = [{name:'', label:'(None)'}];
		for (var i = 0, len = profilesDb.length; i < len; i++) {
			var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);
			a[i] = {name: profileItem.name, label: profileItem.label};
		}
		// Insert 1st list item
		a.splice(0, 0, {name:'', label:'(' + langVar('lang_stats.btn.none') + ')'});
		util.populateSelect('edit_cell:profiles_list', a, 'name', 'label');
		YE.addListener('edit_cell:cancel_btn', 'click', _closeEditCell);
		YE.addListener('edit_cell:ok_btn', 'click', _saveCell);
		YE.addListener('edit_cell:profiles_list', 'change', profileSelected);
		YE.addListener('edit_cell:show_column_label', 'click', _setShowColumnLabel);
		YE.addListener('edit_cell:show_cell_labels', 'click', _setShowCellLabels); // header cell
		YE.addListener('edit_cell:show_cell_label', 'click', _setShowCellLabel); // body cell
	}
	function editColumn(colIndex, colObj) {
//		alert('editColumn: ' + colIndex);
//		util.showObject(colObj);
		// activeProfileName is the profile defined
		// in the cell header.
		activeProfileName = colObj.profile_name;
		isHeaderCell = true;
		activeColIndex = colIndex;
		_updateForm(colObj);
		editPanel.prePositionAtCenter();
		editPanel.open({label: langVar('lang_admin.profiles.edit_column')});
	}
	function editCell(colIndex, colObj, profileName) {
		// activeProfileName is the profile of the row.
		activeProfileName = profileName;
		isHeaderCell = false;
		activeColIndex = colIndex;
		_updateForm(colObj);
		editPanel.prePositionAtCenter();
		editPanel.open({label: langVar('lang_admin.profiles.edit_cell')});
	}
	function _updateForm(colObj) {
//		util.showObject(colObj);
		if (isHeaderCell) {
			util.setF('edit_cell:profiles_list', activeProfileName);
			_handleReportFieldsList(activeProfileName, colObj.report_field);
			var showColumnLabel = colObj.show_column_label;
			var showCellLabels = colObj.show_cell_labels;
			util.setF('edit_cell:show_column_label', showColumnLabel);
			util.setF('edit_cell:show_cell_labels', showCellLabels);
			util.setF('edit_cell:column_label', colObj.column_label);
			util.setF('edit_cell:cell_label', colObj.cell_label);
			util.showE('edit_cell:column_label:section', showColumnLabel);
			util.showE('edit_cell:cell_label_section', showCellLabels);
		}
		else {
			var profileCellItem = _getProfileCellItem(colObj);
			_handleReportFieldsList(activeProfileName, profileCellItem.report_field);
			var showLabel = profileCellItem.show_label;
			util.setF('edit_cell:show_cell_label', showLabel);
			util.showE('edit_cell:cell_label_section', showLabel);
			util.setF('edit_cell:cell_label', profileCellItem.label);
		}
		util.showE('edit_cell:profiles_list_section', isHeaderCell);
		util.showE('edit_cell:header_cell_section', isHeaderCell);
		util.showE('edit_cell:cell_section', !isHeaderCell);
	}
	function profileSelected(evt) {
		var profileName = util.getF('edit_cell:profiles_list');
		activeProfileName = profileName;
		var selectedReportField = '';
		_handleReportFieldsList(profileName, selectedReportField);
	}
	function _setShowColumnLabel() {
		util.showE('edit_cell:column_label:section', this.checked);
	}
	function _setShowCellLabels() {
		util.showE('edit_cell:cell_label_section', this.checked);
	}
	function _setShowCellLabel() {
		util.showE('edit_cell:cell_label_section', this.checked);
	}
	function _handleReportFieldsList(profileName, selectedReportField) {
		// Reset report fields list
		util.populateSelect('edit_cell:report_field_list', [{name:'', label:'(' + langVar('lang_stats.btn.none') + ')'}], 'name', 'label');
		var makeEnabled = false;
		if (profileName !== '') {
			if (reportFieldsByProfile.hasOwnProperty('_' + profileName)) {
				makeEnabled = true;
				_updateReportFieldsList(profileName, selectedReportField);
			}
			else {
				// Load report fields
				var url = '?dp=admin_pages.profiles_dashboard.get_report_fields_data';
				var dat = 'v.fp.page_token=' + pageInfo.pageToken;
				dat += '&v.fp.profile_name=' + profileName;
				dat += '&v.fp.selected_report_field=' + selectedReportField;
				util.serverPost(url, dat);
			}
		}
		util.enableE('edit_cell:report_field_list', makeEnabled);
	}
	function handleReportFieldsListResponse(dat) {
		function compareLabels(a, b) {
			var labelA = a.label.toLowerCase();
			var labelB = b.label.toLowerCase();
			if (labelA < labelB) {
				return -1;
			}
			else if (labelA > labelB) {
				return 1;
			}
			return 0;
		}
		var reportFieldsDb = dat.report_fields_db;
		reportFieldsDb.sort(compareLabels);
		var profileName = dat.profile_name;
		var selectedReportField = dat.selected_report_field;
		reportFieldsByProfile['_' + profileName] = reportFieldsDb;
		// Update list if profile is still selected/active
		if (activeProfileName === profileName) {
			_updateReportFieldsList(profileName, selectedReportField);
		}
	}
	function _updateReportFieldsList(profileName, selectedReportField) {
		// This assumes that reportFields are already loaded and that
		// the first list entry (None) already exists.
		var reportFields = reportFieldsByProfile['_' + profileName];
		util.extendSelect('edit_cell:report_field_list', reportFields, 'name', 'label');
		util.enableE('edit_cell:report_field_list');
		util.setF('edit_cell:report_field_list', selectedReportField);
	}
	function _closeEditCell() {
		editPanel.close();
	}
	function _saveCell() {
		// This saves column and cell changes
		if (isHeaderCell) {
			_saveHeaderCell();
		}
		else {
			_saveSimpleCell();
		}
		// Rebuild profilesView
		profilesDashboardEditor.createView();
		_closeEditCell();
	}
	function _saveHeaderCell() {
		// This saves column and cell changes
		var reportField = util.getF('edit_cell:report_field_list');
		// Ignore profile_name if no report field has been selected
		var profileName = (reportField !== '') ? util.getF('edit_cell:profiles_list') : '';
		var reportFieldLabels = _getReportFieldLabels(profileName, reportField);
		var showColumnLabel = util.getF('edit_cell:show_column_label');
		var columnLabel = '';
		if (showColumnLabel) {
			columnLabel = util.getF('edit_cell:column_label');
			// Reset showColumnLabel if no label exists
			if (reportField === '' && columnLabel === '') {
				showColumnLabel = false;
			}
		}
		// Ignore cell label if no report field per column is defined
		var showCellLabels = false;
		var cellLabel = '';
		if (reportField !== '') {
			showCellLabels = util.getF('edit_cell:show_cell_labels');
			if (showCellLabels) {
				cellLabel = util.getF('edit_cell:cell_label');
			}
		}
		var obj = {
			profile_name: profileName,
			report_field: reportField,
			raw_report_field_label: reportFieldLabels.rawLabel,
			report_field_label: reportFieldLabels.label,
			show_column_label: showColumnLabel,
			column_label: columnLabel,
			show_cell_labels: showCellLabels,
			cell_label: cellLabel
		};
		profilesDashboardEditor.saveHeaderCell(activeColIndex, obj);
	}
	function _saveSimpleCell() {
		// This saves cell changes of a specific profile
		var reportField = util.getF('edit_cell:report_field_list');
		var reportFieldLabels = _getReportFieldLabels(activeProfileName, reportField);
		var showLabel = util.getF('edit_cell:show_cell_label');
		var cellLabel = '';
		if (showLabel && reportField !== '') {
			cellLabel = util.getF('edit_cell:cell_label');
		}
		var obj = {
			profile_name: activeProfileName,
			report_field: reportField,
			raw_report_field_label: reportFieldLabels.rawLabel,
			report_field_label: reportFieldLabels.label,
			show_label: showLabel,
			label: cellLabel
		};
		profilesDashboardEditor.saveCell(activeColIndex, obj, activeProfileName);
	}
	function _getProfileCellItem(colObj) {
		// Returns the cell object for activeProfileName
		// if such a cell exists in the colObj.
		// Set default profileCellObj
		var profileCellObj = {
			profile_name: '',
			show_label: '',
			label: '',
			report_field: '',
//			expression: ''
		};
		// Check if activeProfileName exists in
		// colObj.profiles
		var profiles = colObj.profiles;
		for (var i = 0, len = profiles.length; i < len; i++) {
			var item = profiles[i];
			if (item.profile_name === activeProfileName) {
				// Override profileCellObj with actual profile cell data
				for (var prop in item) {
					profileCellObj[prop] = item[prop];
				}
				break;
			}
		}
		return profileCellObj;
	}
	function _getReportFieldLabels(profileName, reportFieldName) {
		// Returns the report field raw label and label
		var obj = {rawLabel:'', label:''};
		if (profileName !== '' && reportFieldName !== '') {
			var reportFields = reportFieldsByProfile['_' + profileName];
			var item = null;
			for (var i = 0, len = reportFields.length; i < len; i++) {
				item = reportFields[i];
				if (item.name === reportFieldName) {
					obj.rawLabel = item.rawLabel;
					obj.label = item.label;
					break;
				}
			}
		}
		return obj;
	}
	// Return global properties and methods
	return {
		init: init,
		editColumn: editColumn,
		editCell: editCell,
//		closeEditCell: closeEditCell,
//		saveCell: saveCell,
		handleReportFieldsListResponse: handleReportFieldsListResponse
//		setShowColumnLabel: setShowColumnLabel
	};
}());
/* global
	profiles: false
	profilesStorage: false
	profilesDashboard: false
*/
var profilesList = (function() {
	'use strict';
	// This handles the profiles list creation.
	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		isRootAdmin = false,
		isViewDashboardPermission = false,
//		isEditProfilesDashboard = false,
		isAdminLike = false,
		activeProfilesDb = [], // Reference to all permitted profiles or filtered profilesDb
		numActiveProfiles = 0,
		dashboardView = null,
		dashboardColumns = [],
		numDashboardColumns = 0,
		dashboardData = [],
		showDbInfo = false,
		showCreatedBy = false,
		// dateTime is used to calculate last updated time ago
		dateTime = 0,
		v7ProfilesListContainer = null,
		profilesListContainer = null,
		isUnloadedDashboardData = false,
		count = 0;
	function init() {
		var permissions = pageInfo.permissions;
		isRootAdmin = pageInfo.isRootAdmin;
		isViewDashboardPermission = (isRootAdmin || permissions.isViewProfilesDashboard || permissions.isViewDatabaseInfoColumn);
		isAdminLike = (isRootAdmin || permissions.isAdd || pageInfo.permissions.isDelete);
//		console.log('isViewDashboardPermission: ' + isViewDashboardPermission);
//		console.log('isAdminLike: ' + isAdminLike);
		v7ProfilesListContainer = util.getE('profiles:v7_profiles_list');
		profilesListContainer = util.getE('profiles_profiles_list');
//		YE.delegate(profilesListContainer, 'mouseover', function(evt, matchedElement, container) {
//			console.log('mouseover: ' + this.nodeName);
//
//		}, 'td');
//
//		YE.delegate(profilesListContainer, 'mouseout', function(evt, matchedElement, container) {
//			console.log('mouseover: ' + this.nodeName);
//
//		}, 'td');
	}
	function clear() {
		// This clears the profile tables
//		util.removeChildElements(v7ProfilesListContainer);
//		util.removeChildElements(profilesListContainer);
		v7ProfilesListContainer.innerHTML = '';
		profilesListContainer.innerHTML = '';
	}
	function create(theProfiles) {
		// This creates a new profiles list, all profiles are assumed to be valid.
		// theProfiles could be all profiles or the profiles
		// from a search result.
//		console.log('theProfiles: ' + theProfiles);
		var isAddPermission = pageInfo.permissions.isAdd;
		// Reset
		isUnloadedDashboardData = false;
		count = 0;
		// Remove scroll listener in case that one has been assigned.
		YE.removeListener(window, 'scroll', _scrollActivated);
		activeProfilesDb = theProfiles;
		numActiveProfiles = activeProfilesDb.length;
		dashboardData = profilesDashboard.getDashboardDataRef();
		dashboardView = pageInfo.profilesDashboardView;
		dashboardColumns = dashboardView.columns;
		numDashboardColumns = dashboardColumns.length;
		showDbInfo = pageInfo.permissions.isViewDatabaseInfoColumn && pageInfo.showDatabaseInfoColumn;
//		console.log('showDbInfo: ' + showDbInfo);
		showCreatedBy = pageInfo.permissions.isViewCreatedByColumn && pageInfo.showCreatedByColumn;
		dateTime = showDbInfo ? (new Date().getTime() / 1000) : 0;
		var table = '<table class="profiles-list">';
		// Always show header row
		table += '<tbody>';
		table += _getHeaderRow();
		table += '</tbody>';
		table += '<tbody>';
		for (var i = 0; i < numActiveProfiles; i++) {
			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
//			util.showObject(item);
			table += _getRow(isAddPermission, i, item);
		}
		table += '</tbody></table>';
		profilesListContainer.innerHTML = table;
		// Handle unloaded dashboard data
		if (isViewDashboardPermission && isUnloadedDashboardData) {
			YE.addListener(window, 'scroll', _scrollActivated);
		}
	}
	function createWithInvalidProfiles(theProfiles) {
		// This creates a draft profiles list which contains
		// some or only invalid profiles. Invalid v7 profiles must
		// be deleted and invalid v8 profiles must be converted
		// before showing a final profiles list with View Reports
		// and Config links.
		activeProfilesDb = theProfiles;
		numActiveProfiles = activeProfilesDb.length;
		var v7Table = '<table class="profiles-list"><tbody>';
		var table = '<table class="profiles-list">';
//		table += '<tbody>';
//		table += _getHeaderRow();
//		table += '</tbody>';
		table += '<tbody>';
		for (var i = 0; i < numActiveProfiles; i++) {
			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
//			util.showObject(item);
			// If valid v8 profile without any invalid v8 profiles
			// This is not anymore valid because we don't know upfront
			// if an invalid profile exists or not.
//			if (item.isValidProfile && !invalidV80ProfilesExist) {
//
//				createListEntry(tbody, item);
//			}
			if (item.isValidProfile || item.version === '8.0') {
				// table += _getRow(isAddPermission, i, item);
				table += _getSimpleRow(item);
			}
			else {
				// This must be an invalid version 7.0 profile
				v7Table += _getSimpleRow(item);
			}
		}
		v7Table += '</tbody></table>';
		table += '</tbody></table>';
		v7ProfilesListContainer.innerHTML = v7Table;
		profilesListContainer.innerHTML = table;
	}
	function _getHeaderRow() {
		var row = '<tr>';
		// View Reports cell
//		row += '<th></th>';
		row += '<th class="profile">' + langVar('lang_stats.btn.profiles_reports') + '</th>';
		// Show Options label if user has access to options
		row += '<th class="options"></th>';
		// Add profiles view column labels
		for (var i = 0; i < numDashboardColumns; i++) {
			var colItem = dashboardColumns[i];
			var colLabel = '';
			if (colItem.show_column_label) {
				colLabel = (colItem.column_label !== '') ? colItem.column_label : colItem.report_field_label;
			}
			row += '<th class="rep">' + colLabel + '</th>';
		}
		if (showDbInfo) {
			row += '<th>' + langVar('lang_stats.btn.database_last_modified') + '</th>';
		}
		// Add created by
		if (showCreatedBy) {
			// Username is only shown for other users, hence we don't show a header label
			row += '<th>' + langVar('lang_stats.btn.created_by');
			row += ' <span class="lite">(' + langVar('lang_stats.general.empty_if_me') + ')</span>';
			row += '</th>';
		}
		row += '</tr>';
		return row;
	}
	function _getRow(isAddPermission, rowIndex, item) {
		var profileName = item.name;
		var rowClass= '';
		var theProfileGrants = profilesUtil.getProfileGrants(profileName);
		var row = '<tr id="tr:' + profileName + '"' + rowClass + '>';
		// Add profileLabel
		row += _getProfileLabelCell(theProfileGrants, item);
		// Add Options cell
		row += _getOptionsCell(isAddPermission, theProfileGrants, item);
		// Add dashboard report cells
		if (numDashboardColumns > 0) {
			row += _getDashboardReportCells(profileName);
		}
		// Add dashboard database info
		if (showDbInfo) {
			if (theProfileGrants.viewDatabaseInfoColumn) {
				// If permission
				row += _getDbInfoCell(profileName);
			}
			else {
				// Some or even all profiles may not have permission
				row += '<td class="db-info">(' + langVar('lang_stats.general.no_permission') + ')</td>';
			}
		}
		// Show user name if profile has been created
		// by other user.
		if (showCreatedBy) {
			row += '<td class="db-info">';
			if (theProfileGrants.viewCreatedByColumn) {
				if (item.username !== '') {
	//				var byUserLabel = ' (' + langVar('lang_admin.general.by_user') + ')';
	//				byUserLabel = byUserLabel.replace(/__PARAM__1/, item.username);
	//				row += byUserLabel;
					row += item.username;
				}
				else {
					// Created by myself
					row +=  '&nbsp;';
				}
			}
			else {
				// No permission
				row += '(' + langVar('lang_stats.general.no_permission') + ')';
			}
			'</td>';
		}
		row += '</tr>';
		return row;
	}
	function _getSimpleRow(item) {
		// This creates v7.0 or v8.x (unconverted and converted) rows.
		// They only contain profile name and a delete button.
		var profileName = item.name;
		var theProfileGrants = profilesUtil.getProfileGrants(profileName);
		var row = '<tr id="tr:' + profileName + '">';
		// Fallback to profile node name if label is empty
		var profileLabel = item.label;
		var pattern = /^\s+$/;
		if (profileLabel === '' || pattern.test(profileLabel)) {
			profileLabel = profileName;
		}
		// Add profileLabel
		row += '<td class="profile">' + profileLabel + '</td>';
		// Add state cell
		var info;
		if (item.isValidProfile) {
			info = langVar('lang_admin.profiles.valid_profile');
		}
		else if (item.version === '8.0') {
			info = langVar('lang_admin.profiles.version_80_or_81_profile');
		}
		else {
			info = langVar('lang_admin.profiles.version_7x_profile');
		}
		row += '<td class="info">' + info + '</td>';
		// add Delete link
		if (theProfileGrants.isDelete) {
			var anchorId = 'a:' + profileName + ':delete';
			row += '<td>';
			row += '<a id="' + anchorId + '" class="link-50" href="javascript:;">';
			row += '<span class="ico ico-16 ico-p-delete"></span> ';
			row += langVar('lang_stats.btn.delete');
			row += '</a>';
			row += '</td>';
		}
		else {
			row += '<td>&nbsp;</td>';
		}
		return row;
	}
	function _getDashboardReportCells(profileName) {
		var htmlCell = '';
		var reportCellsCode = dashboardData['_' + profileName].reportCellsCode;
		var reportCells = dashboardData['_' + profileName].reportCells;
//		util.showObject(reportCells);
		for (var i = 0; i < numDashboardColumns; i++) {
			var reportCellItem = reportCells[i];
			var showCell = reportCellItem[0];
			htmlCell += '<td class="rep">';
			if (showCell) {
				if (reportCellsCode === 1) {
					// Loading, this cell possibly has report data
					htmlCell += '<span class="rep">&ndash;</span>';
					isUnloadedDashboardData = true;
				}
				else {
					var label = reportCellItem[1];
					var value = (reportCellsCode === 3) ? reportCellItem[2] : '&ndash;';
					if (label !== '') {
						htmlCell += '<span class="rep">' + label + ':</span>';
					}
					htmlCell += value;
				}
			}
			else {
				// Ignore cell
				htmlCell += '&nbsp;';
			}
			htmlCell += '</td>';
		}
		return htmlCell;
	}
//	function _getDeleteCell(item) {
//
//		return _getIconLinkCell(imgDb.deleteProfile.src, item.name, 'delete', langVar('lang_admin.profiles.delete_profile') + ' "' + item.label + '"', langVar('lang_admin.profiles.delete_profile'));
//	}
	function _getProfileLabelCell(theProfileGrants, item) {
		var profileName = item.name;
		var profileLabel = item.label;
		var cell = '<td class="profile">';
		// Add the View Reports icon
//		cell += '<div class="profile">';
		if (theProfileGrants.isViewReports) {
			var href = '?dp=reports&p=' + profileName;
			var dateFilter = item.df;
			if (dateFilter !== '') {
				href += '&df=' + dateFilter;
			}
			cell += '<a href="' + href + '" class="profile">';
			cell += '<span class="ico ico-16 ico-p-reports" title="' + langVar('lang_stats.btn.view_reports') + '"></span> ';
			cell += '<span class="text">' + profileLabel + '</span>';
			cell += '</a>';
		}
		else {
			cell += '<span class="ico ico-16"></span> ';
			cell += profileLabel;
		}
		cell += '</td>';
		return cell;
	}
	function _getOptionsCell(isAddPermission, theProfileGrants, item) {
		var profileName = item.name;
		var cell = '<td class="options">';
		if (isAddPermission ||
			theProfileGrants.isViewConfig ||
			theProfileGrants.isViewTools ||
			theProfileGrants.isRename ||
			theProfileGrants.isDelete) {
			// Add more options link
			cell += ' <a id="a:' + profileName + ':menu" class="options" href="javascript:;">';
			cell += '<span class="ico ico-16 ico-p-gear"></span> ';
			cell += '<span class="text">' + langVar('lang_stats.btn.options') + '</span>';
			cell += '<span class="ico ico-16 ico-arrow-down-blue"></span> ';
			cell += '</a>';
		}
		cell += '</td>';
		return cell;
	}
//	function _getTextLinkCell(imgSrc, href, label) {
//
//		var cell = '<td>';
//		cell += '<a class="link-80" href="' + href + '">';
//		cell += '<img src="' + imgSrc + '" width="16" height="16" alt="' + label + '" />';
//		cell += '<span>' + label + '</span>';
//		cell += '</a>';
//		cell += '</td>';
//
//		return cell;
//	}
//	function _getIconLinkCell(imgSrc, profileName, operationKeyWord, title, alt) {
//
//		// operationKeyWord is: duplicate | rename | delete
//
//		var anchorId = 'a:' + profileName + ':' + operationKeyWord;
//		var imageId = 'img:' + profileName + ':' + operationKeyWord;
//
//		var cell = '<td>';
//		cell += '<a id="' + anchorId + '" class="link-50" href="#">';
//		cell += '<img id="' + imageId + '" src="' + imgSrc + '" width="16" height="16" title="' + title + '" alt="' + alt + '" />';
//		cell += '</a>';
//		cell += '</td>';
//
//		return cell;
//	}
//	function _getShowHeaderColumn() {
//
//		// Returns true if a column label must be shown
//		for (var i = 0; i < numDashboardColumns; i++) {
//
//			var colItem = dashboardColumns[i];
//			if (colItem.show_column_label) {
//				return true;
//			}
//		}
//
//		return false;
//	}
	function _getDbInfoCell(profileName) {
		var dbInfo = dashboardData['_' + profileName].dbInfo;
		var isLoaded = dbInfo[0];
//		util.showObject(dbInfo);
		var htmlCell = '<td class="db-info">';
		htmlCell += '<a id="a:' + profileName + ':db" href="javascript:;" class="link-80 link-80-lite">';
		if (isLoaded) {
			var dbState = dbInfo[1];
			var lastModifiedAgoInSec = 0;
			if (dbState === 2)  {
				var lastModifiedInEpoc = dbInfo[2];
				lastModifiedAgoInSec = dateTime - lastModifiedInEpoc;
			}
			htmlCell +=_getDbInfoCellSubElements(dbState, lastModifiedAgoInSec);
		}
		else {
			// Loading
			htmlCell += '<span class="ico ico-16 ico-p-db-loading">&nbsp;</span>';
			htmlCell += '<span>&ndash;</span>';
			isUnloadedDashboardData = true;
		}
		htmlCell += '</a>';
		htmlCell += '</td>';
		return htmlCell;
	}
	function updateDbInfoCell(profileName, dbState, lastModifiedInEpoc) {
		// This updates a single database info cell.
		var dbInfoAElement = util.getE('a:' + profileName + ':db');
		var now = new Date().getTime() / 1000;
		var lastModifiedAgoInSec = now - lastModifiedInEpoc;
		dbInfoAElement.innerHTML = _getDbInfoCellSubElements(dbState, lastModifiedAgoInSec);
	}
//	function setReportCellsToChangedDataState(profileName) {
//
//		// This changes report values to a dash. This is usually called
//		// after Update/Build database.
//		var tr = util.getE('tr:' + profileName);
//		// Replace existing cell values with ndash
//		var newText = document.createTextNode('Hello Karl');
//		var tableCells = tr.getElementsByTagName('td');
//		for (var i = 0, len = tableCells.length; i < len; i++) {
//			var td = tableCells[i];
//			if (td.className === 'rep') {
//				var oldText = td.firstChild;
//				td.replaceChild(newText, oldText);
//			}
//		}
//	}
	function _getDbInfoCellSubElements(dbState, lastModifiedAgoInSec) {
		var html = '';
		if (dbState === 2)  {
			// TODO - Refine lastModifiedAgo granularity
			var lastModifiedAgo = 0;
			if (lastModifiedAgoInSec >= 86400) {
				lastModifiedAgo = Math.round(lastModifiedAgoInSec / 86400);
				lastModifiedAgo += (lastModifiedAgo === 1) ? ' day' : ' days';
			}
			else if (lastModifiedAgoInSec >= 3600) {
				lastModifiedAgo = Math.round(lastModifiedAgoInSec / 3600);
				lastModifiedAgo += (lastModifiedAgo === 1) ? ' hour' : ' hours';
			}
			else if (lastModifiedAgoInSec >= 60) {
				lastModifiedAgo = Math.round(lastModifiedAgoInSec / 60);
				lastModifiedAgo += (lastModifiedAgo === 1) ? ' minute' : ' minutes'
			}
			else {
				lastModifiedAgo = '< 1 minute';
			}
			html = '<span class="ico ico-16 ico-p-db-built"></span>&nbsp;<span>' + lastModifiedAgo + ' ago</span>';
		}
		else if (dbState === 1)  {
			html = '<span class="ico ico-16 ico-p-db-loading"></span>&nbsp;<span>' + langVar('lang_stats.database.building') + '</span>';
		}
		else {
			// Not built
			html = '<span class="ico ico-16 ico-p-db-loading"></span>&nbsp;<span>' + langVar('lang_stats.database.not_built') + '</span>';
		}
		html += '<span class="ico ico-16 ico-arrow-down-grey"></span> ';
		return html;
	}
	function _scrollActivated(evt) {
//		console.log('scroll activated');
		// Increment count
		var newCount = count + 1;
		count = newCount;
		setTimeout(function() {_scrollingStopped(newCount);}, 500);
	}
	function _scrollingStopped(newCount) {
		// Check for dashboard data when user stopped scrolling
		if (count === newCount) {
//			util.showObject({count:count});
			_checkDashboardDataForCurrentView();
		}
	}
	function checkDashboardDataForCurrentView() {
		// Called from profiles but with a delay
		// Set some timeout to be sure that the table is displayed
		if (isViewDashboardPermission) {
			setTimeout(function() {_checkDashboardDataForCurrentView()}, 100);
		}
	}
	function _checkDashboardDataForCurrentView() {
		// Checks if profiles of current view require
		// to load dashboard data.
		// Don't check profiles list visibility
		// if there are less than 20 profiles.
//		var scrollTop = YD.getDocumentScrollTop();
//		util.showObject({scrollTop:scrollTop});
//		console.log('_checkDashboardDataForCurrentView()');
		// Set all profiles as default
		var profilesInView = [];
		var firstVisibleProfileIndex = 0;
		var lastVisibleProfileIndex = numActiveProfiles - 1;
		// TODO, revise numActiveProfiles
		if (numActiveProfiles > 30) {
			// clientRegion.top is equal scrollTop!
			var clientRegion = YD.getClientRegion();
//			util.showObject(clientRegion, 'clientRegion');
			var profilesListRegion = YD.getRegion(profilesListContainer);
//			util.showObject(profilesListRegion, 'profilesListRegion');
			var heightPerProfile =  Math.round(profilesListRegion.height / (numActiveProfiles + 1));
			//
			// get firstVisibleProfileIndex
			//
			if (clientRegion.top > profilesListRegion.top) {
				// First visible profile index is most likely greater than 0
				firstVisibleProfileIndex = _getFirstVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile);
				// Make sure we are within the index range
				if (firstVisibleProfileIndex < 0) {
					firstVisibleProfileIndex = 0
				}
				else if (firstVisibleProfileIndex >= numActiveProfiles) {
					firstVisibleProfileIndex = numActiveProfiles - 1;
				}
			}
			//
			// get lastVisibleProfileIndex
			//
			lastVisibleProfileIndex = _getLastVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile);
			// Make sure we are within the index range
			if (lastVisibleProfileIndex >= numActiveProfiles) {
				lastVisibleProfileIndex = numActiveProfiles - 1;
			}
			else if (lastVisibleProfileIndex < 0) {
				lastVisibleProfileIndex = 0;
			}
		}
		// Populate profilesInView
		for (var i = firstVisibleProfileIndex, k = 0; i <= lastVisibleProfileIndex; i++, k++) {
			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			profilesInView[k] = item.name;
		}
//		util.showObject({firstVisibleProfileIndex:firstVisibleProfileIndex});
//		util.showObject({lastVisibleProfileIndex:lastVisibleProfileIndex});
//		util.showObject(profilesInView, 'profilesInView');
//		console.log('profilesInView: ' + profilesInView);
		profilesDashboard.verifyDashboardDataForProfilesInView(profilesInView);
	}
	function _getFirstVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile) {
		// Get approximate hidden rows
		// hiddenHeightTop defines the height of invisible profile rows on top
		var hiddenHeightTop = clientRegion.top - profilesListRegion.top;
		var numHiddenRowsTop = 0;
		if (hiddenHeightTop > heightPerProfile) {
			numHiddenRowsTop = Math.round(hiddenHeightTop / heightPerProfile);
		}
//		util.showObject({numHiddenRowsTop: numHiddenRowsTop});
		// Check if the profile with index of numHiddenRowsTop
		// is actually hidden.
		var isVisible = true;
		var i = numHiddenRowsTop;
		while (isVisible && i >= 0) {
			i = i - 1;
			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			var rowId = 'tr:' + item.name;
			var rowRegion = YD.getRegion(rowId);
			// util.showObject(rowRegion, 'rowRegion');
			isVisible = rowRegion.bottom > clientRegion.top;
		}
		return i + 1;
	}
	function _getLastVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile) {
		// hiddenHeightBottom defines the height of invisible profiles on bottom
		var hiddenHeightBottom = profilesListRegion.bottom - clientRegion.bottom;
		var numHiddenRowsBottom = 0;
		if (hiddenHeightBottom > heightPerProfile) {
			numHiddenRowsBottom = Math.round(hiddenHeightBottom / heightPerProfile);
		}
//		util.showObject({numHiddenRowsBottom: numHiddenRowsBottom});
		// Check if the profile with index of numHiddenRowsBottom
		// is actually hidden.
		var lastVisibleProfileIndex = numActiveProfiles - numHiddenRowsBottom - 2;
		var isVisible = true;
		var i = numActiveProfiles - numHiddenRowsBottom - 1;
		if (i < 0) {i = 0;}
		var visibleIndex = i;
		while (isVisible && i < numActiveProfiles) {
			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			var rowId = 'tr:' + item.name;
			var rowRegion = YD.getRegion(rowId);
//			console.log('---');
//			console.log('index: ' + i);
//			console.log('rowRegion.top: ' + rowRegion.top);
//			console.log('clientRegion.bottom: ' + clientRegion.bottom);
//			console.log('---');
			// util.showObject(rowRegion, 'rowRegion');
			isVisible = (rowRegion.top > clientRegion.bottom);
			if (isVisible) {
				visibleIndex++;
			}
			i = i + 1;
		}
		var lastVisibleProfileIndex = i;
//		console.log('numActiveProfiles: ' + numActiveProfiles);
//		console.log('lastVisibleProfileIndex: ' + (i - 2));
//		console.log('visibleIndex: ' + visibleIndex);
		return visibleIndex;
	}
	function editViewActivated() {
		// Remove scroll listener
		YE.removeListener(window, 'scroll', _scrollActivated);
	}
	// Return global properties and methods
	return {
		init: init,
		clear: clear,
		create: create,
		createWithInvalidProfiles: createWithInvalidProfiles,
		checkDashboardDataForCurrentView: checkDashboardDataForCurrentView,
		editViewActivated: editViewActivated,
		updateDbInfoCell: updateDbInfoCell
	};
}());
/* global
	profilesDashboard: false */
var database = (function() {
	'use strict';
	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		databasePanel = null,
		panelHeader = null,
		panelBody = null,
		panelWidth = 450,
//		updateBtn = null,
//		buildBtn = null,
//		cancelTaskBtn = null,
		activeProfileName = '',
		activeTaskId = '',
		// activeOperation: update | build
		activeOperation = '',
		rowElement = null;
	function init() {
		databasePanel = util.getE('profiles_database_panel');
		databasePanel.style.width = panelWidth + 'px';
		panelHeader = util.getE('profiles_database_header');
		panelBody = util.getE('profiles_database_body');
//		updateBtn = util.getE('profiles:update_database_btn');
//		buildBtn = util.getE('profiles:build_database_btn');
		YE.delegate(panelHeader, 'click', function(evt) {
			var element = evt.target || evt.srcElement;
			var elementId = element.id;
			// console.log('elementId: ' + elementId);
			if (elementId === 'profiles:close_database_panel_btn') {
				closePanel();
			}
			else if (elementId === 'profiles:update_database_btn') {
				updateDatabase();
			}
			else {
				buildDatabase();
			}
		}, 'a');
	}
	function closePanel() {
		// This closes any active database info / progress panel.
		// It is called i.e. when editing the dashboard.
		if (activeProfileName !== '') {
			databasePanel.style.display = 'none';
			activeProfileName = '';
			activeOperation = '';
			rowElement.className = '';
		}
	}
	function toggleDatabaseMenu(btnElement, profileName) {
		// Init database
		if (databasePanel === null) {
			init();
		}
		if (profileName === activeProfileName) {
			// Close active panel
			closePanel();
		}
		else {
			// Close panel so that any selected row becomes deselected
			closePanel();
			// Select the table row
			// Get row
			rowElement = btnElement;
			while (rowElement.nodeName !== 'TR') {
				rowElement = rowElement.parentNode;
			}
			rowElement.className = 'active';
			// Show database panel for given profileName
			// Hide all buttons
//			updateBtn.style.display = 'none';
//			buildBtn.style.display = 'none';
			setPanelHeader();
			panelBody.innerHTML = '<p>Loading ...</p>';
			setPanelPosition(btnElement);
			getDatabaseInfo(profileName);
			databasePanel.style.display = 'block';
			activeProfileName = profileName;
		}
	}
	function getDatabaseInfo(profileName) {
		var url = '?dp=templates.util.database_info.get_database_info_data';
		url += '&p=' + profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=database.getDatabaseInfoResponse';
		util.serverPost(url, dat);
	}
	function getDatabaseInfoResponse(dat) {
//		util.showObject(dat);
		// Make sure that we are still on the same profile
		if (dat.profileName === activeProfileName) {
			var content = '';
			var	dbState = 0;
			var panelHeaderType = '';
			var dbOperationCompleted = false;
			if (dat.databaseIsBuilding) {
				activeTaskId = dat.taskId;
				getProgressState();
				// Get progress data
				content += '<p>' + langVar('lang_stats.database.database_is_updating_building') + '</p>';
				content += '<p>' + langVar('lang_stats.general.receiving_progress') + '</p>';
				dbState = 1;
			}
			else if (dat.dbBuilt) {
				// Show database info
//				updateBtn.style.display = (activeOperation === '') ? 'block' : '';
				if (activeOperation === '') {
					panelHeaderType = 'update';
				}
				else if (activeOperation === 'update') {
					// This must be a completed update
//					panelHeaderType = 'update_complete';
					content += '<p>' + langVar('lang_stats.database.update_completed') + '<p>';
					dbOperationCompleted = true;
				}
				else {
					// This must be a completed build
//					panelHeaderType = 'build_complete';
					content += '<p>' + langVar('lang_stats.database.build_completed') + '<p>';
					dbOperationCompleted = true;
				}
				content += '<p>' + langVar('lang_stats.database.database_last_modified') + ': ' + dat.dbLastModified + '<p>';
				content += '<p>' + dat.dbLastOperation + '</p>';
				content += '<p>' + langVar('lang_stats.database.earliest_log_entry') + ': ' + dat.dbErliestDateTime + '</p>';
				content += '<p>' + langVar('lang_stats.database.latest_log_entry') + ': ' + dat.dbLatestDateTime + '</p>';
				dbState = 2;
			}
			else {
				// Not yet built.
//				buildBtn.style.display = (activeOperation === '') ? 'block' : '';
				panelHeaderType = 'build';
				content += '<p>' + langVar('lang_stats.database.database_is_not_yet_built') + '</p>';
				dbState = 0;
			}
			setPanelHeader(panelHeaderType);
			panelBody.innerHTML = content;
			// Update dashboard
			profilesDashboard.updateDashboardItemDbState(
				activeProfileName,
				dbState,
				dat.dbLastModifiedEpoc,
				dbOperationCompleted);
		}
	}
	function updateDatabase() {
//		updateBtn.style.display = 'none';
		activeOperation = 'update';
		var url = '?dp=update_database.start_update_database';
		var text = langVar('lang_stats.database.updating_database_initiated_please_wait');
		updateBuildDatabase(url, text);
	}
	function buildDatabase() {
//		buildBtn.style.display = 'none';
		activeOperation = 'build';
		var url = '?dp=build_database.start_build_database';
		var text = langVar('lang_stats.database.building_database_initiated_please_wait');
		updateBuildDatabase(url, text);
	}
	function updateBuildDatabase(url, text) {
//		util.hideE('profiles:database_buttons');
		setPanelHeader();
		panelBody.innerHTML = '<p>' + text + '</p>';
		url += '&p=' + activeProfileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=' + 'database.updateBuildDatabaseResponse';
		util.serverPost(url, dat);
		// Update dashboard info
		profilesDashboard.updateDashboardItemDbState(activeProfileName, 1, 0, false);
	}
	function updateBuildDatabaseResponse(dat) {
		// Make sure that we are still on the same profile
		if (dat.profileName === activeProfileName) {
			if (dat.errorMessage === '') {
				// Get progress state
				activeTaskId = dat.taskId;
				getProgressState();
			}
			else {
				// An error occurred, show error message.
				// TODO - refine error handling
				panelBody.innerHTML = '<p>' + dat.errorMessage + '</p>';
			}
		}
	}
	function getProgressState() {
		// TODO - we may need to handle snapon progress too!
		var url = '?dp=progress.get_progress_state';
		url += '&p=' + activeProfileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.response_function=database.getProgressStateResponse';
		dat += '&v.fp.progress_type=database';
		dat += '&v.fp.task_id=' + activeTaskId;
		dat += '&v.fp.report_job_id=';
		// Use the profile_name for progress_id
		dat += '&v.fp.progress_id=' + activeProfileName;
		util.serverPost(url, dat);
	}
	function getProgressStateResponse(dat) {
		// Make sure that we are still on the same profile
		// Note, get_progress_state returns no profile_name
		// but we get it in progress_id.
		if (dat.progressId === activeProfileName) {
//			util.showObject(dat);
			var progressState = dat.progressState;
			switch (progressState) {
				case 'progress':
					// util.showE(['progress:step_label', 'progress:step_description']);
//					util.updateT('progress:main_label', dat.mainLabel);
//					util.updateT('progress:total_time_elapsed', dat.totalTimeElapsed);
					setProgressDisplay(dat.progress);
					// get progress state data
					setTimeout(function() {
						getProgressState();
					}, 1200);
					break;
				case 'progress_prediction':
					// get progress state data
					setTimeout(function() {
						getProgressState();
					}, 1200);
					break;
				case 'complete':
//					var content = '<p>Update/Build Database completed.</p>';
//					panelBody.innerHTML = content;
					// Get up to date database info data
					getDatabaseInfo(activeProfileName);
					break;
				case 'error':
					// Currently not active, the error is fired
					// by a Salang error() message right away in get_progress_state.cfv!
					alert('getProgressStateResponse() error');
					break;
			}
		}
	}
	function setProgressDisplay(dat) {
		// TODO - normalize progress data, i.e. handle subtasks
		// on server side response
		var content = '<p>' + dat.mainLabel + '</p>';
		content += '<p>' + langVar('lang_stats.progress.time_elapsed_label') + ': ' + dat.totalTimeElapsed + '</p>';
		if (dat.stepLabel !== '') {
			content += '<p>' + dat.stepLabel + '</p>';
		}
		if (dat.stepDescription !== '') {
			content += '<p>' + dat.stepDescription + '</p>';
		}
		panelBody.innerHTML = content;
	}
	function setPanelHeader(headerType) {
		headerType = headerType || '';
		var html = '<a id="profiles:close_database_panel_btn" href="javascript:;" class="database-panel-close">&times;</a>';
		if (headerType !== '') {
			if (headerType === 'update') {
				html += '<a id="profiles:update_database_btn" href="javascript:;">' + langVar('lang_stats.btn.update_database') + '</a>';
			}
			else if (headerType === 'build') {
				html += '<a id="profiles:build_database_btn" href="javascript:;">' + langVar('lang_stats.btn.build_database') + '</a>';
			}
		}
		panelHeader.innerHTML = html;
	}
	function setPanelPosition(btnElement) {
		// Set panel element position right or left from button element
		// clientRegion.top is equal scrollTop!
		var clientRegion = YD.getClientRegion();
//		util.showObject(clientRegion);
		var btnRegion = YD.getRegion(btnElement);
		var btnTop = btnRegion.top;
		var btnBottom = btnRegion.bottom;
		var btnLeft =  btnRegion.left;
		var btnRight =  btnRegion.right;
//		util.showObject(btnRegion);
		var panelTop = btnBottom + 5;
		var panelLeft = btnRight - panelWidth + 62;
		panelLeft = panelLeft > 70 ? panelLeft : 70;
//		if ((btnRight + panelWidth) <= clientRegion.right ||
//			(clientRegion.right - btnRight) >= btnLeft) {
//			// Position panel on right side of button
//			panelLeft = btnRight + 6;
//		}
//		else {
//			// Position panel on left side of button
//			panelLeft = btnLeft - panelWidth;
//			panelLeft = panelLeft >= 0 ? panelLeft : 0;
//		}
		databasePanel.style.top = panelTop + 'px';
		databasePanel.style.left = panelLeft + 'px';
//		databasePanel.style.right = panelRight + 'px';
	}
	// Return global properties and methods
	return {
		closePanel: closePanel,
		toggleDatabaseMenu: toggleDatabaseMenu,
		getDatabaseInfoResponse: getDatabaseInfoResponse,
		updateBuildDatabaseResponse: updateBuildDatabaseResponse,
		getProgressStateResponse: getProgressStateResponse
	};
}());
/* global
	profiles: false,
	deleteProfile: false,
	duplicateProfile: false,
	renameProfile: false
*/
var profilesUtil = (function() {
	'use strict';
	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;
	var isRootAdmin = false;
	var allProfilesGrants = null;
	var profilesGrants = null;
	var superRoles = null;
	// Menu elements
	var profileOptionsMenu;
	var configOptionsMenu = null;
	var configOptionsMenuAnchorEl = null;
	var toolsMenu = null;
	var toolsMenuAnchorEl = null;
	// activeProfile is the profile of the active menu
	var activeProfile = '';
	// activeSubmenu is the displayed Config Options or Tools menu.
	var activeSubmenu = '';
	var isMouseleave = false;
	var lastMouseLeaveEventCount = 0;
	function init() {
		isRootAdmin = pageInfo.isRootAdmin;
		initUserGrants();
		profileOptionsMenu = util.getE('profile_options_menu');
		configOptionsMenu = util.getE('profile_config_options_menu');
		configOptionsMenuAnchorEl = util.getE('profiles:config_options_btn');
		toolsMenu = util.getE('profile_tools_menu');
		toolsMenuAnchorEl = util.getE('profiles:tools_btn');
		// Create configOptionsMenu
		createMenu(configOptionsMenu, pageInfo.configOptionsMenuItems);
		// Create toolsMenu
		createMenu(toolsMenu, pageInfo.toolsMenuItems);
		YE.addListener([profileOptionsMenu, configOptionsMenu, toolsMenu], 'mouseenter', function(evt) {
			// Reset isMouseleave
//			console.log('mouseenter');
			isMouseleave = false;
		});
		YE.addListener([profileOptionsMenu, configOptionsMenu, toolsMenu], 'mouseleave', function(evt) {
			// Reset isMouseleave
//			console.log('mouseleave');
			isMouseleave = true;
			lastMouseLeaveEventCount += 1;
			var lastCount = lastMouseLeaveEventCount;
//			console.log('lastMouseLeaveEventCount: ' + lastMouseLeaveEventCount);
			// If isMouseleave remains true then we close the menu.
			setTimeout(function() {
				checkMouseLeaveState(lastCount);
			}, 750);
		});
		YE.delegate('profile_options_menu', 'mouseover', function(evt) {
			var element = evt.target || evt.srcElement;
			// Get the li element
			if (element.nodeName !== 'LI') {
				element = element.parentNode;
			}
			var elementId = element.id;
//			console.log('mouseover: ' + elementId);
			var currentMenu = '';
			if (elementId.indexOf('config_options') !== -1) {
				currentMenu = 'config_options';
			}
			else if (elementId.indexOf('tools') !== -1) {
				currentMenu = 'tools';
			}
//			console.log('currentMenu: ' + currentMenu);
			if (currentMenu !== activeSubmenu) {
				// Hide displayed submenu
				if (activeSubmenu == 'config_options') {
					configOptionsMenu.style.display = 'none';
				}
				else if (activeSubmenu == 'tools') {
					toolsMenu.style.display = 'none';
				}
				// Display submenu
				if (currentMenu === 'config_options' ||
					currentMenu === 'tools') {
					var theMenu = null;
					if (currentMenu === 'config_options') {
						theMenu = configOptionsMenu;
					}
					else {
						theMenu = toolsMenu;
					}
					var region = YD.getRegion(element);
//					util.showObject(region);
					theMenu.style.top = region.top + 'px';
					theMenu.style.left = region.right + 'px';
					theMenu.style.display = 'block';
				}
				activeSubmenu = currentMenu;
			}
		}, 'li');
		YE.addListener('profile_options_menu', 'click', function(evt) {
			var element = evt.target || evt.srcElement;
			// Check if we need to handle the parent element,
			// for example multiple span elements within an anchor element
			// where id is defined on anchor element.
			if (element.id === '' && element.parentNode.id !== '') {
				element = element.parentNode;
			}
			var elementId = element.id;
			var profileItem;
			if (elementId.indexOf('delete_profile') !== -1) {
				deleteProfile.confirmDelete(activeProfile);
			}
			else if (elementId.indexOf('duplicate_profile') !== -1) {
				profileItem = profiles.getProfileItem(activeProfile);
				duplicateProfile.open(activeProfile, profileItem.label);
			}
			else if (elementId.indexOf('rename_profile') !== -1) {
				profileItem =  profiles.getProfileItem(activeProfile);
				renameProfile.open(activeProfile, profileItem.label);
			}
			closeProfileOptionsMenu();
		});
	}
	function initUserGrants() {
		if (!isRootAdmin) {
			allProfilesGrants = pageInfo.userGrants.allProfilesGrants;
			profilesGrants = pageInfo.userGrants.profilesGrants;
			superRoles = pageInfo.userGrants.superRoles;
			// Create hash lookup for profilesGrants
			util.createHash(profilesGrants, 'profile');
//			util.showObject(allProfilesGrants, allProfilesGrants);
//			util.showObject(profilesGrants, profilesGrants);
		}
	}
	function resetUserGrants(theUserGrants) {
		// This resets pageInfo.userGrants with up to date theUserGrants.
		// This is called for non-root-admins after profile creation
		// or upon duplicate, rename and delete profile.
		pageInfo.userGrants = theUserGrants;
		initUserGrants();
	}
	function checkMouseLeaveState(count) {
//		console.log('checkMouseLeaveState()');
//		console.log(' ');
//		console.log('count: ' + count);
//		console.log('lastMouseLeaveEventCount: ' + lastMouseLeaveEventCount);
//		console.log(' ');
		if (count === lastMouseLeaveEventCount && isMouseleave) {
			closeProfileOptionsMenu();
		}
	}
	function openProfileOptionsMenu(btnElement, profileName) {
		if (activeProfile === profileName) {
			// Toggle menu
			closeProfileOptionsMenu();
		}
		else {
			// Close any open menu
			closeProfileOptionsMenu();
			var isRootAdmin = pageInfo.isRootAdmin;
			// Handle permissions for non-root-admin users
			if (!isRootAdmin) {
//				var profileItem = profiles.getProfileItem(profileName);
				var theProfileGrants = getProfileGrants(profileName);
				util.showE('profiles:config_options:li', theProfileGrants.isViewConfig);
				util.showE('profiles:tools:li', theProfileGrants.isViewTools);
				util.showE('profiles:rename_profile:li', theProfileGrants.isRename);
				util.showE('profiles:duplicate_profile:li', pageInfo.permissions.isAdd);
				util.showE('profiles:delete_profile:li', theProfileGrants.isDelete);
			}
			// Set href of Config Options and Tools
			configOptionsMenuAnchorEl.href = '?dp=config&page=log_source&p=' + profileName;
			toolsMenuAnchorEl.href = '?dp=config&page=database_info&p=' + profileName;
			// Get superRole for non-admin-users so that we get the config grants.
			var theSuperRole = {};
			if (!isRootAdmin) {
				var theProfileGrants = getProfileGrantsObject(profileName);
				var superRoleName = theProfileGrants.superRole;
				theSuperRole = superRoles[superRoleName];
			}
			setMenuItems(pageInfo.configOptionsMenuItems, profileName, theSuperRole);
			setMenuItems(pageInfo.toolsMenuItems, profileName, theSuperRole);
			// Set position and show the menu
			positionAndShowMenuElement(btnElement);
 			activeProfile = profileName;
		}
	}
	function closeProfileOptionsMenu() {
		if (activeProfile !== '') {
			profileOptionsMenu.style.display = 'none';
			configOptionsMenu.style.display = 'none';
			toolsMenu.style.display = 'none';
			activeProfile = '';
			activeSubmenu = '';
		}
	}
	function positionAndShowMenuElement(btnElement) {
		var menuElement = profileOptionsMenu;
		// clientRegion.top is equal scrollTop!
		var clientRegion = YD.getClientRegion();
//		util.showObject(clientRegion);
		var btnRegion = YD.getRegion(btnElement);
		var btnTop = btnRegion.top
		var btnBottom = btnRegion.bottom;
		var btnLeft =  btnRegion.left;
		var btnRight =  btnRegion.right;
//			util.showObject(btnRegion);
		// Get region of drop down menu
		menuElement.style.visibility = 'hidden';
		menuElement.style.top = 0;
		menuElement.style.left = 0;
		menuElement.style.display = 'block';
		var menuRegion = YD.getRegion(menuElement);
//			util.showObject(menuRegion);
		var menuWidth = menuRegion.width;
		var menuHeight = menuRegion.height;
		var menuLeft = btnLeft;
		var menuTop = 0;
		// Check if we have enough bottom space for the menu
		if ((btnBottom + menuHeight) < clientRegion.bottom) {
			menuTop = btnBottom;
		}
		else {
			// Display menu on top
			menuTop = btnTop - menuHeight;
		}
		// Set final position
		menuElement.style.top = menuTop + 'px';
		menuElement.style.left = menuLeft + 'px';
		// Show the menu
		menuElement.style.visibility = 'visible';
	}
	function setMenuItems(menuItems, profileName, theSuperRole) {
		// This sets the href attribute and visibility according
		// user grants of the menuItems for the active profile.
		for (var i = 0, len = menuItems.length; i < len; i++) {
			var menuItem = menuItems[i];
			var page = menuItem.page;
			if (!isRootAdmin) {
				// Show/hide list element according theSuperRole config grants.
				var liElement = menuItem.liElement;
				liElement.style.display = theSuperRole.hasOwnProperty(page) ? '' : 'none';
			}
			var aElement = menuItem.aElement;
			aElement.href= '?dp=config&page=' + page + '&p=' + profileName;
		}
	}
	function createMenu(container, menuItems) {
//		util.showObject(menuItems);
		var list = '';
		var i = 0;
		var len =  menuItems.length;
		for (i = 0; i < len; i++) {
			var listItem = menuItems[i];
			var listClass = (listItem.separator) ? ' class="group"' : '';
			var label = listItem.label;
			list += '<li' + listClass + '><a href=""><span>' + label + '</span></a></li>';
		}
		container.innerHTML = list;
		// Create a reference for each anchor element so that we can set
		// the href attribute per profile
		var elements = container.getElementsByTagName('a');
		for (i = 0; i < len; i++) {
			var anchorElement = elements[i];
			menuItems[i].aElement = anchorElement;
			// Create a reference to the list element for
			// non-root-admins so that we can show/hide the list
			// elements according profile grants.
			if (!isRootAdmin) {
				menuItems[i].liElement = anchorElement.parentNode;
			}
//			console.log(elements[i].href);
		}
	}
	function getProfileGrants(profileName) {
		var theProfileGrants = isRootAdmin ? null : getProfileGrantsObject(profileName);
//		util.showObject(theProfileGrants, 'theProfileGrants');
		return {
			viewDatabaseInfoColumn: isRootAdmin || theProfileGrants.viewDatabaseInfoColumn,
			viewCreatedByColumn: isRootAdmin || theProfileGrants.viewCreatedByColumn,
			viewProfilesDashboard: isRootAdmin || theProfileGrants.viewProfilesDashboard,
			editProfilesDashboard: isRootAdmin || theProfileGrants.editProfilesDashboard,
			isViewReports: isRootAdmin || theProfileGrants.accessReports,
			isViewConfig: isRootAdmin || theProfileGrants.accessConfig,
			isViewTools: isRootAdmin || theProfileGrants.accessTools,
			isRename: isRootAdmin || theProfileGrants.isRename,
			isDelete: isRootAdmin || theProfileGrants.isDelete
		};
	}
	function getProfileGrantsObject(profileName) {
		// Get user grants for the profile
		if (typeof profilesGrants[util.h(profileName)] !== 'undefined') {
			// This profile has individual profile grants
//			console.log('Return individual profile grants');
//			util.showObject(profilesGrants[util.h(profileName)], 'profilesGrants of profile ' + profileName);
			return profilesGrants[util.h(profileName)];
		}
		else {
			// Individual profile grants don't exist, use the allProfilesGrants
//			console.log('Return allProfilesGrants');
			return allProfilesGrants;
		}
	}
	// Return global properties and methods
	return {
		init: init,
		resetUserGrants: resetUserGrants,
		openProfileOptionsMenu: openProfileOptionsMenu,
		checkMouseLeaveState: checkMouseLeaveState,
		getProfileGrants: getProfileGrants
	};
}());
/* global
	convertProfile: false,
	database: false,
	deleteProfile: false,
	langVar: false,
	pageInfo: false,
	profilesFilter: false,
	profilesList: false,
	profilesStorage: false,
	profilesDashboard: false,
	profilesDashboardEditor: false,
	profilesUtil: false,
	scrollUtil: false,
	toolbarButtonsDb: false,
	util: false,
	YAHOO: false */
var profiles = (function() {
	'use strict';
	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		// profilesDb is an array with profile item arrays:
		// [
		// profile name
		// profile label
		// database type 1=internal_sql 2=mysql 3=odbc_mssql 4=odbc_oracle
		// database name
		// username
		// date filter
		// not supported version number (empty is valid profile)
		// ]
		profilesDb = [],
		// profilesView = {}, profilesView is defined in pageInfo
		numLicensedProfiles = 0,
		numAllProfiles = 0,
		numPermittedProfiles = 0,
		newProfileBtn = null,
		viewBtn = null,
//		editViewBtn = null,
		convertProfilesBtn = null,
		newProfileWizardWindow = null,
//		scrollControl = null,
		// Valid/invalid profile parameters
		// are set when loading new profile lists.
		isInvalidVersion7Profiles = false,
		isInvalidVersion8Profiles = false,
		// isInvalidProfiles is true if one invalid v7 or v8 profile exists
		isInvalidProfiles = false,
		// isValidProfiles is true if one or more valid profile exists,
		// regardless of invalid profiles.
		isValidProfiles = true,
		editViewActive = false,
		busyPanel = null;
	function init() {
		var isRootAdmin = pageInfo.isRootAdmin;
		var permissions = pageInfo.permissions;
		// Create simple progress panel
		busyPanel = new util.BusyPanel();
		newProfileBtn = new util.ToolbarButton('new_profile', createNewProfile, toolbarButtonsDb);
		viewBtn = new util.ToolbarButton('view', toggleToolbarMenu, toolbarButtonsDb);
		util.dropDownMenu.add('toolbar:view', 'profiles_toolbar:drop_down:view');
		YE.addListener('profiles_toolbar:drop_down:toggle_profiles_filter_btn', 'click', toggleProfilesFilter);
		if (permissions.isViewDatabaseInfoColumn) {
			YE.addListener('profiles_toolbar:drop_down:toggle_db_info_column_btn', 'click', toggleDatabaseInfoColumn);
		}
		if (permissions.isViewCreatedByColumn) {
			YE.addListener('profiles_toolbar:drop_down:toggle_created_by_column_btn', 'click', toggleCreatedByColumn);
		}
		YE.addListener('profiles_toolbar:drop_down:refresh_view', 'click', refreshView);
		if (isRootAdmin || permissions.isAdd) {
			YE.addListener('profiles:no_profile_info_btn', 'click', createNewProfile);
			YE.addListener('profiles_toolbar:drop_down:edit_dashboard_btn', 'click', editView);
		}
		if (isRootAdmin) {
			var commandLinkOptions = {
				classNameEnabled: '',
				classNameDisabled: 'disabled'
			};
			convertProfilesBtn = new util.CommandLink('profiles:convert_profiles_btn', convertProfile.confirmProfileConversion, true, commandLinkOptions);
		}
		YE.addListener('profiles:v7_profiles_list', 'click', profileLinkActivated);
		YE.addListener('profiles_profiles_list', 'click', profileLinkActivated);
		// Init help
		util.helpWindow.init('');
		// Init profilesUtil and profilesList
		profilesUtil.init();
		profilesList.init();
		// Init the scrollControl
//		scrollControl = new scrollUtil.Scroller('', '', profiles.scrollingList);
		numLicensedProfiles = pageInfo.numLicensedProfiles;
		if (profilesStorage.getIsUpToDate()) {
			// Note, we assume that there are no invalid v7 and v8 profiles
			// in profilesStorage.
//			console.log('Profile Data: UP TO DATE ON CLIENT - NO FRESH DATA');
//			alert('getting profiles data from storage!');
			// profilesDb already exists in storage
			numAllProfiles = profilesStorage.get('numAllProfiles');
			// Note, we need to create the hash as upon
			// initial loading.
			var theProfiles = profilesStorage.get('profilesDb');
			addProfilesToProfilesDb(theProfiles);
//			util.showObject(profilesDb, 'profilesDb from store');
//			console.log('Profile Data: FROM STORAGE');
			// Note, createDashboardData must be generated before the
			// the profilesList becomes generated.
			profilesDashboard.createDashboardData();
			profilesList.create(profilesDb);
			updateProfilesDisplay();
			profilesList.checkDashboardDataForCurrentView();
		}
		else {
//			console.log('Profile Data: FRESH FROM SERVER');
			// Get fresh profile data
//			getProfileData(0, 40);
			// Initial loading of profile data requires to load all
			// profiles at once because it may contain invalid
			// version 7, version 8.0 and version 8.1 profiles.
			getProfileData();
		}
		// Init profilesFilter
		profilesFilter.init({
			profilesDb: profilesDb,
			searchElementId: 'profiles:filter',
			clearSearchBtnId: 'profiles:clear_filter_btn',
			onSearchCallback: profiles.createFilteredProfilesList
		});
		// Init show_before_you_start_info
		if (pageInfo.showBeforeYouStartInfo) {
			YE.addListener(['before_you_start:antivirus', 'before_you_start:large_datasets'], 'click', toggleShowBeforeYouStartSection);
			var infoHelpLinks = ['before_you_start:server_sizing', 'before_you_start:database_setup', 'before_you_start:profile_tuning'];
			YE.addListener(infoHelpLinks, 'click', util.helpWindow.openGeneralHelp);
			YE.addListener('before_you_start:hide_btn', 'click', hideBeforeYouStartSection);
			YE.addListener('before_you_start:do_not_show_again', 'click', toggleDoNotShowAgain);
		}
	}
	function getProfileData(isGetNewChecksum /* option */) {
		isGetNewChecksum = isGetNewChecksum || false;
//		console.log('isGetNewChecksum: ' + isGetNewChecksum);
		if (!pageInfo.exitActive) {
			busyPanel.showLoading();
			var url = '?dp=util.profiles.get_profile_data';
			var dat = 'v.fp.active_page=' + pageInfo.page;
			dat += '&v.fp.page_token=' + pageInfo.pageToken;
			dat += '&v.fp.response_function=profiles.getProfileDataResponse';
			dat += '&v.fp.get_new_checksum=' + isGetNewChecksum;
			util.serverPost(url, dat);
		}
	}
	function getProfileDataResponse(dat) {
		if (!pageInfo.exitActive) {
//			util.showObject(dat);
			// Reset profilesDb, it may contain invalid profiles
			// which have been converted.
			profilesDb = [];
			// Set numAllProfiles
			numAllProfiles = dat.numAllProfiles;
			numPermittedProfiles = dat.numPermittedProfiles;
			// Sort the profiles by label
			dat.profilesDb.sort(compareProfileLabels);
			addProfilesToProfilesDb(dat.profilesDb);
			// Check if all all profiles are valid before we
			// save the profiles on client side.
			setIsInvalidProfiles();
			// Handle any active profile conversion.
			if (pageInfo.profileConversionState.isActive) {
				// Set conversion state parameters in case that
				// they are not yet set by setIsInvalidProfiles()
				isInvalidVersion8Profiles = true;
				isInvalidProfiles = false;
			}
			if (!isInvalidProfiles) {
				// Save profile data in local storage, only if no single invalid profile exists
				// If we requested a new profilesListChecksum then use it!
				var profilesListChecksum = '';
				// If a new profilesListChecksum
				if (dat.profilesListChecksum !== '') {
					profilesListChecksum = dat.profilesListChecksum;
					// Update pageInfo.profilesListChecksum
					pageInfo.profilesListChecksum = profilesListChecksum;
//					console.log('Using new profilesListChecksum: ' + profilesListChecksum);
				}
				else {
					// No new checksum requested, use pageInfo.profilesListChecksum.
					profilesListChecksum = pageInfo.profilesListChecksum;
//					console.log('Using existing profilesListChecksum: ' + profilesListChecksum);
				}
				profilesStorage.addNewProfilesDb(
					profilesListChecksum,
					numAllProfiles,
					numPermittedProfiles,
					profilesDb);
				profilesDashboard.createDashboardData();
				profilesList.create(profilesDb);
				updateProfilesDisplay();
				profilesList.checkDashboardDataForCurrentView();
			}
			else {
				// There is one or more invalid profiles
				profilesList.createWithInvalidProfiles(profilesDb);
				updateProfilesDisplay();
				// Handle active profile conversion, if any.
				if (pageInfo.profileConversionState.isActive) {
					convertProfile.handleActiveProfileConversion();
				}
			}
			busyPanel.stop();
		}
	}
	function updateProfilesDisplay() {
		// New profile data have been loaded or a profile has been deleted,
		// renamed or copied.
		util.hideE([
			'profiles:no_profile_info',
			'max_profiles_exceeded_info',
			'profiles:v7_profiles_info',
			'profiles:convert_profiles_info',
			'profiles_profiles_list',
			'saving_info',
			'deleting_info'
		]);
		if (numAllProfiles > 0) {
			if (isInvalidVersion7Profiles) {
				util.showE('profiles:v7_profiles_info');
			}
			if (isInvalidVersion8Profiles) {
				// Set text in convert_profiles_btn
				util.showE('profiles:convert_all_profiles_info', !isValidProfiles);
				util.showE('profiles:convert_some_profiles_info', isValidProfiles);
				util.showE('profiles:convert_profiles_info');
				if (pageInfo.isRootAdmin) {
					// util.enableE('profiles:convert_profiles_info', isInvalidVersion8Profiles && !convertProfile.isActive);
					convertProfilesBtn.enable();
				}
			}
			if (isValidProfiles || isInvalidVersion8Profiles) {
				util.showE('profiles_profiles_list');
			}
			// Enable/disable profiles filters input element
			util.enableE('profiles:filter', !isInvalidProfiles);
		}
		else {
			util.showE('profiles:no_profile_info');
		}
		// Check if there is a limit on the number of profiles
		// Note, check for number_of_licensed_profiles element existence because the element is not always available
		if (numLicensedProfiles !== 0 && (util.getE('licensed_profiles_info') !== null)) {
			// Update number of licensed profiles
			util.updateT('licensed_profiles_info:number_of_licensed_profiles', numLicensedProfiles);
			util.updateT('licensed_profiles_info:number_of_used_profiles', numAllProfiles);
			util.showE('licensed_profiles_info');
			// If all profiles exceeds number of licensed profiles
			if (numAllProfiles > numLicensedProfiles) {
				util.updateT('max_profiles_exceeded_info:number_of_profiles', numAllProfiles);
				util.updateT('max_profiles_exceeded_info:number_of_licensed_profiles', numLicensedProfiles);
				util.showE('max_profiles_exceeded_info');
			}
		}
		// TODO, we may need to wrap !convertProfile.isActive into a function!
		// ToDO, revise newProfileBtn permission
		newProfileBtn.enable(!isInvalidVersion8Profiles && !convertProfile.isActive);
		viewBtn.enable(!isInvalidVersion8Profiles && !convertProfile.isActive);
		util.showE('form_section');
	}
	function scrollingList(verticalScrollLevel) {
//		console.log('scrollingList() fired - verticalScrollLevel: ' + verticalScrollLevel);
		// ToDO
//		getProfileData();
	}
	function profileLinkActivated(evt) {
		// Event on profiles list table, used for menus, database info and
		// delete when showing simple rows which include invalid profiles.
		var element = evt.target || evt.srcElement;
//		console.log('element clicked: ' + element.id);
//		console.log('element node: ' + element.nodeName);
//		console.log('element parent node: ' + element.parentNode.nodeName);
//		console.log('element parent node ID: ' + element.parentNode.id);
		// Check if we need to handle the parent element,
		// for example multiple span elements within an anchor element
		// where id is defined on anchor element.
		if (element.id === '' && element.parentNode.id !== '') {
			element = element.parentNode;
		}
		var elementId = element.id;
//		var profileItem = {};
		var pattern = /^.+:(menu|db|delete)$/;
		if (pattern.test(elementId)) {
			var dat = elementId.split(':');
			var profileName = dat[1];
			var operationKeyWord = dat[2];
			switch (operationKeyWord) {
			case 'menu':
				profilesUtil.openProfileOptionsMenu(element, profileName);
				break;
			case 'db':
				// Handle update database, build database and database info
				database.toggleDatabaseMenu(element, profileName);
				break;
			case 'delete':
				// This delete button is only activated via simple rows
				// in case of invalid version 7 or version 8 profiles.
				deleteProfile.confirmDelete(profileName);
				break;
//			case 'toggle_invalid_profile_text':
//
//				toggleInvalidProfileText(profileName);
//				break;
			}
		}
	}
	function createNewProfile() {
		// Verify that width and height are within available viewport size
		var viewPortWidth = YD.getViewportWidth();
		var viewPortHeight = YD.getViewportHeight();
		var width = (770 < viewPortWidth) ? 770 : viewPortWidth;
		var height = (510 < viewPortHeight) ? 510 : viewPortHeight;
		var windowName = 'new_profile_wizard';
		var url = '?dp=new_profile_wizard.index';
		var left = parseInt((screen.availWidth / 2) - (width / 2), 10);
		var top = parseInt((screen.availHeight / 2) - (height / 2), 10);
		newProfileWizardWindow = window.open(url, windowName, 'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ', status=yes, scrollbars=yes, resizable=yes');
		newProfileWizardWindow.focus();
	}
	function closeNewProfileWizardWindow() {
		// Close new profile wizard window
		// Hack for Firefox problem which doesn't close the window immediately,
		// though blur moves it to the background!
		newProfileWizardWindow.blur();
		newProfileWizardWindow.close();
	}
	function handleDeleteProfileCompleted(profileChanges) {
//		util.showObject(profileChanges);
		if (!profileChanges.isNewProfilesList) {
			// We got a new profilesListChecksum but don't
			// need a new list. Delete the profile from
			// profilesDb and update local storage
			// with the new checksum and profilesDb so that
			// it is in sync with the server side.
			var profilesListChecksum = profileChanges.profilesListChecksum;
			// Update pageInfo.profilesListChecksum
			pageInfo.profilesListChecksum = profilesListChecksum;
			var deletedProfileName = profileChanges.profileName;
			for (var i = 0, len = profilesDb.length; i < len; i++) {
				if (profilesDb[i][0] === deletedProfileName) {
					profilesDb.splice(i, 1);
					break;
				}
			}
			numAllProfiles = numAllProfiles - 1;
			numPermittedProfiles = numPermittedProfiles - 1;
			if (!isInvalidProfiles) {
				// Update local storage
				profilesStorage.addNewProfilesDb(
					profilesListChecksum,
					numAllProfiles,
					numPermittedProfiles,
					profilesDb);
				profilesList.create(profilesDb);
				updateProfilesDisplay();
				profilesList.checkDashboardDataForCurrentView();
			}
			else {
				// The list contained one or more invalid profiles.
				// Recheck profilesDb for invalid profiles
				setIsInvalidProfiles();
				// If there are still invalid profiles
				if (isInvalidProfiles) {
					profilesList.createWithInvalidProfiles(profilesDb);
					updateProfilesDisplay();
				}
				else {
					// No more invalid profile, reload the profiles.
					getProfileData();
				}
			}
		}
		else {
			// We got a new profilesDb
			if (!isInvalidProfiles) {
				handleNewProfilesDb(profileChanges);
			}
			else {
				// The list contains or contained invalid profiles
				// and we got a new profilesDB, this use case should be very rare.
				// For convenience reload the profiles.
				location.reload(true);
			}
		}
	}
	function handleNewProfile(profileChanges) {
		// This is called after a new profile has been added
		// via new profile wizard or duplicate profile.
//		console.log('handleNewProfile - profileChanges.isNewProfilesList: ' + profileChanges.isNewProfilesList);
		if (!profileChanges.isNewProfilesList) {
			// Add a single new profile item
			// to existing profilesDb.
//			util.showObject(profileChanges, 'profileChanges');
			var profilesListChecksum = profileChanges.profilesListChecksum;
			// Add item to profilesDb
			profilesDb[profilesDb.length] = profileChanges.profileItem;
			// Sort profilesDb
			profilesDb.sort(compareProfileLabels);
			// Note, we must re-add all items to profilesDb after sort
			// so that we get the right lookup names!
			var theProfiles = util.cloneObject(profilesDb);
			profilesDb = [];
			addProfilesToProfilesDb(theProfiles);
			theProfiles = [];
			numAllProfiles = numAllProfiles + 1;
			numPermittedProfiles = numPermittedProfiles + 1;
			// Update local storage
			profilesStorage.addNewProfilesDb(
				profilesListChecksum,
				numAllProfiles,
				numPermittedProfiles,
				profilesDb);
			// TODO - Revise how to handle dashboard after addition of a new profile
			// since we don't want to reload all data.
			profilesDashboard.createDashboardData();
			profilesList.create(profilesDb);
			updateProfilesDisplay();
			profilesList.checkDashboardDataForCurrentView();
		}
		else {
			// We got a new profilesDb
			handleNewProfilesDb(profileChanges);
		}
	}
	function handleNewProfilesDb(profileChanges) {
		// We received a new profilesDb after delete, rename, copy or new
		profilesDb = [];
		var profilesListChecksum = profileChanges.profilesListChecksum;
		addProfilesToProfilesDb(profileChanges.profilesDb);
		// Sort profilesDb
		profilesDb.sort(compareProfileLabels);
		numAllProfiles = profileChanges.numAllProfiles;
		numPermittedProfiles = profileChanges.numPermittedProfiles;
		// Update local storage
		profilesStorage.addNewProfilesDb(
			profilesListChecksum,
			numAllProfiles,
			numPermittedProfiles,
			profilesDb);
		// TODO - Revise how to handle dashboard after addition of a new profile
		// since we don't want to reload all data.
		profilesDashboard.createDashboardData();
		profilesList.create(profilesDb);
		updateProfilesDisplay();
		profilesList.checkDashboardDataForCurrentView();
	}
	function editView() {
		// Don't allow editView while we have invalid profiles.
		// This is a workaround for the dropdown menu which is functional
		// although the  button is disabled.
		// TODO - Remove isInvalidProfiles check when adding other drop down menus.
		if (!isInvalidProfiles) {
			editViewActive = true;
			newProfileBtn.disable();
			viewBtn.disable();
			profilesList.clear();
			// Remove scroll listener in profilesList
			profilesList.editViewActivated();
			// Create edit profiles view
			var theProfiles = getActiveProfilesDb();
			profilesDashboardEditor.create(theProfiles);
			// Close database info, if any
			database.closePanel();
		}
	}
	function editViewClosed(isCancel) {
		editViewActive = false;
		// Update dashboard data
		profilesDashboard.createDashboardData();
		var theProfiles = getActiveProfilesDb();
		profilesList.create(theProfiles);
		updateProfilesDisplay();
		newProfileBtn.enable();
		viewBtn.enable();
		profilesList.checkDashboardDataForCurrentView();
//		if (!isCancel) {
			// TODO
			// the profilesView has been saved and most likely changed.
			// Handle profilesView data update?
//		}
	}
	function profilesDashboardDataUpdated() {
		// profilesDashboard data have been updated.
		// Rebuild the current view
		var theProfiles = getActiveProfilesDb();
		profilesList.create(theProfiles);
	}
	function createFilteredProfilesList(theProfiles) {
		// Called from profilesFilter
		if (!editViewActive) {
//			console.log('createFilteredProfilesList() - theProfiles: ' + theProfiles);
			profilesList.create(theProfiles);
			profilesList.checkDashboardDataForCurrentView();
		}
		else {
			profilesDashboardEditor.update(theProfiles);
		}
	}
	// Toggle profiles filter
	function toggleProfilesFilter(evt) {
		// Don't allow toggle while we have invalid profiles.
		// This is a workaround for the drop-down menu which is functional
		// although the  button is disabled.
		// TODO - Remove isInvalidProfiles check when adding better drop down menus.
		if (!isInvalidProfiles) {
			var profilesFilter = util.getE('profiles:profiles_filter_box');
			var showProfilesFilter = profilesFilter.className === 'profiles-filter-box-hidden';
			var btnText = '';
			if (showProfilesFilter) {
				btnText = langVar('lang_stats.btn.hide_profiles_filter');
				profilesFilter.className = 'profiles-filter-box';
			}
			else {
				btnText = langVar('lang_stats.btn.show_profiles_filter');
				profilesFilter.className = 'profiles-filter-box-hidden';
			}
			util.updateT('profiles_toolbar:drop_down:toggle_profiles_filter_btn', btnText);
			// Set users_cache preferences value
			var url = '?dp=admin_pages.profiles.toggle_profiles_filter';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			dat += '&v.fp.show_profiles_filter=' + showProfilesFilter;
			util.serverPost(url, dat);
		}
	}
	function toggleProfilesFilterResponse() {
		return false;
	}
	// Toggle Database Info or Created By column
	function toggleDatabaseInfoColumn(evt) {
		var showColumn = !pageInfo.showDatabaseInfoColumn;
		var btnText = '';
		if (showColumn) {
			btnText = langVar('lang_admin.profiles.hide_database_info_column');
		}
		else {
			btnText = langVar('lang_admin.profiles.show_database_info_column');
		}
		util.updateT('profiles_toolbar:drop_down:toggle_db_info_column_btn', btnText);
		pageInfo.showDatabaseInfoColumn = showColumn;
		// Save state in user preferences
		saveColumnStateInUserPreferences('profiles.show_database_info_column=' + showColumn);
		// Re-create profiles view
		profilesDashboard.createDashboardData();
		profilesList.create(profilesDb);
		updateProfilesDisplay();
		profilesList.checkDashboardDataForCurrentView();
	}
	function toggleCreatedByColumn(evt) {
		var showColumn = !pageInfo.showCreatedByColumn;
		var btnText = '';
		if (showColumn) {
			btnText = langVar('lang_admin.profiles.hide_created_by_column');
		}
		else {
			btnText = langVar('lang_admin.profiles.show_created_by_column');
		}
		util.updateT('profiles_toolbar:drop_down:toggle_created_by_column_btn', btnText);
		pageInfo.showCreatedByColumn = showColumn;
		// Save state in user preferences
		saveColumnStateInUserPreferences('profiles.show_created_by_column=' + showColumn);
		profilesList.create(profilesDb);
		updateProfilesDisplay();
		profilesList.checkDashboardDataForCurrentView();
	}
	function saveColumnStateInUserPreferences(userPreferencesProperty) {
		var url = '?dp=util.set_and_save_node';
		var dat = 'v.fp.active_page=' + pageInfo.page;
		dat += '&v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.main_node_name=users_cache_preferences';
		dat += '&v.fp.new_nodes.' + userPreferencesProperty;
		util.serverPost(url, dat);
	}
	function refreshView() {
		// This clears local storage and reloads all profile data
		var isGetNewChecksum = true;
		profilesList.clear();
		profilesStorage.reset();
		getProfileData(isGetNewChecksum);
	}
	//
	// Utilities
	//
	function setIsInvalidProfiles() {
		// Reset isValid/isInvalid properties
		isInvalidVersion7Profiles = false;
		isInvalidVersion8Profiles = false;
		isInvalidProfiles = false;
		isValidProfiles = false;
		for (var i = 0, len = profilesDb.length; i < len; i++) {
			var item = profilesStorage.profileArrayItemToObject(profilesDb[i]);
//			util.showObject(item);
			if (item.isValidProfile) {
				isValidProfiles = true;
			}
			else if (item.version === '8.0') {
				// This must be an invalid version 8.0 or 8.1 profile
				isInvalidVersion8Profiles = true;
			}
			else {
				// This must be an invalid version 7.0 profile
				isInvalidVersion7Profiles = true;
			}
		}
		isInvalidProfiles = isInvalidVersion8Profiles || isInvalidVersion7Profiles;
//		console.log('isInvalidProfiles: ' + isInvalidProfiles);
	}
	function addProfilesToProfilesDb(theProfiles) {
		// This adds theProfiles to profilesDb. It also creates
		// a hash to access a profile by profile name.
//		util.showObject(theProfiles, 'addProfilesToProfilesDb()');
		var len = theProfiles.length;
		if (len > 0) {
			// Add profile items to profilesDb
			for (var i = 0; i < len; i++) {
				var item = theProfiles[i];
				var lookupName = '_' + item[0];
				var targetIndex = profilesDb.length;
				profilesDb[targetIndex] = item;
				// Create lookup by profile name
				profilesDb[lookupName] = profilesDb[targetIndex];
			}
		}
	}
	function getActiveProfilesDb() {
		// Returns a filtered profilesDb if filter is active,
		// or the regular profilesDb if no filter is active.
		var obj = profilesFilter.getFilteredProfilesDb();
		if (obj.isFiltered) {
			return obj.filteredProfilesDb;
		}
		return profilesDb;
	}
	function getProfilesDb() {
		return profilesDb;
	}
	function getProfileItem(profileName) {
		var lookupName = '_' + profileName;
		return profilesStorage.profileArrayItemToObject(profilesDb[lookupName]);
	}
	function compareProfileLabels(a, b) {
//		console.log('sorting profiles ...');
		var labelA = a[1].toLowerCase();
		var labelB = b[1].toLowerCase();
		if (labelA < labelB) {
			return -1;
		}
		else if (labelA > labelB) {
			return 1;
		}
		return 0;
	}
	function getIsEditViewActive() {
		return editViewActive;
	}
	function toggleToolbarMenu() {
		// This is a fake function for the View button drop down.
		// TODO - remove this when adding better drop down menu support.
	}
	/*
		Show before you start info utilities
	*/
	function toggleShowBeforeYouStartSection(evt) {
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		var sectionElement = util.getE(elementId + ':section');
//		console.log('elementId: ' + elementId);
		sectionElement.style.display = (sectionElement.style.display === 'block') ? 'none' : 'block';
		element.blur();
	}
	function toggleDoNotShowAgain(evt) {
		// If checked this changes the text of the Hide Messages link
		// to "Hide And Don't Show Again"
        var element = evt.target || evt.srcElement;
		var text = '';
		if (element.checked) {
			text = langVar('lang_stats.btn.hide_and_do_not_show_again');
		}
		else {
			text = langVar('lang_stats.btn.hide_messages');
		}
		util.updateT('before_you_start:hide_btn', text);
	}
	function hideBeforeYouStartSection(evt) {
		// If don't show again is checked set appropriate system node
		if (util.getF('before_you_start:do_not_show_again')) {
			var url = '?dp=util.set_and_save_node';
			var dat = 'v.fp.active_page=' + pageInfo.page;
			dat += '&v.fp.page_token=' + pageInfo.pageToken;
			dat += '&v.fp.main_node_name=system';
			dat += '&v.fp.new_nodes.show_before_you_start_info.profiles=false';
			util.serverPost(url, dat);
		}
		util.hideE('before_you_start:panel');
	}
	// Return global properties and methods
	return {
		init: init,
		createNewProfile: createNewProfile,
		handleDeleteProfileCompleted: handleDeleteProfileCompleted,
		handleNewProfile: handleNewProfile,
		handleNewProfilesDb: handleNewProfilesDb,
		getProfileData: getProfileData,
		getProfileDataResponse: getProfileDataResponse,
//		scrollingList: scrollingList,
		getProfilesDb: getProfilesDb,
		getProfileItem: getProfileItem,
		createFilteredProfilesList: createFilteredProfilesList,
		closeNewProfileWizardWindow: closeNewProfileWizardWindow,
		editViewClosed: editViewClosed,
		profilesDashboardDataUpdated: profilesDashboardDataUpdated,
		getIsEditViewActive: getIsEditViewActive,
		toggleProfilesFilterResponse: toggleProfilesFilterResponse
	};
}());
YAHOO.util.Event.onDOMReady(profiles.init);
