// tools.js
/* global profilesStorage: false */
var tools = (function() {
	'use strict';
	var YE = YAHOO.util.Event,
		busyPanel = null,
		clearCachesPanel = null;
	function init() {
		busyPanel =  new util.BusyPanel();
		YE.addListener('tools:clear_caches_btn', 'click', _confirmClearCaches);
		YE.addListener('tools:update_web_files_btn', 'click', updateWebFiles);
		// Init the clearCachesPanel
		var panelObj = {
			panelId: 'tools:confirm_clear_caches_panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.tools.clear_caches'),
			left: 80,
			top: 100,
			zIndex: 100,
			isCover: true,
			closeEvent: _cancelClearCaches
		};
		clearCachesPanel = new util.Panel3(panelObj);
		YE.addListener('tools:clear_caches_ok_btn', 'click', _clearCaches);
		YE.addListener('tools:clear_caches_cancel_btn', 'click', _cancelClearCaches);
		_setButtons(true);
		util.showE('form_section');
	}
	function _setButtons(isEnabled) {
		util.enableE('tools:clear_caches_btn', isEnabled);
		util.enableE('tools:update_web_files_btn', isEnabled);
	}
	function _confirmClearCaches() {
		clearCachesPanel.open();
	}
	function _cancelClearCaches() {
		clearCachesPanel.close();
	}
	function _clearCaches() {
		// This clears the profiles in local storage
		// and server side caches such as profiles_cache
		// and WebServerRoot caches.
		_setButtons(false);
//		util.updateT('tools:clear_caches_status', '');
		clearCachesPanel.close();
		busyPanel.showCustom(langVar('lang_admin.tools.clearing_caches'));
		// Clear local storage
		profilesStorage.reset();
		// Clear server side caches
		var url = '?dp=admin_pages.tools.clear_caches';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
	function clearCachesResponse() {
		busyPanel.stop();
		// New login is required after clearing all caches.
		// Show login page
		location.href = '?dp=login';
	}
	function updateWebFiles() {
		_setButtons(false);
		util.updateT('tools:update_web_files_status', '');
		busyPanel.showCustom(langVar('lang_admin.tools.updating_web_files'));
		var url = '?dp=admin_pages.tools.update_web_files';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
	function updateWebFilesResponse() {
		busyPanel.stop();
		util.updateT('tools:update_web_files_status', 'Updating web files completed.');
		_setButtons(true);
	}
	return {
		init: init,
		clearCachesResponse: clearCachesResponse,
		updateWebFilesResponse: updateWebFilesResponse
	};
}());
YAHOO.util.Event.onDOMReady(tools.init);
