//
// js
//
var fileManager = (function() {
	// pathnameElementId specifies the input field
	// from where the file manager has been opened.
	// The id is required to read and set the field value
	// The following two variables are defined in the template
	// UPDATE - HAS BEEN MOVED TO pageInfo
	// pathnameElementId: '', // The element of the pathname field from which the file manager has been initiated.
	// defaultPathname: '', // Any default pathname given in the input element defined by pathnameElementId.
	/*
	drive and directory object
		{
			id: i:0,		// the integer(s) in the id define the depth and index of the directory in the items array
			lb: '_dat',		// label
			pn: 'C:\_dat',	// pathname
			isDir: false, 	// Is directory or drive
			nDir: -1, 		// number of all subdirectories, regardless if loaded, -1 means that we don't know the actual number yet
			numOfFiles: -1, // number of all files, regardless if loaded, -1 means that we don't know the actual number yet
			dirs: [], 		// loaded subdirectories, partial loading possible
			files: [], 		// loaded files, partial loading possible
			isExp: false 	// if item is expanded, the property is added when building the tree
		}
	file object as in files array:
		{
			id: i:0:1:5		// the integer(s) in the id define the depth and index of the directory in the items array
			lb: '_dat',		// label
			pn: 'C:\_dat',	// pathname
			sz: 330 K, 		// size as string,
		}
			OLD PROPERTIES
			,
			type: 'dir' 	// drive | directory | file
			isLoaded: false, 	// isLoaded defines if any subitems (located in items array of this object) have
								// already been loaded.
								// isLoaded is also true if isEmpty is true
			items: [], 			// items with other items. An empty array means that the directory is empty
			hasSubDir: false,	// hasSubDir is true if this item has any subdirectories
			isEmpty: false,		// isEmpty is true if the drive or directory has no content
	*/
	var YE = YAHOO.util.Event,
	    YD = YAHOO.util.Dom,
        directoryFilesListTable = null,
        scrollControl = new scrollUtil.Scroller('directory_files_list:container', 'directory_files_list:table', scrollingFileItemsList);
	var GD = {
		 // fileManagerSessionId is used when caching directories
		 // and files on server side. When loading i.e. files 500-1000
		 // then we can use the cached files node.
		fileManagerSessionId: '',
		rootItemId: 'directory_tree:root', // Note, the root list element id is "tree:li:directory_tree:root"
		defaultPathname: '', // The defaultPathname from pageInfo or from mapDrive
		defaultPathnameStructure: [],
		isMapDriveCallee: false,
		// isInvalidDefaultPathname: false, // isInvalidDefaultPathname is set upon getDefinedDirectoryResponse().
											// When we then load the root directories we know that we have to
											// show an alert for the invalid default pathname.
		bottomDirectoryItemId: '', // bottomDirectoryItemId is used upon defined pathnames for final directory selection
		// Hierarchical directory structure [{}, {}, {}, ...]
		dirs: {
			// root items
			nDir: -1,
			dirs: []
		},
		selectedTreeItem: {}, // A reference to the selected tree item object;
		selectedTreeItemId: '', // i.e. 'i:1:5', itemId of selected directory in left panel
		selectedListItemId: '', // i.e. 'i:1:5', itemId of selected directory or file in right panel
		selectedListItem: { // selected directory or file in right panel
			elementId: '',
			itemId: '',
			isDirectory: false
		},
		// list state (right panel)
		listState: {
		    initDirsComplete: false,
            numOfBuiltFiles: 0
			// builtComplete: false // all directories and files are build
		},
		initialLoadingCompleted: false,
		isLoading: false // Set to true while loading directories
	};
	function init() {
		// alert('init');
		// util.showObject(pageInfo);
		// Set fileManagerSessionId
		var d = new Date();
		GD.fileManagerSessionId = 'i' + d.getTime();
		// Set the panels size
		setSize();
        directoryFilesListTable = util.getE('directory_files_list:table');
		YE.addListener('file_manager:ok_btn', 'click', setPathnameInOpener);
		YE.addListener('file_manager:cancel_btn', 'click', close);
		if (pageInfo.isWindows) {
			YE.addListener('file_manager:map_drive_btn', 'click', mapDrive.open);
			util.showEV('file_manager:map_drive_btn');
		}
		YE.addListener(window, 'resize', setSize);
		YE.addListener('directory_tree:container', 'click', directoryTreeActor);
		YE.addListener(directoryFilesListTable, 'click', listActor);
		// Show loading bar
		util.showE('file_manager:loading_bar');
		if (pageInfo.defaultPathname == '') {
			getRootDirectories();
		}
		else {
			var isMapDriveCallee = false;
			getDefinedDirectory(pageInfo.defaultPathname, isMapDriveCallee);
		}
		// getDirectoryContents(pageInfo.defaultPathname);
	}
	function setPathnameInOpener() {
		var isDirectory = true;
		var itemId = '';
		if (GD.selectedListItem.itemId !== '') {
			itemId = GD.selectedListItem.itemId;
			isDirectory = GD.selectedListItem.isDirectory;
		}
		else {
			itemId = GD.selectedTreeItemId;
		}
		// var itemId = (GD.selectedListItemId != '') ? GD.selectedListItemId : GD.selectedTreeItemId;
		if (itemId != '') {
			var item = isDirectory ? dirItemGetter(itemId) : fileItemGetter(itemId);
			var pathname = item.pn;
			var pathnameElementId = pageInfo.pathnameElementId;
			// util.showObject(item);
			opener.util.fileManagerWindow.setPathnameValue(pathnameElementId, pathname);
			window.close();
		}
		else {
			alert(langVar('lang_admin.file_manager.no_directory_or_file_selected_message'));
		}
	}
	function close() {
		window.close();
	}
	function setIsLoading(isLoading) {
		GD.isLoading = isLoading;
		if (GD.initialLoadingCompleted) {
			util.showE('file_manager_header_bar:loading_text', isLoading);
		}
		else {
			if (!isLoading) {
				// run this only once after initial data are loaded
				util.hideE('file_manager:loading_bar');
				util.showEV('file_manager_header_bar:select_dir_or_file_text');
				util.showEV('file_manager_header_bar:dirs_and_file_numbers');
				GD.initialLoadingCompleted = true;
			}
		}
		util.disableE('file_manager:ok_btn', isLoading);
		if (pageInfo.isWindows) {
			util.disableE('file_manager:map_drive_btn', isLoading);
		}
	}
	function getRootDirectories() {
		setIsLoading(true);
		// console.log('getRootDirectories()');
		var url = '?dp=file_manager.get_root_directories';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
	function getRootDirectoriesResponse(dat) {
		// console.log('getRootDirectoriesResponse()');
		// util.showObject(dat, 'getRootDirectoriesResponse()');
		var dirs = dat.dirs;
		var parentId = 'i';
		setItemsDefaultParameters(parentId, dirs);
		GD.dirs.nDir = dat.nDir;
		GD.dirs.dirs = dirs;
		buildTree(GD.rootItemId, GD.dirs.dirs);
		// Show root tree element and and set isLoading
		util.showEV('directory_panel');
		setIsLoading(false);
	}
	function getDefinedDirectory(defaultPathname, isMapDriveCallee) {
		// This handles a default pathname to which the tree should
		// expand automatically.
		// The function is also called from mapDrive.js!
		// So we may need to cleanup any existing items in the response function!
		// alert('getDefinedDirectory() - defaultPathname: ' + defaultPathname);
		// console.log('getDefinedDirectory()');
		GD.defaultPathname = defaultPathname;
		GD.isMapDriveCallee = isMapDriveCallee;
		setIsLoading(true);
		var url = '?dp=file_manager.get_defined_directory';
		var pathname = defaultPathname.replace(/\\/g, '__HexEsc__5C');
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.pathname=' + encodeURIComponent(pathname);
		util.serverPost(url, dat);
	}
	function getDefinedDirectoryResponse(dat) {
		// util.showObject(dat, 'getDefinedDirectoryResponse()');
		// console.log('getDefinedDirectoryResponse()');
		// Clean directory tree and list from any existing items.
		// (Items could exist if getDefinedDirectory() has been
		// initiated by mapDrive.js!
		if (GD.isMapDriveCallee) {
			util.removeChildElements('tree:li:directory_tree:root');
			util.removeChildElements(directoryFilesListTable);
		}
		//
		// Create the fresh root items
		//
		var dirs = dat.dirs;
		var parentId = 'i';
		setItemsDefaultParameters(parentId, dirs);
		GD.dirs.nDir = dat.nDir;
		GD.dirs.dirs = dirs;
		buildTree(GD.rootItemId, GD.dirs.dirs);
		if (dat.isValidPathname) {
			GD.defaultPathnameStructure = dat.defaultPathnameStructure;
			if (GD.defaultPathnameStructure.length > 0) {
				expandRootDirToDefaultPathname(GD.dirs);
			}
			else {
				util.showEV('directory_panel');
			}
			//
			// Handle the defined tree items
			//
			/*
			if (dat.treeStructure.length > 0) {
				var treeStructureItemIndex = 0;
				createTreeFromDefinedPathname(GD.items, dat.treeStructure, treeStructureItemIndex);
				// Select bottom directory
				if (GD.bottomDirectoryItemId != '') {
					// alert('handle bottomDirectoryItemId: ' + GD.bottomDirectoryItemId);
					// util.showObject({'handle bottomDirectoryItemId':GD.bottomDirectoryItemId});
					var bottomItem = dirItemGetter(GD.bottomDirectoryItemId);
			*/
					// handleActivatedTreeItem(bottomItem, /* isImageActor */ false , /* isAnchorActor */ true);
					/*
				}
			}
			// Show root tree and isLoading
			util.showE('tree:ul:' + GD.rootItemId);
			setIsLoading(false);
			*/
		}
		else {
			var msg = '';
			if (!GD.isMapDriveCallee) {
				// Invalid default pathname.
				msg = langVar('lang_admin.file_manager.invalid_path_message');
				msg = msg.replace(/__PARAM__1/, GD.defaultPathname);
			}
			else {
				// Map drive did not succeed
			    msg = langVar('lang_admin.file_manager.invalid_path_message');
				msg = msg.replace(/__PARAM__1/, GD.defaultPathname);
			}
			util.showEV('directory_panel');
			setIsLoading(false);
			alert(msg);
		}
	}
	function expandRootDirToDefaultPathname(itemToExpand) {
		// Auto-expand the root directory to the default pathname
		// console.log('expandRootDirToDefaultPathname()');
		var defaultPathnameStructure = GD.defaultPathnameStructure;
		// Get and remove the last item in defaultPathnameStructure,
		// which is the item we need to expand, respectively
		// get the directories for it.
		var lastItem = defaultPathnameStructure.pop();
		// util.showObject(lastItem, 'expandRootDirToDefaultPathname() - the last item');
		var type = lastItem.type;
		var pathname = lastItem.pathname;
		// console.log('expandRootDirToDefaultPathname() - process pathname: ' + pathname);
		var isWindows = pageInfo.isWindows;
		if (isWindows) {
			if (type === 'directory') {
				// Windows pathnames are case insensitive, convert them to lowercase
				// before comparing pathnames.
				pathname = pathname.toLowerCase();
			}
			else { // type is drive
				pathname = getNormalizedDriveName(pathname);
			}
		}
		// Check for dirs in case that directories have been deleted on server
		var dirs = (itemToExpand.dirs !== null) ? itemToExpand.dirs : [];
		var numDirsItems = dirs.length;
		var pathnameExists = false;
		for (var i = 0; i < numDirsItems; i++) {
			var dirItem = dirs[i];
			var dirItemPathname = dirItem.pn;
			if (isWindows) {
				if (dirItem.isDir) {
					dirItemPathname = dirItemPathname.toLowerCase();
				}
				else {
					dirItemPathname = getNormalizedDriveName(dirItemPathname);
				}
			}
			if (pathname === dirItemPathname) {
				// alert('Got pathname: ' + pathname);
				// Get the directories for the found pathname
				// If this is the path which beccomes selected
				// then also load the files for it.
				var autoExpandRootDirActive = true;
				var loadDirectories = true;
				var loadFiles = defaultPathnameStructure.length === 0;
				getDirectoryItems(dirItem, loadDirectories, loadFiles, autoExpandRootDirActive);
				pathnameExists = true;
				break;
			}
		}
		if (!pathnameExists) {
			// The pathname does not anymore exist
			// ToDo, exit expand, should we show a warning?
			alert('expandRootDirToDefaultPathname() - did not find pathname: ' + pathname);
			// Show the panel
			util.showEV('directory_panel');
			// util.showObject(itemToExpand, 'did not find the pathname: ' + pathname);
		}
	}
	function getDirectoryItems(item, loadDirectories, loadFiles, autoExpandRootDirActive/* optional */) {
		autoExpandRootDirActive = (typeof autoExpandRootDirActive == "undefined") ? false : autoExpandRootDirActive;
		// console.log('getDirectoryItems()');
		//
		// Lock user interactions
		//
		setIsLoading(true);
		var url = '?dp=file_manager.get_directory_items';
		var pathname = item.pn;
		pathname = pathname.replace(/\\/g, '__HexEsc__5C');
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.file_manager_session_id=' + GD.fileManagerSessionId + '&';
		dat += 'v.fp.item_id=' + encodeURIComponent(item.id) + '&';
		dat += 'v.fp.load_directories=' + loadDirectories + '&';
		dat += 'v.fp.load_files=' + loadFiles + '&';
		dat += 'v.fp.auto_expand_root_dir_active=' + autoExpandRootDirActive + '&';
		dat += 'v.fp.pathname=' + encodeURIComponent(pathname);
		util.serverPost(url, dat);
	}
	function getDirectoryItemsResponse(dat) {
		// util.showObject(dat, 'getDirectoryItemsResponse()');
		// console.log('getDirectoryItemsResponse()');
		var itemId = dat.itemId;
		var item = dirItemGetter(itemId);
		var autoExpandRootDirActive = dat.autoExpandRootDirActive;
		// console.log('getDirectoryItemsResponse() - autoExpandRootDirActive: ' + autoExpandRootDirActive);
		if (dat.isValidPathname) {
			if (dat.loadDirectories) {
				item.nDir = dat.nDir;
				item.dirs = dat.dirs;
				// console.log("getDirectoryItemsResponse() - number of directory items: " + item.nDir);
				if (item.nDir > 0) {
					setItemsDefaultParameters(itemId, item.dirs);
					// add directory items
					buildTree(itemId, item.dirs);
					// Make parent expanded
					makeTreeItemExpanded(item, false);
				}
			}
			if (dat.loadFiles) {
				item.numOfFiles = dat.numOfFiles;
				item.files = dat.files;
				// console.log("getDirectoryItemsResponse() - number of file items: " + item.numOfFiles);
				setItemsDefaultParameters(itemId, item.files);
			}
			// util.showObject(item);
			if (!autoExpandRootDirActive) {
				// Update list in right panel
				if (GD.selectedTreeItemId == itemId) {
					initListItemsDisplay(item);
				}
				setIsLoading(false);
			}
			else {
				// Auto expand to next directory
				if (GD.defaultPathnameStructure.length > 0) {
					expandRootDirToDefaultPathname(item);
				}
				else {
					// Got to last directory, nothing to load anymore
					// make item the selected item
					autoScrollToExpandedItem(itemId);
					makeTreeItemSelected(item);
					util.showEV('directory_panel');
					setIsLoading(false);
				}
			}
		}
		else {
			var msg = langVar('lang_admin.file_manager.pathname_is_not_anymore_valid_msg');
			msg = msg.replace(/__PARAM__1/, item.pathname);
			alert(msg);
			setIsLoading(false);
		}
	}
	//
	//
	//
	// File loading
	//
	//
	//
	function reviewScrollControlAfterAddingFiles(isMoreFilesToAdd) {
        // This is called right after files have been added.
        if (isMoreFilesToAdd) {
            // Check if we add files right away or if we wait
            // for the scrollControl to fire scrollingFileItemsList()
            var scrollInfo = scrollControl.getScrollInfo();
            if (scrollInfo.isScrollingDown &&
                scrollInfo.verticalScrollLevel > 80) {
                // Don't wait for the next scroll event,
                // fire the scroll handler right away.
//              console.log('reviewScrollControlAfterAddingFiles() - fired scroll handler manually');
                scrollingFileItemsList(scrollInfo.verticalScrollLevel);
            }
            else {
                // Let scrollControl fire the scroll handler
//                console.log('reviewScrollControlAfterAddingFiles() - waiting for next scroll event');
                scrollControl.restartListening();
            }
        }
        else {
            scrollControl.deactivate();
        }
    }
    function scrollingFileItemsList(verticalScrollLevel) {
        // Fired when scrolling down or after adding files.
        // Add already loaded files or start loading files
        var item = GD.selectedTreeItem,
            numOfFiles = item.numOfFiles,
		    numOfLoadedFiles = item.files.length,
		    numOfBuiltFiles = GD.listState.numOfBuiltFiles,
            maxFiles = 0,
            indexFrom = numOfBuiltFiles,
            indexTo = 0,
            isMoreFilesToAdd = false;
        if (numOfLoadedFiles > numOfBuiltFiles) {
//            console.log('scrollingFileItemsList() - adding already loaded files');
            // Add already loaded files
            // Temp, try generating all files!
            // and show Loading icon while generating the files
            // maxFiles = 80;
            // maxFiles = 80;
            // indexTo = indexFrom + maxFiles;
            indexTo = numOfLoadedFiles - 1;
            if ((indexTo + 1) > numOfFiles) {
                indexTo = numOfFiles - 1;
            }
            if ((numOfLoadedFiles -1) < indexTo) {
                // Not all files are loaded,
                // just build the files we already have
                indexTo = numOfLoadedFiles -1;
            }
//          console.log('---> Adding loaded files, no new loading of files required');
            addItemsToBuildFileItemsList(item.files, indexFrom, indexTo);
            isMoreFilesToAdd = ((numOfFiles - 1) > indexTo);
            reviewScrollControlAfterAddingFiles(isMoreFilesToAdd);
        }
        else {
            // Load files from server
            // Get maxFiles depending on numOfFiles and
            // verticalScrollLevel.
            maxFiles = parseInt((numOfFiles / 1000) * verticalScrollLevel);
//          console.log('scrollingFileItemsList() - get files from server maxFiles raw: ' + maxFiles);
            if (maxFiles <= 0) {
                maxFiles = 5;
            }
            else if (maxFiles > 500) {
                maxFiles = 500;
            }
            indexTo = indexFrom + maxFiles;
            // Don't get more files than numOfFiles
            if ((indexTo + 1) > numOfFiles) {
                indexTo = numOfFiles - 1;
            }
            getFileItems(item, indexFrom, indexTo);
        }
    }
	function getFileItems(item, indexFrom, indexTo) {
		var url = '?dp=file_manager.get_file_items',
		    pathname = item.pn,
            dat = '';
		// Show loading
		util.showE('file_manager_header_bar:loading_text');
        util.showE('file_manager:files_loading_bar');
        pathname = pathname.replace(/\\/g, '__HexEsc__5C');
        dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.file_manager_session_id=' + GD.fileManagerSessionId;
		dat += '&v.fp.item_id=' + encodeURIComponent(item.id);
		dat += '&v.fp.pathname=' + encodeURIComponent(pathname);
		dat += '&v.fp.index_from=' + indexFrom;
		dat += '&v.fp.index_to=' + indexTo;
		util.serverPost(url, dat);
	}
	function getFileItemsResponse(dat) {
		// util.showObject(dat, 'getFileItemsResponse()');
		var itemId = dat.itemId,
            filesToAdd = dat.filesToAdd,
            indexFrom = dat.indexFrom,
            indexTo = dat.indexTo,
		    item = GD.selectedTreeItem,
            isMoreFilesToAdd = false;
		// Hide loading
		util.hideE('file_manager_header_bar:loading_text');
        util.hideE('file_manager:files_loading_bar');
		if (itemId === item.id) {
			// Append the loaded files
			// Set defaults
			setItemsDefaultParameters(itemId, filesToAdd, indexFrom);
			// Add filesToAdd in files
			item.files = item.files.concat(filesToAdd);
			// util.showObject(item, 'item after adding files from pos indexFrom ' + indexFrom);
            // Check what to do next before adding the new files.
            isMoreFilesToAdd = ((item.numOfFiles - 1) > indexTo);
            reviewScrollControlAfterAddingFiles(isMoreFilesToAdd);
            // Add the just loaded items
            addItemsToBuildFileItemsList(item.files, indexFrom, indexTo);
		}
	}
	//
	//
	//
	// Select functions
	//
	//
	//
	function directoryTreeActor(evt) {
		// Initiated upon click on directory tree image or text
		// Possible states/actions
		// - Expand directory with subdirectories (click on image, no selection)
		// - Collapse directory with subdirectories (click on image, no selection)
		// - Expand and select directory with subdirectories (click on label, becomes selected)
		// - Select directory without subdirectories (click on image or label, becomes selected)
		// - Extend the subdirectories list, yet more directories to load (ToDo)
		// Note, reselecting an item means to get fresh contents of the given item.
		if (!GD.isLoading) {
			var element = evt.target || evt.srcElement;
			var elementId = element.id;
			// console.log('directoryTreeActor() elementId: ' + elementId);
			var isImageClick = (elementId.indexOf(':img:actor:') != -1);
			var isAnchorClick = (elementId.indexOf(':a:actor:') != -1);
			var makeExpanded = false;
			var makeSelected = false;
			if (isImageClick || isAnchorClick) {
				// alert('directoryTreeActor() - elementId: ' + elementId);
				// Get the item
				var item = dirItemGetter(elementId);
				var nDir = item.nDir;
				var hasSubdirs = nDir !== 0;
				var isExp = item.isExp;
				//console.log('directoryTreeActor() item.isExp: ' + item.isExp);
				if (isExp && isImageClick) {
					// Already expanded, collapse it when click on image
					collapseTreeItem(item);
				}
				else {
					makeExpanded = hasSubdirs && !isExp;
					makeSelected = isAnchorClick;
					expandTreeItem(item, hasSubdirs, makeExpanded, makeSelected);
				}
			}
		}
	}
	function expandTreeItem(item, hasSubdirs, makeExpanded, makeSelected) { // New
		// Expand and/or select a directory item
		//console.log('expandTreeItem()');
		//console.log('expandTreeItem() - makeExpanded: ' + makeExpanded);
		//console.log('expandTreeItem() - makeSelected: ' + makeSelected);
		var itemId = item.id;
		var selectedTreeItemId = GD.selectedTreeItemId;
		var loadDirectories = false;
		var loadFiles = false;
		// var updateListPanel = false;
		// If not already selected or if semi-selected
		if (itemId !== selectedTreeItemId ||
			GD.selectedListItem.itemId !== '') {
			if (makeExpanded) {
				loadDirectories = item.nDir === -1;
				makeTreeItemExpanded(item, loadDirectories);
			}
			if (makeSelected) {
				loadFiles = item.numOfFiles === -1;
				makeTreeItemSelected(item);
			}
			if (loadDirectories || loadFiles) {
				// Load the directories && or files
				getDirectoryItems(item, loadDirectories, loadFiles);
			}
		}
		else {
			// directory is alrady selected
			// 	if has subdirectories and is collapsed then simply expand
			// 	else do nothing
			if (hasSubdirs && !item.isExp) {
				makeTreeItemExpanded(item, false);
			}
		}
	}
	function makeTreeItemExpanded(item, loadDirectories) {
		//console.log('makeTreeItemExpanded()');
		var itemId = item.id;
		// Show animated icon if loadDirectories is true!
		var directoryImage = util.getE('tree:img:actor:' + itemId);
		if (!loadDirectories) {
			directoryImage.src = imgDb.fmCollapseDir.src;
		}
		else {
			directoryImage.src = imgDb.fmCollapseDirBusy.src;
		}
		// Show the ul element if it already exists
		var subDirsEl = util.getE('tree:ul:' + itemId);
		if (subDirsEl != null) {
			subDirsEl.style.display = 'block';
		}
		item.isExp = true;
	}
	function collapseTreeItem(item) { // New
		// Collapse a directory with subdirectories
		// Check if any subdirectory is displayed in the list,
		// if yes, then we have to clear the list and select
		// and show the list for the collapsed item.
		//console.log('collapseTreeItem()');
		var itemId = item.id;
		directoryImage = util.getE('tree:img:actor:' + itemId);
		directoryImage.src = imgDb.fmExpandDir.src;
		util.hideE('tree:ul:' + itemId);
		item.isExp = false;
		var selectedTreeItemId = GD.selectedTreeItemId;
		// Check if a child item of the current item is selected.
		// We can do that with the itemId. If the current itemId
		// is i.e. "i:0:1:2" and the already selected itemId starts
		// with the same string, i.e. "i:0:1:2:3" then we know that
		// we have to move the child child selection to the current
		// item.
		if (itemId != selectedTreeItemId &&
			selectedTreeItemId.indexOf(itemId + ':') !== -1) {
			// Move selection to current item, even if not yet loaded
			// selectDirectoryItem(itemId, item.items);
			var loadFiles = item.numOfFiles === -1;
			makeTreeItemSelected(item);
			if (loadFiles) {
				// Load the files, directories already exist
				var loadDirectories = false;
				getDirectoryItems(item, loadDirectories, loadFiles);
			}
		}
	}
	function makeTreeItemSelected(item) { // New
		// This selects the tree item name
		//console.log('makeTreeItemSelected()');
		var itemId = item.id,
            anchorElement = util.getE('tree:a:actor:' + itemId);
		// Clear all selections
		clearAllSelectedItems();
		// ToDo, add animation to tree item ????
		// Select the item
		anchorElement.className = 'active';
		GD.selectedTreeItem = item;
		GD.selectedTreeItemId = itemId;
        initListItemsDisplay(item);
	}
	function clearAllSelectedItems() {
		// Clears any selected item and clears the items list in right pane
		if (GD.selectedTreeItemId != '') {
			var anchorElement = util.getE('tree:a:actor:' + GD.selectedTreeItemId);
			anchorElement.className = '';
			GD.selectedTreeItemId = '';
		}
		// Simply reset selectedListItemId because the list is cleared anyway
		// GD.selectedListItemId = '';
		GD.selectedListItem.elementId = '';
		GD.selectedListItem.itemId = '';
		// Reset state
		GD.listState.initDirsComplete = false;
		GD.listState.numOfBuiltFiles = 0;
		// Remove all items from the list
        util.removeChildElements(directoryFilesListTable);
        // Set focus on list so that it scrolls to top
        // directory_panel must be visible in IE before
        // applying focus!
        var directoryPanelElement = util.getE('directory_panel');
        if (directoryPanelElement.style.visibility === 'visible') {
            directoryFilesListTable.focus();
        }
	}
	function deselectListItem() {
		// deselects any selected item in right panel
		var item = GD.selectedListItem;
		if (item.elementId != '') {
			var element = util.getE(item.elementId);
			element.className = '';
		}
	}
	function listActor(evt) {
		// Initiated if a list item is clicked
		if (!GD.isLoading) {
			var element = evt.target || evt.srcElement;
			var elementId = element.id;
			//console.log('listActor() - elementId: ' + elementId);
			// if (elementId.indexOf('list:a:actor:i:') != -1) {
			if (elementId.indexOf('list_a:') != -1) {
				// Deselect any selected list item
				deselectListItem();
				var substringIndex = elementId.lastIndexOf('i:');
				var itemId = elementId.substring(substringIndex);
				// alert('listActor() - itemId: ' + itemId);
				// GD.selectedListItemId = itemId;
				GD.selectedListItem.elementId = elementId;
				GD.selectedListItem.itemId = itemId;
				GD.selectedListItem.isDirectory = elementId.indexOf('list_a:dir') !== -1;
				element.className = 'active';
				// Make the selected directory item semi-selected
				var activeTreeElement = util.getE('tree:a:actor:' + GD.selectedTreeItemId);
				activeTreeElement.className = 'semi-active';
				// Note that selectedTreeItemId and selectedListItemId have now a value.
				// Upon Okay we first check for a selectedListItemId and use that one to get
				// the pathname, else we use the selectedTreeItemId for the pathname.
			}
		}
	}
	function dirItemGetter(itemElementIdOrItemId) {
		// get directory item
		var isDirectoryItem = true;
		return itemGetter(itemElementIdOrItemId, isDirectoryItem);
	}
	function fileItemGetter(itemElementIdOrItemId) {
		// get file item
		var isDirectoryItem = false;
		return itemGetter(itemElementIdOrItemId, isDirectoryItem);
	}
	function itemGetter(itemElementIdOrItemId, isDirectoryItem) {
		// Get a reference to the array item of itemElementIdOrItemId
		// itemElement is in the format "tree:img:actor:d:0:1:3"
		// itemId is in the format "i:0:1:3" for drives and directories
		// Get a string with the numbers only
		var substringIndex = itemElementIdOrItemId.lastIndexOf('i:');
		var cleanedUpString = itemElementIdOrItemId.substring(substringIndex + 2);
		//console.log('itemGetter() - cleanedUpString: ' + cleanedUpString);
		var dat = cleanedUpString.split(':');
		var depth = dat.length;
		//console.log('itemGetter() - dat: ' + dat);
		//console.log('itemGetter() - depth: ' + depth);
		// Note, we assume no files in the root tree, so isDirectoryItem
		// is not relevant iun the root dirs
		var item = GD.dirs.dirs[parseInt(dat[0], 10)]; // item in root tree
		// Loop down to the item if item is not in root tree
		if (depth > 1) {
			for (var i = 1; i < depth; i++) {
				var itemIndex = parseInt(dat[i], 10);
				// if isDirectoryItem or not last depth
				if (isDirectoryItem ||
					i < (depth - 1)) {
					item = item.dirs[itemIndex];
				}
				else {
					// Get the file item
					item = item.files[itemIndex];
					// util.showObject(item, 'This should be a file item');
				}
			}
		}
		// util.showObject(item, 'The item we got via itemGetter()');
		return item;
	}
	//
	//
	// Create tree from defined pathname functions
	//
	//
	function createTreeFromDefinedPathnameFixIds(parentItemId, items) {
		for (var i = 0; i < items.length; i++) {
			var item = items[i];
			item.id = parentItemId + ':' + i;
		}
	}
	function fixPathnameOfTypeDrive(pathname) {
		// Returns a clean drivename on Windows systems.
		// This problem is supposed to exist only in Windows and it is only a problem for pre-defined pathnames!
		// There are differences of how we get the drive between C++  get_directory_contents() and get_file_info(),
		// once we get it with a trailing backslash and once not.
		// I.e. we may get "c:" and "C:\"
		if (pageInfo.isWindows) {
			pathname = pathname.toUpperCase();
			var lastChar = pathname.substring(pathname.length - 1);
			if (lastChar != '\\') {
				pathname += '\\';
			}
		}
		return pathname;
	}
	function createTreeFromDefinedPathname(items, treeStructure, treeStructureItemIndex) {
		// At this point the rootItems are already build.
		// treeStructure contains each subtree with invalid
		// item Id's. All item Ids needs to be fixed to present
		// the tree depth.
		var item;
		var itemId;
		var itemType;
		var itemPathname;
		var treeItem = treeStructure[treeStructureItemIndex];
		var treeItemType = treeItem.type;
		var treeItemPathname = treeItem.pathname;
		var isWindows = pageInfo.isWindows;
		if (isWindows) {
			// Windows pathnames are case insensitive, so we need to convert them before
			// we check the pre-defined path with itemPathname's
			treeItemPathname = treeItemPathname.toLowerCase();
		}
		// util.showObject({'treeItemPathname 1':treeItemPathname});
		// var itemHasSubDir;
		// var itemIsEmpty;
		// var isImageActor = true;
		// var isAnchorActor = false;
		// Track the last itemId of drive or directory
		// var bottomDirectoryItemId = '';
		if (treeItemType == 'drive') {
			treeItemPathname = fixPathnameOfTypeDrive(treeItemPathname);
		}
		// alert('treeItemType: ' + treeItemType + '\ntreeItemPathname: ' + treeItemPathname);
		if (treeItemType != 'file') { // is not the last item
			for (var i = 0; i < items.length; i++) {
				item = items[i];
				itemType = item.type;
				// util.showObject(item, 'OK I');
				if (itemType != 'file') {
					itemPathname = item.pathname;
					// alert('itemPathname: ' + itemPathname);
					if (isWindows) {
						itemPathname = itemPathname.toLowerCase();
					}
					if (itemType == 'drive') {
						itemPathname = fixPathnameOfTypeDrive(itemPathname);
					}
					// alert('itemPathname: ' + itemPathname);
					// util.showObject({itemPathname:itemPathname, treeItemPathname:treeItemPathname});
					if (itemPathname == treeItemPathname) {
						// We found the item where we insert the items of the treeStructure item
						// alert('found pathname: ' + treeItemPathname);
						itemId = item.id;
						GD.bottomDirectoryItemId = itemId; // We remember this itemId for final directory item selection
						// Insert the items from the treeStructure item
						item.items = treeItem.items;
						// Fix the iserted item Ids
						createTreeFromDefinedPathnameFixIds(itemId, item.items);
						// Mark this item as loaded
						item.isLoaded = true;
						// Build the subdirectries
						if (item.hasSubDir) {
							// build the items
							buildTree(itemId, item.items);
							// expand the items (Set isImageActor to true so that the right pane directory list is not affected)
							handleActivatedTreeItem(item, /* isImageActor */ true , /* isAnchorActor */ false);
							// item.isExpanded = true;
						}
						// Check if there are other items in the treeStructure,
						// if yes recursively call createTreeFromDefinedPathname.
						if (treeStructureItemIndex < (treeStructure.length - 1)) {
							createTreeFromDefinedPathname(item.items, treeStructure, treeStructureItemIndex + 1);
						}
						// Exit the loop because we found the item
						break;
					}
				}
			}
		}
		// alert('Handle bottomDirectoryItemId selection: ' + bottomDirectoryItemId);
	}
	//
	//
	// Builder functions
	//
	//
	function buildTree(parentItemId, dirs) {
		// Default display style is none
		//console.log('buildTree()');
		var ulId = 'tree:ul:' + parentItemId;
		var ul = util.createE('ul', {id:ulId, display:'block'});
		var numDirs = dirs.length;
		for (var i = 0; i < numDirs; i++) {
			var item = dirs[i];
			buildTreeItem(ul, item);
		}
		var parentListElement = util.getE('tree:li:' + parentItemId);
		parentListElement.appendChild(ul);
	}
	function buildTreeItem(ul, item) {
		// The item is a drive or directory
		var itemId = item.id;
		var label = item.lb;
		var itemHasSubDirs = item.nDir !== 0;
		// Don't make the list item an actor because the li element would also fire upon white space on the left!
		// Beside that a list item has nested lists!
		// So only image and anchor elements become actors upon which an action is taken when clicking the element.
		var liId = 'tree:li:' + itemId;
		var li = util.createE('li', {id:liId});
		var imgRef = itemHasSubDirs ? imgDb.fmExpandDir : imgDb.fmOpenDir;
		var imgId = 'tree:img:actor:' + itemId;
		var img = util.createE('img', {id:imgId, src:imgRef.src, width:imgRef.width, height:imgRef.height, alt:''});
		var aId = 'tree:a:actor:' + itemId;
		var a = util.createE('a', {id:aId, href:'javascript:;'});
		var aText = util.createT(label);
		util.chainE(ul, [li, img, [a, aText]]);
	}
	//
	//
	// Directories and files in right panel
	//
	//
	function initListItemsDisplay(item) {
        // Initializes the list item display.
        // This function may be called twice when directories
        // are already loaded but files are just loading.
        // So we track if directories are already initialized.
        // This is not called when loading additional files.
//        console.log('initListItemsDisplay()');
        var numOfDirs = item.nDir,
            numOfFiles = item.numOfFiles,
            tbodyDirs = null,
            tbodyFiles = null,
            listState = GD.listState,
            isLoading = false,
            numOfLoadedFileItems = 0,
            numOfFileItemsToBuild = 0,
            numOfDirsText = '0',
            numOfFilesText = '0',
            numOfBuiltFilesText = '0';
            maxFiles = 500;
        // Deactivate scrollControl
        scrollControl.deactivate();
		if (numOfDirs === 0 && numOfFiles === 0) {
			// No dirs and no files
			createEmptyList();
            isLoading = false;
            listState.initDirsComplete = true;
		}
		else {
			// util.showObject(item, 'initListItemsDisplay()');
			if (numOfDirs === -1) {
                // This must be loading state.
                // Don't know the number of subdirectories,
                // so we don't know about files either.
                isLoading = true;
                numOfDirsText = '?';
                numOfFilesText = '?';
            }
            else {
                if (!listState.initDirsComplete) {
                    if (numOfDirs > 0) {
                        // Build all directory rows at once
                        buildItemsList(item.dirs, numOfDirs, true);
                    }
                    listState.initDirsComplete = true;
                }
                numOfDirsText = numOfDirs;
                // Initialize files if any and loaded.
                if (numOfFiles !== -1) {
                    if (numOfFiles > 0) {
                       // Don't build all files, even if loaded
                       // because building too many files makes the
                       // GUI less responsive. Build/load more files while
                       // scrolling down.
                       numOfLoadedFileItems = item.files.length;
                       numOfFileItemsToBuild = (numOfLoadedFileItems > maxFiles) ? maxFiles : numOfLoadedFileItems;
                       buildItemsList(item.files, numOfFileItemsToBuild, false);
                       listState.numOfBuiltFiles = numOfFileItemsToBuild;
                       if (numOfFileItemsToBuild < numOfFiles) {
                           scrollControl.activate();
                       }
                        numOfBuiltFilesText = numOfFileItemsToBuild;
                    }
                    numOfFilesText = numOfFiles;
                }
                else {
                    numOfFilesText = '?';
                    isLoading = true;
                }
            }
		}
        util.updateT('file_manager:number_of_dirs', numOfDirsText);
        util.updateT('file_manager:number_of_files', numOfFilesText);
        // Show loading
        util.showE('file_manager:files_loading_bar', isLoading);
	}
	function createEmptyList() {
		// Empty directory
        var tbody = util.createE('tbody'),
		    tr =  util.createE('tr'),
		    td =  util.createE('td'),
            text = util.createT(langVar('lang_admin.file_manager.no_directory_or_files_info'));
		util.chainE(directoryFilesListTable, tbody, tr, td, text);
	}
	function buildItemsList(items, numOfItemsToBuild, isDirectory) {
		//console.log('buildItemsList() - isDirectory: ' + isDirectory);
        // directoryFilesListTable, tbodyDirs,
		var item,
            i,
            tbody = util.createE('tbody');
		for (i = 0; i < numOfItemsToBuild; i++) {
			item = items[i];
			buildItemsListItem(tbody, item, isDirectory);
		}
        util.chainE(directoryFilesListTable, tbody);
	}
    function addItemsToBuildFileItemsList(items, indexFrom, indexTo) {
        var item,
            i,
            tbody = util.createE('tbody');
        for (i = indexFrom; i <= indexTo; i++) {
            item = items[i];
            buildItemsListItem(tbody, item, false);
        }
        util.chainE(directoryFilesListTable, tbody);
        // Update listState
        GD.listState.numOfBuiltFiles = indexTo + 1;
        // util.updateT('file_manager:number_of_built_files', indexTo + 1);
     }
	function buildItemsListItem(tbody, item, isDirectory) {
		var tr = util.createE('tr');
		var imgRef = isDirectory ? imgDb.fmDirectory : imgDb.fmFile;
		var tdImage = util.createE('td', {width:imgRef.width + 'px', paddingLeft:0, paddingRight:0});
		// tdImage.style.width = imgRef.width + ''; // KHP-RC createE() does not support width property or there is some conflict with image width!
		var tdLabel = util.createE('td');
		var tdSize = util.createE('td');
		var img = util.createE('img', {src:imgRef.src, width:imgRef.width, height:imgRef.height, alt:''});
		var idPrefix = isDirectory ? 'list_a:dir' : 'list_a:fil';
		var aId = idPrefix + ':' + item.id;
		var a = util.createE('a', {id:aId, href:'javascript:;'});
		var label = util.createT(item.lb);
		var sizeText = isDirectory ? '&nbsp;' : item.sz;
		var size = util.createT(sizeText);
		util.chainE(tbody, [tr, [tdImage, img], [tdLabel, [a, label]], [tdSize, size]]);
	}
	//
	//
	// Misc utilities
	//
	//
    function setSize() {
        // Set directory tree and list height
        var viewportHeight = YD.getViewportHeight();
        var headerRegion = YD.getRegion('file_manager_header');
        var height = (viewportHeight - headerRegion.height - 5) + 'px';
		// Set loading bar position
		var loadingBarElement = util.getE('file_manager:loading_bar');
		loadingBarElement.style.top = headerRegion.height + 'px';
		// Set file loading bar position
		var filesListRegion = YD.getRegion('directory_files_list:container');
		var filesLoadingBarElement = util.getE('file_manager:files_loading_bar');
		filesLoadingBarElement.style.top = headerRegion.height + 'px';
		filesLoadingBarElement.style.left = filesListRegion.left + 'px';
		// Set tree and list element size
        var treeElement = util.getE('directory_tree:container');
        var listElement = util.getE('directory_files_list:container');
        treeElement.style.height = height;
        listElement.style.height = height;
    }
	function setItemsDefaultParameters(parentId, items, j /* optional*/) {
		// dirs or files have just been loaded
		// add the id and other default parameters
		//console.log('setItemsDefaultParameters()');
		// j is only defined when applied to additional files
		// which are loaded on demand, they don't start at 0 but
		// at the given j.
		j = (typeof j == "undefined") ? 0 : j;
		var numItems = items.length;
		if (numItems > 0) {
			// Check if this is a directory
			var isDirectory = items[0].sz == null; // sz (size) property only exists in files
			//console.log('setItemsDefaultParameters() - isDirectory: ' + isDirectory);
			for (var i = 0; i < numItems; i++, j++) {
				var item = items[i];
				item.id = parentId + ':' + j;
				if (isDirectory) {
					item.isExp = false;
				}
			}
		}
		// util.showObject(numItems, 'setItemsDefaultParameters() - DONE');
	}
	function getNormalizedDriveName(pathname) {
		// Returns a clean drivename (call this only if isWindows).
		// This problem is supposed to exist only in Windows
		// and it is only a problem when using default pathnames
		// because there are differences of how we get the drive between C++,
		// get_directory_contents() and get_file_info(),
		// once we get it with a trailing backslash and once not.
		// I.e. we may get "c:", "C:", "c:\" or "C:\"
		pathname = pathname.toUpperCase();
		var lastChar = pathname.substring(pathname.length - 1);
		if (lastChar != '\\') {
			pathname += '\\';
		}
		return pathname;
	}
	function autoScrollToExpandedItem(itemId) {
		// directory_tree:container
		//console.log('autoScrollToExpandedItem');
		var container = YD.getRegion('directory_tree:container');
		// var treeContainerBottom = treeContainderRegion.bottom;
		var itemRegion = YD.getRegion('tree:a:actor:' + itemId);
		var itemBottom = itemRegion.bottom;
		// util.showObject(itemRegion);
		// Scroll to given item if it is not visible within
		// the upper two thirds of the container element.
		var aThirdContainerHeight = container.height / 3;
		var yDelta = itemRegion.bottom - container.bottom + aThirdContainerHeight;
		if (yDelta > 0) {
			// Scroll to expanded/selected item
			// var scrollHeight = hiddenHeight + (container.height / 3);
			var attributes = {
				scroll: {to:[0, yDelta]}
			};
			var anim = new YAHOO.util.Scroll('directory_tree:container', attributes, 0.1);
			anim.animate();
		}
	}
	//
	//
	// Return global properties and methods
	//
	//
	return {
		init: init,
		getRootDirectoriesResponse: getRootDirectoriesResponse,
		getDefinedDirectory: getDefinedDirectory, // Called from mapDrive!
		getDefinedDirectoryResponse: getDefinedDirectoryResponse,
		getDirectoryItemsResponse: getDirectoryItemsResponse,
		getFileItemsResponse: getFileItemsResponse,
		scrollingFileItemsList: scrollingFileItemsList
	}
}());
//
// mapDrive.js
//
var mapDrive = {
	panel: null,
	validator: null,
	defaultPathname: '',
	init: function() {
		var YE = YAHOO.util.Event;
		var panelObj = {
			panelId:"map_drive:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.file_manager.map_drive_label'),
			right: 30,
			top: 20,
			width: 640,
			zIndex: 20,
			isCover: true,
			closeEvent: mapDrive.close
		};
		mapDrive.panel = new util.Panel3(panelObj);
		mapDrive.validator = new util.Validator();
		YE.addListener(['map_drive:drive_btn', 'map_drive:connect_to_password_protected_btn'], 'click', mapDrive.toggleNetworkShare);
		YE.addListener('map_drive:ok_btn', 'click', mapDrive.apply);
		YE.addListener('map_drive:cancel_btn', 'click', mapDrive.close);
	},
	open: function() {
		if (!mapDrive.panel) {
			mapDrive.init();
		}
		mapDrive.toggleNetworkShare();
		mapDrive.hideFileManagerOverflow(true);
		mapDrive.panel.open();
	},
	close: function() {
		mapDrive.validator.reset();
		mapDrive.hideFileManagerOverflow(false);
		mapDrive.panel.close();
	},
	toggleNetworkShare: function() {
		var isDrive = util.getF('map_drive:drive_btn');
		mapDrive.validator.reset();
		util.showE(['map_drive:drive_sample:tr', 'map_drive:drive:tr', 'map_drive:warning'], isDrive);
		util.showEV(['map_drive:username_otional_label', 'map_drive:password_otional_label'], isDrive);
	},
	apply: function() {
		var validator = mapDrive.validator;
		validator.reset();
		var isDrive = util.getF('map_drive:drive_btn');
		var obj = {};
		obj.is_drive = isDrive;
		obj.drive = isDrive ? validator.isValue('map_drive:drive') : '';
		obj.share = validator.isValue('map_drive:share');
		obj.username = isDrive ? util.getF('map_drive:username') : validator.isValue('map_drive:username');
		obj.password = isDrive ? util.getF('map_drive:password') : validator.isValue('map_drive:password');
		if (validator.allValid()) {
			//
			// Set un-escaped default pathname for response
			//
			mapDrive.defaultPathname = isDrive ? obj.drive : obj.share;
			//
			// Send form data
			//
			var url = '?dp=file_manager.map_drive';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			var pattern = /\\/g;
			for (var prop in obj) {
				var datValue = obj[prop];
				if (pattern.test(datValue)) {
					datValue = datValue.replace(/\\/g, '__HexEsc__5C');
				}
				dat += 'v.fp.' + prop + '=' + encodeURIComponent(datValue) + '&';
			}
			dat = dat.replace(/&$/, '');
			util.serverPost(url, dat);
		}
	},
	applyResponse: function() {
		// alert('applyResponse()');
		mapDrive.close();
		var isMapDriveCallee = true;
		fileManager.getDefinedDirectory(mapDrive.defaultPathname, isMapDriveCallee);
	},
	hideFileManagerOverflow: function(isHide) {
		// Fixes Firefox overflow problem (no focus cursor in forms above div's if overflow is scroll or auto).
		var div1 = util.getE('directory_tree:container');
		var div2 = util.getE('directory_files_list:container');
		var overflowValue = isHide ? 'hidden' : 'scroll';
		div1.style.overflow = overflowValue;
		div2.style.overflow = overflowValue;
	}
};
