//
// logFiltersUtil.js
// 
//
var logFiltersUtil = {
	filterType: {
		toggleDisplay: function() {
			// Invoked by select element only
			var filterType = util.getF('log_filters:type');
			logFiltersUtil.filterType.setDisplay(filterType);
		},
		updateDisplay: function(filterType) {
			util.setF('log_filters:type', filterType);
			logFiltersUtil.filterType.setDisplay(filterType);
		},
		setDisplay: function(filterType) {
			// Reset any errors
			logFilters.validator.reset();
			util.hideE('log_filters:structured:error'); // resets any structured filter error
			var isExpression = (filterType == 'expression');
			util.showE('log_filters:expression:section', isExpression);
			util.showE('log_filters:structured:section', !isExpression);
			logFilters.activeFilterType = filterType;
		}
	},
	boolOperator: {
		setSectionDisplay: function(numberOfConditionalItems) {
			// We show the boolean operator section if there is more than one condition in the list
			// alert('boolOperator.updateDisplay(): ' + numberOfConditionalItems);
			var showSection = (numberOfConditionalItems > 1);
			util.showE('log_filters:boolean_operator:section', showSection);
		},
		toggleOperator: function() {
			var operator = util.getF('log_filters:boolean_operator');
			logFiltersUtil.boolOperator.setOperatorDisplay(operator);
		},
		setOperatorDisplay: function(operator) {
			var isCustomOperator = (operator == 'custom');
			util.showEV('log_filters:boolean_operator_sequence:example', isCustomOperator);
			util.showE('log_filters:boolean_operator_sequence:section', isCustomOperator);
		}
	},
	boolOperatorSequence: {
		getSequenceLetterByItemNumber: function(itemNumber) {
			// KHP-RC, if itemNumber is greater letter sequence length then get the right letter, i.e. AA, BB
			var theLetter = logFilters.sequenceLettersDb[itemNumber];
			// alert('getSequenceLetterByItemNumber - itemNumber: ' + itemNumber + '\ntheLetter: ' + theLetter);
			return theLetter;
		},
		validate: function(sequence, numberOfConditionItems) {
			// Returns the object "obj"
			/*
			var obj = {
				sequence: '', // A cleaned-up representation of the sequence to be saved in items dat
				isError: false,
				errorMsg: ''
			}
			*/
			var i;
			var cleanedUpSequence = '';
			var boolOrWord = logFilters.boolOrWord;
			var boolAndWord = logFilters.boolAndWord;
			var numberOfOpeningBraces = 0;
			var numberOfClosingBraces = 0;
			var numberOfOperators = 0;
			var invalidLetters = []; // Tracks any invalid letter
			/*
			Create a letterState object where we look up the letters in the sequence
			and where we track the number of found letters. We can use this object
			to check if the sequence has duplicate letters.
			letterState = {
				_A = 0 // We count the occurance of each found letter
				_B = 0
				_C = 0
				_D = 0
			}
			*/ 
			var sequenceLettersDb = logFilters.sequenceLettersDb;
			var letterState = {};
			for (i = 0; i < numberOfConditionItems; i++) {
				var theEscapedLetter = '_' + util.getRepetitionSequenceLetter(sequenceLettersDb, i);
				letterState[theEscapedLetter] = 0;
			}
			// util.showObject(letterState);
			// alert('boolOperatorSequence in original language: ' + sequence);
			// Replace all braces with a space so that we can split the sequence
			sequence = sequence.replace(/\(/g, ' ( ');
			sequence = sequence.replace(/\)/g, ' ) ');
			// alert('sequence after we replaced braces with spaces: ' + sequence);
			var sequenceSplit = sequence.split(' ');
			// alert('sequence after split: ' + sequenceSplit);
			for (i = 0; i < sequenceSplit.length; i++) {
				var sequenceItem = sequenceSplit[i];
				if (sequenceItem != '') {
					// alert('sequenceItem: "' + sequenceItem + '"');
					switch (sequenceItem) {
						case '(':
							cleanedUpSequence += '(';
							numberOfOpeningBraces++;
							break;
						case ')':
							cleanedUpSequence += ')';
							numberOfClosingBraces++;
							break;
						case boolOrWord: 
							cleanedUpSequence += ' ' + boolOrWord + ' ';
							numberOfOperators++;
							break;
						case boolAndWord: 
							cleanedUpSequence += ' ' + boolAndWord + ' ';
							numberOfOperators++;
							break;
						default:
							// This must be an item letter
							var escapedSequenceItem = '_' + sequenceItem;
							if (letterState[escapedSequenceItem] != null) {
								cleanedUpSequence += sequenceItem;
								// alert('letter found: "' + escapedSequenceItem + '"');
								// The letter is valid.
								// Count the occurence of this letter in letterState
								letterState[escapedSequenceItem] = letterState[escapedSequenceItem] + 1;
							}
							else {
								// This must be an invalid letter
								// alert('letter not found: "' + escapedSequenceItem + '"');
								invalidLetters[invalidLetters.length] = sequenceItem;
							}
							break;
					}
				}
			}
			// util.showObject(letterState);
			/*
			alert('invalidLetters: ' + invalidLetters);
			var tempS = 'ValidationInfo:';
			tempS += '\nnumberOfOpeningBraces: ' + numberOfOpeningBraces;
			tempS += '\nnumberOfClosingBraces: ' + numberOfClosingBraces;
			tempS += '\nnumberOfOperators: ' + numberOfOperators;
			alert(tempS);
			*/
			//
			//
			// Check for any errors in validation variables
			//
			//
			var isError = false;
			var errorMsg = langVar('lang_admin.log_filters.invalid_bool_operator_sequence') + ' ';
			if (invalidLetters.length > 0) {
				isError = true;
				// errorMsg += 'The letter "' + invalidLetters + '" is not a valid sequence letter.';
				errorMsg += langVar('lang_admin.log_filters.invalid_sequence_letter_msg');
				errorMsg = errorMsg.replace(/__PARAM__1/, invalidLetters);
			}
			else if (numberOfOpeningBraces != numberOfClosingBraces) {
				isError = true;
				errorMsg += langVar('lang_admin.log_filters.invalid_number_of_braces');
			}
			else if (numberOfOperators > 1 && numberOfOpeningBraces == 0) {
				isError = true;
				errorMsg += langVar('lang_admin.log_filters.no_braces_defined_msg');
			}
			else if (numberOfOperators != (numberOfConditionItems - 1)) {
				isError = true;
				errorMsg += langVar('lang_admin.log_filters.invalid_number_of_bool_operators_msg');
			}
			else {
				// Check for valid letters
				var missingLetters = '';
				var duplicateLetters = '';
				for (var prop in letterState) {
					var numberOfLetterItems = letterState[prop];
					if (numberOfLetterItems < 1) {
						missingLetters += prop.replace(/_/, '') + ', ';
					}
					else if (numberOfLetterItems > 1) {
						duplicateLetters += prop.replace(/_/, '') + ', ';
					}
				}
				if (missingLetters != '') {
					isError = true;
					missingLetters = missingLetters.replace(/,\s$/, '');
					// errorMsg += 'The letter "' + missingLetters + '" is missing.';
					errorMsg += langVar('lang_admin.log_filters.missing_sequence_letter_msg');
					errorMsg = errorMsg.replace(/__PARAM__1/, missingLetters);
				}
				if (duplicateLetters != '') {
					isError = true;
					duplicateLetters = duplicateLetters.replace(/,\s$/, '');
					// errorMsg += 'The letter "' + duplicateLetters + '" is a duplicate.';
					errorMsg += langVar('lang_admin.log_filters.duplicate_sequence_letter_msg');
					errorMsg = errorMsg.replace(/__PARAM__1/, duplicateLetters);
				}
			}
			var obj = {
				sequence: cleanedUpSequence,
				isError: isError,
				errorMsg: errorMsg
			}
			return obj;
		},
		convertNumericalToLetterFormat: function(numberOfConditions, numericalSequence) {
			var boolOrWord = logFilters.boolOrWord;
			var boolAndWord = logFilters.boolAndWord;
			var sequenceLettersDb = logFilters.sequenceLettersDb;
			// Replace all English ' or ' words with the local language ' or ' words
			var letterSequence = numericalSequence.replace(/\sor\s/g, ' ' + boolOrWord + ' ');
			// Replace all English ' and ' words with the local language ' and ' words
			var letterSequence = letterSequence.replace(/\sand\s/g, ' ' + boolAndWord + ' ');
			for (var i = 0; i < numberOfConditions; i++) {
				var numericalPresentation = '__IntEsc__' + i + '__'; // i.e. "__IntEsc__0__"
				var numericalPresentationPattern = new RegExp(numericalPresentation);
				var letterPresentation = util.getRepetitionSequenceLetter(sequenceLettersDb, i);				
				letterSequence = letterSequence.replace(numericalPresentationPattern, letterPresentation);
			}
			// alert('letterSequence: ' + letterSequence);
			return letterSequence;
		},
		convertLetterToNumericalFormat: function(numberOfConditions, letterSequence) {
			var sequenceLettersDb = logFilters.sequenceLettersDb;
			var orPattern = new RegExp(' ' + logFilters.boolOrWord + ' ', 'g');
			var andPattern = new RegExp(' ' + logFilters.boolAndWord + ' ', 'g');
			var numericalSequence = '';
			numericalSequence = letterSequence.replace(orPattern, ' or ');
			numericalSequence = numericalSequence.replace(andPattern, ' and ');
			//
			// Convert the letters to numbers
			// Note, we must start conversion with higher numbers
			// so that i.e. "AA" becomes converted prior "A"
			for (var i = numberOfConditions - 1; i >= 0; i--) {
				var theLetter = util.getRepetitionSequenceLetter(sequenceLettersDb, i);	
				var theLetterPattern = new RegExp(theLetter);
				numericalSequence = numericalSequence.replace(theLetterPattern, '__IntEsc__' + i + '__');
			}
			// alert('numericalSequence: ' + numericalSequence);
			return numericalSequence;
		}
	},
	//
	// Log fields list utilities
	//
	populateFullLogFieldsList: function(elementId, addSelectOption) {
		// Populates the given Select Element with log field items
		logFiltersUtil.populateLogFieldsList(elementId, addSelectOption, true, true);
	},
	populateStringLogFieldsList: function(elementId, addSelectOption) {
		// Populates the given Select Element with log field items of type string
		logFiltersUtil.populateLogFieldsList(elementId, addSelectOption, true, false);
	},
	populateLogFieldsList: function(elementId, addSelectOption, isStringFields, isNumericalFields) {
		var logFields = [];
		if (isStringFields && isNumericalFields) {
			logFields = logFilters.logFieldsDb;
		}
		else if (isStringFields) {
			logFields = logFilters.logFieldsOfTypeStringDb;
		}
		if (addSelectOption) {
			var selectOptionDb = [{name:'', label:langVar('lang_admin.log_filters.select_log_field')}];
			util.populateSelect(elementId, selectOptionDb, 'name', 'label');
			util.extendSelect(elementId, logFields, 'name', 'label');
		}
		else {
			util.populateSelect(elementId, logFields, 'name', 'label');
		}
	},
	fixDivOverflow: function(isFix) {
		// Firefox has a problem with the underlying filter item div's.
		// The problem is caused by the div overflow setting where form fields
		// above the div don't anymore show focus on form fields. We solve this
		// by setting the div overflow to 'hidden' while a subform is open.
		var element = util.getE('log_filters:structured:list:div');
		element.style.overflow = isFix ? 'hidden' : 'scroll';
	}
};
//
// logFilters.js
//
var logFilters = {
	theList: null,
	// actionsList: null,
	// actionsMoveControl: null,
	boolOrWord: '', // the boolean OR word, it is always lowercase
	boolAndWord: '', // // the boolean AND word, it is always lowercase
	sequenceLettersDb: [], // Array with sequence letters ['A','B','C', ...], sequence letters are always uppercase
	conditionOperatorsDb: {},
	conditionOperatorLabelsDb: {}, // Created from conditionOperatorsDb for quick label lookup
	logFieldsDb: [], // Contains all log fields (string, int, float)
	logFieldsOfTypeStringDb: [], // Contains log fields of type string
	itemsDb: [],  // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	validator: null,
	// mainButtons;
	saveLogFiltersBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	newAlternativeActionBtn: null,
	noItemFormIsActive: false,
	structuredItemsMoveControlIsPositioned: false,
	//
	// active form data
	//
	activeFilterType: '', // structured || expression, the active filter type in display
	activeLabelOri: '', // Only used to transfer the variable into new object
	activeComment: '', // keeps active item comment (original or modified)
	activeCommentOri: '' // Only used to transfer the variable into new object
};
function init() {
	var YE = YAHOO.util.Event;
	var i;	
	// Create conditionOperatorLabelsDb
	var conditionOperatorsDb = logFilters.conditionOperatorsDb;
	var conditionOperatorLabelsDb = {};
	for (var prop in conditionOperatorsDb) {
		var operators = conditionOperatorsDb[prop];
		for (i = 0; i < operators.length; i++) {
			conditionOperatorLabelsDb['_' + operators[i].name] = operators[i].label;
		}
	}
	logFilters.conditionOperatorLabelsDb = conditionOperatorLabelsDb;
	// util.showObject(logFilters.conditionOperatorLabelsDb);
	// Create logFieldsOfTypeStringDb
	var logFieldsDb = logFilters.logFieldsDb;
	var logFieldsOfTypeStringDb = [];
	for (i = 0; i < logFieldsDb.length; i++) {
		var item = logFieldsDb[i];
		if (item.dbFieldType == 'string') {
			logFieldsOfTypeStringDb[logFieldsOfTypeStringDb.length] = {name:item.name, label:item.label};
		}
	}
	logFilters.logFieldsOfTypeStringDb = logFieldsOfTypeStringDb;
	logFilters.validator = new util.Validator();
	//
	// init toolbar buttons and form controls
	//
	logFilters.saveLogFiltersBtn = new util.ToolbarButton('save_changes', saveLogFilters, toolbarButtonsDb);		
	logFilters.newItemBtn = new util.ToolbarButton('new_log_filter', newItem, toolbarButtonsDb);
	logFilters.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	logFilters.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	logFilters.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	// Create theList object
	logFilters.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		isSwitch1: true,
		isMoveControl: true
	});
	// Add events
	YE.addListener('log_filters:label', 'keyup', updateListAndFormLabel);
	YE.addListener('log_filters:structured:new_condition_btn', 'click', logFilterCondition.newItem);
	YE.addListener('log_filters:structured:new_action_btn', 'click', logFilterAction.newActionItem);
	// YE.addListener('log_filters:structured:new_alternative_action_btn', 'click', logFilterAction.newAlternativeActionItem);
	// New Alternative Action must be a command link which can be enabled/disabled
	var commandLinkOptions = {
		classNameEnabled: 'command-link-50',
		classNameDisabled: 'command-link-50-disabled'
	};	
	logFilters.newAlternativeActionBtn = new util.CommandLink('log_filters:structured:new_alternative_action_btn', logFilterAction.newAlternativeActionItem, true, commandLinkOptions);
	YE.addListener('log_filters:type', 'change', logFiltersUtil.filterType.toggleDisplay);
	YE.addListener('log_filters:boolean_operator', 'change', logFiltersUtil.boolOperator.toggleOperator);
	YE.addListener(['log_filters:comment:add_edit_btn_1', 'log_filters:comment:add_edit_btn_2'], 'click', editComment);
	YE.addListener('log_filters:view_log_fields:view_btn', 'click', logFilterExpressionFields.open);
	YE.addListener('log_filters:view_log_fields:view_examples_btn', 'click', util.helpWindow.openGeneralHelp);
	//
	// Ignore/Disable buttons according RBAC
	//
	var permissions = pageInfo.permissions;
	if (permissions.isEdit) {
		if (!permissions.isAdd) {
			logFilters.newItemBtn.disableAndIgnore();
			logFilters.duplicateBtn.disableAndIgnore();
		}
		if (!permissions.isDelete) {
			logFilters.deleteBtn.disableAndIgnore();
		}
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		logFilters.saveLogFiltersBtn.disableAndIgnore();
		logFilters.newItemBtn.disableAndIgnore();
		logFilters.duplicateBtn.disableAndIgnore();
		logFilters.deleteBtn.disableAndIgnore();
		logFilters.undoAllChangesBtn.disableAndIgnore();
	}
	//
	// init structured filter lists
	//
	logFilterLists.init();
	// init view available log fields and log filter comment
	logFilterExpressionFields.init(logFilters.logFieldsDb);
	logFilterComment.init(updateCommentDisplay);
}
function initMainDisplay() {
	util.hideE(['form_section', 'loading_info', 'saving_info']);
	var firstItemId = logFilters.theList.getFirstItemId();
	if (firstItemId != null) {
		setItem(firstItemId);
		displayNoItemForm(false);
	}
	else {
		// no item exists
		displayNoItemForm(true);
	}
	util.showE('form_section');
}
function getLogFiltersData() {
	if (!pageInfo.exitActive) {
		// Init help
		util.helpWindow.init('');
		// invoked upon editor load
		var url = '?dp=config_pages.log_filters.get_log_filters_data';
		url += '&p=' + pageInfo.profileName;
var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}
function getLogFiltersDataResponse(dat) {
	// alert('getLogFiltersDataResponse()');
	if (!pageInfo.exitActive) {
		logFilters.boolOrWord = dat.boolOrWord;
		logFilters.boolAndWord = dat.boolAndWord;
		logFilters.sequenceLettersDb = dat.sequenceLettersDb;
		logFilters.conditionOperatorsDb = dat.conditionOperatorsDb;
		logFilters.logFieldsDb = dat.logFieldsDb;
		util.createHash(logFilters.logFieldsDb, 'name');
		var itemsDb = dat.logFiltersDb;
		// Convert any boolean_operator_sequence in itemsDb from numerical format to presentational letter format!
		for (var i = 0; i < itemsDb.length; i++) {
			var itemDat = itemsDb[i].dat;
			if (itemDat.boolOperatorSequence != '') {
				// Convert boolOperatorSequence
				var numberOfConditions = itemDat.conditions.length;
				itemDat.boolOperatorSequence = logFiltersUtil.boolOperatorSequence.convertNumericalToLetterFormat(numberOfConditions, itemDat.boolOperatorSequence);
			}
		}
		logFilters.itemsDb = itemsDb;
		logFilters.itemsDbBackup = util.cloneObject(itemsDb);
		init();
		logFilters.theList.init(itemsDb);
		initMainDisplay();
		// IE 7 requires the form_section to be displayed before setItemListSize()
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		// Set final toolbar state
		logFilters.saveLogFiltersBtn.enable();
		logFilters.undoAllChangesBtn.enable();
		logFilters.newItemBtn.enable();
		updateToolbarButtons(); // handles Duplicate and Delete
		pageInfo.initComplete = true;
	}
}
function displayNoItemForm(isDisplayNoItemForm) {
	if (isDisplayNoItemForm) {
		// util.updateT('item_form_label', '-');
		util.hideE('log_filters:form');
		util.showE('no_item_form');
	}
	else {
		util.hideE('no_item_form');
		util.showE('log_filters:form');
	}
	logFilters.noItemFormIsActive = isDisplayNoItemForm;
}
function updateToolbarButtons() {
	var isItems = logFilters.theList.isItems();
	logFilters.deleteBtn.enable(isItems);
	logFilters.duplicateBtn.enable(isItems);
}
function updateListAndFormLabel() {
	setTimeout('setListAndFormLabel()', 300);
}
function setListAndFormLabel() {
	var label = util.getF('log_filters:label');
	if (label == '') {
		label = '-';
	}
	logFilters.theList.updateListLabel(label);
}
//
//
// Items
//
//
function setItem(itemId) {
	logFilters.theList.selectItem(itemId);
	updateForm();
}
function itemActivated(itemId) {
	if (validateActiveItem()) {
		// if selected node item is valid then e to activated node item
		setItem(itemId);
	}
}
function newItem() {
	if (validateActiveItem()) {
		var newItemId = logFilters.theList.getNewItemId();
		var newLogFilterLabel = langVar('lang_admin.general.new_log_filter');
		var newFilterObj = {
			id: newItemId,
			type: '',
			switch1: true,
			label: newLogFilterLabel,
			dat: {
				type: 'structured',
				label: newLogFilterLabel,
				labelOri: '',
				comment: '',
				commentOri: '',
				expression: '',
				conditions: [],
				actions: [],
				alternativeActions: [],
				boolOperator: 'or',
				boolOperatorSequence: ''
			}
		};
		// util.showObject(newScheduleObj);
		logFilters.theList.newItem(newFilterObj);
		setItem(newItemId);
		updateToolbarButtons();
	}
}
function duplicateItem() {
	if (validateActiveItem()) {
		var theList = logFilters.theList
		var clonedItemId = theList.cloneItem();
		// Update created_by_user property
		// theList.setItemDatValue(clonedItemId, 'created_by_user', logFilters.activeUserNodeName);
		setItem(clonedItemId);
	}
}	
function deleteItem() {
	var theList = logFilters.theList;
	var nextItemIdToBeSelected = theList.deleteItem();
	if (nextItemIdToBeSelected != null) {
		// reset the validator to clear any error message of the deleted item
		logFilters.validator.reset();
		util.hideE('log_filters:structured:error'); // resets any structured filter error
		// select the next item
		setItem(nextItemIdToBeSelected);
	}
	else {
		// All items have been deleted
		displayNoItemForm(true);
		updateToolbarButtons();
	}
}
function updateForm() {
	var item = logFilters.theList.getSelectedItem();
	var itemDat = item.dat;
	// util.showObject(item);
	// Set non-editable data which are simply transferd to new object
	logFilters.activeLabelOri = itemDat.labelOri;
	logFilters.activeCommentOri = itemDat.commentOri;
	//
	// Reset form fields (don't reset entire form!)
	//
	var filterType = itemDat.type;
	var label = itemDat.label;
	if (logFilters.activeFilterType != filterType) {
		logFiltersUtil.filterType.updateDisplay(filterType);
	}
	util.setF('log_filters:label', label);
	var expression = itemDat.expression;
	// Temp structured items
	var structuredConditions = itemDat.conditions ? itemDat.conditions : [];
	var structuredActions = itemDat.actions ? itemDat.actions : [];
	var structuredAlternativeActions = itemDat.alternativeActions ? itemDat.alternativeActions : [];
	// Update the structured list and expression (so we don't need to reset them separately)
	logFilterLists.conditions.compose(structuredConditions);
	logFilterLists.actions.compose(structuredActions);
	logFilterLists.alternativeActions.compose(structuredAlternativeActions);
	// Reset logFilterLists (selectedItemIndexes)
	logFilterLists.reset();
	util.setF('log_filters:expression', expression);
	// Set/reset Boolean Operator (The section display is handled automatically through the list change notification)
	var boolOperator = itemDat.boolOperator;
	util.setF('log_filters:boolean_operator', boolOperator);
	util.setF('log_filters:boolean_operator_sequence', itemDat.boolOperatorSequence);
	logFiltersUtil.boolOperator.setOperatorDisplay(boolOperator);
	//
	// Set comment display
	//
	updateCommentDisplay(itemDat.comment);
	// Update form label
	// util.updateT('item_form_label', label);
	if (logFilters.noItemFormIsActive) {
		displayNoItemForm(false);
	}
	// Position the Lists Move Control
	if (!logFilters.structuredItemsMoveControlIsPositioned) {
		// We need to give it some time, else we don't get the right list position
		var s = 'log_filters:structured:move_control:position_reference';
		setTimeout('logFilterLists.moveControl.setPosition("' + s + '")', 250);
		logFilters.structuredItemsMoveControlIsPositioned = true;
	}
}
function validateActiveItem() {
	var theList = logFilters.theList;
	// Only validate if isEdit permission and if there are items
	if (pageInfo.permissions.isEdit && theList.isItems()) {
		var validator = logFilters.validator;
		var filterType = logFilters.activeFilterType;
		var o = {};
		o.type = filterType;
		o.label = validator.isValue('log_filters:label');
		o.label = validator.isUnique('log_filters:label', theList.getLookupItems('label'));
		o.labelOri = logFilters.activeLabelOri;
		o.comment = logFilters.activeComment;
		o.commentOri = logFilters.activeCommentOri;
		// KHP-RC, we may do this part later!
		// Note, WE NEED TO KNOW IF A STRUCTURED LIST HAS BEEN MODIFIED OR NOT
		// IF MODIFIED OR NEW THEN the expression value must be empty
		// ELSE WE KEEP THE EXISTING EXPRESSION!
		// For now we re-create the expressions on the server side for all structured
		// log filters!
		// Set defaults for structured and expression filter
		var expression = '';
		var conditions = [];
		var actions = [];
		var alternativeActions = [];
		var boolOperator = 'or';
		var boolOperatorSequence = '';
		var isValidStructuredFilter = true;
		if (filterType == 'expression') {
			expression = validator.isValue('log_filters:expression');
		}
		else {
			//
			// Validate lists
			//
			// Get the lists
			conditions = logFilterLists.conditions.getItemsClone();
			actions = logFilterLists.actions.getItemsClone();
			alternativeActions = logFilterLists.alternativeActions.getItemsClone();
			//
			// Validate boolean operator
			//
			var numberOfConditionItems = conditions.length;
			if (numberOfConditionItems > 1) {
				boolOperator = util.getF('log_filters:boolean_operator');
				if (boolOperator == 'custom') {
					// Validate custom boolean operator sequence
					boolOperatorSequence = validator.isValue('log_filters:boolean_operator_sequence');
					if (boolOperatorSequence != '') {
						// Validate the sequence
						var sequenceValidationObj = logFiltersUtil.boolOperatorSequence.validate(boolOperatorSequence, numberOfConditionItems);
						if (!sequenceValidationObj.isError) {
							// Get clean preentation of boolOperatorSequence
							boolOperatorSequence = sequenceValidationObj.sequence;
						}
						else {
							// Show custom error message
							validator.isCustom('log_filters:boolean_operator_sequence', sequenceValidationObj.errorMsg);
						}
					}
				}
			}
			//
			// Validate filter structure
			//
			var msg = '';
			if (actions.length == 0) {
				msg = langVar('lang_admin.log_filters.invalid_filter_structure_msg');
				// alert(msg);
				isValidStructuredFilter = false;
			}
			else if (alternativeActions.length > 0) {
				if (conditions.length == 0 || actions.length == 0) {
					msg = langVar('lang_admin.log_filters.invalid_filter_structure_with_alternative_msg');
					// alert(msg);
					isValidStructuredFilter = false;
				}
			}
			if (!isValidStructuredFilter) {
				util.updateT('log_filters:structured:error', msg);
				util.showE('log_filters:structured:error');
			}
		}
		if (validator.allValid() && isValidStructuredFilter) {
			o.expression = expression;
			o.conditions = conditions;
			o.actions = actions;
			o.alternativeActions = alternativeActions;
			o.boolOperator = boolOperator;
			o.boolOperatorSequence = boolOperatorSequence;
			theList.saveItem(o);
			return true;
		}
		return false;
	}
	else {
		// No item exists
		return true;
	}
}
function getConditionItemsDat(path, items) {
	var dat = '';
	for (var i = 0; i < items.length; i++) {
		var item = items[i];
		var itemPath = path + '.' + i;
		// Add position property
		dat += itemPath + '.position=' + i + '&';
		for (var prop in item) {
			var itemValue = encodeURIComponent(item[prop]);
			dat += itemPath + '.' + prop + '=' + itemValue + '&';
		}
	}
	return dat;
}
function getActionItemsDat(path, items) {
	var dat = '';
	var j;
	for (var i = 0; i < items.length; i++) {
		var item = items[i];
		var itemPath = path + '.' + i;
		var actionType = item.type;
		// Add position property
		dat += itemPath + '.position=' + i + '&';
		dat += itemPath + '.type=' + actionType + '&';
		// All actions which have a property except type have at a minimum the log_field property
		if (item.log_field) {
			dat += itemPath + '.log_field=' + encodeURIComponent(item.log_field) + '&';
			// Some actions have a literal property
			if (item.literal) {
				dat += itemPath + '.literal=' + encodeURIComponent(item.literal) + '&';
			}
			// Handle remaining action properties
			switch (actionType) {
				case 'concatenate':
					var concatenateItems = item.concatenate;
					for (j = 0; j < concatenateItems.length; j++) {
						dat += itemPath + '.concatenate.' + j  + '.is_log_field=' + concatenateItems[j].is_log_field + '&';
						dat += itemPath + '.concatenate.' + j  + '.literal=' + encodeURIComponent(concatenateItems[j].literal) + '&';
					}
					break;
				case 'copy':
					dat += itemPath + '.target_log_field=' + encodeURIComponent(item.target_log_field) + '&';
					break;
				case 'find_and_replace':
					dat += itemPath + '.literal_2=' + encodeURIComponent(item.literal_2) + '&';
					dat += itemPath + '.replace_type=' + item.replace_type + '&';
					break;
				case 'match_regexp_copy':
					var copyItems = item.copy;
					for (j = 0; j < copyItems.length; j++) {
						dat += itemPath + '.copy.' + j  + '.log_field=' + encodeURIComponent(copyItems[j].log_field) + '&';
					}
					break;
			}			
		}
	}
	return dat;
}
function saveLogFilters() {
	// check active item, if any
	if (validateActiveItem()) {
		var theList = logFilters.theList;
		var isModified = theList.getIsModified();
		// alert('isModified: ' + isModified);
		if (isModified) {
			if (pageInfo.showRebuildDbAdvice) {
				rebuildDbAdvice.open(processSaveLogFilters);
			}
			else {
				processSaveLogFilters();
			}
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}
function processSaveLogFilters(isHideRebuildDbAdviceMessage) {
	// This function may be invoked from rebuildDbAdvice.
	// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
	util.hideE('form_section');
	util.showE('saving_info');
	var itemsDb = logFilters.itemsDb;
	var setHideRebuildDbAdviceMessage = (arguments.length == 1) ? isHideRebuildDbAdviceMessage : false;
	var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
	dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
	dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
	if (itemsDb.length > 0) {
		for (var i = 0; i < itemsDb.length; i++) {
			var item = itemsDb[i];
			var itemDat = item.dat;
			var path = 'v.fp.filters.' + i;
			// Add position node, else the log filters would be saved by node order as 1,10,11, ..., 2,20,21, ...
			dat += path + '.position=' + i + '&';
			dat += path + '.label=' + encodeURIComponent(itemDat.label) + '&';
			dat += path + '.label_ori=' + encodeURIComponent(itemDat.labelOri) + '&';
			dat += path + '.comment=' + encodeURIComponent(itemDat.comment) + '&';
			dat += path + '.comment_ori=' + encodeURIComponent(itemDat.commentOri) + '&';
			dat += path + '.disabled=' + !item.switch1 + '&';
			if (itemDat.type == 'expression') {
				//
				// expression filter
				//
				dat += path + '.value=' + encodeURIComponent(itemDat.expression) + '&';
			}
			else {
				//
				// structured filter
				//
				// Note that we save the structured filter in v7 format!
				dat += path + '.value=&';
				var conditions = itemDat.conditions;
				var actions = itemDat.actions;
				var alternativeActions = itemDat.alternativeActions;
				var exprPath = path + '.expressions';
				var numberOfConditions = conditions.length;
				if (numberOfConditions > 0) {
					//
					// Type is "conditional"
					//
					var boolOperator = itemDat.boolOperator;
					var boolOperatorSequence = '';
					if (boolOperator == 'custom') {
						// Convert boolOperatorSequence letter presentation to internal numerical presentation
						boolOperatorSequence = logFiltersUtil.boolOperatorSequence.convertLetterToNumericalFormat(numberOfConditions, itemDat.boolOperatorSequence);
					}
					dat += exprPath + '.type=conditional&';
					dat += exprPath + '.boolean_operator=' + boolOperator + '&';
					dat += exprPath + '.boolean_operator_sequence=' + boolOperatorSequence + '&';
					dat += getConditionItemsDat(exprPath + '.if', conditions);
					dat += getActionItemsDat(exprPath + '.then', actions);
					if (alternativeActions.length > 0) {
						dat += getActionItemsDat(exprPath + '.else', alternativeActions);
					}
				}
				else {
					//
					// Type is "action"
					//
					dat += exprPath + '.type=action&';
					dat += getActionItemsDat(exprPath + '.do', actions);
				}
			}
		}
		dat = dat.replace(/&$/, '');
	}
	else {
		// No log filter exists
		dat += 'v.fp.filters=';
	}
	// alert(dat);
	pageInfo.saveActive = true;
	var url = '?dp=config_pages.log_filters.save_log_filters';
	url += '&p=' + pageInfo.profileName;
	util.serverPost(url, dat);
}
function processSaveLogFiltersResponse(dat) {
	// alert('saveLogFiltersResponse()');
	// return false;
	// reset isModified
	logFilters.theList.resetIsModified();
	// the saved work itemsDb becomes now the itemsDbBackup
	logFilters.itemsDbBackup = util.cloneObject(logFilters.itemsDb);
	// Update profilesListChecksum checksum
	profilesStorage.update(dat.profileChanges);
	pageInfo.saveActive = false;
	util.hideE('saving_info');
	util.showE('form_section');
}
function undoAllChanges() {
	logFilters.itemsDb = util.cloneObject(logFilters.itemsDbBackup);
	logFilters.validator.reset();
	util.hideE('log_filters:structured:error'); // resets any structured filter error
	logFilters.theList.init(logFilters.itemsDb);
	initMainDisplay();
	updateToolbarButtons();
}
function getIsModifiedPage() {
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	if (!validateActiveItem() || logFilters.theList.getIsModified()) {
		return true;
	}
	return false;
}
function updateCommentDisplay(theComment) {
	// theComment may contain HTML tags, i.e. <br />,
	// so we use innerHTML for comment display!
	var isComment = (theComment != '');
	var buttonLabel = isComment ? langVar('lang_admin.log_filters.edit_comment') : langVar('lang_admin.log_filters.add_comment');
	util.updateT('log_filters:comment:add_edit_btn_1', buttonLabel);
	util.updateT('log_filters:comment:add_edit_btn_2', buttonLabel);
	// util.updateT('log_filters:comment:display', theComment);
	var commentElement = util.getE('log_filters:comment:display');
	commentElement.innerHTML = theComment;
	util.showE('log_filters:comment:display', isComment);
	// util.showE('log_filters:comment:add_btn', !isComment);
	// util.showE('log_filters:comment:edit_btn', isComment);
	logFilters.activeComment = theComment;
}
function editComment() {
	logFilterComment.open(logFilters.activeComment);
}
//
// logFilterLists.js
//
var logFilterLists = {
	// Note, we maintain three different lists,
	// one per if, then and else statemenets
	moveControl: null,
	// list: null,
	conditions: null,
	actions: null,
	alternativeActions: null,
	// We track active list selection in selectedItemIndexes object so that we know if we need to deselect other lists
	// (only one of the three lists can have a selected row)
	selectedItemIndexes: {
		// Use list name for selectedItemIndexes properties!
		conditions: -1,
		actions: -1,
		alternativeActions: -1
	},
	// Track the number of conditionItems and actionItems so that we know
	// when to enable/disable the New Alternative Action button
	numberOfItems: {
		// Use list name for numberOfItems properties!
		conditions: 0,
		actions: 0,
		alternativeActions: 0
	},
	init: function() {
		//
		// Create the list objects
		//
		logFilterLists.moveControl = new util.MoveControl('log_filters:structured:move_control', logFilterLists.moveItem);
		var conditionsObj = {
			name: 'conditions',
			tbodyElementId: 'log_filters:structured:conditions:tbody',
			noItemText: '',
			isDefaultItem: false,
			customSequence: logFilters.sequenceLettersDb,
			listChangeNotificationFunction: logFilterLists.listChangeNotification,
			editItemFunction: logFilterCondition.editItem,
			duplicateItemFunction: logFilterCondition.duplicateItem,
			labelBuilderFunction: logFilterCondition.labelBuilder
		};
		var actionsObj = {
			name: 'actions',
			tbodyElementId: 'log_filters:structured:actions:tbody',
			noItemText: '',
			isDefaultItem: false,
			listChangeNotificationFunction: logFilterLists.listChangeNotification,
			editItemFunction: logFilterAction.editActionItem,
			duplicateItemFunction: logFilterAction.duplicateActionItem,
			labelBuilderFunction: logFilterAction.actionLabelBuilder
		};
		var alternativeActionsObj = {
			name: 'alternativeActions',
			tbodyElementId: 'log_filters:structured:alternative_actions:tbody',
			noItemText: '',
			isDefaultItem: false,
			listChangeNotificationFunction: logFilterLists.listChangeNotification,
			editItemFunction: logFilterAction.editAlternativeActionItem,
			duplicateItemFunction: logFilterAction.duplicateAlternativeActionItem,
			labelBuilderFunction: logFilterAction.alternativeActionLabelBuilder
		};
		logFilterLists.conditions = new listcontrollerB.List(conditionsObj);
		logFilterLists.actions = new listcontrollerB.List(actionsObj);
		logFilterLists.alternativeActions = new listcontrollerB.List(alternativeActionsObj);
	},
	reset: function() {
		// Called upon updateForm() in logFilters.js
		// Reset selectedItemIndex object
		var obj = logFilterLists.selectedItemIndexes;
		obj.conditions = -1;
		obj.actions = -1;
		obj.alternativeActions = -1;
		// Reset numberOfItems object
		var obj2 = logFilterLists.numberOfItems;
		obj2.conditions = 0;
		obj2.actions = 0;
		obj2.alternativeActions = 0;
	},
	listChangeNotification: function(listName, selectedItemIndex, numberOfItems) {
		// alert('logFilterLists.listChangeNotification()\nlistName: ' + listName + '\nselectedItemIndex: ' + selectedItemIndex + '\nnumberOfItems: ' + numberOfItems);
		// Called from wide item list controller upon list change
		//
		// Check if the selection state changed
		//
		var indexes = logFilterLists.selectedItemIndexes;
		if (indexes[listName] != selectedItemIndex) {
			// Selection state changed, we need to
			// a.) Update the button state
			// b.) Deselect any other list item if selected and if current selectedItemIndex is > -1
			if (selectedItemIndex > -1) {
				// Deselect any selected row in other lists
				for (var prop in indexes) {
					if (prop != listName && indexes[prop] > -1) {
						// alert('call deselectRowTEMP() for list: ' + prop);
						logFilterLists[prop].deselectRow();
						indexes[prop] = -1;
					}
				}
			}
			// alert('We set moveControl button State' + '\nlistName: ' + listName + '\nselectedItemIndex: ' + selectedItemIndex + '\nnumberOfItems: ' + numberOfItems);
			// Set button state of move control for current item
			logFilterLists.moveControl.setState(selectedItemIndex, numberOfItems);
		}
		// Update selectedItemIndexes
		indexes[listName] = selectedItemIndex;
		// Update numberOfItems
		logFilterLists.numberOfItems[listName] = numberOfItems;
		//
		// Enable/Disable New Alternative Action button
		//
		var numberOfConditions = logFilterLists.numberOfItems.conditions;
		var numberOfActions = logFilterLists.numberOfItems.actions;
		var numberOfAlternativeActions = logFilterLists.numberOfItems.alternativeActions;
		var allowAddingAlternativeActions = (numberOfConditions > 0 && numberOfActions > 0);
		logFilters.newAlternativeActionBtn.enable(allowAddingAlternativeActions);
		//
		// Display no item info
		//
		var showNoItemInfo = (numberOfConditions == 0 && numberOfActions == 0 && numberOfAlternativeActions == 0);
		util.showE('log_filters:structured:list:no_items_info', showNoItemInfo);
		//
		// Reset error display
		//
		util.hideE('log_filters:structured:error');
		//
		// Update boolean operator display
		//
		if (listName == 'conditions') {
			// Show/hide boolean operator display depending on number of conditions
			logFiltersUtil.boolOperator.setSectionDisplay(numberOfItems);
		}
		// util.showObject(indexes);
	},
	moveItem: function(direction) {
		// Invoked from moveControl
		// var direction = logFilterLists.moveControl.getMoveDirection(this.id);
		// Move item in list
		var indexs = logFilterLists.selectedItemIndexes;
		for (var prop in indexs) {
			if (indexs[prop] != -1) {
				logFilterLists[prop].moveItem(direction);
				break;
			}
		}
	}
};
//
// logFilterComment.js
//
var logFilterComment = {
	panel: null,
	saveCommentHandler: null,
	init: function(saveCommentHandlerFunction) {
		logFilterComment.saveCommentHandler = saveCommentHandlerFunction;
		var panelObj = {
			panelId: 'log_filter_comment:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.btn.comment'),
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterComment.close
		};
		logFilterComment.panel = new util.Panel3(panelObj);
		var YE = YAHOO.util.Event;
		YE.addListener('log_filter_comment:ok_btn', 'click', logFilterComment.save);
		YE.addListener('log_filter_comment:cancel_btn', 'click', logFilterComment.close);
	},
	open: function(comment) {
		// Convert <br /> tags to new line
		comment = comment.replace(/<br\s\/>/g, '\n');
		util.setF('log_filter_comment:comment', comment);
		logFilterComment.fixDivOverflow(true);
		logFilterComment.panel.open();
	},
	close: function() {
		logFilterComment.fixDivOverflow(false);
		logFilterComment.panel.close();
	},
	save: function() {
		var comment = util.getF('log_filter_comment:comment');
		// Escape newline and carriage return with <br /> tags
		comment = comment.replace(/\n/g, '<br />'); // newline
		comment = comment.replace(/\r/g, '<br />'); // carriage return
		logFilterComment.close();
		// Return to calle
		logFilterComment.saveCommentHandler(comment);
	},
	fixDivOverflow: function(isFix) {
		// Firefox has a problem with the underlying filter item div's.
		// The problem is caused by the div overflow setting where form fields
		// above the div don't anymore show focus on form fields. We solve this
		// by setting the div overflow to 'hidden' while a subform is open.
		var element = util.getE('log_filters:structured:list:div');
		// Element does not exist in logParsingFilters form, so check for element
		if (element) {
			element.style.overflow = isFix ? 'hidden' : 'scroll';
		}
	}
};
// 
// logFilterExpressionFields.js (Show avaialble log fields to be used in expressions)
// 
var logFilterExpressionFields = function() {
    // var h = util.h;
    var YE = YAHOO.util.Event;
    var GD = { // General global data
    	panel: null
    };
    function init(logFieldsDb) {
    	// Create the available expression fields list
		var availableExprFieldsDb = [];
		for (var i = 0; i < logFieldsDb.length; i++) {
			var logFieldItem = logFieldsDb[i];
			availableExprFieldsDb[i] = {label:logFieldItem.label, name:logFieldItem.name};
		}
		var viewExprFieldsObj = {
			panelId: 'view_log_filter_expression_fields:panel',
			tbodyId: 'view_log_filter_expression_fields:tbody',
			panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
			availableExpressionFieldsDb: availableExprFieldsDb
		};
		GD.panel = new AvailableExprFields(viewExprFieldsObj);
		YE.addListener('view_log_filter_expression_fields:close_btn', 'click', close);
    }
    function open() {
    	GD.panel.open();
    }
    function close() {
    	GD.panel.close();
    }
    //
	//
	// Return global properties and methods
	//
	//
	return {
       init: init,
       open: open,
       close: close
    }
}();
//
// logFilterCondition.js
//
var logFilterCondition = {
	panel: null,
	validator: null,
	//
	// Active form parameters
	//
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index
	activeOperatorListType: '', // numerical | string | dateTime --> names are equal the property name in conditionOperatorsDb object for quick access
	init: function() {
		var addSelectOption = true;
		var panelObj = {
			panelId: 'lfc:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterCondition.closePanel
		};
		var YE = YAHOO.util.Event;
		logFilterCondition.panel = new util.Panel3(panelObj);
		logFilterCondition.validator = new util.Validator();
		logFiltersUtil.populateFullLogFieldsList('lfc:log_fields_list', addSelectOption);
		// Set default operator list by resetForm()
		logFilterCondition.resetForm();
		//
		// Add events
		//
		YE.addListener('lfc:log_fields_list', 'change', logFilterCondition.selectLogFieldActor);
		YE.addListener('lfc:ok_btn', 'click', logFilterCondition.saveItem);
		YE.addListener('lfc:cancel_btn', 'click', logFilterCondition.closePanel);
	},
	selectLogFieldActor: function() {
		// Invoked by event and by updateForm()!
		var logFieldName = util.getF('lfc:log_fields_list');
		if (logFieldName != '') {
			var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
			var requiredOperatorListType = '';
			if (logFieldItem.type == 'date_time') {
				requiredOperatorListType = 'dateTime';
			}
			else if (logFieldItem.dbFieldType == 'string') {
				requiredOperatorListType = 'string';
			}
			else {
				requiredOperatorListType = 'numerical';
			}
			if (requiredOperatorListType != logFilterCondition.activeOperatorListType) {
				var operatorsDb = logFilters.conditionOperatorsDb[requiredOperatorListType];
				util.populateSelect('lfc:operator_list', operatorsDb, 'name', 'label');
				logFilterCondition.activeOperatorListType = requiredOperatorListType;
			}
		}
	},
	openPanel: function(panelLabel, item) {
		// Note, the item may be empty!
		if (!logFilterCondition.panel) {
			logFilterCondition.init();
		}
		if (!item.log_field) {
			// Reset/set initial state
			logFilterCondition.resetForm();
		}
		else {
			// this is an existing item
			logFilterCondition.updateForm(item);
		}		
		logFiltersUtil.fixDivOverflow(true);
		logFilterCondition.panel.open({label:panelLabel});
	},
	resetForm: function() {
		util.resetF('lfc:form');
		if (logFilterCondition.activeOperatorListType != 'string') {
			var stringOperators = logFilters.conditionOperatorsDb.string;
			util.populateSelect('lfc:operator_list', stringOperators, 'name', 'label');
			logFilterCondition.activeOperatorListType = 'string';
		}
	},
	updateForm: function(item) {
		util.setF('lfc:log_fields_list', item.log_field);
		// Set the right operator list by selectLogFieldActor
		logFilterCondition.selectLogFieldActor();
		// Set the operator and literal
		util.setF('lfc:operator_list', item.operator);
		util.setF('lfc:value', item.literal);
	},
	closePanel: function() {
		logFilterCondition.validator.reset();
		logFiltersUtil.fixDivOverflow(false);
		logFilterCondition.panel.close();
	},
	newItem: function() {
		// invoked from logFilters.js
		logFilterCondition.mode = 'new';
		var panelLabel = langVar('lang_admin.log_filters.new_condition');
		var newItemObj = {};
		logFilterCondition.openPanel(panelLabel, newItemObj);
	},
	editItem: function(itemIndex, item) {
		// invoked from listcontrollerB
		logFilterCondition.mode = 'edit';
		logFilterCondition.itemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.log_filters.edit_condition');
		// alert('editItem with itemIndex: ' + itemIndex);
		logFilterCondition.openPanel(panelLabel, item);
	},
	duplicateItem: function(itemIndex, item) {
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		logFilterCondition.mode = 'duplicate';
		logFilterCondition.itemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.log_filters.edit_duplicated_condition');
		logFilterCondition.openPanel(panelLabel, item);
	},
	saveItem: function() {
		// We save the item object back to the items array in listcontrollerB
		var validator = logFilterCondition.validator;
		validator.reset();
		//
		// Validate
		//
		var logFieldName = validator.isValue('lfc:log_fields_list');
		var operator = util.getF('lfc:operator_list');
		var literal = '';
		if (logFieldName != '') {
			var activeOperatorListType = logFilterCondition.activeOperatorListType;
			if (operator == 'matches_regular_expression' || operator == '!matches_regular_expression') {
				literal = validator.isRegularExpression('lfc:value');
				// alert('matches_regular_expression validation - literal: ' + literal);
			}
			else if (operator.indexOf('epoc') != -1) {
				literal = util.getF('lfc:value');
				var dateTimePattern = /^[0-3]{1}[0-9]{1}\/{1}(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec){1}\/{1}[0-9]{4}\s{1}[0-2]{1}[0-9]{1}\:{1}[0-5]{1}[0-9]{1}\:{1}[0-5]{1}[0-9]{1}$/;
				if (!dateTimePattern.test(literal)) {
					var msg = langVar('lang_admin.log_filters.invalid_date_msg');
					validator.isCustom('lfc:value', msg);
				}
			}
			else if (operator == '<now') {
				// literal value must be integer >= 1
				literal = validator.isInteger('lfc:value', 1);
			}
			else {
				// Get database field type of selected log field
				var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
				var dbFieldType = logFieldItem.dbFieldType;
				if (dbFieldType == 'int') {
					literal = validator.isInteger('lfc:value');
				}
				else if (dbFieldType == 'float') {
					literal = validator.isFloat('lfc:value');
				}
				else {
					literal = validator.isValue('lfc:value');
				}
			}
		}
		//
		// Save the item
		//
		if (validator.allValid()) {
			var obj = {};
			obj.log_field = logFieldName;
			obj.operator = operator;
			obj.literal = literal;
			// Save the item to the actions list (listcontrollerB handles save of the object)
			logFilterLists.conditions.saveItem(logFilterCondition.mode, logFilterCondition.itemIndex, obj);
			logFilterCondition.closePanel();
		}
	},
	labelBuilder: function(conditionItem) {
		// alert('logFilterCondition.labelBuilder()');
		// Invoced from listcontrollerB
		// Returns a label (with or without HTML markup)
		// util.showObject(actionItem);
		var logFieldName = conditionItem.log_field;
		var operator = conditionItem.operator;
		var literal = conditionItem.literal;
		var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
		var logFieldLabel = '';
		if (logFieldItem != null) {
			logFieldLabel = logFieldItem.label;
		}
		else {
			logFieldLabel = '[ ' + langVar('lang_admin.log_filters.unknown_log_field') + ' ]';
		}
		var operatorLabel = logFilters.conditionOperatorLabelsDb['_' + operator];
		var label = '<strong>If</strong>: ' + logFieldLabel + ' <span>' + operatorLabel + '</span> "' + literal + '"';
		return label;
	}
};
//
// logFilterActionUtil.js
//
var logFilterActionUtil = {
	initActionForm: function() {
		//
		// Populate log field lists (lists with string and numerical fields)
		//
		var allLogFieldsLists = [
			'lfa:concatenate_log_fields_list:0',
			'lfa:concatenate_log_fields_list:1',
			'lfa:concatenate_log_fields_list:2',
			'lfa:concatenate_log_fields_list:3',
			'lfa:concatenate_log_fields_list:result',
			'lfa:copy:log_fields_list:from',
			'lfa:copy:log_fields_list:to',
			'lfa:match_regexp_copy:log_field_list',
			'lfa:match_regexp_copy:log_fields_list:0',
			'lfa:match_regexp_copy:log_fields_list:1',
			'lfa:match_regexp_copy:log_fields_list:2',
			'lfa:match_regexp_copy:log_fields_list:3',
			'lfa:set:log_fields_list'
		];
		var i;
		var YE = YAHOO.util.Event;
		for (i = 0; i < allLogFieldsLists.length; i++) {
			logFiltersUtil.populateFullLogFieldsList(allLogFieldsLists[i], true);
		}
		//
		// Populate log field lists (lists with string fields only)
		//
		var stringLogFieldsLists = [
			'lfa:convert_to_lowercase:log_fields_list',
			'lfa:convert_to_uppercase:log_fields_list',
			'lfa:find_and_replace:log_fields_list'
		];
		for (i = 0; i < stringLogFieldsLists.length; i++) {
			logFiltersUtil.populateStringLogFieldsList(stringLogFieldsLists[i], true);
		}
		YE.addListener('lfa:action_list', 'change', logFilterActionUtil.setActionActor);
		YE.addListener(
			[
			'lfa:concatenate_type_list:0',
			'lfa:concatenate_type_list:1',
			'lfa:concatenate_type_list:2',
			'lfa:concatenate_type_list:3',
			],
			'change',
			logFilterActionUtil.toggleConcatenateType
		);
	},
	setActionActor: function() {
		// Invoked by select event
		var actionType = util.getF('lfa:action_list');
		logFilterActionUtil.setActionDisplay(actionType);
	},
	setActionDisplay: function(actionType) {
		var action_sections = [
			'lfa::section', // first option - Select Action
			'lfa:accept:section',
			'lfa:concatenate:section',
			'lfa:convert_to_lowercase:section',
			'lfa:convert_to_uppercase:section',
			'lfa:copy:section',
			'lfa:match_regexp_copy:section',
			'lfa:find_and_replace:section',
			'lfa:reject:section',
			'lfa:set:section'
		];
		util.hideE(action_sections);
		util.showE('lfa:' + actionType + ':section');
	},
	toggleConcatenateType: function() {
		// Toggles between value field and log fields list
		var elementId = this.id;
		var dat = elementId.split(':');
		var itemNumber = dat[2];
		var isSetToLogFieldList = (util.getF(elementId) == 'log_field');
		util.showE('lfa:concatenate_value:' + itemNumber, !isSetToLogFieldList);
		util.showE('lfa:concatenate_log_fields_list:' + itemNumber, isSetToLogFieldList);
	},
	toggleConcatenateField: function() {
		// Enables/disables additional concatenation fields
	},
	resetForm: function() {
		util.resetF('lfa:form');
		var i;
		// Reset concatenation fields
		for (var i = 0; i < 4; i++) {
			util.hideE('lfa:concatenate_log_fields_list:' + i);
			util.showE('lfa:concatenate_value:' + i);
		}
	},
	updateForm: function(item) {
		var actionType = item.type;
		util.setF('lfa:action_list', actionType);
		logFilterActionUtil.setActionDisplay(actionType);
		var i;
		switch (item.type) {
			case 'concatenate':
				var concatenateItems = item.concatenate;
				var isLogField;
				var concatenateTypeValue;
				var concatenateValueElementId;
				// util.showObject(concatenateItems);
				for (i = 0; i < concatenateItems.length; i++) {
					// util.showObject(concatenateItems[i]);
					isLogField = concatenateItems[i].is_log_field;
					concatenateTypeValue = isLogField ? 'log_field' : 'value';
					concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:' + i : 'lfa:concatenate_value:' + i;
					util.setF('lfa:concatenate_type_list:' + i, concatenateTypeValue);
					util.setF(concatenateValueElementId, concatenateItems[i].literal);
					util.showE('lfa:concatenate_log_fields_list:' + i, isLogField);
					util.showE('lfa:concatenate_value:' + i, !isLogField);
				}
				// Set result field
				util.setF('lfa:concatenate_log_fields_list:result', item.log_field);
				break;
			case 'convert_to_lowercase':
				util.setF('lfa:convert_to_lowercase:log_fields_list', item.log_field);
				break;
			case 'convert_to_uppercase':
				util.setF('lfa:convert_to_uppercase:log_fields_list', item.log_field);
				break;
			case 'copy':
				util.setF('lfa:copy:log_fields_list:from', item.log_field);
				util.setF('lfa:copy:log_fields_list:to', item.target_log_field);
				break;
			case 'match_regexp_copy':
				util.setF('lfa:match_regexp_copy:log_field_list', item.log_field);
				util.setF('lfa:match_regexp_copy:expression', item.literal);
				var copyToLogFieldItems = item.copy;
				for (i = 0; i < copyToLogFieldItems.length; i++) {
					util.setF('lfa:match_regexp_copy:log_fields_list:' + i, copyToLogFieldItems[i].log_field);
				}
				break;
			case 'find_and_replace':
				util.setF('lfa:find_and_replace:log_fields_list', item.log_field);
				util.setF('lfa:find_and_replace:find_value', item.literal);
				util.setF('lfa:find_and_replace:replace_value', item.literal_2);
				var replaceType = item.replace_type;
				util.setF('lfa:find_and_replace:' + replaceType + '_btn', true);
				break;
			case 'set':
				util.setF('lfa:set:log_fields_list', item.log_field);
				util.setF('lfa:set:value', item.literal);
				break;
		}
	}
};
//
// logFilterAction.js
//
// Covers log filter Actions (then) and Alternative Actions (else)
var logFilterAction = {
	panel: null,
	validator: null,
	//
	// Active form parameters
	//
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index
	// activeOperatorListType: '', // numerical | string | dateTime --> names are equal the property name in conditionOperatorsDb object for quick access
	isAlternativeAction: false, // defines if the current item is an action or an alternative action
	init: function() {
		var panelObj = {
			panelId: 'lfa:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterAction.closePanel
		};
		var YE = YAHOO.util.Event;
		logFilterAction.validator = new util.Validator();
		logFilterAction.panel = new util.Panel3(panelObj);
		// var addSelectOption = true;
		// logFiltersUtil.populateFullLogFieldsList('lfc:log_fields_list', addSelectOption);
		// Set default operator list by resetForm()
		// logFilterAction.resetForm();
		logFilterActionUtil.initActionForm();
		//
		// Add events
		//
		YE.addListener('lfa:ok_btn', 'click', logFilterAction.saveItem);
		YE.addListener('lfa:cancel_btn', 'click', logFilterAction.closePanel);
	},
	openPanel: function(panelLabel, item) {
		// Note, the item may be empty!
		if (!logFilterAction.panel) {
			logFilterAction.init();
		}
		// Reset the form
		logFilterActionUtil.resetForm();
		if (!item.type) {
			// Set initial state (new item)
			logFilterActionUtil.setActionDisplay('');
		}
		else {
			// this is an existing item (edit or duplicate item)
			logFilterActionUtil.updateForm(item);
		}		
		logFiltersUtil.fixDivOverflow(true);
		logFilterAction.panel.open({label:panelLabel});
	},
	closePanel: function() {
		logFilterAction.validator.reset();
		logFiltersUtil.fixDivOverflow(false);
		logFilterAction.panel.close();
	},
	//
	// New item handling
	// 
	newItem: function(panelLabel) {
		logFilterAction.mode = 'new';
		var newItemObj = {};
		logFilterAction.openPanel(panelLabel, newItemObj);
	},
	newActionItem: function() {
		// invoked from logFilters.js
		logFilterAction.isAlternativeAction = false;
		logFilterAction.newItem(langVar('lang_admin.log_filters.new_action'));
	},
	newAlternativeActionItem: function() {
		// invoked from logFilters.js
		logFilterAction.isAlternativeAction = true;
		logFilterAction.newItem(langVar('lang_admin.log_filters.new_alternative_action'));
	},
	//
	// Edit item handling
	// 
	editItem: function(itemIndex, item, panelLabel) {
		logFilterAction.mode = 'edit';
		logFilterAction.itemIndex = itemIndex;
		// alert('editItem with itemIndex: ' + itemIndex);
		logFilterAction.openPanel(panelLabel, item);
	},
	editActionItem: function(itemIndex, item) {
		// invoked from listcontrollerB
		logFilterAction.isAlternativeAction = false;
		logFilterAction.editItem(itemIndex, item, langVar('lang_admin.log_filters.edit_action'));
	},
	editAlternativeActionItem: function(itemIndex, item) {
		// invoked from listcontrollerB
		logFilterAction.isAlternativeAction = true;
		logFilterAction.editItem(itemIndex, item, langVar('lang_admin.log_filters.edit_alternative_action'));
	},
	//
	// Duplicate item handling
	//
	duplicateItem: function(itemIndex, item, panelLabel) {
		logFilterAction.mode = 'duplicate';
		logFilterAction.itemIndex = itemIndex;
		logFilterAction.openPanel(panelLabel, item);
	},
	duplicateActionItem: function(itemIndex, item) {
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		logFilterAction.isAlternativeAction = false;
		logFilterAction.duplicateItem(itemIndex, item, langVar('lang_admin.log_filters.edit_duplicated_action'));
	},
	duplicateAlternativeActionItem: function(itemIndex, item) {
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		logFilterAction.isAlternativeAction = true;
		logFilterAction.duplicateItem(itemIndex, item, langVar('lang_admin.log_filters.edit_duplicated_alternative_action'));
	},
	//
	// Save item
	//
	saveItem: function() {
		// We save the item object back to the items array in listcontrollerB
		var validator = logFilterAction.validator;
		validator.reset();
		var obj = {};
		obj.type = validator.isValue('lfa:action_list');
		switch (obj.type) {
			case 'concatenate':
				var concatenateItems = [];
				var isLogField;
				var concatenateValueElementId;
				var literal;
				// Check field 0
				isLogField = (util.getF('lfa:concatenate_type_list:0') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:0' : 'lfa:concatenate_value:0';
				literal = validator.isValue(concatenateValueElementId);
				concatenateItems[0] = {is_log_field: isLogField, literal: literal};
				// Check field 1
				isLogField = (util.getF('lfa:concatenate_type_list:1') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:1' : 'lfa:concatenate_value:1';
				literal = validator.isValue(concatenateValueElementId);
				concatenateItems[1] = {is_log_field: isLogField, literal: literal};
				// Check the optional field 2
				isLogField = (util.getF('lfa:concatenate_type_list:2') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:2' : 'lfa:concatenate_value:2';
				literal = util.getF(concatenateValueElementId);
				if (literal != '') {
					concatenateItems[2] = {is_log_field: isLogField, literal: literal};
				}
				// Check the optional field 3
				isLogField = (util.getF('lfa:concatenate_type_list:3') == 'log_field');
				concatenateValueElementId = isLogField ? 'lfa:concatenate_log_fields_list:3' : 'lfa:concatenate_value:3';
				literal = util.getF(concatenateValueElementId);
				if (literal != '') {
					// There may be no item number 2, so add the item by length property!
					concatenateItems[concatenateItems.length] = {is_log_field: isLogField, literal: literal};
				}
				// util.showObject(concatenateItems);
				obj.concatenate = concatenateItems;
				// Validate result field
				obj.log_field = validator.isValue('lfa:concatenate_log_fields_list:result');
				break;
			case 'convert_to_lowercase':
				obj.log_field = validator.isValue('lfa:convert_to_lowercase:log_fields_list');
				break;
			case 'convert_to_uppercase':
				obj.log_field = validator.isValue('lfa:convert_to_uppercase:log_fields_list');
				break;
			case 'copy':
				obj.log_field = validator.isValue('lfa:copy:log_fields_list:from');
				obj.target_log_field = validator.isValue('lfa:copy:log_fields_list:to');
				break;
			case 'match_regexp_copy':
				obj.log_field = validator.isValue('lfa:match_regexp_copy:log_field_list');
				obj.literal = validator.isRegularExpression('lfa:match_regexp_copy:expression');
				var copyToLogFieldItems = [];
				var copyToLogField = '';
				// KHP-RC, check for errors if parenthesizes in regular expression don't match the number of selected log fields!
				// var numberOfCopyToItems = 1;
				// Check log field 0
				copyToLogField = validator.isValue('lfa:match_regexp_copy:log_fields_list:0');
				copyToLogFieldItems[0] = {log_field: copyToLogField};
				// heck log field 1 (optional)
				copyToLogField = util.getF('lfa:match_regexp_copy:log_fields_list:1');
				if (copyToLogField != '') {
					copyToLogFieldItems[1] = {log_field: copyToLogField};
					// heck log field 2 (optional)
					copyToLogField = util.getF('lfa:match_regexp_copy:log_fields_list:2');
					if (copyToLogField != '') {
						copyToLogFieldItems[2] = {log_field: copyToLogField};
						// heck log field 3 (optional)
						copyToLogField = util.getF('lfa:match_regexp_copy:log_fields_list:3');
						if (copyToLogField != '') {
							copyToLogFieldItems[3] = {log_field: copyToLogField};
						}
					}
				}
				obj.copy = copyToLogFieldItems;
				break;
			case 'find_and_replace':
				obj.log_field = validator.isValue('lfa:find_and_replace:log_fields_list');
				obj.literal = validator.isValue('lfa:find_and_replace:find_value');
				obj.literal_2 = util.getF('lfa:find_and_replace:replace_value'); // Is allowed to be empty!
				var replaceType = '';
				if (util.getF('lfa:find_and_replace:all_btn')) {
					replaceType = 'all';
				}
				else if (util.getF('lfa:find_and_replace:first_btn')) {
					replaceType = 'first';
				}
				else {
					replaceType = 'last';
				}
				obj.replace_type = replaceType;
				break;
			case 'set':
				obj.log_field = validator.isValue('lfa:set:log_fields_list');
				obj.literal = util.getF('lfa:set:value'); // empty value is allowed!
				break;
		}
		//
		// Save the item
		//
		if (validator.allValid()) {
			// Save the item to the actions list (listcontrollerB handles save of the object)
			if (!logFilterAction.isAlternativeAction) {
				// Save Action item
				logFilterLists.actions.saveItem(logFilterAction.mode, logFilterAction.itemIndex, obj);
			}
			else {
				// Save Alternative Action item
				logFilterLists.alternativeActions.saveItem(logFilterAction.mode, logFilterAction.itemIndex, obj);
			}
			logFilterAction.closePanel();
		}
	},
	//
	// Label builder
	//
	labelBuilder: function(item, isAlternativeAction) {
		// alert('logFilterAction.labelBuilder()');
		// Returns a label (with or without HTML markup)
		// util.showObject(actionItem);
		function getLabel(logFieldName) {
			var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
			var logFieldLabel = '';
			if (logFieldItem != null) {
				logFieldLabel = logFieldItem.label;
			}
			else {
				logFieldLabel = '[ ' + langVar('lang_admin.log_filters.unknown_log_field') + ' ]';
			}
			return logFieldLabel;
		}
		function getConcatenateString(concatenateItems) {
			var s = '';
			for (var i = 0; i < concatenateItems.length; i++) {
				var item = concatenateItems[i];
				var literal = item.literal;
				s += ' ';
				s += item.is_log_field ? getLabel(literal) : '"' + literal + '"';
				s += ' +';
			}
			s = s.replace(/\+$/, '');
			return s;
		}
		function getMatchRegexpCopyString(copyItems) {
			var s = '';
			for (var i = 0; i < copyItems.length; i++) {
				s += ' $' + (i+1) + ' ' + langVar('lang_admin.log_filters.match_regexp_and_copy_to_info_2') + ' '; // I.e. "$1 to "
				s += getLabel(copyItems[i].log_field);
				s += ', ';
			}
			s = s.replace(/,\s$/, '');
			return s;
		}
		var actionPrefix = !isAlternativeAction ? langVar('lang_admin.log_filters.then') : langVar('lang_admin.log_filters.else');
		var subLabel = '';
		switch (item.type) {
			case 'accept':
				subLabel = langVar('lang_admin.log_filters.accept_log_entry');
				break;
			case 'concatenate':
				// I.e.: Concatenate [ "ABC" + "DEF" + Country + City ] and write result to Errors
				// subLabel = 'Concatenate [' +getConcatenateString(item.concatenate) + '] and write result to ' + getLabel(item.log_field); 
				subLabel = langVar('lang_admin.log_filters.concatenate_and_write_info');
				subLabel = subLabel.replace(/__PARAM__1/, '[' +getConcatenateString(item.concatenate) + ']');
				subLabel = subLabel.replace(/__PARAM__2/, getLabel(item.log_field));
				break;
			case 'convert_to_lowercase':
				// subLabel = 'Convert ' + getLabel(item.log_field) + ' to lowercase';
				subLabel = langVar('lang_admin.log_filters.convert_to_lowercase_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				break;
			case 'convert_to_uppercase':
				// subLabel = 'Convert ' + getLabel(item.log_field) + ' to uppercase';
				subLabel = langVar('lang_admin.log_filters.convert_to_uppercase_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				break;
			case 'copy':
				// subLabel = 'Copy ' + getLabel(item.log_field) + ' to ' + getLabel(item.target_log_field);
				subLabel = langVar('lang_admin.log_filters.copy_to_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, getLabel(item.target_log_field));
				break;
			case 'match_regexp_copy':
				// I.e.: Match in Country the regular expression "[(abc)]" and copy $1 to City
				// subLabel = 'Match in ' + getLabel(item.log_field) + ' the regular expression "' + item.literal + '" and copy ';
				subLabel = langVar('lang_admin.log_filters.match_regexp_and_copy_to_info_1');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, item.literal);
				subLabel+= getMatchRegexpCopyString(item.copy);
				break;
			case 'find_and_replace':
				// I.e.: Find in Geographic location "Greece" and replace all matches with "GREECE"
				if (item.replace_type == 'all') {
					subLabel = langVar('lang_admin.log_filters.find_and_replace_all_matches_info');
				}
				else if (item.replace_type == 'first') {
					subLabel = langVar('lang_admin.log_filters.find_and_replace_first_match_info');
				}
				else {
					subLabel = langVar('lang_admin.log_filters.find_and_replace_last_match_info');
				}
				// subLabel = 'Find in ' + getLabel(item.log_field) + ' "' + item.literal + '" ';
				// subLabel += 'and replace all matches with "' + item.literal_2 + '"';
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, item.literal);
				subLabel = subLabel.replace(/__PARAM__3/, item.literal_2);
				break;
			case 'reject':
				subLabel = langVar('lang_admin.log_filters.reject_log_entry_and_stop_filtering');
				break;
			case 'set':
				// subLabel = 'Set ' + getLabel(item.log_field) + ' to "' + item.literal + '"';
				subLabel = langVar('lang_admin.log_filters.set_log_field_info');
				subLabel = subLabel.replace(/__PARAM__1/, getLabel(item.log_field));
				subLabel = subLabel.replace(/__PARAM__2/, item.literal);
				break;
		}
		var label = '<strong>' + actionPrefix + '</strong>: ' + subLabel;
		return label;
	},
	actionLabelBuilder: function(item) {
		// Invoced from listcontrollerB
		return logFilterAction.labelBuilder(item, false);
	},
	alternativeActionLabelBuilder: function(item) {
		// Invoced from listcontrollerB
		return logFilterAction.labelBuilder(item, true);
	}
};
