//
// logFilterComment.js
//
var logFilterComment = {
	panel: null,
	saveCommentHandler: null,
	init: function(saveCommentHandlerFunction) {
		logFilterComment.saveCommentHandler = saveCommentHandlerFunction;
		var panelObj = {
			panelId: 'log_filter_comment:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.btn.comment'),
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterComment.close
		};
		logFilterComment.panel = new util.Panel3(panelObj);
		var YE = YAHOO.util.Event;
		YE.addListener('log_filter_comment:ok_btn', 'click', logFilterComment.save);
		YE.addListener('log_filter_comment:cancel_btn', 'click', logFilterComment.close);
	},
	open: function(comment) {
		// Convert <br /> tags to new line
		comment = comment.replace(/<br\s\/>/g, '\n');
		util.setF('log_filter_comment:comment', comment);
		logFilterComment.fixDivOverflow(true);
		logFilterComment.panel.open();
	},
	close: function() {
		logFilterComment.fixDivOverflow(false);
		logFilterComment.panel.close();
	},
	save: function() {
		var comment = util.getF('log_filter_comment:comment');
		// Escape newline and carriage return with <br /> tags
		comment = comment.replace(/\n/g, '<br />'); // newline
		comment = comment.replace(/\r/g, '<br />'); // carriage return
		logFilterComment.close();
		// Return to calle
		logFilterComment.saveCommentHandler(comment);
	},
	fixDivOverflow: function(isFix) {
		// Firefox has a problem with the underlying filter item div's.
		// The problem is caused by the div overflow setting where form fields
		// above the div don't anymore show focus on form fields. We solve this
		// by setting the div overflow to 'hidden' while a subform is open.
		var element = util.getE('log_filters:structured:list:div');
		// Element does not exist in logParsingFilters form, so check for element
		if (element) {
			element.style.overflow = isFix ? 'hidden' : 'scroll';
		}
	}
};
// 
// logFilterExpressionFields.js (Show avaialble log fields to be used in expressions)
// 
var logFilterExpressionFields = function() {
    // var h = util.h;
    var YE = YAHOO.util.Event;
    var GD = { // General global data
    	panel: null
    };
    function init(logFieldsDb) {
    	// Create the available expression fields list
		var availableExprFieldsDb = [];
		for (var i = 0; i < logFieldsDb.length; i++) {
			var logFieldItem = logFieldsDb[i];
			availableExprFieldsDb[i] = {label:logFieldItem.label, name:logFieldItem.name};
		}
		var viewExprFieldsObj = {
			panelId: 'view_log_filter_expression_fields:panel',
			tbodyId: 'view_log_filter_expression_fields:tbody',
			panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
			availableExpressionFieldsDb: availableExprFieldsDb
		};
		GD.panel = new AvailableExprFields(viewExprFieldsObj);
		YE.addListener('view_log_filter_expression_fields:close_btn', 'click', close);
    }
    function open() {
    	GD.panel.open();
    }
    function close() {
    	GD.panel.close();
    }
    //
	//
	// Return global properties and methods
	//
	//
	return {
       init: init,
       open: open,
       close: close
    }
}();
//
// logParsingFilters
//
window.onresize = adminConfig.setItemListSize;
var logParsingFilters = function() {
    // var h = util.h;
    var YE = YAHOO.util.Event;
    var GD = { // General global data
        theList: null,
        logFieldsDb: [],
        itemsDb: [], // items work array
        itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
        filterInitializationIsActive: false, // true if Filter Initialization is selected
        validator: null,
        saveChangesBtn: null,
        newItemBtn: null,
        duplicateBtn: null,
        deleteBtn: null,
        undoAllChangesBtn: null,
        // Active form data
        activeFormType: '',
        activeItem: {
        	labelOri: '',
        	comment: '',
        	commentOri: ''
        }
    };
    function init() {
        GD.validator = new util.Validator();
        //
		// init toolbar buttons and form controls
		//
		GD.saveChangesBtn = new util.ToolbarButton('save_changes', saveLogParsingFilters, toolbarButtonsDb);
		GD.newItemBtn = new util.ToolbarButton('new_log_parsing_filter', newItem, toolbarButtonsDb);
		GD.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
		GD.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
		GD.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
		// Create theList object
		GD.theList = new listcontroller.List({
			containerElementId: 'item_list_body',
			itemEvent: itemActivated,
			isSwitch1: true,
			isMoveControl: true,
			numberOfFixedItems: 1 // first list item cannot be moved
		});
		// Init the list
		initItemList();
		//
		// Ignore/Disable buttons according RBAC
		//
		var permissions = pageInfo.permissions;
		if (permissions.isEdit) {
			if (!permissions.isAdd) {
				GD.newItemBtn.disableAndIgnore();
				GD.duplicateBtn.disableAndIgnore();
			}
			if (!permissions.isDelete) {
				GD.deleteBtn.disableAndIgnore();
			}
			// Register isModifiedPageHandler in adminConfig.js
			// (We don't check for modifications if there is no edit 
			// permission because there is no Save button anyway!)
			adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
		}
		else {
			GD.saveChangesBtn.disableAndIgnore();
			GD.newItemBtn.disableAndIgnore();
			GD.duplicateBtn.disableAndIgnore();
			GD.deleteBtn.disableAndIgnore();
			GD.undoAllChangesBtn.disableAndIgnore();
		}
		// Set final toolbar state
		GD.saveChangesBtn.enable();
		GD.undoAllChangesBtn.enable();
		GD.newItemBtn.enable();
		YE.addListener('log_parsing_filters:label', 'keyup', updateListAndFormLabel);
		YE.addListener('log_parsing_filters:view_log_fields_btn', 'click', logFilterExpressionFields.open);
		YE.addListener('log_parsing_filters:edit_comment_btn', 'click', editComment);
		// init view available log fields and log filter comment
		logFilterExpressionFields.init(GD.logFieldsDb);
		logFilterComment.init(updateCommentDisplay);
		pageInfo.initComplete = true;
    }
    function initItemList() {
		GD.theList.init(GD.itemsDb);
		// Disable and hide checkbox of filter_initialization (first list item)
		var item_list_container = util.getE('item_list_body:ul_listcontrol');
		var checkboxes = item_list_container.getElementsByTagName('input');
		var filter_init_checkbox = checkboxes[0];
		filter_init_checkbox.disabled = true;
		filter_init_checkbox.style.visibility = 'hidden';
    }
    function updateMainDisplay(listItemType) {
    	// Whether we show the items form or no items form
    	if (listItemType != GD.activeFormType) {
			var isParsingFilterItem = listItemType != 'filter_initialization';
			util.showE('log_parsing_filters:filter_initialization_section', !isParsingFilterItem);
			util.showE('log_parsing_filters:parsing_filters_section', isParsingFilterItem);
			GD.deleteBtn.enable(isParsingFilterItem);
			GD.duplicateBtn.enable(isParsingFilterItem);
			GD.activeFormType = listItemType;
		}
    }
    function updateListAndFormLabel() {
    	setTimeout('logParsingFilters.setListAndFormLabel()', 300);
    }
    function setListAndFormLabel() {
		var label = util.getF('log_parsing_filters:label');
		if (label == '') {
			label = '-';
		}
		GD.theList.updateListLabel(label);
	}
    function updateCommentDisplay(comment) {
    	// theComment may contain HTML tags, i.e. <br />,
		// so we use innerHTML for comment display!
		var isComment = (comment != '');
		var buttonLabel = isComment ? langVar('lang_admin.log_parsing_filters.edit_comment') : langVar('lang_admin.log_parsing_filters.add_comment');
		util.updateT('log_parsing_filters:edit_comment_btn', buttonLabel);
		var commentElement = util.getE('log_parsing_filters:comment');
		if (isComment) {
			commentElement.innerHTML = comment;
			commentElement.style.display = 'block';
		}
		else {
			commentElement.style.display = 'none';
		}
		// Save active comment
		GD.activeItem.comment = comment;
    }
    function editComment() {
    	logFilterComment.open(GD.activeItem.comment);
    }
    function getLogParsingFiltersData() {
    	if (!pageInfo.exitActive) {
			// Init help
			util.helpWindow.init('');
			// invoked upon editor load
			var url = '?dp=config_pages.log_parsing_filters.get_log_pars_filters_data';
			url += '&p=' + pageInfo.profileName;
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			util.serverPost(url, dat);
		}
    }
    function getLogParsingFiltersDataResponse(dat) {
    	// util.showObject(dat);
    	var itemsDb = dat.logParsingFiltersDb;
    	GD.logFieldsDb = dat.logFieldsDb;
    	GD.itemsDb = itemsDb;
    	GD.itemsDbBackup = util.cloneObject(itemsDb);
    	init();
    	// Select first item
    	var firstItemId = GD.theList.getFirstItemId();
    	setItem(firstItemId);
    	util.showE('form_section');
    	adminConfig.setItemListSize();
    }
    function setItem(itemId) {
    	GD.theList.selectItem(itemId);
    	updateForm();
    }
	function itemActivated(itemId) {
		if (validateActiveItem()) {
			// if selected node item is valid then e to activated node item
			setItem(itemId);
		}
	}
    function newItem() {
    	if (validateActiveItem()) {
    		var theList = GD.theList;
			var newItemId = theList.getNewItemId();
			var newItemLabel = langVar('lang_admin.general.new_log_parsing_filter');
			var newFilterObj = {
				id: newItemId,
				type: '',
				switch1: true,
				label: newItemLabel,
				dat: {
					label: newItemLabel,
					labelOri: '',
					comment: '',
					commentOri: '',
					expression: ''
				}
			};
			theList.newItem(newFilterObj);
			setItem(newItemId);
		}
    }
    function duplicateItem() {
    	if (validateActiveItem()) {
			var theList = GD.theList
			var clonedItemId = theList.cloneItem();
			setItem(clonedItemId);
		}
    }
    function deleteItem() {
    	var theList = GD.theList;
		var nextItemIdToBeSelected = theList.deleteItem();
		// reset the validator to clear any error message of the deleted item
		GD.validator.reset();
		// select the next item
		setItem(nextItemIdToBeSelected);
    }
    function updateForm() {
    	var item = GD.theList.getSelectedItem();
    	var itemType = item.type;
    	var itemDat = item.dat;
    	if (itemType != 'filter_initialization') {
			// util.showObject(itemDat);
			// Set non-editable data which are simply transferd to new object
			GD.activeItem.labelOri = itemDat.labelOri;
			// GD.activeItem.comment = itemDat.comment; --> comment is set via updateCommentDisplay()
			GD.activeItem.commentOri = itemDat.commentOri;
			// Set editable data
			util.setF('log_parsing_filters:label', itemDat.label);
			util.setF('log_parsing_filters:expression', itemDat.expression);
			updateCommentDisplay(itemDat.comment);
		}
		else {
			// filter_initialization, filter_finalization
			util.setF('log_parsing_filters:filter_initialization', itemDat.filter_initialization);
			util.setF('log_parsing_filters:filter_finalization', itemDat.filter_finalization);
		}
    	updateMainDisplay(itemType);
    }
    function validateActiveItem() {
		// Only validate if isEdit permission
		if (pageInfo.permissions.isEdit) {
			var theList = GD.theList;
			var validator = GD.validator;
			validator.reset();
			var o = {};
			if (GD.activeFormType != 'filter_initialization') {
				o.label = validator.isValue('log_parsing_filters:label');
				o.label = validator.isUnique('log_parsing_filters:label', theList.getLookupItems('label'));
				o.labelOri = GD.activeItem.labelOri;
				o.comment = GD.activeItem.comment;
				o.commentOri = GD.activeItem.commentOri;
				o.expression = validator.isValue('log_parsing_filters:expression');
			}
			else {
				o.filter_initialization = util.getF('log_parsing_filters:filter_initialization');
				o.filter_finalization = util.getF('log_parsing_filters:filter_finalization');
			}
			if (validator.allValid()) {
				theList.saveItem(o);
				return true;
			}
			return false;
		}
		// If no edit permission or no items
		return true;
    }
    function saveLogParsingFilters() {
    	if (validateActiveItem()) {
			var theList = GD.theList;
			var isModified = theList.getIsModified();
			// alert('isModified: ' + isModified);
			if (isModified) {
				if (pageInfo.showRebuildDbAdvice) {
					rebuildDbAdvice.open(saveLogParsingFiltersFinal);
				}
				else {
					saveLogParsingFiltersFinal();
				}
			}
			else {
				alert(langVar('lang_stats.general.no_changes_to_save'));
			}
		}
    }
    function saveLogParsingFiltersFinal(isHideRebuildDbAdviceMessage) {
		// This function may be invoked from rebuildDbAdvice.
		// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
		util.hideE('form_section');
		util.showE('saving_info');
		var itemsDb = GD.itemsDb;
		var numberOfItems = itemsDb.length;
		var setHideRebuildDbAdviceMessage = (arguments.length == 1) ? isHideRebuildDbAdviceMessage : false;
		var isParsingFilterItems = false;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
		dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
		for (var i = 0; i < numberOfItems; i++) {
			var item = itemsDb[i];
			var itemDat = item.dat;
			if (item.type != 'filter_initialization') {
				isParsingFilterItems = true;
				var path = 'v.fp.parsing_filters.' + i;
				// Add position node so that we are able tp re-sort items on client side
				dat += path + '.position=' + i + '&';
				dat += path + '.label=' + encodeURIComponent(itemDat.label) + '&';
				dat += path + '.label_ori=' + encodeURIComponent(itemDat.labelOri) + '&';
				dat += path + '.comment=' + encodeURIComponent(itemDat.comment) + '&';
				dat += path + '.comment_ori=' + encodeURIComponent(itemDat.commentOri) + '&';
				dat += path + '.disabled=' + !item.switch1 + '&';
				dat += path + '.value=' + encodeURIComponent(itemDat.expression) + '&';
			}
			else {
				dat += 'v.fp.filter_initialization=' + encodeURIComponent(itemDat.filter_initialization) + '&';
				dat += 'v.fp.filter_finalization=' + encodeURIComponent(itemDat.filter_finalization) + '&';
			}
		}
		if (!isParsingFilterItems) {
			// No log parsing filter exists
			dat += 'v.fp.parsing_filters=&';
		}
		dat = dat.replace(/&$/, '');
		pageInfo.saveActive = true;
		var url = '?dp=config_pages.log_parsing_filters.save_log_pars_filters';
		url += '&p=' + pageInfo.profileName;
		util.serverPost(url, dat);
    }
    function saveLogParsingFiltersFinalResponse(dat) {
    	// reset isModified
		GD.theList.resetIsModified();
		// the saved work itemsDb becomes now the itemsDbBackup
		GD.itemsDbBackup = util.cloneObject(GD.itemsDb);
		pageInfo.saveActive = false;
		// Update profilesListChecksum checksum
		profilesStorage.update(dat.profileChanges);
		util.hideE('saving_info');
		util.showE('form_section');
	}
    function undoAllChanges() {
    	GD.itemsDb = util.cloneObject(GD.itemsDbBackup);
		GD.validator.reset();
		initItemList();
		// Select first item
    	var firstItemId = GD.theList.getFirstItemId();
    	setItem(firstItemId);
    }
    function getIsModifiedPage() {
        // Before checking isModified we need to validate the form!
        if (!validateActiveItem() || GD.theList.getIsModified()) {
            return true;
        }
        return false;
    }
    //
	//
	// Return global properties and methods
	//
	//
	return {
        getLogParsingFiltersData: getLogParsingFiltersData,
        getLogParsingFiltersDataResponse: getLogParsingFiltersDataResponse,
        setListAndFormLabel: setListAndFormLabel,
        updateCommentDisplay: updateCommentDisplay,
        saveLogParsingFiltersFinalResponse: saveLogParsingFiltersFinalResponse
    }
}();
