//
// logSourceUtil.js (used in new profile wizard and config)
// This handles the log source selection.
//
//
var logSourceUtil = function() {
	var YE = YAHOO.util.Event;
	var GD = {
		isLite: false,
		isConfig: false, // versus new profile wizard
		isActiveLogSourceFileMask: false
	}
	function init(isLite, isConfig) {
		GD.isLite = isLite;
		GD.isConfig = isConfig;
		YE.addListener('log_source:type', 'change', setLogSourceDisplay);
		YE.addListener(['log_source:add_file_mask_btn', 'log_source:remove_file_mask_btn'], 'click', toggleFileMask);
		YE.addListener('log_source:local:browse_btn', 'click', browseLocalLogSource);
	}
	function browseLocalLogSource() {
		matchingFiles.closePanel();
		util.fileManagerWindow.open('log_source:pathname');
	}
	function toggleFileMask() {
		var showFileMask = !GD.isActiveLogSourceFileMask;
		util.showE('log_source:group:add_file_mask', !showFileMask);
		util.showE('log_source:group:file_mask', showFileMask);
		if (showFileMask) {
			util.focusE('log_source:file_mask');
		}
		GD.isActiveLogSourceFileMask = showFileMask;
	}
	function setLogSourceDisplay() {
		var activeType = util.getF('log_source:type');
		// alert('activeType: ' + activeType);
		util.hideE([
			'log_source:group:hostname_username_password',
			'log_source:group:pathname',
			'log_source:group:file_mask',
			'log_source:group:process_subdirectories',
			'log_source:group:use_passive',
			'log_source:group:http',
			'log_source:group:odbc', // is used for odbc_mssql && odbc_oracle
			'log_source:group:command',
			'log_source:group:show_matching_files'
		]);
		var isLocal = activeType == 'local';
		var isFTP = activeType == 'ftp';
		var isSFTP = activeType == 'sftp';
		if (isLocal || isFTP || isSFTP) {
			util.showE('log_source:group:hostname_username_password', !isLocal);
			util.showE('log_source:group:local_pathname_field_info', isLocal);
			util.showE('log_source:group:ftp_pathname_field_info', !isLocal);
			util.showE('log_source:group:pathname');
			// Enable browse button only for local log source
			util.showEV('log_source:local:browse_btn', isLocal);
			util.enableE('log_source:local:browse_btn', isLocal);
			if (!GD.isLite) {
				util.showE('log_source:group:add_file_mask', !GD.isActiveLogSourceFileMask);
				util.showE('log_source:group:file_mask', GD.isActiveLogSourceFileMask);
				util.showE('log_source:group:process_subdirectories');
			}
			util.showE('log_source:group:use_passive', isFTP);
			util.showE('log_source:group:show_matching_files');
		}
		else if (activeType == 'http') {
			util.showE('log_source:group:http');
			util.showE('log_source:group:show_matching_files');
		}
		else if (activeType == 'command') {
			util.showE('log_source:group:command');
			util.showE('log_source:group:show_matching_files');
		}
		else {
			// odbc_mssql || odbc_oracle
			util.showE('log_source:group:odbc');
		}
	}
	function updateForm(itemDat) {
		// util.showObject(itemDat);
		// Reset file_mask
		GD.isActiveLogSourceFileMask = false;
		if (GD.isConfig) {
			util.setF('log_source:label', itemDat.label);
		}
		var activeType = itemDat.type;
		var isLocal = activeType == 'local';
		var isFTP = activeType == 'ftp';
		var isSFTP = activeType == 'sftp';
		if (activeType == 'odbc') {
			// Look actual odbc type, odbc_mssql or odbc_oracle, up in server.
			activeType = itemDat.server.type;
		}
		util.setF('log_source:type', activeType);
		if (isLocal || isFTP || isSFTP) {
			if (!isLocal) {
				util.setF('log_source:hostname', itemDat.hostname);
				util.setF('log_source:username', itemDat.username);
				util.setF('log_source:password', itemDat.password);
				if (isFTP) {
					util.setF('log_source:use_passive', itemDat.use_passive);
				}
			}
			util.setF('log_source:pathname', itemDat.pathname);
			util.setF('log_source:process_subdirectories', itemDat.process_subdirectories);
			if (!GD.isLite) {
				util.setF('log_source:file_mask', itemDat.file_mask);
				util.setF('log_source:pattern_is_regular_expression', itemDat.pattern_is_regular_expression);
				if (itemDat.file_mask != '') {
					GD.isActiveLogSourceFileMask = true;
				}
			}
		}
		else if (activeType == 'http') {
			util.setF('log_source:http_hostname', itemDat.hostname);
			util.setF('log_source:http_pathname', itemDat.pathname);
		}
		else if (activeType == 'command') {
			util.setF('log_source:command', itemDat.command);
		}
		else {
			// odbc_mssql || odbc_oracle
			var server = itemDat.server;
			util.setF('log_source:odbc:dsn', server.dsn);
			util.setF('log_source:odbc:username', server.username);
			util.setF('log_source:odbc:password', server.password);
			util.setF('log_source:odbc:database_name', server.database_name);
			util.setF('log_source:odbc:query', itemDat.query);
		}
	}
	function getValidatedLogSourceObject(validator) {
		// Validates the log source and returns the validated data.
		var log_source_type = util.getF('log_source:type');
		var isLocal = log_source_type == 'local';
		var isFTP = log_source_type == 'ftp';
		var isSFTP = log_source_type == 'sftp';
		if (log_source_type.indexOf('odbc') != -1) {
			var odbc_server_type = log_source_type;
			log_source_type = 'odbc'; // We use odbc_mssql && odbc_oracle for the server type only, the log source type is simply "odbc"!
		}
		var obj = {};
		// Get the label if we are in Config
		if (GD.isConfig) {
			// Coverted profiles may show duplicate labels, so we allow
			// duplicate labels because they don't matter in log source anyway.
			// o.label = validator.isUnique('label', theList.getLookupItems('label'));
			obj.label = validator.isValue('log_source:label');
		}
		obj.type = log_source_type;
		if (isLocal || isFTP || isSFTP) {
			if (!isLocal) {
				// Note, the ftp_username and ftp_password are optional, don't validate!
				obj.hostname = validator.isValue('log_source:hostname');
				obj.username = util.getF('log_source:username');
				obj.password = util.getF('log_source:password');
				if (isFTP) {
					obj.use_passive = util.getF('log_source:use_passive');
				}
			}
			obj.pathname = validator.isValue('log_source:pathname');
			obj.process_subdirectories = util.getF('log_source:process_subdirectories');
			// Handle file_mask
			var fileMask = '';
			var fileMaskIsRegExpr = false;
			if (!GD.isLite && GD.isActiveLogSourceFileMask) {
				fileMask = util.getF('log_source:file_mask');				
				fileMaskIsRegExpr = util.getF('log_source:pattern_is_regular_expression');
				// // validate file_mask only if regular expression is checked
				if (fileMaskIsRegExpr && !util.isRegularExpression(fileMask)) {
					validator.isCustom('log_source:file_mask',
						langVar('lang_admin.log_source.invalid_pathname_regular_expression')
					);
				}
			}
			obj.file_mask = fileMask;
			obj.pattern_is_regular_expression = fileMaskIsRegExpr;
		}
		else if (log_source_type == 'http') {
			obj.hostname = validator.isValue('log_source:http_hostname');
			obj.pathname = validator.isValue('log_source:http_pathname');
		}
		else if (log_source_type == 'odbc') {
			// Are the odbc username and password optional?
			var server = {};
			server.type = odbc_server_type;
			server.dsn = validator.isValue('log_source:odbc:dsn');
			server.username = util.getF('log_source:odbc:username');
			server.password = util.getF('log_source:odbc:password');
			server.database_name =  validator.isValue('log_source:odbc:database_name');
			obj.server = server;
			obj.query = validator.isValue('log_source:odbc:query');
		}
		else {
			// command
			obj.command = validator.isValue('log_source:command');
		}
		return obj;
	}
	//
	//
	// Return global properties and methods
	//
	//
	return {
		init: init,
		toggleFileMask: toggleFileMask,
		setLogSourceDisplay: setLogSourceDisplay,
		updateForm: updateForm,
		getValidatedLogSourceObject: getValidatedLogSourceObject
	}
}();
