//
// newProfileInfo.js
//

var newProfileInfo = {
	
	panel: null,

	init: function() {
		
		var panelObj = {
			panelId: 'new_profile_info:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: '-',
			zIndex: 20,
			isCover: true,
			closeEvent: newProfileInfo.close
		};
		
		newProfileInfo.panel = new util.Panel3(panelObj);
		
		YAHOO.util.Event.addListener('new_profile_info:close_btn', 'click', newProfileInfo.close);
	},
	
	openViaNewProfileWizard: function(newProfileNodeName, profileChanges, userGrants) {
		
		// This function is called from New Profile Wizard when the profile has been saved.
		// newProfilesDb is up to date which includes the new profile.
		// profiles.createNewProfileCompleted(newProfilesDb);

		// Reset userGrants
		profilesUtil.resetUserGrants(userGrants);

		profiles.handleNewProfile(profileChanges);
		profiles.closeNewProfileWizardWindow();

		// Open new profile info panel
		newProfileInfo.open(newProfileNodeName);
	},
	
	open: function(newProfileNodeName) {

		//
		// Init newProfileInfo panel
		//
		
		if (newProfileInfo.panel === null) {
			newProfileInfo.init();
		}

		var newProfileItem = profiles.getProfileItem(newProfileNodeName);
		// util.showObject(newProfileItem);

		// Update the info label
		var label = langVar('lang_admin.profiles.profile_has_been_created');
		label = label.replace(/__PARAM__1/, newProfileItem.label);
		util.updateT('new_profile_info:label', label);
		
		//
		// Handle View Reports, View Config and Delete link
		//
		
		// util.showObject(newProfileItem);
		var theProfileGrants = profilesUtil.getProfileGrants(newProfileNodeName);

		var isViewReportsPermission = theProfileGrants.isViewReports;
		var isViewConfigPermission = theProfileGrants.isViewConfig || theProfileGrants.isViewTools;
		
		if (isViewReportsPermission) {
			
			var viewReportsBtn = util.getE('new_profile_info:view_reports_btn');
			var viewReportsUrl = '?dp=reports&p=' + newProfileNodeName;
			if (newProfileItem.df != '') {
				viewReportsUrl += '&df=' + newProfileItem.df;
			}
			viewReportsBtn.href = viewReportsUrl;
		}
		
		if (isViewConfigPermission) {

			// TODO - there may be no permission for page=log_source, check for page permission!
			var viewConfigBtn = util.getE('new_profile_info:view_config_btn');
			var viewConfigUrl = '?dp=config&page=log_source&p=' + newProfileNodeName;
			viewConfigBtn.href = viewConfigUrl;
		}
		
		util.showE('new_profile_info:view_reports_btn', isViewReportsPermission);
		util.showE('new_profile_info:view_config_btn', isViewConfigPermission);
		
		//
		// Show profiles list and new profile info
		//
		
		newProfileInfo.panel.prePositionAtCenter();
		newProfileInfo.panel.open();
	},
	
	close: function() {
		
		newProfileInfo.panel.close();
	}
};
