/* global
	profiles: false
	 profilesStorage: false */

var profilesDashboardEditor = (function() {

	'use strict';

	// This is the profiles view editor

	var YE = YAHOO.util.Event;
//	var busyPanel = null;
	var containerEl = null;

	// profilesDb is a reference to profiles.profilesDb, this contains all profiles
	var profilesDb = [];

	// activeProfilesDb is used to create the list, it may contain all profiles
	// or a filter result from profilesFilter.
	var activeProfilesDb = [];

	// dashboardView is a clone of pageInfo.profilesDashboardView
	var dashboardView = {};

	var idPrefix = '';

	var isDateFilter = false;

	var confirmDeletePanel = null;
	var defaultColumn = {
			profile_name: '',
			show_column_label: true,
			column_label: langVar('lang_admin.profiles.new_column'),
			show_cell_labels: false,
			cell_label: '',
			report_field: '',

			// raw_report_field_label contains the language variable, not expanded
			raw_report_field_label: '',

			// The expanded label, this not saved to server
			report_field_label: '',
//			expression: '',
//			date_filter: '',
			profiles: []
		};
	var indexOfColumnToDelete = -1;

	var isRootAdmin = false;
	var isEditAllProfilesGrants = false;

	function init() {

		// Set permissions/grants. If this is not the root admin and if the user
		// has not edit permission for all profiles then we limit editing
		// to granted profiles only. In this case the user cannot add/delete columns
		// nor edit the column headers.
		isRootAdmin = pageInfo.isRootAdmin;

		if (!isRootAdmin) {
			var allProfilesGrants = pageInfo.userGrants.allProfilesGrants;
			isEditAllProfilesGrants = allProfilesGrants.editProfilesDashboard;
		}

		profilesDb = profiles.getProfilesDb();
		idPrefix = util.getUniqueElementId();

		var confirmDeletePanelObj = {
			panelId: 'delete_column:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.delete_column'),
			left: 100,
			top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: cancelDeleteColumn
		};

		if (isRootAdmin || isEditAllProfilesGrants) {

			YE.addListener('delete_column:yes_btn', 'click', deleteColumn);
			YE.addListener('delete_column:no_btn', 'click', cancelDeleteColumn);
		}

		// Enable/disable Show database info and date filter
//		util.enableE('profiles:show_database_info', isRootAdmin || isEditAllProfilesGrants);
		util.enableE('profiles:date_filter', isRootAdmin || isEditAllProfilesGrants);

		confirmDeletePanel = new util.Panel3(confirmDeletePanelObj);

		containerEl = util.getE('profiles:edit_profiles_view_list');

//		YE.addListener('profiles:toggle_date_filter_btn', 'click', toggleDateFilter);

		YE.addListener('profiles:edit_profiles_view:cancel_btn', 'click', cancelProfilesView);
		YE.addListener('profiles:edit_profiles_view:save_btn', 'click', saveProfilesDashboard);

		YE.addListener('profiles:edit_profiles_view_list', 'click', cellItemClicked);

		// Init profilesViewUtil
		profilesDashboardEditorUtil.init(profilesDb);
	}

	function create(theActiveProfilesDb) {

		activeProfilesDb = theActiveProfilesDb;

		// Clone pageInfo.profilesDashboardView, so that it remains intact.
		dashboardView = util.cloneObject(pageInfo.profilesDashboardView);

		if (containerEl === null) {
			init();
		}

		var columns = dashboardView.columns;
		var numColumns = columns.length;
		if (numColumns === 0) {

			columns[0] = util.cloneObject(defaultColumn);
		}

//		util.showObject(activeProfilesDb);

		createView();

//		util.setF('profiles:show_database_info', dashboardView.show_database_info);
		util.setF('profiles:date_filter', dashboardView.date_filter);

		util.showE('profiles:edit_profiles_view');
	}

	function update(theActiveProfilesDb) {
		// This is called from dashboardView when the profiles become filtered.
		// Replace current dashboardView.
		activeProfilesDb = theActiveProfilesDb;
		createView();
	}

	function cancelProfilesView() {
		util.hideE('profiles:edit_profiles_view');
		var isCancel = true;
		profiles.editViewClosed(isCancel);
	}

	function getColProfilesDat(colPath, colProfiles) {

		var colProfilesDat = '';
		var numProfiles = colProfiles.length;

		if (numProfiles > 0) {

			for (var i = 0; i < numProfiles; i++) {

				var cellItem = colProfiles[i];
				var profileName = cellItem.profile_name;

//				util.showObject(cellItem, 'cellItem');

				var path = colPath + '.profiles.' + profileName;

				colProfilesDat += path + '.profile_name=' + profileName;
				colProfilesDat += path + '.show_label=' + cellItem.show_label;
				colProfilesDat += path + '.label=' + encodeURIComponent(cellItem.label);
				colProfilesDat += path + '.report_field=' + cellItem.report_field;

				// Save raw_report_field_label to report_field_label!
				colProfilesDat += path + '.report_field_label=' + encodeURIComponent(cellItem.raw_report_field_label);
//				colProfilesDat += path + '.expression=' + encodeURIComponent(cellItem.expression);
//				colProfilesDat += path + '.date_filter=' + encodeURIComponent(cellItem.date_filter);
			}
		}
		else {

			colProfilesDat = colPath + '.profiles=';
		}

		return colProfilesDat;
	}

	function saveProfilesDashboard() {

		util.hideE('profiles:edit_profiles_view');
//		util.showObject(dashboardView);

//		var showDatabaseInfo = util.getF('profiles:show_database_info');
		var dateFilter = util.getF('profiles:date_filter');

//		dashboardView.show_database_info = showDatabaseInfo;
		dashboardView.date_filter = dateFilter;

		var columns = dashboardView.columns;
		var columnsDat = '';

		for (var i = 0, len = columns.length; i < len; i++) {

			var colItem = columns[i];
			var colPath = '&v.fp.profiles_dashboard.columns.' + i;

			columnsDat += colPath + '.profile_name=' + colItem.profile_name;
			columnsDat += colPath + '.show_column_label=' + colItem.show_column_label;
			columnsDat += colPath + '.column_label=' + encodeURIComponent(colItem.column_label);
			columnsDat += colPath + '.show_cell_labels=' + colItem.show_cell_labels;
			columnsDat += colPath + '.cell_label=' + encodeURIComponent(colItem.cell_label);
			columnsDat += colPath + '.report_field=' + colItem.report_field;

			// Save raw_report_field_label to report_field_label!
			columnsDat += colPath + '.report_field_label=' + encodeURIComponent(colItem.raw_report_field_label);
//			columnsDat += colPath + '.expression=' + encodeURIComponent(colItem.expression);
//			columnsDat += colPath + '.date_filter=' + encodeURIComponent(colItem.date_filter);

			columnsDat += getColProfilesDat(colPath, colItem.profiles);
		}

		var url = '?dp=admin_pages.profiles_dashboard.save_profiles_dashboard';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
//		dat += '&v.fp.profiles_dashboard.show_database_info=' + showDatabaseInfo;
		dat += '&v.fp.profiles_dashboard.date_filter=' + dateFilter;
		dat += '&v.fp.profiles_dashboard.columns=' + columnsDat;

		util.serverPost(url, dat);
	}

	function saveProfilesDashboardResponse() {

		// Set profilesDashboardView in pageInfo to saved dashboardView
		pageInfo.profilesDashboardView = util.cloneObject(dashboardView);

		var isCancel = false;
		profiles.editViewClosed(isCancel);
	}

//	function toggleDateFilter(evt) {
//
//		var dateFilterBox = util.getE('profiles:date_filter:box');
//		dateFilterBox.style.display = isDateFilter ? 'none' : 'inline';
//		isDateFilter = !isDateFilter;
//	}

	function cellItemClicked(evt) {

		var element = evt.target || evt.srcElement;
		var elementId = element.id;

//		alert('cellItemClicked(): ' + elementId);

		var pattern = /:(add_col|edit_col|delete_col|edit_cell)/;

		if (pattern.test(elementId)) {

			var dat = elementId.split(':');
			var directive = dat[1];
			var colIndex = parseInt(dat[2], 10);

			switch (directive) {

			case 'add_col':

				addColumn(colIndex);
				break;

			case 'edit_col':

				profilesDashboardEditorUtil.editColumn(colIndex, dashboardView.columns[colIndex]);
				break;

			case 'delete_col':

				confirmDeleteColumn(colIndex);
				break;

			case 'edit_cell':

				// Get profile name from tr element Id
				var trElement = element.parentNode;

				// Make sure we get the TR element
				while (trElement.nodeName !== 'TR') {
					trElement = trElement.parentNode;
				}

				var trDat = trElement.id.split(':');
				var profileName = trDat[2];
//				alert('profileName: ' + profileName);
				profilesDashboardEditorUtil.editCell(colIndex, dashboardView.columns[colIndex], profileName);
				break;
			}
		}
	}

	function addColumn(colIndex) {

		dashboardView.columns[colIndex] = util.cloneObject(defaultColumn);
		createView();
	}

	function confirmDeleteColumn(colIndex) {

		indexOfColumnToDelete = colIndex;
		confirmDeletePanel.prePositionAtCenter();
		confirmDeletePanel.open();
	}

	function deleteColumn() {

		dashboardView.columns.splice(indexOfColumnToDelete, 1);
		createView();
		confirmDeletePanel.close();
	}

	function cancelDeleteColumn() {
		confirmDeletePanel.close();
	}

	function saveHeaderCell(colIndex, newColObj) {

		// Override column with newColObj
		var column = dashboardView.columns[colIndex];

		for (var prop in newColObj) {

			column[prop] = newColObj[prop];
		}

//		util.showObject(dashboardView);
	}

	function saveCell(colIndex, newCellObj, profileName) {

		var colProfiles = dashboardView.columns[colIndex].profiles;

		// Remove existing cell with given profileName
		for (var i = 0, len = colProfiles.length; i < len; i++) {

			var cellItem = colProfiles[i];

			if (cellItem.profile_name === profileName) {

				// Remove the cellItem
				colProfiles.splice(i, 1);
				break;
			}
		}

//		util.showObject(newCellObj, 'newCellObj');

		// Add newCellObj if a report_field is defined
		if (newCellObj.report_field !== '') {


			// colProfiles[colProfiles.length] = util.cloneObject(newCellObj);

			colProfiles[colProfiles.length] = newCellObj;
		}

//		util.showObject(dashboardView, 'saved the cell');
	}

	//
	// Create the view
	//

	function createView() {

		// Clear existing view
//		util.removeChildElements(containerEl);
		var columns = dashboardView.columns;
		var numColumns = columns.length;

//		util.showObject(dashboardView);
//		util.showObject(profilesDb);

		var table = '<table class="edit-profiles-view"><tbody>';
//		table += _getPreHeaderRow(columns, numColumns);
		table += _getHeaderRow(columns, numColumns);

		for (var i = 0, len = activeProfilesDb.length; i < len; i++) {

			var profileItem = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);

			var rowId = idPrefix + ':tr:' + profileItem.name;

			table += '<tr id="' + rowId + '">';
			table += '<td class="profile">' + profileItem.label + '</td>';

			// Add the columns
			table += _getColumns(profileItem.name, columns, numColumns);
			table += '</tr>';
		}

		table += '</tbody></table>';
		containerEl.innerHTML = table;
	}

	function _getPreHeaderRow(columns, numColumns) {

		// This returns the row with the delete buttons
		var row = '<tr>';
		row += '<th class="delete">&nbsp;</th>';

		// Create the column cells
		for (var i = 0; i < numColumns; i++) {

			var column = columns[i];
			var colText = (column.column_label !== '') ? column.column_label : '-';

			row += '<th class="delete">'

			if (isRootAdmin || isEditAllProfilesGrants) {

				row += '<a id="' + idPrefix + ':delete_col:' + i + '" class="link-90" href="javascript:;">' + langVar('lang_stats.btn.delete') + '</a> ';
			}

			row += '</th>';
		}

		row += '</tr>';

		return row;
	}

	function _getHeaderRow(columns, numColumns) {

		// This returns the main header row
//		util.showObject(columns);

		var row = '<tr>';
		row += '<th>';
		row += '<div class="delete">&nbsp;</div>';
		row += '<div class="profile">' + langVar('lang_stats.btn.profiles') + '</div>';
		row += '</th>';

		// Create the column cells
		for (var i = 0; i < numColumns; i++) {

			var column = columns[i];
			var colText = '';

			if (column.column_label !== '') {


				colText = column.column_label;
			}
			else if (column.report_field !== '' &&
					column.report_field_label !== '') {

				colText = column.report_field_label;
			}
			else {

				colText = '(' + langVar('lang_admin.profiles.column') + ' ' + (i + 1) + ')';
			}


			row += '<th>';

			// Delete
			row += '<div class="delete">';
				if (isRootAdmin || isEditAllProfilesGrants) {
					row += '<a id="' + idPrefix + ':delete_col:' + i + '" class="link-90" href="javascript:;">' + langVar('lang_stats.btn.delete') + '</a>';
				}
				else {
					row += '&nbsp;';
				}
			row += '</div>';

			// Label
			row += '<div>';
				if (isRootAdmin || isEditAllProfilesGrants) {
					row += '<a id="' + idPrefix + ':edit_col:' + i + '" class="link-90" href="javascript:;">' + colText + '</a>';
				}
				else {
					row += colText;
				}
			row += '</div>';

			row += '</th>';
		}

		// Create Add Column cell
		row += '<th>';
		if (isRootAdmin || isEditAllProfilesGrants) {
			row += '<div class="delete">&nbsp;</div>';
			row += '<div class="add"><a id="' + idPrefix + ':add_col:' + numColumns + '" class="link-90" href="javascript:;">+ ' + langVar('lang_admin.profiles.add_column') + '</a></div>';
		}
		row += '</th>';

		row += '</tr>';

		return row;
	}

	function _getColumns(profileName, columns, numColumns) {

		var colHTML = '';

		var isEditGrants = isRootAdmin || isEditAllProfilesGrants;

		if (!isEditGrants) {

			// Check if this profile has edit grants
			var theProfileGrants = profilesUtil.getProfileGrants(profileName);
			isEditGrants = theProfileGrants.editProfilesDashboard;
		}

		for (var i = 0; i < numColumns; i++) {

			var id = idPrefix + ':edit_cell:' + i;
			var column = columns[i];

			// Check if this profile has specific cell settings
			var cellItem = _getProfileCellItem(profileName, column);

			var className = '';
			var anchorClassName = '';
//			var reportFieldLabel = '';
			var text = ' ';

			if (cellItem !== null) {

				// Specific report field for profile defined.
//				util.showObject(cellItem, 'cellItem');
//				reportFieldLabel = cellItem.report_field_label;
				className = 'cell-def';
				anchorClassName = 'link-90';
				text = (cellItem.label !== '') ? cellItem.label : cellItem.report_field_label;
			}
			else if (column.report_field !== '') {

				// Report field defined in column header

				className = 'col-def';
				anchorClassName = 'link-90';

				if (column.cell_label !== '') {

					text = '(' + column.cell_label + ')';
				}
				else {

					text = '(' + column.report_field_label + ')';
				}
			}
			else {

				className = 'not-def';
				anchorClassName = 'link-90-lite';
				text = '(' + langVar('lang_stats.btn.none') + ')';
			}

			colHTML += '<td class="' + className + '">';
			if (isEditGrants) {
				colHTML += '<a id="' + id + '" class="' + anchorClassName + '" href="javascript:;">' + text + '</a>';
			}
			else {
				colHTML += text;
			}

			colHTML += '</td>';
		}

		return colHTML;
	}

	function _getProfileCellItem(profileName, column) {

		var profileCellItem = null;
		var profiles = column.profiles;

		for (var i = 0, len = profiles.length; i < len; i++) {

			if (profiles[i].profile_name === profileName) {
				profileCellItem = profiles[i];
				break;
			}
		}

		return profileCellItem;
	}

	// Return global properties and methods
	return {
		create: create,
		update: update,
		createView: createView,
		cellItemClicked: cellItemClicked,
		deleteColumn: deleteColumn,
		cancelDeleteColumn: cancelDeleteColumn,
		saveHeaderCell: saveHeaderCell,
		saveCell: saveCell,
		saveProfilesDashboardResponse: saveProfilesDashboardResponse
	};
}());

