/* global
	profilesDashboardEditor: false */

var profilesDashboardEditorUtil = (function() {

	'use strict';

	// This are profiles view editor utilities.

	var YE = YAHOO.util.Event;
	var editPanel = null;
	var isHeaderCell = false;
	var activeColIndex = 0;
	var reportFieldsByProfile = {}; // Note, this contains aggregating report fields only!

	var activeProfileName = '';

	function init(profilesDb) {

		var panelObj = {
			panelId: 'edit_cell:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			zIndex: 30,
			isCover: true,
			closeEvent: _closeEditCell
		};

		editPanel = new util.Panel3(panelObj);

		// Populate profiles list
		var a = [{name:'', label:'(None)'}];
		for (var i = 0, len = profilesDb.length; i < len; i++) {
			var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);
			a[i] = {name: profileItem.name, label: profileItem.label};
		}

		// Insert 1st list item
		a.splice(0, 0, {name:'', label:'(' + langVar('lang_stats.btn.none') + ')'});

		util.populateSelect('edit_cell:profiles_list', a, 'name', 'label');

		YE.addListener('edit_cell:cancel_btn', 'click', _closeEditCell);
		YE.addListener('edit_cell:ok_btn', 'click', _saveCell);

		YE.addListener('edit_cell:profiles_list', 'change', profileSelected);
		YE.addListener('edit_cell:show_column_label', 'click', _setShowColumnLabel);
		YE.addListener('edit_cell:show_cell_labels', 'click', _setShowCellLabels); // header cell
		YE.addListener('edit_cell:show_cell_label', 'click', _setShowCellLabel); // body cell
	}

	function editColumn(colIndex, colObj) {

//		alert('editColumn: ' + colIndex);
//		util.showObject(colObj);

		// activeProfileName is the profile defined
		// in the cell header.

		activeProfileName = colObj.profile_name;

		isHeaderCell = true;
		activeColIndex = colIndex;
		_updateForm(colObj);
		editPanel.prePositionAtCenter();
		editPanel.open({label: langVar('lang_admin.profiles.edit_column')});
	}

	function editCell(colIndex, colObj, profileName) {

		// activeProfileName is the profile of the row.
		activeProfileName = profileName;
		isHeaderCell = false;
		activeColIndex = colIndex;
		_updateForm(colObj);
		editPanel.prePositionAtCenter();
		editPanel.open({label: langVar('lang_admin.profiles.edit_cell')});
	}

	function _updateForm(colObj) {

//		util.showObject(colObj);

		if (isHeaderCell) {

			util.setF('edit_cell:profiles_list', activeProfileName);
			_handleReportFieldsList(activeProfileName, colObj.report_field);

			var showColumnLabel = colObj.show_column_label;
			var showCellLabels = colObj.show_cell_labels;

			util.setF('edit_cell:show_column_label', showColumnLabel);
			util.setF('edit_cell:show_cell_labels', showCellLabels);

			util.setF('edit_cell:column_label', colObj.column_label);
			util.setF('edit_cell:cell_label', colObj.cell_label);

			util.showE('edit_cell:column_label:section', showColumnLabel);
			util.showE('edit_cell:cell_label_section', showCellLabels);
		}
		else {

			var profileCellItem = _getProfileCellItem(colObj);
			_handleReportFieldsList(activeProfileName, profileCellItem.report_field);

			var showLabel = profileCellItem.show_label;
			util.setF('edit_cell:show_cell_label', showLabel);
			util.showE('edit_cell:cell_label_section', showLabel);

			util.setF('edit_cell:cell_label', profileCellItem.label);
		}

		util.showE('edit_cell:profiles_list_section', isHeaderCell);
		util.showE('edit_cell:header_cell_section', isHeaderCell);
		util.showE('edit_cell:cell_section', !isHeaderCell);
	}

	function profileSelected(evt) {

		var profileName = util.getF('edit_cell:profiles_list');
		activeProfileName = profileName;

		var selectedReportField = '';
		_handleReportFieldsList(profileName, selectedReportField);
	}

	function _setShowColumnLabel() {

		util.showE('edit_cell:column_label:section', this.checked);
	}

	function _setShowCellLabels() {

		util.showE('edit_cell:cell_label_section', this.checked);
	}

	function _setShowCellLabel() {

		util.showE('edit_cell:cell_label_section', this.checked);
	}

	function _handleReportFieldsList(profileName, selectedReportField) {

		// Reset report fields list
		util.populateSelect('edit_cell:report_field_list', [{name:'', label:'(' + langVar('lang_stats.btn.none') + ')'}], 'name', 'label');
		var makeEnabled = false;

		if (profileName !== '') {

			if (reportFieldsByProfile.hasOwnProperty('_' + profileName)) {

				makeEnabled = true;
				_updateReportFieldsList(profileName, selectedReportField);
			}
			else {

				// Load report fields
				var url = '?dp=admin_pages.profiles_dashboard.get_report_fields_data';
				var dat = 'v.fp.page_token=' + pageInfo.pageToken;
				dat += '&v.fp.profile_name=' + profileName;
				dat += '&v.fp.selected_report_field=' + selectedReportField;
				util.serverPost(url, dat);
			}
		}

		util.enableE('edit_cell:report_field_list', makeEnabled);
	}

	function handleReportFieldsListResponse(dat) {

		function compareLabels(a, b) {
			var labelA = a.label.toLowerCase();
			var labelB = b.label.toLowerCase();
			if (labelA < labelB) {
				return -1;
			}
			else if (labelA > labelB) {
				return 1;
			}
			return 0;
		}

		var reportFieldsDb = dat.report_fields_db;
		reportFieldsDb.sort(compareLabels);

		var profileName = dat.profile_name;
		var selectedReportField = dat.selected_report_field;

		reportFieldsByProfile['_' + profileName] = reportFieldsDb;

		// Update list if profile is still selected/active
		if (activeProfileName === profileName) {
			_updateReportFieldsList(profileName, selectedReportField);
		}
	}

	function _updateReportFieldsList(profileName, selectedReportField) {

		// This assumes that reportFields are already loaded and that
		// the first list entry (None) already exists.

		var reportFields = reportFieldsByProfile['_' + profileName];
		util.extendSelect('edit_cell:report_field_list', reportFields, 'name', 'label');
		util.enableE('edit_cell:report_field_list');
		util.setF('edit_cell:report_field_list', selectedReportField);
	}

	function _closeEditCell() {

		editPanel.close();
	}

	function _saveCell() {

		// This saves column and cell changes

		if (isHeaderCell) {
			_saveHeaderCell();
		}
		else {
			_saveSimpleCell();
		}

		// Rebuild profilesView
		profilesDashboardEditor.createView();
		
		_closeEditCell();
	}

	function _saveHeaderCell() {

		// This saves column and cell changes

		var reportField = util.getF('edit_cell:report_field_list');

		// Ignore profile_name if no report field has been selected
		var profileName = (reportField !== '') ? util.getF('edit_cell:profiles_list') : '';

		var reportFieldLabels = _getReportFieldLabels(profileName, reportField);

		var showColumnLabel = util.getF('edit_cell:show_column_label');
		var columnLabel = '';

		if (showColumnLabel) {

			columnLabel = util.getF('edit_cell:column_label');

			// Reset showColumnLabel if no label exists
			if (reportField === '' && columnLabel === '') {
				showColumnLabel = false;
			}
		}

		// Ignore cell label if no report field per column is defined
		var showCellLabels = false;
		var cellLabel = '';

		if (reportField !== '') {

			showCellLabels = util.getF('edit_cell:show_cell_labels');

			if (showCellLabels) {
				cellLabel = util.getF('edit_cell:cell_label');
			}
		}

		var obj = {
			profile_name: profileName,
			report_field: reportField,
			raw_report_field_label: reportFieldLabels.rawLabel,
			report_field_label: reportFieldLabels.label,
			show_column_label: showColumnLabel,
			column_label: columnLabel,
			show_cell_labels: showCellLabels,
			cell_label: cellLabel
		};

		profilesDashboardEditor.saveHeaderCell(activeColIndex, obj);
	}

	function _saveSimpleCell() {

		// This saves cell changes of a specific profile

		var reportField = util.getF('edit_cell:report_field_list');
		var reportFieldLabels = _getReportFieldLabels(activeProfileName, reportField);

		var showLabel = util.getF('edit_cell:show_cell_label');
		var cellLabel = '';

		if (showLabel && reportField !== '') {
			cellLabel = util.getF('edit_cell:cell_label');
		}

		var obj = {
			profile_name: activeProfileName,
			report_field: reportField,
			raw_report_field_label: reportFieldLabels.rawLabel,
			report_field_label: reportFieldLabels.label,
			show_label: showLabel,
			label: cellLabel
		};

		profilesDashboardEditor.saveCell(activeColIndex, obj, activeProfileName);
	}


	function _getProfileCellItem(colObj) {

		// Returns the cell object for activeProfileName
		// if such a cell exists in the colObj.

		// Set default profileCellObj
		var profileCellObj = {
			profile_name: '',
			show_label: '',
			label: '',
			report_field: '',
//			expression: ''
		};

		// Check if activeProfileName exists in
		// colObj.profiles
		var profiles = colObj.profiles;
		for (var i = 0, len = profiles.length; i < len; i++) {
			var item = profiles[i];

			if (item.profile_name === activeProfileName) {

				// Override profileCellObj with actual profile cell data
				for (var prop in item) {
					profileCellObj[prop] = item[prop];
				}

				break;
			}
		}

		return profileCellObj;
	}

	function _getReportFieldLabels(profileName, reportFieldName) {

		// Returns the report field raw label and label
		var obj = {rawLabel:'', label:''};

		if (profileName !== '' && reportFieldName !== '') {

			var reportFields = reportFieldsByProfile['_' + profileName];
			var item = null;

			for (var i = 0, len = reportFields.length; i < len; i++) {

				item = reportFields[i];

				if (item.name === reportFieldName) {
					obj.rawLabel = item.rawLabel;
					obj.label = item.label;
					break;
				}
			}
		}

		return obj;
	}

	// Return global properties and methods
	return {
		init: init,
		editColumn: editColumn,
		editCell: editCell,
//		closeEditCell: closeEditCell,
//		saveCell: saveCell,
		handleReportFieldsListResponse: handleReportFieldsListResponse
//		setShowColumnLabel: setShowColumnLabel
	};
}());

