//
// Imports filter items and filter groups from scheduler actions and reports
// of the same profile and user.
//


/* global
	scheduler: false
	ReportFiltersPanel: false */


var importReportFilters = (function() {

	'use strict';
	
  	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		panel = null,

		// The filtersPanel which shows the items to import.
		filtersPanel = null,

		// A reference to filter items and groups which
		// already exist as saved items or items to be saved.
		// Note, this are saved items in scheduler actions,
		// not the once loaded from users_cache.

		filtersLookup = {},
		filterGroupLabelsLookup = {},

		// Items to import which are not duplicates with
		// already saved items.
		filterItemsToImport = [],
		filterGroupsToImport = [],

		profileName = '',
		queryFieldsDb = [];

	function _init() {

		var panelObj = {
			panelId:"import_rf:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.scheduler.import_report_filters'),
//			left: 70,
//			top: 80,
			zIndex: 80,
			isCover: true,
			isSticky: true,
			closeEvent: _close
		};

		panel = new util.Panel3(panelObj);

		// Create a minimalistic filters panel
		filtersPanel = new ReportFiltersPanel({
			containerId: 'import_rf:container',
			filterItemsSelectCallback: importReportFilters.filterItemsSelectionListener

		});

		YE.addListener('import_rf:import_btn', 'click', _import);
		YE.addListener('import_rf:cancel_btn', 'click', _close);
	}

	function open(_profileName, _queryFieldsDb, existingFilterItems) {

		// This is called via the main reportFiltersPanel

		// NOTE, WE GET ONLY filterItems which already includes the groups!

//		util.showObject(existingFilterItems, 'existingFilterItems');

		profileName = _profileName;
		queryFieldsDb = _queryFieldsDb;

		// Reset
		filtersLookup = {};
		filterGroupLabelsLookup = {};
		filterItemsToImport = [];
		filterGroupsToImport = [];

		// Add filters which already exist to filtersLookup
		// so that we don't show duplicates to import.
		var filterId;
		for (var i = 0, numItems = existingFilterItems.length; i < numItems; i++) {

			var filterItem = existingFilterItems[i];

			if (!filterItem.hasOwnProperty('items')) {

				// This is a filterItem
				filterId = repFiltersUtil.getFilterItemAsString(filterItem);
			}
			else {

				// This is a filterGroup
				filterId = repFiltersUtil.getFilterGroupId(filterItem);

				// Add group label to filterGroupLabelsLookup
				var groupLabel = filterItem.label;
				filterGroupLabelsLookup['_' + groupLabel] = true;
			}

			filtersLookup[filterId] = true;
		}

		// Open Import panel

		if (panel === null) {
			_init();
		}

		// Set panel text
		// TODO - Getting the profileLabel looks a bit of hack because
		// we don't won't any scheduler dependencies here.
		var profileItem = scheduler.profilesDb[util.h(profileName)];
		var profileLabel = profileItem.label;

		var infoText = langVar('lang_admin.scheduler.import_report_filters_info');
		infoText = infoText.replace(/__PARAM__1/, '<strong>' + profileLabel + '</strong>');
		var infoTextContainer = util.getE('import_rf:import_report_filters_info');
		infoTextContainer.innerHTML = infoText;

		// Reset filtersPanel
		filtersPanel.initFilters(profileName, queryFieldsDb, [], []);

		var viewportWidth = YD.getViewportWidth();

		// If large display
		if (viewportWidth > 1000) {

			// Set import panel position
			var region = YD.getRegion('sa:report_filters');
			var left = region.left;
			var top = region.top - 60;

			panel.open({
				left: left,
				top: top
			});
		}
		else {

			// If small display
			panel.prePositionAtCenter();
			panel.open();
		}

		// Get filter items and filter groups already used in scheduler
		var a = _getUsedReportFiltersInScheduler();

//		util.showObject(a);

		_addToFilterItemsToImport(a.filterItems);
		_addToFilterGroupsToImport(a.filterGroups);

		// Get saved filter items and groups
		_getSavedReportFilters(profileName);
	}

	function _close() {

		panel.close();
	}

	function filterItemsSelectionListener(isSelectedItem) {

		// Enables/disables import button
		util.enableE('import_rf:import_btn', isSelectedItem);
	}

	function _import() {

		util.disableE('import_rf:import_btn');

		var activeFilterItemsAndGroups = filtersPanel.getActiveItems();
		schedulerActions.importReportFilterItemsAndGroups(activeFilterItemsAndGroups);

		// Close the Import panel.
		_close();
	}

	function _getUsedReportFiltersInScheduler() {

		// Returns all used report filters and filter groups of scheduler

		var itemsDb = scheduler.itemsDb;
		var filterItems = [];
		var filterGroups = [];

	//	util.showObject(itemsDb);
		for (var i = 0, len = itemsDb.length; i < len; i++) {

			if (itemsDb[i].dat.hasOwnProperty('actions')) {

				var actions = itemsDb[i].dat.actions;

				for (var j = 0, numActions = actions.length; j < numActions; j++) {

					var theAction = actions[j];

					if (theAction.hasOwnProperty('report_filters')) {

						var reportFilters = theAction.report_filters;

						if (reportFilters.filter_items.length > 0) {

							var existingFilterItems = util.cloneObject(reportFilters.filter_items);

							// Add existingFilterItems to filterItems
							_addFilterItemToUsedReportFilters(existingFilterItems, filterItems);
						}

						if (reportFilters.filter_groups.length > 0) {

							var existingFilterGroups = util.cloneObject(reportFilters.filter_groups);

							// Add existingFilterGroups to filterGroups
							_addFilterItemToUsedReportFilters(existingFilterGroups, filterGroups);
						}
					}
				}
			}
		}

		return {filterItems: filterItems, filterGroups: filterGroups};
	}

	function _addFilterItemToUsedReportFilters(itemsToBeAdded, theItems) {

		for (var i = 0, len = itemsToBeAdded.length; i < len; i++) {

			var filterItemOrGroup = util.cloneObject(itemsToBeAdded[i]);
			theItems.push(filterItemOrGroup);
		}
	}

	function _getSavedReportFilters(profileName) {

		var url = '?dp=admin_pages.scheduler.get_saved_report_filters';

		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profile_name=' + profileName;
		util.serverPost(url, dat);
	}

	function getSavedReportFiltersResponse(dat) {

//		util.showObject(dat);
		_addToFilterItemsToImport(dat.filterItems);
		_addToFilterGroupsToImport(dat.filterGroups);

		// Show filters
		filtersPanel.initFilters(profileName, queryFieldsDb, filterItemsToImport, filterGroupsToImport);
	}

	function _addToFilterItemsToImport(filterItems) {

		// This adds non-duplicate filter items to filterItemsToImport
		for (var i = 0, len = filterItems.length; i < len; i++) {

			var filterItem = filterItems[i];

			// Check if the filter item fields actually exist for this profile.
			if (repFiltersUtil.getIsValidFilterFields(queryFieldsDb, filterItem)) {

				var filterId = repFiltersUtil.getFilterItemAsString(filterItem);

				// Add filter item if it doesn't yet exist.
				if (!filtersLookup.hasOwnProperty(filterId)) {

					var clonedFilterItem = util.cloneObject(filterItem);
					clonedFilterItem.isActive = false;
					filterItemsToImport.push(clonedFilterItem);
				}
			}
		}
	}

	function _addToFilterGroupsToImport(filterGroups) {

		// This adds non-duplicate filter groups to filterGroupsToImport
		for (var i = 0, len = filterGroups.length; i < len; i++) {

			var filterGroup = filterGroups[i];

			// If one filter item in group has an invalid field then
			// ignore the group.
			var subitems = filterGroup.items;
			var allSubitemsValid = true;
			for (var j = 0, numSubitems = subitems.length; j < numSubitems; j++) {
				var subitem = subitems[j];
				if (!repFiltersUtil.getIsValidFilterFields(queryFieldsDb, subitem)) {
					allSubitemsValid = false;
					break;
				}
			}

			if (allSubitemsValid) {

				var groupId = repFiltersUtil.getFilterGroupId(filterGroup);

				// Add filter group if it doesn't yet exist.
				if (!filtersLookup.hasOwnProperty(groupId)) {

					var clonedGroupItem = util.cloneObject(filterGroup);
					clonedGroupItem.isActive = false;

					// Reset the group node name because it becomes
					// re-generated when importing the groups in
					// reportFiltersPanel.
					clonedGroupItem.name = '';

//					util.showObject(clonedGroupItem, 'clonedGroupItem');

					// Check for unique group labels because it is
					// possible that two groups with different group ID
					// have the same label
					var groupLabel = clonedGroupItem.label;

					if (filterGroupLabelsLookup.hasOwnProperty('_' + groupLabel)) {

						groupLabel = _getUniqueGroupLabel(groupLabel);
						clonedGroupItem.label = groupLabel;
					}

					// Add final label to filterGroupLabelsLookup
					filterGroupLabelsLookup['_' + groupLabel] = true;

					filterGroupsToImport.push(clonedGroupItem);
				}
			}
		}
	}

	function _getUniqueGroupLabel(groupLabel) {

		var newGroupLabel = '';
		var isUnique = false;
		var count = 2;

		while (!isUnique) {

			newGroupLabel = groupLabel + ' (' + count + ')';
			isUnique = !filterGroupLabelsLookup.hasOwnProperty('_' + newGroupLabel);
			count++;
		}

		return newGroupLabel;
	}

	// Return global properties and methods
	return {
		open: open,
		filterItemsSelectionListener: filterItemsSelectionListener,
		getSavedReportFiltersResponse: getSavedReportFiltersResponse
	};

}());