//
// logFields.js
//

var logFields = {
	
	itemsDb: [], // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	
	logFieldIdsUsedInDbFields: {}, 
	/*
	itemId's of log fields used in database fields, its value is an array of the database field labels where the log field is used.
	logFieldIdsUsedInDbFields = {
		i0: ['db field label 1', 'db field label 2'],
		i2: ['db field label 5'],
		...
	}
	*/
	
	logFieldIdsUsedInLogFields: {}, 
	/*
	itemId's of log fields from which other log fields are derived, its value is an array with itemId's where the log field is used in other log fields.
	logFieldIdsUsedInLogFields = {
		i0: ['i7'],
		i2: ['i20', 'i34'],
		...
	}
	*/
	
	theList: null,
	
	validator: null,
	
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	
	nodeNamePrefix: 'log_field',
	
	activeForm: {
		oriNodeName: '',
		oriLabel: '',
		isDisabledForm: false // required in logFieldsUtil.js
	},
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		logFields.validator = new util.Validator();
	
		logFields.initToolbar();
		
		YE.addListener('log_fields:label', 'keyup', logFieldsUtil.updateListLabelActor);
		
		// Init identifier
		identifier.init();
		
		YE.addListener('type', 'change', logFieldsUtil.typeActor);	
		
		// Create theList object
		logFields.theList = new listcontroller.List({
			containerElementId: 'item_list_body',
			itemEvent: logFields.itemActivated
		});
		
		// init OptionInfo
		optionInfo.init();
	},
	
	initToolbar: function() {
		
		//
		// init toolbar buttons
		//
		
		logFields.saveChangesBtn = new util.ToolbarButton('save_changes', logFields.saveLogFields, toolbarButtonsDb);		
		logFields.newItemBtn = new util.ToolbarButton('new_log_field', logFields.newItem, toolbarButtonsDb);
		logFields.duplicateBtn = new util.ToolbarButton('duplicate', logFields.duplicateItem, toolbarButtonsDb);
		logFields.deleteBtn = new util.ToolbarButton('delete', logFields.deleteItem, toolbarButtonsDb);
		logFields.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', logFields.undoAllChanges, toolbarButtonsDb);
		
		var permissions = pageInfo.permissions;
		
		if (permissions.isEdit) {
			
			if (!permissions.isAdd) {
				logFields.newItemBtn.disableAndIgnore();
				logFields.duplicateBtn.disableAndIgnore();
			}
			
			if (!permissions.isDelete) {
				logFields.deleteBtn.disableAndIgnore();
			}
			
			// Register isModifiedPageHandler in adminConfig.js
			// (We don't check for modifications if there is no edit 
			// permission because there is no Save button anyway!)
			adminConfig.getIsModifiedPageHandler = logFields.getIsModifiedPage;
		}
		else {
			
			logFields.saveChangesBtn.disableAndIgnore();
			logFields.newItemBtn.disableAndIgnore();
			logFields.duplicateBtn.disableAndIgnore();
			logFields.deleteBtn.disableAndIgnore();
			logFields.undoAllChangesBtn.disableAndIgnore();
		}
	},

	initItemList: function() {
		
		var theList = logFields.theList;
		
		theList.init(logFields.itemsDb);
		
		// select the first item
		var firstItemId = theList.getFirstItemId();
		logFields.setItem(firstItemId);
	},
	
	getLogFieldsData: function() {

	if (!pageInfo.exitActive) {	
		var url = '?dp=config_pages.log_fields.get_log_fields_data';
		url += '&p=' + pageInfo.profileName;
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			
			// Init help
			util.helpWindow.init('');

			util.serverPost(url, dat);
		}
	},
	
	getLogFieldsDataResponse: function(dat) {
		
		if (!pageInfo.exitActive) {
			
			// get itemsDb
			logFields.itemsDb = dat.logFieldsDb;
			logFields.itemsDbBackup = util.cloneObject(dat.logFieldsDb);
			
			// Get logFieldIdsUsedInDbFields
			logFields.logFieldIdsUsedInDbFields = dat.logFieldIdsUsedInDbFields;
			
			// Get logFieldIdsUsedInLogFields
			logFields.logFieldIdsUsedInLogFields = dat.logFieldIdsUsedInLogFields;
			
			// Init		
			logFields.init();
			logFields.initItemList();
			
			logFields.saveChangesBtn.enable();
			logFields.newItemBtn.enable();
			logFields.undoAllChangesBtn.enable();
			
			util.showE('form_section');
			
			adminConfig.setItemListSize();
			YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
			
			pageInfo.initComplete = true;
		}
	},
	
	itemActivated: function(itemId) {
		
		if (logFields.validateActiveItem()) {
			logFields.setItem(itemId);
		}
	},
	
	setItem: function(itemId) {
		
		// selects active item in list and displays the form
		// alert('set item: ' + itemId);
		logFields.theList.selectItem(itemId);
		logFields.updateForm(itemId);
	},
	

	newItem: function() {
		
		if (logFields.validateActiveItem()) {
			
			var theList = logFields.theList;
		
			var newItemId = theList.getNewItemId();
			var label = langVar('lang_admin.log_fields.new_log_field');
			
			var newLogField = {
				id: newItemId,
				type: '',
				label: label,
				dat: {
					node_name: '',
					ori_node_name: '',
					label: label,
					ori_label: '',
					type: '',
					index: 0,
					subindex: 0,
					case_sensitive: false
				}
			}
			
			theList.newItem(newLogField);
			logFields.setItem(newItemId);
		}
	},

	duplicateItem: function() {
		
		if (logFields.validateActiveItem()) {
			
			var theList = logFields.theList;
			
			var clonedItemId = theList.cloneItem();
			// reset node_name and ori_node_name
			theList.setItemDatValue(clonedItemId, 'node_name', '');
			theList.setItemDatValue(clonedItemId, 'ori_node_name', '');
			theList.setItemDatValue(clonedItemId, 'ori_label', '');
			logFields.setItem(clonedItemId);
		}
	},
	
	deleteItem: function() {
		
		var theList = logFields.theList;
		
		var selectedItemId = theList.selectedItemId;
		
		var logFieldIdsUsedInDbFields = logFields.logFieldIdsUsedInDbFields;
		var logFieldIdsUsedInLogFields = logFields.logFieldIdsUsedInLogFields;
		
		var usedInDbFieldLabels = [];
		var usedInLogFieldLabels = [];
		var i;
		
		//
		// Check if the log field is used in database fields
		//
		
		if (logFieldIdsUsedInDbFields[selectedItemId]) {
			usedInDbFieldLabels = logFieldIdsUsedInDbFields[selectedItemId];
		}
		
		// Check if the log field is used in log fields (fields which are derived from the selected field)
		
		if (logFieldIdsUsedInLogFields[selectedItemId]) {
			
			// alert('logFieldIdsUsedInLogFields: IS USED');
			
			var usedInLogFieldIds = logFieldIdsUsedInLogFields[selectedItemId];
			var itemIdsWithLabelsObj = logFieldsUtil.getItemIdsWithLabelsObject(logFields.itemsDb);
			
			for (i = 0; i < usedInLogFieldIds.length; i++) {
				var itemId = usedInLogFieldIds[i];
				usedInLogFieldLabels[i] = itemIdsWithLabelsObj[itemId];
			}
		}
		
		if (usedInDbFieldLabels.length == 0 && usedInLogFieldLabels.length == 0) {
			
			// Delete the item
			
			var nextItemIdToBeSelected = theList.deleteItem();
			
			// reset the validator in case that the deleted item indicated an error
			logFields.validator.reset();
			logFields.setItem(nextItemIdToBeSelected);
		}
		else {
			
			// Delete not allowed.
			// The log field item is used in log fields as derived item or in database fields.
			// Show alert message
			
			var msg = langVar('lang_admin.log_fields.cannot_be_deleted_msg') + '\n\n';
			
			if (usedInDbFieldLabels.length > 0) {
							
				for (var i = 0; i < usedInDbFieldLabels.length; i++) {
					msg += '- ' + langVar('lang_admin.log_fields.database_field') + ' "' + usedInDbFieldLabels[i] + '"\n';
				}
			}
			
			if (usedInLogFieldLabels.length > 0) {
							
				for (var i = 0; i < usedInLogFieldLabels.length; i++) {
					msg += '- ' + langVar('lang_admin.log_fields.log_field') + ' "' + usedInLogFieldLabels[i] + '"\n';
				}
			}
		
			alert(msg);
		}
	},
	
	updateForm: function(itemId) {
		
		var theList = logFields.theList;
			
		var item = theList.getSelectedItem();
		var itemDat = item.dat;
		
		// util.showObject(item);
		// util.showObject(itemDat);
		
		
		var activeForm = logFields.activeForm;
		activeForm.oriNodeName = itemDat.ori_node_name;
		activeForm.oriLabel = itemDat.ori_label;
		
		
		var isDerivedLogField = (itemDat.derived_from_1 != null || itemDat.derived_from_2 != null) ? true : false;
		var type = itemDat.type;
		
		// reset form values
		util.resetF('log_fields:form');
		
		logFieldsUtil.init(isDerivedLogField);
		
		var label = itemDat.label;
		// util.updateT('item_form_label', label);
		util.setF('log_fields:label', label);
		
		//
		// Handle identfier object
		//
		identifier.initUponUpdateForm(itemDat.node_name);
		
		if (isDerivedLogField) {
	
			if (itemDat.derived_from_1 != null) {
				
				var derivedFromItemId = itemDat.derived_from_1;
				var derivedFromItemLabel = theList.getItemDatValue(derivedFromItemId, 'label');
				util.setF('derived_from_1', derivedFromItemLabel);
				util.showE('derived_from_1_section');
			}
			
			if (itemDat.derived_from_2 != null) {
				
				var derivedFromItemId = itemDat.derived_from_2;
				var derivedFromItemLabel = theList.getItemDatValue(derivedFromItemId, 'label');
				util.setF('derived_from_2', derivedFromItemLabel);
				util.showE('derived_from_2_section');
			}
		}
		
		util.showEV('derived_field_info', isDerivedLogField);
		
		
		// alert('type: ' + item.type);
		
		util.setF('type', type);
		
		if (type == "hierarchical") {
		
			util.setF('hierarchy_dividers', itemDat.hierarchy_dividers);
			util.setF('left_to_right', itemDat.left_to_right);
			util.setF('leading_divider', itemDat.leading_divider);
			util.showE('hierarchical_section');
		}
		
		util.setF('index', itemDat.index);
		util.setF('subindex', itemDat.subindex);
		util.setF('case_sensitive', itemDat.case_sensitive);
	},
	
	validateActiveItem: function() {
		
		logFields.validator.reset();
		
		// Note, if this is a derived log field then we don't validate it!
		
		var item = logFields.theList.getSelectedItem();
		var itemDat = item.dat;
		
		// util.showObject(item);
		
		var isDerivedLogField = (itemDat.derived_from_1 != null || itemDat.derived_from_2 != null) ? true : false;
		
		if (!isDerivedLogField) {
			return logFields.validateItem();
		}
		
		// isDerivedLogField
		return true;
	},
	
	validateItem: function() {
		
		// Only validate if isEdit permission and if items
		
		var theList = logFields.theList;
		
		if (pageInfo.permissions.isEdit && theList.isItems()) {
		
			var validator = logFields.validator;
			var activeForm = logFields.activeForm;
			var o = {};
			
			o.ori_node_name = activeForm.oriNodeName;
			o.ori_label = activeForm.oriLabel;
			
			o.label = validator.isValue('log_fields:label');
			o.label = validator.isUnique('log_fields:label', theList.getLookupItems('label'), /* convertToLowercase */ true);
			
			//
			// handle node name
			//
			
			if (!identifier.isCustomIdentifier) {
				
				o.node_name = identifier.initialNodeName;
		
				// if this is a new field with empty node name give it a node name now
				if (o.node_name == '') {
					o.node_name = util.labelToUniqueNodeName(o.label, theList.getLookupItems('node_name'), logFields.nodeNamePrefix);
				}
			}
			else {
				
				// Custom identifier is active
				// validate for valid and unique node name 
				
				// KHP-RC, a custom node name change which is used in a source_database_field must be updated
				// in case that this object becomes saved!
				
				o.node_name = validator.isValue('identifier:node_name');
				o.node_name = validator.isNodeName('identifier:node_name');
				o.node_name = validator.isUnique('identifier:node_name', theList.getLookupItems('node_name'));
			}		
			
			o.type = validator.isValue('type');
	
			if (o.type == 'hierarchical') {
				
				// hierarchy_dividers input field is limited to two characters, so no length validation is required
				o.hierarchy_dividers = validator.isValue('hierarchy_dividers', false); // second argument false does not trim white space!
				o.left_to_right = util.getF('left_to_right');
				o.leading_divider = util.getF('leading_divider');
			}
			
			// index/subinex, if empty set them to 0, else validate for valid integer
			var index = util.getF('index');
			var subindex = util.getF('subindex');
			
			o.index = (index == '' || index == 0) ? 0 : validator.isInteger('index');
			o.subindex = (subindex == '' || subindex == 0) ? 0 : validator.isInteger('subindex');
			
			o.case_sensitive = util.getF('case_sensitive');
			
			// util.showObject(o);
			
			if (validator.allValid()) {
				theList.saveItem(o);
				return true;
			}
			
			return false;
		}
		
		// If no isEdit permission or if no items
		return true;
	},
	
	saveLogFields: function() {
		
		if (logFields.validateActiveItem()) {
			
			var theList = logFields.theList;
			var isModified = theList.getIsModified();
			
			// alert('saveChanges() - isModified: ' + isModified);
			
			if (isModified) {
				
				if (pageInfo.showRebuildDbAdvice) {
					
					rebuildDbAdvice.open(logFields.processSaveLogFields);
				}
				else {
					logFields.processSaveLogFields();
				}
			}
			else {
				
				alert(langVar('lang_stats.general.no_changes_to_save'));
			}
		}
	},
	
	processSaveLogFields: function(isHideRebuildDbAdviceMessage) {
		
		// This function may be invoked from rebuildDbAdvice.
		// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
		
		util.hideE('form_section');
		util.showE('saving_info');
		
		var setHideRebuildDbAdviceMessage = (arguments.length == 1) ? isHideRebuildDbAdviceMessage : false;
		
		var itemsDb = logFields.itemsDb;

		// Create itemId node_name lookup object so that we can replace the itemId's in derived_from_1 and derived_from_2
		// property with the actual node name because this values only exist as itemId.
		var itemIdsWithNodeNamesLookup = logFieldsUtil.getItemIdsWithNodeNamesLookup(itemsDb);
		
		// util.showObject(itemIdsWithNodeNamesLookup);
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
		dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
		var path = 'v.fp.log_fields';
		var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]

		for (var i = 0; i < itemsDb.length; i++) {
			
			var item = itemsDb[i];
			var itemDat = item.dat;
			var path = 'v.fp.log_fields.' + itemDat.node_name;
			
			dat += path + '.is_new=' + item.isNew + '&';
			
			for (var prop in itemDat) {
				
				if (prop != 'node_name') {
				
					var theValue = itemDat[prop];
					
					if (prop == 'derived_from_1' || prop == 'derived_from_2') {
						// replace itemId with node_name
						theValue = itemIdsWithNodeNamesLookup[theValue];
					}
					
					if (pattern.test(theValue)) {
						theValue = encodeURIComponent(theValue);
					}
					
					dat += path + '.' + prop + '=' + theValue + '&';
				}
			}
		}
		
		pattern = /&$/;
		dat = dat.replace(pattern, '');
		
		// alert('dat:\n' + dat);
		
		var url = '?dp=config_pages.log_fields.save_log_fields';
		url += '&p=' + pageInfo.profileName;
		
		util.serverPost(url, dat);
	},
	
	processSaveLogFieldsResponse: function(dat) {
		
		// As new nodeNames might have been applied we must update
		// the ori_node_name of all items and the active form item!
		
		var theList = logFields.theList;
		var itemsDb = logFields.itemsDb;
		
		for (var i = 0; i < itemsDb.length; i++) {
			var item = itemsDb[i];
			var itemDat = item.dat;
			item.isNew = false;
			item.isModified = false;
			itemDat.ori_node_name = itemDat.node_name;
		}
		
		// reset isModified
		theList.resetIsModified();
		
		// the saved work itemsDb becomes now the itemsDbBackup
		logFields.itemsDbBackup = util.cloneObject(logFields.itemsDb);
		
		// update form
		var selectedItemId = theList.getSelectedItemId();
		logFields.updateForm(selectedItemId);

		// Update profilesListChecksum checksum
		profilesStorage.update(dat.profileChanges);
		
		util.hideE('saving_info');
		util.showE('form_section');
	},
	
	undoAllChanges: function() {
		
		logFields.itemsDb = util.cloneObject(logFields.itemsDbBackup);
		logFields.initItemList();
	},
	
	getIsModifiedPage: function() {
		
		if (!logFields.validateActiveItem() || logFields.theList.getIsModified()) {
			return true;
		}
		
		return false;
	}
};
