//
// logFilters.js
//


var logFilters = {
		
	theList: null,
	// actionsList: null,
	// actionsMoveControl: null,
	boolOrWord: '', // the boolean OR word, it is always lowercase
	boolAndWord: '', // // the boolean AND word, it is always lowercase
	sequenceLettersDb: [], // Array with sequence letters ['A','B','C', ...], sequence letters are always uppercase
	conditionOperatorsDb: {},
	conditionOperatorLabelsDb: {}, // Created from conditionOperatorsDb for quick label lookup
	logFieldsDb: [], // Contains all log fields (string, int, float)
	logFieldsOfTypeStringDb: [], // Contains log fields of type string
	itemsDb: [],  // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	validator: null,
	
	// mainButtons;
	saveLogFiltersBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	newAlternativeActionBtn: null,
	
	noItemFormIsActive: false,
	structuredItemsMoveControlIsPositioned: false,
	
	//
	// active form data
	//
	
	activeFilterType: '', // structured || expression, the active filter type in display
	activeLabelOri: '', // Only used to transfer the variable into new object
	activeComment: '', // keeps active item comment (original or modified)
	activeCommentOri: '' // Only used to transfer the variable into new object
};


function init() {
	
	var YE = YAHOO.util.Event;
	
	var i;	
	
	// Create conditionOperatorLabelsDb
	var conditionOperatorsDb = logFilters.conditionOperatorsDb;
	var conditionOperatorLabelsDb = {};
	for (var prop in conditionOperatorsDb) {
		var operators = conditionOperatorsDb[prop];
		for (i = 0; i < operators.length; i++) {
			conditionOperatorLabelsDb['_' + operators[i].name] = operators[i].label;
		}
	}
	logFilters.conditionOperatorLabelsDb = conditionOperatorLabelsDb;
	
	// util.showObject(logFilters.conditionOperatorLabelsDb);
	
	// Create logFieldsOfTypeStringDb
	var logFieldsDb = logFilters.logFieldsDb;
	var logFieldsOfTypeStringDb = [];
	for (i = 0; i < logFieldsDb.length; i++) {
		var item = logFieldsDb[i];
		if (item.dbFieldType == 'string') {
			logFieldsOfTypeStringDb[logFieldsOfTypeStringDb.length] = {name:item.name, label:item.label};
		}
	}
	logFilters.logFieldsOfTypeStringDb = logFieldsOfTypeStringDb;
	
	
	logFilters.validator = new util.Validator();
	
	//
	// init toolbar buttons and form controls
	//
	
	logFilters.saveLogFiltersBtn = new util.ToolbarButton('save_changes', saveLogFilters, toolbarButtonsDb);		
	logFilters.newItemBtn = new util.ToolbarButton('new_log_filter', newItem, toolbarButtonsDb);
	logFilters.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	logFilters.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	logFilters.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
		
	// Create theList object
	logFilters.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		isSwitch1: true,
		isMoveControl: true
	});
	
	// Add events

	YE.addListener('log_filters:label', 'keyup', updateListAndFormLabel);
	
	YE.addListener('log_filters:structured:new_condition_btn', 'click', logFilterCondition.newItem);
	YE.addListener('log_filters:structured:new_action_btn', 'click', logFilterAction.newActionItem);
	// YE.addListener('log_filters:structured:new_alternative_action_btn', 'click', logFilterAction.newAlternativeActionItem);

	// New Alternative Action must be a command link which can be enabled/disabled
	var commandLinkOptions = {
		classNameEnabled: 'command-link-50',
		classNameDisabled: 'command-link-50-disabled'
	};	
	logFilters.newAlternativeActionBtn = new util.CommandLink('log_filters:structured:new_alternative_action_btn', logFilterAction.newAlternativeActionItem, true, commandLinkOptions);
	
	
	YE.addListener('log_filters:type', 'change', logFiltersUtil.filterType.toggleDisplay);
	YE.addListener('log_filters:boolean_operator', 'change', logFiltersUtil.boolOperator.toggleOperator);

	YE.addListener(['log_filters:comment:add_edit_btn_1', 'log_filters:comment:add_edit_btn_2'], 'click', editComment);
	
	
	YE.addListener('log_filters:view_log_fields:view_btn', 'click', logFilterExpressionFields.open);
	YE.addListener('log_filters:view_log_fields:view_examples_btn', 'click', util.helpWindow.openGeneralHelp);

	
	//
	// Ignore/Disable buttons according RBAC
	//
	
	var permissions = pageInfo.permissions;
	
	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			logFilters.newItemBtn.disableAndIgnore();
			logFilters.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			logFilters.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		logFilters.saveLogFiltersBtn.disableAndIgnore();
		logFilters.newItemBtn.disableAndIgnore();
		logFilters.duplicateBtn.disableAndIgnore();
		logFilters.deleteBtn.disableAndIgnore();
		logFilters.undoAllChangesBtn.disableAndIgnore();
	}
	
	//
	// init structured filter lists
	//
	
	logFilterLists.init();
	
	// init view available log fields and log filter comment
	logFilterExpressionFields.init(logFilters.logFieldsDb);
	logFilterComment.init(updateCommentDisplay);
	
}

function initMainDisplay() {
	
	util.hideE(['form_section', 'loading_info', 'saving_info']);
	
	var firstItemId = logFilters.theList.getFirstItemId();
	
	if (firstItemId != null) {
		
		setItem(firstItemId);
		displayNoItemForm(false);
	}
	else {
		// no item exists
		displayNoItemForm(true);
	}
	
	util.showE('form_section');
}


function getLogFiltersData() {
	
	if (!pageInfo.exitActive) {
		
		// Init help
		util.helpWindow.init('');

		// invoked upon editor load
		var url = '?dp=config_pages.log_filters.get_log_filters_data';
		url += '&p=' + pageInfo.profileName;
var dat = 'v.fp.page_token=' + pageInfo.pageToken;
	
		util.serverPost(url, dat);
	}
}

function getLogFiltersDataResponse(dat) {
	
	// alert('getLogFiltersDataResponse()');
	
	if (!pageInfo.exitActive) {
		
		logFilters.boolOrWord = dat.boolOrWord;
		logFilters.boolAndWord = dat.boolAndWord;
		logFilters.sequenceLettersDb = dat.sequenceLettersDb;
		
		logFilters.conditionOperatorsDb = dat.conditionOperatorsDb;
		
		logFilters.logFieldsDb = dat.logFieldsDb;
		util.createHash(logFilters.logFieldsDb, 'name');
		
		var itemsDb = dat.logFiltersDb;
		
		// Convert any boolean_operator_sequence in itemsDb from numerical format to presentational letter format!
		for (var i = 0; i < itemsDb.length; i++) {
			var itemDat = itemsDb[i].dat;
			if (itemDat.boolOperatorSequence != '') {
				// Convert boolOperatorSequence
				var numberOfConditions = itemDat.conditions.length;
				itemDat.boolOperatorSequence = logFiltersUtil.boolOperatorSequence.convertNumericalToLetterFormat(numberOfConditions, itemDat.boolOperatorSequence);
			}
		}
	
		logFilters.itemsDb = itemsDb;
		logFilters.itemsDbBackup = util.cloneObject(itemsDb);
	
		
		init();
		logFilters.theList.init(itemsDb);
		initMainDisplay();
		
		// IE 7 requires the form_section to be displayed before setItemListSize()
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		
		// Set final toolbar state
		logFilters.saveLogFiltersBtn.enable();
		logFilters.undoAllChangesBtn.enable();
		logFilters.newItemBtn.enable();
		updateToolbarButtons(); // handles Duplicate and Delete
		
		pageInfo.initComplete = true;
	}
}

function displayNoItemForm(isDisplayNoItemForm) {
	
	if (isDisplayNoItemForm) {
		// util.updateT('item_form_label', '-');
		util.hideE('log_filters:form');
		util.showE('no_item_form');
	}
	else {
		util.hideE('no_item_form');
		util.showE('log_filters:form');
	}

	logFilters.noItemFormIsActive = isDisplayNoItemForm;
}

function updateToolbarButtons() {
	
	var isItems = logFilters.theList.isItems();
	logFilters.deleteBtn.enable(isItems);
	logFilters.duplicateBtn.enable(isItems);
}

function updateListAndFormLabel() {
	
	setTimeout('setListAndFormLabel()', 300);
}

function setListAndFormLabel() {
	
	var label = util.getF('log_filters:label');
	if (label == '') {
		label = '-';
	}
	
	logFilters.theList.updateListLabel(label);
}

//
//
// Items
//
//


function setItem(itemId) {

	logFilters.theList.selectItem(itemId);
	updateForm();
}


function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		// if selected node item is valid then e to activated node item
		setItem(itemId);
	}
}

function newItem() {
	
	if (validateActiveItem()) {
	
		var newItemId = logFilters.theList.getNewItemId();
		var newLogFilterLabel = langVar('lang_admin.general.new_log_filter');
		
		var newFilterObj = {
			id: newItemId,
			type: '',
			switch1: true,
			label: newLogFilterLabel,
			dat: {
				type: 'structured',
				label: newLogFilterLabel,
				labelOri: '',
				comment: '',
				commentOri: '',
				expression: '',
				conditions: [],
				actions: [],
				alternativeActions: [],
				boolOperator: 'or',
				boolOperatorSequence: ''
			}
		};
		
		// util.showObject(newScheduleObj);
		logFilters.theList.newItem(newFilterObj);
		setItem(newItemId);
		updateToolbarButtons();
	}
}

function duplicateItem() {
	
	if (validateActiveItem()) {
		
		var theList = logFilters.theList
		var clonedItemId = theList.cloneItem();
		
		// Update created_by_user property
		// theList.setItemDatValue(clonedItemId, 'created_by_user', logFilters.activeUserNodeName);
		
		setItem(clonedItemId);
	}
}	

function deleteItem() {
	
	var theList = logFilters.theList;
	
	var nextItemIdToBeSelected = theList.deleteItem();
	
	if (nextItemIdToBeSelected != null) {
		
		// reset the validator to clear any error message of the deleted item
		logFilters.validator.reset();
		util.hideE('log_filters:structured:error'); // resets any structured filter error
		
		// select the next item
		setItem(nextItemIdToBeSelected);
	}
	else {
		
		// All items have been deleted
		displayNoItemForm(true);
		updateToolbarButtons();
	}
}

function updateForm() {
	
	var item = logFilters.theList.getSelectedItem();
	var itemDat = item.dat;
	// util.showObject(item);
	
	
	// Set non-editable data which are simply transferd to new object
	logFilters.activeLabelOri = itemDat.labelOri;
	logFilters.activeCommentOri = itemDat.commentOri;

	
	//
	// Reset form fields (don't reset entire form!)
	//
	
	var filterType = itemDat.type;
	var label = itemDat.label;
	
	if (logFilters.activeFilterType != filterType) {
		logFiltersUtil.filterType.updateDisplay(filterType);
	}
	
	util.setF('log_filters:label', label);
	
	var expression = itemDat.expression;
	
	// Temp structured items
	var structuredConditions = itemDat.conditions ? itemDat.conditions : [];
	var structuredActions = itemDat.actions ? itemDat.actions : [];
	var structuredAlternativeActions = itemDat.alternativeActions ? itemDat.alternativeActions : [];
	
	// Update the structured list and expression (so we don't need to reset them separately)
	
	logFilterLists.conditions.compose(structuredConditions);
	logFilterLists.actions.compose(structuredActions);
	logFilterLists.alternativeActions.compose(structuredAlternativeActions);
	
	// Reset logFilterLists (selectedItemIndexes)
	logFilterLists.reset();
	
	util.setF('log_filters:expression', expression);
	
	// Set/reset Boolean Operator (The section display is handled automatically through the list change notification)
	var boolOperator = itemDat.boolOperator;
	util.setF('log_filters:boolean_operator', boolOperator);
	util.setF('log_filters:boolean_operator_sequence', itemDat.boolOperatorSequence);
	logFiltersUtil.boolOperator.setOperatorDisplay(boolOperator);
	
	//
	// Set comment display
	//
	
	updateCommentDisplay(itemDat.comment);
	
	
	// Update form label
	// util.updateT('item_form_label', label);
	
	
	
	if (logFilters.noItemFormIsActive) {
		displayNoItemForm(false);
	}
	
	// Position the Lists Move Control
	if (!logFilters.structuredItemsMoveControlIsPositioned) {
		
		// We need to give it some time, else we don't get the right list position
		var s = 'log_filters:structured:move_control:position_reference';
		setTimeout('logFilterLists.moveControl.setPosition("' + s + '")', 250);
		logFilters.structuredItemsMoveControlIsPositioned = true;
	}
}

function validateActiveItem() {
	
	var theList = logFilters.theList;
	
	// Only validate if isEdit permission and if there are items
	
	if (pageInfo.permissions.isEdit && theList.isItems()) {
		
		var validator = logFilters.validator;
		
		var filterType = logFilters.activeFilterType;
		
		var o = {};
		o.type = filterType;
		o.label = validator.isValue('log_filters:label');
		o.label = validator.isUnique('log_filters:label', theList.getLookupItems('label'));
		o.labelOri = logFilters.activeLabelOri;
		o.comment = logFilters.activeComment;
		o.commentOri = logFilters.activeCommentOri;
		
		// KHP-RC, we may do this part later!
		// Note, WE NEED TO KNOW IF A STRUCTURED LIST HAS BEEN MODIFIED OR NOT
		// IF MODIFIED OR NEW THEN the expression value must be empty
		// ELSE WE KEEP THE EXISTING EXPRESSION!
		// For now we re-create the expressions on the server side for all structured
		// log filters!
		
		// Set defaults for structured and expression filter
		var expression = '';
		var conditions = [];
		var actions = [];
		var alternativeActions = [];
		var boolOperator = 'or';
		var boolOperatorSequence = '';
		
		var isValidStructuredFilter = true;
		
		if (filterType == 'expression') {
			expression = validator.isValue('log_filters:expression');
		}
		else {
			
			//
			// Validate lists
			//
			
			// Get the lists
			conditions = logFilterLists.conditions.getItemsClone();
			actions = logFilterLists.actions.getItemsClone();
			alternativeActions = logFilterLists.alternativeActions.getItemsClone();
			
			//
			// Validate boolean operator
			//
			
			var numberOfConditionItems = conditions.length;
			
			if (numberOfConditionItems > 1) {
				
				boolOperator = util.getF('log_filters:boolean_operator');
				
				if (boolOperator == 'custom') {
					
					// Validate custom boolean operator sequence
					
					boolOperatorSequence = validator.isValue('log_filters:boolean_operator_sequence');
					
					if (boolOperatorSequence != '') {
											
						// Validate the sequence
						
						var sequenceValidationObj = logFiltersUtil.boolOperatorSequence.validate(boolOperatorSequence, numberOfConditionItems);
						
						if (!sequenceValidationObj.isError) {
							// Get clean preentation of boolOperatorSequence
							boolOperatorSequence = sequenceValidationObj.sequence;
						}
						else {
							
							// Show custom error message
							validator.isCustom('log_filters:boolean_operator_sequence', sequenceValidationObj.errorMsg);
						}
					}
				}
			}
			
			//
			// Validate filter structure
			//
			
			var msg = '';
			if (actions.length == 0) {
				msg = langVar('lang_admin.log_filters.invalid_filter_structure_msg');
				// alert(msg);
				isValidStructuredFilter = false;
			}
			else if (alternativeActions.length > 0) {
				
				if (conditions.length == 0 || actions.length == 0) {
					
					msg = langVar('lang_admin.log_filters.invalid_filter_structure_with_alternative_msg');
					// alert(msg);
					isValidStructuredFilter = false;
				}
			}
			
			if (!isValidStructuredFilter) {
				util.updateT('log_filters:structured:error', msg);
				util.showE('log_filters:structured:error');
			}
		}
		
		if (validator.allValid() && isValidStructuredFilter) {
			
			o.expression = expression;
			o.conditions = conditions;
			o.actions = actions;
			o.alternativeActions = alternativeActions;
			o.boolOperator = boolOperator;
			o.boolOperatorSequence = boolOperatorSequence;
	
			theList.saveItem(o);
			
			return true;
		}
	
		return false;
	}
	else {
		
		// No item exists
		return true;
	}
}


function getConditionItemsDat(path, items) {

	var dat = '';
	
	for (var i = 0; i < items.length; i++) {
		
		var item = items[i];
		var itemPath = path + '.' + i;
		
		// Add position property
		dat += itemPath + '.position=' + i + '&';
		
		for (var prop in item) {
			var itemValue = encodeURIComponent(item[prop]);
			dat += itemPath + '.' + prop + '=' + itemValue + '&';
		}
	}
	
	return dat;
}

function getActionItemsDat(path, items) {
	
	var dat = '';
	var j;
	
	for (var i = 0; i < items.length; i++) {
		
		var item = items[i];
		var itemPath = path + '.' + i;
		
		var actionType = item.type;
		
		// Add position property
		dat += itemPath + '.position=' + i + '&';
		
		dat += itemPath + '.type=' + actionType + '&';
		
		// All actions which have a property except type have at a minimum the log_field property
		if (item.log_field) {
			
			dat += itemPath + '.log_field=' + encodeURIComponent(item.log_field) + '&';
			
			// Some actions have a literal property
			if (item.literal) {
				dat += itemPath + '.literal=' + encodeURIComponent(item.literal) + '&';
			}
			
			// Handle remaining action properties
			
			switch (actionType) {
				
				case 'concatenate':
				
					var concatenateItems = item.concatenate;
				
					for (j = 0; j < concatenateItems.length; j++) {
						
						dat += itemPath + '.concatenate.' + j  + '.is_log_field=' + concatenateItems[j].is_log_field + '&';
						dat += itemPath + '.concatenate.' + j  + '.literal=' + encodeURIComponent(concatenateItems[j].literal) + '&';
					}
					break;
					
				case 'copy':
				
					dat += itemPath + '.target_log_field=' + encodeURIComponent(item.target_log_field) + '&';
					break;
				
				case 'find_and_replace':
				
					dat += itemPath + '.literal_2=' + encodeURIComponent(item.literal_2) + '&';
					dat += itemPath + '.replace_type=' + item.replace_type + '&';
					break;
				
				case 'match_regexp_copy':
				
					var copyItems = item.copy;
					
					for (j = 0; j < copyItems.length; j++) {
						dat += itemPath + '.copy.' + j  + '.log_field=' + encodeURIComponent(copyItems[j].log_field) + '&';
					}
					break;
			}			
		}
	}
	
	return dat;
}


function saveLogFilters() {
	
	// check active item, if any
	
	if (validateActiveItem()) {
		
		var theList = logFilters.theList;
		var isModified = theList.getIsModified();
		
		// alert('isModified: ' + isModified);

		if (isModified) {
			
			if (pageInfo.showRebuildDbAdvice) {
					
				rebuildDbAdvice.open(processSaveLogFilters);
			}
			else {
				processSaveLogFilters();
			}
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function processSaveLogFilters(isHideRebuildDbAdviceMessage) {
	
	// This function may be invoked from rebuildDbAdvice.
	// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
	
	util.hideE('form_section');
	util.showE('saving_info');
	
	var itemsDb = logFilters.itemsDb;
	
	var setHideRebuildDbAdviceMessage = (arguments.length == 1) ? isHideRebuildDbAdviceMessage : false;
	
	var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
	dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
	dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
	
	if (itemsDb.length > 0) {
		
		for (var i = 0; i < itemsDb.length; i++) {
			
			var item = itemsDb[i];
			var itemDat = item.dat;
			
			var path = 'v.fp.filters.' + i;
			
			// Add position node, else the log filters would be saved by node order as 1,10,11, ..., 2,20,21, ...
			dat += path + '.position=' + i + '&';
			
			dat += path + '.label=' + encodeURIComponent(itemDat.label) + '&';
			dat += path + '.label_ori=' + encodeURIComponent(itemDat.labelOri) + '&';
			dat += path + '.comment=' + encodeURIComponent(itemDat.comment) + '&';
			dat += path + '.comment_ori=' + encodeURIComponent(itemDat.commentOri) + '&';
			dat += path + '.disabled=' + !item.switch1 + '&';
			
			if (itemDat.type == 'expression') {
				
				//
				// expression filter
				//
				
				dat += path + '.value=' + encodeURIComponent(itemDat.expression) + '&';
			}
			else {
				
				//
				// structured filter
				//
				
				// Note that we save the structured filter in v7 format!
				
				dat += path + '.value=&';
				
				var conditions = itemDat.conditions;
				var actions = itemDat.actions;
				var alternativeActions = itemDat.alternativeActions;
				
				var exprPath = path + '.expressions';
				
				var numberOfConditions = conditions.length;
				
				if (numberOfConditions > 0) {
					
					//
					// Type is "conditional"
					//
					
					var boolOperator = itemDat.boolOperator;
					var boolOperatorSequence = '';
					
					if (boolOperator == 'custom') {
						// Convert boolOperatorSequence letter presentation to internal numerical presentation
						boolOperatorSequence = logFiltersUtil.boolOperatorSequence.convertLetterToNumericalFormat(numberOfConditions, itemDat.boolOperatorSequence);
					}
					
					dat += exprPath + '.type=conditional&';
					dat += exprPath + '.boolean_operator=' + boolOperator + '&';
					dat += exprPath + '.boolean_operator_sequence=' + boolOperatorSequence + '&';
					
					dat += getConditionItemsDat(exprPath + '.if', conditions);
					dat += getActionItemsDat(exprPath + '.then', actions);
					
					if (alternativeActions.length > 0) {
						dat += getActionItemsDat(exprPath + '.else', alternativeActions);
					}
				}
				else {
					
					//
					// Type is "action"
					//
					
					dat += exprPath + '.type=action&';
					dat += getActionItemsDat(exprPath + '.do', actions);
				}
			}
		}
		
		dat = dat.replace(/&$/, '');
	}
	else {
		// No log filter exists
		dat += 'v.fp.filters=';
	}
	
	// alert(dat);
	
	pageInfo.saveActive = true;
	
	var url = '?dp=config_pages.log_filters.save_log_filters';
	url += '&p=' + pageInfo.profileName;
	
	util.serverPost(url, dat);
}

function processSaveLogFiltersResponse(dat) {
	
	// alert('saveLogFiltersResponse()');
	// return false;
	
	// reset isModified
	logFilters.theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	logFilters.itemsDbBackup = util.cloneObject(logFilters.itemsDb);

	// Update profilesListChecksum checksum
	profilesStorage.update(dat.profileChanges);
	
	pageInfo.saveActive = false;
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
		
	logFilters.itemsDb = util.cloneObject(logFilters.itemsDbBackup);
	logFilters.validator.reset();
	util.hideE('log_filters:structured:error'); // resets any structured filter error
	logFilters.theList.init(logFilters.itemsDb);
	initMainDisplay();
	updateToolbarButtons();
}

function getIsModifiedPage() {
	
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	
	if (!validateActiveItem() || logFilters.theList.getIsModified()) {
		return true;
	}
	
	return false;
}

function updateCommentDisplay(theComment) {
	
	// theComment may contain HTML tags, i.e. <br />,
	// so we use innerHTML for comment display!
	
	var isComment = (theComment != '');
	
	var buttonLabel = isComment ? langVar('lang_admin.log_filters.edit_comment') : langVar('lang_admin.log_filters.add_comment');
	util.updateT('log_filters:comment:add_edit_btn_1', buttonLabel);
	util.updateT('log_filters:comment:add_edit_btn_2', buttonLabel);
	
	// util.updateT('log_filters:comment:display', theComment);
	var commentElement = util.getE('log_filters:comment:display');
	commentElement.innerHTML = theComment;
	
	util.showE('log_filters:comment:display', isComment);
	
	// util.showE('log_filters:comment:add_btn', !isComment);
	// util.showE('log_filters:comment:edit_btn', isComment);
	
	logFilters.activeComment = theComment;
}

function editComment() {
	
	logFilterComment.open(logFilters.activeComment);
}



