//
// snaponParametersWizard namespace
//

var snaponParametersWizard = function() {


	var YE = YAHOO.util.Event,
	    panel = null,
        parametersForm = [],
        indexOfLastPage = -1, // The index of the snapon label page
	    currentPageIndex = -1,
	    activeNextButtonLabel = '';

	function init() {
		
		var panelObj = {
			panelId: 'snapon_parameters:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.snapons.snapon_parameters'),
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			// isSticky: true,
			closeEvent: snaponParametersWizard.cancel
		};
		
		panel = new util.Panel3(panelObj);
		
		YE.addListener('snapon_parameters:back_btn', 'click', goBack);
		YE.addListener('snapon_parameters:next_btn', 'click', goNext);
		YE.addListener('snapon_parameters:cancel_btn', 'click', cancel);
	}
	
	function openPanel(dat, defaultSnaponLabel, attachedSnaponLabelsLookupArg) {
		
		// util.showObject(dat);
		
		if (!panel) {init();}
		
		parametersForm = dat.parametersForm;
		
		// Add last label wizard page to parameters
		indexOfLastPage = parametersForm.length;
		var lastPage = {
			elementIdPrefix: '',
			// label:langVar('lang_admin.snapons.snapon_name'),
			description:langVar('lang_admin.snapons.please_define_a_snapon_name'),
			parameters: [{
				name: 'snapon_name',
				type: 'string',
				parameterValue: defaultSnaponLabel,
				validationType: 'snapon_label',
				formElementLabel: langVar('lang_admin.snapons.snapon_name'),
				formElementType: 'text',
				description: '',
				formElementWidth: '380'
			}]
		};
		
		parametersForm[indexOfLastPage] = lastPage;
		
		// Init snaponParameters
		
		var obj = {
            containerElementId: 'snapon_parameters:form',
            nextButtonElementId: 'snapon_parameters:next_btn',
			parametersForm: parametersForm,
			logFields: dat.logFields,
			databaseFields: dat.databaseFields,
			reportFields: dat.reportFields,
			reports: dat.reports,
			reportGroups: dat.reportGroups,
			attachedSnaponLabelsLookup: attachedSnaponLabelsLookupArg
		};

        snaponParameters.init(obj);
		
		// Reset currentPageIndex
		currentPageIndex = -1;
		
		// Start with the first wizard page
		setPage(0);
	
		panel.open();
	}
	
	function cancel() {
		
		panel.close();
		snapons.cancelViaParamtersPanel();
	}

	//
	// Page control
	//
	
	function goBack() {
		
		if (currentPageIndex > 0) {
			setPage(currentPageIndex - 1);
		}
	}
	
	function goNext() {
		
		// Go to next page
		
		// Validate current wizard page
		if (snaponParameters.getIsValidWizardPage(currentPageIndex)) {
			
			if (currentPageIndex < indexOfLastPage) {
				setPage(currentPageIndex + 1);
			}
			else {
				
				// The user clicked Finish
				
				// Proceed with snapon.startSnaponOperation()
				panel.close();
				
				// Get snaponLabel and remove last wizardPage (the snaponLabel) from
				// parametersForm because the snaponLabel is send as separate value.
				var a = parametersForm.splice(indexOfLastPage, 1);
				var deletedPageItem = a[0];
				var snaponLabel = deletedPageItem.parameters[0].finalValue;
				
				// Process node names for all label parameters, if any.
				snaponParameters.handleLabelParameterNodeNames();
				
				// Start the snapon operation
				snapons.startSnaponOperation(snaponLabel, parametersForm);
			}
		}		
	}
	
	function setPage(pageIndex) {
		
		// Hide the current page
		if (currentPageIndex != -1) {
			util.hideE('snapon_parameters_page:' + currentPageIndex);
		}
		
		// Update wizard page title and description
		// var pageItem = parametersForm[pageIndex];
		// util.updateT('snapon_parameters:title', pageItem.label);
		// util.updateT('snapon_parameters:description', pageItem.description);
		
		// Show new page
		util.showE('snapon_parameters_page:' + pageIndex);
		
		currentPageIndex = pageIndex;
		updateButtonState();
	}
	
	function updateButtonState() {
		
		var isBack = (currentPageIndex > 0);
		var nextButtonLabel = (currentPageIndex < indexOfLastPage) ? langVar('lang_stats.btn.next') : langVar('lang_stats.btn.finish');
		
		util.enableE('snapon_parameters:back_btn', isBack);
		
		if (activeNextButtonLabel != nextButtonLabel) {
			// Update next button label
			util.updateT('snapon_parameters:next_btn', nextButtonLabel);
			activeNextButtonLabel = nextButtonLabel;
		}
	}

	//
	// Return global properties and methods
	//
	
	return {
		
		openPanel: openPanel,
		cancel: cancel
	}
}();
