//
// calendarControl.js
//

var calendarControl = {
	
	dfMonths: ['jan', 'feb', 'mar', 'apr', 'may', 'jun', 'jul', 'aug', 'sep', 'oct', 'nov', 'dec'],
	
	selectedElementId: '',
	selectedElementClassName: '',
	
	init: function() {
		
		// attach events
		var isIE6 = util.userAgent.isIE6;
		
		// alert('isIE6: ' + isIE6);
		// isIE6 = true;
				
		var calendar = util.getE('calendar');
		var calendarLinks = calendar.getElementsByTagName('a');
		
		for (var i = 0; i < calendarLinks.length; i++) {
			
			var anchor = calendarLinks[i];
			YAHOO.util.Event.addListener(anchor, 'click', calendarControl.setDate);
			
			// Fix Internet Explorer text-hover problem by adding a height to the anchor element
			if (isIE6) {
				anchor.style.height = '0.1em';
			}
		}
		
		// Fix Internet Explorer text-hover problem by adding a height to all span elements
		// We do this to keep the height constant bewteen anchor and span elements. Span elements
		// are used for days or weeks which have no log data.
		if (isIE6) {
			var calendarSpans = document.getElementsByTagName('span');
			for (var i = 0; i < calendarSpans.length; i++) {
				var span = calendarSpans[i];
				span.style.height = '0.1em';
			}
		}
		
		util.showE('calendar');
	},
	
	setDate: function() {
	
		// Create a dateFilter and dateFilter display value from the given elementId where dateId is in the format:
		// y:2006
		// m:2006:1
		// d:2006:1:20
		// w0:2006:1:20:2006:1:26 (week)
		// w1:2006:1:20:2006:1:26 (week)
		// Note that the first letter in week ID's is followed by a number. The number avoids duplicate id's
		// because the last week id in i.e. Jan could be the same id as the first week in Feb!

		// alert('setDate(): ' + this.id);
		
		var anchor = this;
		var elementId = anchor.id;
		var isEntireDateRange = (elementId == 'calendar:set_entire_date_range') ? true : false;
		
		if (elementId == calendarControl.selectedElementId) {
			calendarControl.cancelZoom();
			return false;
		}
		
		// Recover state of any selected element
		if (calendarControl.selectedElementId != '') {
			calendarControl.deselectActiveElement();
		}
		
		// Get existing className
		var className = (anchor.className != null) ? anchor.className : '';
		//alert('elementId: ' + elementId + '\nanchor className: ' + className);
		
		// Selecet calendar element
		anchor.className = (className == '') ? 'active' : className + ' active';
		
		calendarControl.selectedElementId = elementId;
		calendarControl.selectedElementClassName = className;
		
		
		//
		// Set df & dfDisplay
		// 
		
		var df; // The date filter in URL
		var dfDisplay = '' // The date filter displayed in zoomInfo
		var year;
		var monthInt;
		var month;
		var monthDisplay;
		var day;
		var dayDisplay;
		var year2;
		var month2Int;
		var month2;
		var month2Display;
		var day2;
		var day2Display;
		
		if (!isEntireDateRange) {
		
			var dat = elementId.split(':');
			var id = dat[0];
			year = dat[1];
			
			if (id == 'y') {
				// date is year
				df = year;
				dfDisplay = year;
			}
			else {
				
				monthInt = parseInt(dat[2], 10);
				month = calendarControl.dfMonths[monthInt];
				monthDisplay = lang.monthsShort[monthInt];
				
				if (id == 'm') {
					// date is month
					df = month + year;
					dfDisplay = monthDisplay + '/' + year;
				}
				else {
					// date is day or week
					day = parseInt(dat[3], 10);
					dayDisplay = (day > 9) ? day : '0' + day;
					
					df = day + month + year;
					dfDisplay = dayDisplay + '/' + monthDisplay + '/' + year;
					
					if (id != 'd') {
						// date is week
						
						year2 = dat[4];
						month2Int = parseInt(dat[5], 10);
						month2 = calendarControl.dfMonths[month2Int];
						month2Display = lang.monthsShort[month2Int];
						day2 = parseInt(dat[6], 10);
						day2Display = (day2 > 9) ? day2 : '0' + day2;
						
						df += '-' + day2 + month2 + year2;
						dfDisplay += ' - ' + day2Display + '/' + month2Display + '/' + year2;
					}
				}
			}
		}
		else {
			
			// ID is 'calendar:set_entire_date_range'
			
			var earliestDate = reportInfo.earliestDate;
			var earliestDateJs = util.salangDateToSimpleDateObject(earliestDate);
			
			df = '';
			dfDisplay = calendarControl.simpleDateObjectToDisplay(earliestDateJs);
			
			if (earliestDate != reportInfo.latestDate) {
				
				var latestDateJs = util.salangDateToSimpleDateObject(reportInfo.latestDate);
				dfDisplay += ' - ' + calendarControl.simpleDateObjectToDisplay(latestDateJs);
			}
		}
		
		
		// alert('isEntireDateRange: ' + isEntireDateRange + '\ndfDisplay: ' + dfDisplay);
	
		zoomInfo.update(true, false, false);
		reportsMenu.updateMenuItemLinks(
			reportsMenuDb,
			df,
			reportInfo.commandLineFilter,
			reportInfo.commandLineFilterComment,
			reportInfo.filterId,
			''
		);
		
		newReport.dateFilter = df;
	},
	
	cancelZoom: function() {
		// alert('calendarControl.cancelZoom()');
		calendarControl.deselectActiveElement();
		calendarControl.selectedElementId = '';
		calendarControl.selectedElementClassName = '';
		zoomInfo.close();
		var dateFilterOri = reportInfo.dateFilter;
		reportsMenu.updateMenuItemLinks(
			reportsMenuDb,
			dateFilterOri,
			reportInfo.commandLineFilter,
			reportInfo.commandLineFilterComment,
			reportInfo.filterId,
			''
		);
		newReport.dateFilter = dateFilterOri;
	},
	
	deselectActiveElement: function() {
		
		var selectedElement = util.getE(calendarControl.selectedElementId);
		
		// alert('calendarControl.selectedElementId: ' + calendarControl.selectedElementId + '\nselectedElement: ' + selectedElement + '\ncalendarControl.selectedElementClassName: ' + calendarControl.selectedElementClassName);
		
		
		selectedElement.className = calendarControl.selectedElementClassName;
	},

	simpleDateObjectToDisplay: function(simpleDateObj) {
	
		var day = (simpleDateObj.day < 10) ? '0' + simpleDateObj.day : simpleDateObj.day;
		var month = lang.monthsShort[simpleDateObj.month];
		var year = simpleDateObj.year;
		var dateDisplay = day + '/' + month + '/' + year;	
		return dateDisplay;
	}
}
