//
//
// creGraphOptions.js (Customize Report Element GraphOptions Class, used in Reports and Reports Editor)
//
//

CreGraphOptions = function(queryFieldsDb, defaultGraphsDb) {
	
	// this.defaultGraphs = defaultGraphs; // A reference to defaultGraphs
	
	var YE = YAHOO.util.Event;
	
	this.queryFieldsDb = queryFieldsDb; // A reference to all report fields from where we get the labels and category
	
	this.defaultGraphsDb = defaultGraphsDb;
	
	this.reportElementDb = {};  // A reference to the active report element data.
								// Note, if no table is shown we may set sort_by and sort_direction
								// of the report element via Graph Options.
								
	this.activeGraphsDb = {}; // The active graphsDb object which is created upon init(). It is
							// equal the defaultGraphsDb but overriden with active reportElementDb
							// graphs data.

	this.showTable = false;  // Set upon init(), We need to know if the report element shows a table as well
							// because if no table is shown we need a full Sort By list in Graph Options

	this.isChronoGraphSupport = false; // Set upon init(), it is true if the report element supports a chrono graph
	
	// this.activeMetaGraphType = ''; NOT REQUIRED because the active metaGraphType is defined in activeGraphsDb!
	
	//
	// Init the GUI
	//
	
	creUtil.buildSortDirectionList('cre_obj:graph_options:sort_direction');

	YE.addListener('cre_obj:graph_options:type', 'change', this.graphTypeActor, this);
	YE.addListener('cre_obj:graph_options:sort_by', 'change', this.sortByActor, this);
	YE.addListener('cre_obj:graph_options:sort_direction', 'change', this.sortDirectionActor, this);
	// YE.addListener('cre_obj:graph_options:show_legend', 'click', this.showLegendActor, this);
};


CreGraphOptions.prototype = {
	
	init: function(reportElementDb) {
	
		// alert('creUtil.GraphOptions.prototype.init');
		
		this.reportElementDb = reportElementDb;
		var activeGraphsDb = this.createActiveGraphsDbObject(reportElementDb);
		this.activeGraphsDb = activeGraphsDb;
		this.showTable = reportElementDb.show_table;
		
		this.updateGraphTypeList(activeGraphsDb.isChronoGraphSupport);
		
		// util.showObject(activeGraphsDb);
		
		var metaGraphType = activeGraphsDb.metaGraphType;
		
		util.setF('cre_obj:graph_options:type', metaGraphType);

		this.updateForm(metaGraphType);
	},
	
	updateForm: function(metaGraphType) {
		
		// alert('updateForm() - metaGraphType: ' + metaGraphType);
		
		// var activeGraphsDb = this.activeGraphsDb;
		
		// util.showObject(activeGraphsDb);
		
		// Get a reference to the active graph object from which we read the data
		var graphObj = this.getGraphObjectReference(metaGraphType);
		
		// util.showObject(graphObj);
		
		var isChronoGraph = (metaGraphType.indexOf('chrono_') != -1);
		var isPieChart = (metaGraphType == 'pie');
		var isSortAllDescending = graphObj.sort_all_descending;
		
		this.updateSortByForm(isChronoGraph, isSortAllDescending);
		
		util.setF('cre_obj:graph_options:y_axis_height', graphObj.y_axis_height);
		util.setF('cre_obj:graph_options:x_axis_length', graphObj.x_axis_length);

		util.setF('cre_obj:graph_options:display_graphs_side_by_side', this.reportElementDb.display_graphs_side_by_side);

		util.showE('cre_obj:graphs:variables_and_legend_box', !isChronoGraph);
		
		var showLegend = !isChronoGraph ? graphObj.show_legend : false;
		
		if (!isChronoGraph) {
			
			util.setF('cre_obj:graph_options:max_variables', graphObj.max_variables);
			util.setF('cre_obj:graph_options:show_remainder', graphObj.show_remainder);
			// util.disableE('cre_obj:graph_options:show_remainder', isPieChart);
			util.showE('cre_obj:graph_options:show_remainder:section', !isPieChart);
			
			util.setF('cre_obj:graph_options:show_legend', showLegend);

			util.setF('cre_obj:graph_options:show_values_in_legend', graphObj.show_values_in_legend);
			util.setF('cre_obj:graph_options:show_percent_in_legend', graphObj.show_percent_in_legend);

			util.setF('cre_obj:graph_options:max_legend_rows', graphObj.max_legend_rows);

			if (isPieChart) {
				util.setF('cre_obj:graph_options:show_3d', graphObj.show_3d);
			}
		}

		if (!isPieChart) {

			util.setF('cre_obj:graph_options:show_percent_on_y_axis', graphObj.show_percent_on_y_axis);
		}

		util.showE('cre_obj:graph_options:show_3d_section', isPieChart);
		util.showE('cre_obj:graph_options:show_percent_on_y_axis:section', !isPieChart);
		// util.disableE('cre_obj:graph_options:show_legend', isChronoGraph);
	},
	
	
	updateSortByForm: function(isChronoGraph, isSortAllDescending) {
					
		if (isChronoGraph || this.showTable) {
			
			this.updateSortByList(isChronoGraph, isSortAllDescending);
		}
		else {
			
			// There is no table and no chrono graph, so we allow to select a report field
			// and the sort direction (sortAllDescending is still possible)
			this.updateSortByListWithReportFields(isSortAllDescending);
		}
	},
	
	graphTypeActor: function(evt, self) {
		
		// alert('graphTypeActor()');
		var newMetaGraphType = util.getF('cre_obj:graph_options:type');
		
		// Before we update the form save current data to activeGraphs
		self.saveChangesToGraphObject(self.activeGraphsDb.metaGraphType);
		
		// Update the form
		self.updateForm(newMetaGraphType);
		self.activeGraphsDb.metaGraphType = newMetaGraphType;
	},
	
	sortByActor: function(evt, self) {
		
		var sortBy = util.getF('cre_obj:graph_options:sort_by');
		
		// var graphsDb = self.graphsDb;
		var metaGraphType = self.activeGraphsDb.metaGraphType;
		var isChronoGraph = (metaGraphType.indexOf('chrono_') != -1);
		var graphObj = self.getGraphObjectReference(metaGraphType);
		
		var isSortAllDescending = (sortBy == '__ALL__DESC__TRUE__') ? true : false;
		
		if (!isChronoGraph && !self.showTable && !isSortAllDescending) {
			
			//
			// Handle sort by with report fields
			//
			var reportElementDb = self.reportElementDb;
			
			reportElementDb.sort_by = sortBy;
			
			// Set sort direction in case that it has not yet been set upon init
			util.setF('cre_obj:graph_options:sort_direction', reportElementDb.sort_direction);
		
			util.showEV('cre_obj:graph_options:sort_direction', !isSortAllDescending);
			util.enableE('cre_obj:graph_options:sort_direction', !isSortAllDescending);
		}
		
		graphObj.sort_all_descending = isSortAllDescending;
	},
	

	sortDirectionActor: function(evt, self) {
		
		// We update sort_direction of reportElementDb, this case is only possible
		// if no table is displayed and a report field is selected in sort_by list.
		
		self.reportElementDb.sort_direction = util.getF('cre_obj:graph_options:sort_direction');
	},

	
//	showLegendActor: function(evt, self) {
//
//		var graphObj = self.getGraphObjectReference(self.activeGraphsDb.metaGraphType);
//		// util.showObject(graphObj);
//		graphObj.show_legend = this.checked;
//	},
	
	//
	//
	// Check sort by integrity
	//
	//
	
	//checkSortByIntegrity: function() {
		// This function is called from creGraphs.js and checks the sort_by integrity when a graph field in "graphs" becomes deselected.
		// We only need to check the sort_by integrity if no table is active (this.showTable = false) and if we have a non-chrono graph,
		// in this case we need to update the sort_by list according the active graph fields.
		// alert('creGraphOptions.js - checkSortByIntegrity()');
	//},

	
	// 
	//
	// Utilities
	//
	//
	
	
	getGraphObjectReference: function(metaGraphType) {
		
		var activeGraphsDb = this.activeGraphsDb;
		var graphObj;
		
		if (metaGraphType == 'chrono_bar' || metaGraphType == 'chrono_line') {
			graphObj = activeGraphsDb.chrono_bar_line_graph;
		}
		else if (metaGraphType != 'pie') {
			graphObj = activeGraphsDb.bar_line_graph;
		}
		else {
			graphObj = activeGraphsDb.pie_chart;
		}
		
		return graphObj;
	},

	
	updateGraphTypeList: function(isChronoGraphSupport) {
	
		var list = [];
		
		if (isChronoGraphSupport) {
			
			list[0] = {name:'chrono_bar', label:langVar('lang_stats.customize_report_element.chrono_bar_graph')};
			list[1] = {name:'chrono_line', label:langVar('lang_stats.customize_report_element.chrono_line_graph')};
		}
		
		list[list.length] = {name:'bar', label:langVar('lang_stats.customize_report_element.bar_graph')};
		list[list.length] = {name:'line', label:langVar('lang_stats.customize_report_element.line_graph')};

		// KHP 06/Feb/2013 - Don't allow pie for chronological fields
		// KHP 28/Feb/2013 - Looks like that there are profiles out which already use a pie chart for chrono fields!
		// 					 So we need to support pie charts for chronological fields, this makes the most sense anyway.

		list[list.length] = {name:'pie', label:langVar('lang_stats.customize_report_element.pie_chart')};

		util.populateSelect('cre_obj:graph_options:type', list, 'name', 'label');
	},

	updateSortByList: function(isChronoGraph, isSortAllDescending) {
		
		var list = [];
		var activeSortItem = isSortAllDescending ? '__ALL__DESC__TRUE__' : '__ALL__DESC__FALSE__';
		
		if (isChronoGraph) {
		
			list[0] = {name:'__ALL__DESC__FALSE__', label:langVar('lang_stats.customize_report_element.chronological')};
			list[1] = {name:'__ALL__DESC__TRUE__', label:langVar('lang_stats.customize_report_element.reverse_chronological')};
		}
		else {
			list[0] = {name:'__ALL__DESC__TRUE__', label:langVar('lang_stats.customize_report_element.all_descending')};
			list[1] = {name:'__ALL__DESC__FALSE__', label:langVar('lang_stats.customize_report_element.as_defined_for_table')};
		}
		
		util.populateSelect('cre_obj:graph_options:sort_by', list, 'name', 'label');
		util.setF('cre_obj:graph_options:sort_by', activeSortItem);
		
		// Hide sort_direction
		util.hideEV('cre_obj:graph_options:sort_direction');
		util.disableE('cre_obj:graph_options:sort_direction');
	},

	updateSortByListWithReportFields: function(isSortAllDescending) {
	
		// No Table tab is shown and no chrono graph is selected,
		// so the sort_by list shows 'sort_all_descending = true'
		//  which applies to the graphs object and in addition it shows
		// all active graphs report fields of reportElementDb which
		// applies to sort_by and sort_direction.
		
		var list = [];
		list[0] = {name:'__ALL__DESC__TRUE__', label:langVar('lang_stats.customize_report_element.all_descending')};
		
		// Add all active fields
		var queryFieldsDb = this.queryFieldsDb;
		var reportElementDb = this.reportElementDb;
		var columns = reportElementDb.columns;
		
		// Note, for now we add all graph fields, we don't care if a field is checked or not!
		for (var i = 0; i < columns.length; i++) {
			
			var column = columns[i];
			
			// Add all text and aggreagting fields because sort_by could just be any field@
			
			var reportFieldName = column.report_field;
			var label = queryFieldsDb[util.h(reportFieldName)].label;
			
			list[list.length] = {name:reportFieldName, label:label};
		}
	
		//
		// Set active sort item and sort direction list
		//
	
		util.populateSelect('cre_obj:graph_options:sort_by', list, 'name', 'label');
		
		var activeSortItem;
		var showSortDirection;
		
		if (isSortAllDescending) {
			activeSortItem = '__ALL__DESC__TRUE__';
			showSortDirection = false;
		}
		else {
			
			activeSortItem = reportElementDb.sort_by;
			sort_direction = reportElementDb.sort_direction;
			util.setF('cre_obj:graph_options:sort_direction', sort_direction);
			showSortDirection = true;
		}
		
		util.setF('cre_obj:graph_options:sort_by', activeSortItem);
		util.showEV('cre_obj:graph_options:sort_direction', showSortDirection);
		util.enableE('cre_obj:graph_options:sort_direction', showSortDirection);
	},
	
	saveChangesToGraphObject: function(metaGraphType) {
		
		// This saves the current graphs state to activeGraphsDb but not to the reportElementDb object!
		
		// We save data to the graph object to keep state when switching between types
		// and to get the final graph object upon exit.
		// Note, we do form validation but auto-fix invalid form values by keeping default values
		
		var isChronoGraph = (metaGraphType.indexOf('chrono_') != -1);
		var graphObj = this.getGraphObjectReference(metaGraphType);
		
		var y = util.getF('cre_obj:graph_options:y_axis_height');
		var x = util.getF('cre_obj:graph_options:x_axis_length');
		
		if (util.isInteger(y, 1)) {graphObj.y_axis_height = y;}
		if (util.isInteger(x, 1)) {graphObj.x_axis_length = x;}
		
		if (!isChronoGraph) {

			graphObj.show_legend = util.getF('cre_obj:graph_options:show_legend');
			graphObj.show_values_in_legend = util.getF('cre_obj:graph_options:show_values_in_legend');
			graphObj.show_percent_in_legend = util.getF('cre_obj:graph_options:show_percent_in_legend');
			
			var maxVariables = util.getF('cre_obj:graph_options:max_variables');
			if (util.isInteger(maxVariables, 1)) {graphObj.max_variables = maxVariables;}
			graphObj.show_remainder = util.getF('cre_obj:graph_options:show_remainder');
					
			maxLegendRows = util.getF('cre_obj:graph_options:max_legend_rows');
			if (util.isInteger(maxLegendRows, 1)) {graphObj.max_legend_rows = maxLegendRows;}
			
			if (metaGraphType == 'pie') {
				graphObj.show_3d = util.getF('cre_obj:graph_options:show_3d');
			}
		}

		graphObj.show_percent_on_y_axis = util.getF('cre_obj:graph_options:show_percent_on_y_axis');
	},
	
	saveChanges: function() {
		
		// This saves the current graphs state to the reportElementDb object!
		var metaGraphType = this.activeGraphsDb.metaGraphType;
		
		// Save graph object
		this.saveChangesToGraphObject(metaGraphType);
		
		// Get graphType as saved in reportElementDb
		var isChrono = (metaGraphType.indexOf('chrono_') != -1);
		var graphType = '';
		
		if (isChrono) {
			graphType = (metaGraphType == 'chrono_bar') ? 'bar' : 'line';
		}
		else {
			graphType = metaGraphType;
		}

		// Get the graph object
		var graphObject = this.getGraphObjectReference(metaGraphType);
		
		// Clean up reportElementDb from existing graphs object.
		var reportElementDb = this.reportElementDb;
		var prop;
		
		// Copy graphsObj to reportElementDb.graphs
		reportElementDb.graphs = util.cloneObject(graphObject);
		
		// Set graphType which is not part of the graphsObj
		reportElementDb.graphs.graph_type = graphType;

		// Handle sort_by in case of show_graphs=true and show_table=false
		// In this case we need to re-check sort_by and sort_direction.
        if (!isChrono && !graphObject.sort_all_descending && !this.showTable) {

            // Get sort_by and sort_direction
            reportElementDb.sort_by = util.getF('cre_obj:graph_options:sort_by');
            reportElementDb.sort_direction = util.getF('cre_obj:graph_options:sort_direction');
        }

		reportElementDb.display_graphs_side_by_side = util.getF('cre_obj:graph_options:display_graphs_side_by_side');

        // util.showObject(graphObject, "graphObject");
        // util.showObject(reportElementDb, "reportElementDb");
	},
	
	createActiveGraphsDbObject: function(reportElementDb) {
		
		// Creates an active graphsDb object with any active report element graphs data.
		// graphsDb keeps the graph data state while customizing report element graphs data
		
		// util.showObject(reportElementDb);
		
		var activeGraphsDb = util.cloneObject(this.defaultGraphsDb);
		var isChronoGraphSupport = creUtil.getIsChronoGraphSupport(this.queryFieldsDb, reportElementDb.columns);
		
		var graphType = '';
		var isChronoGraph = false;
		
		if (reportElementDb['graphs'] && reportElementDb.graphs['graph_type']) {
			
			var reportElementGraphs = reportElementDb.graphs;
			
			// util.showObject(reportElementGraphs);
			
			graphType = reportElementGraphs.graph_type;
			isChronoGraph = (isChronoGraphSupport && (graphType != 'pie')  && (reportElementGraphs['show_chrono_graph'] != null) && reportElementGraphs.show_chrono_graph);
			
			var overrideTarget;
			
			if (isChronoGraph) {
				overrideTarget = activeGraphsDb.chrono_bar_line_graph;
			}
			else if (graphType != 'pie') {
				overrideTarget = activeGraphsDb.bar_line_graph;
			}
			else {
				overrideTarget = activeGraphsDb.pie_chart;
			}
			
			// util.showObject(overrideTarget);
			
			for (prop in reportElementGraphs) {
				
				// alert('prop: ' + prop);
				
				if (overrideTarget[prop] != null) {
					// Override default
					// alert('Override prop "' + prop + '" with value: ' + reportElementGraphs[prop]);
					overrideTarget[prop] = reportElementGraphs[prop];
				}
			}
		}
		else {
			// There is no report element graphs, so we use default settings as defined
			// in activeGraphsDb
			
			graphType = isChronoGraphSupport ? activeGraphsDb.chrono_graph_type : activeGraphsDb.graph_type;
			isChronoGraph = (isChronoGraphSupport && graphType != 'pie');
		}
		
		// Set meta graph type
		var metaGraphType = !isChronoGraph ? graphType : 'chrono_' + graphType;
		
		// alert('graphType: ' + graphType + '\nmetaGraphType: ' + metaGraphType);
		
		activeGraphsDb.isChronoGraphSupport = isChronoGraphSupport;
		activeGraphsDb.metaGraphType = metaGraphType;
		
		// util.showObject(activeGraphsDb);
		
		return activeGraphsDb;
	}
};






