//
//
// creTableOptions.js (Customize Report Element TableOptions Class, used in Reports and Reports Editor)
//
//


CreTableOptions = function(queryFieldsDb, isCustomizeInReports) {
	
	this.isCustomizeInReports = isCustomizeInReports; // Used to handle differences between CRE in Reports GUI and CRE in Config Reports Editor GUI
	this.queryFieldsDb = queryFieldsDb; // A reference to all report fields from where we get the Field labels
	this.reportElementDb = {}; // A reference to the active report element data.
							   // reportElementDb keeps the state of any action taken in the FieldList
							   // The variable is set upon this.init()
	
	this.isLogDetail = false;
	this.isSessionPaths = false;
	this.isSessionPagePaths = false;
};

CreTableOptions.prototype = {
	
	init: function(reportElementDb, totalRows) {

		// util.showObject(reportElementDb);
	
		var reportElementType = reportElementDb.type;
		var isOverview = (reportElementType == 'overview');
		var isTable = (reportElementType == 'table');
		var isLogDetail = (reportElementType == 'log_detail');
		var isSessionPaths = (reportElementType == 'session_paths');
		var isSessionPagePaths = (reportElementType == 'session_page_paths');
	
		this.reportElementDb = reportElementDb;
		this.isOverview = isOverview;
		this.isTable = isTable;
		this.isLogDetail = isLogDetail;
		this.isSessionPaths = isSessionPaths;
		this.isSessionPagePaths = isSessionPagePaths;

		if (!isOverview) {

			util.setF('cre_obj:table_options:number_of_rows', reportElementDb.number_of_rows);

			if (this.isCustomizeInReports && !isSessionPaths && !isSessionPagePaths) {
				util.setF('cre_obj:table_options:starting_row', reportElementDb.starting_row);
				util.setF('cre_obj:table_options:ending_row', reportElementDb.ending_row);

				// Set totalRows
				util.updateT('cre_obj:table_options:total_rows', customizeRE.totalRows);
			}

			if (isTable)  {

				util.setF('cre_obj:table_options:show_remainder_row', reportElementDb.show_remainder_row);
				util.setF('cre_obj:table_options:show_averages_row', reportElementDb.show_averages_row);
				util.setF('cre_obj:table_options:show_min_row', reportElementDb.show_min_row);
				util.setF('cre_obj:table_options:show_max_row', reportElementDb.show_max_row);
				util.setF('cre_obj:table_options:show_totals_row', reportElementDb.show_totals_row);

				util.setF('cre_obj:table_options:maximum_table_bar_graph_length', reportElementDb.maximum_table_bar_graph_length);
//				util.setF('cre_obj:table_options:display_graphs_table_side_by_side', reportElementDb.display_graphs_table_side_by_side);
			}
			else if (isSessionPaths) {

				util.setF('cre_obj:table_options:expand_paths_greater_than', reportElementDb.expand_paths_greater_than);
				util.setF('cre_obj:table_options:number_of_rows_expanded', reportElementDb.number_of_rows_expanded);
			}
		}
		else {
			// Overview report element
			var compactView = reportElementDb.compact_view;
			util.setF('cre_obj:table_options:classic_table', !compactView);
			util.setF('cre_obj:table_options:compact_view', compactView);
		}

		util.showE('cre_obj:table_options:rows', !isOverview);
		util.showE('cre_obj:table_options:misc_box', isTable);
		util.showE('cre_obj:table_options:session_paths', isSessionPaths);
		util.showE('cre_obj:table_options:overview', isOverview);

		util.showE('cre_obj:table_options:maximum_table_bar_graph_length:section', isTable);
//		util.showE('cre_obj:table_options:display_graphs_table_side_by_side:section', isTable);
	},

	saveChanges: function() {
		
		// Saves the active form data to reportElementDb
		
		// Note, in case of invalid values we keep existing values (auto fix)
		
		var reportElementDb = this.reportElementDb;

		if (!this.isOverview) {

			if (this.isTable) {

				reportElementDb.show_remainder_row = util.getF('cre_obj:table_options:show_remainder_row');
				reportElementDb.show_averages_row = util.getF('cre_obj:table_options:show_averages_row');
				reportElementDb.show_min_row = util.getF('cre_obj:table_options:show_min_row');
				reportElementDb.show_max_row = util.getF('cre_obj:table_options:show_max_row');
				reportElementDb.show_totals_row = util.getF('cre_obj:table_options:show_totals_row');
//				reportElementDb.display_graphs_table_side_by_side = util.getF('cre_obj:table_options:display_graphs_table_side_by_side');

				var maximumTableBarGraphLength = util.getF('cre_obj:table_options:maximum_table_bar_graph_length');

				if (maximumTableBarGraphLength != '' && util.isInteger(maximumTableBarGraphLength, 1)) {

					reportElementDb.maximum_table_bar_graph_length = maximumTableBarGraphLength;
				}
			}

			if (this.isCustomizeInReports && (this.isTable || !this.isLogDetail)) {

				var startingRow = util.getF('cre_obj:table_options:starting_row');
				var endingRow = util.getF('cre_obj:table_options:ending_row');

				if (util.isInteger(startingRow, 1) && util.isInteger(endingRow, 1)) {

					startingRow = parseInt(startingRow, 10);
					endingRow = parseInt(endingRow, 10);

					if (endingRow >= startingRow) {

						// alert('ROW NUMBERS IN creTableOptions 1' + '\nstartingRow: ' + startingRow + '\nendingRow: ' + endingRow);
						reportElementDb.starting_row = startingRow;
						reportElementDb.ending_row = endingRow;
					}
				}
			}

			var numberOfRows = util.getF('cre_obj:table_options:number_of_rows');

			if (util.isInteger(numberOfRows, 1)) {
				reportElementDb.number_of_rows = numberOfRows;
			}

			if (this.isSessionPaths) {

				var expandPathsGreaterThan = util.getF('cre_obj:table_options:expand_paths_greater_than');
				var numberOfRowsExpanded = util.getF('cre_obj:table_options:number_of_rows_expanded');

				if (util.isInteger(expandPathsGreaterThan, 0)) {
					reportElementDb.expand_paths_greater_than = expandPathsGreaterThan;
				}

				if (util.isInteger(numberOfRowsExpanded, 1)) {
					reportElementDb.number_of_rows_expanded = numberOfRowsExpanded;
				}
			}
		}
		else {

			reportElementDb.compact_view = util.getF('cre_obj:table_options:compact_view');
		}
	}
};




