//
// databaseInfoUtil - used in Config Database Info, Update Database and Build Database
//

var databaseInfoUtil = function() {
	
	/*
	var GD = {
		isRealTimeProcessing: false,
		isActiveSnaponOperation: false,
		databaseIsBuilding: false,
		initialBuildDone: false,
		databaseIsReadyForReporting: false,
		lastProfileInfoTime: -1 // the time profile info data have been updated
	};
	*/

	function updateDatabaseInfo(dat) {
		
		// util.showObject(dat);
	
		var isInternalSQL = (dat.dbServerType === 'internal_sql');
		
		// util.updateT('database_info:profile_label', dat.profileLabel);
		// util.updateT('database_info:log_format', dat.logFormatLabel);
		//util.updateT('database_info:real_time_processing', dat.realTimeProcessingLabel);
		
		util.updateT('database_info:db_server_type', dat.dbServerTypeLabel);
		util.updateT('database_info:db_directory', dat.dbDirectory);
		util.updateT('database_info:db_name', dat.dbName);
		
		util.updateT('database_info:db_last_modified', dat.dbLastModified);
		util.updateT('database_info:db_last_operation', dat.dbLastOperation);
		
		util.updateT('database_info:db_earliest_log_entry', dat.dbErliestDateTime);
		util.updateT('database_info:db_latest_log_entry', dat.dbLatestDateTime);        
		
		util.showE('database_info:db_directory:tr', isInternalSQL);
		util.showE('database_info:db_name:tr', !isInternalSQL);
		
		// updateLogFormatInfo(dat);
		setDatabaseInfoDisplay(dat);
	}
	
	function setDatabaseInfoDisplay(dat) {
		
		// Called when receiving fresh database info data but also used to reset the display
		// after Update Database or Build Database
		
		//
		// Handle basic database info display
		//
		
		//var isRealTimeProcessing = dat.isRealTimeProcessing;

        // KHP 2015/01/22 - real time processing is no longer supported.
        var isRealTimeProcessing = false;

		var isActiveSnaponOperation = dat.isActiveSnaponOperation;
		var databaseIsBuilding = dat.databaseIsBuilding;
		var initialBuildDone = dat.initialBuildDone;
		var databaseIsReadyForReporting = dat.databaseIsReadyForReporting;

		var showDatabaseBuildDetails = !isRealTimeProcessing ? (!databaseIsBuilding && initialBuildDone) : databaseIsReadyForReporting;
		// var showNoDatabaseBuildInfo = !isRealTimeProcessing  ? (!databaseIsBuilding && !initialBuildDone) : !databaseIsReadyForReporting;
		
		// var showDatabaseProgress = (!isRealTimeProcessing && databaseIsBuilding);
		
		// Set current operation parameters
		var operationIcon = '';
		var operationLabel = '';
	
		if (isActiveSnaponOperation) {
			
			// Get snapon progress
			// showSnaponProgress();
			
			operationIcon = 'run';
			operationLabel = langVar('lang_stats.database.snapon_operation_active');
		}
		else if (databaseIsBuilding) {
			
			if (!isRealTimeProcessing) {
				
				operationIcon = 'run';
				operationLabel = langVar('lang_stats.database.database_is_building_or_updating');
			}
			else {
				
				// real time mode
				operationIcon = 'run';
				operationLabel = langVar('lang_stats.database.database_is_building_updating');
			}
		}
		else {
			
			operationIcon = 'stop';
			operationLabel = langVar('lang_stats.database.none_no_database_or_snapon_active');
		}
		
		util.showE('database_info:db_build_details_section', showDatabaseBuildDetails);
		// util.showE('database_info:db_no_build_info_section', showNoDatabaseBuildInfo);
		setCurrentOperation(operationIcon, operationLabel);
	}

	function setCurrentOperation(operationIcon, operationLabel) {
		
		// operationIcon is: stop | blink | run
		
		util.hideE([
			'database_info:progress_animation_stop',
			'database_info:progress_animation_blink',
			'database_info:progress_animation_run'
		]);
		
		if (operationIcon == 'stop') {
			util.showE('database_info:progress_animation_stop');
		}
		else if (operationIcon == 'run') {
			util.showE('database_info:progress_animation_run');
		}
		
		/*
		else if (operationIcon == 'blink') {
			util.showE('database_info:progress_animation_blink');
		}
		*/
		
		util.updateT('database_info:current_operation_text', operationLabel);
		util.showE('database_info:current_operation_section');
	}
	
	//
	// Return global properties and methods
	//
	
	return {
		updateDatabaseInfo: updateDatabaseInfo
	}
}();
	
