/* global
	util: false */


//
//
// Language variable util function
//
//

util.namspace('util.langVar');

util.langVar = (function() {

	'use strict';

	var checkedForIsLanguageModule = false,
		isLanguageModule = false,

		// lang contains language variables when in developer mode
		lang = {},

		getLangVariable = function(langVarPath) {

			// Return language variable if it exists, else return the langVarPath

			// Check if language variables exists by language module
			// name such as lang_stats, lang_config, etc.
			// If no language variable exists then we are in developer mode or
			// the variable is yet missing.
			if (!checkedForIsLanguageModule) {

				var i = langVarPath.indexOf('.');
				var langModule = langVarPath.slice(0, i);
				isLanguageModule  = (window[langModule] !== null);

				// We only check the first langVarPath
				checkedForIsLanguageModule = true;
			}

			// Replace each dot "." in the langVarPath with dot underscore "._"
			// because the language variables use an underscore in the js object to
			// prevent name conflicts for words such as "delete", "length", etc.
			var jsLangVarPath = langVarPath.replace(/\./g,'._');
			// alert('jsLangVarPath: ' + jsLangVarPath);
			var langVarValue;

			if (isLanguageModule) {

				try {

					langVarValue = eval(jsLangVarPath);
					// alert('langVarPath: ' + langVarPath + '\nlangVarValue: ' + langVarValue);
				}

				catch(ex) {

					// alert('Missing language variable in js file: "' + langVarPath + '"');
					langVarValue = jsLangVarPath;
				}
			}
			else {

				// Resolve language variables from server
				langVarValue = resolveLangVar(langVarPath, jsLangVarPath);
			}

			return langVarValue;

		},

		resolveLangVar = function(langVarPath, jsLangVarPath) {

			var langVarValue = '';

			if (util.lang[jsLangVarPath]) {

				langVarValue = util.lang[jsLangVarPath];
			}
			else {

				var url = '?dp=util.resolve_lang_var';
				url += '&pathname=' + encodeURIComponent(langVarPath);

				var request = util.newXMLHttpRequest();

				// Note, this is a synchronous server call

				request.open('GET', url, false);
				request.send(null);

				if (request.status === 200) {

					// alert(request.responseText);
					langVarValue = request.responseText;

					// Set language variable in lang for reuse
					util.lang[jsLangVarPath] = langVarValue;

					// util.showObject(xmlhttp.responseText);
				}
			}

			return langVarValue;
		};


	return {
		getLangVariable: getLangVariable
	}

}());

// Add shortcut for langVar
var langVar = util.langVar.getLangVariable();

