/* global
	langVar: false,
	YAHOO: false */

var util = util || {};

util = (function() {

	'use strict';

	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,

		// validHtmlElementAttributes & validImgElementAttributes are uses in createE() to distinguish
		// between html element and html style attributes
		validHtmlElementAttributes = {
			cellSpacing:true,
			colSpan:true,
			cols:true,
			className:true,
			href:true,
			htmlFor:true,
			id:true,
			rows:true,
			target:true,
			title:true,
			type:true,
			value:true
		},

		validImgElementAttributes = {
			id:true,
			className:true,
			src:true,
			width:true,
			height:true,
			title:true,
			alt:true
		},

		// List of XMLHttpRequest-creation factory functions to try
		HTTP_factories = [
			function() { return new XMLHttpRequest(); },
			function() { return new ActiveXObject('Msxml2.XMLHTTP'); },
			function() { return new ActiveXObject('Microsoft.XMLHTTP'); }
		],


		// When we find a factory that works store it here
		HTTP_factory = null,

		uniqueElementIdCount = 0, // used with getUniqueElementId

		getUniqueElementId = function() {

			var id = '';

			while (id === '' || document.getElementById(id)) {

				uniqueElementIdCount++;
                id = 'ueid_' + uniqueElementIdCount;
			}

//            console.log('id: ' + id);

			return id;
		},

		userAgent = {

			isIE: false,
			isIE6: false,
			name: '',

			init: function() {

				// returns the user agent brand

				var userAgentString = navigator.userAgent.toLowerCase();
				var userAgentAppName = navigator.appName.toLowerCase();
				var brand;

				// Note, Interent Explorer may contain multiple versions (8.0 and 6.0!) as this one:
				// -mozilla/4.0 (compatible; msie 8.0; windows nt 5.2; wow64; trident/4.0; mozilla/4.0 (compatible; msie 6.0; windows nt 5.1; sv1) ; .net clr 2.0.50727; .net clr 3.0.04506.30; .net clr 3.0.4506.2152; .net clr3.5.30729)
				// Consider this when checking for isIE6!

				if (userAgentString.indexOf('safari') !== -1) {
					userAgent.name = 'safari';
				}
				else if (userAgentString.indexOf('opera') !== -1) {
					userAgent.name = 'opera';
				}
				else if (userAgentAppName === 'netscape') {
					userAgent.name = 'netscape';
				}
				else if (userAgentAppName === 'microsoft internet explorer') {
					userAgent.name = 'msie';
					userAgent.isIE = true;

					// Check if this is Internet Explorer Version 6
					// (Regular Expression as defined in MSDN - Detecting Internet Explorer More Effectively)
					var re = new RegExp('msie ([0-9]{1,}[\u002e0-9]{0,})');
					var ieVersion = -1;
					if (re.exec(userAgentString) !== null) {
						ieVersion = parseFloat(RegExp.$1);
					}

					// alert('ieVersion: ' + ieVersion);

					if (ieVersion >= 6.0 && ieVersion < 7.0) {
						userAgent.isIE6 = true;
					}
				}
				else {
					userAgent.name = 'unknown';
				}

				// alert('userAgent.isIE: ' + userAgent.isIE + '\nuserAgent.isIE6: ' + userAgent.isIE6 + '\nuserAgent.name: ' + userAgent.name);
			}
		},


		// -- user interaction / session handler -------------------------------
		// This pings the server upon user interaction in defined intervals
		// so that a session timeout is reported early and not too late when
		// the user is going to save any changes.

		userInteractionTimer = 120000, // time in ms, set to 2 minutes

		initSession = function() {

			// A new session starts, a page just loaded.

//			console.log('initSession()');

			// Start listening for user interaction events later
			setTimeout(function() {
                startUserInteractionListener();
            }, userInteractionTimer);
		},

		startUserInteractionListener = function() {

//			console.log('startUserInteractionListener() - just started');
			YE.addListener(document, 'click', setSessionActive);
			YE.addListener(document, 'keydown', setSessionActive);
		},

		setSessionActive = function() {

//			console.log('setSessionActive()');

			// Some user interaction is active, ping the server
			// and start listening to user interaction again later

			// Remove the listener, we check for events again later
			YE.removeListener(document, 'click', setSessionActive);
			YE.removeListener(document, 'keydown', setSessionActive);

			// Ping the server so that the server knows that the user is active
			var url = '?dp=util.ping_session_active';
			serverPost(url);

			// Start listening to user interactions again later
			setTimeout(function() {
                startUserInteractionListener();
            }, userInteractionTimer);
		},

		pingSessionActiveResponse = function() {
			return false;
		},


		// -- general utilities ------------------------------------------------


		trim = function(theString) {
			// removes leading and trailing white space
			theString = theString.replace(/^\s+/, '');
			theString = theString.replace(/\s+$/, '');
			return theString;
		},

		isBoolean = function(a) {
			return typeof a === 'boolean';
		},

		isObject = function(a) {
			return (a && typeof a === 'object') || isFunction(a);
		},

		isFunction = function(a) {
			return typeof a === 'function';
		},

		isArray = function(a) {

			return isObject(a) && a.constructor === Array;
		},

		isUndefined = function(a) {

			return typeof a === 'undefined';
		},


		isInteger = function(a, /* optional */ min, /* optional */ max) {

			var pattern = /^[-]?\d+$/;

			if (a !== '' && pattern.test(a)) {

				var minIsValid = true;
				var maxIsValid = true;

				if (!isUndefined(min)) {
					if (parseInt(a, 10) < parseInt(min, 10)) {
						minIsValid = false;
					}
				}

				if (!isUndefined(max)) {
					if (parseInt(a, 10) > parseInt(max, 10)) {
						maxIsValid = false;
					}
				}

				if (minIsValid && maxIsValid) {
					return true;
				}
			}

			return false;
		},

		isFloat = function(a, min, max) {

			var pattern = /^[-]?\d*\.?\d*$/;

			if (a !== '' && pattern.test(a)) {

				var minIsValid = true;
				var maxIsValid = true;

				if (!isUndefined(min)) {
					if (parseFloat(a) < parseFloat(min)) {
						minIsValid = false;
					}
				}

				if (!isUndefined(max)) {
					if (parseFloat(a) > parseFloat(max)) {
						maxIsValid = false;
					}
				}

				if (minIsValid && maxIsValid) {
					return true;
				}
			}

			return false;
		},

		isRegularExpression = function(s) {

			if (s !== '') {

				try {
					var obj = new RegExp(s);
					return true;
				}
				catch(e) {
					return false;
				}
			}

			return false;
		},

		isEmailAddress = function(s) {

			// Returns true if s is a valid email address in the format:
			// 'username@hostname' || '<username@hostname>' || 'display name <username@hostname>'

			// pattern1 matches: 'display name <username@hostname>' || '<username@hostname>'
			// pattern2 matches: 'username@hostname'

			var pattern1 = /^.*<\w[-.&\w]+@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]{2,}>$/;
			var pattern2 = /^\w[-.&\w]+@[-a-z0-9]+(\.[-a-z0-9]+)*\.[a-z]{2,}$/;

			// alert('s: ' + s + '\nmatched pattern1: ' + s.match(pattern1) + '\nmatched pattern2: ' + s.match(pattern2));

			var isValid = (pattern1.test(s) || pattern2.test(s));

			return isValid;
		},

		getE = function(elementId) {

			// get element reference

			return document.getElementById(elementId);
		},

		focusE = function(elementId) {

			var element = getE(elementId);
			if (element) {

				// IE Hack, IE may show an error that it can't focus even if the
				// element is displayed, use setTimeout()
				setTimeout(function() {element.focus();}, 0);
				// element.focus();
			}
			else {
				alert('focusE(), element with id "' + elementId + '" \ndoes not exist.');
			}
		},

		enableE = function(elementList, /* optional */ enableElement) {

			if (typeof enableElement === 'undefined') {
				enableElement = true;
			}

			enableDisableElement(elementList, !enableElement);
		},


		disableE = function(elementList, /* optional */ disableElement) {

			if (typeof disableElement === 'undefined') {
				disableElement = true;
			}

			enableDisableElement(elementList, disableElement);
		},

		enableDisableElement = function(elementList, isDisabled) {

			var a = [];
			if (!isArray(elementList)) {
				a[0] = elementList;
			}
			else {
				a = elementList;
			}

			for (var i = 0; i < a.length; i++) {

				var element = getE(a[i]);

				if (element) {

					element.disabled = isDisabled;
				}
				else {

					alert('enableDisableElement(), element with id "' + a[i] + '" \ndoes not exist.');
				}
			}
		},

		showEV = function(elementList, /* optional */ showElement) {
			// show Elements visibility
			if (typeof showElement === 'undefined') {
				showElement = true;
			}

			_showHideElementVisibility(elementList, showElement);
		},

		hideEV = function(elementList, /* optional */ hideElement) {
			// hide Elements visibility
			if (typeof hideElement === 'undefined') {
				hideElement = true;
			}

			_showHideElementVisibility(elementList, !hideElement);
		},

		_showHideElementVisibility = function(elementList, displayElement) {

			var a = [];
			if (!isArray(elementList)) {
				a[0] = elementList;
			}
			else {
				a = elementList;
			}

			// alert('_showHideElementVisibility displayElement: ' + displayElement);

			for (var i = 0; i < a.length; i++) {

				var element = getE(a[i]);

				if (element) {
					var visibility = displayElement ? 'visible' : 'hidden';
					element.style.visibility = visibility;
				}
				else {
					alert('_showHideElementVisibility(), element with id "' + a[i] + '" \ndoes not exist.');
				}
			}
		},

		showE = function(elementList, /* optional */ showElement) {
			// Use only for display, not for visibility
			if (typeof showElement === 'undefined') {
				showElement = true;
			}

			_showHideElement(elementList, showElement);
		},

		hideE = function(elementList, /* optional */ hideElement) {
			// Use only for display, not for visibility
			if (typeof hideElement === 'undefined') {
				hideElement = true;
			}

			_showHideElement(elementList, !hideElement);
		},

		_showHideElement = function(elementList, displayElement) {

			var a = [];
			if (!isArray(elementList)) {
				a[0] = elementList;
			}
			else {
				a = elementList;
			}

			// alert('elementList 2: ' + elementList);

			for (var i = 0; i < a.length; i++) {

				var element = getE(a[i]);

				if (element) {

					var elementType = element.nodeName;
					var displayType;

					if (displayElement) {

						if (elementType === 'TD' ||
							elementType === 'TR' ||
							elementType === 'TBODY' ||
							elementType === 'LI' ||
							elementType === 'A') {

							displayType = '';
						}
						else {
							displayType = 'block';
						}
					}
					else {
						displayType = 'none';
					}

					if (element.style.display !== displayType) {
						element.style.display = displayType;
					}
				}
				else {
					alert('_showHideElement(), element with id "' + a[i] + '" \ndoes not exist.');
				}
			}
		},

		setF = function(elementOrElementId, theValue) {

			// set Form Value

			var element = (isObject(elementOrElementId)) ? elementOrElementId : getE(elementOrElementId);

			if (element) {
				var elementType = element.nodeName;

				// alert(elementType);

				switch (elementType) {

				case 'INPUT' :

					var typeAttr = element.type;

					if (typeAttr === 'text' || typeAttr === 'hidden') {

						element.value = theValue;
					}
					else if (typeAttr === 'checkbox' || typeAttr === 'radio') {

						element.checked = theValue;
					}
					else if (typeAttr === 'password') {

						// A password field can only be set when dynamically created
						// and by setting its value before appending it to the document.
						// Hence we create a new password field, set its value and replace
						// it with the existing one.

						var elementWidth = element.style.width;
						var containerElement = element.parentNode;
						var elementId = element.id;

						// delete existing password element
						containerElement.removeChild(element);

						// create new password element
						var newPasswordElement = document.createElement('input');
							newPasswordElement.type = 'password';
							newPasswordElement.id = elementId;
							newPasswordElement.value = theValue;
							newPasswordElement.style.width = elementWidth;
							containerElement.appendChild(newPasswordElement);
					}
					break;

				case 'SELECT' :

					var options = element.options;

					for (var i = 0, len = options.length; i < len; i++) {

						// alert(options[i].value);

						if (options[i].value === theValue) {
							options[i].selected = true;
							break;
						}
					}

					break;

				case 'TEXTAREA' :

					element.value = theValue;
					break;
				}
			}
			else {
				alert('setFormValue(), element with id "' + elementId + '" \ndoes not exist.');
			}
		},

		getF = function(elementId, /* optional */ trimFormValue) {

			// get Form Value

			var element = document.getElementById(elementId);
			var theValue;

			if (element) {

				var elementType = element.nodeName;

				// Set default trimFormValue if undefined
				if (typeof trimFormValue === 'undefined') {
					trimFormValue = true;
				}

				switch (elementType) {

					case 'INPUT' :

						var typeAttr = element.type;

						if (typeAttr === "text" || typeAttr === 'hidden' || typeAttr === 'password') {

							theValue = trimFormValue ? trim(element.value) : element.value;
						}
						else {

							theValue = element.checked;
						}
						break;

					case 'SELECT' :

						var i = element.selectedIndex;
						theValue = (i !== -1) ? element.options[i].value : '';
						break;

					case 'TEXTAREA' :

						theValue = trimFormValue ? trim(element.value) : element.value;

						// Clean multi line values from carriage return \r characters
						// which are added in IE so that we only have the line feed \n
						// instead of \r\n. Otherwise the value is interpreted as isModified
						// although nothing has been modified.

						var pattern = /\u000D/g; // Carriage return \r

						if (pattern.test(theValue)) {

							// Reomve all carriage returns
							theValue = theValue.replace(pattern, '');
						}

						break;
				}

				return theValue;
			}
			else {

				alert('getF(), element with id "' + elementId + '" \ndoes not exist.');
			}
		},

		resetF = function(elementList) {

			// Resets a form element, argument is a single form element Id or an array with form element Id's

			var a = [];
			if (!isArray(elementList)) {
				a[0] = elementList;
			}
			else {
				a = elementList;
			}

			for (var i = 0; i < a.length; i++) {

				var element = getE(a[i]);

				if (element) {

					element.reset();
				}
				else {
					alert('resetF(), element with id "' + a[i] + '" \ndoes not exist.');
				}
			}
		},

		populateSelect = function(elementOrElementId, theList, valueKey, textKey, defaultSelectedValueArg /*optional*/) {

			// Populates a select element. theList is an array with objects

			var element = (isObject(elementOrElementId)) ? elementOrElementId : getE(elementOrElementId);
			var defaultSelectedValue = (defaultSelectedValueArg !== null) ? defaultSelectedValueArg : '';

			if (element !== null) {

				// showObject(theList);

				element.options.length = 0;

				for (var i = 0, l = theList.length; i < l; i++) {

					var theValue = theList[i][valueKey];
					var makeSelected = (theValue === defaultSelectedValue);

					// showObject({theValue:theValue, defaultSelectedValue:defaultSelectedValue});

					element.options[i] = new Option(theList[i][textKey], theValue, makeSelected, makeSelected);
				}
			}
			else {
				alert('populateSelect(), element with id "' + elementId + '" \ndoes not exist.');
			}
		},

		extendSelect = function(elementOrElementId, theList, valueKey, textKey, defaultSelectedValueArg /*optional*/) {

			// This adds aditional options to a select element which is already populated
			var element = (isObject(elementOrElementId)) ? elementOrElementId : getE(elementOrElementId);
			var defaultSelectedValue = (defaultSelectedValueArg !== null) ? defaultSelectedValueArg : '';

			if (element) {

				var j = element.options.length;

				for (var i = 0, l = theList.length; i < l; i++, j++) {

					// showObject({f:'extendSelect', i:i, j:j});

					var theValue = theList[i][valueKey];
					var makeSelected = (theValue === defaultSelectedValue);

					element.options[j] = new Option(theList[i][textKey],theValue, makeSelected, makeSelected);
				}
			}
			else {
				alert('extendPopulatedSelect(), element with id "' + elementId + '" \ndoes not exist.');
			}
		},

		getSelectOptionText = function(elementId) {

			// returns the text of the selected option in a select element

			var text = '';
			var element = getE(elementId);

			if (element && (element.selectedIndex >= 0)) {

				text = element.options[element.selectedIndex].text;
			}

			return text;
		},

		getEncodedURIComponent = function(theValue) {

			// returns an encoded URI component value if theValue contains special characters

			var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]

			if (pattern.test(theValue)) {
				theValue = encodeURIComponent(theValue);
			}

			return theValue;
		},

		getRepetitionSequenceLetter = function(theSequence, theIndex) {

			// theSequence is an array, i.e. the latin alphabet ['A', 'B', 'C', ...]
			// theIndex is an integer which refers a letter in theSequence.
			// We return theSequence value.
			// If theIndex is equal or greater the length of theSequence then we extend theSequence
			// by adding duplicates of the initial sequence, so the sequence becomes:
			// ['A', 'B', 'C', ..., 'Z', 'AA', 'BB', 'CC', ..., 'ZZ', 'AAA', 'BBB', 'CCC', ... 'ZZZ', 'AAAA', ...]

			var numberOfSequenceItems = theSequence.length;

			if (theIndex < numberOfSequenceItems) {
				return theSequence[theIndex];
			}
			else {
				// Return a repetition of a single letter
				var repetitionFactor = Math.floor(theIndex / numberOfSequenceItems) + 1;
				var theIndexWhichFits = theIndex % numberOfSequenceItems;
				var theLetter = theSequence[theIndexWhichFits];
				var theLetterRepetition = '';
				for (var i = 0; i < repetitionFactor; i++) {
					theLetterRepetition += theLetter;
				}

				return theLetterRepetition
			}
		},

		createHash = function(theArray, theKey) {

			var hasKey = (typeof theKey !== 'undefined');
			var s = '';

			for (var i = 0, len = theArray.length; i < len; i++) {

				if (hasKey) {

					s = '__h__' + theArray[i][theKey];
					theArray[s] = theArray[i];
				}
				else {

					s = '__h__' + theArray[i];
					theArray[s] = theArray[i];
				}
			}
		},

		h = function(name) {
			// converts a hash name to the above hash format
			return '__h__' + name;
		},

		getArrayObject = function(theArray, theKey, theValue) {

			// returns an object reference from theArray where theKey has the value theValue
			var obj = {};
			for (var i = 0; i < theArray.length; i++) {
				if (theArray[i][theKey] === theValue) {
					obj = theArray[i];
					break;
				}
			}
			return obj;
		},

		getArrayObjectIndex = function(theArray, theKey, theValue) {

			// returns the index of the specified object
			for (var i = 0; i < theArray.length; i++) {
				if (theArray[i][theKey] === theValue) {
					return i;
				}
			}
		},

		getNextArrayObject = function(theArray, theKey, theValue) {

			// returns the next object of the given object in the array. If there is no next
			// object it will return the previous object. If there is no next or
			// previous object it will return null.

			var nextObject = null;
			var numberOfObjects = theArray.length;

			if (numberOfObjects > 1) {

				// get position of given object

				for (var i = 0; i < numberOfObjects; i++) {

					if (theArray[i][theKey] === theValue) {
						break;
					}
				}

				var nextIndex;

				if (i < (numberOfObjects - 1)) {
					nextIndex = i + 1;
				}
				else {
					nextIndex = i - 1;
				}

				nextObject = theArray[nextIndex];
			}

			return nextObject;
		},

		deleteArrayObject = function(theArray, theKey, theValue) {

			// Delete the object from theArray where theKey has the value theValue.
			// Ignore deletion if the object does not exist

			// get index of object to delete
			var objExists = false;

			for (var i = 0; i < theArray.length; i++) {

				if (theArray[i][theKey] === theValue) {
					objExists = true;
					break;
				}
			}

			// alert('index to delete: ' + i);

			if (objExists) {
				theArray.splice(i, 1);
			}
		},

		cloneObject = function(obj) {

			// returns a true copy of an array or object,
            // not just a reference.
			var copy;

            if (obj instanceof Date) {

                 // Handle Date

                copy = new Date();
                copy.setTime(obj.getTime());

                return copy;
            }
			else if (isArray(obj)) {

				copy = [];

				for (var i = 0, length = obj.length; i < length; i++) {

					copy[i] = cloneObject(obj[i]);
				}

                return copy;
			}
			else if (isObject(obj)) {

				copy = {};

				for (var prop in obj) {

                    if (obj.hasOwnProperty(prop)) {

                        copy[prop] = cloneObject(obj[prop]);
                    }
				}

                return copy;
			}
            // Handle the 3 simple types, and null or undefined
            else if (obj === null || typeof obj !== 'object') {

                return obj;
            }

			throw new Error("Unable to copy obj! Its type isn't supported.");
		},

		removeChildElements = function(s /* s is an elementID or an element*/) {

			var element = isObject(s) ? s : getE(s);

			while (element.lastChild) {
				var childElement = element.lastChild;
				element.removeChild(childElement);
			}
		},

		createE = function(elementType, attributes) {

			// Creates an element. attributes and labelText are optional arguments.
			// Note, attributes may contain html attributes and style attributes,
			// we check for differences here
			// I.e.:
			// createE('div');
			// createE('input', {id:id, type:'checkbox'});
			// createE('input', {id:id, type:'checkbox'}, {paddingLeft:'14px', margin:'5px'});

			var element = document.createElement(elementType);

			if (attributes !== null) {

				var validAttributes = (elementType !== 'img') ? validHtmlElementAttributes : validImgElementAttributes;

				for (var prop in attributes) {

					if (validAttributes[prop]) {
						// Apply element attribute
						element[prop] = attributes[prop];
					}
					else {
						// Apply element style attribute
						element.style[prop] = attributes[prop];
					}
				}
			}

			return element;
		},

		createT = function(s) {

			// Creates a new text node

			if (s === '&nbsp;') {
				s = '\u00a0';
			}

			return document.createTextNode(s);
		},


		updateT = function(elementId, text) {

			// Replaces any existing text of the element or creates a new text node if it does not yet exist

			var element = document.getElementById(elementId);

			if (element) {

				// alert('updateT() - element with text: ' + text);

				if (text === 0) {
					// alert('the text: ' + text + '\nis interpreted as the number 0');
					text = '0';
				}
				else if (text === '&nbsp;') {
					// alert('the text: ' + text + '\nis interpreted as space');
					text = '\u00a0'; // &nbsp;
				}

				var newText = document.createTextNode(text);

				if (element.firstChild) {
					// replace existing text
					var oldText = element.firstChild;
					element.replaceChild(newText, oldText);
				}
				else {
					// append new text
					element.appendChild(newText);
				}
			}
			else {
				alert('updateT() - element with elementId "' + elementId + '" does not exist.');
			}
		},

		chainE = function(/* html elements */) { // accepts any number of arguments

			// Chain elements appends the given html elements in two different ways

			// a.) Cascading (html elements are not given in an array)
			// Each previous element is the parent element, i.e.:
			// chainE(div, p, span, text);
			// span is the parent of text, p is the parent of span, div is the parent of p

			// b.) Tree (html elements are given in an array)
			// The first element of the array is the parent element, all following
			// elements in the array are appended to the 1st array element, i.e.:
			// chainE([div, p1, p2, p3, p4]);
			// All p elements (1-4) are appended to the 1st div element

			// Cascading and Tree can be combined, i.e.:
			// chainE(table, [tbody, [tr1, td1, text1], [tr2, td2, text2]]);
			// Arbitrary nesting of tree like arrays is allowed.


			var numberOfArguments = arguments.length;

			if (numberOfArguments > 1) {

				for (var i = numberOfArguments - 1; i > 0; i--) {

					var parentElement = arguments[i - 1];
					var childElement = arguments[i];

					if (isArray(parentElement)) {
						parentElement = _chainElementsTreeLike(parentElement);
					}

					if (isArray(childElement)) {
						childElement =  _chainElementsTreeLike(childElement);
					}

					// alert('chainE()' + '\nparentElement: ' + parentElement + '\nchildElement: ' + childElement);

					parentElement.appendChild(childElement);
				}
			}
			else {
				// There is only one argument, this must be an array to which we apply _chainElementsTreeLike()

				var element = _chainElementsTreeLike(arguments[0]);
				// The var element is not required in this case, its just a placeholder for the returned element
			}

			// alert('chainE() completed' );
		},

		_chainElementsTreeLike = function(elements) {

			// See chainE() for details

			// alert('_chainElementsTreeLike(): ' + elements);

			var parentElement = elements[0];

			if (isArray(parentElement)) {
				parentElement = _chainElementsTreeLike(parentElement);
			}

			for (var i = 1; i < elements.length; i++) {

				var childElement = elements[i];

				if (isArray(childElement)) {
					childElement = _chainElementsTreeLike(childElement);
				}

				parentElement.appendChild(childElement);
			}

			// alert('We return parentElement: ' + parentElement);

			return parentElement;
		},

		setConfigItemListHeight = function() {

			var config_item_list_body = document.getElementById('config_item_list_body');

			// alert('setConfigItemListHeight(): ' + config_item_list_body);

			var pos = YD.getXY('config_item_list_body');
			var configItemListY = pos[1];
			var pageY = YD.getClientHeight();

			var configItemListHeight = pageY - (configItemListY + 40);

			config_item_list_body.style.height = configItemListHeight + 'px';
		},


		// -- XMLHttpRequest - server background calls -------------------------


		newXMLHttpRequest = function() {

			// Create new XMLHttpRequest object

			// If HTTP_factory is already known then use that one
			if (HTTP_factory !== null) return HTTP_factory();

			for (var i = 0; i < HTTP_factories.length; i++) {

				try {

					var factory = HTTP_factories[i];
					var request = factory();
					if (request !== null) {
						HTTP_factory = factory;
						return request;
					}
				}
				catch(e) {
					continue;
				}
			}

			// If we get here then no factory candidate succeeded,
			// throw an exception now and for all future calls.
			HTTP_factory = function() {
				throw new Error("XMLHttpRequest not supported");
			};

			HTTP_factory(); // Throw an error
		},

		serverPost = function(url, dat) {

			// dat is optional

			// add volatile node for error handling
			if (dat) {
				dat += '&volatile.is_server_background_call=true';
			}
			else {
				dat = 'volatile.is_server_background_call=true';
			}

			var request = newXMLHttpRequest();

			// alert('request: ' + request);

			request.onreadystatechange = function() {
				if (request.readyState === 4) { // If the request is finished
					if (request.status === 200) { // If it was successful

//						alert(request.responseText.length);

						// If there is a response text
						if (request.responseText.length > 3) {
							eval('(' + request.responseText + ')');
						}

						/* DISABLED try and catch because it does not allow detailed debugging with Firebug
						try {

							eval('(' + request.responseText + ')');
						}
						catch (ex) {

							alertMsg = 'Inavlid response from server.\n\nServer response text:\n\n';
							alertMsg += request.responseText;
							alertMsg += '\n\n JavaScript error message:\n\n' + ex;

							alert(alertMsg);
						}
						*/
					}
				}
			};

			request.open('POST', url, true);
			request.send(dat);
		},

		authenticationFailureInServerBackgroundCall = function(dat) {

	//		if (dat.isSessionTimedOut) {
	//
	//			// Add volatile.session_timed_out=true to URL
	//			// before authentication.cfv is called the second time
	//			location.href = location.href + '&volatile.session_timed_out=true';
	//		}
	//		else {
	//
	//			// Unknown authentication failure
	//			// alert('authenticationFailureInServerBackgroundCall');
	//			alert(dat.errorMessage);
	//			// reload the current page so that we get the login form
	//			location.reload();
	//		}

			// KHP 08/Dec/2012 - ToDo - revise session time out handling
			// We suppose this is always a session time out, even if
			// dat.isSessionTimedOut is false
			location.href = location.href + '&volatile.session_timed_out=true';
		},


		// -- Miscellanious ----------------------------------------------------


		labelToNodeName = function(theLabel) {

			// Returns a valid node name of label or empty '' if the label
			// contains no single alphanumerical character.

			var label = theLabel.toLowerCase();
			var nodeName = '';
			var pattern = /[a-z0-9]/;

			if (pattern.test(label)) {

				// alert(label + ' Matched!');

				pattern = /[_a-z0-9]/;

				for (var i = 0; i < label.length; i++) {

					var s = label.charAt(i);
					var sUnicode = s.charCodeAt(0);
					// alert(s);\

					if (!pattern.test(s)) {

						if (sUnicode < 128) {

							s = '_';
						}
						else {
							// covert to hex
							s = sUnicode.toString(16);
						}
					}

					nodeName += s;
				}
			}

			return nodeName;
		},

		labelToUniqueNodeName = function(label, existingNodeNames, nodeNamePrefix) {

			// Returns a valid and unique node name.
			// The nodeNamePrefix is used as name in case that the label does
			// not contain any alphanumerical English characters.

			var i = 0;
			var len = existingNodeNames.length;
			var s = '';
			var nodeNameLookup = {};

			// Create nodeNameLookup
			// nodeNameLookup is an object in the format
			// o._name1 = true
			// o._name2 = true
			// the starting underscore "_" is not part of the node name but added to avoid any name conflicts

			for (i = 0; i < len; i++) {
				nodeNameLookup['_' + existingNodeNames[i]] = true;
			}

			var newNodeName = labelToNodeName(label);

			if (newNodeName !== '') {

				i = 1;
				s = '';
			}
			else {

				// The label does not contain any alphanumerical characters.
				// Give it the node name prefix

				newNodeName = nodeNamePrefix;
				i = 1;
				s = '_' + i;
			}

			while (nodeNameLookup['_' + newNodeName + s]) {
				i++;
				s = '_' + i;
			}

			newNodeName = newNodeName + s;

			return newNodeName;
		},

		arrayToString = function(a) {

			var s = "";

			for (var i = 0; i <a.length; i++) {

				var obj = a[i];

				for (var prop in obj) {

					s += "{" + prop + ":" + obj[prop] + "}";
				}
			}

			return s;
		},

//		setTabBarSpace = function(parentElementId, spacerCellId) {
//
//			// Sets the space of a tab-bar if the tab-bar consists of GUI controls on the right side
//			// so that the tab-bar table expands to the length of the parent panel.
//			// The spacer cell is a td element between the left tabs and right GUI controls.
//
//			var region = YD.getRegion(parentElementId);
//			var parentElementWidth = region.width;
//
//			var cellElement = getE(spacerCellId);
//			var table = cellElement.parentNode;
//			var tableRegion = YD.getRegion(table);
//			var tableWidth = tableRegion.width;
//
//			// alert('parentElementWidth: ' + parentElementWidth + '\ntableWidth: ' + tableWidth);
//
//			var deltaWidth = parentElementWidth - tableWidth;
//
//			if (deltaWidth > 0) {
//				// We apply a padding so that the table width can flow upon text sizing!
//				cellElement.style.paddingLeft = deltaWidth + 'px';
//			}
//		},


		// -- Date -------------------------------------------------------------


		salangDateToSimpleDateObject = function(salangDate) {

			// converts a salang date, i.e. 18/Jan/2006 to a javascript object in the format
			// o.year = 2006
			// o.month = 0
			// o.day = 18

			var salangJsMonths = {jan:0, feb:1, mar:2, apr:3, may:4, jun:5, jul:6, aug:7, sep:8, oct:9 ,nov:10, dec:11};
			var dat = salangDate.split('/');

			// showObject({"salangDateToSimpleDateObject() - salangDate argument": salangDate});
			// showObject({"salangDateToSimpleDateObject() - dat": dat});

			var obj = {};

			obj.year = parseInt(dat[2], 10);
			obj.month = salangJsMonths[dat[1].toLowerCase()];
			obj.day = parseInt(dat[0], 10); // make sure the radix of base 10 is defined so that i.e. "08" isn't converted to "0" which could occur in ECMAScript v3

			// showObject({"salangDateToSimpleDateObject() - obj": obj});

			return obj;
		},


		//
		// -- File manager window ----------------------------------------------
		//

		fileManagerWindow = {

			theWindow: null,

			open: function(pathnameElementId) {

				// alert('fileManagerWindow.open()');

				var url = '?dp=file_manager.file_manager_page';
				url += '&peid=' + encodeURIComponent(pathnameElementId);

				var windowName = 'file_manager';
				var width = 700;
				var height = 480;

				// check if a path is defined in the pathname field
				// if a path exists then start the file manager with the defined path
				var pathname = getF(pathnameElementId);

				// alert('pathname not encoded: ' + pathname);

				if (pathname !== '') {

					pathname = pathname.replace(/\\/g, '__HexEsc__5C');
					url += '&pathname=' + encodeURIComponent(pathname);
				}

				var left = parseInt((screen.availWidth/2) - (width/2), 10);
				var top = parseInt((screen.availHeight/2) - (height/2), 10);

				fileManagerWindow.theWindow = window.open(url,windowName,'location=no,width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
				fileManagerWindow.theWindow.focus();
			},

			setPathnameValue: function(pathnameElementId, pathname) {

				// This function is initiated from file manager,
				// it sets the pathname element to the given pathname
				setF(pathnameElementId, pathname);
			}
		},


		// -- Help window ------------------------------------------------------


		helpWindow = {

			theWindow: null,
			centralUrl: '?dp+docs.technical_manual.toc',
			contextUrl: '', // Set upon init, the link refers to a specific topic group, i.e. Log Filters or Reports

			init: function(contextUrl) {

				// alert('helpWindow.init()');

				YE.addListener('central_help_btn', 'click', helpWindow.openCentralHelp);

				if (contextUrl && contextUrl !== '') {
					helpWindow.contextUrl = contextUrl;
					YE.addListener('context_help_btn', 'click', helpWindow.openContextHelp);
				}
			},

			openCentralHelp: function(evt) {

				// Opens the help window via central help button
				YE.preventDefault(evt);
				helpWindow.open(helpWindow.centralUrl);
			},

			openContextHelp: function(evt) {

				// Opens the help window via toolbar context help button
				YE.preventDefault(evt);
				helpWindow.open(helpWindow.contextUrl);
			},

			openGeneralHelp: function(evt) {

				// Opens the help window from any link in the GUI. The URL must be specified
				// as regular anchor because we get the URL from this anchor.

				YE.preventDefault(evt);
				var element = evt.target || evt.srcElement;
				var url = element.href;
				helpWindow.open(url);
			},

			open: function(url) {

//				var width = YD.getViewportWidth() - 120;
//				var height = YD.getViewportHeight() - 60;
				var width = 1024;
				var height = 700;
				var features = 'width=' + width + ',height=' + height + ',location=yes,menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';

				helpWindow.theWindow = window.open(url, 'help', features);
				helpWindow.theWindow.focus();
			}
		},

		// -- About ------------------------------------------------------------

		about = {

			isDisplayed: false,

			toggleAboutSection: function() {

				var showAboutSection = !about.isDisplayed;
				showE('product_bar:about_section', showAboutSection);
				about.isDisplayed = showAboutSection;
			}
		},


		// -- Error / Alert handling -------------------------------------------


		errorInServerBackgroundCall = {

			panel: null,

			init: function() {

				//
				// Create the error panel
				//

				var panelId = 'error_in_server_background_call:panel';


				var bodyElements = document.getElementsByTagName('body');
				var body = bodyElements[0];

				var mainDiv = createE('div', {id:panelId, className:'panel-50'});

				chainE(body, mainDiv);

				// We create the alert panel via innerHTML because it doesn't correctly render
				// when creating it via DOM elements in Firefox
				var htmlString = '<div class="panel-50-body">';

				htmlString += '<div class="panel-50-form" style="width:340px;background-color:White">';
				htmlString += '<p style="font-weight:bold;color:Red">' + langVar('lang_stats.error_handling.error_while_processing_last_request') + '</p>';

				htmlString += '<a id="error_in_server_background_call:view_alert_msg_btn" href="?dp=alert" target="_blank">';
				htmlString += langVar('lang_stats.error_handling.click_here_to_view_alert_msg');
				htmlString +=  '</a>';
				htmlString += '</div>'; // panel-50-form

				htmlString += '<div style="text-align:center;padding:12px"><a id="error_in_server_background_call:close_alert_btn" href="javascript:;">';
				htmlString += langVar('lang_stats.btn.close');
				htmlString +=  '</a></div>';


				htmlString += '</div>'; // panel-50-body

				mainDiv.innerHTML = htmlString;

				//
				// Init the error panel object
				//

				var panelObj = {
					panelId: panelId,
					panelClassName: 'panel-50',
					panelHeaderLabel: langVar('lang_stats.error_handling.product_alert_info'),
					left: 60,
					top: 60,
					zIndex: 5000,
					isCover: true,
					isCloseButton: false
				};

				errorInServerBackgroundCall.panel = new util.Panel3(panelObj);

				YE.addListener('error_in_server_background_call:close_alert_btn', 'click', errorInServerBackgroundCall.close);
			},

			open: function(errorId) {

				if (!errorInServerBackgroundCall.panel) {
					errorInServerBackgroundCall.init();
				}

				var viewAlertBtn = getE('error_in_server_background_call:view_alert_msg_btn');
				viewAlertBtn.href = '?dp=alert&ei=' + errorId;

				errorInServerBackgroundCall.panel.open();
			},

			close: function() {

				errorInServerBackgroundCall.panel.close();

				// If this is the New Profile Wizard window
				// then restore the new profile wizard page

				try {
					restoreNewProfileWizardPageAfterError();
				}
				catch(msg) {}
			}
		},


		// -- Trial mode utilities ---------------------------------------------


		trialLicensingTier = {

			reminderPanel: null,

			init: function(showTrialReminder, days_left) {

				// Init the change trial licensing tier button

				var a = [
					'prompt_for_trial_tier:lite',
					'prompt_for_trial_tier:pro',
					'prompt_for_trial_tier:enterprise'
				];

				YE.addListener(a, 'click', trialLicensingTier.change);
				// trialLicensingTier.btn.enable();
				// YE.addListener(document, 'unload', trialLicensingTier.exit);

				// Enable dropDownMenu
				util.dropDownMenu.add('change_licensing_tier:btn', 'prompt_for_trial_tier:drop_down');


				if (showTrialReminder) {
					// This checks and sets a flag in "system" so that the reminder
					// isn't shown twice.

					var url = '?dp=util.check_show_trial_reminder';
					var dat = 'v.fp.page_token=' + pageInfo.changeTrialLicensingTierToken;
					dat += '&v.fp.days_left=' + days_left;
					serverPost(url, dat);
				}
			},

			change: function() {

				var elementId = this.id;

				// Check if we have any unsaved changes on the current page

				if (adminConfig.getIsExitPagePermission()) {

					var bodyElements = document.getElementsByTagName('body');
					var bodyElement = bodyElements[0];
					bodyElement.style.display = 'none';

					// User clicked on a link to change the trial mode
					var elementDat = elementId.split(':');
					var trialLicensingFeatures = elementDat[1];

					var url = '?dp=util.change_trial_licensing_tier';
					var dat = 'v.fp.page_token=' + pageInfo.changeTrialLicensingTierToken;
					dat += '&v.fp.trial_licensing_features=' + trialLicensingFeatures;
					serverPost(url, dat);
				}
			},

			changeResponse: function() {

				location.reload(true);
			},

			showTrialReminderResponse: function(showTrialReminder) {

				if (showTrialReminder) {

					var panelObj = {
						panelId: 'trial_reminder:panel',
						panelClassName: 'panel-30',
						panelHeaderLabel: langVar('lang_admin.trial.reminder'),
						zIndex: 20,
						closeEvent: trialLicensingTier.closeTrialReminder
					};

					trialLicensingTier.reminderPanel = new util.Panel3(panelObj);
					YE.addListener('trial_reminder:close_btn', 'click', trialLicensingTier.closeTrialReminder);

					trialLicensingTier.reminderPanel.prePositionAtCenter();
					trialLicensingTier.reminderPanel.open();
				}
			},

			closeTrialReminder: function() {

				trialLicensingTier.reminderPanel.close();
			}
		},


		// -- Namespace --------------------------------------------------------

//		namespace = function(nsString) {
//
//			// This creates the nsString namespace if it doesn't yet exist.
//			var parts = nsString.split('.'),
//				parent = parts[0];
//
//			// If parent property does not yet exist
//			if (typeof parent === 'undefined') {
//				parent = {};
//			}
//
////			console.log('namespace parts: ' + parts);
//
//			// Strip redundant parent
//			parts = parts.slice(1);
//
////			console.log('namespace parts 2: ' + parts);
//
//			for (var i = 0; i < parts.length; i++) {
//
//				// Create a property if it doesn't yet exist
//				if (typeof parent[parts[i]] === 'undefined') {
//					parent[parts[i]] = {};
//				}
//
//				parent = parent[parts[i]];
//			}
//
//			return parent;
//		},


		// -- ShowObject handling ----------------------------------------------

		showObjectWindowId = '', // Used with showObject, keeps the showObjectWindowId

		createShowObjectWindow = function() {

			var bodyElements = document.getElementsByTagName('body');
			var body = bodyElements[0];

			showObjectWindowId = getUniqueElementId();

			var mainDivProperties = {
				id: showObjectWindowId,
				position: 'absolute',
				top: 0,
				right: 0,
				borderStyle: 'solid',
				borderWidth: '1px',
				borderColor: 'Silver',
				backgroundColor: 'White',
				zIndex: 5000
			};

			var objectDivProperties = {
				id: showObjectWindowId + ':body',
				width: '800px',
				height: '700px',
				overflow: 'scroll'
			};

			var mainDiv = createE('div', mainDivProperties);
			var headerDiv = createE('div', {padding:'4px', backgroundColor:'#f5f5f5'});
			var a = createE('a', {id:showObjectWindowId + ':close_btn', href:'javascript:;'});
			var aText = createT('Close Object Window');
			var objectDiv = createE('div', objectDivProperties);

			chainE(headerDiv, a, aText);
			chainE(body, [mainDiv, headerDiv, objectDiv]);

			YE.addListener(showObjectWindowId + ':close_btn', 'click', closeShowObjectWindow);
		},

		closeShowObjectWindow = function() {

			// Clean object viewer
			removeChildElements(showObjectWindowId + ':body');
			hideE(showObjectWindowId);
		},

		showObject = function(obj, comment) {

			// showObject outputs objects to a debug window
			// The comment argument is optional

			if (showObjectWindowId === '') {

				createShowObjectWindow();
			}

			// Create a new div which we append to the already existing object viewer
			var container = getE(showObjectWindowId + ':body');
			var div = createE('div', {padding:'0 14px', borderBottom:'1px solid Silver', zIndex: 5000});
			chainE(container, div);

			var text = '';

			if (comment) {
				text += '<strong>' + comment + '</strong><br />';
			}

			var objAsString = JSON.stringify(obj, null, '&nbsp;');

			text += '<pre>' + objAsString.replace(/\u000A/g, '<br />') + '</pre>';

			div.innerHTML = text;

			showE(showObjectWindowId);
		},

		// -- Drop down util ---------------------------------------------------

		positionAndShowDropDownElement = function(btnElement, menuElement) {

			// This sets the position of a drop-down element relative
			// to the button and available space.

			var clientRegion = YD.getClientRegion();
			var clientWidth = clientRegion.width;
			var clientHeight = clientRegion.height;
//			showObject(clientRegion);

			var btnRegion = YD.getRegion(btnElement);
			var btnTop = btnRegion.top;
			var btnBottom = btnRegion.bottom;
			var btnLeft =  btnRegion.left;
			var btnRight =  btnRegion.right;

//			showObject(btnRegion);

			// Get region of drop down menu
			menuElement.style.visibility = 'hidden';
			menuElement.style.top = 0;
			menuElement.style.left = 0;
			menuElement.style.display = 'block';
			var menuRegion = YD.getRegion(menuElement);
//			showObject(menuRegion);
			var menuWidth = menuRegion.width;
			var menuHeight = menuRegion.height;

			// Get menu top and menu left
			var alignLeft = false;
			var alignBottom = false;

			// Check if we align menu left or right of button
			if ((btnLeft + menuWidth) <= clientWidth) {
				// Align left of button
				alignLeft = true;
			}
			else if (btnRight - menuWidth >= 0) {
				// Align right of button
				alignLeft = false;
			}
			else {
				// Align on the side where more space is left
				var spaceOnRight = clientWidth - btnLeft;
				var spaceOnLeft = btnRight;

				if (spaceOnRight >= spaceOnLeft) {
					// Align left of button
					alignLeft = true;
				}
				else {
					// Align right of button
					alignLeft = false;
				}
			}

			// Check if we align menu bottom or top of button
			var menuLeft = alignLeft ? btnLeft : btnRight - menuWidth;
			var menuTop = btnBottom;

//			console.log('menuTop: ' + menuTop);
//			console.log('menuLeft: ' + menuLeft);

			// Set final position
			menuElement.style.top = menuTop + 'px';
			menuElement.style.left = menuLeft + 'px';


			// Show the menu
			menuElement.style.visibility = 'visible';
		};

	return {

		getUniqueElementId: getUniqueElementId,
		userAgent: userAgent,
		initSession: initSession,
		startUserInteractionListener: startUserInteractionListener,
		setSessionActive: setSessionActive,
        pingSessionActiveResponse: pingSessionActiveResponse,
		trim: trim,
		isBoolean: isBoolean,
		isObject: isObject,
		isFunction: isFunction,
		isArray: isArray,
		isUndefined: isUndefined,
		isInteger: isInteger,
		isFloat: isFloat,
		isRegularExpression: isRegularExpression,
		isEmailAddress: isEmailAddress,
		getE: getE,
		focusE: focusE,
		enableE: enableE,
		disableE: disableE,
		enableDisableElement: enableDisableElement,
		showEV: showEV,
		hideEV: hideEV,
		showE: showE,
		hideE: hideE,
		setF: setF,
		getF: getF,
		resetF: resetF,
		populateSelect: populateSelect,
		extendSelect: extendSelect,
		getSelectOptionText: getSelectOptionText,
		getEncodedURIComponent: getEncodedURIComponent,
		getRepetitionSequenceLetter: getRepetitionSequenceLetter,
		createHash: createHash,
		h: h,
		getArrayObject: getArrayObject,
		getArrayObjectIndex: getArrayObjectIndex,
		getNextArrayObject: getNextArrayObject,
		deleteArrayObject: deleteArrayObject,
		cloneObject: cloneObject,
		removeChildElements: removeChildElements,
		createE: createE,
		createT: createT,
		updateT: updateT,
		chainE: chainE,
		_chainElementsTreeLike: _chainElementsTreeLike,
		setConfigItemListHeight: setConfigItemListHeight,
		newXMLHttpRequest: newXMLHttpRequest,
		serverPost: serverPost,
		authenticationFailureInServerBackgroundCall: authenticationFailureInServerBackgroundCall,
		labelToNodeName: labelToNodeName,
		labelToUniqueNodeName: labelToUniqueNodeName,
		arrayToString: arrayToString,
		salangDateToSimpleDateObject: salangDateToSimpleDateObject,
		fileManagerWindow: fileManagerWindow,
		helpWindow: helpWindow,
		about: about,
		errorInServerBackgroundCall: errorInServerBackgroundCall,
		trialLicensingTier: trialLicensingTier,
//		namespace: namespace,
		closeShowObjectWindow: closeShowObjectWindow,
		showObject: showObject,
		positionAndShowDropDownElement: positionAndShowDropDownElement
	};

}());

// Invoke upon load
util.userAgent.init();