/* global
	util: false,
	YAHOO: false */

//
//	dropDownMenu control
//

//util.namespace('util.dropDownMenu');

util.dropDownMenu = (function() {

	'use strict';

	var menuItems = {}, // contains obj as defined below, accessible by btnElementId
		activeMenuItemId = '',

		// Drop down region
		region = {
			left: 0,
			top: 0,
			right: 0,
			bottom: 0
		},

		// Active mouse position tracked by mousemove
		pageX = 0,
		pageY = 0,

		add = function(btnElementId, dropDownElementId) {

			// register menuItem by btnElementId

			var obj = {};
			obj.btnElementId = btnElementId;
			obj.dropDownElement = util.getE(dropDownElementId);

			menuItems[btnElementId] = obj;

			// add event
			YAHOO.util.Event.addListener(btnElementId, 'click', toggle);
		},

		toggle = function(evt) {

			// invoked upon click on btnElementId
			// open or close drop down

			var btnElement = evt.target || evt.srcElement;

			if (btnElement.nodeName !== 'A') {
				btnElement = btnElement.parentNode;
			}

			if (activeMenuItemId === '') {

				// Drop down menu is closed, open it.
				var obj = menuItems[btnElement.id];

				// get Region of reference element
				var btnRegion = YAHOO.util.Dom.getRegion(btnElement);

				var ul = obj.dropDownElement;
				ul.style.top = btnRegion.bottom + 'px';
				ul.style.left = btnRegion.left + 'px';

				ul.style.display = 'block';

				// Write ul region to obj which we check for move out coordinates

				var dropDownRegion = YAHOO.util.Dom.getRegion(ul);
				// Override the top region with the btn region so that we can move out of the ul,
				// We also add some padding around so that the ul does not immediately disappear.

				region.top = btnRegion.top;
				region.left = dropDownRegion.left - 18;
				region.right = dropDownRegion.right + 18;
				region.bottom = dropDownRegion.bottom + 18;

				activeMenuItemId = btnElement.id;

				YAHOO.util.Event.addListener(document, 'mousemove', function(evt) {

					// Track mouse position
					pageX = evt.pageX;
					pageY = evt.pageY;

					setTimeout(function() {
						closeByMoveOut();
					}, 200);
				});

				YAHOO.util.Event.addListener(ul, 'mouseup', closeByMouseClick);

			}
			else {
				// drop down is open, close it
				close();
			}
		},

		close = function() {

			// Make sure the menu hasn't been closed yet.
			if (activeMenuItemId !== '') {

				var obj = menuItems[activeMenuItemId];
				var ul = obj.dropDownElement;

				YAHOO.util.Event.removeListener(document, 'mousemove');
				YAHOO.util.Event.removeListener(ul, 'mouseup');
				ul.style.display = 'none';

				activeMenuItemId = '';
			}
		},

		closeByMouseClick = function(evt) {

			// Close the drop down upon left mousedown

			var i = (!util.userAgent.isIE) ? evt.button : evt.button - 1;

			if (i === 0) {
				close();
			}

			// alert('closeByMouseClick: ' + evt.button);
		},

		closeByMoveOut = function() {

			// closes the drop down when moving out of it
			var x = pageX;
			var y = pageY;

			if (x < region.left || x > region.right || y < region.top || y > region.bottom) {
				close();
			}
		};

	return {
		add: add
	};

}());