/* global
	imgDb: false,
	util: false,
	YAHOO: false */

//
//
//
// MoveControl class
//
//


(function() {

	'use strict';

//	util.namespace('util');

	util.MoveControl = function(baseId, moveEvent) {

		// Move control baseId is the element ID of the move control container div
		// Each image element ID in this container is a combination
		// of the baseID and move direction as follwos:
		// id="baseId:top"
		// id="baseId:up"
		// id="baseId:down"
		// id="baseId:bottom"

		// Note, the baseId may contain other colons ':'

		this.baseId = baseId;
		this.moveEvent = moveEvent;

		this.buttonsState = {
			top: {id:baseId + ':top', isDisabled:true, src:imgDb.moveTop.src, srcDis:imgDb.moveTopDis.src},
			up: {id:baseId + ':up', isDisabled:true, src:imgDb.moveUp.src, srcDis:imgDb.moveUpDis.src},
			down: {id:baseId + ':down', isDisabled:true, src:imgDb.moveDown.src, srcDis:imgDb.moveDownDis.src},
			bottom: {id:baseId + ':bottom', isDisabled:true, src:imgDb.moveBottom.src, srcDis:imgDb.moveBottomDis.src}
		};
	};

	util.MoveControl.prototype = {

		setState: function(selectedItemIndex, numberOfItems) {

			// Sets the move control button state (enabled/disabled) depending
			// of selectedItemIndex and numberOfItems.

			//
			// Set default state
			//

			var moveDisabled = {
				top: true,
				up: true,
				down: true,
				bottom: true
			};

			//
			// Set active state
			//

			if (selectedItemIndex >= 0 && numberOfItems > 1) {

				if (selectedItemIndex > 0) {
					moveDisabled.top = false;
					moveDisabled.up = false;
				}

				if (selectedItemIndex < (numberOfItems - 1)) {
					moveDisabled.down = false;
					moveDisabled.bottom = false;
				}
			}

			//
			// Set the buttons
			//

			var buttonsState = this.buttonsState;

			for (var prop in moveDisabled) {

				var isDisabled = moveDisabled[prop];

				var theButton = buttonsState[prop];

				if (isDisabled !== theButton.isDisabled) {

					// Change the button state

					var img = util.getE(theButton.id);
					img.src = isDisabled ? theButton.srcDis : theButton.src;
					theButton.isDisabled = isDisabled;

					if (isDisabled) {
						YAHOO.util.Event.removeListener(img, 'click', this.moveItem);
					}
					else {
						YAHOO.util.Event.addListener(img, 'click', this.moveItem, this);
					}
				}
			}
		},

		moveItem: function(evt, self) {

			var element = evt.target || evt.srcElement;
			var elementId = element.id;
			var direction = self.getMoveDirection(elementId);
			self.moveEvent(direction);
		},

		getMoveDirection: function(buttonElementId) {

			var dat = buttonElementId.split(':');
			var lastItemIndex = dat.length - 1;
			return dat[lastItemIndex];
		},

		setPosition: function(listElementId) {

			// Sets the absolute position of the move control
			// alert('setPosition');

			var moveElement = util.getE(this.baseId);
			var region = YAHOO.util.Dom.getRegion(listElementId);

			// util.showObject(region);

			moveElement.style.top = region.top + 'px';
			moveElement.style.left = (region.left - 46) + 'px';
			moveElement.style.display = 'block';
		}
	};

}());