/* global
	imgDb: false,
	langVar: false,
	util: false,
	YAHOO: false */



//
//	Panel3 class
//

(function() {

	'use strict';

//	util.namespace('util');

	util.Panel3 = function(obj) {

		// util.showObject(obj);
		// Default values become overwritten by obj
		this.panelId = null;
		this.panelClassName = ''; // i.e. panel-50
		this.width = -1;
		this.height = -1;
		this.top = -1;
		this.left = -1;
		this.right = -1;
		this.bottom = -1;
		this.zIndex = 20; // The zIndex of the panel, we require the zIndex for the form, the cover and iframe!
		this.isCover = false; // Creates a background cover if true
		this.isCloseButton = true;
		this.closeEvent = null;

		// this.isIframe = util.userAgent.isIE;
		this.isIframe = false; // KHP 31/JAN/2011 - the iframe becomes a problem with drag drop, check for solution

		// alert('this.isIframe: ' + this.isIframe);

		// If isSticky is given and is true then we don't re-position the panel upon "scroll",
		// it sticks at the position where the panel is initially positioned.
		// This is useful for panels which don't fit in Admin or Config
		this.isSticky = false;
		this.panelHeaderLabel = '';

		// this.isScroll = false;

		// Override default values
		for (var prop in obj) {
			this[prop] = obj[prop];
		}

		this.headerTitleId = '';
		this.coverId = '';
		this.iframeId = '';

		var panel = util.getE(this.panelId);

		panel.style.zIndex = this.zIndex;

		if (this.width > 0) {
			panel.style.width = this.width + 'px';
		}

		if (this.height > 0) {
			panel.style.height = this.height + 'px';
		}

		if (this.panelHeaderLabel !== '') {

			//
			// Create the panel header and insert it into the panel
			//

			var titleId =  util.getUniqueElementId();
			var imageContainerId = util.getUniqueElementId();

			var firstElement = panel.firstChild;

			var headerDiv = document.createElement('div');
			var headerElementId = this.panelId + ':header';
			headerDiv.id = headerElementId;
			headerDiv.className = this.panelClassName + '-header';

			var headerFrameDiv = document.createElement('div');
			headerFrameDiv.id = imageContainerId;
			headerFrameDiv.className = this.panelClassName + '-header-frame';

			var headerTitleDiv = document.createElement('div');
			headerTitleDiv.id = titleId;
			headerTitleDiv.className = this.panelClassName + '-header-title';
			var headerTitleTxt;

			if (this.panelHeaderLabel !== '-') {
				headerTitleTxt = document.createTextNode(this.panelHeaderLabel);
			}
			else {
				headerTitleTxt = document.createTextNode('\u00a0');
			}

			var headerBottomDiv = document.createElement('div');
			headerBottomDiv.className = this.panelClassName + '-header-bottom';

			// var spaceTxt = document.createTextNode('\u00a0'); // inserts &nbsp;
			var spaceTxtA = document.createTextNode('\u00a0');
			var spaceTxtB = document.createTextNode('\u00a0');

			headerTitleDiv.appendChild(headerTitleTxt);
			headerFrameDiv.appendChild(headerTitleDiv);
			headerFrameDiv.appendChild(spaceTxtA);
			headerBottomDiv.appendChild(spaceTxtB);

			if (this.isCloseButton) {

				var img = document.createElement('img');
				img.src = imgDb.panelClose.src;
				img.alt = langVar('lang_stats.btn.close');
				img.width = imgDb.panelClose.width;
				img.height = imgDb.panelClose.height;

				if (this.closeEvent) {
					// Use external close event to close the panel
					YAHOO.util.Event.addListener(img, 'click', this.closeEvent, this);
				}
				else {
					// Use internal close event to close the panel
					YAHOO.util.Event.addListener(img, 'click', this._close, this);
				}

				headerFrameDiv.appendChild(img);
			}

			headerDiv.appendChild(headerFrameDiv);
			headerDiv.appendChild(headerBottomDiv);

			panel.insertBefore(headerDiv, firstElement);

			this.headerTitleId = titleId;


			// Handle drag drop
			var dd = new YAHOO.util.DD(this.panelId);
			dd.setHandleElId(headerElementId);
		}

		//
		// Create the footer
		//

		var footerDiv = document.createElement('div');
		footerDiv.className = this.panelClassName + '-footer';
		var footerOffsetDiv = document.createElement('div');
		footerOffsetDiv.className = this.panelClassName + '-footer-offset';

		var footerSpaceTxt = util.createT('&nbsp;');

		footerOffsetDiv.appendChild(footerSpaceTxt);
		footerDiv.appendChild(footerOffsetDiv);
		panel.appendChild(footerDiv);

		//
		// Create background cover which hides underlying elements
		//

		if (this.isCover) {

			this.coverId = util.getUniqueElementId();
			var coverZIndex = this.zIndex - 5;
			var coverDiv = util.createE('div', {id:this.coverId, className:'form-cover', zIndex:coverZIndex});
			var coverText = util.createT('&nbsp;');
			util.chainE(coverDiv, coverText);
			panel.parentNode.appendChild(coverDiv);
		}


		// Create iframe element as form backround.
		// This fixes IE so that no elements shine through the form.

		if (this.isIframe) {

			this.iframeId = util.getUniqueElementId();

			var iframe = document.createElement('iframe');
			iframe.id = this.iframeId;
			iframe.tabIndex = '-1';
			iframe.src = 'javascript:false;';
			iframe.className = 'form-cover';
			iframe.style.zIndex = this.zIndex - 2;
			panel.parentNode.appendChild(iframe);
		}
	};


	util.Panel3.prototype = {

		open: function(obj) {

			// obj is optional and has the properties left, top, right, bottom and label
			// If a position argument is given it overrides any existing absolute position
			// If a label argument is given it sets the panel header label

			if (typeof obj !== 'undefined') {

				// Note, if i.e. the "left" position is given then we set
				// the "right" position to default value!

				if (obj.hasOwnProperty('left')) {
					this.left = obj.left;
					this.right = -1;
				}

				if (obj.hasOwnProperty('right')) {
					this.right = obj.right;
					this.left = -1;
				}

				if (obj.hasOwnProperty('top')) {
					this.top = obj.top;
					this.bottom = -1;
				}

				if (obj.hasOwnProperty('bottom')) {
					this.bottom = obj.bottom;
					this.top = -1;
				}

				if (obj.hasOwnProperty('label')) {
					util.updateT(this.headerTitleId, obj.label);
				}
			}

			// alert('this.top after open(): ' + this.top);

			if (this.isCover) {

				this.setCoverSize();
				YAHOO.util.Event.addListener(window, 'resize', this.setCoverSizeUponResize, this);
				util.showE(this.coverId);
			}

			if (!this.isSticky) {
				YAHOO.util.Event.addListener(window, 'scroll', this._setPositionByWindow, this);
			}

			// set initial position
			this._setPosition(true/* true because this is the initial positioning */);

			util.showE(this.panelId);

			if (this.isIframe) {
				this.setIframePositionAndSize();
				util.showE(this.iframeId);
			}
		},

		_close: function(evt, self) {

			// _close() is only used if no external closeEvent is given!
			self.close();
		},

		close: function() {

			if (!this.isSticky) {
				YAHOO.util.Event.removeListener(window, 'scroll', this._setPositionByWindow);
			}

			util.hideE(this.panelId);

			if (this.isIframe) {
				util.hideE(this.iframeId);
			}

			if (this.isCover) {
				YAHOO.util.Event.removeListener(window, 'resize', this.setCoverSizeUponResize, this);
				util.hideE(this.coverId);
			}
		},

		_setPositionByWindow: function(evt, self) {

			var isInitialPositioning = false;
			self._setPosition(isInitialPositioning);
		},

		_setPosition: function(isInitialPositioning) {

			// If isInitialPositioning is true then we don't position the iframe
			// because the panel is not yet open, in all other cases we
			// position the iframe if it exists.

			// alert('update position of panelId: ' + this.panelId);
			var element = util.getE(this.panelId);
			var scrollY = YAHOO.util.Dom.getDocumentScrollTop();
			var scrollX = YAHOO.util.Dom.getDocumentScrollLeft();

			// util.showObject(this);

			if (this.top >= 0) {
				// alert('this.top: ' + this.top + '\nthis.left: ' + this.left);
				// alert('this.top: ' + this.top + '\nscrollY: ' + scrollY);
				element.style.top = (this.top + scrollY) + 'px';
			}

			if (this.left >= 0) {
				// alert('set left position to: ' + (left + scrollX) + 'px');
				element.style.left = (this.left + scrollX) + 'px';
			}

			if (this.right >= 0) {
				// alert('set right position to: ' + (right + scrollX) + 'px');
				element.style.right = (this.right + scrollX) + 'px';
			}

			if (!isInitialPositioning && this.isIframe) {
				this.setIframePositionAndSize();
			}

			// util.showObject(element.style.top);
		},

		setIframePositionAndSize: function() {

			var region = YAHOO.util.Dom.getRegion(this.panelId);
			var element = util.getE(this.iframeId);
			element.style.top = region.top;
			element.style.left = region.left;
			element.style.width = region.width;
			element.style.height = region.height;
		},

		prePositionAtCenter: function() {

			// Display the panel temporary so that we get the region
			var panel = util.getE(this.panelId);
			panel.style.top = '0px';
			panel.style.left = '0px';
			panel.style.display = 'block';
			panel.style.visibility = 'hidden';

			// util.showE(this.panelId);
			// util.hideEV(this.panelId);

			var panelRegion = YAHOO.util.Dom.getRegion(panel);

			// util.showObject(region);
			panel.style.display = 'none';
			panel.style.visibility = '';

			var panelWidth = panelRegion.width;
			var panelHeight = panelRegion.height;

			var viewportWidth = YAHOO.util.Dom.getViewportWidth();
			var viewportHeight = YAHOO.util.Dom.getViewportHeight();

			// var topDistance = ((viewportHeight - panelHeight) / 2) - 30;
			var topDistance = ((viewportHeight - panelHeight) / 3);
			var leftDistance = (viewportWidth - panelWidth) / 2;

			this.top = (topDistance > -1) ? topDistance : 0;
			this.left = (leftDistance > -1) ? leftDistance : 0;
		},

		setCoverSizeUponResize: function(evt, self) {
			self.setCoverSize();
		},

		setCoverSize: function() {

			var coverElement = util.getE(this.coverId);
			coverElement.style.width = YAHOO.util.Dom.getDocumentWidth() + 'px';
			coverElement.style.height = YAHOO.util.Dom.getDocumentHeight() + 'px';
		}
	};

}());