/* global
	util: false,
	YAHOO: false */


//
//	Tabs3 class (replaces Tab and Tab2 class)
//

//	This class fixes a IE bug where hiding a li element which
//	is not the last li element messes up the tab display.
//	Tab3 hides li elements in sequence, beginning from
//	the last li element and re-creates the tab labels.


(function() {

	'use strict';

//	util.namespace('util');

	util.Tabs3 = function(ulContainer, allTabIds, tabEvent) {

		// 'ulContainer' is the elementId of the tab element

		// 'allTabIds' is a simple array with all tab Id's (not element Id's!), i.e.:
		// ['graphs', 'graph_options', 'table']
		// The element Id's for the list elements are created here. We also read the labels and
		// save them within a new tabs object, because we need the labels if we change the tab sequence.
		// tabs must contain all possible tabs, respectively as they exist in the ul element, in the right order.
		// The tabs can later be set by setSequence to any number or order of the given tabs.

		// We create a tab object to handle the tabs, which looks as follows:

		// The tabsDb contains all tabs identified by ID ...

//		tabsDb = {
//			graphs: {
//				label: 'Graphs'
//				currentTabIndex: 0
//			},
//
//			graph_options: {
//				label: 'Graph Options'
//				currentTabIndex: 0
//
//			}
//			...
//		}


		// The tab li elements become an ID with tabIndex (0,1,2,...) in combination with an idPrefix, i.e.:
		// ue_id:0
		// ue_id:1

		var idPrefix = util.getUniqueElementId();
		var tabsDb = {};

		this.idPrefix = idPrefix;
		this.allTabIds = allTabIds;
		this.tabEvent = tabEvent;
		this.selectedTabIndex = -1; // 0, 1, 2, ... refers to the tab array position
		this.tabSequence = []; // initialized upon setSequence() , i.e. ['graphs', 'table'] will only show the graphs and table tab

		var ul = util.getE(ulContainer);
		var liElements = ul.getElementsByTagName('li');

		// init the tabs
		for (var i = 0; i < allTabIds.length; i++) {

			var tabId = allTabIds[i];
			var elementId = idPrefix + ':' + i;
			var li = liElements[i];
			li.id = elementId;

			var a = li.firstChild;
			var aText = a.firstChild;
			var label = aText.nodeValue;
			// alert('tab label: ' + label);

			tabsDb[tabId] = {label: label};
			// tabsDb[tabId]['currentTabIndex'] = -0;

			YAHOO.util.Event.addListener(li, 'click', this.tabActivated, this);
			//YAHOO.util.Event.addListener(li, 'mouseover', this.hoverOn);
			//YAHOO.util.Event.addListener(li, 'mouseout', this.hoverOff);
		}

		this.tabsDb = tabsDb;
		// util.Tabs3SelfReferences[idPrefix] = this;
	};


	util.Tabs3.prototype = {


		tabActivated: function(evt, self) {

			// Activates the tab function defined in this.tabEvent, which
			// is a function in the module of the tabs object.
			// We return the tabId as argument

			// alert('tabActivated() - this.id: ' + this.id);

			var elementId = this.id;

            //console.log('tabActivated - elementId: ' + elementId);

			var dat = elementId.split(':');
			var idPrefix = dat[0];
			var tabIndex = parseInt(dat[1], 10);

			// alert('tabIndex: ' + tabIndex);

			// var self = util.Tabs3SelfReferences[idPrefix];
			var tabSequence = self.tabSequence;
			var tabId = tabSequence[tabIndex];

            //console.log('tabActivated - tabId: ' + tabId);

			// alert('tabActivated() - tabId: ' + tabId);

			self.tabEvent(tabId);
		},

		setSequence: function(tabSequence, setToTabId) {

			// alert('setSequence()');

			var idPrefix = this.idPrefix;
			var allTabIds = this.allTabIds;
			var tabsDb = this.tabsDb;
			var i;

			var newSelectedTabIndex = -1;

			for (i = 0; i < tabSequence.length; i++) {

				var tabId = tabSequence[i];
				var tabElementId = idPrefix + ':' + i;
				var tabLi = util.getE(tabElementId);
				var tabAnchor = tabLi.firstChild;
				var existingTextNode = tabAnchor.firstChild;
				var newTextNode = document.createTextNode(tabsDb[tabId].label);
				tabAnchor.replaceChild(newTextNode, existingTextNode);

				// display the tab
				if (tabLi.style.display === 'none') {
					// alert('Set style.display of tab index: ' + i);
					tabLi.style.display = '';
				}

				// get the index of the activeTabId

				if (tabId === setToTabId) {
					newSelectedTabIndex = i;
				}
			}

			if (tabSequence.length < allTabIds.length) {

				// hide all further tab elements
				for (i = tabSequence.length; i < allTabIds.length; i++) {
					util.hideE(idPrefix + ':' + i);
				}
			}

			if (newSelectedTabIndex > -1) {
				// make the tab active
				this.setActiveTabByIndex(newSelectedTabIndex);

			}
			/*
			else {
				// There is some mismatch with setToTabId
				alert('Tabs3.setSquence - invalid setToTabId: ' + setToTabId);
			}
			*/

			this.tabSequence = tabSequence;
		},

		setActiveTab: function(tabId) {

			// Get the index of the tabId and then set the tab by setActiveTabByIndex()

			//console.log('setActiveTab - tabId: ' + tabId);

			var tabSequence = this.tabSequence;
			for (var i = 0; i < tabSequence.length; i++) {
				if (tabId === tabSequence[i]) {
					this.setActiveTabByIndex(i);
					break;
				}
			}
		},

		setActiveTabByIndex: function(newTabIndex) {

			// Only set the tab if it is not already active

            //console.log('setActiveTabByIndex()');

			var selectedTabIndex = this.selectedTabIndex;

			if (selectedTabIndex !== newTabIndex) {

				// If the tab isn't already selected

				var idPrefix = this.idPrefix;
				// var tabElementIds = this.tabElementIds;

				var li;
				var a;

				if (selectedTabIndex !== -1) {

					// Reset selected tab
                    //console.log('setActiveTabByIndex() - Re-enable selected tab');

					// alert('Tabs3 class - Reset selected tab');
					li = util.getE(idPrefix + ':' + selectedTabIndex);
					a = li.firstChild;
					li.className = '';
					a.className = '';

                    // KHP 2015/01/21 - Disabled add/remove event listener,
                    // this is not required.
					//YAHOO.util.Event.addListener(li, 'click', this.tabEvent);
					//YAHOO.util.Event.addListener(li, 'mouseover', this.hoverOn);
					//YAHOO.util.Event.addListener(li, 'mouseout', this.hoverOff);
				}

				// Select tab of newTabIndex

				// alert('Tabs2 class - Select tab of given tabElementId: ' + tabElementId);

				li = util.getE(idPrefix + ':' + newTabIndex);
				a = li.firstChild;
				li.className = 'active';
				a.className = 'active';

				//YAHOO.util.Event.removeListener(li, 'click', this.tabEvent);
				//YAHOO.util.Event.removeListener(li, 'mouseover', this.hoverOn);
				//YAHOO.util.Event.removeListener(li, 'mouseout', this.hoverOff);

				// remove focus
				a.blur();

                //console.log('setActiveTabByIndex() - selectedTabIndex: ' + selectedTabIndex);

				this.selectedTabIndex = newTabIndex;
			}
		}

		//hoverOn: function() {
        //
		//	var li = this;
		//	var a = li.firstChild;
		//	li.className = 'hover';
		//	a.className = 'hover';
		//},
        //
		//hoverOff: function() {
        //
		//	var li = this;
		//	var a = li.firstChild;
		//	li.className = '';
		//	a.className = '';
		//}
	};

}());