/* global
	langVar: false,
	util: false,
	YAHOO: false */



//
//	Validator class
//

(function() {

	'use strict';

//	util.namespace('util');

	// Note, we must always return the form value, even if the item is already logged, so that
	// the callee object always gets a value, or simply don't return something?

	util.Validator = function() {

		this.errorLog = [];
	};

	util.Validator.prototype = {

		reset: function() {

			// remove all error messages and clear the error log

			var errorLog = this.errorLog;

			for (var i = 0; i < errorLog.length; i++) {
				var elementId = errorLog[i].elementId + ':error';
				var element = document.getElementById(elementId);
				if (element) {
					util.hideE(elementId);
				}
			}

			this.errorLog = [];
		},

		resetElement: function(e, validatorObj) {

			// alert('reset element of elementId: ' + this.id + '\nerrorLog: ' + validatorObj);

			var elementId = this.id;

			var formElement = document.getElementById(elementId);
			var errorElement = document.getElementById(elementId + ':error');

			// remove the event listener from form element
			if (formElement) {
				YAHOO.util.Event.removeListener(formElement,'click', validatorObj.resetElement);
			}

			// hide error message
			if (errorElement) {
				util.hideE(elementId + ':error');
			}

			// remove elementId in error log
			// util.deleteArrayObject(this.errorLog, 'elementId', elementId);
			util.deleteArrayObject(validatorObj.errorLog, 'elementId', elementId);
		},

		allValid: function() {

			// checks the errorLog for errors and if there is
			// any error it displays them

			var errorLog = this.errorLog;

			if (errorLog.length > 0) {

				for (var i = 0; i < errorLog.length; i++) {

					// util.showObject(errorLog[i]);

					// var formElement = document.getElementById(errorLog[i].elementId);
					var errorElement = document.getElementById(errorLog[i].elementId + ':error');

					// alert(formElement + '\n' + errorElement);

					// if (formElement && errorElement) {
					if (errorElement) {
						// alert('write and show error');
						// write error message to ':error' element container
						util.updateT(errorLog[i].elementId + ':error', errorLog[i].msg);
						util.showE(errorLog[i].elementId + ':error');
					}
				}

				return false;
			}

			return true;
		},

		getIsLogged: function(elementId) {

			// This returns true if the elementId is already logged in this.errorLog

			var isLogged = false;
			var errorLog = this.errorLog;

			for (var i = 0; i < errorLog.length; i++) {

				if (errorLog[i].elementId === elementId) {
					isLogged = true;
					break;
				}
			}

			return isLogged;
		},

		logInvalidElementValue: function(elementId, msg) {

			// add element and type to error log
			var errorLog = this.errorLog;
			errorLog[errorLog.length] = {elementId:elementId, msg: msg};


			// Add event which will hide the error message upon element click
			// Note, 'isCustom' might not have an element, hence check for the element

			var element = util.getE(elementId);

			// alert(' Set error element: ' + element);

			if (element) {

				// alert('add eventListener to: ' + elementId);

				// We need to add the Validator object in the Listener so that we
				// get an object reference in resetElement()
				YAHOO.util.Event.addListener(element,'click', this.resetElement, this);
			}

			// alert('added item to error log, new length: ' + this.errorLog.length);
		},

		isValue: function(elementId, /* optional */ trimFormValue) {

			// Checks the form element to be not empty.

			// Set default trimFormValue if undefined
			if (typeof trimFormValue === 'undefined') {
				trimFormValue = true;
			}

			var theValue = util.getF(elementId, trimFormValue);

			// If this element hasn't been validated yet
			if (!this.getIsLogged(elementId) && (theValue === '')) {

				var msg = langVar('lang_stats.form_validation.no_value');
				this.logInvalidElementValue(elementId, msg);
			}

			return theValue;
		},

		isUnique: function(elementId, lookupItems, /* optional */ convertToLowercase, /* optional */ trimFormValue) {

			// We check if the value of elementId exists in the lookupItems array

			// Set default convertToLowercase if undefined
			if (typeof convertToLowercase === 'undefined') {
				convertToLowercase = false;
			}

			// Set default trimFormValue if undefined
			if (typeof trimFormValue === 'undefined') {
				trimFormValue = true;
			}

			var theValue = util.getF(elementId, trimFormValue);

			// If this element hasn't been validated yet
			if (!this.getIsLogged(elementId)) {

				var isDuplicateItemValue = false;
				var s = !convertToLowercase ? theValue : theValue.toLowerCase();

				for (var i = 0; i < lookupItems.length; i++) {

					var lookupItemValue = lookupItems[i];
					if (convertToLowercase) {
						lookupItemValue = lookupItemValue.toLowerCase();
					}

					if (s === lookupItemValue) {
						isDuplicateItemValue = true;
						break;
					}
				}

				if (isDuplicateItemValue) {
					var msg = langVar('lang_stats.form_validation.duplicat_name');
					this.logInvalidElementValue(elementId, msg);
				}
			}

			return theValue;
		},

		isInteger: function(elementId, /* optional */ min, /* optional */ max) {

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId) && !util.isInteger(theValue, min, max)) {

				var minDefined = !util.isUndefined(min);
				var maxDefined = !util.isUndefined(max);
				var msg = '';

				if (minDefined && maxDefined) {
					msg = langVar('lang_stats.form_validation.invalid_integer_min_max');
					msg = msg.replace(/__PARAM__1/, min);
					msg = msg.replace(/__PARAM__2/, max);
				}
				else if (minDefined) {
					msg = langVar('lang_stats.form_validation.invalid_integer_min');
					msg = msg.replace(/__PARAM__1/, min);
				}
				else if (maxDefined) {
					msg = langVar('lang_stats.form_validation.invalid_integer_max');
					msg = msg.replace(/__PARAM__1/, max);
				}
				else {
					msg = langVar('lang_stats.form_validation.invalid_integer');
				}

				this.logInvalidElementValue(elementId, msg);
			}

			return theValue;
		},

		isFloat: function(elementId, /* optional */ min, /* optional */ max) {

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId) && !util.isFloat(theValue, min, max)) {

				var msg = '';
				var minDefined = !util.isUndefined(min);
				var maxDefined = !util.isUndefined(max);

				if (minDefined && maxDefined) {
					msg = langVar('lang_stats.form_validation.invalid_float_min_max');
					msg = msg.replace(/__PARAM__1/, min);
					msg = msg.replace(/__PARAM__2/, max);
				}
				else if (minDefined) {
					msg = langVar('lang_stats.form_validation.invalid_float_min');
					msg = msg.replace(/__PARAM__1/, min);
				}
				else if (maxDefined) {
					msg = langVar('lang_stats.form_validation.invalid_float_max');
					msg = msg.replace(/__PARAM__1/, max);
				}
				else {
					msg = langVar('lang_stats.form_validation.invalid_float');
				}

				this.logInvalidElementValue(elementId, msg);
			}

			return theValue;
		},

		isNumber: function(elementId, /* optional */ min, /* optional */ max) {

			// This checks for any number (int or float)

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId) && !util.isInteger(theValue, min, max) && !util.isFloat(theValue, min, max)) {

				var msg = langVar('lang_stats.form_validation.invalid_number');
				this.logInvalidElementValue(elementId, msg);
			}

			return theValue;
		},

		isRegularExpression: function(elementId) {

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId) && !util.isRegularExpression(theValue)) {

				var msg = langVar('lang_stats.form_validation.invalid_regular_expression');
				this.logInvalidElementValue(elementId, msg);
			}

			return theValue;
		},

		isEmailAddress: function(elementId) {

			// This validates a single email address

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId) && !util.isEmailAddress(theValue)) {

				var msg = langVar('lang_stats.form_validation.invalid_email_address');
				this.logInvalidElementValue(elementId, msg);
			}

			return theValue;
		},

		isEmailAddresses: function(elementId) {

			// This validates a single email address or multiple email addresses separated by a comma.

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId)) {

				var isValidEmailAddress = true;

				if (theValue.indexOf(',') === -1) {
					// single email address
					isValidEmailAddress = util.isEmailAddress(theValue);
				}
				else {
					// multiple email addresses
					var emailAddressesDat = theValue.split(',');
					for (var i = 0; i < emailAddressesDat.length; i++) {
						var emailAddress = util.trim(emailAddressesDat[i]);
						if (!util.isEmailAddress(emailAddress)) {
							isValidEmailAddress = false;
							break;
						}
					}
				}

				if (!isValidEmailAddress) {
					var msg = langVar('lang_stats.form_validation.invalid_email_addresses');
					this.logInvalidElementValue(elementId, msg);
				}
			}

			return theValue;
		},

		isNodeName: function(elementId) {

			// checks to be a valid node name

			var theValue = util.getF(elementId);

			if (!this.getIsLogged(elementId)) {

				var pattern = /[^_a-z0-9]/;

				if (pattern.test(theValue)) {
					var msg = langVar('lang_stats.form_validation.invalid_identifier');
					this.logInvalidElementValue(elementId, msg);
				}
			}

			return theValue;
		},


		isCustom: function(elementId, msg) {

			// This does not require validation, it simply throws a custom error message
			// and does not return a form value.

			if (!this.getIsLogged(elementId)) {
				this.logInvalidElementValue(elementId, msg);
			}
		}
	};

}());