//
// configHome
//

// This is the configHome namespace
var configHome = function() {
	
	// var YE = YAHOO.util.Event;
	
	//
	// Private properties and methods
	//
	
	// var updateDatabaseBtn = null;
	// var buildDatabaseBtn = null;
	// var showProfileInfoBtn = null;
	var simpleProgress = null;
	
	var profileInfoPanel = null;
	var isOpenprofileInfoPanel = false;
	// var isUpdateDbPermission = false;
	// var isBuildDbPermission = false;
	
	// active profile and database info variables
	var isRealTimeProcessing = false;
	var isActiveSnaponOperation = false;
	var databaseIsBuilding = false;
	var initialBuildDone = false;
	var databaseIsReadyForReporting = false;
	
	var lastProfileInfoTime = -1; // the time profile and database info variables have been updated
	
	function init() {
		
		if (!pageInfo.exitActive) {
			
			// Init help
			util.helpWindow.init('');
			
			var commandLinkOptions = {
				classNameEnabled: 'config-home-nav',
				classNameDisabled: 'config-home-nav-disabled'
			};
			
			// defaultOperation is defined in the URL with shortcut 'dop'. This shortcut is used when calling Update Database,
			// Build Database or Show Profile and Database Info from a non-config-home-page, so config-home becomes loaded
			// but mut also initiate one of the above actions by default.
			
			var defaultOperation = pageInfo.defaultOperation; 
			// alert('defaultOperation: ' + defaultOperation);
			
			// updateDatabaseBtn = new util.CommandLink('config_home:update_database:btn', prepareUpdateDatabase, true, commandLinkOptions);
			// buildDatabaseBtn = new util.CommandLink('config_home:build_database:btn', prepareBuildDatabase, true, commandLinkOptions);
			// showProfileInfoBtn = new util.CommandLink('config_home:show_profile_info:btn', showProfileInfo, true, commandLinkOptions);
			
			// init simple progress
			simpleProgress = new util.SimpleProgressPanel();
			
			// init progress.js
			
			progress.init({
				decimalDivider: pageInfo.decimalDivider,
				isCancelTaskPermission: pageInfo.permissions.isCancelTask,
				profileName: pageInfo.profileName,
				calleeListener: configHome.progressListener,
				isPanel: true
			});
			
			
			if (defaultOperation != '') {
				
				// Make sure that this is no reload or a history action
				// by checking for the exec_db_operation=yes cookie. If this cookie
				// does not anymore exist, respectively if the name/value is not 'exec_db_operation=yes'
				// then we don't execute the default operation because it has already been executed once.
				
				var allCookies = document.cookie;
				var execDbOperation = (allCookies.indexOf('exec_db_operation=yes') != -1);
				
				if (execDbOperation) {
					
					// Reset the cookie and execute the default operation
					document.cookie = 'exec_db_operation=no';
			
					if (defaultOperation == 'ud') {
						prepareUpdateDatabase();
					}
					else if (defaultOperation == 'bd') {
						prepareBuildDatabase();
					}
					else if (defaultOperation == 'dbinfo') {
						showProfileInfo();
					}
				}
			}
		}
	}
	
	function openProfileInfoPanel() {
		
		if (profileInfoPanel == null) {
			
			// Init profileInfoPanel panel
			var panelObj = {
				panelId: 'config_home:profile_info:panel',
				panelClassName: 'panel-30',
				panelHeaderLabel: langVar('lang_admin.config_home.profile_and_database_info'),
				zIndex: 20,
				top: 100,
				left: 240,
				// isCover: true,
				closeEvent: configHome.closeProfileInfoPanel
			};
			
			profileInfoPanel = new util.Panel3(panelObj);
		}
		
		profileInfoPanel.open();
		isOpenprofileInfoPanel = true;
		
		// Update Show Proifle and Database Info button text
		util.updateT('product_bar:show_profile_info:byn_label', langVar('lang_admin.config_home.refresh_profile_and_database_info'));
	}
	
	function closeProfileInfoPanel() {
		
		profileInfoPanel.close();
		isOpenprofileInfoPanel = false;
		
		// Update Show Proifle and Database Info button text
		util.updateT('product_bar:show_profile_info:byn_label', langVar('lang_admin.config_home.show_profile_and_database_info'));
		
		// Hide progress, if any
		progress.close();
	}
	
	function getProfileInfoData(responseInfo) {
		
		// responseInfo is '' | 'updateDatabase' || 'buildDatabase'
		// responseInfo is send to the server and received with the response.
		// If the responseInfo is updateDatabase or buildDatabase then we proceed with updateDatabase or buildDatabase in the response.
		
		var responseInfo = responseInfo || '';
				
		var url = '?dp=config_pages.config_home.get_database_info_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.response_info=' + responseInfo;
		
		util.serverPost(url, dat);
	}
	
	function getProfileInfoDataResponse(dat) {
		
		if (!pageInfo.exitActive) {
		
			// util.showObject(dat);
			
			// Update main variables
			
			var d = new Date();
			lastProfileInfoTime = d.getTime();
					
			isRealTimeProcessing = dat.isRealTimeProcessing;
			isActiveSnaponOperation = dat.isActiveSnaponOperation;
			databaseIsBuilding = dat.databaseIsBuilding;
			initialBuildDone = dat.initialBuildDone;
			databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
			
			
			var responseInfo = dat.responseInfo;

			updateProfileInfoData(dat);			
			updateProfileInfoDisplay();
			
			//
			//
			// Proceed to updateDatabase or buildDatabase if profileInfo has been requested due a click
			// on Update Database or Build Database.
			// Get realtime mode progress if no responseInfo is active
			//
			//
			
			if (responseInfo == 'updateDatabase') {
				updateDatabase();
			}
			else if (responseInfo == 'buildDatabase') {
				buildDatabase();
			}
			
			
			//
			// Check if we show real time progress
			//
			
			if (isRealTimeProcessing && responseInfo == '') {
				
				// Periodically update profile and database info unless
				// responseInfo is updateDatabase or buildDatabase
				
				setTimeout('configHome.getProfileInfoData()', 3000);
			}
		}
	}
	
	function updateProfileInfoData(dat) {
		
		var isInternalSQL = (dat.dbServerType === 'internal_sql');
		
		util.updateT('config_home:profile_label', dat.profileLabel);
		util.updateT('config_home:log_format', dat.logFormatLabel);
		util.updateT('config_home:real_time_processing', dat.realTimeProcessingLabel);
		
		util.updateT('config_home:db_server_type', dat.dbServerTypeLabel);
		util.updateT('config_home:db_directory', dat.dbDirectory);
		util.updateT('config_home:db_name', dat.dbName);
		
		util.updateT('config_home:db_last_modified', dat.dbLastModified);
		util.updateT('config_home:db_last_operation', dat.dbLastOperation);
		
		util.updateT('config_home:db_earliest_log_entry', dat.dbErliestDateTime);
		util.updateT('config_home:db_latest_log_entry', dat.dbLatestDateTime);
		
		util.showE('config_home:db_directory:tr', isInternalSQL);
		util.showE('config_home:db_name:tr', !isInternalSQL);
	}
	
	function updateProfileInfoDisplay() {
		
		// Called when receiving fresh profile info data but also used to reset the display
		// after Update Database or Build Database
		
		// Update 
	
		//
		// Handle basic database info display
		//

		
		var showDatabaseBuildDetails = !isRealTimeProcessing ? (!databaseIsBuilding && initialBuildDone) : databaseIsReadyForReporting;
		var showNoDatabaseBuildInfo = !isRealTimeProcessing  ? (!databaseIsBuilding && !initialBuildDone) : !databaseIsReadyForReporting;
		
		// var showDatabaseProgress = (!isRealTimeProcessing && databaseIsBuilding);
		
		// Set current operation parameters
		var operationIcon = '';
		var operationLabel = '';
	
		if (isActiveSnaponOperation) {
			
			operationIcon = 'blink';
			operationLabel = langVar('lang_admin.config_home.snapon_active_checking_for_progress');
			
			// Get snapon progress
			showSnaponProgress();
		}
		else if (databaseIsBuilding) {
			
			if (!isRealTimeProcessing) {
				
				operationIcon = 'blink';
				operationLabel = langVar('lang_admin.config_home.database_active_checking_for_progress');
				
				// get database progress
				showDatabaseProgress();
			}
			else {
				
				// real time mode
				operationIcon = 'run';
				operationLabel = langVar('lang_admin.config_home.database_is_building_updating');
			}
		}
		else {
			
			operationIcon = 'stop';
			operationLabel = langVar('lang_admin.config_home.none_no_database_or_snapon_active');
		}
		
		
		util.showE('config_home:profile_info:db_build_details_section', showDatabaseBuildDetails);
		util.showE('config_home:profile_info:db_no_build_info_section', showNoDatabaseBuildInfo);
		setCurrentOperation(operationIcon, operationLabel);
		showLoadingState(false);
	}	
	
	function setCurrentOperation(operationIcon, operationLabel) {
		
		// operationIcon is: stop | blink | run
		
		util.hideE([
			'config_home:progress_animation_stop',
			'config_home:progress_animation_blink',
			'config_home:progress_animation_run'
		]);
		
		if (operationIcon == 'stop') {
			util.showE('config_home:progress_animation_stop');
		}
		else if (operationIcon == 'blink') {
			util.showE('config_home:progress_animation_blink');
		}
		else {
			util.showE('config_home:progress_animation_run');
		}
		
		util.updateT('config_home:current_operation_text', operationLabel);
		util.showE('config_home:profile_info:current_operation_section');
	}
	
	
	
	function prepareUpdateDatabase() {
		
		// toggleDbButtonState(false);
		
		if (getIsUpToDateProfileInfo()) {
			
			updateDatabase();
		}
		else {
			
			// Profile info data are not up to date, get fresh data
			showLoadingState();
			getProfileInfoData('updateDatabase');
		}
	}	
	
	function updateDatabase() {
		
		if (isActiveSnaponOperation) {
			
			// update not allowed
			configHomeUtil.openAlertPanel(langVar('lang_admin.config_home.database_cannot_be_updated_due_active_snapon'));
		}
		else if (databaseIsBuilding) {
			
			// update not allowed
			configHomeUtil.openAlertPanel(langVar('lang_admin.config_home.database_is_already_building_updating'));
		}
		else {
			
			var dbBuildExists = (!isRealTimeProcessing && initialBuildDone) || 
					(isRealTimeProcessing && databaseIsReadyForReporting);
			
			// Show confirm update database panel
			configHomeUtil.openDbOperationPanel('updateDatabase', dbBuildExists);
		}
	}
	
	function prepareBuildDatabase() {
		
		// toggleDbButtonState(false);
		
		if (getIsUpToDateProfileInfo()) {
			
			buildDatabase();
		}
		else {
			// Profile info data are not up to date, get fresh data
			showLoadingState();
			getProfileInfoData('buildDatabase');
		}
	}
	
	function buildDatabase() {
		
		if (isActiveSnaponOperation) {
			
			// update not allowed
			configHomeUtil.openAlertPanel(langVar('lang_admin.config_home.database_cannot_be_build_rebuild_due_active_snapon'));
		}
		else if (!isRealTimeProcessing && databaseIsBuilding) {
			
			// build not allowed
			configHomeUtil.openAlertPanel(langVar('lang_admin.config_home.database_is_already_building_updating'));
		}
		else {
			
			var dbBuildExists = (!isRealTimeProcessing && initialBuildDone) || 
					(isRealTimeProcessing && databaseIsReadyForReporting) || databaseIsBuilding;
			
			// Show confirm build database panel
			configHomeUtil.openDbOperationPanel('buildDatabase', dbBuildExists);
		}
	}
	
	function startUpdateOrBuildDatabase(dbOperationType) {
		
		// Called from configHomeUtil.js, this finally initates update database on the server side
		
		// alert('dbOperationType: ' + dbOperationType);
		
		var isUpdateDb = (dbOperationType == 'updateDatabase');
		
		// alert('isUpdateDb: ' + isUpdateDb);
		
		var operationLabel = isUpdateDb ? langVar('lang_admin.config_home.update_database_started_checking_for_progress') : langVar('lang_admin.config_home.build_database_started_checking_for_progress');
		var urlTemplatePath = isUpdateDb ? 'update_database.start_update_database' : 'build_database.start_build_database';
		
		util.hideE(['config_home:profile_info:db_build_details_section', 'config_home:profile_info:db_no_build_info_section']);
		setCurrentOperation('blink', operationLabel);

		var url = '?dp=' + urlTemplatePath;
		url += '&p=' + pageInfo.profileName;
		
		var dat = 'v.fp.client_response_function=' + 'configHome.startUpdateOrBuildDatabaseResponse';
		
		util.serverPost(url, dat);
	}
	
	function startUpdateOrBuildDatabaseResponse(dat) {
		
		// util.showObject(dat);
		var errorMessage = dat.errorMessage;
			
		if (errorMessage == '') {
			
			// Check for progress
			// alert('get progress');
			showDatabaseProgress(dat.taskId);
		}
		else {
			// show error message
			alert(errorMessage);
		}
		
	}

	function cancelDatabaseOperation() {
		
		// called from configHomeUtil upon cancelling
		// toggleDbButtonState(true);
	}
	
	function getIsUpToDateProfileInfo() {
		
		var d = new Date();
		var profileInfoAge = d.getTime() - lastProfileInfoTime;
		
		// alert('profileInfoAge: ' + profileInfoAge);
		
		// if profileInfoAge > 30 seconds
		if (isOpenprofileInfoPanel && profileInfoAge < 30000) {
			return true;
		}
		
		return false;
	}
	
	//
	// Pogress display
	//
	
	function showSnaponProgress() {
		
		util.hideE('config_home:profile_info:current_operation_section');
		progress.startSnaponProgress();
	}
	
	function showDatabaseProgress(taskId/*optional*/) {
		
		var theTaskId = taskId || '';
		
		util.hideE('config_home:profile_info:current_operation_section');
		progress.startDatabaseProgress(theTaskId);
	}
	
	function progressListener(senderState) {
		
		// This is called from progress
		// alert('progressListener() senderState: ' + senderState);
		
		// ToDo, revise progressListener
		
		progress.close();
		
		// Update profile and database info
		showProfileInfo();
		
		// toggleDbButtonState(true);
	}
	

	function showProfileInfo() {
		
		// Used also upon refresh
		showLoadingState();
		getProfileInfoData();
	}
	
	function showLoadingState(isLoading/*optional*/) {
		
		var isLoading = isLoading != null ? isLoading : true;
		
		if (isLoading) {
			simpleProgress.showLoading();
		}
		else {
			simpleProgress.stop();
			// util.showE('config_home:profile_info');
			openProfileInfoPanel();
		}
	}
	
	/*
	function toggleDbButtonState(isEnabled) {
		
		var isEnabled = isEnabled != null ? isEnabled : true;
		updateDatabaseBtn.enable(isEnabled);
		buildDatabaseBtn.enable(isEnabled);
		showProfileInfoBtn.enable(isEnabled);
	}
	*/
	
	//
	// Return global properties and methods
	//
	
	return {
		init: init,
		closeProfileInfoPanel: closeProfileInfoPanel,
		showProfileInfo: showProfileInfo,
		prepareUpdateDatabase: prepareUpdateDatabase,
		prepareBuildDatabase: prepareBuildDatabase,
		getProfileInfoData: getProfileInfoData,
		getProfileInfoDataResponse: getProfileInfoDataResponse,
		startUpdateOrBuildDatabase: startUpdateOrBuildDatabase,
		startUpdateOrBuildDatabaseResponse: startUpdateOrBuildDatabaseResponse,
		cancelDatabaseOperation: cancelDatabaseOperation,
		progressListener: progressListener
	}
}();
//
// configHomeUtil
//

// This is the configHomeUtil namespace
var configHomeUtil = function() {
	
	var YE = YAHOO.util.Event;
	
	var dbOperationPanel = null;
	var alertPanel = null;
	
	var dbOperationType = '';
	var dbBuildExists = false;
	
	//
	//
	// Db operation panel
	//
	//

	function initDbOperationPanel() {
		
		var panelObj = {
			panelId: 'database_operation:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 40,
			isCover: true,
			// isSticky: true,
			closeEvent: configHomeUtil.cancelDbOperation
		};
		
		dbOperationPanel = new util.Panel3(panelObj);
		
		YE.addListener('database_operation:yes_btn', 'click', startDbOperation);
		YE.addListener('database_operation:no_btn', 'click', cancelDbOperation);
	}
	
	function openDbOperationPanel(dbOperationTypeArg, dbBuildExistsArg) {
		
		// dbOperationType is: updateDatabase | buildDatabase
		
		var panelLabel = '';
				
		dbOperationType = dbOperationTypeArg;		
		dbBuildExists = dbBuildExistsArg;
		
		var isUpdateDb = (dbOperationType == 'updateDatabase');
		
		if (!dbOperationPanel) {
		 	initDbOperationPanel();
		}
		
		// Handle text info and buttons
		
		util.hideE(['database_operation:update_db:db_build_exists',
				'database_operation:update_db:no_db_build_exists',
				'database_operation:build_db:db_build_exists',
				'database_operation:build_db:no_db_build_exists']);
		
		if (isUpdateDb) {
			
			panelLabel = langVar('lang_stats.btn.update_database');
			
			if (dbBuildExists) {
				util.showE('database_operation:update_db:db_build_exists');
			}
			else {
				util.showE('database_operation:update_db:no_db_build_exists');
			}
		}
		else {
			
			if (dbBuildExists) {
				
				panelLabel = langVar('lang_stats.btn.build_rebuild_database');
				util.showE('database_operation:build_db:db_build_exists');
			}
			else {
				
				panelLabel = langVar('lang_stats.btn.build_database');
				util.showE('database_operation:build_db:no_db_build_exists');
			}
		}
		
		// util.updateT('database_operation:start_btn', buttonLabel);
		
		dbOperationPanel.open({label:panelLabel});
	}
	
	function startDbOperation() {
				
		dbOperationPanel.close();
		configHome.startUpdateOrBuildDatabase(dbOperationType);
	}
	
	function cancelDbOperation() {
		dbOperationPanel.close();
		configHome.cancelDatabaseOperation();
	}
	
	
	//
	//
	// Alert panel
	//
	//
	
	function initAlertPanel() {
		
		var panelObj = {
			panelId: 'config_home_alert:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.general.alert'),
			left: 316,
			top: 160,
			zIndex: 20,
			// isCover: true,
			// isSticky: true,
			closeEvent: configHomeUtil.closeAlertPanel
		};
		
		alertPanel = new util.Panel3(panelObj);
		
		YE.addListener('config_home_alert:cancel_btn', 'click', closeAlertPanel);
	}
	
	function openAlertPanel(alertText) {
		
		if (!alertPanel) {
			initAlertPanel();	
		}
		
		util.updateT('config_home_alert:text', alertText);
		
		alertPanel.open();
	}
	
	function closeAlertPanel() {
		
		alertPanel.close();
		
		// Restore button state in callee
		configHome.cancelDatabaseOperation();
	}
	
	
	//
	// Return global properties and methods
	//
	
	return {
		openDbOperationPanel: openDbOperationPanel,
		cancelDbOperation: cancelDbOperation,
		openAlertPanel: openAlertPanel,
		closeAlertPanel: closeAlertPanel
	}
}();
