/* global util: false */
var docs = (function() {
	'use strict';
	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		activeFAQId = '';
	function init() {
		// Assign listeners according active page
		var qs = decodeURIComponent(location.search);
//		console.log('qs: ' + qs);
		if (qs.indexOf('docs.technical_manual') !== -1) {
			// Get active page and open menu group of it
			var dat = qs.split('.');
			var chapterName = dat[2];
			// console.log('chapterName: ' + chapterName);
			var linkId = 'docs_tm:' + chapterName;
			var linkElement = util.getE(linkId);
			if (linkElement !== null) {
				// Set link as active
				linkElement.className = 'active';
				// Expand the the group which contains the linkElement
				var isUlElement = false;
				var ulElement = linkElement;
				while (!isUlElement) {
					ulElement = ulElement.parentNode;
					if (ulElement.nodeName === 'UL') {
						isUlElement = true;
					}
				}
				ulElement.style.display = 'block';
			}
			YE.addListener('docs_technical_manual_sidebar', 'click', toggleMenuGroup);
		}
		else if (qs.indexOf('docs.faq') !== -1) {
			YE.addListener('docs_faq', 'click', toggleFAQ);
		}
	}
	function toggleMenuGroup(evt) {
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
//		console.log('element.nodeName: ' + element.nodeName);
//		console.log('element.id: ' + element.id);
		if (elementId.indexOf('docs_tm_group:') !== -1 ) {
			var listElement = util.getE(elementId + ':ul');
			listElement.style.display = (listElement.style.display === 'none') ? 'block' : 'none';
		}
	}
	function toggleFAQ(evt) {
		var element = evt.target || evt.srcElement;
//		console.log('element.nodeName: ' + element.nodeName);
//		console.log('element.id: ' + element.id);
		if (element.nodeName === 'A' && element.id !== '') {
			var id = element.id;
			if (id === activeFAQId) {
				// Close the open FAQ section
				util.hideE(activeFAQId + ':div');
				activeFAQId = '';
			}
			else {
				// Close open FAQ section
				if (activeFAQId !== '') {
					util.hideE(activeFAQId + ':div');
				}
				// Open new FAQ section
				util.showE(id + ':div');
				activeFAQId = id;
			}
			element.blur();
		}
	}
	return {
		init: init,
		toggleFAQ: toggleFAQ
	}
}());
YAHOO.util.Event.onDOMReady(docs.init);
