//
// matchingFiles
//
// This is the matchingFiles namespace
var matchingFiles = function() {
	var YE = YAHOO.util.Event,
		panel = null,
        initDone = false,
//      isNewProfileWizard = false,
        pageToken = '',
        profileName = '',
        cachedMatchingFilesNodeName = '',
        numberOfBuiltFiles = 0,
        numberOfMatchedFiles = 0,
        filesContainer = null,
        scrollControl = null,
        scrollResetAnim = null;
	function initPanel(panelTop, panelLeft) {
		var panelObj = {
			panelId: 'matching_files:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: langVar('lang_admin.log_source_matching_files.matching_files'),
			top: panelTop,
			left: panelLeft,
			zIndex: 40,
			isCover: false,
			closeEvent: matchingFiles.closePanel
		};
		panel = new util.Panel3(panelObj);
	}
	function init(_pageToken, _profileName) {
		// Note, init() may be called from pages with an integrated matching files list
		// such as in Process Logs.
		pageToken = _pageToken;
		profileName = _profileName;
        var attributes = {
			scroll: {to:[0, 0]}
		};
        filesContainer = util.getE('matching_files:files');
        // Init the scrollControl
        scrollControl = new scrollUtil.Scroller('matching_files:box', 'matching_files:label_and_files', scrollingList);
        // Init scroll animation to reset scroll position to 0
        scrollResetAnim = new YAHOO.util.Scroll('matching_files:box', attributes, 0.1);
		initDone = true;
	}
	function openPanel(_pageToken, _profileName, panelTop, panelLeft) {
		if (!initDone) {
			initPanel(panelTop, panelLeft);
			init(_pageToken, _profileName);
		}
		util.hideE('matching_files:label_and_files');
		util.showE('matching_files:loading');
//		util.showE('matching_files_section');
		util.removeChildElements(filesContainer);
		panel.open();
	}
//	function openPanelFromNewProfileWizard() {
//
//		isNewProfileWizard = true;
//		openPanel();
//	}
	function closePanel() {
		// Note, closePanel may be called from log source or new profile wizard
		if (initDone) {
			panel.close();
		}
	}
	function showFiles(dat) {
        // showFiles is called upon initial load
        // from New Profile Wizard or Log Source
        var files = dat.files,
            numberOfUnloadedFiles = 0,
            indexFrom = 0,
            indexTo = 0;
        // util.showObject(dat);
        cachedMatchingFilesNodeName = dat.cachedMatchingFilesNodeName;
        numberOfBuiltFiles = 0;
        numberOfMatchedFiles = dat.numberOfMatchedFiles;
		// Update the label
        util.updateT('matching_files:label', dat.label);
        // Create files
        addFiles(files, 0);
        // Automatically load more files, if any
//        console.log('showFiles - numberOfMatchedFiles: ' + numberOfMatchedFiles);
//        console.log('showFiles - numberOfBuiltFiles: ' + numberOfBuiltFiles);
        numberOfUnloadedFiles = numberOfMatchedFiles - numberOfBuiltFiles;
//        console.log('showFiles - numberOfUnloadedFiles: ' + numberOfUnloadedFiles);
        if (numberOfUnloadedFiles > 0) {
//            console.log('showFiles - LOAD ADDITIONAL FILES UPON INITIAL LOAD - NO SCROLL EVENT YET! ');
            // Start loading additional files after the first load regardless
            // of scrolling state. Load about the same number of files as already
            // loaded.
            indexFrom = numberOfBuiltFiles;
            if (numberOfUnloadedFiles < (numberOfBuiltFiles + (numberOfBuiltFiles / 2))) {
                // There are less than 1.5x of the already loaded files to load.
                // Load of them all
                indexTo = numberOfMatchedFiles - 1;
            }
            else {
                // Load just the same number of files as already loaded
                indexTo = (numberOfBuiltFiles * 2) - 1;
            }
            getCachedMatchingFiles(indexFrom, indexTo);
        }
		util.hideE('matching_files:loading');
        util.showE('matching_files:label_and_files');
         // Scroll to top
        scrollResetAnim.animate();
	}
    function addFiles(files, indexFrom) {
        // Adds a new div with the given files to the container element.
        // files only contains the loaded files from initial load or when loaded from cache.
        // Note, indexFrom is not really required, it just indicates
        // the start index from where we got the cached files, it is most useful
        // for debugging.
        // Adds files to the container Element
        var numberOfFiles = files.length,
            ul = util.createE('ul', {className: 'matching-files'}),
			li = null,
            fileNameLabel = '',
            fileNameText = null,
            i = 0,
            numberOfLoadedFiles = files.length;
        // Create files
        for (i = 0; i < numberOfFiles; i++) {
            fileNameLabel = files[i];
            // Debug only, this shows the actual file number
            // fileNameLabel = (indexFrom + i) + '. -- ' + fileNameLabel;
            fileNameText = document.createTextNode(fileNameLabel);
            li = util.createE('li');
            util.chainE(ul, li, fileNameText);
        }
        numberOfBuiltFiles = numberOfBuiltFiles + numberOfFiles;
        util.chainE(filesContainer, ul);
    }
    function getCachedMatchingFiles(indexFrom, indexTo) {
//        console.log('getCachedMatchingFiles - indexFrom: ' + indexFrom);
//        console.log('getCachedMatchingFiles - indexTo: ' + indexTo);
        var url = '?dp=util.matching_files.get_cached_matching_files',
            dat = '';
        // Show loading
        util.showE('matching_files:loading');
        dat = 'v.fp.page_token=' + pageToken;
        dat += '&v.fp.profile_name=' + profileName;
        dat += '&v.fp.cached_matching_files_node_name=' + cachedMatchingFilesNodeName;
        dat += '&v.fp.index_from=' + indexFrom;
        dat += '&v.fp.index_to=' + indexTo;
        util.serverPost(url, dat);
    }
    function getCachedMatchingFilesResponse(dat) {
        var indexFrom = dat.indexFrom,
            files = dat.files,
            scrollInfo = {},
            keepLoadingInfoActive = false,
            isValidCachedMatchingFilesNodeName = (dat.cachedMatchingFilesNodeName == cachedMatchingFilesNodeName),
            isValidIndexFrom = (dat.indexFrom == numberOfBuiltFiles),
            errorMsg = '';
        // util.showObject(dat);
        if (isValidCachedMatchingFilesNodeName && isValidIndexFrom) {
            // Add the files
            addFiles(files, indexFrom);
            // Activate the scrollControl if there are more files to load
            if (numberOfBuiltFiles < numberOfMatchedFiles) {
                scrollInfo = scrollControl.getScrollInfo();
                if (scrollInfo.isScrollingDown &&
                    scrollInfo.verticalScrollLevel > 80) {
                    // Load more files right away, simply call scrollingList
                    scrollingList(scrollInfo.verticalScrollLevel);
                    keepLoadingInfoActive = true;
                }
                else {
                    // Wait for scroll event to load more files
                    scrollControl.activate();
                }
            }
            else {
                // No more files to load
                scrollControl.deactivate();
            }
        }
        else {
            // An error occurred although this shouldn't be possible,
            errorMsg = 'Error in matchingFiles.getCachedMatchingFilesResponse().\n';
            errorMsg += 'is valid cachedMatchingFilesNodeName: ' + isValidCachedMatchingFilesNodeName + '\n';
            errorMsg += 'isValidIndexFrom: ' + isValidIndexFrom + '\n';
            alert(errorMsg);
        }
        // Hide loading info
        if (!keepLoadingInfoActive) {
            util.hideE('matching_files:loading');
        }
    }
    function scrollingList(verticalScrollLevel) {
//        console.log('scrollingList - VerticalScrollLevel: ' + verticalScrollLevel);
        // Scrolling down.
        // Get maxFiles depending on numberOfMatchedFiles and
        // verticalScrollLevel.
        var indexFrom = numberOfBuiltFiles,
            indexTo = 0,
            maxFiles = parseInt((numberOfMatchedFiles / 1000) * verticalScrollLevel);
//        console.log('scrollingList() - get files from server maxFiles: ' + maxFiles);
        if (maxFiles <= 0) {
            maxFiles = 10;
        }
        else if (maxFiles > 400) {
            maxFiles = 400;
        }
        indexTo = indexFrom + maxFiles;
        // Don't get more files than numberOfMatchedFiles
        if ((indexTo + 1) > numberOfMatchedFiles) {
            indexTo = numberOfMatchedFiles - 1;
        }
//        console.log('scrollingList() - get files from server indexFrom: ' + indexFrom);
//        console.log('scrollingList() - get files from server indexTo: ' + indexTo);
        getCachedMatchingFiles(indexFrom, indexTo);
    }
	//
	//
	// Return global properties and methods
	//
	//
	return {
		init: init,
		openPanel: openPanel,
//		openPanelFromNewProfileWizard: openPanelFromNewProfileWizard,
		showFiles: showFiles,
		closePanel: closePanel,
        scrollingList: scrollingList,
        getCachedMatchingFilesResponse: getCachedMatchingFilesResponse
	}
}();
//
// processLogs
//
var processLogs = function() {
	var YE = YAHOO.util.Event;
	function init() {
		YE.addListener('process_logs_btn', 'click', processLogs.startProcessLogs);
		// init progress.js
		progress.init({
			// decimalDivider: pageInfo.decimalDivider,
			isCancelTaskPermission: pageInfo.permissions.isCancelTask,
			profileName: pageInfo.profileName,
			calleeListener: processLogs.progressListener,
			isPanel: true
		});
		// Get matching log source files
		var pageToken = pageInfo.pageToken;
		var profileName = pageInfo.profileName;
		// Elements may be disabled upon error!
		util.enableE('process_logs:output_file');
		util.enableE('process_logs_btn');
		matchingFiles.init(pageToken, profileName);
		var url = '?dp=config_pages.process_logs.get_matching_files';
		url += '&p=' + profileName;
		var dat = 'v.fp.page_token=' + pageToken;
		util.serverPost(url, dat);
	}
	function showMatchingFilesResponse(dat) {
		matchingFiles.showFiles(dat);
	}
	function startProcessLogs() {
		var output_file = util.getF('process_logs:output_file');
		util.disableE('process_logs:output_file');
		util.disableE('process_logs_btn');
		util.hideE('process_logs:completed');
		var url = '?dp=templates.config_pages.process_logs.start_process_logs';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.output_file=' + encodeURIComponent(output_file);
		// Start simple progress
		progress.startProgress({
			progressType: 'simple',
			mainLabel: langVar('lang_admin.process_logs.label'),
			updateMainLabel: false,
			mainInfo: langVar('lang_admin.process_logs.process_logs_initiated_please_wait'),
			updateMainInfo: false
		});
		util.serverPost(url, dat);
	}
	function startProcessLogsResponse(dat) {
//		util.showObject(dat);
		var errorMessage = dat.errorMessage;
		if (errorMessage == '') {
			// Start progress
			progress.startProgress({
				progressType: 'process_logs',
				taskId: dat.taskId,
				mainLabel: langVar('lang_admin.process_logs.label'),
				updateMainLabel: false,
				mainInfo: langVar('lang_admin.process_logs.processing_logs'),
				updateMainInfo: false
			});
		}
		else {
			alert(errorMessage);
			progress.close();
			util.enableE('process_logs_btn');
		}
	}
	function progressListener(senderState) {
		// This is called from progress.js
//		util.showObject(senderState, 'progressListener in processLogs.js');
		// getDatabaseInfoData();
		progress.close();
		util.enableE('process_logs:output_file');
		util.enableE('process_logs_btn');
		util.showE('process_logs:completed');
	}
	//
	// Return global properties and methods
	//
	return {
		init: init,
		startProcessLogs: startProcessLogs,
		startProcessLogsResponse: startProcessLogsResponse,
		progressListener: progressListener,
		showMatchingFilesResponse: showMatchingFilesResponse
	}
}();
