//
// snaponParameters namespace
// This handles the snapon parameters forms in
// Config/Snapons and in Admin/Profiles/New Profile Wizard
//
var snaponParameters = function() {
	var YE = YAHOO.util.Event,
		validator = null,
	    elementIdPrefix = '',
	    containerElementId = '',
        nextButtonElementId = '';
        // parametersForm is a reference to the parametersForm, it may contain
	    // forms of multiple snapons when used in the new profile wizard.
	    parametersForm = [],
        sourceItems = {
            logFields: [],
            databaseFields: [],
            reportFields: [],
            reports: [],
            reportGroups: []
        },
        labelLookup = {
            logFields: {},
            databaseFields: {},
            reportFields: {},
            reports: {},
            reportGroups: {}
        },
	    attachedSnaponLabelsLookup = {}, // All attached labels (escaped by leading underscore)
        // conditionTriggersLookup contains the element Id's of elements
        // which have an event handler attached which triggers the evaluation for the parameter
        // where the condition is defined. The value of the Id's is the Id of the parameter where the
        // condition is defined, this Id is used to access an object in parametersWithCondition which
        // contains information about the parameter and its condition to handle it without any further
        // lookup. Two or more trigger element Id's may have a reference to the same
        // object in parametersWithCondition when a condition expression contains more than one parameter,
        // in this case each parameter becomes a trigger to evaluate the condition upon change.
	    conditionTriggersLookup = {},
        // parametersWithCondition contains parameter items which have a condition,
        // each object contains information to handle the condition.
        parametersWithCondition = {},
        // Set currentParametersFormIndex, default must be 0, even if no
        // page is displayed. currentParametersFormIndex is generally handled in the callee
        // and only given when calling getIsValidWizardPage()
        currentParametersFormIndex = 0; // 1st page
    function init(obj) {
        validator = new util.Validator();
        elementIdPrefix = util.getUniqueElementId();
        containerElementId = obj.containerElementId;
        nextButtonElementId = obj.nextButtonElementId;
        // util.showObject(obj.parametersForm);
        // Updates all sourceItems and labels, if any
        parametersForm = obj.parametersForm;
        sourceItems.logFields = obj.logFields;
        sourceItems.databaseFields = obj.databaseFields;
        sourceItems.reportFields = obj.reportFields;
        sourceItems.reports = obj.reports;
        sourceItems.reportGroups = obj.reportGroups;
        attachedSnaponLabelsLookup = obj.attachedSnaponLabelsLookup;
        // parameterConditionActorElements contains the element Id's of elements
        // which have an event handler attached to handle a condition (show/hide a form element).
        // Two or more Id's have a reference to a single condition object in parametersWithCondition
        // which contains information about the parameter of the condition and the associated parameters
        // which fire a event to check if the condition is met or not.
        // Remove any attached events from trigger elements and reset
        // conditionTriggersLookup and parametersWithCondition.
        // util.showObject(conditionTriggersLookup, "init, conditionTriggersLookup object");
        for (var triggerElementId in conditionTriggersLookup) {
            var eventType = conditionTriggersLookup[triggerElementId].eventType;
            YE.removeListener(triggerElementId, eventType);
        }
        conditionTriggersLookup = {};
        parametersWithCondition = {};
        // Reset currentParametersFormIndex to 1st page
        currentParametersFormIndex = 0;
        // Make sure that all labels (parameter_value) are unique
        checkForUniqueDefaultLabels();
        // util.showObject(parametersForm);
        // util.showObject(sourceItems.databaseFields);
        // Create the wizard pages
        buildWizardPages();
        // util.showObject(conditionTriggersLookup, "conditionTriggersLookup");
        // util.showObject(parametersWithCondition, "parametersWithCondition");
        // Initialize formElements based on conditions (show/hide) if there
        // are parameters with a condition
        var elementIdsWithACondition = [];
        var elementIdOfParameterWithCondition;
        var count = 0;
        for (elementIdOfParameterWithCondition in parametersWithCondition) {
            elementIdsWithACondition[count] = elementIdOfParameterWithCondition;
            count += 1;
        }
        if (elementIdsWithACondition.length > 0) {
            evaluateConditions(elementIdsWithACondition);
        }
    }
    //
    //
    // Validate page
    //
    //
    function createBasicLabelLookup(itemsName) {
        // alert('createBasicLabelLookup() - itemsName: ' + itemsName);
        var items = sourceItems[itemsName];
        // util.showObject(items, 'createBasicLabelLookup() - sourceItems');
        // Reset lookupItems so that there are no items from
        // validated wizard pages.
        labelLookup[itemsName] = {};
        var lookup = labelLookup[itemsName];
        // util.showObject(labelLookup[itemsName], 'lookup object right after reset, should be empty!');
        // Add labels to labelLookup
        for (var i = 0, l = items.length; i < l; i++) {
            var label = '_' + items[i].label;
            lookup[label] = true;
        }
        // util.showObject(labelLookup[itemsName], 'generated lookup items');
    }
    function addWizardPageValuesToLabelLookup(lookupCollection) {
        // This adds any label values of any previous wizard pages
        // to labelLookup which is required for the current wizard page validation.
        // The required lookup names are given in lookupCollection.
        for (var i = 0; i < currentParametersFormIndex; i++) {
            var parameters = parametersForm[i].parameters;
            for (var j = 0, l = parameters.length; j < l; j++) {
                var item = parameters[j];
                var validationType = item.validationType;
                var label = '';
                if (validationType == 'field_label') {
                    if (item.isLogFieldLabel && lookupCollection.logFields) {
                        labelLookup['logFields']['_' + item.finalValue] = true;
                    }
                    if (item.isDatabaseFieldLabel && lookupCollection.databaseFields) {
                        labelLookup['databaseFields']['_' + item.finalValue] = true;
                    }
                    if (item.isReportFieldLabel && lookupCollection.reportFields) {
                        labelLookup['reportFields']['_' + item.finalValue] = true;
                    }
                }
                else if (validationType == 'report_label' && lookupCollection.reports) {
                    labelLookup['reports']['_' + item.finalValue] = true;
                }
                else if (validationType == 'report_group_label' && lookupCollection.reportGroups) {
                    labelLookup['reportGroups']['_' + item.finalValue] = true;
                }
            }
        }
    }
    function validateInteger(item, formElementId) {
        var finalValue;
        if (item.min != null && item.max != null) {
            finalValue = validator.isInteger(formElementId, item.min, item.max);
        }
        else if (item.min != null) {
            finalValue = validator.isInteger(formElementId, item.min);
        }
        else if (item.max != null) {
            finalValue = validator.isInteger(formElementId, null, item.max);
        }
        else {
            finalValue = validator.isInteger(formElementId);
        }
        return finalValue;
    }
    function validateFloat(item, formElementId) {
        var finalValue;
        if (item.min != null && item.max != null) {
            finalValue = validator.isNumber(formElementId, item.min, item.max);
        }
        else if (item.min != null) {
            finalValue = validator.isNumber(formElementId, item.min);
        }
        else if (item.max != null) {
            finalValue = validator.isNumber(formElementId, null, item.max);
        }
        else {
            finalValue = validator.isNumber(formElementId);
        }
        return finalValue;
    }
    function getIsValidFieldLabel(item, newLabel) {
        // alert('getIsValidFieldLabel() - newLabel: ' + newLabel);
        // util.showObject(item);
        // util.showObject(labelLookup.databaseFields, 'labelLookup.databaseFields');
        var labelExists = false;
        // Note, we complete the loop for all items because
        // any new label has to be added to all field types within
        // checkLabelFor (log_fields, database_fields and report_fields, if all are given).
        if (item.isLogFieldLabel) {
            if (labelLookup.logFields['_' + newLabel]) {
                labelExists = true;
            }
            else {
                // Add label to lookup anyway
                labelLookup.logFields['_' + newLabel] = true;
            }
        }
        if (item.isDatabaseFieldLabel) {
            if (labelLookup.databaseFields['_' + newLabel]) {
                labelExists = true;
            }
            else {
                // Add label to lookup anyway
                labelLookup.databaseFields['_' + newLabel] = true;
            }
        }
        if (item.isReportFieldLabel) {
            if (labelLookup.reportFields['_' + newLabel]) {
                labelExists = true;
            }
            else {
                // Add label to lookup anyway
                labelLookup.reportFields['_' + newLabel] = true;
            }
        }
        // alert('getIsValidFieldLabel() - newLabel: ' + newLabel + '\nlabelExists: ' + labelExists);
        // return isValidFieldLabel
        return !labelExists;
    }
    function checkWizardPageLabelLookupIntegrity() {
        // This checks if we require to update the labelLookup!
        // Note, the label lookup is updated regular here because we have
        // to check labels against the once which exist in the profile
        // plus any entered label in the snapon wizard. But we also have to
        // make sure that the label_loop does not contain any labels from
        // the next pages (assume we went back from the last wizard page to the first one)
        // and from the current page. Hance we have to re-create a fresh labelLookup
        // object upon each next click in case that any label has to be validated.
        // Get all lookup names once in lookupCollection
        // alert('checkWizardPageLabelLookupIntegrity of page (currentParametersFormIndex): ' + currentParametersFormIndex);
        var parameters = parametersForm[currentParametersFormIndex].parameters;
        var lookupCollection = {};
        var isLookup = false;
        // util.showObject(parameters);
        for (var i = 0, l = parameters.length; i < l; i++) {
            var item = parameters[i];
            var validationType = item.validationType;
            switch (validationType) {
                case 'field_label':
                    if (item.isLogFieldLabel) {
                        lookupCollection['logFields'] = true;
                    }
                    if (item.isDatabaseFieldLabel) {
                        lookupCollection['databaseFields'] = true;
                    }
                    if (item.isReportFieldLabel) {
                        lookupCollection['reportFields'] = true;
                    }
                    isLookup = true;
                    break;
                case 'report_label':
                    lookupCollection['reports'] = true;
                    isLookup = true;
                    break;
                case 'report_group_label':
                    lookupCollection['reportGroups'] = true;
                    isLookup = true;
                    break;
                // We don't require to handle the snapon_label because
                // there is only one snapon label among all wizard pages.
            }
        }
        // alert('isLookup: ' + isLookup);
        // util.showObject(lookupCollection, 'generated lookupCollection');
        if (isLookup) {
            //
            // Create fresh lookup objects
            //
            for (var prop in lookupCollection) {
                createBasicLabelLookup(prop);
            }
            if (currentParametersFormIndex > 0) {
                addWizardPageValuesToLabelLookup(lookupCollection);
            }
        }
    }
    function getIsValidWizardPage(parametersFormIndex) {
        // alert('validateForm()');
        // alert('getIsValidWizardPage() - currentParametersFormIndex: ' + currentParametersFormIndex)
        currentParametersFormIndex = parametersFormIndex;
        validator.reset();
        var parametersFormItem = parametersForm[parametersFormIndex];
        var snaponId = parametersFormItem.snaponId;
        var parameters = parametersFormItem.parameters;
        // util.showObject(parametersFormItem, "getIsValidWizardPage()");
        //
        // Check labelLookup integrity
        //
        checkWizardPageLabelLookupIntegrity();
        // Track duplicate report label and report group label for which
        // we only show a warning message via confirm().
        var duplicateReportLabels = [];
        var duplicateReportGroupLabels = [];
        for (var i = 0, l = parameters.length; i < l; i++) {
            var item = parameters[i];
            var validationType = item.validationType;
            var formElementType = item.formElementType;
            var formElementId = elementIdPrefix + ':' + snaponId + ':' + item.name;
            // Skip validation if parameter has a condition and condition evaluates to false
            var skipValidation = false;
            if (item.hasOwnProperty('condition') &&
                parametersWithCondition[formElementId].conditionValue == false) {
                skipValidation = true;
            }
            if (validationType == '' || formElementType == 'checkbox' || skipValidation) {
                // No validation
                finalValue = util.getF(formElementId);
            }
            else if (validationType == 'string') {
                finalValue = validator.isValue(formElementId);
            }
            else if (validationType == 'int') {
                finalValue = validateInteger(item, formElementId);
            }
            else if (validationType == 'float') {
                finalValue = validateFloat(item, formElementId);
            }
            else {
                // This must be one of the *_label types
                finalValue = validator.isValue(formElementId);
                if (finalValue != '') {
                    if (validationType == 'field_label') {
                        if (!getIsValidFieldLabel(item, finalValue)) {
                            validator.isCustom(formElementId, langVar('lang_admin.snapons.field_already_exists_message'));
                        }
                    }
                    else if (validationType == 'report_label') {
                        if (labelLookup.reports['_' + finalValue] != null) {
                            // Track duplicate label in duplicateReportLabels
                            duplicateReportLabels[duplicateReportLabels.length] = finalValue;
                        }
                        // Add report label to labelLookup
                        labelLookup.reports['_' + finalValue] = true;
                    }
                    else if (validationType == 'report_group_label') {
                        if (labelLookup.reportGroups['_' + finalValue] != null) {
                            // Track duplicate label in duplicateReportGroupLabels
                            duplicateReportGroupLabels[duplicateReportGroupLabels.length] = finalValue;
                        }
                        // Add report group to labelLookup
                        labelLookup.reportGroups['_' + finalValue] = true;
                    }
                    else if (validationType == 'snapon_label') {
                        if (attachedSnaponLabelsLookup['_' + finalValue] != null) {
                            // The label already exists
                            validator.isCustom(formElementId, langVar('lang_admin.snapons.snapon_name_already_exists_message'));
                        }
                    }
                }
            }
            // Save finalValue in parameter item
            item.finalValue = finalValue;
        }
        // util.showObject(parameters);
        if (validator.allValid()) {
            if (duplicateReportLabels.length > 0 || duplicateReportGroupLabels.length > 0) {
                var msg = langVar('lang_admin.snapons.confirm_duplicate_report_or_report_group_label');
                if (confirm(msg)) {
                    return true;
                }
            }
            else {
                return true;
            }
        }
        return false;
    }
    //
    //
    // Verify default labels
    //
    //
    function getUniqueLabel(lookup, label) {
        // Returns a unique label
        var uniqueLabel = label;
        var count = 2;
        while (lookup['_' + uniqueLabel]) {
            uniqueLabel = label + ' ' + count;
            count++;
        }
        return uniqueLabel;
    }
    function checkForUniqueDefaultFieldLabels(parameterItem) {
        var parameterValue = parameterItem.parameterValue;
        // Create a new lookup which contains all field label items.
        var fieldsLookup = {};
        var prop;
        if (parameterItem.isLogFieldLabel) {
            for (prop in labelLookup.logFields) {
                fieldsLookup[prop] = true;
            }
        }
        if (parameterItem.isDatabaseFieldLabel) {
            for (prop in labelLookup.databaseFields) {
                fieldsLookup[prop] = true;
            }
        }
        if (parameterItem.isReportFieldLabel) {
            for (prop in labelLookup.reportFields) {
                fieldsLookup[prop] = true;
            }
        }
        // Check for unique label
        if (fieldsLookup['_' + parameterValue]) {
            var newParameterValue = getUniqueLabel(fieldsLookup, parameterValue);
            // Replace parameterValue with newParameterValue
            parameterItem.parameterValue = newParameterValue;
            // Add newParameterValue to corresponding lookup for the case that there is another field label
            if (parameterItem.isLogFieldLabel) {
                labelLookup.logFields['_' + newParameterValue] = true;
            }
            if (parameterItem.isDatabaseFieldLabel) {
                labelLookup.databaseFields['_' + newParameterValue] = true;
            }
            if (parameterItem.isReportFieldLabel) {
                labelLookup.reportFields['_' + newParameterValue] = true;
            }
        }
    }
    function checkForUniqueDefaultLabels() {
        // This checks/creates default labels for parameters where the validation_type
        // is field_label, report_label or report_group_label. If a label (parameterValue) already exists
        // due multiple attachment then we create a unique label
        // Setup basic label lookup (the labelLookup is later re-created per wizard page,
        // so we can add labels which are created within this function without to worry
        // about final label validation!)
        for (var prop in sourceItems) {
            createBasicLabelLookup(prop);
        }
        // Check all labels in parametersForm
        for (var i = 0, l = parametersForm.length; i < l; i++) {
            var parameters = parametersForm[i].parameters;
            for (var j = 0, numberOfParameters = parameters.length; j < numberOfParameters; j++) {
                var parameterItem = parameters[j];
                var validationType = parameterItem.validationType;
                var parameterValue = parameterItem.parameterValue;
                var newParameterValue;
                if (validationType == 'field_label') {
                    checkForUniqueDefaultFieldLabels(parameterItem);
                }
                else if (validationType == 'report_label') {
                    if (labelLookup.reports['_' + parameterValue]) {
                        newParameterValue = getUniqueLabel(labelLookup.reports, parameterValue);
                        // Replace parameterValue with newParameterValue
                        parameterItem.parameterValue = newParameterValue;
                        // Add newParameterValue to labelLookup for the case that there is another report label
                        labelLookup.reports['_' + newParameterValue] = true;
                    }
                }
                else if (validationType == 'report_group_label') {
                    if (labelLookup.reportGroups['_' + parameterValue]) {
                        newParameterValue = getUniqueLabel(labelLookup.reportGroups, parameterValue);
                        // Replace parameterValue with newParameterValue
                        parameterItem.parameterValue = newParameterValue;
                        // Add newParameterValue to labelLookup for the case that there is another report label
                        labelLookup.reportGroups['_' + newParameterValue] = true;
                    }
                }
            }
        }
    }
    //
    //
    // Define node names for all label parameter values except the snapon label
    //
    //
    function handleLabelParameterNodeNames() {
        function addItemsToNodeNames(itemsName) {
            // util.showObject({itemsName: itemsName}, 'addItemsToNodeNames()');
            var items = sourceItems[itemsName];
            var a = [];
            for (var i = 0, l = items.length; i < l; i++) {
                a[i] = items[i].name;
            }
            nodeNames[itemsName] = a;
        }
        var nodeNames = {}; // Contains arrays for logFields, databaseFields, etc. node name items
        for (var i = 0, l = parametersForm.length; i < l; i++) {
            var parameters = parametersForm[i].parameters;
            for (var j = 0, numberOfParameters = parameters.length; j < numberOfParameters; j++) {
                var parameterItem = parameters[j];
                var validationType = parameterItem.validationType;
                if (validationType == 'field_label' ||
                    validationType == 'report_label' ||
                    validationType == 'report_group_label') {
                    // Get a node name for the label
                    var label = parameterItem.finalValue;
                    var finalNodeName;
                    if (validationType == 'field_label') {
                        // We need to combine all node names from all specified fields
                        var combinedFields = [];
                        if (parameterItem.isLogFieldLabel) {
                            if (!nodeNames.logFields) {
                                addItemsToNodeNames('logFields');
                            }
                            combinedFields = nodeNames.logFields.concat();
                        }
                        if (parameterItem.isDatabaseFieldLabel) {
                            if (!nodeNames.databaseFields) {
                                addItemsToNodeNames('databaseFields');
                                // util.showObject(nodeNames.databaseFields, 'just created nodeNames.databaseFields array');
                            }
                            combinedFields = combinedFields.concat(nodeNames.databaseFields);
                        }
                        if (parameterItem.isReportFieldLabel) {
                            if (!nodeNames.reportFields) {
                                addItemsToNodeNames('reportFields');
                            }
                            combinedFields = combinedFields.concat(nodeNames.reportFields);
                        }
                        // util.showObject(combinedFields, 'combinedFields');
                        finalNodeName = util.labelToUniqueNodeName(label, combinedFields, 'field');
                        //
                        // Add finalNodeName to covered nodeNames array
                        //
                        if (parameterItem.isLogFieldLabel) {
                            nodeNames.logFields[nodeNames.logFields.length] = finalNodeName;
                        }
                        if (parameterItem.isDatabaseFieldLabel) {
                            nodeNames.databaseFields[nodeNames.databaseFields.length] = finalNodeName;
                        }
                        // util.showObject(nodeNames.databaseFields, 'just added new node name "' + finalNodeName + '" to nodeNames.databaseFields array');
                        if (parameterItem.isReportFieldLabel) {
                            nodeNames.reportFields[nodeNames.reportFields.length] = finalNodeName;
                        }
                    }
                    else if (validationType == 'report_label') {
                        if (!nodeNames.reports) {
                            addItemsToNodeNames('reports');
                        }
                        finalNodeName = util.labelToUniqueNodeName(label, nodeNames.reports, 'report');
                        // Add finalNodeName to nodeNames.reports
                        nodeNames.reports[nodeNames.reports.length] = finalNodeName;
                    }
                    else {
                        // report_group_label
                        if (!nodeNames.reportGroups) {
                            addItemsToNodeNames('reportGroups');
                        }
                        finalNodeName = util.labelToUniqueNodeName(label, nodeNames.reportGroups, 'report_group');
                        // Add finalNodeName to nodeNames.reportGroups
                        nodeNames.reportGroups[nodeNames.reportGroups.length] = finalNodeName;
                        // util.showObject(nodeNames.reportGroups, 'nodeNames.reportGroups');
                    }
                    // alert('label: ' + label + '\nfinalNodeName: ' + finalNodeName);
                    // Save finalNodeName in parameterItem
                    parameterItem.finalNodeName = finalNodeName;
                }
            }
        }
    }
    //
    //
    //
    // Parameter condition handling
    //
    //
    //
    function initCondition(snaponId, elementIdOfParameterWithCondition, parameterItem) {
        // elementIdOfParameterWithCondition and parameterItem is the parameter with
        // the condition which we show or hide upon condition evaluation.
        // parameterItem.conditionParameters contains the parameter names
        // which are used in the condition expression and which trigger the
        // evaluation upon a change in the form value.
        // util.showObject(parameterItem, "initCondition()");
        var condition = parameterItem.condition;
        var conditionParameters = util.cloneObject(parameterItem.conditionParameters);
        var conditionParameterItem;
        var conditionParameterName;
        var formElementType;
        var eventType;
        // Create a new object which contains condition details
        var obj = {
            snaponId: snaponId,
            condition: condition,
            conditionParameters: conditionParameters,
            conditionValue: false // The actual result of the condition evaluation, final value is set upon evaluation.
        };
        // Add event to relevant condition parameters
        var triggerElementId = '';
        for (var i = 0; i < conditionParameters.length; i++ ) {
            conditionParameterItem = conditionParameters[i];
            conditionParameterName = conditionParameterItem.name;
            triggerElementId = elementIdPrefix + ':' + snaponId + ':' + conditionParameterName;
            // Add triggerElementId to conditionTriggersLookup.
            // Note, it is possible that one trigger handles multiple
            // parameters/elements. Attach event only once.
            if (!conditionTriggersLookup.hasOwnProperty(triggerElementId)) {
                // Get event type for addListener
                formElementType = conditionParameterItem.formElementType;
                if (formElementType == 'select') {
                    eventType = 'change';
                }
                else if (formElementType == 'text') {
                    eventType = 'keyup';
                }
                else {
                    eventType = 'click';
                }
                conditionTriggersLookup[triggerElementId] = {};
                // Add eventType to lookup because it is required when removing the event upon reset.
                conditionTriggersLookup[triggerElementId].eventType = eventType;
                conditionTriggersLookup[triggerElementId].elementIdsOfParametersWithCondition = {};
                // Attach the event
                YE.addListener(triggerElementId, eventType, handleCondition);
            }
            conditionTriggersLookup[triggerElementId]['elementIdsOfParametersWithCondition'][elementIdOfParameterWithCondition] = true;
        }
        // util.showObject(conditionTriggersLookup, "conditionTriggersLookup");
        // Add the new condition object to parametersWithCondition
        parametersWithCondition[elementIdOfParameterWithCondition] = obj;
    }
    function handleCondition(evt) {
//        alert('handleCondition()');
        var triggerElement = evt.target || evt.srcElement;
        var triggerElementId = triggerElement.id;
        // Evaluate one or more conditions which are associated with the trigger element
        // util.showObject(conditionTriggersLookup, "handleCondition()");
        var elementIdsOfParametersWithCondition = conditionTriggersLookup[triggerElementId].elementIdsOfParametersWithCondition;
        var a = []; // collection of elementId's of parameter items with a condition
        for (var elementId in elementIdsOfParametersWithCondition) {
            a[a.length] = elementId;
        }
        evaluateConditions(a);
    }
    function getParameterConditionDat(itemNumber, elementIdOfParameterWithCondition) {
        // This collects all data so that the condition can be evaluated on server side
        var conditionDetails = parametersWithCondition[elementIdOfParameterWithCondition];
        // util.showObject(conditionDetails, "handleCondition()");
        var snaponId = conditionDetails.snaponId;
        var conditionParameters = conditionDetails.conditionParameters;
        var condition = conditionDetails.condition;
        var parameterName = '';
        var parameterValue = '';
        var elementId = '';
        var path = '&v.fp.conditions.' + itemNumber;
        var dat = path + '.element_id_of_parameter_with_condition=' + encodeURIComponent(elementIdOfParameterWithCondition);
        dat += path + '.condition=' + encodeURIComponent(condition);
        for (var i= 0; i < conditionParameters.length; i++) {
            parameterName = conditionParameters[i].name;
            elementId = elementIdPrefix + ':' + snaponId + ':' + parameterName;
            parameterValue = util.getF(elementId);
            dat += path + '.condition_parameters.' + parameterName + '=' + encodeURIComponent(parameterValue);
        }
        return dat;
    }
    function evaluateConditions(conditionElementIds) {
        // This evaluates the condition of one or more parameter items at form
        // initialization or upon trigger of condition parameters.
        lockFormInput(true);
        // Get profileName,  it is required for RBAC when we call the URL in Config
        var profileName = pageInfo.hasOwnProperty('profileName') ? pageInfo.profileName : '';
        var url = '?dp=util.snapon_parameters.evaluate_param_conditions';
        var dat = 'v.fp.page_token=' + pageInfo.pageToken;
        dat += '&v.fp.profile_name=' + profileName;
        var elementIdOfParameterWithCondition = '';
        var path = '';
        for (var i = 0; i < conditionElementIds.length; i++) {
            elementIdOfParameterWithCondition = conditionElementIds[i];
            dat += getParameterConditionDat(i, elementIdOfParameterWithCondition);
        }
        util.serverPost(url, dat);
    }
    function evaluateConditionsResponse(dat) {
        // util.showObject(dat, "evaluateConditionsResponse()");
        var item;
        var elementIdOfParameterWithCondition = '';
        var conditionDetails;
        var conditionValue = '';
        for (var i = 0; i < dat.length; i++) {
            item = dat[i];
            elementIdOfParameterWithCondition = item.elementIdOfParameterWithCondition;
            conditionValue = item.conditionValue;
            // Get conditionDetails and set actual conditionValue,
            // we require the actual conditionValue upon form validation.
            conditionDetails = parametersWithCondition[elementIdOfParameterWithCondition];
            conditionDetails.conditionValue = conditionValue;
            // Show/hide parameter element
            util.showE(elementIdOfParameterWithCondition + ':tr', conditionValue);
        }
        lockFormInput(false);
    }
    function lockFormInput(isLock) {
        // This locks the form elements while waiting for a condition evaluation response
        // Since we don't know which wizard page is active we disable all form elements
        for (var i = 0; i < parametersForm.length; i++) {
            var snaponId = parametersForm[i].snaponId;
            var parameters = parametersForm[i].parameters;
            // util.showObject(parameters, "lockFormInput()");
            for (var j = 0; j < parameters.length; j++) {
                var elementId = elementIdPrefix + ':' + snaponId + ':' + parameters[j].name;
                util.disableE(elementId, isLock);
            }
        }
        util.disableE(nextButtonElementId, isLock);
    }
    //
    //
    //
    // Build form elements
    //
    //
    //
    function getParameterTextElement(item, elementId) {
        var element = util.createE('input', {id:elementId, type:'text', width:item.formElementWidth + 'px', value:item.parameterValue});
        return element;
    }
    function getParameterSelectElement(item, elementId) {
        // The (--- Select ---) list item ensures that we don't set
        // an invalid default field in case that it does not exist
        // in the fields array.
        var element = util.createE('select', {id:elementId});
        var listItems;
        // Get sourceList
        switch (item.selectOptionsSource) {
            case 'log_fields':
                listItems = sourceItems.logFields;
                break;
            case 'database_fields':
                listItems = sourceItems.databaseFields;
                break;
            case 'report_fields':
                listItems = sourceItems.reportFields;
                break;
            case 'custom_fields':
                listItems = item.customFields;
                break;
        }
        // util.showObject(listItems);
        // Add '--- Select ---' item
        var selectLabel = '--- ' + langVar('lang_stats.btn.select') + ' ---';
        var a = [{name:'', label: selectLabel}];
        util.populateSelect(element, a, 'name', 'label');
        // Add list items
        util.extendSelect(element, listItems, 'name', 'label', item.parameterValue);
        // Set default value'
        // util.setF(element, item.parameterValue);
        return element;
    }
    function getParameterCheckboxElement(item, elementId) {
        // util.showObject(item);
        var div = util.createE('div'); // div is used to return checkbox with label element
        var element = util.createE('input', {id:elementId, type:'checkbox'});
        var label = util.createE('label', {htmlFor:elementId});
        var labelText = util.createT(' ' + item.formElementLabel);
        // Note, parameterValue is a string, hence the 'true' in quotes
        if (item.parameterValue == 'true') {
            element.checked = 'checked';
        }
        util.chainE([div, element, [label, labelText]]);
        return div;
    }
    function getParameterTableRow(formElementId, item) {
        // util.showObject(item);
        var formElementType = item.formElementType;
        // var formElementId = elementIdPrefix + ':' + parameterIndex;
        // Add element ID to tr because we may need to hide it when
        // the parameter is displayed upon a condition.
        var tr = util.createE('tr', {id:formElementId + ':tr'});
        var th = util.createE('th', {whiteSpace:'nowrap'});
        var td = util.createE('td');
        var label = (formElementType != 'checkbox') ? item.formElementLabel + ':' : '';
        var thText = util.createT(label);
        var formElement;
        if (formElementType == 'text') {
            formElement = getParameterTextElement(item, formElementId);
        }
        else if (formElementType == 'select') {
            formElement = getParameterSelectElement(item, formElementId);
        }
        else if (formElementType == 'checkbox') {
            formElement = getParameterCheckboxElement(item, formElementId);
        }
        // Add div element for error handling
        var div = util.createE('div', {id:formElementId + ':error', className:'form-error'});
        util.chainE([tr, [th, thText], [td, formElement, div]]);
        return tr;
    }
    function getWizardPage(parametersFormIndex) {
        // util.showObject(parametersFormItem, 'getWizardPage()');
        // Get a unique elementID which is used for the page div
        // and as prefix for all form elements of this page.
        var parametersFormItem = parametersForm[parametersFormIndex];
        // alert("parametersFormItem.snaponId: " + parametersFormItem.snaponId);
        // var elementIdPrefix = util.getUniqueElementId();
        // Set elementIdPrefix in parametersFormItem
        // parametersFormItem.elementIdPrefix = elementIdPrefix;
        var snaponId = parametersFormItem.snaponId;
        var containerDivId = 'snapon_parameters_page:' + parametersFormIndex;
        var containerDiv = util.createE('div', {id:containerDivId, display:'none'});
        // Add description
        var description = parametersFormItem.description;
        var descriptionDiv = util.createE('div');
        // Add <p> tag to description if it doesn't start with a HTML tag
        if (description.substring(0, 1) != '<') {
            description = '<p>' + description + '</p>';
        }
        descriptionDiv.innerHTML = description;
        // Add parameters form elements
        var parameters = parametersFormItem.parameters;
        var formDiv = util.createE('div', {className:'panel-50-form'});
        var table = util.createE('table', {cellSpacing:0});
        var tbody = util.createE('tbody');
        var tr;
        var parameterItem;
        var formElementId;
        for (var i = 0, l = parameters.length; i < l; i++) {
            parameterItem = parameters[i];
            formElementId = elementIdPrefix + ':' + snaponId + ':' + parameterItem.name;
            tr = getParameterTableRow(formElementId, parameterItem);
            util.chainE(tbody, tr);
            // If parameter item has a condition defined
            // then initialize the condition
            if (parameterItem.hasOwnProperty('condition')) {
                initCondition(snaponId, formElementId, parameterItem);
            }
        }
        util.chainE(formDiv, table, tbody);
        util.chainE([containerDiv, descriptionDiv, formDiv]);
        return containerDiv;
    }
    function buildWizardPages() {
        // Clean form from existing pages
        var form = util.getE(containerElementId);
        util.removeChildElements(form);
        for (var i = 0, l = parametersForm.length; i < l; i++) {
            var div = getWizardPage(i);
            util.chainE(form, div);
        }
    }
	//
	// Return global properties and methods
	//
	return {
		init: init,
        handleLabelParameterNodeNames: handleLabelParameterNodeNames,
        getIsValidWizardPage: getIsValidWizardPage,
        evaluateConditionsResponse: evaluateConditionsResponse
	}
}();
