//
//
// 
// importDataStack (handles the actual import by sending import objects to the server)
//
//
//

var importDataStack = {

	isCancel: false, // is set to true if the user close the Wizard while importing,
					// in this case we stop importing any data
	importIndex: -1, // The import object which is currently handled on server side
	importId: '', // An Id of the current imported item. It is used to save the import data in sessions on the server side
	isErrors: false,
	
	start: function() {
		
		// Reset the importer
		importDataStack.isCancel = false;
		importDataStack.importIndex = -1;
		importDataStack.importId = '';
		importDataUtil.isErrors = false;
		
		// TEMP
		// util.showObject(importData.itemsDat);
		// return false;
		
		// Start importing items
		importDataStack.importItem();
	},
	
	importItem: function() {
		
		var itemsDat = importData.itemsDat;
		var itemIndexOfImportItem = importDataStack.importIndex + 1;
		
		var statuslineText = '&nbsp;';
		
		if (itemIndexOfImportItem < itemsDat.length) {
			
			importDataStack.importIndex = itemIndexOfImportItem;
			
			// If this is a database make sure that the profile
			// had no error upon import.
			
			// Send import item to server
			var importItem = itemsDat[itemIndexOfImportItem];
			var importType = importItem.type; // profile | database | schedules | users
			var theProfile;
			var skipImport = false;
			
			if (importType == 'database') {
				
				theProfile = importItem.reference;
				skipImport = theProfile.isError; // profile has not been imported so we can't import the database!
			}
			
			if (!skipImport) {
			
				// Indicate state
				importDataStack.showImportState(itemIndexOfImportItem, 'importing');
				
				// util.showObject(importItem);
				
				var theDate = new Date();
				var importId = 'import_' + theDate.getTime();
				
				importDataStack.importId = importId;
				
				var url = '?dp=admin_pages.import_data.import_item';
				
				var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
				dat += 'v.fp.import_id=' + importId;
				dat += '&v.fp.import_type=' + importType;
				dat += '&v.fp.item_index_of_import_item=' + itemIndexOfImportItem;
				
				// if (importType == 'profile' || importType == 'database') {
				// KHP 15/Apr/2013 - database is not anymore a separate importType,
				// simply check isImportDatabase property if database becomes imported too.
				if (importType == 'profile') {
					
					// Include profile item data from importData.v7profilesDb
					theProfile = importItem.reference;

					// util.showObject(theProfile);

					var profileLabel = theProfile.label;
					var isImportDatabase = theProfile.isImportDatabase;
					
					// Set v8overridesV7database, it will only have relevance if we override
					// an existing profile
					var v8overridesV7database = false;


					// Check if we delete any existing version 8 database
					if (theProfile.profileExistsInV8 && isImportDatabase) {

						if (theProfile.isMysql) {

							if (theProfile.mysqlDatabaseName == theProfile.newMysqlDatabaseName) {
								v8overridesV7database = true;
							}
						}
						else if (theProfile.isCustomDbDirectory) {

							if (theProfile.databaseDirectory == theProfile.newCustomDatabaseDirectory) {
								v8overridesV7database = true;
							}
						}
					}

					// Set statuslineText

					if (!isImportDatabase) {

						statuslineText = langVar('lang_admin.import.importing_profile');
						statuslineText = statuslineText.replace(/__PARAM__1/, profileLabel);
					}
					else {

						statuslineText = langVar('lang_admin.import.importing_profile_and_database');
						statuslineText = statuslineText.replace(/__PARAM__1/, profileLabel);
					}

					dat += '&v.fp.v7_profile_pathname=' + encodeURIComponent(theProfile.pathname);
					
					dat += '&v.fp.v7_profile_label=' + encodeURIComponent(theProfile.label);
					dat += '&v.fp.profile_exists_in_v8=' + theProfile.profileExistsInV8;
					dat += '&v.fp.existing_v8_profile_name=' + encodeURIComponent(theProfile.existingV8profileName);
					dat += '&v.fp.new_v8_profile_name=' + encodeURIComponent(theProfile.newV8profileName);

					dat += '&v.fp.is_import_database=' + isImportDatabase;
					dat += '&v.fp.v8_overrides_v7_database=' + v8overridesV7database;
					
					dat += '&v.fp.v7_database_pathname=' + encodeURIComponent(theProfile.databaseDirectory);
					
					dat += '&v.fp.is_mysql=' + theProfile.isMysql;
					dat += '&v.fp.v7_mysql_database_name=' + encodeURIComponent(theProfile.mysqlDatabaseName);
					dat += '&v.fp.v8_mysql_database_name=' + encodeURIComponent(theProfile.newMysqlDatabaseName);
					
					dat += '&v.fp.is_custom_database_directory=' + theProfile.isCustomDbDirectory;
					dat += '&v.fp.v8_custom_database_directory=' + encodeURIComponent(theProfile.newCustomDatabaseDirectory);
				}
				else {
					
					dat +=  '&v.fp.v7_lai_pathname=' + encodeURIComponent(importData.pathname);
					
					if (importType == 'schedules') {
						statuslineText = langVar('lang_admin.import.importing_schedules');
					}
					else {
						dat +=  '&v.fp.current_user_username=' + encodeURIComponent(importData.currentUserUsername);
						statuslineText = langVar('lang_admin.import.importing_users');
					}
				}
				
				if (!importDataStack.isCancel) {
					util.serverPost(url, dat);
				}
			}
			else {
				
				importDataStack.showImportState(itemIndexOfImportItem, 'skip');
				// Continue with import
				importDataStack.importItem();
			}
		}
		else {
			
			// Import is complete
			// alert('Import complete, all items have been imported');
			statuslineText = !importDataStack.isErrors ? langVar('lang_admin.import.import_completed') : langVar('lang_admin.import.import_completed_with_errors');
			util.updateT('import_data:cancel_btn', langVar('lang_stats.btn.close'));
		}
		
		util.updateT('import_data:final:statusline', statuslineText);
	},
	
	importItemResponse: function(dat) {
		
		var importId = dat.importId;
		
		// alert('importItemResponse() - importId: ' + importId);
		
		// If valid response
		if ((importId == importDataStack.importId) && !importDataStack.isCancel) {
			
			var importType = dat.importType;
			
			if (importType == 'profile') {
				
				// Set new version 8 profile name for eventual later use upon database import
				var itemIndexOfImportItem = dat.itemIndexOfImportItem;
				var itemsDat = importData.itemsDat;
				var importItem = itemsDat[itemIndexOfImportItem];
				var theProfile = importItem.reference;
				theProfile.newV8profileName = dat.newV8profileName;
				
				// util.showObject(theProfile);
				// alert('dat.newV8profileName: ' + dat.newV8profileName);
			}
			
			// Check the importing state.
			// Wait 1.5 sec before checking the state
			setTimeout("importDataStack.getImportingState()", 1500);
		}
	},
	
	getImportingState: function() {
		
		var url = '?dp=admin_pages.import_data.get_importing_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.import_id=' + importDataStack.importId;
		util.serverPost(url, dat);
	},
	
	getImportingStateResponse: function(dat) {
		
		// alert('getImportingStateResponse()');
		
		if ((dat.importId == importDataStack.importId) && !importDataStack.isCancel) {
		
			if (dat.isComplete) {
				
				// Indicate state (complete | complete with error)
				// Note, we need to track any error in itemsDat
				// because if a profile fails then we don't import
				// any database.
				
				var isError = dat.isError;
				
				if (isError) {
					importDataStack.isErrors = true;
				}
				
				var importIndex = importDataStack.importIndex;
				var importItem = importData.itemsDat[importIndex];
				
				if (importItem.type == 'profile') {
					
					var theProfile = importItem.reference;
					theProfile['isError'] = isError;
				}
				
				var importState = isError ? 'error' : 'complete';
				var errorId = dat.errorId;
				
				importDataStack.showImportState(importIndex, importState, errorId);
				// alert('Import item complete. Indicate state');
				
				// Continue to import the next item
				importDataStack.importItem();
			}
			else {
				// Continue checking importing state
				setTimeout("importDataStack.getImportingState()", 1000);
			}
		}
	},
	
	showImportState: function(itemIndexOfImportItem, importState, errorId) {
		
		// errorId is optional!
		
		var importStateText = '';
		var className = '';
		
		switch (importState) {
			
			case 'importing':
			
				importStateText = langVar('lang_admin.import.importing');
				break;
				
			case 'complete':
			
				importStateText = langVar('lang_admin.import.complete');
				break;
				
			case 'error':
				
				importStateText = '<span style="color:Red">' + langVar('lang_admin.import.import_failed') + '</span><br />';
				importStateText += '<a href="?dp=alert&ei=' + errorId + '" target="_blank">' + langVar('lang_admin.import.click_here_to_view_alert') + '</a>';
				// className = 'import-data-error';
				break;
				
			case 'skip':
				importStateText = langVar('lang_admin.import.skipped_due_profile_error');
				className = 'import-data-error';
				break;
		}
		
		var containerElement = util.getE('import_data:final:state:' + itemIndexOfImportItem);
		
		if (className != '') {
			containerElement.className = className;
		}
		
		// util.updateT('import_data:final:state:' + itemIndexOfImportItem, importStateText);
		
		containerElement.innerHTML = importStateText;
	}
};
