/* global profiles: false */

var convertProfile = (function() {

	'use strict';

	var YE = YAHOO.util.Event;
	var panel = null;
	var confirmPanel = null;
	var busyPanel = null;

	var taskId = '';
	var activeProfileName = '';

	function _init() {

		// If not yet initialized
		if (confirmPanel === null) {

			// Create simple progress panel
			busyPanel = new util.BusyPanel();

			// Init the confirm panel
			var panelObj = {
				panelId: 'convert_profiles:panel',
				panelClassName: 'panel-50',
				panelHeaderLabel: langVar('lang_admin.profiles.convert_profiles'),
				left: 80,
				top: 100,
				zIndex: 100,
				isCover: true,
				closeEvent: _cancelProfileConversion
			};

			confirmPanel = new util.Panel3(panelObj);

			YE.addListener('convert_profiles:no_btn', 'click', _cancelProfileConversion);
			YE.addListener('convert_profiles:yes_btn', 'click', _startProfileConversion);
		}
	}

	//
	//
	// Convert v8.0 and 8.1 profiles
	//
	//

	function handleActiveProfileConversion() {

		_init();
		_removeDeleteLinks();

		// This handles an already active profile conversion
		// while the profiles pages has been loaded or reloaded.
		var profileConversionState = pageInfo.profileConversionState;
		taskId = profileConversionState.taskId;
		activeProfileName = profileConversionState.profileName;

		var profileItem = profiles.getProfileItem(activeProfileName);

		var busyPanelText = langVar('lang_admin.profiles.converting_profiles_text') + '<strong>' + profileItem.label + '</strong>';
		busyPanel.showCustom(busyPanelText);

		_checkConvertProfileState(taskId);
	}

	function _getNextProfileNameToConvert() {

		// This gets the next profileName of the profile which has to be converted.

		var profilesDb = profiles.getProfilesDb();
		var profileName = '';

		for (var i = 0, l = profilesDb.length; i < l; i++) {

			var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);

			if (!profileItem.isValidProfile && profileItem.version === '8.0') {
				profileName = profileItem.name;
				break;
			}
		}

		return profileName;
	}

	function confirmProfileConversion() {

		_init();
		confirmPanel.open();
	}

	function _cancelProfileConversion() {

		confirmPanel.close();
	}

	function _startProfileConversion() {

		// Close confirm window
		confirmPanel.close();
		_removeDeleteLinks();

		var profileName = _getNextProfileNameToConvert();
		_convertProfile(profileName);
	}

	function _convertProfile(profileName) {

//		convertProfilesBtn.disable();

//		console.log('_convertProfile() - profileName: ' + profileName);

		// Keep track of the profileName which becomes converted
		activeProfileName = profileName;

		var profileItem = profiles.getProfileItem(activeProfileName);
		var busyPanelText = langVar('lang_admin.profiles.converting_profiles_text') + ' <strong>' + profileItem.label + '</strong>';

		busyPanel.showCustom(busyPanelText);

		var url = '?dp=admin_pages.profiles.convert_profile';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profile_name=' + profileName;

		util.serverPost(url, dat);
	}

	function convertProfileResponse(taskId) {

		// util.showObject(dat);

		// Check task state
		setTimeout(function() {_checkConvertProfileState(taskId)}, 2500);
	}

	function _checkConvertProfileState(taskId) {

		var url = '?dp=admin_pages.profiles.check_convert_profile_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.task_id=' + taskId;

		util.serverPost(url, dat);
	}

	function checkConvertProfileStateResponse(dat) {

		// util.showObject(dat);
		// alert('convertProfileResponse() - taskId: ' + dat.taskId);
		if (dat.isActiveTask) {
			// Recheck task state
			setTimeout(function() {_checkConvertProfileState(taskId)}, 1750);
		}
		else {

			// alert('Task completed.);

			// Mark the active profile as converted by setting version to empty string
			var profilesDb = profiles.getProfilesDb();
			profilesStorage.setProfileArrayItemValues(profilesDb['_' + activeProfileName], {version:''});

			// Continue to convert the next profile, if any
			var nextProfileName = _getNextProfileNameToConvert();

			if (nextProfileName !== '') {

				_convertProfile(nextProfileName);
			}
			else {

				// All profiles converted, get fresh profile data
				var isGetNewChecksum = true;
				activeProfileName = '';
				profiles.getProfileData(isGetNewChecksum);
				busyPanel.stop();
			}
		}
	}

	function _removeDeleteLinks() {

		// This removes the delete links in the profiles list

		var container = util.getE('profiles_profiles_list');
		var aElements = container.getElementsByTagName('a');
		var numberOfElements = aElements.length;

		for (var i = 0; i < numberOfElements; i++) {

			var e = aElements[i];
			// Hide Delete link
			e.style.display = 'none';
		}
	}

	// Return global properties and methods
	return {
		handleActiveProfileConversion: handleActiveProfileConversion,
		confirmProfileConversion: confirmProfileConversion,
		convertProfileResponse: convertProfileResponse,
		checkConvertProfileStateResponse: checkConvertProfileStateResponse
	};
}());



