/* global
	profiles: false
	profilesStorage: false
	profilesDashboard: false
*/

var profilesList = (function() {

	'use strict';

	// This handles the profiles list creation.

	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,

		isRootAdmin = false,
		isViewDashboardPermission = false,
//		isEditProfilesDashboard = false,
		isAdminLike = false,

		activeProfilesDb = [], // Reference to all permitted profiles or filtered profilesDb
		numActiveProfiles = 0,

		dashboardView = null,
		dashboardColumns = [],
		numDashboardColumns = 0,

		dashboardData = [],

		showDbInfo = false,
		showCreatedBy = false,
		// dateTime is used to calculate last updated time ago
		dateTime = 0,

		v7ProfilesListContainer = null,
		profilesListContainer = null,

		isUnloadedDashboardData = false,

		count = 0;

	function init() {

		var permissions = pageInfo.permissions;
		isRootAdmin = pageInfo.isRootAdmin;

		isViewDashboardPermission = (isRootAdmin || permissions.isViewProfilesDashboard || permissions.isViewDatabaseInfoColumn);
		isAdminLike = (isRootAdmin || permissions.isAdd || pageInfo.permissions.isDelete);

//		console.log('isViewDashboardPermission: ' + isViewDashboardPermission);
//		console.log('isAdminLike: ' + isAdminLike);

		v7ProfilesListContainer = util.getE('profiles:v7_profiles_list');
		profilesListContainer = util.getE('profiles_profiles_list');

//		YE.delegate(profilesListContainer, 'mouseover', function(evt, matchedElement, container) {
//			console.log('mouseover: ' + this.nodeName);
//
//		}, 'td');
//
//		YE.delegate(profilesListContainer, 'mouseout', function(evt, matchedElement, container) {
//			console.log('mouseover: ' + this.nodeName);
//
//		}, 'td');
	}

	function clear() {

		// This clears the profile tables
//		util.removeChildElements(v7ProfilesListContainer);
//		util.removeChildElements(profilesListContainer);
		v7ProfilesListContainer.innerHTML = '';
		profilesListContainer.innerHTML = '';
	}

	function create(theProfiles) {

		// This creates a new profiles list, all profiles are assumed to be valid.
		// theProfiles could be all profiles or the profiles
		// from a search result.

//		console.log('theProfiles: ' + theProfiles);
		var isAddPermission = pageInfo.permissions.isAdd;

		// Reset
		isUnloadedDashboardData = false;
		count = 0;
		// Remove scroll listener in case that one has been assigned.
		YE.removeListener(window, 'scroll', _scrollActivated);

		activeProfilesDb = theProfiles;
		numActiveProfiles = activeProfilesDb.length;

		dashboardData = profilesDashboard.getDashboardDataRef();

		dashboardView = pageInfo.profilesDashboardView;
		dashboardColumns = dashboardView.columns;
		numDashboardColumns = dashboardColumns.length;

		showDbInfo = pageInfo.permissions.isViewDatabaseInfoColumn && pageInfo.showDatabaseInfoColumn;

//		console.log('showDbInfo: ' + showDbInfo);

		showCreatedBy = pageInfo.permissions.isViewCreatedByColumn && pageInfo.showCreatedByColumn;
		dateTime = showDbInfo ? (new Date().getTime() / 1000) : 0;

		var table = '<table class="profiles-list">';

		// Always show header row
		table += '<tbody>';
		table += _getHeaderRow();
		table += '</tbody>';

		table += '<tbody>';

		for (var i = 0; i < numActiveProfiles; i++) {

			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);

//			util.showObject(item);
			table += _getRow(isAddPermission, i, item);
		}

		table += '</tbody></table>';

		profilesListContainer.innerHTML = table;

		// Handle unloaded dashboard data
		if (isViewDashboardPermission && isUnloadedDashboardData) {

			YE.addListener(window, 'scroll', _scrollActivated);
		}
	}

	function createWithInvalidProfiles(theProfiles) {

		// This creates a draft profiles list which contains
		// some or only invalid profiles. Invalid v7 profiles must
		// be deleted and invalid v8 profiles must be converted
		// before showing a final profiles list with View Reports
		// and Config links.

		activeProfilesDb = theProfiles;
		numActiveProfiles = activeProfilesDb.length;

		var v7Table = '<table class="profiles-list"><tbody>';
		var table = '<table class="profiles-list">';


//		table += '<tbody>';
//		table += _getHeaderRow();
//		table += '</tbody>';

		table += '<tbody>';

		for (var i = 0; i < numActiveProfiles; i++) {

			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);

//			util.showObject(item);

			// If valid v8 profile without any invalid v8 profiles
			// This is not anymore valid because we don't know upfront
			// if an invalid profile exists or not.
//			if (item.isValidProfile && !invalidV80ProfilesExist) {
//
//				createListEntry(tbody, item);
//			}
			if (item.isValidProfile || item.version === '8.0') {

				// table += _getRow(isAddPermission, i, item);
				table += _getSimpleRow(item);
			}
			else {

				// This must be an invalid version 7.0 profile
				v7Table += _getSimpleRow(item);
			}
		}

		v7Table += '</tbody></table>';
		table += '</tbody></table>';

		v7ProfilesListContainer.innerHTML = v7Table;
		profilesListContainer.innerHTML = table;
	}


	function _getHeaderRow() {

		var row = '<tr>';

		// View Reports cell
//		row += '<th></th>';

		row += '<th class="profile">' + langVar('lang_stats.btn.profiles_reports') + '</th>';

		// Show Options label if user has access to options
		row += '<th class="options"></th>';

		// Add profiles view column labels
		for (var i = 0; i < numDashboardColumns; i++) {

			var colItem = dashboardColumns[i];
			var colLabel = '';

			if (colItem.show_column_label) {

				colLabel = (colItem.column_label !== '') ? colItem.column_label : colItem.report_field_label;
			}

			row += '<th class="rep">' + colLabel + '</th>';
		}

		if (showDbInfo) {
			row += '<th>' + langVar('lang_stats.btn.database_last_modified') + '</th>';
		}

		// Add created by
		if (showCreatedBy) {
			// Username is only shown for other users, hence we don't show a header label
			row += '<th>' + langVar('lang_stats.btn.created_by');
			row += ' <span class="lite">(' + langVar('lang_stats.general.empty_if_me') + ')</span>';
			row += '</th>';
		}

		row += '</tr>';
		return row;
	}

	function _getRow(isAddPermission, rowIndex, item) {

		var profileName = item.name;
		var rowClass= '';
		var theProfileGrants = profilesUtil.getProfileGrants(profileName);

		var row = '<tr id="tr:' + profileName + '"' + rowClass + '>';


		// Add profileLabel
		row += _getProfileLabelCell(theProfileGrants, item);


		// Add Options cell
		row += _getOptionsCell(isAddPermission, theProfileGrants, item);


		// Add dashboard report cells
		if (numDashboardColumns > 0) {

			row += _getDashboardReportCells(profileName);
		}


		// Add dashboard database info
		if (showDbInfo) {


			if (theProfileGrants.viewDatabaseInfoColumn) {
				// If permission
				row += _getDbInfoCell(profileName);
			}
			else {
				// Some or even all profiles may not have permission
				row += '<td class="db-info">(' + langVar('lang_stats.general.no_permission') + ')</td>';
			}
		}

		// Show user name if profile has been created
		// by other user.
		if (showCreatedBy) {

			row += '<td class="db-info">';

			if (theProfileGrants.viewCreatedByColumn) {

				if (item.username !== '') {

	//				var byUserLabel = ' (' + langVar('lang_admin.general.by_user') + ')';
	//				byUserLabel = byUserLabel.replace(/__PARAM__1/, item.username);
	//				row += byUserLabel;
					row += item.username;
				}
				else {

					// Created by myself
					row +=  '&nbsp;';
				}
			}
			else {
				// No permission
				row += '(' + langVar('lang_stats.general.no_permission') + ')';
			}

			'</td>';
		}

		row += '</tr>';

		return row;
	}

	function _getSimpleRow(item) {

		// This creates v7.0 or v8.x (unconverted and converted) rows.
		// They only contain profile name and a delete button.

		var profileName = item.name;
		var theProfileGrants = profilesUtil.getProfileGrants(profileName);

		var row = '<tr id="tr:' + profileName + '">';

		// Fallback to profile node name if label is empty
		var profileLabel = item.label;
		var pattern = /^\s+$/;
		if (profileLabel === '' || pattern.test(profileLabel)) {
			profileLabel = profileName;
		}

		// Add profileLabel
		row += '<td class="profile">' + profileLabel + '</td>';

		// Add state cell
		var info;

		if (item.isValidProfile) {
			info = langVar('lang_admin.profiles.valid_profile');
		}
		else if (item.version === '8.0') {
			info = langVar('lang_admin.profiles.version_80_or_81_profile');
		}
		else {
			info = langVar('lang_admin.profiles.version_7x_profile');
		}

		row += '<td class="info">' + info + '</td>';

		// add Delete link
		if (theProfileGrants.isDelete) {

			var anchorId = 'a:' + profileName + ':delete';

			row += '<td>';
			row += '<a id="' + anchorId + '" class="link-50" href="javascript:;">';
			row += '<span class="ico ico-16 ico-p-delete"></span> ';
			row += langVar('lang_stats.btn.delete');
			row += '</a>';
			row += '</td>';
		}
		else {

			row += '<td>&nbsp;</td>';
		}

		return row;
	}

	function _getDashboardReportCells(profileName) {

		var htmlCell = '';

		var reportCellsCode = dashboardData['_' + profileName].reportCellsCode;
		var reportCells = dashboardData['_' + profileName].reportCells;

//		util.showObject(reportCells);

		for (var i = 0; i < numDashboardColumns; i++) {

			var reportCellItem = reportCells[i];
			var showCell = reportCellItem[0];

			htmlCell += '<td class="rep">';

			if (showCell) {

				if (reportCellsCode === 1) {

					// Loading, this cell possibly has report data
					htmlCell += '<span class="rep">&ndash;</span>';

					isUnloadedDashboardData = true;
				}
				else {

					var label = reportCellItem[1];
					var value = (reportCellsCode === 3) ? reportCellItem[2] : '&ndash;';

					if (label !== '') {
						htmlCell += '<span class="rep">' + label + ':</span>';
					}

					htmlCell += value;
				}
			}
			else {

				// Ignore cell
				htmlCell += '&nbsp;';
			}

			htmlCell += '</td>';
		}

		return htmlCell;
	}


//	function _getDeleteCell(item) {
//
//		return _getIconLinkCell(imgDb.deleteProfile.src, item.name, 'delete', langVar('lang_admin.profiles.delete_profile') + ' "' + item.label + '"', langVar('lang_admin.profiles.delete_profile'));
//	}

	function _getProfileLabelCell(theProfileGrants, item) {

		var profileName = item.name;
		var profileLabel = item.label;

		var cell = '<td class="profile">';

		// Add the View Reports icon
//		cell += '<div class="profile">';

		if (theProfileGrants.isViewReports) {

			var href = '?dp=reports&p=' + profileName;
			var dateFilter = item.df;

			if (dateFilter !== '') {
				href += '&df=' + dateFilter;
			}

			cell += '<a href="' + href + '" class="profile">';
			cell += '<span class="ico ico-16 ico-p-reports" title="' + langVar('lang_stats.btn.view_reports') + '"></span> ';
			cell += '<span class="text">' + profileLabel + '</span>';
			cell += '</a>';
		}
		else {

			cell += '<span class="ico ico-16"></span> ';
			cell += profileLabel;
		}

		cell += '</td>';

		return cell;
	}

	function _getOptionsCell(isAddPermission, theProfileGrants, item) {

		var profileName = item.name;

		var cell = '<td class="options">';

		if (isAddPermission ||
			theProfileGrants.isViewConfig ||
			theProfileGrants.isViewTools ||
			theProfileGrants.isRename ||
			theProfileGrants.isDelete) {

			// Add more options link
			cell += ' <a id="a:' + profileName + ':menu" class="options" href="javascript:;">';
			cell += '<span class="ico ico-16 ico-p-gear"></span> ';
			cell += '<span class="text">' + langVar('lang_stats.btn.options') + '</span>';
			cell += '<span class="ico ico-16 ico-arrow-down-blue"></span> ';
			cell += '</a>';
		}

		cell += '</td>';

		return cell;
	}

//	function _getTextLinkCell(imgSrc, href, label) {
//
//		var cell = '<td>';
//		cell += '<a class="link-80" href="' + href + '">';
//		cell += '<img src="' + imgSrc + '" width="16" height="16" alt="' + label + '" />';
//		cell += '<span>' + label + '</span>';
//		cell += '</a>';
//		cell += '</td>';
//
//		return cell;
//	}

//	function _getIconLinkCell(imgSrc, profileName, operationKeyWord, title, alt) {
//
//		// operationKeyWord is: duplicate | rename | delete
//
//		var anchorId = 'a:' + profileName + ':' + operationKeyWord;
//		var imageId = 'img:' + profileName + ':' + operationKeyWord;
//
//		var cell = '<td>';
//		cell += '<a id="' + anchorId + '" class="link-50" href="#">';
//		cell += '<img id="' + imageId + '" src="' + imgSrc + '" width="16" height="16" title="' + title + '" alt="' + alt + '" />';
//		cell += '</a>';
//		cell += '</td>';
//
//		return cell;
//	}

//	function _getShowHeaderColumn() {
//
//		// Returns true if a column label must be shown
//		for (var i = 0; i < numDashboardColumns; i++) {
//
//			var colItem = dashboardColumns[i];
//			if (colItem.show_column_label) {
//				return true;
//			}
//		}
//
//		return false;
//	}


	function _getDbInfoCell(profileName) {

		var dbInfo = dashboardData['_' + profileName].dbInfo;
		var isLoaded = dbInfo[0];

//		util.showObject(dbInfo);

		var htmlCell = '<td class="db-info">';

		htmlCell += '<a id="a:' + profileName + ':db" href="javascript:;" class="link-80 link-80-lite">';

		if (isLoaded) {

			var dbState = dbInfo[1];
			var lastModifiedAgoInSec = 0;

			if (dbState === 2)  {
				var lastModifiedInEpoc = dbInfo[2];
				lastModifiedAgoInSec = dateTime - lastModifiedInEpoc;
			}

			htmlCell +=_getDbInfoCellSubElements(dbState, lastModifiedAgoInSec);
		}
		else {

			// Loading
			htmlCell += '<span class="ico ico-16 ico-p-db-loading">&nbsp;</span>';
			htmlCell += '<span>&ndash;</span>';

			isUnloadedDashboardData = true;
		}

		htmlCell += '</a>';
		htmlCell += '</td>';

		return htmlCell;
	}

	function updateDbInfoCell(profileName, dbState, lastModifiedInEpoc) {

		// This updates a single database info cell.
		var dbInfoAElement = util.getE('a:' + profileName + ':db');
		var now = new Date().getTime() / 1000;
		var lastModifiedAgoInSec = now - lastModifiedInEpoc;

		dbInfoAElement.innerHTML = _getDbInfoCellSubElements(dbState, lastModifiedAgoInSec);
	}

//	function setReportCellsToChangedDataState(profileName) {
//
//		// This changes report values to a dash. This is usually called
//		// after Update/Build database.
//		var tr = util.getE('tr:' + profileName);
//		// Replace existing cell values with ndash
//		var newText = document.createTextNode('Hello Karl');
//		var tableCells = tr.getElementsByTagName('td');
//		for (var i = 0, len = tableCells.length; i < len; i++) {
//			var td = tableCells[i];
//			if (td.className === 'rep') {
//				var oldText = td.firstChild;
//				td.replaceChild(newText, oldText);
//			}
//		}
//	}

	function _getDbInfoCellSubElements(dbState, lastModifiedAgoInSec) {

		var html = '';

		if (dbState === 2)  {

			// TODO - Refine lastModifiedAgo granularity
			var lastModifiedAgo = 0;

			if (lastModifiedAgoInSec >= 86400) {
				lastModifiedAgo = Math.round(lastModifiedAgoInSec / 86400);
				lastModifiedAgo += (lastModifiedAgo === 1) ? ' day' : ' days';
			}
			else if (lastModifiedAgoInSec >= 3600) {
				lastModifiedAgo = Math.round(lastModifiedAgoInSec / 3600);
				lastModifiedAgo += (lastModifiedAgo === 1) ? ' hour' : ' hours';
			}
			else if (lastModifiedAgoInSec >= 60) {
				lastModifiedAgo = Math.round(lastModifiedAgoInSec / 60);
				lastModifiedAgo += (lastModifiedAgo === 1) ? ' minute' : ' minutes'
			}
			else {
				lastModifiedAgo = '< 1 minute';
			}

			html = '<span class="ico ico-16 ico-p-db-built"></span>&nbsp;<span>' + lastModifiedAgo + ' ago</span>';
		}
		else if (dbState === 1)  {

			html = '<span class="ico ico-16 ico-p-db-loading"></span>&nbsp;<span>' + langVar('lang_stats.database.building') + '</span>';
		}
		else {

			// Not built
			html = '<span class="ico ico-16 ico-p-db-loading"></span>&nbsp;<span>' + langVar('lang_stats.database.not_built') + '</span>';
		}

		html += '<span class="ico ico-16 ico-arrow-down-grey"></span> ';

		return html;
	}


	function _scrollActivated(evt) {

//		console.log('scroll activated');

		// Increment count
		var newCount = count + 1;
		count = newCount;

		setTimeout(function() {_scrollingStopped(newCount);}, 500);
	}

	function _scrollingStopped(newCount) {

		// Check for dashboard data when user stopped scrolling
		if (count === newCount) {

//			util.showObject({count:count});
			_checkDashboardDataForCurrentView();
		}
	}

	function checkDashboardDataForCurrentView() {

		// Called from profiles but with a delay
		// Set some timeout to be sure that the table is displayed
		if (isViewDashboardPermission) {
			setTimeout(function() {_checkDashboardDataForCurrentView()}, 100);
		}
	}

	function _checkDashboardDataForCurrentView() {

		// Checks if profiles of current view require
		// to load dashboard data.

		// Don't check profiles list visibility
		// if there are less than 20 profiles.

//		var scrollTop = YD.getDocumentScrollTop();
//		util.showObject({scrollTop:scrollTop});

//		console.log('_checkDashboardDataForCurrentView()');

		// Set all profiles as default
		var profilesInView = [];
		var firstVisibleProfileIndex = 0;
		var lastVisibleProfileIndex = numActiveProfiles - 1;

		// TODO, revise numActiveProfiles
		if (numActiveProfiles > 30) {

			// clientRegion.top is equal scrollTop!
			var clientRegion = YD.getClientRegion();

//			util.showObject(clientRegion, 'clientRegion');

			var profilesListRegion = YD.getRegion(profilesListContainer);

//			util.showObject(profilesListRegion, 'profilesListRegion');

			var heightPerProfile =  Math.round(profilesListRegion.height / (numActiveProfiles + 1));

			//
			// get firstVisibleProfileIndex
			//

			if (clientRegion.top > profilesListRegion.top) {

				// First visible profile index is most likely greater than 0
				firstVisibleProfileIndex = _getFirstVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile);

				// Make sure we are within the index range
				if (firstVisibleProfileIndex < 0) {
					firstVisibleProfileIndex = 0
				}
				else if (firstVisibleProfileIndex >= numActiveProfiles) {
					firstVisibleProfileIndex = numActiveProfiles - 1;
				}
			}

			//
			// get lastVisibleProfileIndex
			//

			lastVisibleProfileIndex = _getLastVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile);

			// Make sure we are within the index range
			if (lastVisibleProfileIndex >= numActiveProfiles) {
				lastVisibleProfileIndex = numActiveProfiles - 1;
			}
			else if (lastVisibleProfileIndex < 0) {
				lastVisibleProfileIndex = 0;
			}
		}


		// Populate profilesInView
		for (var i = firstVisibleProfileIndex, k = 0; i <= lastVisibleProfileIndex; i++, k++) {

			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			profilesInView[k] = item.name;
		}

//		util.showObject({firstVisibleProfileIndex:firstVisibleProfileIndex});
//		util.showObject({lastVisibleProfileIndex:lastVisibleProfileIndex});

//		util.showObject(profilesInView, 'profilesInView');
//		console.log('profilesInView: ' + profilesInView);

		profilesDashboard.verifyDashboardDataForProfilesInView(profilesInView);
	}


	function _getFirstVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile) {

		// Get approximate hidden rows
		// hiddenHeightTop defines the height of invisible profile rows on top
		var hiddenHeightTop = clientRegion.top - profilesListRegion.top;
		var numHiddenRowsTop = 0;
		if (hiddenHeightTop > heightPerProfile) {
			numHiddenRowsTop = Math.round(hiddenHeightTop / heightPerProfile);
		}

//		util.showObject({numHiddenRowsTop: numHiddenRowsTop});

		// Check if the profile with index of numHiddenRowsTop
		// is actually hidden.
		var isVisible = true;
		var i = numHiddenRowsTop;
		while (isVisible && i >= 0) {

			i = i - 1;

			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			var rowId = 'tr:' + item.name;
			var rowRegion = YD.getRegion(rowId);

			// util.showObject(rowRegion, 'rowRegion');
			isVisible = rowRegion.bottom > clientRegion.top;
		}

		return i + 1;
	}

	function _getLastVisibleProfileIndex(clientRegion, profilesListRegion, heightPerProfile) {

		// hiddenHeightBottom defines the height of invisible profiles on bottom
		var hiddenHeightBottom = profilesListRegion.bottom - clientRegion.bottom;
		var numHiddenRowsBottom = 0;
		if (hiddenHeightBottom > heightPerProfile) {
			numHiddenRowsBottom = Math.round(hiddenHeightBottom / heightPerProfile);
		}

//		util.showObject({numHiddenRowsBottom: numHiddenRowsBottom});

		// Check if the profile with index of numHiddenRowsBottom
		// is actually hidden.


		var lastVisibleProfileIndex = numActiveProfiles - numHiddenRowsBottom - 2;

		var isVisible = true;
		var i = numActiveProfiles - numHiddenRowsBottom - 1;

		if (i < 0) {i = 0;}

		var visibleIndex = i;

		while (isVisible && i < numActiveProfiles) {

			var item = profilesStorage.profileArrayItemToObject(activeProfilesDb[i]);
			var rowId = 'tr:' + item.name;
			var rowRegion = YD.getRegion(rowId);

//			console.log('---');
//			console.log('index: ' + i);
//			console.log('rowRegion.top: ' + rowRegion.top);
//			console.log('clientRegion.bottom: ' + clientRegion.bottom);
//			console.log('---');

			// util.showObject(rowRegion, 'rowRegion');

			isVisible = (rowRegion.top > clientRegion.bottom);

			if (isVisible) {
				visibleIndex++;
			}

			i = i + 1;
		}

		var lastVisibleProfileIndex = i;

//		console.log('numActiveProfiles: ' + numActiveProfiles);
//		console.log('lastVisibleProfileIndex: ' + (i - 2));
//		console.log('visibleIndex: ' + visibleIndex);

		return visibleIndex;
	}

	function editViewActivated() {
		// Remove scroll listener
		YE.removeListener(window, 'scroll', _scrollActivated);
	}

	// Return global properties and methods
	return {
		init: init,
		clear: clear,
		create: create,
		createWithInvalidProfiles: createWithInvalidProfiles,
		checkDashboardDataForCurrentView: checkDashboardDataForCurrentView,
		editViewActivated: editViewActivated,
		updateDbInfoCell: updateDbInfoCell
	};
}());

