/* global
	profiles: false,
	renameProfileDb: false */

var renameProfile = (function() {

	'use strict';
	
	var panel = null;
	var validator = null;
	
	var sourceProfileLabel = '';
	var sourceProfileName = '';
	var existingProfileLabels = [];
	var existingProfileNames = [];
	
	// database data of the source profile
	var receivedDatabaseData = false;
	var databaseServerType = '';
	var databaseName = '';
	var isRealTimeProcessing = false;
	var initialBuildDone = false;
	var databaseIsReadyForReporting = false;

	// new profile data
	var newProfileName = '';
	var newProfileLabel = '';
	
	function init() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId: 'rename_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.rename_profile_title'),
			// left: 100,
			// top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: close
		};
		
		panel = new util.Panel3(panelObj);
		validator = new util.Validator();
		
		YE.addListener('rename_profile:profile_label', 'keyup', setOkButtonState);
		YE.addListener('rename_profile:ok_btn', 'click', renameAndSaveProfile);
		YE.addListener('rename_profile:cancel_btn', 'click', close);
	}
	
	function open(profileName, profileLabel) {
		
		if (panel === null) {
			init();
		}

		var profileInfoText = langVar('lang_admin.profiles.rename_profile_info') + ':';
		profileInfoText = profileInfoText.replace(/__PARAM__1/, profileLabel);
		
		util.updateT('rename_profile:info_text', profileInfoText);
		
		util.setF('rename_profile:profile_label', profileLabel);
		
		// Disable OK button
		util.disableE('rename_profile:ok_btn');
		// util.disableE('rename_profile:cancel_btn');
		
		// Set/reset global data
		sourceProfileLabel = profileLabel;
		sourceProfileName = profileName;
		receivedDatabaseData = false;
		
		// Reset existingProfileLabels and existingProfileNames
		existingProfileLabels = [];
		existingProfileNames = [];
		
		panel.prePositionAtCenter();
		panel.open();
		
		// Get fresh database data of the source profile
		getDatabaseData();
		
		// var inputElement = util.getE('rename_profile:profile_label');
		// inputElement.focus();
	}
	
	function close() {
		
		validator.reset();
		panel.close();
	}
	
	function getDatabaseData() {
		
		var url = '?dp=admin_pages.profiles.rename_get_db_info_data';
		url += '&p=' + sourceProfileName;
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.profile_name=' + sourceProfileName;
		
		util.serverPost(url, dat);
	}
	
	function getDatabaseDataResponse(dat) {

//		util.showObject(dat);
		// Make sure that we got the data for the current profile
		if (dat.profileName === sourceProfileName) {
		
			if (dat.errorMessage === '') {
				
				receivedDatabaseData = true;
				
				// Set database variables for later use
				databaseServerType = dat.databaseServerType;
				databaseName = dat.databaseName;
				isRealTimeProcessing = dat.isRealTimeProcessing;
				databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
				initialBuildDone = dat.initialBuildDone;
				
				// util.enableE('rename_profile:cancel_btn');
			}
			else {
				
				// Show error message and close window
				alert(dat.errorMessage);
				close();
			}
		}
	}

	function setOkButtonState() {
		
		newProfileLabel = util.getF('rename_profile:profile_label');
		var makeEnabled = (newProfileLabel !== '' && (sourceProfileLabel !== newProfileLabel));
		util.enableE('rename_profile:ok_btn', makeEnabled);
	}

	function renameAndSaveProfile() {

		validator.reset();

		if (existingProfileLabels.length === 0) {
			
			// Get existingProfileLabels and existingProfileNames,
			// except for the current profile which becomes deleted upon rename.
			var profilesDb = profiles.getProfilesDb();
			for (var i = 0, len = profilesDb.length; i < len; i++) {

				var profileItem = profilesStorage.profileArrayItemToObject(profilesDb[i]);
				
				if (profileItem.name !== sourceProfileName) {

					existingProfileNames[i] = profileItem.name;
					existingProfileLabels[i] = profileItem.label;
				}
			}
		}
		
		// util.showObject(existingProfileLabels);
		// util.showObject(existingProfileNames);
			
		newProfileLabel = validator.isValue('rename_profile:profile_label');
		newProfileLabel = validator.isUnique('rename_profile:profile_label', existingProfileLabels);
		newProfileName = util.labelToUniqueNodeName(newProfileLabel, existingProfileNames, 'profile');
				
		// alert('newProfileName: ' + newProfileName);
		
		if (validator.allValid()) {
			
			if (newProfileName === sourceProfileName) {
				
				// alert('newProfileName is equal sourceProfileName');
				
				// The profile node name does not change, only the case (i.e. profile1 > PROFILE1) changed,
				// this case doesn't require any database action because we only rename the label of the profile.
				// Proceed with renaming the profile on server side
				renameAndSaveProfileFinal('');
			}
			else {
			
				// If we received up to date database data
				
				if (receivedDatabaseData) {
					
					// Allow to rename the database if it is an external server
					// and if the database is not yet build, else we just show a
					// warning message that the database name has to be modified
					// manually.
					// we 
					// Note, we allow to rename Oracle if no database exists
					
					if (databaseServerType === 'internal_sql') {
						
						// Proceed with renaming the profile on server side
						renameAndSaveProfileFinal('');
					}
					else {
						
						// External database server
						
						if (databaseIsReadyForReporting || initialBuildDone) {
							
							// We don't allow renaming of the external database server
							
							// Show an info that the external database server must be renamed manually
							var externalDbMsg = langVar('lang_admin.profiles.cannot_rename_external_database');
							externalDbMsg = externalDbMsg.replace(/__PARAM__1/, databaseName);
							
							if (confirm(externalDbMsg)) {
								// Proceed with renaming the profile on server side
								renameAndSaveProfileFinal('');
							}
						}
						else {
							
							// No database exists yet, show rename database window
							renameProfileDb.open(sourceProfileName, databaseName, newProfileName, newProfileLabel);
						}
					}
				}
				else {
					
					// No response from the server, try again and show an error message
					getDatabaseData();
					alert(langVar('lang_admin.profiles.rename_profile_connection_failed'));
				}
			}
		}
	}
	
	function renameAndSaveProfileFinal(newDatabaseName) {
		
		// This function is also called from the rename database window!
		// newDatabaseName is an empty string unless it is a new database name for external db servers
		
		// alert('newDatabaseName: ' + newDatabaseName);
		
		close();
		util.hideE('profiles_profiles_list');
		util.showE('saving_info');
		
		var url = '?dp=admin_pages.profiles.rename_profile';
		// We need to set the source_profile_name as -p option so that
		// database_sql_query knows what profile to use.
		url += '&p=' + sourceProfileName;

		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.source_profile_name=' + sourceProfileName;
		dat += '&v.fp.new_profile_name=' + newProfileName;
		dat += '&v.fp.new_profile_label=' + encodeURIComponent(newProfileLabel);
		
		dat += '&v.fp.new_database_name=' + encodeURIComponent(newDatabaseName);
				
		util.serverPost(url, dat);
	}
	
	function renameAndSaveProfileFinalResponse(dat) {

		// Reset userGrants
		profilesUtil.resetUserGrants(dat.userGrants);
		
		// util.showObject(dat);
		// We always load a new profilesDb when renaming a profile
		// because this is a rare uses case.
		profiles.handleNewProfilesDb(dat.profileChanges);

		var errorMessage = dat.errorMessage;
			
		if (errorMessage !== '') {
			alert(errorMessage);
		}
	}

	// Return global properties and methods
	return {
		open: open,
		close: close,
		getDatabaseDataResponse: getDatabaseDataResponse,
		renameAndSaveProfile: renameAndSaveProfile,
		renameAndSaveProfileFinal: renameAndSaveProfileFinal,
		renameAndSaveProfileFinalResponse: renameAndSaveProfileFinalResponse,
		setOkButtonState: setOkButtonState
	};

}());
