//
// schedulerUtil.js
//

var schedulerUtil = {
	
	actionsEmailToEmailAddressesObject: function(options) {
		
		// Converts the action email parameters in options (options.rca, options.ca and options.ba)
		// to an address array with objects required by emailUtil.js
		// i.e.: [{type:'to',  address:'abc@abc.com'}, {type:'cc', address:'first last <abc@abc.com>'}]
		
		var emailAddresses = [];
		var shortcuts = ['rca', 'ca', 'ba'];
		var recipientTypes = ['to', 'cc', 'bcc'];
		
		for (var i = 0; i < shortcuts.length; i++) {
			
			var shortcut = shortcuts[i];
			
			// Note, only options with a value exists!
			// If no cc_address has been defined then no cc_address exists in options!
			
			if (options[shortcut]) {
			
				var addressString = options[shortcut];
		
				// Remove white space
				addressString = addressString.replace(/\s/g, '');
				
				var type = recipientTypes[i];
				
				if (addressString.indexOf(',') == -1) {
					
					// Single email address
					emailAddresses[emailAddresses.length] = {type:type, address:addressString};
				}
				else {
					
					// Multiple email addresses
					var dat = addressString.split(',');
					
					for (var j = 0; j < dat.length; j++) {
						emailAddresses[emailAddresses.length] = {type:type, address:dat[j]};
					}
				}
			}
		}
		
		return emailAddresses;
	}
}