/* global
    adminConfig: false,
	langVar: false,
	listcontroller,
	optionInfo: false,
	pageInfo: false,
	toolbarButtonsDb: false,
	usersAM: false,
	usersUtil: false,
	util: false,
	YAHOO: false */

var users = (function() {

	'use strict';
	
	var YE = YAHOO.util.Event,
        isRootAdmin = false,
        isEnterprise = false,
        isUnlimitedGrants = false,
        defaultDividerLabels = [],
        languageInPreferences = '',
        languageOfDividerLists = '',
        activeUserNodeName = '',
        rootAdminUsername = '', // Used to check for duplicate username because the rootAdmin is not part of usersDb
        usersDb = [],
        usersDbBackup = [],
        profilesDb = [],
        rolesDb = [], // Contains the role names, labels and profile access rights if there are no unlimited grants, format is:
                     // [{name:"role_1", label:"Administrator", isPermission:true, all_profiles:false, profiles:['profile_1', profile_2]}, ...]
                     // Note, rolesDb contains all roles even if unlimited_grants is equal false because we need all roles for display!
                     // We use the "isPermission" property to check whether or not a role is granted.

        deletedUsersDb = [], // Keeps the node names of any deleted user, i.e. ['user_1', 'user_12']
        theList = null,
        validator = null,
        // isModifiedUsers = false,
        saveChangesBtn = null,
        newUserBtn = null,
        deleteBtn = null,
        duplicateBtn = null,
        undoAllChangesBtn = null,

        noItemFormIsActive = false,
        // Active form data:
        changePasswordIsActive = false,
        activeItemIsNew = false,
        activeItemNodeName = '',
        activeCreatedByUser = '',
        activeAccess = [],

        isSelectUserName = false, // used for username default selected upon new or duplicate

        // is true if the report filter expression field is shown on the item form
        isVisibleReportFilterExpressionField = false;


    function init() {

        //
        // Main init routine
        //

        isRootAdmin = pageInfo.isRootAdmin;
        isEnterprise = (pageInfo.licensingTier === 'enterprise');
        isUnlimitedGrants = pageInfo.permissions.isUnlimitedGrants;
        validator = new util.Validator();

        //
        // init toolbar buttons
        //

        saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);
        newUserBtn = new util.ToolbarButton('new_user', newUser, toolbarButtonsDb);
        duplicateBtn = new util.ToolbarButton('duplicate', duplicateUser, toolbarButtonsDb);
        deleteBtn = new util.ToolbarButton('delete', deleteUser, toolbarButtonsDb);
        undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);

        //
        // Ignore/Disable buttons according RBAC
        //

        var permissions = pageInfo.permissions;

        if (permissions.isEdit) {

            if (!permissions.isAdd) {
                newUserBtn.disableAndIgnore();
                duplicateBtn.disableAndIgnore();
            }

            if (!permissions.isDelete) {
                deleteBtn.disableAndIgnore();
            }

            // Register isModifiedPageHandler in adminConfig.js
            // (We don't check for modifications if there is no edit
            // permission because there is no Save button anyway!)
            adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
        }
        else {
            saveChangesBtn.disableAndIgnore();
            newUserBtn.disableAndIgnore();
            duplicateBtn.disableAndIgnore();
            deleteBtn.disableAndIgnore();
            undoAllChangesBtn.disableAndIgnore();
        }

        // init OptionInfo
        optionInfo.init();

        // Init help
        util.helpWindow.init('');

        //
        // Create the theList object
        //

        theList = new listcontroller.List({
            containerElementId: 'item_list_body',
            itemEvent: itemActivated
        });

        // Add events

        YE.addListener('users:username', 'keyup', updateListAndFormLabel);
        YE.addListener('users:change_password_btn', 'click', changeCancelPassword);
        YE.addListener('users:cancel_change_password_btn', 'click', changeCancelPassword);

        YE.addListener('users:access:tbody', 'click', usersUtil.accessListLinkActivated);
        YE.addListener('users:access:tbody', 'mouseover', usersUtil.hoverAccessListItem);
        YE.addListener('users:access:tbody', 'mouseout', usersUtil.hoverAccessListItem);


        YE.addListener('users:language', 'change', languageActor);

        //
        // Handle enterprise specific features
        //

        if (isEnterprise) {

            YE.addListener('users:access:new_access_pair_btn', 'click', usersAM.addNewAccessPair);
            YE.addListener('users:add_report_filter:btn', 'click', addReportFilter);
            YE.addListener('users:report_filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);

            util.showE('users:add_report_filter:section');
        }

        //
        // Init Access Manager Panel
        //

        usersAM.init();
        usersUtil.init();
    }

    function initMainDisplay() {

        // alert('initMainDisplay()');

        util.hideE(['form_section', 'users_form', 'no_item_form', 'loading_info', 'saving_info']);

        var firstItemId = theList.getFirstItemId();

        // alert('initMainDisplay() - firstItemId: ' + firstItemId);

        if (firstItemId !== null) {
            // select the first item
            setItem(firstItemId);
            displayNoItemForm(false);
        }
        else {
            // no item exists
            displayNoItemForm(true);
        }

        util.showE('form_section');
    }

    function getUsersData() {

        if (!pageInfo.exitActive) {

            var url = '?dp=admin_pages.users.get_data';
            var dat = 'v.fp.page_token=' + pageInfo.pageToken;
            util.serverPost(url, dat);
        }
    }

    function getUsersDataResponse(dat) {

//        util.showObject(dat);

        if (!pageInfo.exitActive) {

            defaultDividerLabels = dat.defaultDividerLabels;
            languageInPreferences = dat.languageInPreferences;
            activeUserNodeName = dat.activeUserNodeName;
            rootAdminUsername = dat.rootAdminUsername;
            usersDb = dat.usersDb;
            usersDbBackup = util.cloneObject(dat.usersDb);
            profilesDb = dat.profilesDb;
            rolesDb = dat.rolesDb;

            // util.showObject(defaultDividerLabels);

            util.createHash(defaultDividerLabels, 'language');
            util.createHash(profilesDb, 'name');
            util.createHash(rolesDb, 'name');


            // Init

            if (!pageInfo.initComplete) {
                // This is the initial page load
                init();
                theList.init(usersDb);
                initMainDisplay();
                pageInfo.initComplete = true;
            }

            // Set final toolbar state
            saveChangesBtn.enable();
            undoAllChangesBtn.enable();
            newUserBtn.enable();
            updateToolbarButtons(); // handles Duplicate and Delete

            adminConfig.setItemListSize();
            YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
        }
    }

    function displayNoItemForm(isDisplayNoItemForm) {

        if (isDisplayNoItemForm) {
            // util.updateT('item_form_label', '-');
            util.hideE('users_form');
            util.showE('no_item_form');
        }
        else {
            util.hideE('no_item_form');
            util.showE('users_form');
        }

        noItemFormIsActive = isDisplayNoItemForm;
    }

    function updateToolbarButtons() {

        var isItems = theList.isItems();
        deleteBtn.enable(isItems);
        duplicateBtn.enable(isItems);
    }

    function updateListAndFormLabel() {

        setTimeout(function() {

            var label = util.getF('users:username');
            if (label === '') {
                label = '-';
            }

            if (!isRootAdmin) {

                var item = theList.getSelectedItem();
                var userNodeName = item.dat.node_name;

                if (userNodeName === activeUserNodeName) {
                    label += ' (' + langVar('lang_admin.users.logged_in') + ')';
                }
            }

            // util.updateT('item_form_label', label);
            theList.updateListLabel(label);

        }, 300);
    }

//    function setListAndFormLabel() {
//
//
//    }

    function changeCancelPassword() {

        var isChangePassword = !changePasswordIsActive;
        // util.showE('users:password_container', isChangePassword);
        // util.showE('users:change_password_btn', !isChangePassword);
        // util.showE('users:cancel_change_password_btn', isChangePassword);
        util.showE('users:password_section', isChangePassword);
        util.showE('users:change_password_section', !isChangePassword);
        changePasswordIsActive = isChangePassword;

        // Reset any errors
        validator.reset();
    }

    function languageActor() {

        var language = util.getF('users:language');
        updateLanguageOptions(language);
    }

    function updateLanguageOptions(language) {

        // language is the language of current user

        // This updates the select element label
        // of number_thousands_divider and number_decimal_divider
        // so that the first list item shows the language specific
        // default dividers.

        function updateOptionText(elementId, label) {
            var element = util.getE(elementId);
            element.options[0].text = label;
        }

        if (language === '') {
            // Use default language as set it preferences
            language = languageInPreferences;
        }

        // Check if we need to update the default divider text
        if (language !== languageOfDividerLists) {

            var dividerItem = defaultDividerLabels[util.h(language)];
            updateOptionText('users:number_thousands_divider', dividerItem.defaultThousandDividerLabel);
            updateOptionText('users:number_decimal_divider', dividerItem.defaultDecimalDividerLabel);

            // Remember the language of divider lists
            languageOfDividerLists = language;
        }
    }

    function addReportFilter() {

        util.hideE('users:add_report_filter:section');
        util.showE('users:report_filter_expression:section');

        isVisibleReportFilterExpressionField = true;
    }

    function itemActivated(itemId) {

        if (validateActiveItem()) {
            setItem(itemId);
        }
    }

    function setItem(itemId) {

        // selects active item in list and displays the form

        theList.selectItem(itemId);
        updateForm(itemId);

        //
        // set delete button
        //
        /*
        if (itemId != activeUserItemId) {
            deleteButton.enable();
        }
        else {
            deleteButton.disable();
        }
        */
    }

    function newUser() {

        if (validateActiveItem()) {

            var newItemId = theList.getNewItemId();
            var newNodeName = usersUtil.getNewUserNodeName(usersDb, deletedUsersDb);

            // Give a default role in the pro version, the role_2 (Statistics visitor)
            var defaultRoles = isEnterprise ? [] : ['role_2'];
            var accessObj = [{
                all_profiles: false,
                profiles: [],
                roles: defaultRoles,
                created_by_user: activeUserNodeName
            }];

            var newUserLabel = langVar('lang_admin.users.new_user');

            var userObj = {
                id: newItemId,
                type: '',
                label: newUserLabel,
                dat: {
                    is_new: true,
                    node_name: newNodeName,
                    username: newUserLabel,
                    password: '',
                    email_address: '',
                    language: '',
                    number_thousands_divider: '',
                    number_decimal_divider: '',
                    created_by_user: activeUserNodeName,
                    access: accessObj,
                    auto_direct_to_reports_after_login: false,
                    report_filter_expression: ''
                }
            };

            theList.newItem(userObj);
            isSelectUserName = true;
            setItem(newItemId);
            updateToolbarButtons();
        }
    }

    function duplicateUser() {

        if (validateActiveItem()) {

            var item = theList.getSelectedItem();
            var username = item.dat.username;

            // Get new node name
            var newNodeName = usersUtil.getNewUserNodeName(usersDb, deletedUsersDb);
            var newUsername = langVar('lang_stats.general.item_copy');
            newUsername = newUsername.replace(/__PARAM__1/, username);

            // Clone item
            var clonedItemId = theList.cloneItem();

            //
            // Reset item data
            //

            theList.setItemDatValue(clonedItemId, 'is_new', true);
            theList.setItemDatValue(clonedItemId, 'node_name', newNodeName);
            theList.setItemDatValue(clonedItemId, 'username', newUsername);
            theList.setItemDatValue(clonedItemId, 'password', '');
            theList.setItemDatValue(clonedItemId, 'created_by_user', activeUserNodeName);

            isSelectUserName = true;
            setItem(clonedItemId);
        }
    }

    function deleteUser() {

        var item = theList.getSelectedItem();
        var itemId = item.id;

        deletedUsersDb[deletedUsersDb.length] = item.dat.node_name;

        // alert('deleteRole(): ' + itemId);


        //
        // select the next item
        //

        var nextItemIdToBeSelected = theList.deleteItem();

        if (nextItemIdToBeSelected !== null) {

            // reset the validator in case that the deleted an item with error indication
            validator.reset();
            setItem(nextItemIdToBeSelected);
        }
        else {

            // All items have been deleted

            // alert('Last item has been deleted, no more items to select.');
            displayNoItemForm(true);
            updateToolbarButtons();
        }
    }

    function updateForm(itemId) {

        var item = theList.getSelectedItem();
        var itemDat = item.dat;

//        util.showObject(item);
        // util.showObject(itemDat);

        // util.updateT('item_form_label', itemDat.username);

        activeItemIsNew = itemDat.is_new;
        activeItemNodeName = itemDat.node_name;

        //
        // Handle username
        //

        util.setF('users:username', itemDat.username);
        // var isLoggedInUser = (itemDat.node_name == activeUserNodeName);
        // util.showE('users:active_user_info', isLoggedInUser);

        //
        // Handle password
        //

        // util.hideE(['users:password_container', 'users:change_password_btn', 'users:cancel_change_password_btn']);
        util.hideE(['users:change_password_section', 'users:password_section']);

        var password = itemDat.password;
        changePasswordIsActive = false;
        util.setF('users:password', password);

        if (!itemDat.is_new) {
            // Existing user item
            if (password === '') {

                // util.hideE('users:password_container');
                // util.showE('users:change_password_btn');
                util.hideE('users:password_section');
                util.showE('users:change_password_section');
            }
            else {

                // password changed already, allow to cancel the change
                // util.showE('users:password_container');
                // util.showE('users:cancel_change_password_btn');
                util.showE('users:password_section');
                util.showE('users:cancel_change_password_btn');
                changePasswordIsActive = true;
            }
        }
        else {

            // New user item
            // util.showE('users:password_container');
            util.hideE('users:cancel_change_password_btn');
            util.showE('users:password_section');
        }

        util.setF('users:email_address', itemDat.email_address);

        //
        // Handle language options & created_by_user
        //

        util.setF('users:language', itemDat.language);
        updateLanguageOptions(itemDat.language);
        util.setF('users:number_thousands_divider', itemDat.number_thousands_divider);
        util.setF('users:number_decimal_divider', itemDat.number_decimal_divider);
        activeCreatedByUser = itemDat.created_by_user;


        //
        //
        // Handle access
        //
        //

        // Clone the active access array to activeAccess, we use
        // the activeAccess to create and manipulate the access list
        // per user item.

        activeAccess = util.cloneObject(itemDat.access);

        // util.showObject(activeAccess);

        usersUtil.updateAccessList();

        if (noItemFormIsActive) {
            displayNoItemForm(false);
        }

        // Set auto_direct_to_reports_after_login
        util.setF('users:auto_direct_to_reports_after_login', itemDat.auto_direct_to_reports_after_login);

        //
        //
        // Handle report filter
        //
        //

        if (isEnterprise) {

            var reportFilterExpression = itemDat.report_filter_expression;
            var reportFilterExpressionExists = (reportFilterExpression !== '');

            util.setF('users:report_filter_expression', reportFilterExpression);

            if (reportFilterExpressionExists !== isVisibleReportFilterExpressionField) {

                util.showE('users:add_report_filter:section', !reportFilterExpressionExists);
                util.showE('users:report_filter_expression:section', reportFilterExpressionExists);
                isVisibleReportFilterExpressionField = reportFilterExpressionExists;
            }
        }


        // Assign tabIndex (hard coded html tabindex has a problem with password field, hence we do via js!

        /*
        KHP 25/Nov/2010 - disabled because tabIndex looks to work  without js
        and it misses number_thousands_divider, number_decimal_divider and report filter
        anyway.
        var f1 = util.getE('users:username');
        var f2 = util.getE('users:password');
        var f3 = util.getE('users:access:container');
        var f4 = util.getE('users:language');
        f1.tabIndex = 1;
        f2.tabIndex = 2;
        f3.tabIndex = 3;
        f4.tabIndex = 4;

        if (isSelectUserName) {
            f1.select();
            // Reset isSelectUserName
            isSelectUserName = false;
        }
        */

    }

    function validateActiveItem() {

        // Only validate if isEdit permission and if items

        if (pageInfo.permissions.isEdit && theList.isItems()) {

            validator.reset();

            var o = {};

            // Transfer is_new and node_name from existing object
            o.is_new = activeItemIsNew;
            o.node_name = activeItemNodeName;

            o.username = validator.isValue('users:username');

            // Make sure the username is not equal the rootAdmin username

            if (o.username !== rootAdminUsername) {

                // The username is case sensitive, so "user a" is not equal "USER A", both are unique!
                o.username = validator.isUnique('users:username', theList.getLookupItems('username'));
            }
            else {
                // Same username as rootAdmin, we show a custom error
                var msg = '';

                if (isRootAdmin) {
                    msg = langVar('lang_admin.users.is_root_admin_username_msg');
                }
                else {
                    msg = langVar('lang_admin.users.is_reserved_username_msg');
                }

                validator.isCustom('users:username', msg);
            }

            // alert('o.username: ' + o.username);

            if (activeItemIsNew || changePasswordIsActive) {
                o.password = validator.isValue('users:password');
            }
            else {
                o.password = '';
            }

            o.email_address = util.getF('users:email_address');

            // Validate for valid email address if any is defined
            if (o.email_address !== '') {
                validator.isEmailAddress('users:email_address');
            }

            o.language = util.getF('users:language');
            o.number_thousands_divider = util.getF('users:number_thousands_divider');
            o.number_decimal_divider = util.getF('users:number_decimal_divider');
            o.created_by_user = activeCreatedByUser;

            //
            // Handle access (get active access array from activeAccess, it is ready to go)
            //
            // Note, we allow zero profiles and zero roles, there is no validation for profiles and roles!

            o.access = util.cloneObject(activeAccess);

            o.auto_direct_to_reports_after_login = util.getF('users:auto_direct_to_reports_after_login');

            o.report_filter_expression = (isVisibleReportFilterExpressionField) ? util.getF('users:report_filter_expression') : '';

            if (validator.allValid()) {

                theList.saveItem(o);
                return true;
            }

            return false;
        }

        // No isEdit permission or no items
        return true;
    }

    //
    // Save Changes
    //

    function getDeletedUsersDat() {

        var dat = '';

        if (deletedUsersDb.length > 0) {

            for (var i = 0, numItems = deletedUsersDb.length; i < numItems; i++) {

                dat += 'v.fp.deleted_users.' + deletedUsersDb[i] + '=true&';
            }
        }
        else {

            dat += 'v.fp.deleted_users=&';
        }

        return dat;
    }

    function getUsersAccessItemsDat(userPath, access) {

        var dat = '';
        var accessItem;
        var accessItemPath;
        var accessProfiles;
        var accessRoles;

        for (var i = 0, numItems = access.length; i < numItems; i++) {

            accessItem = access[i];
            accessItemPath = userPath + '.access.' + i;

            dat += accessItemPath + '.all_profiles=' + accessItem.all_profiles + '&';
            dat += accessItemPath + '.created_by_user=' + accessItem.created_by_user + '&';

            accessProfiles = accessItem.profiles;
            accessRoles = accessItem.roles;

            if (accessProfiles.length > 0) {

                for (var j = 0, numProfiles = accessProfiles.length; j < numProfiles; j++) {

                    dat += accessItemPath + '.profiles.' + j + '=' + accessProfiles[j] + '&';
                }
            }
            else {

                dat += accessItemPath + '.profiles=&';
            }

            if (accessRoles.length > 0) {

                for (var k = 0, numRoles = accessRoles.length; k < numRoles; k++) {

                    dat += accessItemPath + '.roles.' + k + '=' + accessRoles[k] + '&';
                }
            }
            else {

                dat += accessItemPath + '.roles=&';
            }
        }

        return dat;
    }

    function getUsersDat() {

        var dat = '';
        var numOfUsers = usersDb.length;
        var itemDat = '';

        if (numOfUsers > 0) {

            for (var i = 0; i < numOfUsers; i++) {

                itemDat = usersDb[i].dat;

//              util.showObject(itemDat);

                var userPath = 'v.fp.users.' + itemDat.node_name;

                dat += userPath + '.is_new=' + itemDat.is_new + '&';
                dat += userPath + '.username=' + encodeURIComponent(itemDat.username) + '&';
                dat += userPath + '.password=' + encodeURIComponent(itemDat.password) + '&';
                dat += userPath + '.email_address=' + encodeURIComponent(itemDat.email_address) + '&';
                dat += userPath + '.language=' + itemDat.language + '&';
                dat += userPath + '.number_thousands_divider=' + encodeURIComponent(itemDat.number_thousands_divider) + '&';
                dat += userPath + '.number_decimal_divider=' + encodeURIComponent(itemDat.number_decimal_divider) + '&';
                dat += userPath + '.created_by_user=' + itemDat.created_by_user + '&';

                dat += getUsersAccessItemsDat(userPath, itemDat.access);

                dat += userPath + '.auto_direct_to_reports_after_login=' + itemDat.auto_direct_to_reports_after_login + '&';

                // Add report_filter_expression
                dat += userPath + '.report_filters.all_profiles.filter_expression=' + encodeURIComponent(itemDat.report_filter_expression) + '&';
            }
        }
        else {

            dat += 'v.fp.users=&';
        }

        return dat;
    }

    function getUsersDbBackupDat() {

        var numOfUsers2 = usersDbBackup.length;
        var dat = '';
        var itemDat;

        if (numOfUsers2 > 0) {

            for (var i = 0; i < numOfUsers2; i++) {

                itemDat = usersDbBackup[i].dat;
                dat += 'v.fp.users_backup.' + i + '=' + encodeURIComponent(itemDat.username) + '&';
            }
        }
        else {

            dat += 'v.fp.users_backup=&';
        }

        return dat;
    }

    function saveChanges() {

        if (validateActiveItem()) {

            var isModified = theList.getIsModified();

            // alert('saveChanges() - isModified: ' + isModified);

            if (isModified) {

                util.hideE('form_section');
                util.showE('saving_info');

                var url = '?dp=admin_pages.users.save_data';
                var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';

                // Handle deleted users
                dat += getDeletedUsersDat();

                // Handle users
                dat += getUsersDat();

                // Handle usersDbBackup
                dat += getUsersDbBackupDat();

                dat = dat.replace(/&$/, '');

                util.serverPost(url, dat);
            }
            else {

                alert(langVar('lang_stats.general.no_changes_to_save'));
            }
        }
    }

    function saveChangesResponse() {

        // alert('saveChangesResponse()');
        // Note, we keep the system at current state, we do not re-initialize theList
        usersDbBackup = util.cloneObject(usersDb);

        deletedUsersDb = [];

        theList.resetIsModified();

        util.hideE('saving_info');
        util.showE('form_section');
    }

    function undoAllChanges() {

        usersDb = util.cloneObject(usersDbBackup);
        deletedUsersDb = [];

        theList.init(usersDb);
        initMainDisplay();
        updateToolbarButtons();
    }

    function getIsModifiedPage() {

        // Note, isModified will be false if only the active item has been edited
        // but has an error, hence we also check "if (!validateActiveItem() ..."

        return !validateActiveItem() || theList.getIsModified();
    }

    function get(name) {

        // Returns a reference or value
        if (name === 'profilesDb') {

            return profilesDb;
        }
        else if (name === 'rolesDb') {

            return rolesDb;
        }
        else if (name === 'usersDb') {

            return usersDb;
        }
        else if (name === 'activeAccess') {

            return activeAccess;
        }
        else if (name === 'activeUserNodeName') {

            return activeUserNodeName;
        }
    }

    // Return global methods
	return {
		init: init,
        getUsersData: getUsersData,
        getUsersDataResponse: getUsersDataResponse,
        saveChangesResponse: saveChangesResponse,
        get: get
	};
}());
