/* global
	langVar: false,
	pageInfo: false,
	users: users,
	usersUtil: false,
	util: false,
	YAHOO: false */

// usersAM.js (handles the users Access Manager Panel

var usersAM = (function() {

    'use strict';
	
	var YE = YAHOO.util.Event,
        isRootAdmin = false,
        isUnlimitedGrants = false,
        panel = null,
        tabs = null,
        isNewAccessPair = false,

        // The index of the active access pair in users.activeAccess.
        // The index is only relevant when isNewAccessPair is false.
        activeAccessItemIndex = 0,

        activeCreatedByUser = '';
	
	function init() {
		
		//
		// Init the panel
		//
		
		var panelObj = {
			panelId: 'users:am:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: close
		};
		
		panel = new util.Panel3(panelObj);
		
		//
		// Init the tabs
		//

		var tabList = ['users:am:profiles:tab', 'users:am:roles:tab'];
		tabs = new util.Tabs3('users:am:tabs', tabList, tabActivated);
		tabs.setSequence(tabList, 'users:am:profiles:tab');
		
		//
		//
		// Init form controls
		//
		//
		
		isRootAdmin = pageInfo.isRootAdmin;
		isUnlimitedGrants = pageInfo.permissions.isUnlimitedGrants;
		var isLimitedGrants = (!isRootAdmin && !isUnlimitedGrants);

		//
		// Handle roles list first so that we can populate a profilesLookup if
		// isLimitedGrants
		//

		var rolesDb = users.get('rolesDb');
		var profilesDb = users.get('profilesDb');

//        util.showObject(rolesDb);
//        util.showObject(profilesDb);
		
		var rolesList = [];
		var profilesList = [];
		var profilesLookup = {};
		var isAllProfilesPermission = false;
        var numProfiles;
		
		if (!isLimitedGrants) {
			
			rolesList = rolesDb;
			isAllProfilesPermission = true;
		}
		else {
			
			for (var i = 0, numRoles = rolesDb.length; i < numRoles; i++) {
				
				var roleItem = rolesDb[i];
				
				if (roleItem.isPermission) {
					
					rolesList[rolesList.length] = {name:roleItem.name, label:roleItem.label};
					
					if (roleItem.isAllProfiles) {
						
						isAllProfilesPermission = true;
					}
					else {
						
						// Remember any profile listed in profiles in profilesLookup

                        numProfiles = roleItem.profiles.length;

						for (var j = 0; j < numProfiles; j++) {

							profilesLookup['_' + roleItem.profiles[j]] = true;
						}
					}
				}
			}
		}
		
		//
		//
		// Create profiles list
		//
		//
		
		if (isAllProfilesPermission) {
			profilesList[0] = {name: '__ALL__PROFILES__', label: langVar('lang_admin.users.all_profiles_accesses')};
		}

        numProfiles = profilesDb.length;
		
		for (var k = 0; k < numProfiles; k++) {
			
			var profileItem = profilesDb[k];
			var profileName = profileItem.name;
			
			if (isAllProfilesPermission || (profilesLookup['_' + profileName] !== null)) {
				
				// We add a space to profile labels so that there is some offset from the All Profiles label
				var profileLabel = isAllProfilesPermission ? ' ' + profileItem.label : profileItem.label;
				profilesList[profilesList.length] = {name: profileName, label: profileLabel}; 
			}
		}
		
		util.populateSelect('users:am:profiles:select', profilesList, 'name', 'label');
		util.populateSelect('users:am:roles:select', rolesList, 'name', 'label');
		
		YE.addListener('users:am:okay', 'click', saveAccessPair);
		YE.addListener('users:am:cancel', 'click', close);
	}

	function open(itemIndex, accessItem, activeTabIsRoles, _isNewAccessPair) {
		
		// isNewAccessPair is true when Access Manager is opened via the
		// New Access Pair button.
		
		// reset the form
		util.resetF('users_am_form');
		
		//
		//
		// Set form values according accessItem
		//
		//
		
		activeAccessItemIndex = itemIndex;
		isNewAccessPair = _isNewAccessPair;
		activeCreatedByUser = accessItem.created_by_user;
		
		var isAllProfiles = accessItem.all_profiles;
		var profiles = accessItem.profiles;
		var roles = accessItem.roles;

		// var selectOptions;
		
		if (!isAllProfiles) { 

			for (var i = 0, numProfiles = profiles.length; i < numProfiles; i++) {

				util.setF('users:am:profiles:select', profiles[i]);
			}
		}
		else {

			// Check the All profiles radio button
			// util.setF('users:am:all_profiles_btn', true);
			
			// Select All Profiles entry
			var profilesSelect = util.getE('users:am:profiles:select');
			// alert('profilesSelect: ' + profilesSelect);
			profilesSelect.selectedIndex = 0;
			// profilesSelect.options[0].selected = true;
		}
		
		for (var j = 0, numRoles = roles.length; j < numRoles; j++) {

			util.setF('users:am:roles:select', roles[j]);
		}
		
		// Preset tabs
		var tabId = activeTabIsRoles ? 'users:am:roles:tab' : 'users:am:profiles:tab';
		tabs.setActiveTab(tabId);
		setDisplay(activeTabIsRoles);
		
		// Open panel
		var panelLabel = !isNewAccessPair ? langVar('lang_admin.users.edit_access_pair') : langVar('lang_admin.users.new_access_pair');
		panel.open({label: panelLabel});
	}
	
	function addNewAccessPair() {
		
		var itemIndex = 0; // is not relevant when adding a new item
		var isNewAccessPair = true;
		var activeTabIsRoles = false;
		var newAccessItem = {
			all_profiles: false,
			profiles: [],
			roles: []
			// created_by_user: users.activeUserNodeName
		};
		
		open(itemIndex, newAccessItem, activeTabIsRoles, isNewAccessPair);
	}
	
	function setDisplay(activeTabIsRoles) {
		
		if (activeTabIsRoles) {
			util.hideE('users:am:profiles:section');
			util.showE('users:am:roles_section');
		}
		else {
			util.hideE('users:am:roles_section');
			util.showE('users:am:profiles:section');
		}
	}
	
	function tabActivated(tabId) {
		
//		var tabId = this.id;
		var activeTabIsRoles = (tabId === 'users:am:roles:tab');
		tabs.setActiveTab(tabId);
		setDisplay(activeTabIsRoles);
	}
	
	function getIsValidAccessPair(profiles, roles) {
		
		// Only used if there are no unlimited grants. It is
		// only relevant if there are different profiles with different role permissions,
		// i.e. different profile manager roles are assigned to different profiles.
		
		var allValid = true;
		var isValidRoleProfileRelation;
		var rolesDb = users.get('rolesDb');
		var profilesDb = users.get('profilesDb');
		var info = '';
        var profileName = '';
		
		for (var i = 0, numRoles = roles.length; i < numRoles; i++) {
	
			var roleName = roles[i];
			var theRoleInDb = rolesDb[util.h(roleName)];
			var isAllProfiles = theRoleInDb.isAllProfiles;
			
			for (var j = 0, numProfiles = profiles.length; j < numProfiles; j++) {
				
				profileName = profiles[j];
				
				isValidRoleProfileRelation = false;
				
				if (isAllProfiles) {
					isValidRoleProfileRelation = true;
				}
				else {
					// Check if the profile exists in theRoleInDb.profiles
					
					for (var k = 0, numItems = theRoleInDb.profiles.length; k < numItems; k++) {
						
						if (theRoleInDb.profiles[k] === profileName) {

							isValidRoleProfileRelation = true;
							break;
						}
					}
				}
				
				// We add any invalid profile/role relations to info
				// and show them in an alert.
				
				if (!isValidRoleProfileRelation) {
					
					allValid = false;
			
					var roleLabel = theRoleInDb.label;
					var profileLabel = profilesDb[util.h(profileName)].label;
				
					info += profileLabel + ' - ' + roleLabel + '\n';
				}
			}
		}
		
		if (!allValid) {

			alert(langVar('lang_admin.users.profiles_roles_assignment_conflict_msg') + '\n' + info);
		}
		
		return allValid;
	}
	
	function saveAccessPair() {
		
		
		var profilesSelect = util.getE('users:am:profiles:select');
		
		var profilesOptions = profilesSelect.options;
		
		var isAllProfiles = ((profilesOptions[0].value === '__ALL__PROFILES__') && profilesOptions[0].selected);
		var profiles = [];
		var roles = [];

		
		// alert('isAllProfiles: ' + isAllProfiles);
		
		if (!isAllProfiles) {

			for (var i = 0, numProOpt = profilesOptions.length; i < numProOpt; i++) {

				if (profilesOptions[i].selected) {

					profiles[profiles.length] = profilesOptions[i].value;
				}
			}
		}
		
		var rolesSelect = util.getE('users:am:roles:select');
		var options = rolesSelect.options;

		for (var j = 0, numOptions = options.length; j < numOptions; j++) {

			if (options[j].selected) {

				roles[roles.length] = options[j].value;
			}
		}
		
		var isValidAccessPair = (isRootAdmin || isUnlimitedGrants) ? true : getIsValidAccessPair(profiles, roles);
		
		if (isValidAccessPair) {
		
			var accessItem;
			var accessItemIndex = 0;
			var activeAccess = users.get('activeAccess');
			
			var numberOfAccessItems = activeAccess.length;
			
			if (!isNewAccessPair) {
				
				// Update the existing access object
				accessItemIndex = activeAccessItemIndex;
				
				accessItem = activeAccess[accessItemIndex];
				accessItem.all_profiles = isAllProfiles;
				accessItem.profiles = profiles;
				accessItem.roles = roles;
				
				// Update the single row in access list
				usersUtil.updateAccessRow(accessItemIndex, accessItem, numberOfAccessItems);
			}
			else {
				
				// Add a new access item object
				
				numberOfAccessItems += 1;
				
				accessItem = {
					all_profiles: isAllProfiles,
					profiles: profiles,
					roles: roles,
					created_by_user: users.get('activeUserNodeName')
				};
				
				// Add new item to users.activeAccess
				accessItemIndex = activeAccess.length;
				activeAccess[accessItemIndex] = accessItem;
				
				// util.showObject(activeAccess);
				
				// Create a new row
				var tbody = util.getE('users:access:tbody');
				usersUtil.createAccessRow(tbody, accessItemIndex);
				
				
				// If the list already shows a delete button (final numberOfAccessItems > 2)
				// then we only need to update the last row, else we update all rows.
				
				if (numberOfAccessItems > 2) {

					// Update single row
					usersUtil.updateAccessRow(accessItemIndex, accessItem, numberOfAccessItems);
				}
				else {

					// Update all rows so that we get the delete button in every row
					for (var k = 0; k < numberOfAccessItems; k++) {

						usersUtil.updateAccessRow(k, activeAccess[k], numberOfAccessItems);
					}
				}
			}
			
			// Close the panel
			close();
		}
	}

	function close() {
		
		panel.close();
	}

     // Return global methods
	return {
		init: init,
        open: open,
        addNewAccessPair: addNewAccessPair
	};

}());
