//
// databaseFilters
//

window.onresize = adminConfig.setItemListSize;

var databaseFilters = function() {

    // var h = util.h;
    var YE = YAHOO.util.Event;
    var GD = { // General global data
	
        theList: null,
        databaseFields: [],
        itemsDb: [], // items work array
        itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
        
        validator: null,
        
        saveChangesBtn: null,
        newItemBtn: null,
        duplicateBtn: null,
        deleteBtn: null,
        undoAllChangesBtn: null,
        
        activeFormElementId: '',
        
        activeItem: {
        	labelOri: ''
        },
        
        availableFieldsPanel: null
    };

    function init() {

        GD.validator = new util.Validator();
        
        //
		// init toolbar buttons and form controls
		//
		
		GD.saveChangesBtn = new util.ToolbarButton('save_changes', saveItems, toolbarButtonsDb);
		GD.newItemBtn = new util.ToolbarButton('new_database_filter', newItem, toolbarButtonsDb);
		GD.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
		GD.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
		GD.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
			
		// Create theList object
		GD.theList = new listcontroller.List({
			containerElementId: 'item_list_body',
			itemEvent: itemActivated,
			// isSwitch1: true,
			isMoveControl: true
		});
		
		// Init the list
		GD.theList.init(GD.itemsDb);
		
		//
		// Ignore/Disable buttons according RBAC
		//
		
		var permissions = pageInfo.permissions;
		
		if (permissions.isEdit) {
			
			if (!permissions.isAdd) {
				GD.newItemBtn.disableAndIgnore();
				GD.duplicateBtn.disableAndIgnore();
			}
			
			if (!permissions.isDelete) {
				GD.deleteBtn.disableAndIgnore();
			}
			
			// Register isModifiedPageHandler in adminConfig.js
			// (We don't check for modifications if there is no edit 
			// permission because there is no Save button anyway!)
			adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
		}
		else {
			GD.saveChangesBtn.disableAndIgnore();
			GD.newItemBtn.disableAndIgnore();
			GD.duplicateBtn.disableAndIgnore();
			GD.deleteBtn.disableAndIgnore();
			GD.undoAllChangesBtn.disableAndIgnore();
		}
		
		// Set final toolbar state
		GD.saveChangesBtn.enable();
		GD.undoAllChangesBtn.enable();
		GD.newItemBtn.enable();
		
		YE.addListener('database_filters:label', 'keyup', updateListAndFormLabel);
		YE.addListener('database_filters:show_available_fields_btn', 'click', openAvailableFieldsPanel);
	
		pageInfo.initComplete = true;
    }
    
    function initAvailableFieldsPanel() {
    	
    	// Create the available expression fields list
			
		var availableExprFieldsDb = [];
		var databaseFields = GD.databaseFields;
		var numFields = databaseFields.length;
		for (var i = 0; i < numFields; i++) {
			var dbField = databaseFields[i];
			availableExprFieldsDb[i] = {label:dbField.label, name:dbField.name};
		}
		
		var viewExprFieldsObj = {
			panelId: 'database_filters_available_fields:panel',
			tbodyId: 'database_filters_available_fields:tbody',
			panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
			availableExpressionFieldsDb: availableExprFieldsDb
		};
		
		GD.availableFieldsPanel = new AvailableExprFields(viewExprFieldsObj);
		
		YE.addListener('database_filters_available_fields:close_btn', 'click', closeAvailableFieldsPanel);
	}
	
	function openAvailableFieldsPanel() {
		
		GD.availableFieldsPanel.open();
	}
	
	function closeAvailableFieldsPanel() {
		
		GD.availableFieldsPanel.close();
	}
    
    function updateListAndFormLabel() {
    	
    	setTimeout('databaseFilters.setListAndFormLabel()', 300);
    }
    
    function setListAndFormLabel() {
	
		var label = util.getF('database_filters:label');
		if (label == '') {
			label = '-';
		}
		
		GD.theList.updateListLabel(label);
	}
    
    function getData() {
    	
    	if (!pageInfo.exitActive) {
		
			// Init help
			util.helpWindow.init('');
	
			// invoked upon editor load
			var url = '?dp=config_pages.database_filters.get_db_filters_data';
			url += '&p=' + pageInfo.profileName;
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		
			util.serverPost(url, dat);
		}
    }
    
    function getDataResponse(dat) {
    	
    	// util.showObject(dat);
    	
    	GD.databaseFields = dat.databaseFields;
    	var itemsDb = dat.databaseFilters;
    	
    	GD.itemsDb = itemsDb;
    	GD.itemsDbBackup = util.cloneObject(itemsDb);
    	
    	init();
    	initAvailableFieldsPanel();
    	
    	// Select first item
    	var firstItemId = GD.theList.getFirstItemId();
    	setItem(firstItemId);
    	
    	util.showE('form_section');
    	
    	adminConfig.setItemListSize();
    	YE.addListener(window, 'resize', adminConfig.setItemListSize);
    }
    
    function setItem(itemId) {
    	
    	var isItem = (itemId != null);
    	var requiredFormElementId = '';
    	
    	if (isItem) {

			requiredFormElementId = 'database_filters:form';
			GD.theList.selectItem(itemId);
			updateForm();
		}
		else {
			requiredFormElementId = 'no_item_form';
		}
		
		if (GD.activeFormElementId != requiredFormElementId) {
			
			GD.deleteBtn.enable(isItem);
			GD.duplicateBtn.enable(isItem);
			util.showE('no_item_form', !isItem);
			util.showE('database_filters:form', isItem);
		}
    }
    
	function itemActivated(itemId) {
		
		if (validateActiveItem()) {
			// if selected node item is valid then e to activated node item
			setItem(itemId);
		}
	}
    
    function newItem() {
    	
    	if (validateActiveItem()) {
	
    		var theList = GD.theList;
			var newItemId = theList.getNewItemId();
			var newItemLabel = langVar('lang_admin.general.new_log_parsing_filter');
			
			var newFilterObj = {
				id: newItemId,
				type: '',
				label: newItemLabel,
				dat: {
					label: newItemLabel,
					labelOri: '',
					conditions: '',
					expression: ''
				}
			};
			
			theList.newItem(newFilterObj);
			setItem(newItemId);
		}
    }
    
    function duplicateItem() {
    	
    	if (validateActiveItem()) {
		
			var theList = GD.theList
			var clonedItemId = theList.cloneItem();
			
			setItem(clonedItemId);
		}
    }
    
    function deleteItem() {
    	
    	var theList = GD.theList;
		var nextItemIdToBeSelected = theList.deleteItem();
		
		// reset the validator to clear any error message of the deleted item
		GD.validator.reset();
		// select the next item
		setItem(nextItemIdToBeSelected);
    }
    
    function updateForm() {
    	
    	var item = GD.theList.getSelectedItem();
    	var itemType = item.type;
    	var itemDat = item.dat;
    	
		// util.showObject(itemDat);
		
		// Set non-editable data which are simply transferd to new object
		GD.activeItem.labelOri = itemDat.labelOri;

		util.setF('database_filters:label', itemDat.label);
		util.setF('database_filters:conditions', itemDat.conditions);
		util.setF('database_filters:expression', itemDat.expression);
    }
    
    function validateActiveItem() {
    	
		// Only validate if isEdit permission
		
		var theList = GD.theList;
		
		if (pageInfo.permissions.isEdit && theList.isItems()) {

			var validator = GD.validator;
			validator.reset();
			var o = {};
			
			o.label = validator.isValue('database_filters:label');
			o.label = validator.isUnique('database_filters:label', theList.getLookupItems('label'));
			o.labelOri = GD.activeItem.labelOri;
			o.conditions = util.getF('database_filters:conditions');
			o.expression = validator.isValue('database_filters:expression');
			
			if (validator.allValid()) {

				theList.saveItem(o);
				return true;
			}
		
			return false;
		}
		
		// If no edit permission or no items
		return true;
    }
    
    function saveItems() {
    	
    	if (validateActiveItem()) {
		
			var theList = GD.theList;
			var isModified = theList.getIsModified();
			
			// alert('isModified: ' + isModified);
	
			if (isModified) {
				
				saveItemsFinal();
			}
			else {
				
				alert(langVar('lang_stats.general.no_changes_to_save'));
			}
		}
    }
   
    function saveItemsFinal() {
    	
		util.hideE('form_section');
		util.showE('saving_info');
		
		var itemsDb = GD.itemsDb;
		var numberOfItems = itemsDb.length;
		
		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
		
		if (numberOfItems > 0) {
		
			for (var i = 0; i < numberOfItems; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				var path = 'v.fp.database_filters.' + i;
				
				// Add position node so that we are able tp re-sort items on client side
				dat += path + '.position=' + i + '&';
				dat += path + '.label=' + encodeURIComponent(itemDat.label) + '&';
				dat += path + '.label_ori=' + encodeURIComponent(itemDat.labelOri) + '&';
				dat += path + '.conditions_string=' + encodeURIComponent(itemDat.conditions) + '&';
				dat += path + '.expression=' + encodeURIComponent(itemDat.expression) + '&';
			}
			
			dat = dat.replace(/&$/, '');
		}
		else {
			
			// No database filter exists
			dat += 'v.fp.database_filters=';
		}
		
		pageInfo.saveActive = true;
		
		var url = '?dp=config_pages.database_filters.save_db_filters';
		url += '&p=' + pageInfo.profileName;
		
		util.serverPost(url, dat);
    }
    
    function saveItemsFinalResponse(dat) {
    	
    	// reset isModified
		GD.theList.resetIsModified();
		
		// the saved work itemsDb becomes now the itemsDbBackup
		GD.itemsDbBackup = util.cloneObject(GD.itemsDb);

		// Update profilesListChecksum checksum
		profilesStorage.update(dat.profileChanges);
		
		pageInfo.saveActive = false;
		
		util.hideE('saving_info');
		util.showE('form_section');
	}
    
    function undoAllChanges() {
    	
    	GD.itemsDb = util.cloneObject(GD.itemsDbBackup);
		GD.validator.reset();
		GD.theList.init(GD.itemsDb);
		
		// Select first item
    	var firstItemId = GD.theList.getFirstItemId();
    	setItem(firstItemId);
    }
    
    function getIsModifiedPage() {

        // Before checking isModified we need to validate the form!
        if (!validateActiveItem() || GD.theList.getIsModified()) {
            return true;
        }
        return false;
    }
   
	//
	// Return global properties and methods
	//

	return {
        getData: getData,
        getDataResponse: getDataResponse,
        setListAndFormLabel: setListAndFormLabel,
        saveItemsFinalResponse: saveItemsFinalResponse,
        openAvailableFieldsPanel: openAvailableFieldsPanel,
        closeAvailableFieldsPanel: closeAvailableFieldsPanel
    }
}();
