//
// logFilterCondition.js
//

var logFilterCondition = {
	
	panel: null,
	validator: null,
	
	//
	// Active form parameters
	//
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index

	activeOperatorListType: '', // numerical | string | dateTime --> names are equal the property name in conditionOperatorsDb object for quick access

	init: function() {
		
		var addSelectOption = true;
	
		var panelObj = {
			panelId: 'lfc:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterCondition.closePanel
		};
		
		var YE = YAHOO.util.Event;
		
		logFilterCondition.panel = new util.Panel3(panelObj);
		logFilterCondition.validator = new util.Validator();
		
		logFiltersUtil.populateFullLogFieldsList('lfc:log_fields_list', addSelectOption);
		
		// Set default operator list by resetForm()
		logFilterCondition.resetForm();
		
		//
		// Add events
		//
		
		YE.addListener('lfc:log_fields_list', 'change', logFilterCondition.selectLogFieldActor);
			
		YE.addListener('lfc:ok_btn', 'click', logFilterCondition.saveItem);
		YE.addListener('lfc:cancel_btn', 'click', logFilterCondition.closePanel);
	},
	
	selectLogFieldActor: function() {
		
		// Invoked by event and by updateForm()!
		
		var logFieldName = util.getF('lfc:log_fields_list');
		
		if (logFieldName != '') {
			
			var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
			
			var requiredOperatorListType = '';
			
			if (logFieldItem.type == 'date_time') {
				requiredOperatorListType = 'dateTime';
			}
			else if (logFieldItem.dbFieldType == 'string') {
				requiredOperatorListType = 'string';
			}
			else {
				requiredOperatorListType = 'numerical';
			}
			
			if (requiredOperatorListType != logFilterCondition.activeOperatorListType) {
				
				var operatorsDb = logFilters.conditionOperatorsDb[requiredOperatorListType];
				util.populateSelect('lfc:operator_list', operatorsDb, 'name', 'label');
				logFilterCondition.activeOperatorListType = requiredOperatorListType;
			}
		}
	},
	
	openPanel: function(panelLabel, item) {
		
		// Note, the item may be empty!
		
		if (!logFilterCondition.panel) {
			logFilterCondition.init();
		}
		
		if (!item.log_field) {
			// Reset/set initial state
			logFilterCondition.resetForm();
		}
		else {
			// this is an existing item
			logFilterCondition.updateForm(item);
		}		
		
		logFiltersUtil.fixDivOverflow(true);
		logFilterCondition.panel.open({label:panelLabel});
	},
	
	resetForm: function() {
		
		util.resetF('lfc:form');
		
		if (logFilterCondition.activeOperatorListType != 'string') {
			var stringOperators = logFilters.conditionOperatorsDb.string;
			util.populateSelect('lfc:operator_list', stringOperators, 'name', 'label');
			logFilterCondition.activeOperatorListType = 'string';
		}
	},
	
	updateForm: function(item) {
		
		util.setF('lfc:log_fields_list', item.log_field);
		
		// Set the right operator list by selectLogFieldActor
		logFilterCondition.selectLogFieldActor();
		
		// Set the operator and literal
		util.setF('lfc:operator_list', item.operator);
		util.setF('lfc:value', item.literal);
	},
	
	closePanel: function() {
		
		logFilterCondition.validator.reset();
		logFiltersUtil.fixDivOverflow(false);
		logFilterCondition.panel.close();
	},


	newItem: function() {

		// invoked from logFilters.js
		logFilterCondition.mode = 'new';
		var panelLabel = langVar('lang_admin.log_filters.new_condition');
		var newItemObj = {};
		logFilterCondition.openPanel(panelLabel, newItemObj);
	},
	
	
	editItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		logFilterCondition.mode = 'edit';
		logFilterCondition.itemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.log_filters.edit_condition');
		
		// alert('editItem with itemIndex: ' + itemIndex);
		logFilterCondition.openPanel(panelLabel, item);
	},
	
	duplicateItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// alert('duplicateItem with itemIndex: ' + itemIndex);
		
		logFilterCondition.mode = 'duplicate';
		logFilterCondition.itemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.log_filters.edit_duplicated_condition');
		logFilterCondition.openPanel(panelLabel, item);
	},
	
	saveItem: function() {
		
		// We save the item object back to the items array in listcontrollerB
		
		var validator = logFilterCondition.validator;
		validator.reset();
		
		//
		// Validate
		//
		
		var logFieldName = validator.isValue('lfc:log_fields_list');
		var operator = util.getF('lfc:operator_list');
		var literal = '';
		
		if (logFieldName != '') {
		
			var activeOperatorListType = logFilterCondition.activeOperatorListType;
			
			if (operator == 'matches_regular_expression' || operator == '!matches_regular_expression') {
				
				literal = validator.isRegularExpression('lfc:value');
				
				// alert('matches_regular_expression validation - literal: ' + literal);
			}
			else if (operator.indexOf('epoc') != -1) {
				
				literal = util.getF('lfc:value');
				var dateTimePattern = /^[0-3]{1}[0-9]{1}\/{1}(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec){1}\/{1}[0-9]{4}\s{1}[0-2]{1}[0-9]{1}\:{1}[0-5]{1}[0-9]{1}\:{1}[0-5]{1}[0-9]{1}$/;
				
				if (!dateTimePattern.test(literal)) {
					var msg = langVar('lang_admin.log_filters.invalid_date_msg');
					validator.isCustom('lfc:value', msg);
				}
			}
			else if (operator == '<now') {
				// literal value must be integer >= 1
				literal = validator.isInteger('lfc:value', 1);
			}
			else {
				
				// Get database field type of selected log field
				var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
				var dbFieldType = logFieldItem.dbFieldType;
				
				if (dbFieldType == 'int') {
					literal = validator.isInteger('lfc:value');
				}
				else if (dbFieldType == 'float') {
					literal = validator.isFloat('lfc:value');
				}
				else {
					literal = validator.isValue('lfc:value');
				}
			}
		}
		
		//
		// Save the item
		//
		
		if (validator.allValid()) {
		
			var obj = {};
			obj.log_field = logFieldName;
			obj.operator = operator;
			obj.literal = literal;
			
			// Save the item to the actions list (listcontrollerB handles save of the object)
			logFilterLists.conditions.saveItem(logFilterCondition.mode, logFilterCondition.itemIndex, obj);
			
			logFilterCondition.closePanel();
		}
	},
	
	labelBuilder: function(conditionItem) {
		
		// alert('logFilterCondition.labelBuilder()');
		
		// Invoced from listcontrollerB
		// Returns a label (with or without HTML markup)
		
		// util.showObject(actionItem);
		
		var logFieldName = conditionItem.log_field;
		var operator = conditionItem.operator;
		var literal = conditionItem.literal;
		
		var logFieldItem = logFilters.logFieldsDb[util.h(logFieldName)];
		var logFieldLabel = '';
		if (logFieldItem != null) {
			logFieldLabel = logFieldItem.label;
		}
		else {
			logFieldLabel = '[ ' + langVar('lang_admin.log_filters.unknown_log_field') + ' ]';
		}
		
		var operatorLabel = logFilters.conditionOperatorLabelsDb['_' + operator];

		var label = '<strong>If</strong>: ' + logFieldLabel + ' <span>' + operatorLabel + '</span> "' + literal + '"';
	
		return label;
	}

};


