//
//
// logProcessingDS.js (Log Processing Distributed Server, used with logProcessing.js to add/edit listed servers)
//
//

var logProcessingDS = {
	
	panel: null,
	validator: null,
	
	
	//
	//
	// Active form parameters
	//
	//
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index
	
	// Default new item object
	newItemObj: {
		hostname: '',
		port: '',
		spawn: false
	},
	

	init: function() {
	
		logProcessingDS.validator = new util.Validator();
		
		var panelObj = {
			panelId: 'dlp_server:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 330,
			top: 120,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logProcessingDS.closePanel
		};
		
		logProcessingDS.panel = new util.Panel3(panelObj);
		
		var YE = YAHOO.util.Event;
		YE.addListener('dlp_server:okay_btn', 'click', logProcessingDS.saveItem);
		YE.addListener('dlp_server:cancel_btn', 'click', logProcessingDS.closePanel);
	},
	
	newItem: function() {
		
		// invoked from logProcessing.js
		logProcessingDS.mode = 'new';
		
		var newItemObj = util.cloneObject(logProcessingDS.newItemObj);		
		logProcessingDS.initForm(newItemObj);
	},
	
	editItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		logProcessingDS.mode = 'edit';
		logProcessingDS.itemIndex = itemIndex;
		
		// If there is no item yet then create one now.
		if (!item.hostname) {
			item = util.cloneObject(logProcessingDS.newItemObj);
		}
		
		// util.showObject(item);
		
		// alert('editItem with itemIndex: ' + itemIndex);
		logProcessingDS.initForm(item);
	},
	
	duplicateItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		logProcessingDS.mode = 'duplicate';
		logProcessingDS.itemIndex = itemIndex;
		
		// alert('editItem with itemIndex: ' + itemIndex);
		logProcessingDS.initForm(item);
	},
	
	openPanel: function() {
		
		var mode = logProcessingDS.mode;
		var panelLabel = '';
		
		if (mode == 'new') {
			panelLabel = langVar('lang_admin.log_processing.distributed.add_server');
		}
		else if (mode == 'edit') {
			panelLabel = langVar('lang_admin.log_processing.distributed.edit_server');
		}
		else {
			panelLabel = langVar('lang_admin.log_processing.distributed.edit_duplicated_server');
		}
		
		logProcessingDS.panel.open({label:panelLabel});
	},
	
	closePanel: function() {
		
		logProcessingDS.panel.close();
	},
	
	
	initForm: function(item) {
		
		logProcessingDS.validator.reset();
		
		util.setF('dlp_server:hostname', item.hostname);
		util.setF('dlp_server:port', item.port);
		util.setF('dlp_server:spawn', item.spawn);
		
		// Open the panel
		logProcessingDS.openPanel();
	},
	
	saveItem: function() {
		
		var validator = logProcessingDS.validator;
		var obj = {};
		
		obj.hostname = validator.isValue('dlp_server:hostname');
		obj.port = validator.isValue('dlp_server:port');
		obj.spawn = util.getF('dlp_server:spawn');
		
		if (validator.allValid()) {
		
			// Save the item to the servers list (listcontrollerB handles save of the object)
			logProcessingDSList.list.saveItem(logProcessingDS.mode, logProcessingDS.itemIndex, obj);
			logProcessingDS.closePanel();
		}
	},
	
	labelBuilder: function(serverItem) {
		
		// util.showObject(serverItem);
		
		var hostnameLabel = langVar('lang_admin.log_processing.distributed.hostname');
		var portLabel = langVar('lang_admin.log_processing.distributed.port');
		var spawnLabel = langVar('lang_admin.log_processing.distributed.spawn');
		var spawnValue = serverItem.spawn ? langVar('lang_admin.log_processing.distributed.yes') : langVar('lang_admin.log_processing.distributed.no');
		
		var label = hostnameLabel + ': <strong>' + serverItem.hostname + '</strong>, ';
		label += portLabel + ':  <strong>' + serverItem.port + '</strong>, ';
		label += spawnLabel + ':  <strong>' + spawnValue + '</strong>';

		return label;
	}
};
