//
// processLogs
//

var processLogs = function() {
	
	var YE = YAHOO.util.Event;
	
	function init() {

		YE.addListener('process_logs_btn', 'click', processLogs.startProcessLogs);
		
		// init progress.js
		progress.init({
			// decimalDivider: pageInfo.decimalDivider,
			isCancelTaskPermission: pageInfo.permissions.isCancelTask,
			profileName: pageInfo.profileName,
			calleeListener: processLogs.progressListener,
			isPanel: true
		});


		// Get matching log source files
		var pageToken = pageInfo.pageToken;
		var profileName = pageInfo.profileName;

		// Elements may be disabled upon error!
		util.enableE('process_logs:output_file');
		util.enableE('process_logs_btn');

		matchingFiles.init(pageToken, profileName);

		var url = '?dp=config_pages.process_logs.get_matching_files';
		url += '&p=' + profileName;
		var dat = 'v.fp.page_token=' + pageToken;

		util.serverPost(url, dat);
	}

	function showMatchingFilesResponse(dat) {

		matchingFiles.showFiles(dat);
	}

	function startProcessLogs() {

		var output_file = util.getF('process_logs:output_file');

		util.disableE('process_logs:output_file');
		util.disableE('process_logs_btn');
		util.hideE('process_logs:completed');

		var url = '?dp=templates.config_pages.process_logs.start_process_logs';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.output_file=' + encodeURIComponent(output_file);


		// Start simple progress
		progress.startProgress({
			progressType: 'simple',
			mainLabel: langVar('lang_admin.process_logs.label'),
			updateMainLabel: false,
			mainInfo: langVar('lang_admin.process_logs.process_logs_initiated_please_wait'),
			updateMainInfo: false
		});

		util.serverPost(url, dat);
	}

	function startProcessLogsResponse(dat) {

//		util.showObject(dat);
		var errorMessage = dat.errorMessage;

		if (errorMessage == '') {

			// Start progress
			progress.startProgress({
				progressType: 'process_logs',
				taskId: dat.taskId,
				mainLabel: langVar('lang_admin.process_logs.label'),
				updateMainLabel: false,
				mainInfo: langVar('lang_admin.process_logs.processing_logs'),
				updateMainInfo: false
			});
		}
		else {

			alert(errorMessage);
			progress.close();
			util.enableE('process_logs_btn');
		}
	}

	function progressListener(senderState) {

		// This is called from progress.js
//		util.showObject(senderState, 'progressListener in processLogs.js');

		// getDatabaseInfoData();
		progress.close();
		util.enableE('process_logs:output_file');
		util.enableE('process_logs_btn');
		util.showE('process_logs:completed');
	}


	//
	// Return global properties and methods
	//
	
	return {
		init: init,
		startProcessLogs: startProcessLogs,
		startProcessLogsResponse: startProcessLogsResponse,
		progressListener: progressListener,
		showMatchingFilesResponse: showMatchingFilesResponse
	}
}();
	
