//
// reportElementMF.js (Report Element Manage Fields)
//

var reportElementMF = {
	
	panel: null,
	
	defaultTabId: '', // defaultTabId in CustomizeReportElement panel
	
	reportElementDb: null, // A reference to the active reportElementDb
	
	/*
	allFieldsDb
	The allFieldsDb object contains all permitted fields for the given report element type,
	it also contains the column state of the active fields (show_column, etc.) and the state
	if the field is active.
	/*
	allFieldsDb = [
		{
		id: i0,
		name: page,
		showColumn: true,
		isActiveField: false --> defines if the field is part of report element columns or not.
		),
		{
		id: i26,
		name: hits
		showColumn: true,
		showPercentColumn: false,
		showBarColumn: false
		isActiveField: true
		},
		...
	*/
	allFieldsDb: [],
	
	/*
	activeFieldsDb
	The activeFields object contains all active field Ids in order. It does not contain any other property.
	activeFields = ['i0', 'i15', 'i18', 'i19', 'i21'];
	*/
	activeFieldsDb: [],
	
	// allFieldsSelectedItemId: '',
	// activeFieldsSelectedItemId: '',
	
	mainReportFieldName: '',
	
	// activeListType defines which of the two lists are active. It is used to handle the Add/Remove button event and label
	activeListType: '', // all_fields | active_fields
	
	init: function() {
		
		//
		// Init the Editor panel
		//
		
		var panelObj = {
			panelId: 'remf:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.report_editor.manage_fields'),
			left: 360,
			top: 145,
			zIndex: 40,
			isCover: true,
			isSticky: true,
			closeEvent: reportElementMF.closePanel
		};
		
		reportElementMF.panel = new util.Panel3(panelObj);
		
		//
		// Add events
		//
		
		var YE = YAHOO.util.Event;
		YE.addListener('remf:all_fields_list', 'click', reportElementMF.allFields.selectActor);
		YE.addListener('remf:active_fields_list', 'click', reportElementMF.activeFields.selectActor);
		
		YE.addListener('remf:add_remove_btn', 'click', reportElementMF.addRemoveItem);
		
		YE.addListener('remf:move_up_btn', 'click', reportElementMF.activeFields.moveItem);
		YE.addListener('remf:move_down_btn', 'click', reportElementMF.activeFields.moveItem);
	
		YE.addListener('remf:okay_btn', 'click', reportElementMF.saveFields);
		YE.addListener('remf:cancel_btn', 'click', reportElementMF.closePanel);
	},
	
	openPanel: function(defaultTabId) {
		
		// defaultTabId is required for Customize Report Element panel upon save.
		reportElementMF.defaultTabId = defaultTabId;
		
		// Reset objects and buttons
		reportElementMF.allFieldsDb = [];
		reportElementMF.activeFieldsDb = [];
		reportElementMF.reportElementDb = {};
		reportElementMF.activeListType = '';
		reportElementMF.allFields.selectedItemId = '';
		reportElementMF.activeFields.selectedItemIndex = -1; // Default is -1!
		util.disableE(['remf:add_remove_btn', 'remf:move_up_btn', 'remf:move_down_btn']);
		
		
		// Get a reference to the active reportElementDb type and columns
		var metaType = reportElement.activeMetaType;
		var metaTypeLabel = reportElement.reportElementMetaTypesDb[util.h(metaType)].label;
		var reportElementType = reportElement.activeReportElementType;
		var reportElementDb = reportElement.activeReportElementDbs[reportElementType];

//		console.log('reportElementType: ' + reportElementType);

		// util.showObject(reportElementDb);
		// var activeColumns = reportElementDb.columns;
		// util.showObject(activeColumns);
		
		reportElementMF.reportElementDb = reportElementDb;
		
		// Set main label
		var mainLabel = langVar('lang_admin.report_editor.report_element_type') + ': <strong>' + metaTypeLabel + '</strong>';
		var mainLabelElement = util.getE('remf:main_label');
		mainLabelElement.innerHTML = mainLabel;
		
		// Create allFields and activeFields object
		reportElementMF.createAllFieldsObject(reportElementDb.columns);
		reportElementMF.createActiveFieldsObject(reportElementDb.columns);
		
		// Build initial allFields and activeFields list
		reportElementMF.buildAllFieldsList();
		reportElementMF.buildActiveFieldsList();
		
		reportElementMF.panel.open();
	},
	
	closePanel: function() {
		
		reportElementMF.panel.close();
	},
	
	saveFields: function() {
		
		var allFieldsDb = reportElementMF.allFieldsDb;

		// util.showObject(allFieldsDb);

		var activeFieldsDb = reportElementMF.activeFieldsDb;
		var firstTextReportField = '';
		var columns = [];
		
		var reportElementType = reportElement.activeReportElementType;
		var isOverview = (reportElementType == 'overview');
		var isTable = (reportElementType == 'table');

		var i, len;
		
		for (i = 0, len = activeFieldsDb.length; i < len; i++) {
			
			var itemId = activeFieldsDb[i];
			var item = allFieldsDb[util.h(itemId)];
			
			var columnItem = {};
			columnItem.report_field = item.name;
			columnItem.show_column = item.showColumn;
			
			if (item.isAggregatingField) {
				
				if (!isOverview) {
					
					columnItem.show_percent_column = item.showPercentColumn;
					columnItem.show_bar_column = item.showBarColumn;
					columnItem.show_graph = item.showGraph;
				}
			}
			else if (firstTextReportField == '') {
				
				firstTextReportField = item.name;
			}
			
			columns[i] = columnItem;
		}

		if ((!isOverview && firstTextReportField != '') ||
			(isOverview && columns.length > 0)) {
			
			var reportElementDb = reportElementMF.reportElementDb;
			reportElementDb.columns = columns;

			// KHP 28/Feb/2013 - If a column matches the pivot report field
			// then reset the pivot table.
			if (isTable) {

				var pivotReportFieldName = reportElementDb.pivot_table.report_field;

				if (pivotReportFieldName != '') {

					for (i = 0, len = columns.length; i < len; i++) {

						if (columns[i].report_field == pivotReportFieldName) {
							// Field is already used in table, reset pivot table field
							reportElementDb.pivot_table.report_field = '';
							break;
						}
					}
				}
			}

			// Re-init the reportElementDb
			// Save changes to reportElementDb before reapplying creControl.init()
			// or all already done changes to the report element are lost!
			creControl.saveChanges();

			var obj = {};
			obj.defaultTabId = reportElementMF.defaultTabId;
			creControl.init(reportElementDb, obj);
			
			if (isTable) {

				// The name of the report element type may have changed when
				// a new text column has been added. So we update the report
				// element type list to be sure that it shows the report field label
				// of the first text column
				reportElement.display.updateMetaTypeList(firstTextReportField);
			}
			
			reportElementMF.closePanel();
		}
		else {
			
			var msg;
			
			if (!isOverview) {
				msg = langVar('lang_admin.report_editor.no_text_field_defined_msg');
			}
			else {
				msg = langVar('lang_admin.report_editor.no_field_defined_msg');
			}
			
			alert(msg);
		}
	},
	
	addRemoveItem: function() {
		
		if (reportElementMF.activeListType == 'all_fields') {
			// All fields
			reportElementMF.allFields.addItem();
		}
		else {
			// Active fields
			reportElementMF.activeFields.removeItem();
		}
	},
	

	//
	//
	//
	// allFields list handler
	//
	//
	//
	
	allFields: {
		
		selectedItemId: '',
		
		selectActor: function(evt) {
			
			// Invoked upon list click
			var element = evt.target || evt.srcElement;
	
			if (element.nodeName == 'LI') {
				
				var elementId = element.id;
				var dat = elementId.split(':');
				var itemId = dat[2];
				
				// alert('itemId: ' + itemId);
				reportElementMF.allFields.selectByItemId(itemId, element);
			}
		},
		
		selectByItemId: function(itemId, element) {
			
			// 'element' is optional, respectively it is only given when invoked via selectActor()
			// itemId may be empty, this is the case if no more item exists to select.
			
			function deselectSelectedItem(previousSelectedItemId) {
				var previousSelectedItemElement = util.getE('remf:all_fields_list:' + previousSelectedItemId);
				previousSelectedItemElement.className = '';
			}
			
			// Make allFields the active list if it isn't already
			if (reportElementMF.activeListType != 'all_fields') {
				
				// Set button label
				util.updateT('remf:add_remove_btn', langVar('lang_stats.btn.add') + ' >');
				
				// Deselect any activeFields list item
				reportElementMF.activeFields.deselectSilent();
				
				// Disable activeFields move buttons
				util.disableE(['remf:move_up_btn','remf:move_down_btn']);
							
				// Set list type
				reportElementMF.activeListType = 'all_fields';
			}
			
			var makeItemSelected;
			var previousSelectedItemId = reportElementMF.allFields.selectedItemId;
			
			// alert('previousSelectedItemId: ' + previousSelectedItemId);
			
			if (itemId != '') {

				if (!element) {
					var element = util.getE('remf:all_fields_list:' + itemId);
				}
				
				if (previousSelectedItemId != '') {
					
					if (previousSelectedItemId == itemId) {
						// Deselect the item
						makeItemSelected = false;
					}
					else {
						
						// A different item is already selected, deselect it
						deselectSelectedItem(previousSelectedItemId);
						makeItemSelected = true;
					}
				}
				else {
					makeItemSelected = true;
				}
				
				// alert('makeItemSelected: ' + makeItemSelected);
				element.className = makeItemSelected ? 'selected' : '';
			}
			else {
				// No new item is to select but we deselect any existing item
				makeItemSelected = false;
				if (previousSelectedItemId != '') {
					deselectSelectedItem(previousSelectedItemId);
				}
			}
			
			reportElementMF.allFields.selectedItemId = makeItemSelected ? itemId : '';
			util.enableE('remf:add_remove_btn', makeItemSelected);
		},
		
		deselectSilent: function() {
			
			// deselectSilent is called by activeFields only! It deselects any selected list item
			// without making allFields the active list.
			
			var previousSelectedItemId = reportElementMF.allFields.selectedItemId;
			
			if (previousSelectedItemId != '') {
				var previousSelectedItemElement = util.getE('remf:all_fields_list:' + previousSelectedItemId);
				previousSelectedItemElement.className = '';
				reportElementMF.allFields.selectedItemId = '';
			}
		},
		
		addItem: function() {
				
			// Adds the selected item to activeFields
			var allFieldsDb = reportElementMF.allFieldsDb;
			var selectedItemId = reportElementMF.allFields.selectedItemId;
			var selectedItem = allFieldsDb[util.h(selectedItemId)];
			
			// Select the next item if one exists, or the previous item if one exists,
			// or no item if this was the last in-active item
			// Create an array with all inactive items, including the selected item to
			// check which is the next selected item.
			
			var inactiveItemIds = [];
			var selectedItemIndex = 0;
			var nextSelectedItemId = '';
			
			for (var i = 0; i < allFieldsDb.length; i++) {
				
				var item = allFieldsDb[i];
				if (!item.isActiveField) {
					var j = inactiveItemIds.length;
					inactiveItemIds[j] = item.id;
					
					if (item.id == selectedItemId) {
						selectedItemIndex = j;
					}
				}
			}
			
			var numInactiveItems = inactiveItemIds.length;
			
			if (numInactiveItems > 1) {
				
				var nextSelectedItemIndex = (selectedItemIndex < numInactiveItems - 1) ? selectedItemIndex + 1 : selectedItemIndex - 1;
				nextSelectedItemId = inactiveItemIds[nextSelectedItemIndex];
			}
			
			//
			// Modify current selectedItem
			//
			
			selectedItem.isActiveField = true;
			
			// Hide the item in allFields list
			util.hideE('remf:all_fields_list:' + selectedItemId);
			
			// Select the next item'
			reportElementMF.allFields.selectByItemId(nextSelectedItemId);
			
			// Add the item to activeFields list
			reportElementMF.activeFields.addItem(selectedItem);
		}
	},
	
	//
	//
	//
	// activeFields list handler
	//
	//
	//
	
	activeFields: {
		
		selectedItemIndex: -1, // -1 is set if no item is selected!
		
		selectActor: function(evt) {
			
			// Invoked upon list click
			var element = evt.target || evt.srcElement;
	
			if (element.nodeName == 'LI') {
				
				var elementId = element.id;
				var dat = elementId.split(':');
				var itemIndex = parseInt(dat[2], 10);
				
				// alert('itemId: ' + itemId);
				reportElementMF.activeFields.selectByItemIndex(itemIndex, element);
			}
		},
		
		selectByItemIndex: function(itemIndex, element) {
						
			// 'element' is optional, respectively it is only given when invoked via selectActor()
			
			function deselectSelectedItem(previousSelectedItemIndex) {
				var previousSelectedItemElement = util.getE('remf:active_fields_list:' + previousSelectedItemIndex);
				previousSelectedItemElement.className = '';
			}
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			var makeItemSelected;
			var previousSelectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			
			// Make activeFields the active list if it isn't already
			if (reportElementMF.activeListType != 'active_fields') {
				
				// Set button label
				util.updateT('remf:add_remove_btn', '< ' + langVar('lang_stats.btn.remove'));
				
				// Deselect any allFields list item
				reportElementMF.allFields.deselectSilent();
				
				// Set list type
				reportElementMF.activeListType = 'active_fields';
			}
			
			if (itemIndex != -1) {

				if (!element) {
					var element = util.getE('remf:active_fields_list:' + itemIndex);
				}
				
				if (previousSelectedItemIndex != -1) {
				
					if (previousSelectedItemIndex == itemIndex) {
						// Deselect the item
						makeItemSelected = false;
					}
					else {
						
						// A different item is already selected, deselect it
						deselectSelectedItem(previousSelectedItemIndex);
						makeItemSelected = true;
					}
				}
				else {
					makeItemSelected = true;
				}
				
				// alert('makeItemSelected: ' + makeItemSelected);
				element.className = makeItemSelected ? 'selected' : '';
			}
			else {
				// No new item is to select but we deselect any existing item
				makeItemSelected = false;
				if (previousSelectedItemIndex != -1) {
					deselectSelectedItem(previousSelectedItemIndex);
				}
			}
			
			reportElementMF.activeFields.selectedItemIndex = makeItemSelected ? itemIndex : -1;
			
			// Handle Remove and Move buttons
			reportElementMF.activeFields.setButtonState(makeItemSelected);
		},
		
		setButtonState: function(isSelectedItem) {
			
			// setButtonState() is called within selectByItemIndex,
			// it handles Remove and Move buttons state
			
			// We allow to remove every field (text and numeric)
			var isRemove = isSelectedItem;
			var isMoveUp = false;
			var isMoveDown = false;
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			var activeFieldsDbLen = activeFieldsDb.length;
			
			if (isSelectedItem && activeFieldsDbLen > 1) {
				
				// Items can be moved in any order, i.e. agggegating fields
				// to top and non-aggregating fields to bottom.
				
				var selectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
				
				isMoveUp = (selectedItemIndex != 0);
				isMoveDown =  (selectedItemIndex != (activeFieldsDbLen - 1));
			}
			
			util.enableE('remf:add_remove_btn', isRemove);
			util.enableE('remf:move_up_btn', isMoveUp);
			util.enableE('remf:move_down_btn', isMoveDown);
		},
		
		deselectSilent: function() {
			
			// deselectSilent is called by allFields only! It deselects any selected list item
			// without making activeFields the active list.
			
			var previousSelectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			
			if (previousSelectedItemIndex != -1) {
				var previousSelectedItemElement = util.getE('remf:active_fields_list:' + previousSelectedItemIndex);
				previousSelectedItemElement.className = '';
				reportElementMF.activeFields.selectedItemIndex = -1;
			}
		},
		
		addItem: function(newAllFieldsItem) {
			
			// Invoked from allFields.addItem(). This adds the given item
			// to the activeFields list.
			
			// util.showObject(newAllFieldsItem, 'activeFields.addItem() - newAllFieldsItem argument');
			
			var newItemId = newAllFieldsItem.id;
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			
			// util.showObject(activeFieldsDb, 'activeFields.addItem() - activeFieldsDb');
			
			var insertAtItemIndex = -1;
			
			if (newAllFieldsItem.isAggregatingField) {
				// Insert item as last item in activeFieldsDb
				insertAtItemIndex = activeFieldsDb.length;
			}
			else {
				
				// This is a non-aggregating field. Insert the item 
				// after the last active non-aggregating field
				var allFieldsDb = reportElementMF.allFieldsDb;
				var activeFieldsDbHasAggregatingField = false;

				for (var i = 0; i < activeFieldsDb.length; i++) {
					
					var itemId = activeFieldsDb[i];
					var allFieldsItem = allFieldsDb[util.h(itemId)];
					
					// alert('allFieldsItem: ' + allFieldsItem);
					// util.showObject(allFieldsItem);
					
					if (allFieldsItem.isAggregatingField) {
						
						// This is the first aggreagting field,
						// we insert the new non-aggregating field at this point.
						
						insertAtItemIndex = i;
						activeFieldsDbHasAggregatingField = true;
						// alert('insertAtItemIndex: ' + insertAtItemIndex);
						break;
					}
				}
				
				if (!activeFieldsDbHasAggregatingField) {
					
					// The activeFieldsDb has no aggregating field yet, so we add the current field as last field
					insertAtItemIndex = activeFieldsDb.length;
				}
			}
			
			// Insert the item			
			activeFieldsDb.splice(insertAtItemIndex, 0, newItemId);
			
			// Rebuild the active fields list
			reportElementMF.buildActiveFieldsList();
		},
		
		removeItem: function() {
			
			// Invoked by remove button, removes the selected item in activeFields list.
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			var allFieldsDb = reportElementMF.allFieldsDb;
			
			var selectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			var selectedItemId = activeFieldsDb[selectedItemIndex];
			
			//var s = 'selectedItemIndex: ' + selectedItemIndex;
			//s += '\nselectedItemId: ' + selectedItemId;
			//alert(s);
			
			
			var nextSelectedItemIndex = -1;
			
			var numberOfItems = activeFieldsDb.length;
			
			// Check which item becomes selected next
			if (numberOfItems > 1) {
				nextSelectedItemIndex = (selectedItemIndex < numberOfItems - 1) ? selectedItemIndex : selectedItemIndex - 1;
			}
			
			// Remove selected li element
			var ul = util.getE('remf:active_fields_list');
			var li = util.getE('remf:active_fields_list:' + selectedItemIndex);
			ul.removeChild(li);
			// We must update the li element Ids so that they match
			// the index number of the activeFieldsDb items!
			var liElementItems = ul.getElementsByTagName('li');
			for (var i = 0; i < liElementItems.length; i++) {
				li = liElementItems[i];
				li.id = 'remf:active_fields_list:' + i;
			}
			
			// Remove selected item from activeFieldsDb
			activeFieldsDb.splice(selectedItemIndex, 1);
			
			// As the item has been removed there is no more selected item,
			// so reset selectedItemIndex!
			reportElementMF.activeFields.selectedItemIndex = -1;
			
			// Re-enable the removed element in allFields list
			util.showE('remf:all_fields_list:' + selectedItemId);
			// Update the allFieldsItem state
			var allFieldsItem = allFieldsDb[util.h(selectedItemId)];
			allFieldsItem.isActiveField = false;
						
			// Select the next item
			reportElementMF.activeFields.selectByItemIndex(nextSelectedItemIndex);
		},
		
		moveItem: function() {
			
			var isMoveUp = (this.id == 'remf:move_up_btn');
			
			var activeFieldsDb = reportElementMF.activeFieldsDb;
			
			var selectedItemIndex = reportElementMF.activeFields.selectedItemIndex;
			var selectedItemId = activeFieldsDb[selectedItemIndex];
			var selectedLiElement = util.getE('remf:active_fields_list:' + selectedItemIndex);
			var selectedTextElement = selectedLiElement.firstChild;
			var selectedLabel = selectedTextElement.nodeValue;
			
			// Get the itemIndex of the element which will be replaced with the selected element
			var nextItemIndex = isMoveUp ? selectedItemIndex - 1 : selectedItemIndex + 1;
			var nextLiElement = util.getE('remf:active_fields_list:' + nextItemIndex);
			var nextTextElement = nextLiElement.firstChild;
			var nextLabel = nextTextElement.nodeValue;
			
			// Update item position in activeFieldsDb
			activeFieldsDb.splice(selectedItemIndex, 1); // Removes selected itemId
			activeFieldsDb.splice(nextItemIndex, 0, selectedItemId); // Re-inserts selected itemId at new position
			
			// Replace the list labels
			var newSelectedTextElement = util.createT(nextLabel);
			var newNextTextElement = util.createT(selectedLabel);
			selectedLiElement.replaceChild(newSelectedTextElement, selectedTextElement);
			nextLiElement.replaceChild(newNextTextElement, nextTextElement);
			
			// Select the next item
			reportElementMF.activeFields.selectByItemIndex(nextItemIndex);
		}
	},
	
	//
	//
	// Utilities
	//
	//
	
	createAllFieldsObject: function(columns) {
		
		var queryFields = reports.getQueryFieldsDbRef();
		var reportElementType = reportElement.activeReportElementType;

		var isOverview = (reportElementType == 'overview');
		var isTable = (reportElementType == 'table');
		var isLogDetail = (reportElementType == 'log_detail');
		
		var allFieldsDb = [];
		
		// KHP 04/Oct/2010 - Create a tempColumns object,
		// it is used to verify if all columns exist in allFieldsDb.
		// If a column is missing for whatever reason in allFieldsDb 
		// then we must add it.
		var tempColumns = util.cloneObject(columns);
		util.createHash(tempColumns, 'report_field');
		
		var i;
		var column;
		var queryField;
		var queryFieldsLen = queryFields.length;
		
		for (i = 0; i < queryFieldsLen; i++) {
			
			queryField = queryFields[i];
			
//			util.showObject(queryField);

			if (isTable ||
				(isOverview && queryField.isAggregatingField) ||
				(isLogDetail && queryField.reportElementTypeSupport.log_detail)) {
				
				reportElementMF.addQueryFieldToAllFieldsDb(allFieldsDb, queryField);
			
				// Mark the added field in tempColumns
				column = tempColumns[util.h(queryField.name)];
				if (column != null) {
					column.columnExistsInAllFieldsDb = true;
				}
			}
		}
		
		// util.showObject(tempColumns, 'tempColumns');
		
		// Check if we need to add any column which exists in columns
		// but not in allFieldsDb
		var tempColumnsLen = tempColumns.length;
		for (i = 0; i < tempColumnsLen; i++) {
				
			column =  tempColumns[i];
			
			if (column.columnExistsInAllFieldsDb == null) {
				
				// Add this report field to allFieldsDb
				var reportFieldName = column.report_field;
				queryField = queryFields[util.h(reportFieldName)];
				reportElementMF.addQueryFieldToAllFieldsDb(allFieldsDb, queryField);
			}
		}
		
		// Set allFieldsDb
		reportElementMF.allFieldsDb = allFieldsDb;
		
		// Create hash
		util.createHash(reportElementMF.allFieldsDb, 'id');
	},

	addQueryFieldToAllFieldsDb: function(allFieldsDb, queryField) {

		var allFieldsDbLen = allFieldsDb.length;
		var isAggregatingField = queryField.isAggregatingField;

		// We add most of the query field properties to allFieldsDb for convenience

		var obj = {};
		obj.id = 'i' + allFieldsDbLen; // id is used for HTML element IDs
		obj.name = queryField.name;
		obj.label = queryField.label;
		obj.isAggregatingField = isAggregatingField;
		obj.category = queryField.category;
		// obj.derivationMethod = queryField.derivationMethod;
		obj.isExpression = queryField.isExpression;

		obj.isActiveField = false;

		//
		// Add field column properties because they will be used
		// as default values and will keep the values of already
		// existing column fields.
		//

		obj.showColumn = true;

		if (isAggregatingField) {
			obj.showPercentColumn = false;
			obj.showBarColumn = false;
			obj.showGraph = false;
		}

		allFieldsDb[allFieldsDbLen] = obj;
	},
	
	createActiveFieldsObject: function(columns) {
		
		// We create a tempColumns object because we require createHash on which we don't want to use on reportElementDb.		
		var reportElementType = reportElement.activeReportElementType;
		var isOverview = (reportElementType == 'overview');
		
		var tempColumns = util.cloneObject(columns);
		util.createHash(tempColumns, 'report_field');
		// util.showObject(tempColumns);
		
		var i;
		
		//
		// Update allFields according activeFields state
		//
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		
		for (i = 0; i < allFieldsDb.length; i++) {
			
			var allFieldsItem = allFieldsDb[i];
			var reportFieldName = allFieldsItem.name;
		
			// If the reportFieldName already exists in activeFields (equal tempColumns)
			// then update the allFieldsItem
		
			var column = tempColumns[util.h(reportFieldName)]
			
			if (column) {
				
				var itemId = allFieldsItem.id;
				
				// Add the itemId to the column in tempColumns because we need it for
				// the final activeFieldsDb
				column.id = itemId;
				
				allFieldsItem.isActiveField = true;
				allFieldsItem.showColumn = column.show_column;
				
				if (!isOverview && allFieldsItem.isAggregatingField) {
					allFieldsItem.showPercentColumn = column.show_percent_column;
					allFieldsItem.showBarColumn = column.show_bar_column;
					allFieldsItem.showGraph = column.show_graph;
				}
			}
		}
		
		//
		// Create the activeFieldsDb
		//
		
		var activeFieldsDb = [];
		
		for (i = 0; i < tempColumns.length; i++) {
			
			// util.showObject(tempColumns[i]);
			activeFieldsDb[i] = tempColumns[i].id;	
		}
				
		// Set activeFields
		reportElementMF.activeFieldsDb = activeFieldsDb;
	},
	
	buildAllFieldsList: function() {
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		
		var ul = util.getE('remf:all_fields_list');
		util.removeChildElements(ul);
		
		for (var i = 0; i < allFieldsDb.length; i++) {
			
			var allFieldsItem = allFieldsDb[i];
			
			// Hide the list item if the field is already active
			var displayStyle = allFieldsItem.isActiveField ? 'none' : 'list-item';
				
			var elementId = 'remf:all_fields_list:' + allFieldsItem.id;
			var li = util.createE('li', {id:elementId, display:displayStyle});
			var label = util.createT(allFieldsItem.label);
			util.chainE(ul, li, label);
		}
	},
	
	buildActiveFieldsList: function() {
				
		var activeFieldsDb = reportElementMF.activeFieldsDb;		
		
		var allFieldsDb = reportElementMF.allFieldsDb;
		
		// util.showObject(allFieldsDb);
		
		var ul = util.getE('remf:active_fields_list');
		util.removeChildElements(ul);
		
		for (var i = 0; i < activeFieldsDb.length; i++) {
			
			var itemId = activeFieldsDb[i];
						
			var item = allFieldsDb[util.h(itemId)];
						
			// In activeFields we use the index of activeFieldsDb for the ID!
			var elementId = 'remf:active_fields_list:' + i;
			var li = util.createE('li', {id:elementId});
			var label = util.createT(item.label);
			util.chainE(ul, li, label);
		}
	}
};
