/* global
    adminConfig: false,
    creSessionFields: false,
    langVar: false,
    listcontroller: false,
    optionInfo: false,
    pageInfo: false,
    profilesStorage: false,
    reportEditor: false,
    reportElement: false,
    reportElementsList: false,
    reportsUtil: false,
    toolbarButtonsDb: false,
    util: false,
    YAHOO: false */

var reports = (function() {

    'use strict';

    /*

    - Save Reports Menu if -----------------------------------------------------

        - report or report group has been moved to different position.
        - show_in_dynamic_reports or show_in_static_reports changed.
        - new report has been added or existing report has been duplicated.


    - Save Report and Report Elements if ---------------------------------------

        - When saving a report we send the report structure (including
          report elements structure).

          If isLoaded is false we only send the initial structure, else we send
          all properties.
    */


    var basicDataLoaded = false,

    intervalId,

    theList = null,

    itemsDb = [],
//    itemsDbBackup = [],

    // reportElementMetaTypesDb - contains all report element types by report field name or by type.
    // Note, the non-table report elements contain a prefix which distinguishes them from table report elements.
    // So for table report elements the name is equal the reportFieldName, for non-table report elements the
    // name is equal "__RET__" + report_element_type
    // This approach allows us to set and get meta type list values in a simple way
    // {name:__RET__overview, type:"overview", label:"Overview", },
    // {name:file_type, , type:"table", label:"File type"},
    // {name:page, type:"table", label:"Page"},
    // {name:__RET__log_detail, type:"table", label:"Page"},
    // ...

    reportElementMetaTypesDb = [],
    databaseFieldsDb = [], // Required for creSessionFields.js
    queryFieldsDb = [], // Contains all report fields with report field properties and additional information
    defaultGraphsDb = {},

    // sessionFieldsDb: [],
    // isBasicSessionReportsSupport: false,
    // isPageSessionReportsSupport: false,

    validator = null,
    //moveControl = null,

    // Create simple progress panel
    busyPanel = null,

    // mainButtons;
    saveChangesBtn = null,
    newReportGroupBtn = null,
    newReportBtn = null,
    deleteBtn = null,
    duplicateBtn = null,
//	undoAllChangesBtn = null,

    // noItemFormIsActive: false,
    reportElementsMoveControlIsPositioned = false,

    activeMainDisplayElementId = '',

    activeItem = {
        isLoaded: false,
        type: '', // type is report | report_group
        isModifiedReportElement: false,
        report_name: ''
    },

    // defaultReportItemDat is used to create a copy for reports editor
    // and when saving data from reports editor back to itemsDb
    defaultReportItemDat = {
//        report_name: '',
//        label_ori: '',
        sync_graph_axis_with_relative_date: false,
        description: '',
        header: '',
        footer: '',
        date_filter: '',
        filter_expression: '',
        filter_items: []
    },


    // isUpdateReportLinkList flag is set to true each time a new report is displayed
    // in the form. It is used in report elements editor to re-create an up to date
    // report list.
//	isUpdateReportLinkList = true;
    reportNameWithItemIdLookup = {},


    // - Global modified states ------------------------------------------------

    // Reports menu has been edited
    isModifiedReportsMenu = false,

    // One or more reports (or only report labels or report element structure)
    // have been modified.
    isModifiedReport = false,

    // Contains the report node names of deleted reports.
    deletedReportNames = [];


    function init() {

        // init new session
        // util.initSession();

        validator = new util.Validator();

        //
        // init toolbar buttons and form controls
        //

        saveChangesBtn = new util.ToolbarButton('save_changes', saveReportChanges, toolbarButtonsDb);
        newReportGroupBtn = new util.ToolbarButton('new_report_group', newReportGroupItem, toolbarButtonsDb);
        newReportBtn = new util.ToolbarButton('new_report', newReportItem, toolbarButtonsDb);
        duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
        deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
//		undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);

        var YE = YAHOO.util.Event;
        YE.addListener('reports:report_group_label', 'keyup', updateItemListLabel);
        YE.addListener('reports:report_label', 'keyup', updateItemListLabel);

        YE.addListener('reports:edit_report_properties_btn', 'click', editReport);

        YE.addListener('reports:new_report_element_btn', 'click', function() {

            var isLoaded = activeItem.isLoaded;

            reportElement.newItem(isLoaded);

            if (!isLoaded) {

                var selectedItem = theList.getSelectedItem();
                var reportName = selectedItem.dat.report_name;
                getReportData('new_report_element', reportName);
            }
        });

        //
        // Ignore/Disable buttons according RBAC
        //

        var permissions = pageInfo.permissions;

        if (permissions.isEdit) {

            if (!permissions.isAdd) {
                newReportGroupBtn.disableAndIgnore();
                newReportBtn.disableAndIgnore();
                duplicateBtn.disableAndIgnore();
            }

            if (!permissions.isDelete) {
                deleteBtn.disableAndIgnore();
            }

            // Register isModifiedPageHandler in adminConfig.js
            // (We don't check for modifications if there is no edit
            // permission because there is no Save button anyway!)
            adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
        }
        else {
            saveChangesBtn.disableAndIgnore();
            newReportGroupBtn.disableAndIgnore();
            newReportBtn.disableAndIgnore();
            duplicateBtn.disableAndIgnore();
            deleteBtn.disableAndIgnore();
//			undoAllChangesBtn.disableAndIgnore();
        }

        //
        // Create theList object
        //

        theList = new listcontroller.List({
            containerElementId: 'item_list_body',
            itemEvent: itemActivated,
            itemMovedEvent: listItemMoved,
            switchEvent: itemSwitchActivated,
            isSwitch1: true,
            isSwitch2: true,
            switchButtonElementId: 'reports:item_list:switch_btn',
            switchLabelElementId: 'reports:item_list:switch_label',
            switch1Label: langVar('lang_admin.report_editor.show_in_dynamic_reports'),
            switch2Label: langVar('lang_admin.report_editor.show_in_static_reports'),
            isMoveControl: true
        });

        //
        // init Report Element List, Report Editor, ...
        //

        reportElementsList.init();
        reportEditor.init();

        reportElement.init(
            queryFieldsDb,
            reportElementMetaTypesDb,
            defaultGraphsDb,
            itemsDb);


        // Init view available fields panels
        reportsUtil.initViewAvailableFields();


        // Init BusyPanel
        busyPanel = new util.BusyPanel();

        // init OptionInfo
        optionInfo.init();
    }


    function initMainDisplay() {

        // alert('initMainDisplay: ' + pageInfo.reportName);

        function getItemIdForGivenReportName(items, reportName) {

            // Returns the itemId for the given reportName,
            // or an empty string if the report_name does not exist.

            var itemId = '';

            for (var i = 0, max = items.length; i < max; i++) {
                var item = items[i];
                if (item.type === 'report') {
                    if (item.dat.report_name === reportName) {
                        itemId = item.id;
                    }
                }
                else {
                    var subitems = item.subitems;
                    for (var j = 0; j < subitems.length; j++) {
                        var subitem = subitems[j];
                        if (subitem.dat.report_name === reportName) {
                            itemId = subitem.id;
                            break;
                        }
                    }
                }
            }

            return itemId;
        }

        if (itemsDb.length > 0) {

            var defaultItemId = '';
            var reportName = pageInfo.reportName;

            if (reportName !== '') {

                // Check if the report exists and get the itemId
                defaultItemId = getItemIdForGivenReportName(itemsDb, reportName);

                // Reset the reportName because we don't want to select
                // any defaultReport when initMainDisplay() is inoked
                // upon undoChanges, etc.
                pageInfo.reportName = '';
            }

            // alert('defaultItemId: ' + defaultItemId);

            // If we don't have a defaultItemId yet get the first itemId.
            if (defaultItemId === '') {
                defaultItemId = theList.getFirstItemId();
            }

            setItem(defaultItemId);
        }
        else {

            // no item exists
            setMainDisplay('no_item_form');
        }

        // Update moveControl button state
        // theList.setMoveControlState();

        util.showE('form_section');
    }

    function setMainDisplay(displayElementId) {

        if (activeMainDisplayElementId !== displayElementId) {
            util.hideE(['no_item_form', 'report_group_form', 'report_form', 'loading_info', 'saving_info']);
            util.showE(displayElementId);
            activeMainDisplayElementId = displayElementId;

            // Update form label
            var formLabel = '';
            if (displayElementId === 'report_group_form') {
                formLabel = langVar('lang_admin.report_editor.report_group');
            }
            else if (displayElementId === 'report_form') {
                formLabel = langVar('lang_admin.report_editor.report');
            }
            else {
                formLabel = '-';
            }

            util.updateT('item_form_label', formLabel);
        }
    }


    function handleInitialDataAndBasicDataLoaded() {

        // Called via setInterval, initial report data are
        // already loaded. init starts as soon as basic data are
        // loaded as well.

        if (basicDataLoaded) {

            clearInterval(intervalId);

            //
            // Init
            //

            init();
            theList.init(itemsDb);
            initMainDisplay();

            // Set final toolbar state
            saveChangesBtn.enable();
    //		undoAllChangesBtn.enable();
            newReportGroupBtn.enable();
            newReportBtn.enable();
            updateToolbarButtons(); // handles Duplicate and Delete

            adminConfig.setItemListSize();
            YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);

            pageInfo.initComplete = true;
        }
    }


    function getInitialReportData() {

        util.showE('loading_info');

        if (!pageInfo.exitActive) {


            // Start parallel request for basic report data
            // TODO - check if queryFieldsDb, etc. can be saved in local storage,
            // and where loading time is lost.
            getBasicReportData();

            // Init help
            util.helpWindow.init('');

            var url = '?dp=config_pages.reports.get_initial_report_data';
            url += '&p=' + pageInfo.profileName;
            var dat = 'v.fp.page_token=' + pageInfo.pageToken;

            util.serverPost(url, dat);
        }
    }

    function updateItemsDb(items/*, reportNameWithItemIdLookup*/) {

        // Add report "label" property to itemsDb.
        // label_ori will not change, only label is editable.

        // Replace the report_name in link_to_report of report elements
        // with the unique itemId. This will be converted back to report_name
        // upon saving the report data.

        // Add default isLoaded and isModified property

        for (var i = 0, numItems = items.length; i < numItems; i++) {

            var item = items[i];
            var itemDat = item.dat;
            var reportElements = null;
            var reportElement = null;
            var reportLink = '';

            if (item.type === 'report') {

                // Set basic properties
                item.isLoaded = false;

                // isModified is set only for loaded report properties and
                // report elements, it is not set if only the label becomes
                // modified.
                item.isModified = false;

                // Update basic properties
                itemDat.report_name = itemDat.report_name_ori;
                itemDat.label = itemDat.label_ori;
            }
            else {
                // Report Group, Recursively call updateItemsDb for subitems
                updateItemsDb(item.subitems/*, reportNameWithItemIdLookup*/);
            }
        }
    }

    function getInitialReportDataResponse(dat) {

//        util.showObject(dat);

        itemsDb = dat.reportsDb;

        updateItemsDb(itemsDb);
//        util.showObject(itemsDb);

        // Create reportNameWithItemIdLookup
        reportNameWithItemIdLookup = getReportNameWithItemIdLookup(itemsDb);
//        util.showObject(reportNameWithItemIdLookup);

        // Handle initialization once basic data are loaded as well.
        intervalId = setInterval(handleInitialDataAndBasicDataLoaded, 80);
    }

    function getBasicReportData() {

        if (!pageInfo.exitActive) {

//            console.log('getBasicReportData()');

            var url = '?dp=config_pages.reports.get_basic_report_data';
            url += '&p=' + pageInfo.profileName;
            var dat = 'v.fp.page_token=' + pageInfo.pageToken;

            util.serverPost(url, dat);
        }
    }

    function getBasicReportDataResponse(dat) {

//        console.log('getBasicReportDataResponse()');

        queryFieldsDb = dat.queryFieldsDb;
        util.createHash(queryFieldsDb, 'name');
        // util.showObject('queryFieldsDb');

        databaseFieldsDb = dat.databaseFieldsDb;

        reportElementMetaTypesDb = dat.reportElementMetaTypesDb;
//            util.showObject(reportElementMetaTypesDb, 'reportElementMetaTypesDb');

        util.createHash(reportElementMetaTypesDb, 'name');

        defaultGraphsDb = dat.defaultGraphsDb;
//           util.showObject(defaultGraphsDb, 'defaultGraphsDb');

        basicDataLoaded = true;
    }

    function getReportData(invokedBy, reportName) {

        // If reportName is not defined then use the selected
        // reportName.

//        console.log('getReportData()');
//        console.log('reportName: ' + reportName);

        // This loads one or more reports.

        //  invokedBy:  edit_report
        //              duplicate_report
        //              duplicate_report_group
        //              new_report_element
        //              edit_report_element
        //              duplicate_report_element

        //
        //  reports:   'report_name'
        //              ['report name 1, report name 2',...]
        //

        if (!pageInfo.exitActive) {

            busyPanel.showLoading();

            var loadBasicData = (reportElementMetaTypesDb.length === 0);

            var url = '?dp=config_pages.reports.get_report_data';
            url += '&p=' + pageInfo.profileName;
            var dat = 'v.fp.page_token=' + pageInfo.pageToken;

            // type and itemId is resend in response
            dat += '&v.fp.invoked_by=' + invokedBy;

            // Handle multiple reportName(s)
            if (reportName) {

                reportName = util.isArray(reportName) ? reportName : [reportName];
            }
            else {
                // Get selected reportName
                var selectedItem = theList.getSelectedItem();
                reportName = [selectedItem.dat.report_name];
            }

            for (var i = 0, numItems = reportName.length; i < numItems; i++) {

                dat += '&v.fp.required_reports.' + i + '=' + encodeURIComponent(reportName[i]);
            }

            util.serverPost(url, dat);
        }
    }

    function getReportDataResponse(dat) {

//        util.showObject(dat);

//        console.log('getReportDataResponse()');

        var invokedBy = dat.invokedBy;
        var reportsDb = dat.reportsDb;
        var reportNameOri = '';
        var reportName = '';
        var labelOri = '';
        var label = '';
        var subitems;
        var subitem;

//        console.log('invokedBy: ' + invokedBy);

        // Copy report(s) data to existing itemsDb
        var selectedItem = theList.getSelectedItem();

//            util.showObject(selectedItem, 'getReportDataResponse() - selectedItem');

        if (selectedItem.type === 'report') {

            // Copy single report

            // Keep existing properties
            reportNameOri = selectedItem.dat.report_name_ori;
            reportName = selectedItem.dat.report_name;
            labelOri = selectedItem.dat.label_ori;
            label = selectedItem.dat.label;

//            console.log('loaded report: ' + reportName);


            // Get modified report elements if report element has been
            // deleted or moved.
            if (activeItem.isModifiedReportElement) {

                selectedItem.dat.report_elements = reportElementsList.list.getItemsClone();
            }

            // Copy new report data
            selectedItem.dat = getReportsDataCopy(selectedItem.dat, reportsDb['_' + reportName]);

            // Re-add existing properties
            selectedItem.dat.report_name_ori = reportNameOri;
            selectedItem.dat.report_name = reportName;
            selectedItem.dat.label = label;
            selectedItem.dat.label_ori = labelOri;

            // Handle report_link in report_elements
//            util.showObject(selectedItem.dat.report_elements, "1");
            updateReportLinkInReportElements(selectedItem.dat.report_elements);
//            util.showObject(selectedItem.dat.report_elements, "2");

            // Update isLoaded state
            selectedItem.isLoaded = true;
            activeItem.isLoaded = true;

            // Re-create the report element list
            reportElementsList.list.compose(selectedItem.dat.report_elements);
        }
        else {

            // Copy loaded reports to reports in report group
            subitems = selectedItem.subitems;

            for (var i = 0, numSubitems = subitems.length; i < numSubitems; i++) {

                subitem = subitems[i];

                if (!subitem.isLoaded) {

                    // Keep existing properties
                    reportNameOri = subitem.dat.report_name_ori;
                    reportName = subitem.dat.report_name;
                    labelOri = subitem.dat.label_ori;
                    label = subitem.dat.label;

                    // Copy new report data
                    subitem.dat = getReportsDataCopy(subitem.dat, reportsDb['_' + reportName]);

                    // Re-add existing properties
                    subitem.dat.report_name_ori = reportNameOri;
                    subitem.dat.report_name = reportName;
                    subitem.dat.label_ori = labelOri;
                    subitem.dat.label = label;

                    // Handle report_link in report_elements
                    updateReportLinkInReportElements(subitem.dat.report_elements);

                    // Update isLoaded state
                    subitem.isLoaded = true;
                }
            }
        }

//            util.showObject(selectedItem, 'getReportDataResponse() - selectedItem after report copy');

        //
        // Continue initial action
        //

        switch (invokedBy) {

            case 'edit':

                reportEditor.updateForm(selectedItem.dat);
                break;

            case 'duplicate':

                // duplicate report or report_group
                duplicateItemWithLoadedReports();
                break;

            case 'new_report_element':

                reportElement.newItemAfterReportLoaded();
                break;

            case 'edit_report_element':

                reportElement.editItemAfterReportLoaded();
                break;

            case 'duplicate_report_element':

                reportElement.duplicateItemAfterReportLoaded();
                break;
        }

        busyPanel.stop();
    }


    function updateToolbarButtons() {

        var isItems = theList.isItems();
        deleteBtn.enable(isItems);
        duplicateBtn.enable(isItems);
    }

    function updateItemListLabel(evt) {

        var element = evt.target || evt.srcElement;
        var label = element.value;
//		console.log('label: ' + label);
//		setTimeout('setItemListLabel("' + label + '")', 150);

        setTimeout(function() {

            setItemListLabel(label);

        }, 150);
    }

    function setItemListLabel(label) {

        if (label === '') {
            label = '-';
        }

        theList.updateListLabel(label);
    }

    function itemActivated(itemId) {

        // util.showE('transparent_cover');
        if (validateActiveItem()) {
            setItem(itemId);
        }
    }

    function itemSwitchActivated(itemId) {

        // A user clicked on an item checkbox (not necessarily a selected item)
        // and we may need to update the ViewReports link.

        // This also counts as modified report structure.

        // alert('itemSwitchActivated() - itemId: ' + itemId);
        var activeSwitchKey = theList.getActiveSwitchKey();

        // If checkboxes are set for dynamic reports
        if (activeSwitchKey === 'switch1') {

            // alert('itemSwitchActivated() - itemId: ' + itemId);
            setViewReportsLink();
        }

        isModifiedReportsMenu = true;
    }

    function setItem(itemId) {

        // selects active item in list and displays the form

        // alert('set item: ' + itemId);
        // Set session is active
        // util.sessionActive();

        theList.selectItem(itemId);
        updateForm();
    }

    function newReportGroupItem() {

        if (validateActiveItem()) {

            var newItemId = theList.getNewItemId();
            var newReportGroupLabel = langVar('lang_admin.general.new_report_group');

            var newReportGroupObj = {
                id: newItemId,
                type: 'report_group',
                switch1: true,
                switch2: true,
                label: newReportGroupLabel,
                dat: {
                    label: newReportGroupLabel,
                    label_ori: ''
                },
                subitems: []
            };

            // util.showObject(newReportGroupObj);

            var insertDirective = {insertAtRootLevel: true};

            theList.newItem(newReportGroupObj, insertDirective);
            setItem(newItemId);
            updateToolbarButtons();

            isModifiedReportsMenu = true;
        }
    }

    function newReportItem() {

        // alert('newReportItem()');

        if (validateActiveItem()) {

            var newItemId = theList.getNewItemId();
            var newReportLabel = langVar('lang_admin.general.new_report');

            var newReportObj = {
                id: newItemId,
                type: 'report',
                switch1: true,
                switch2: true,
                isLoaded: true,
                isModified: true,
                label: newReportLabel,
                dat: {
                    report_name_ori: '', // report node name
                    report_name: '',
                    label_ori: '',
                    label: newReportLabel,
    //				show_header_bar: true,
                    description: '',
                    header: '',
                    footer: '',
                    date_filter: '',
                    filter_expression: '',
                    filter_items: [],
                    sync_graph_axis_with_relative_date: false,
                    report_elements: []
                }
            };

            // util.showObject(newReportObj);

            var insertDirective = {};

            if (activeItem.type === 'report_group') {
                insertDirective.insertAsFirstSubItem = true;
            }
            else {
                insertDirective.insertAsItemOrSubItem = true;
            }

            theList.newItem(newReportObj, insertDirective);
            setItem(newItemId);
            updateToolbarButtons();

            isModifiedReport = true;
            isModifiedReportsMenu = true;
            reportElement.setIsOutOfDateReportLinkList();
        }
    }

    function duplicateItem() {

        if (validateActiveItem()) {

            // If a report or reports of a report group are not yet loaded
            // we need to load reports before the item becomes duplicated.

            var selectedItem = theList.getSelectedItem();
            var isAllLoaded = false;
            var reportName;

            if (selectedItem.type === 'report') {

                // Single report
                isAllLoaded = selectedItem.isLoaded;
                reportName = selectedItem.dat.report_name;
            }
            else {

                 // Check if one or more reports of the group needs
                 // to be loaded.
                reportName = [];

                var subitems = selectedItem.subitems;
                var subitem;

                for (var i = 0, numSubitems = subitems.length; i < numSubitems; i++) {

                    subitem = subitems[i];

                    if (!subitem.isLoaded) {

                        reportName.push(subitem.dat.report_name);
                    }
                }

//                util.showObject(reportName, 'reports to load of report_group');

                isAllLoaded = reportName.length === 0;
            }


            if (isAllLoaded) {

                duplicateItemWithLoadedReports();
            }
            else {

                // Load reports
                getReportData('duplicate', reportName);
            }

            reportElement.setIsOutOfDateReportLinkList();
        }
    }

    function duplicateItemWithLoadedReports() {

        var clonedItemId = theList.cloneItem();

        // Update cloned item properties
        // TODO, we have to update all subitems if this is a report group!
//        theList.setItemDatValue(clonedItemId, 'report_name', '');
//        theList.setItemDatValue(clonedItemId, 'label_ori', '');

        var clonedItem = theList.getItem(clonedItemId);
        clonedItem.dat.label_ori = '';

        if (clonedItem.type === 'report') {

            clonedItem.dat.report_name_ori = '';
            clonedItem.dat.report_name = '';
        }
        else {

            // report_group, reset report_name in each report
            var subitems = clonedItem.subitems;
            var subitem;

            for (var i = 0, numSubitems = subitems.length; i < numSubitems; i++) {

                subitem = subitems[i];
                subitem.dat.report_name_ori = '';
                subitem.dat.report_name = '';
            }
        }

//        util.showObject(clonedItem, 'The cloned report');

        setItem(clonedItemId);

        isModifiedReport = true;
        isModifiedReportsMenu = true;
    }

    function deleteItem() {

        // Tracks deleted report items.
        // New items are not tracked because they are not saved anyway.

        var selectedItem = theList.getSelectedItem();

        var reportName = '';
        if (selectedItem.type === 'report_group') {
            var subitems = selectedItem.subitems;
            for (var i = 0, numSubitems = subitems.length; i < numSubitems; i++) {
                reportName = subitems[i].dat.report_name;
                if (reportName !== '') {
                    deletedReportNames.push(reportName);
                }
            }
        }
        else {
            // This is a report item
            reportName = selectedItem.dat.report_name;
            if (reportName !== '') {
                deletedReportNames.push(reportName);
            }
        }

        //
        // Delete item
        //

        var nextItemIdToBeSelected = theList.deleteItem();

        if (nextItemIdToBeSelected) {

            // reset the validator in case that the deleted item indicated an error
            validator.reset();
            setItem(nextItemIdToBeSelected);
        }
        else {
            // Last item has been deleted, so no item exists.
            activeItem.type = '';
            initMainDisplay();
        }

        isModifiedReportsMenu = true;
        reportElement.setIsOutOfDateReportLinkList();
    }

    function updateForm() {

        var item = theList.getSelectedItem();
        var itemDat = item.dat;

//        util.showObject(item, 'updateForm() - item');
        // Reset isUpdateReportLinkList to true. This ensures that a new list is created
        // when opening the report element editor next time.

//		isUpdateReportLinkList = true;

        var type = item.type;
        activeItem.type = item.type;
//        activeItem.label_ori = itemDat.label_ori;
//        activeItem.label = itemDat.label;

        var displayElementId = '';

        var activeReportName = '';
        var isShowInDynamicReports = false;

        // Reset
        activeItem.isLoaded = (type === 'report') ? item.isLoaded : true;
        activeItem.isModifiedReportElement = false;

        if (type === 'report_group') {

            //
            // Update report group
            //

            displayElementId = 'report_group_form';
            util.setF('reports:report_group_label', itemDat.label);
        }
        else {

            //
            // Update report label
            // Other report data are handled in editReport
            //

            activeItem.report_name = itemDat.report_name;

            displayElementId = 'report_form';

            util.setF('reports:report_label', itemDat.label);


            //
            // Handle report elements list
            //

            reportElementsList.list.compose(itemDat.report_elements);
        }

        //
        // Update display
        //

        if (activeMainDisplayElementId !== displayElementId) {
            setMainDisplay(displayElementId);
        }

        //
        // Update View Reports link
        //

        setViewReportsLink();


        //
        // Position the Report Elements Move Control
        //

        if (!reportElementsMoveControlIsPositioned && type === 'report') {

            // We need to give it some time, else we don't get the right list position
//			var s = 'reports:report_element_list:div';
//			setTimeout('reportElementsList.moveControl.setPosition("' + s + '")', 250);

            setTimeout(function() {
                reportElementsList.moveControl.setPosition('reports:report_element_list:div');
            }, 250);

            reportElementsMoveControlIsPositioned = true;
        }
    }

    function validateActiveItem() {

        // Only validate if isEdit permission and if items

        if (pageInfo.permissions.isEdit && theList.isItems()) {

            var isReportGroup = (activeItem.type === 'report_group');

            // Get the unchanged item
            var item = theList.getSelectedItem();
            var itemDat = item.dat;
            var label = '';

            if (isReportGroup) {

                // Report group
                label = validator.isValue('reports:report_group_label');
            }
            else {

                // Report
                // Handle the label.

                // Note, duplicate labels are allowed.
                label = validator.isValue('reports:report_label');

                // Report data have already been saved via reports editor.
            }

//            console.log('label: ' + label);

            if (validator.allValid()) {

                // Because report data may not yet be loaded we don't
                // use the listcontroller saveItem() method but handle
                // saving data manually.

//                console.log('label_ori: ' + itemDat.label_ori);

                if (label !== itemDat.label_ori) {

                    // Save new label
                    itemDat.label = label;

                    if (!isReportGroup) {

                        isModifiedReport = true;
                        item.isModified = true;

                        reportElement.setIsOutOfDateReportLinkList();
                    }

                    // Set isModifiedReportsMenu for reportGroup and
                    // report because a report label change will most
                    // likely cause a new report node name.

                    isModifiedReportsMenu = true;
                }

//                console.log('isModifiedReportsMenu: ' + isModifiedReportsMenu);
//                console.log('isModifiedReport: ' + isModifiedReport);

                // Report properties have already been saved
                // to itemsDat via reports editor.

                // Save report elements if they have been modified.
                // Note, delete and move report element is possible
                // without loaded report data.

                if (!isReportGroup && activeItem.isModifiedReportElement) {

                    // Get a copy of the report element data.
                    itemDat.report_elements = reportElementsList.list.getItemsClone();

                    item.isModified = true;
                    isModifiedReport = true;
                }

                return true;
            }

            return false;
        }
        else {
            // No item exists or no isEdit permission
            return true;
        }
    }

    function setViewReportsLink() {

        // This updates the "View Reports" link in the navigation
        // so that the selected report is the default report when
        // viewing reports.

        // Make sure the link exists!
        var theLinkElement = util.getE('rc_nav_view_reports:btn');

        if (theLinkElement) {

            var reportNameToView = '';
            var defaultDateFilter = pageInfo.defaultDateFilter;

            if (activeItem.type === 'report') {

                // We only set the reportName if is not a new report (because it isn't saved yet)
                // and if it is active in dynamic reports

                var isNew = theList.getSelectedItemIsNew();
                var isActive = theList.getSelectedItemIsSwitch1(); // This already considers any parent switch to be true as well

                if (!isNew && isActive) {
                    reportNameToView = activeItem.report_name;
                }
            }

//            console.log('reportNameToView: ' + reportNameToView);

            // else it is a group for which no viewReportsName is defined

            // Set the link
            var href = '?dp=reports&p=' + pageInfo.profileName;

            if (defaultDateFilter !== '') {
                href += '&df=' + defaultDateFilter;
            }

            if (reportNameToView !== '') {
                href += '&rn=' + reportNameToView;
            }
            theLinkElement.href = href;
        }
    }

    //
    //
    // Edit report
    //
    //

    function editReport() {

        var item = theList.getSelectedItem();
        var itemDat = item.dat;
        var itemDatCopy = null;

        if (item.isLoaded) {

            reportEditor.openPanel(itemDat);
        }
        else {

            // Open report editor without data
            reportEditor.openPanel();

            // Load data
            getReportData('edit', itemDat.report_name);
        }
    }

//    function getEditReportData(itemDat) {
//
//        // Create copy of report data
//        var itemDatCopy = {};
//
//        // Write current itemDat data to defaultReportItemDat object so that
//        // they can be read by reportsEditor.js
//
//        for (var prop in defaultReportItemDat) {
//            if (defaultReportItemDat.hasOwnProperty(prop)) {
//                itemDatCopy[prop] = itemDat[prop];
//            }
//        }
//
//        return itemDatCopy;
//    }

    function saveEditReportChanges(reportDat) {

        // Called from reports editor
        var item = theList.getSelectedItem();
        var itemDat = item.dat;

        // Save changes to itemDat
        for (var prop in reportDat) {

            if (reportDat.hasOwnProperty(prop)) {
                itemDat[prop] = util.cloneObject(reportDat[prop]);
            }
        }

        item.isModified = true;
        isModifiedReport = true;
    }


    //
    //
    // saveReportChanges utilities
    //
    //

    function getReportElementItemDat(itemIdWithReportNameLookup, path, item, reportElementCount) {

        function addNumberOfRows() {

            dat += path + '.number_of_rows=' + item.number_of_rows + '&';
        }

        function addColumns() {

            var columns = item.columns;

            for (var i = 0; i < columns.length; i++) {

                var columnsObj = columns[i];
                var columnsPath = path + '.columns.' + i;

                for (var prop in columnsObj) {

                    if (columnsObj.hasOwnProperty(prop)) {

                        dat += columnsPath + '.' + prop + '=' + columnsObj[prop] + '&';
                    }
                }

                // Add position node
                dat += columnsPath + '.position=' + i + '&';
            }
        }

        function addSessionFields() {

            var sessionFields = creSessionFields.getSessionFields();

            // util.showObject(sessionFields);

            for (var sessionFieldName in sessionFields) {

                if (sessionFields.hasOwnProperty(sessionFieldName) &&
                    sessionFields[sessionFieldName][reportElementType]) {

                    // Add session field value
                    dat += path + '.' + sessionFieldName + '=' + encodeURIComponent(item[sessionFieldName]) + '&';
                }
            }
        }

        var reportElementType = item.type;
        var isLogDetail = (reportElementType === 'log_detail');
        var prop;
        var graphsObj;
        var pivotTableObj;
        var dat;

        // Note, item.report_link contains the itemId of the report, convert to report_name!
        var reportLinkItemId = item.report_link;
        var reportLink = '';

        if (itemIdWithReportNameLookup.hasOwnProperty(reportLinkItemId)) {
            reportLink = itemIdWithReportNameLookup[reportLinkItemId];
    //		util.showObject({reportLinkItemId:reportLinkItemId, reportLink:reportLink});
        }

        dat = path + '.position=' + reportElementCount + '&'; // Used to sort reports in order on server side
        dat += path + '.label=' + encodeURIComponent(item.label) + '&';
        dat += path + '.label_ori=' + encodeURIComponent(item.label_ori) + '&';
        dat += path + '.type=' + item.type + '&';
        dat += path + '.display_side_by_side=' + item.display_side_by_side + '&';
        dat += path + '.show_header_bar=' + item.show_header_bar + '&';
        dat += path + '.report_link=' + reportLink + '&';
        dat += path + '.description=' + encodeURIComponent(item.description) + '&';
        dat += path + '.header=' + encodeURIComponent(item.header) + '&';
        dat += path + '.footer=' + encodeURIComponent(item.footer) + '&';
        dat += path + '.date_filter.df=' + encodeURIComponent(item.date_filter) + '&';
        dat += path + '.filter.expression=' + encodeURIComponent(item.filter_expression) + '&';

        switch (reportElementType) {

            case 'overview':

                dat += path + '.compact_view=' + item.compact_view + '&';
                addColumns();
                break;

            case 'table':

                addNumberOfRows();
                dat += path + '.show_graphs=' + item.show_graphs + '&';
                dat += path + '.show_table=' + item.show_table + '&';

                dat += path + '.display_graphs_side_by_side=' + item.display_graphs_side_by_side + '&';
    //			dat += path + '.display_graphs_table_side_by_side=' + item.display_graphs_table_side_by_side + '&';
                dat += path + '.maximum_table_bar_graph_length=' + item.maximum_table_bar_graph_length + '&';

                dat += path + '.omit_parenthesized_items=' + item.omit_parenthesized_items + '&';
                dat += path + '.use_overview_for_totals=' + item.use_overview_for_totals + '&';
                dat += path + '.table_filter_expression=' + encodeURIComponent(item.table_filter_expression) + '&';
                dat += path + '.sort_by=' + encodeURIComponent(item.sort_by) + '&';
                dat += path + '.sort_direction=' + item.sort_direction + '&';
                dat += path + '.show_remainder_row=' + item.show_remainder_row + '&';
                dat += path + '.show_averages_row=' + item.show_averages_row + '&';
                dat += path + '.show_min_row=' + item.show_min_row + '&';
                dat += path + '.show_max_row=' + item.show_max_row + '&';
                dat += path + '.show_totals_row=' + item.show_totals_row + '&';

                graphsObj = item.graphs;
                pivotTableObj = item.pivot_table;

                // util.showObject(graphsObj);

                for (prop in graphsObj) {

                    if (graphsObj.hasOwnProperty(prop)) {

                        dat += path + '.graphs.' + prop + '=' + graphsObj[prop] + '&';
                    }

                }

                for (prop in pivotTableObj) {

                    if (pivotTableObj.hasOwnProperty(prop)) {

                        dat += path + '.pivot_table.' + prop + '=' + pivotTableObj[prop] + '&';
                    }
                }

                addColumns();
                break;

            case 'log_detail':

                addNumberOfRows();
                dat += path + '.show_graphs=false&';
                dat += path + '.show_table=true&';
                dat += path + '.table_filter_expression=' + encodeURIComponent(item.table_filter_expression) + '&';
                dat += path + '.sort_by=' + encodeURIComponent(item.sort_by) + '&';
                dat += path + '.sort_direction=' + item.sort_direction + '&';
                addColumns();
                break;

            case 'sessions_overview':

                addSessionFields();
                break;

            case 'session_paths':

                addNumberOfRows();
                addSessionFields();
                dat += path + '.number_of_rows_expanded=' + item.number_of_rows_expanded + '&';
                dat += path + '.expand_paths_greater_than=' + item.expand_paths_greater_than + '&';
                break;

            case 'session_page_paths':

                addNumberOfRows();
                addSessionFields();
                break;
        }

        // util.showObject(dat);

        return dat;
    }

    function getInitialReportElementItemDat(path, item, reportElementCount) {

        // Returns minimal report element data if report has not
        // been loaded. Report element position could have changed
        // or report element could have been deleted without
        // loading all report data.

        var dat = path + '.position=' + reportElementCount + '&'; // Used to sort reports in order on server side
        dat += path + '.label=' + encodeURIComponent(item.label) + '&';
        dat += path + '.node_name_ori=' + encodeURIComponent(item.node_name_ori) + '&';

        return dat;
    }

    function getFilterItemsDat(path, filterItems) {

        var dat = '';
        var itemValue;

        if (filterItems.length > 0) {

            for (var i = 0; i < filterItems.length; i++) {

                var itemPath = path + '.filter.filter_items.' + i;
                var item = filterItems[i];

                for (var prop in item) {

                    dat += itemPath + '.' + prop + '=' + util.getEncodedURIComponent(item[prop]) + '&';
                }
            }
        }
        else {

            // No filter items
            dat = path + '.filter.filter_items=&';
        }

        return dat;
    }

    function getReportItemDat(itemIdWithReportNameLookup, item) {

        // If isLoaded is false this is a modified report where only initial
        // data exists and where only initial data have been modified.
        var isLoaded = item.isLoaded;
        var itemDat = item.dat;
        var reportNameOri = itemDat.report_name_ori;
        var reportName = itemDat.report_name;

        var path = 'v.fp.reports.' + item.id;

        var dat = path + '.is_loaded=' + isLoaded + '&'; // if contains all report data
        dat += path + '.report_name_ori=' + encodeURIComponent(reportNameOri) + '&';
        dat += path + '.report_name=' + encodeURIComponent(reportName) + '&';
        dat += path + '.label=' + encodeURIComponent(itemDat.label) + '&';

        if (isLoaded) {

            dat += path + '.description=' + encodeURIComponent(itemDat.description) + '&';
            dat += path + '.header=' + encodeURIComponent(itemDat.header) + '&';
            dat += path + '.footer=' + encodeURIComponent(itemDat.footer) + '&';
            dat += path + '.date_filter.df=' + encodeURIComponent(itemDat.date_filter) + '&';
            dat += path + '.filter.expression=' + encodeURIComponent(itemDat.filter_expression) + '&';

            dat += getFilterItemsDat(path, itemDat.filter_items);

            dat += path + '.sync_graph_axis_with_relative_date=' + itemDat.sync_graph_axis_with_relative_date + '&';
        }

        // util.showObject(item);

        var reportElements = itemDat.report_elements;

        if (reportElements.length > 0) {

            for (var i = 0, numItems = reportElements.length; i < numItems; i++) {

                var reportElementPath = path + '.report_elements.' + i;

                if (isLoaded) {

                    dat += getReportElementItemDat(itemIdWithReportNameLookup, reportElementPath, reportElements[i], i);
                }
                else {

                    dat += getInitialReportElementItemDat(reportElementPath, reportElements[i], i);
                }
            }
        }
        else {

            // No report element exists
            dat += path + '.report_elements=&';
        }

        return dat;
    }

    function getMenuItemDat(path, position, item) {

        // util.showObject(item);

        var dat = '';
        dat += path + '.position=' + position + '&';
        dat += path + '.report=' + item.dat.report_name + '&';
        dat += path + '.show_in_dynamic_reports=' + item.switch1 + '&';
        dat += path + '.show_in_static_reports=' + item.switch2 + '&';

        return dat;
    }

    function getReportsDat(itemIdWithReportNameLookup, items) {

//        console.log('getReportsDat()');

//        util.showObject(items);

        // This returns modified reports
        var reportsDat = '';
        var reportItemDat;
        var item;

        for (var i = 0, numItems = items.length; i < numItems; i++) {

            item = items[i];

            if (item.type === 'report') {

//                console.log('item.dat.report_name: ' + item.dat.report_name);
//                console.log('item.isModified: ' + item.isModified);

                if (item.isModified) {

                    reportsDat += getReportItemDat(itemIdWithReportNameLookup, item);
                }
            }
            else {

                // report_group
                reportsDat += getReportsDat(itemIdWithReportNameLookup, item.subitems);
            }
        }

//        console.log('-----------------------');
//        console.log('reportsDat: ' + reportsDat);
//        console.log('-----------------------');

        return reportsDat;
    }

    function getReportsMenuDat() {

        var reportsMenuDat = '';
        var menuItemDat;

        if (itemsDb.length > 0) {

            for (var i = 0, numItems = itemsDb.length; i < numItems; i++) {

                var item = itemsDb[i];
                var type = item.type;
                var itemDat = item.dat;

                var reportsMenuPath = 'v.fp.reports_menu.' + i;

                if (type === 'report_group') {

                    // This is a report group with zero or more report items

                    reportsMenuDat += reportsMenuPath + '.position=' + i + '&';
                    reportsMenuDat += reportsMenuPath + '.label=' + encodeURIComponent(itemDat.label) + '&';
                    reportsMenuDat += reportsMenuPath + '.label_ori=' + encodeURIComponent(itemDat.label_ori) + '&';
                    reportsMenuDat += reportsMenuPath + '.show_in_dynamic_reports=' + item.switch1 + '&';
                    reportsMenuDat += reportsMenuPath + '.show_in_static_reports=' + item.switch2 + '&';

                    var subitemsDb = item.subitems;

                    if (subitemsDb.length > 0) {

                        for (var j = 0, numSubitems = subitemsDb.length; j < numSubitems; j++) {

                            // This is a single menu item with a single report
                            var subitem = subitemsDb[j];
                            var subItemDat = subitem.dat;

                            var reportsMenuItemsPath = reportsMenuPath + '.items.' + j;

                            menuItemDat = getMenuItemDat(reportsMenuItemsPath, j, subitem);
                            reportsMenuDat += menuItemDat;
                        }
                    }
                    else {

                        // This is a report group without any reports.
                        reportsMenuDat += reportsMenuPath + '.items=&';
                        // reportsDat += reportsMenuDat;
                    }
                }
                else {

                    // This is a single menu item with a single report
                    menuItemDat = getMenuItemDat(reportsMenuPath, i, item);
                    reportsMenuDat += menuItemDat;
                }
            }
        }
        else {

            // No item exists
            reportsMenuDat = 'v.fp.reports_menu=&';
        }

        return reportsMenuDat;
    }

    function getDeletedReportNamesDat() {

        var numDeletedReports = deletedReportNames.length;
        var reportName = '';
        var path = 'v.fp.deleted_reports';
        var dat = '';

        if (numDeletedReports > 0) {

            for (var i = 0; i < numDeletedReports; i++) {

                reportName = deletedReportNames[i];
                dat += path + '.' + encodeURIComponent(reportName) + '=&';
            }
        }
        else {
            dat = path + '=&';
        }

        return dat;
    }


    //
    //
    // saveReportChanges
    //
    //

    function saveReportChanges() {

//        console.log('saveReportChanges()');

        if (validateActiveItem()) {

            var numDeletedReports = deletedReportNames.length;

//            console.log('isModifiedReportsMenu: ' + isModifiedReportsMenu);
//            console.log('isModifiedReport: ' + isModifiedReport);
//            console.log('numDeletedReports: ' + numDeletedReports);

            if (isModifiedReportsMenu || isModifiedReport ||
                numDeletedReports > 0) {

                util.hideE('form_section');
                util.showE('saving_info');

                var itemIdWithReportNameLookup = {};

                var reportsMenuDat = '';
                var reportsDat = '';


                // Handle report node names, this is also required for
                // reports menu changes!

                verifyAndCreateReportNodeNames(itemsDb);

                if (isModifiedReportsMenu) {

                    reportsMenuDat = getReportsMenuDat();
                }
                else {

                    reportsMenuDat = 'v.fp.reports_menu=&';
                }

                if (isModifiedReport) {

                    // Create itemId with report_name lookup which will be used
                    // to convert any id given in a report_element.report_link to
                    // its report_name. Note, this must be done after verifyAndCreateReportNodeNames()!
                    itemIdWithReportNameLookup = getItemIdWithReportNameLookup(itemsDb);

//                    util.showObject(itemIdWithReportNameLookup);

                    reportsDat = getReportsDat(itemIdWithReportNameLookup, itemsDb);
//                    console.log('FINAL reportsDat: ' + reportsDat);
                }

                // If !isModifiedReport if getReportsDat() does not return any
                // data because no modified report exists (could have been
                // deleted).

                if (reportsDat === '') {

                    reportsDat = 'v.fp.reports=&';
                }

                var deletedReportNamesDat = getDeletedReportNamesDat();
                deletedReportNamesDat = deletedReportNamesDat.replace(/&$/, '');

                var url = '?dp=config_pages.reports.save_reports';
                url += '&p=' + pageInfo.profileName;

                var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
                dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
                dat += 'v.fp.is_modified_reports_menu=' + isModifiedReportsMenu + '&';
                dat += reportsDat + reportsMenuDat + deletedReportNamesDat;

                pageInfo.saveActive = true;

                util.serverPost(url, dat);
            }
            else {

//                console.log('No changes to save');
                // TODO - show message without alert!
                alert(langVar('lang_stats.general.no_changes_to_save'));
            }
        }
    }

    function saveReportChangesResponse(dat) {

        //
        // Reset items
        //

        isModifiedReport = false;
        isModifiedReportsMenu = false;
        deletedReportNames = [];

        resetReportItemsDb(itemsDb);

        // Re-create reportNameWithItemIdLookup
        reportNameWithItemIdLookup = getReportNameWithItemIdLookup(itemsDb);

        // Reset itemsDbBackup
//		itemsDbBackup = util.cloneObject(itemsDb);

        //
        // Before we reset isModified we must update the form
        // of the current selected item because it may not match
        // the latest itemsDb data
        //

        if (itemsDb.length > 0) {
            updateForm();
        }
        else {
            // If updateForm() isn't executed we must handle setViewReportsLink
            setViewReportsLink();
        }

        //
        // Reset isModified
        //

//        theList.resetIsModified();

        // Update profilesListChecksum checksum
        profilesStorage.update(dat.profileChanges);

        //
        // Recover the display
        //

        pageInfo.saveActive = false;

        util.hideE('saving_info');
        util.showE('form_section');
    }

    function resetReportItemsDb(items) {

        // Updates the current itemsDb with saved report data
        for (var i = 0, numItems = items.length; i < numItems; i++) {

            var item = items[i];

            item.isModified = false;
            item.isNew = false;

            if (item.type === 'report') {

                var itemDat = item.dat;
                itemDat.label_ori = itemDat.label;
                itemDat.report_name_ori = itemDat.report_name;
            }
            else {

                // Report Group, Recursively call resetReportItemsDb for subitems
                resetReportItemsDb(item.subitems);
            }
        }
    }

// KHP 2014/09/15 - undoAllChanges is deprecated, will be removed from
// all toolbars!

//	function undoAllChanges() {
//
//		deletedReportNames = [];
//		itemsDb = util.cloneObject(itemsDbBackup);
//		theList.init(itemsDb);
//		initMainDisplay();
//	}

    //
    // verify and create report node names
    //

    function verifyAndCreateReportNodeNames(itemsDb) {

        // Checks if we need to add new report node names.

        var reportNodeNameItems = getValidExistingNodeNames(itemsDb);

//        console.log('number of reportNodeNameItems: ' + reportNodeNameItems.length);
//        util.showObject(reportNodeNameItems);

        setFinalReportNodeNames(itemsDb, reportNodeNameItems);
    }

    function getValidExistingNodeNames(items, reportNodeNameItems) {

        // This checks for existing valid node names. A node name is valid
        // if it exists and if the label is equal label_ori. In this case we
        // keep the existing node name.

        reportNodeNameItems = reportNodeNameItems || [];

        for (var i = 0, numItems = items.length; i < numItems; i++) {

            var item = items[i];

            if (item.type === 'report') {

                var itemDat = item.dat;

                if ((itemDat.report_name !== '') && (itemDat.label === itemDat.label_ori)) {

                    // This is a valid node name, add it to reportNodeNameItems
                    reportNodeNameItems.push(itemDat.report_name) ;
                }
            }
            else {

                // This is a report group, check subitems recursively
                getValidExistingNodeNames(item.subitems, reportNodeNameItems);
            }
        }

        return reportNodeNameItems;
    }

    function setFinalReportNodeNames(items, reportNodeNameItems) {

        // This sets the final report node names to be used upon saving the data
        // Note, we let the server know if we send a new node name or not.

        for (var i = 0, numItems = items.length; i < numItems; i++) {

            var item = items[i];

            if (item.type === 'report') {

                var itemDat = item.dat;
                var reportName = ''; // The final report node name

                if ((itemDat.report_name !== '') && (itemDat.label === itemDat.label_ori)) {

                    // Use existing node name, so we add this node name to reportNodeNameItems
                    reportName = itemDat.report_name;
                }
                else {

                    // Create a new report node name
                    reportName = util.labelToUniqueNodeName(itemDat.label, reportNodeNameItems, 'report');

                    // And final node name reportNodeNameItems
                    reportNodeNameItems.push(reportName);

                    // TODO, if an existing node name changed then we should track it
                    // and modify i.e. report links in report elements, etc.
                }

                // Add final report name to itemDat
                itemDat.report_name = reportName;
            }
            else {
                // This is a report group, check subitems recursively
                setFinalReportNodeNames(item.subitems, reportNodeNameItems);
            }
        }
    }


    //
    // report_link utilities
    //

    function updateReportLinkInReportElements(reportElements) {

        // This replaces the report_name with itemId in the report_link
        // property in report_elements.

        var reportElement;
        var reportLink;

        for (var i = 0, numItems = reportElements.length; i < numItems; i++) {

            reportElement = reportElements[i];

            // Update the report_link
            reportLink = reportElement.report_link;

            if (reportLink !== '') {

                // Note, the report given in reportLink might not anymore exist

                if (reportNameWithItemIdLookup.hasOwnProperty('_' + reportLink)) {

                    // Replace report_name with itemId
                    reportElement.report_link = reportNameWithItemIdLookup['_' + reportLink];
                }
                else {

                    // Reset report_link
                    reportElement.report_link = '';
                }
            }
        }
    }

    function getReportNameWithItemIdLookup(items, lookup) {

        return getItemIdReportNameLookup(items, lookup, true);
    }

    function getItemIdWithReportNameLookup(items, lookup) {

        return getItemIdReportNameLookup(items, lookup, false);
    }

    function getItemIdReportNameLookup(items, lookup, isReportNameWithItemId) {

        // This creates a lookup for report names and itemId's
         // Report name properties start with an underscore
        // (_)report_name = itemId
        // AND
        // itemId = report_name

        lookup = lookup || {};

        var itemId;
        var reportName;

        for (var i = 0, numItems = items.length; i < numItems; i++) {

            var item = items[i];

            if (item.type === 'report') {

                itemId = item.id;
                reportName = item.dat.report_name;

                if (isReportNameWithItemId) {

                    lookup['_' + reportName] = itemId;
                }
                else {

                    lookup[itemId] = reportName;
                }
            }
            else {
                // Report Group, call itself.
                getItemIdReportNameLookup(
                    item.subitems,
                    lookup,
                    isReportNameWithItemId
                );
            }
        }

        return lookup;
    }


    //
    // Misc Utilities
    //

    function getReportsDataCopy(existingReportDat, newReportDat) {

        // This returns a new report object which includes all of the
        // existing report data and the just loaded report data.

        // It also considers a changed order of report elements in
        // case that the initial report elements structure has been moved
        // without all loaded report data.

        var obj = {};
        var prop;

        // Copy report data which already exists, except report_elements
        for (prop in existingReportDat) {

            if (existingReportDat.hasOwnProperty(prop) &&
                prop !== 'report_elements') {

                obj[prop] = util.cloneObject(existingReportDat[prop]);
            }
        }

        // Copy all properties from newReportDat which
        // do not yet exist in existingReportDat.

        for (prop in newReportDat) {

            if (newReportDat.hasOwnProperty(prop) &&
                !obj.hasOwnProperty(prop) &&
                prop !== 'report_elements') {

                obj[prop] = util.cloneObject(newReportDat[prop]);
            }
        }

        // Copy report elements
        var existingReportElements = existingReportDat.report_elements;
        var newReportElements = newReportDat.report_elements;
        var finalReportElements = [];
        var finalReportElement;
        var reportElementItem;
        var newReportElementItem;
        var reportElementNodeName;
        var h = util.h;

//        util.showObject(newReportElements, 'newReportElements before applying hash');

        util.createHash(newReportElements, 'node_name_ori');

//         util.showObject(newReportElements, 'newReportElements after applying hash');

        for (var i = 0, numItems = existingReportElements.length; i < numItems; i++) {

            reportElementItem = existingReportElements[i];
            reportElementNodeName = reportElementItem.node_name_ori;

            newReportElementItem = newReportElements[h(reportElementNodeName)];

//            util.showObject(newReportElementItem, 'newReportElementItem');

            finalReportElement = util.cloneObject(newReportElementItem);
            finalReportElements.push(finalReportElement);
        }

        obj.report_elements = finalReportElements;

        return obj;
    }


    function getIsModifiedPage() {

        // Note, isModified will be false if only the active item has been edited
        // but has an error, hence we also check "if (!validateActiveItem() ..."

        // KHP 09/Oct/2014
        // theList.getIsModified() is not anymore valid for reports because
        // reports are loaded on demand.
//        return (!validateActiveItem() || theList.getIsModified());

        return (!validateActiveItem() ||
            isModifiedReportsMenu ||
            isModifiedReport ||
            deletedReportNames.length > 0)
    }

    function getSelectedReportItemId() {

        var item = theList.getSelectedItem();
        return item.id;
    }

    function getIsLoaded() {

        return activeItem.isLoaded;
    }

    function getQueryFieldsDbRef() {

        return queryFieldsDb;
    }

    function getDatabaseFieldsDbRef() {

        return databaseFieldsDb;
    }

    function setIsModifiedReportElement() {

//        console.log('setIsModifiedReportElement()');
        activeItem.isModifiedReportElement = true;
    }

    function listItemMoved() {

        // This is called from listcontroller when a list item has been moved.
        //console.log('reports.js listItemMoved()');
        isModifiedReportsMenu = true;
    }


    return {
        getInitialReportData: getInitialReportData,
        getInitialReportDataResponse: getInitialReportDataResponse,
        getBasicReportDataResponse: getBasicReportDataResponse,
        getReportData: getReportData,
        getReportDataResponse: getReportDataResponse,
        saveEditReportChanges: saveEditReportChanges,
        saveReportChangesResponse: saveReportChangesResponse,
        getSelectedReportItemId: getSelectedReportItemId,
        getIsLoaded: getIsLoaded,
        getQueryFieldsDbRef: getQueryFieldsDbRef,
        getDatabaseFieldsDbRef: getDatabaseFieldsDbRef,
        setIsModifiedReportElement: setIsModifiedReportElement,
        listItemMoved: listItemMoved
    };

}());