//
// globalFilter
//

/* global
	ReportFiltersPanel: false */


var globalFilter = (function() {

	'use strict';
	
	// Note, each time the window is opened we load a fresh filter set
	// because we don't know if the filter set has been changed in another
	// tab or window between two openings.
	
	var YE = YAHOO.util.Event,
		panel = null,
		tabs = null,

		activeTabId = '',
		isJustAddedFilterItems = false,

		justAddedFiltersPanel = null,
		savedFiltersPanel = null,
		recentlyAddedFiltersPanel = null,

		// isModified indicates that we have to send and re-assemble
		// the corresponding filters, else we only send the isActive state
		// to the server.
		isModifiedRecentlyAddedFilterItems = false;

	function init() {
		
		var panelObj = {
			panelId:'global_filter:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.global_filter.filters'),
			left: 20,
			top: 50,
			zIndex: 20,
			isCover: true,
			closeEvent: close
		};
		
		panel = new util.Panel3(panelObj);
			
		// Init tabs
		var tabList = ['gf:just_added_filter_items:tab', 'gf:saved_filters:tab', 'gf:recently_added_filter_items:tab'];
		tabs = new util.Tabs3('gf:tabs', tabList, tabActivated);
//		tabs.setSequence(tabList, 'gf:saved_filters:tab');


		// Init filter panels
//		reportFiltersAndGroups.init();

		justAddedFiltersPanel = new ReportFiltersPanel({
			containerId: 'gf:just_added_filter_items:panel',
			moveItems: true,
			moveToSavedCallback: globalFilter.moveToSaved,
			filterItemsSelectCallback: globalFilter.setNumberOfActiveItems
		});

		savedFiltersPanel = new ReportFiltersPanel({
			containerId: 'gf:saved_filters:panel',
			addItems: true,
			filterItemsSelectCallback: globalFilter.setNumberOfActiveItems
		});

		recentlyAddedFiltersPanel = new ReportFiltersPanel({
			containerId: 'gf:recently_added_filter_items:panel',
			moveItems: true,
			moveToSavedCallback: globalFilter.moveToSaved,
			filterItemsSelectCallback: globalFilter.setNumberOfActiveItems
		});

		YE.addListener('global_filter:save_btn', 'click', saveFiltersDb);
		YE.addListener('global_filter:cancel_btn', 'click', close);
	}
	
	function open() {
		
		getFiltersDb();
		
		if (panel == null) {
			// Initialize the global filter panel
			init();
		}
		
		// hide the tab bar until all data are loaded
		util.hideE('gf:tab_bar');
		
		util.hideE(['gf:just_added_filter_items:panel', 'gf:saved_filters:panel', 'gf:recently_added_filter_items:panel']);
		util.showE('gf:loading_info');

		panel.open();
	}
	
	function close() {
		
		panel.close();
	}

	function setNumberOfActiveItems() {
		
		// This updates the state of number of items
				
		if (isJustAddedFilterItems) {
			var activeJustAddedItemsNum = justAddedFiltersPanel.getNumOfActiveItems();
			util.updateT('gf:just_added_filter_items:active_item_count', activeJustAddedItemsNum);
		}

		var activeSavedFiltersNum = savedFiltersPanel.getNumOfActiveItems();
		util.updateT('gf:saved_filters:active_item_count', activeSavedFiltersNum);
		
		var activeRecentlyAddedItemsNum = recentlyAddedFiltersPanel.getNumOfActiveItems();
		util.updateT('gf:recently_added_filter_items:active_item_count', activeRecentlyAddedItemsNum);
	}

	function tabActivated(tabId) {
		
//		var tabId = this.id;
	
		util.hideE(['gf:just_added_filter_items:panel', 'gf:saved_filters:panel', 'gf:recently_added_filter_items:panel']);
		
		tabs.setActiveTab(tabId);
		
		if (tabId == 'gf:just_added_filter_items:tab') {
			util.showE('gf:just_added_filter_items:panel');
		}
		else if (tabId == 'gf:saved_filters:tab') {
			util.showE('gf:saved_filters:panel');			
		}
		else {
			util.showE('gf:recently_added_filter_items:panel');
		}
		
		activeTabId = tabId;
	}
	
	function getFiltersDb() {
		
		var url = '?dp=statistics.filters.global_filter.get_filters_db';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		
		if (!zoomControl.isZoomItems) {
		
			dat += 'v.fp.is_zoom_items=false&';
			dat += 'v.fp.active_filter_id=' + reportInfo.filterId;
		}
		else {
			var zoomInfoId = zoomControl.getZoomInfoId();
			dat += zoomControl.getZoomItemsDat();
		}
		
		util.serverPost(url, dat);
	}
	
	function getFiltersDbResponse(dat) {

//        util.showObject(dat, 'getFiltersDbResponse()');
		
		util.hideE('gf:loading_info');
		
		var justAddedFilterItems = dat.justAddedFilterItems;
		var savedFilterItems = dat.savedFilterItems;
		var savedFilterGroups = dat.savedFilterGroups;
		var recentlyAddedFilterItems = dat.recentlyAddedFilterItems;

		isJustAddedFilterItems = (justAddedFilterItems.length > 0);

		var profileName = reportInfo.profileName;
		var queryFieldsDb = reportInfo.queryFieldsDb;

		justAddedFiltersPanel.initFilters(profileName, queryFieldsDb, justAddedFilterItems, []);
		savedFiltersPanel.initFilters(profileName, queryFieldsDb, savedFilterItems, savedFilterGroups);
		recentlyAddedFiltersPanel.initFilters(profileName, queryFieldsDb, recentlyAddedFilterItems, []);

		// Before we build the lists we have to add a unique object id
		// to each filter item and add labels to all filter items
		// which are not groups and not expression items.

		
		//
		// Set initial tab state and set the item list width
		//
		
		util.hideE(['gf:just_added_filter_items:panel', 'gf:saved_filters:panel', 'gf:recently_added_filter_items:panel']);

		var activePanelId;
//		var containerRegion;
		var tabList = ['gf:just_added_filter_items:tab', 'gf:saved_filters:tab', 'gf:recently_added_filter_items:tab'];
		
		if (justAddedFilterItems.length > 0) {

			activeTabId = 'gf:just_added_filter_items:tab';
//			tabs.show('gf:just_added_filter_items:tab');

			activePanelId = 'gf:just_added_filter_items:panel';
		}
		else {
			activeTabId = 'gf:saved_filters:tab';
//			tabs.hide('gf:just_added_filter_items:tab');

			// Remove gf:just_added_filter_items:tab from tabList
			tabList.splice(0, 1);

			activePanelId = 'gf:saved_filters:panel';
		}
		
//		tabs.setActiveTab(activeTabId);
		tabs.setSequence(tabList, activeTabId);
	
		// Show the tabs bar and panel
		util.showE('gf:tab_bar');
		util.showE(activePanelId);
		
		
		// The item list table width must be set due IE quirks.
		// We set the table to the div container width minus scrollbar width.
//		containerRegion = YAHOO.util.Dom.getRegion(activePanelId);
//		var tableWidth = (containerRegion.right - containerRegion.left - 24) + 'px';
//		setTableWidth('gf:just_added_filter_items:container', tableWidth);

		// Disabled setTableWidth for saved_filters due different HTML markup
//		setTableWidth('gf:saved_filters:container', tableWidth);

//		setTableWidth('gf:recently_added_filter_items:container', tableWidth);
		
		// Set controls state
		setNumberOfActiveItems();
	}
	

//	function buildUnsavedFilterRows(idPrefix, containerId, filterItems) {
//
//		// Build the unsaved filter rows. We clean up the container from any
//		// existing rows, sort the filterItems Array and build the rows
//
//		removeFilterRows(containerId);
//
//		if (filterItems.length > 0) {
//
//			// Sort the filterItems
//			filterItems.sort(repFiltersUtil.compareLabels);
//
//			// Create the rows
//			var tbody = util.getE(containerId);
//
//			for (var i = 0; i < filterItems.length; i++) {
//
//				var item = filterItems[i];
//				var tr = getFilterRow(idPrefix, item.id, item.label);
//				tbody.appendChild(tr);
//			}
//
//			repFiltersUtil.updateCheckboxState(filterItems, idPrefix);
//		}
//	}

//	function getFilterRow(idPrefix, itemId, itemLabel) {
//
//		// alert('itemId: ' + itemId + '\nlabel: ' + itemLabel);
//
//		// Builds an item row and returns a tr element reference
//
//		// idPrefix is: just_added_fi | recently_added_fi
//
//		// The idPrefix will be used for item ids which will have the format:
//		// just_added_fi:row:i0
//		// just_added_fi:cb:i0
//		// just_added_fi:move:i0
//		// just_added_fi:delete:i0
//
//		// var tbody = util.getE(tbodyId);
//
//		// Note, items are checked in a separate function due IE bug
//
//		var tr = document.createElement('tr');
//		tr.id = idPrefix + ':row:' + itemId;
//
//		//
//		// Add the checkbox cell
//		//
//
//		var td2 = document.createElement('td');
//		td2.style.width = '14px';
//
//		var input = document.createElement('input');
//		var inputId = idPrefix + ':cb:' + itemId;
//		input.id = inputId;
//		input.type = 'checkbox';
//		input.value = '';
//
//		td2.appendChild(input);
//
//		YE.addListener(input, 'click', toggleFilterActiveState);
//
//
//		tr.appendChild(td2);
//
//
//		//
//		// Add the label cell
//		//
//
//		var td3 = document.createElement('td');
//		td3.style.whiteSpace = 'normal';
//		var labelTxt = document.createTextNode(itemLabel);
//
//
//		// Add the label
//
//		var label = document.createElement('label');
//		label.id = idPrefix + ':label:' + itemId;
//		label.htmlFor = inputId;
//
//		label.appendChild(labelTxt);
//		td3.appendChild(label);
//
//		tr.appendChild(td3);
//
//		//
//		// Add the controls cell
//		//
//
//		var td4 = document.createElement('td');
//		td4.className = 'filter-item-controls';
//		var a1;
//		var a1Txt;
//		var separatorLine1 = document.createTextNode(' | ');
//
//
//		// just added item or recently added item, add Move to Saved
//		a1 = document.createElement('a');
//		a1.href = 'javascript:;';
//		a1.id = idPrefix + ':move:' + itemId;
//		a1Txt = document.createTextNode(langVar('lang_stats.global_filter.move_to_saved'));
//		a1.appendChild(a1Txt);
//		td4.appendChild(a1);
//		td4.appendChild(separatorLine1);
//
//		YE.addListener(a1, 'click', moveFilterItem);
//
//
//		// Add Delete control
//
//		var a3 = document.createElement('a');
//		a3.href = 'javascript:;';
//		a3.id = idPrefix + ':delete:' + itemId;
//		var a3Txt = document.createTextNode(langVar('lang_stats.btn.delete'));
//
//		a3.appendChild(a3Txt);
//		td4.appendChild(a3);
//
//		YE.addListener(a3, 'click', deleteFilter);
//
//		tr.appendChild(td4);
//
//		// tbody.appendChild(
//
//		return tr;
//	}

//	function removeFilterRows(containerId) {
//
//		// removes any existing filter row
//
//		var tbody = util.getE(containerId);
//
//		if (tbody.lastChild != null) {
//
//			// remove all rows
//			while (tbody.lastChild != null) {
//				var row = tbody.lastChild;
//				tbody.removeChild(row);
//			}
//		}
//	}

//	function moveFilterItem() {
//
//		// Moves an unsaved filter item to saved filter items
//
//		// alert('moveFilterItem: ' + this.id);
//
//		var elementId = this.id;
//		var dat = elementId.split(':');
//		var idPrefix = dat[0];
//		var itemId = dat[2];
//		var containerId;
//		var rowId = idPrefix + ':row:' + itemId;
//		var newItem = {};
//
//		if (idPrefix == 'just_added_fi') {
//			containerId = 'gf:just_added_filter_items:container';
//			newItem = util.cloneObject(justAddedFilterItems[util.h(itemId)]);
//			util.deleteArrayObject(justAddedFilterItems, 'id', itemId);
//		}
//		else {
//			// move recently_added_fi
//			containerId = 'gf:recently_added_filter_items:container';
//			newItem = util.cloneObject(recentlyAddedFilterItems[util.h(itemId)]);
//			util.deleteArrayObject(recentlyAddedFilterItems, 'id', itemId);
//		}
//
//		// delete justAddedItem row
//		var tbody = util.getE(containerId);
//		var row = util.getE(rowId);
//		tbody.removeChild(row);
//
//		reportFiltersAndGroups.insertFilterItem(newItem);
//
//		// Set controls state
//		setNumberOfActiveItems();
//	}

//	function deleteFilter() {
//
//		// Delete just added or recently added filter item
//		// alert('deleteFilter: ' + this.id);
//		var elementId = this.id;
//		var dat = elementId.split(':');
//		var idPrefix = dat[0];
//		var itemId = dat[2];
//		var rowElementId = idPrefix + ':row:' + itemId;
//		var containerId = '';
//
//		var filtersArray;
//
//		switch (idPrefix) {
//
//			case 'just_added_fi':
//				containerId = 'gf:just_added_filter_items:container';
//				filtersArray = justAddedFilterItems;
//				break;
//
//			case 'recently_added_fi':
//				containerId = 'gf:recently_added_filter_items:container';
//				filtersArray = recentlyAddedFilterItems;
//				isModifiedRecentlyAddedFilterItems = true;
//				break;
//		}
//
//		// Delete the row
//		var tbody = util.getE(containerId);
//		var row = util.getE(rowElementId);
//		tbody.removeChild(row);
//
//		// Delete the object in corresponding filters array
//		util.deleteArrayObject(filtersArray, 'id', itemId);
//
//		// Update controls
//
//		setNumberOfActiveItems();
//	}

//	function toggleFilterActiveState() {
//
//		// alert(this.id);
//
//		var elementId = this.id;
//		var dat = elementId.split(':');
//		var idPrefix = dat[0];
//		var itemId = dat[2];
//
//		var isChecked = this.checked;
//
//		var filtersArray;
//
//		switch (idPrefix) {
//
//			case 'just_added_fi':
//				filtersArray = justAddedFilterItems;
//				break;
//
//			case 'recently_added_fi':
//				filtersArray = recentlyAddedFilterItems;
//				break;
//		}
//
//		var item = filtersArray[util.h(itemId)];
//		item.isActive = isChecked;
//
//		setNumberOfActiveItems();
//	}

	function moveToSaved(filterItem) {

		// This inserts/adds filterItem to savedFiltersPanel
		savedFiltersPanel.addNewItemViaMoveToSaved(filterItem);
	}
	
	function saveFiltersDb() {

		var justAddedFilterItems = justAddedFiltersPanel.getFilterItems();
		var savedFilterItems = savedFiltersPanel.getFilterItems();
		var savedFilterGroups = savedFiltersPanel.getFilterGroups();
		var recentlyAddedFilterItems = recentlyAddedFiltersPanel.getFilterItems();
		var item;

//		var isModifiedSavedFilterItems = reportFiltersAndGroups.getIsModifiedSavedFilterItems();
//		var isModifiedSavedFilterGroups = reportFiltersAndGroups.getIsModifiedSavedFilterGroups();


		// ToDo, should we add separate isModifiedFilterItems and isModifiedFilterGroups?
		// Set it temporary to true;
		var isModifiedSavedFilterItems = true;
		var isModifiedSavedFilterGroups = true;


		var url = '?dp=statistics.filters.global_filter.save_filters_db';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.is_modified_saved_filter_items=' + isModifiedSavedFilterItems + '&';
		dat += 'v.fp.is_modified_saved_filter_groups=' + isModifiedSavedFilterGroups + '&';
		dat += 'v.fp.is_modified_recently_added_filter_items=' + isModifiedRecentlyAddedFilterItems + '&';
		
		// 
		// 
		// Handle justAddedFilterItems
		//
		// 
		
		if (isJustAddedFilterItems && justAddedFilterItems.length > 0) {
			
			for (var i = 0; i < justAddedFilterItems.length; i++) {
				item = justAddedFilterItems[i];
				dat += repFiltersUtil.getFilterItemDat('v.fp.just_added_filter_items.' + i, item, false);
			}
		}
		else {
			dat += 'v.fp.just_added_filter_items=&';
		}
		
		// 
		// 
		// Handle savedFilterItems
		//
		// 
		
		// If not modified we only send the active items, else we send all items.
//		util.showObject(savedFilterItems);
		var savedFilterItemsDat = '';
		
		for (var j = 0; j < savedFilterItems.length; j++) {
			
			item = savedFilterItems[j];
			if (isModifiedSavedFilterItems || item.isActive) {
				savedFilterItemsDat += repFiltersUtil.getFilterItemDat('v.fp.saved_filter_items.' + j, item, false);
			}
		}
		
		dat += (savedFilterItemsDat != '') ? savedFilterItemsDat : 'v.fp.saved_filter_items=&';
		
		// alert('savedFilterItemsDat length: ' + savedFilterItemsDat.length + '\nstring: ' + savedFilterItemsDat);
		
		// 
		// 
		// Handle savedFilterGroups
		//
		// 
		
		// If not modified we only send the group name and is_active node, else we send all details

//		util.showObject(savedFilterGroups);
		var savedFilterGroupsDat = '';
		
		for (var k = 0; k < savedFilterGroups.length; k++) {
			
			var filterGroup = savedFilterGroups[k];
			var isActive = filterGroup.isActive;
			
			if (isModifiedSavedFilterGroups || isActive) {
				
				var group_path = 'v.fp.saved_filter_groups.' + k;
				
				savedFilterGroupsDat += group_path + '.name=' + encodeURIComponent(filterGroup.name) + '&';
				savedFilterGroupsDat += group_path + '.is_active=' + isActive + '&';
				
				if (isModifiedSavedFilterGroups) {
					
					// We send all details
					savedFilterGroupsDat += group_path + '.label=' + filterGroup.label + '&';
					
					var items = filterGroup.items;
					
					// Note, we allow to save empty filterGroups!
					
					if (items.length > 0) {
						for (var m = 0; m < items.length; m++) {
							item = items[m];
							var itemPath = group_path + '.filter_items.' + m;
							savedFilterGroupsDat += repFiltersUtil.getFilterItemDat(itemPath, item, true);
						}
					}
					else {
						
						savedFilterGroupsDat += group_path + '.filter_items=&';
					}
				}
			}
			
			// alert('savedFilterGroupsDat per iteration length: ' + savedFilterGroupsDat.length + '\nstring: ' + savedFilterGroupsDat);
		}
		
		dat += (savedFilterGroupsDat != '') ? savedFilterGroupsDat : 'v.fp.saved_filter_groups=&';
		

		// 
		// Handle recentlyAddedFilterItems
		//
		
		// If not modified we only send the active items, else we send all items.
		
		var recentlyAddedFilterItemsDat = '';
		
		for (var n = 0; n < recentlyAddedFilterItems.length; n++) {
			
			item = recentlyAddedFilterItems[n];
			
			if (isModifiedRecentlyAddedFilterItems || item.isActive) {
				recentlyAddedFilterItemsDat += repFiltersUtil.getFilterItemDat('v.fp.recently_added_filter_items.' + n, item, false);
			}
		}
		
		dat += (recentlyAddedFilterItemsDat != '') ? recentlyAddedFilterItemsDat : 'v.fp.recently_added_filter_items=&';
		dat = dat.replace(/&$/, '');

		util.serverPost(url, dat);
	}
	
	function saveFiltersDbResponse(filterId) {
		
		// alert('saveFiltersDbResponse, filterId: ' + filterId);

		panel.close();
				
		if (newReport.filterId != filterId) {
			
			// Apply the filter
			newReport.filterId = filterId;
			newReport.request();
		}
	}

	// Return global properties and methods
	return {
		open: open,
		getFiltersDbResponse: getFiltersDbResponse,
		saveFiltersDbResponse: saveFiltersDbResponse,
		moveToSaved: moveToSaved,
		setNumberOfActiveItems: setNumberOfActiveItems
	};

}());
