//
//
// saveReportControl.js
//
//
//

var saveReportControl = {
	
	panelA: null, // Save Report Changes Panel
	panelB: null, // Row Number Paging Warning Panel
	busyPanel: null,
	
	setSkipSaveReportChangesDialogInFuture: false, // Is used on server side to determine if the variable will be set in user_info
	
	init: function() {
			
		var panelAObj = {
			panelId: 'save_report_changes_a:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.save_report_changes.save_report_changes'),
			left: 320,
			top: 45,
			zIndex: 20,
			isCover: true,
			closeEvent: saveReportControl.closePanelA
		};
		
		var panelBObj = {
			panelId: 'save_report_changes_b:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.save_report_changes.row_number_paging_info'),
			left: 320,
			top: 45,
			zIndex: 40,
			isCover: true,
			closeEvent: saveReportControl.closePanelB
		};
		
		saveReportControl.panelA = new util.Panel3(panelAObj);
		saveReportControl.panelB = new util.Panel3(panelBObj);
		
		// Create simple progress panel
		saveReportControl.busyPanel = new util.BusyPanel();
		
		var YE = YAHOO.util.Event;
		
		YE.addListener('save_report_changes_a:ok_btn', 'click', saveReportControl.confirmPanelA);
		YE.addListener('save_report_changes_a:cancel_btn', 'click', saveReportControl.closePanelA);
		
		YE.addListener('save_report_changes_b:ok_btn', 'click', saveReportControl.confirmPanelB);
		YE.addListener('save_report_changes_b:cancel_btn', 'click', saveReportControl.closePanelB);
	},
	
	//
	//
	// panelA (Save Report Changes Panel)
	//
	//
	
	openPanelA: function() {
		
		saveReportControl.panelA.open();
	},
	
	confirmPanelA: function() {
		
		// Check if row number paging is active
		
		var isActiveRowNumberPaging = saveReportControl.getIsActiveRowNumberPaging();
		
		// Check if the user want to skip this dialog in future
		saveReportControl.setSkipSaveReportChangesDialogInFuture = util.getF('save_report_changes_a:skip_dialog_in_future_btn');
		
		if (!isActiveRowNumberPaging) {
			
			// Confirmed, proceed with saving the changes
			saveReportControl.panelA.close();
			saveReportControl.saveChanges();
		}
		else {
			
			// Show row number paging info
			saveReportControl.openPanelB();
		}
	},
	
	closePanelA: function() {
		
		saveReportControl.panelA.close();
	},
	
	//
	//
	// rowNumberPagingWarningPanel
	//
	//
	
	openPanelB: function() {
		
		
		
		saveReportControl.panelB.open();
	},
	
	confirmPanelB: function() {
		
		var isSkipSaveReportChangesDialog = reportInfo.skipSaveReportChangesDialog;
		
		saveReportControl.closePanelB();
		
		if (!isSkipSaveReportChangesDialog) {
			
			// In this case panelA is open, so we have to close this panel too.
			saveReportControl.closePanelA();
		}
		
		saveReportControl.saveChanges();
	},
	
	closePanelB: function() {
		
		saveReportControl.panelB.close();
	},
	
	
	//
	//
	// main saveReportControl handling
	//
	//
	//
	
	saveChangesActor: function() {
		
		// Invoked via 'Save Report Changes' button
		
		var isSkipSaveReportChangesDialog = reportInfo.skipSaveReportChangesDialog;
		
		// Init all panels by checking panelA
		if (!saveReportControl.panelA) {
			saveReportControl.init();
		}
		
		if (!isSkipSaveReportChangesDialog) {
			// Open the dialog
			saveReportControl.openPanelA();
		}
		else {
						
			// Check if row number paging is active
			var isActiveRowNumberPaging = saveReportControl.getIsActiveRowNumberPaging();
			
			if (!isActiveRowNumberPaging) {
				
				// Proceed with saving the report changes
				saveReportControl.saveChanges();
			}
			else {
				
				// Show row number paging info dialog (Row numbers of paging are not saved, respectively starting row will be always 1!)
				saveReportControl.openPanelB();
 			}
		}
	},
	
	saveChanges: function() {
		
		saveReportControl.busyPanel.showSaving();
		
		var setSkipSaveReportChangesDialogInFuture = saveReportControl.setSkipSaveReportChangesDialogInFuture;
		
		if (setSkipSaveReportChangesDialogInFuture) {
			
			// Don't show dialog again, also not on current page, so we have to set the variable in reportInfo as well
			reportInfo.skipSaveReportChangesDialog = true;
		}
				
		var url = '?dp=statistics.save_report_changes.save_report_changes';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.web_browser_session_id=' + reportInfo.webBrowserSessionId;
		dat += '&v.fp.is_save_report_changes_to_profile_permission=' + reportInfo.permissions.saveReportChangesToProfile;
		dat += '&v.fp.report_name=' + reportInfo.reportName;
		dat += '&v.fp.report_info_id=' + reportInfo.reportInfoId;
		dat += '&v.fp.set_skip_save_report_changes_dialog_in_future=' + setSkipSaveReportChangesDialogInFuture;
		
		util.serverPost(url, dat);
	},
	
	saveChangesResponse: function() {
		
		// alert('saveChangesResponse()');
		saveReportControl.busyPanel.stop();
	},
	
	//
	//
	// main util
	//
	//
	
	getIsActiveRowNumberPaging: function() {
		
		var reportElements = reportInfo.reportElements;
		var isActiveRowNumberPaging = false;
		
		for (var i = 0; i < reportElements.length; i++) {
		
			var reportElement = reportElements[i];
			var type = reportElement.reportElementType;
			
			if ((type == 'table' || type == 'log_detail') && reportElement.startingRow > 1) {
				isActiveRowNumberPaging = true;
				break;
			}
		}
		
		return isActiveRowNumberPaging;
	}
};
