//
// sessionPagePaths
//


var sessionPagePathsLookup = {
	
	
	// Note, we allow multiple page lookup panes (i.e. multiple session page paths report elements),
	// each is identified by the short report element id (sreId)
	
	// example of active page lookup panel object
	/*
	re0: {
		
		isOpen: false,
		startingRow: 1, active starting row in display
		endingRow: 24, active ending row in display
		isSearchMode: false, lookup shows a search result
		...
	}
	
	*/
	
	pagesLookupNodeName: '', // Name of the pages lookup node in server side ProfileCache, we get the name when doing the inital pages load
	totalRows: 0, // Number of pages in server side database


	init: function(sreId) {
		
		var YE = YAHOO.util.Event;
		
		// Clear the search field (it could show a value when opening the report via the web browser back button)
		util.setF(sreId + ':page_lookup:search_field', '');

		
		// Add page lookup events
		
		YE.addListener(sreId + ':page_lookup:close_btn', 'click', sessionPagePathsLookup.closeLookup);
		
		YE.addListener(sreId + ':page_lookup:paging_container', 'click', sessionPagePathsLookup.setRows);
		
		YE.addListener(sreId + ':page_lookup:list', 'change', sessionPagePathsLookup.setPagePath);
		YE.addListener(sreId + ':page_lookup:list', 'keypress', newReport.setPagePathViaKey);
		
		YE.addListener(sreId + ':page_lookup:search_field', 'keypress', sessionPagePathsLookup.searchViaKey);
		YE.addListener(sreId + ':page_lookup:search_btn', 'click', sessionPagePathsLookup.searchViaButton);
		YE.addListener(sreId + ':page_lookup:clear_search_btn', 'click', sessionPagePathsLookup.clearSearch);
		
		
		// create object data
		sessionPagePathsLookup[sreId] = {};
		lookupObj = sessionPagePathsLookup[sreId];
		// lookupObj.isOpen = false;
		lookupObj.startingRow = 0;
		lookupObj.endingRow = 0;
		lookupObj.isSearchMode = false;
		lookupObj.searchResult = {};
		lookupObj.searchResult.searchResultNodeName = '';
		lookupObj.searchResult.totalRows = 0;
		lookupObj.searchResult.startingRow = 0;
		lookupObj.searchResult.EndingRow = 0;
		
		// Set initial display state, Loading
		
		sessionPagePathsLookup.setLoadingState(sreId);
	},
	
	
	openLookup: function() {
		
		// Open or close the page lookup panel
		
		// alert(this.id);
		// var panel = this;
		var elementId = this.id;
		var dat = elementId.split(':');
		var sreId = dat[0];
		var panelId = sreId + ':page_lookup:panel';
		
		var panelIsReady = (sessionPagePathsLookup[sreId] != null) ? true : false;
		
		if (!panelIsReady) {
			// panel is opened for the first time
			sessionPagePathsLookup.init(sreId);
		}
		
		var lookupObj = sessionPagePathsLookup[sreId];
		
			
		// Hide the page lookup button
		// util.hideE(sreId + ':lookup_pages_btn');
		
		// Get the region of the page path input element
		var region = YAHOO.util.Dom.getRegion(sreId + ':page_path_field');
		
		// Set panel position
		var panelElement = util.getE(panelId);
		// 2008-11-30 - GMF - Changed the offsets slightly so it completely hides the link that shows it.
		//                    (tested on Win/IE7, Mac/Firefox3, Mac/Safari2).
//		panelElement.style.left = region.left + 'px';
		panelElement.style.left = (region.left - 1) + 'px';
//		panelElement.style.top = (region.bottom + 7) + 'px';
		panelElement.style.top = (region.bottom + 2) + 'px';
		
		util.showE(panelId);
		// lookupObj.isOpen = true;
		
		if (!panelIsReady) {
			// Load the first pages, up to 500
			sessionPagePathsLookup.loadPages(sreId, 1, 500);
		}

		/*
		else {
			
			// Close the panel
			util.hideE(panelId);
			// util.showE(sreId + ':lookup_pages_btn');
			lookupObj.isOpen = false;
		}
		*/
	},
	
	closeLookup: function() {
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var sreId = dat[0];
		util.hideE(sreId + ':page_lookup:panel');
	},
	
	loadPages: function(sreId, startingRow, endingRow) {
		
		var url = '?dp=statistics.session_page_paths.get_sess_paths_lookup_pages';
		url += '&p=' + reportInfo.profileName;
		
		var reportElement = reportInfo.reportElements[util.h(sreId)];
		var reportElementName = reportElement.name;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.report_name=' + reportInfo.reportName + '&';
		dat += 'v.fp.report_element_name=' + reportElementName + '&';
		dat += 'v.fp.pages_lookup_node_name=' + sessionPagePathsLookup.pagesLookupNodeName + '&';
		dat += 'v.fp.sre_id=' + sreId + '&';
		dat += 'v.fp.starting_row=' + startingRow + '&';
		dat += 'v.fp.ending_row=' + endingRow;
		
		util.serverPost(url, dat);
	},
	
	loadPagesResponse: function(dat) {
		
		var sreId = dat.sreId;
		var pages = dat.pages;
		
		var lookupObj = sessionPagePathsLookup[sreId];
		
		if (sessionPagePathsLookup.pagesLookupNodeName == '') {
			
			// This is the initial load
			sessionPagePathsLookup.pagesLookupNodeName = dat.pagesLookupNodeName;
			sessionPagePathsLookup.totalRows = dat.totalRows;
		}
		
		// upadte lookup object
		
		lookupObj.startingRow = dat.startingRow;
		lookupObj.endingRow = dat.endingRow;
		
		sessionPagePathsLookup.populateList(sreId, pages);
		sessionPagePathsLookup.setOperatingState(sreId);
	},
	
	populateList: function(sreId, pages) {
		
		var lookupList = util.getE(sreId + ':page_lookup:list');
		
		lookupList.options.length = 0;
		
		for (var i = 0; i < pages.length; i++) {
			var pageName = pages[i];
			lookupList.options[i] = new Option(pageName, pageName, false, false);
		}
		
		lookupList.disabled = false;
	},
	
	setLoadingState: function(sreId) {
		
		util.updateT(sreId + ':page_lookup:header_text', langVar('lang_stats.session_page_paths.pages'));
		
		// Remove the Prev/Next pages buttons (only required if sessionPagePathsLookup.totalRows > 500)
		if (sessionPagePathsLookup.totalRows > 500) {
			var pagingContainer = util.getE(sreId + ':page_lookup:paging_container');
			while (pagingContainer.lastChild != null) {
				var item = pagingContainer.lastChild;
				pagingContainer.removeChild(item);
			}
		}
		
		// Disable all buttons and the list
		var a = [
			sreId + ':page_lookup:search_field',
			sreId + ':page_lookup:search_btn',
			sreId + ':page_lookup:clear_search_btn'
		];
		
		util.disableE(a);
		
		var lookupList = util.getE(sreId + ':page_lookup:list');
		lookupList.options.length = 0;
		lookupList.options[0] = new Option(langVar('lang_stats.session_page_paths.loading_info'), '', false, false);
		lookupList.disabled = true;
	},
	
	setOperatingState: function(sreId) {
		
		var lookupObj = sessionPagePathsLookup[sreId];
		var isSearchMode = lookupObj.isSearchMode;
		var activeTotalRows = !isSearchMode ? sessionPagePathsLookup.totalRows : lookupObj.searchResult.totalRows;
		var activeStartingRow = !isSearchMode ? lookupObj.startingRow : lookupObj.searchResult.startingRow;
		var activeEndingRow = !isSearchMode ? lookupObj.endingRow : lookupObj.searchResult.endingRow;
		
		// var pagesTxt = 'Pages ' + activeStartingRow + ' - ' + activeEndingRow + ' of ' + activeTotalRows;
		var pagesTxt = langVar('lang_stats.session_page_paths.pages_from_to_of_total_rows');
		pagesTxt = pagesTxt.replace(/__PARAM__1/, activeStartingRow);
		pagesTxt = pagesTxt.replace(/__PARAM__2/, activeEndingRow);
		pagesTxt = pagesTxt.replace(/__PARAM__3/, activeTotalRows);
		
		util.updateT(sreId + ':page_lookup:header_text', pagesTxt);
		
		// Set the Prev/Next pages buttons (only required if activeTotalRows > 500)
		if (activeTotalRows > 500) {
			sessionPagePathsLookup.createPagingButtons(sreId, activeTotalRows, activeStartingRow, activeEndingRow);
		}
		
		// Set the buttons
		// util.enableE(sreId + ':show_path_btn');
		// util.enableE(sreId + ':lookup_pages_btn');
		
		util.enableE(sreId + ':page_lookup:search_field');
		util.enableE(sreId + ':page_lookup:search_btn');
		util.enableE(sreId + ':page_lookup:clear_search_btn', isSearchMode);
	},
	
	createPagingButtons: function(sreId, activeTotalRows, activeStartingRow, activeEndingRow) {
		
		// Creates the paging buttons corresponding to the active rows displayed
		
		// var pagingContainer = util.getE(sreId + ':page_lookup:paging_container');
		
		// alert('createPagingButtons()');
		
		// We create maximum four paging buttons
		
		if (activeStartingRow > 500) {
			
			if (activeStartingRow > 1000) {
				
				// Add the first rows button
				sessionPagePathsLookup.createSinglePagingButton(sreId, 'first', 1, 500);
			}
			
			// Add the Previus row button
			previousStartingRow = activeStartingRow - 500;
			previousEndingRow = activeStartingRow - 1;
			sessionPagePathsLookup.createSinglePagingButton(sreId, 'digits', previousStartingRow, previousEndingRow);
		}
		
		
		if (activeEndingRow < activeTotalRows) {
			
			var nextStartingRow = activeEndingRow + 1;
			var nextEndingRow = (activeEndingRow + 500) <= activeTotalRows ? activeEndingRow + 500 : activeTotalRows;
			
			// Add the Next rows button
			
			sessionPagePathsLookup.createSinglePagingButton(sreId, 'digits', nextStartingRow, nextEndingRow);
			
			if (nextEndingRow < activeTotalRows) {
				
				// Add the Last rows button
				var multipleOfRowNumberInterval = 500 * Math.floor(activeTotalRows / 500);
				var lastStartingRow = (multipleOfRowNumberInterval != activeTotalRows) ? multipleOfRowNumberInterval + 1 : activeTotalRows - 499;
				sessionPagePathsLookup.createSinglePagingButton(sreId, 'last', lastStartingRow, activeTotalRows);
			}
		}
	},
	
	createSinglePagingButton: function (sreId, buttonStyle, startingRow, endingRow) {
		
		// buttonStyle is: first | digits | last
		
		var pagingContainer = util.getE(sreId + ':page_lookup:paging_container');
		
		var button = document.createElement('button');
		button.id = sreId + ':page_lookup_rows_setter_btn:' + startingRow + ':' + endingRow;
		button.className = 'paging';
		// button.type = 'button';
		var buttonLabel;
		
		if (buttonStyle == 'digits') {
			buttonLabel = startingRow + '-' + endingRow;
		}
		else if (buttonStyle == 'last') {
			buttonLabel = '>>';
		}
		else {
			buttonLabel = '<<';
		}
		
		var buttonTxt = document.createTextNode(buttonLabel);
		
		button.appendChild(buttonTxt);
		pagingContainer.appendChild(button);
	},
	
	setRows: function(evt) {
		
		// event is initiated from a paging button where the element id
		// contains the starting and ending row
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		if (elementId.indexOf(':page_lookup_rows_setter_btn:') != -1) {

			var dat = elementId.split(':');
			var sreId = dat[0];
			var startingRow = dat[2];
			var endingRow = dat[3];
			
			sessionPagePathsLookup.setLoadingState(sreId);
			
			if (!sessionPagePathsLookup[sreId]['isSearchMode']) {
				sessionPagePathsLookup.loadPages(sreId, startingRow, endingRow);
			}
			else {
				sessionPagePathsLookup.loadPagesFromSearchResult(sreId, startingRow, endingRow);
			}
		}
	},
	
	setPagePath: function() {
		
		var elementId = this.id;
		var dat = elementId.split(':');
		var sreId = dat[0];
		
		var pagePath = util.getF(elementId);
		util.setF(sreId + ':page_path_field', pagePath);
	},
	
	searchViaKey: function(evt) {
		
		var element = evt.target || evt.srcElement;
		var theKeyCode = (evt.which) ? evt.which : evt.keyCode;
	
		if (theKeyCode == 13 || theKeyCode == 3) {
			sessionPagePathsLookup.search(element.id);
		}
	},
	
	searchViaButton: function() {
		sessionPagePathsLookup.search(this.id);
	},
	
	search: function(elementId) {
		
		var dat = elementId.split(':')
		var sreId = dat[0];
		
		var searchTerm = util.getF(sreId + ':page_lookup:search_field');
		
		if (searchTerm != '') {
			
			// alert('Search');
			sessionPagePathsLookup.setLoadingState(sreId);
			
			var url = '?dp=statistics.session_page_paths.search_session_paths_lookup';
			url += '&p=' + reportInfo.profileName;
			
			var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
			dat += 'v.fp.pages_lookup_node_name=' + sessionPagePathsLookup.pagesLookupNodeName + '&';
			dat += 'v.fp.sre_id=' + sreId + '&';
			dat += 'v.fp.search_term=' + searchTerm;
			
			util.serverPost(url, dat);
		}
	},
	
	searchResponse: function(dat) {
		
		// util.showObject(dat);
		
		var sreId = dat.sreId;
		var totalRows = dat.totalRows;
		var pages = (totalRows > 0) ? dat.pages : [langVar('lang_stats.session_page_paths.no_pages_found_info')];
		
		var lookupObj = sessionPagePathsLookup[sreId];
		
		lookupObj.isSearchMode = true;
		lookupObj.searchResult.searchResultNodeName = dat.searchResultNodeName;
		lookupObj.searchResult.totalRows = totalRows;
		lookupObj.searchResult.startingRow = (totalRows > 0) ? dat.startingRow : 0;
		lookupObj.searchResult.endingRow = dat.endingRow;
		
		sessionPagePathsLookup.populateList(sreId, pages);
		sessionPagePathsLookup.setOperatingState(sreId);
		
		if (totalRows == 0) {
			// Disbale the list
			util.disableE(sreId + ':page_lookup:list');
		}
	},
	
	loadPagesFromSearchResult: function(sreId, startingRow, endingRow) {
		
		// alert('load pages from search result');
		
		var url = '?dp=statistics.session_page_paths.load_sess_paths_search_res';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.sre_id=' + sreId + '&';
		dat += 'v.fp.search_result_node_name=' + sessionPagePathsLookup[sreId]['searchResult']['searchResultNodeName'] + '&';
		dat += 'v.fp.starting_row=' + startingRow + '&';
		dat += 'v.fp.ending_row=' + endingRow;
		
		util.serverPost(url, dat);
	},
	
	loadPagesFromSearchResultResponse: function(dat) {
		
		alert('loadPagesFromSearchResultResponse()');
		
		var sreId = dat.sreId;
		var lookupSearchObj = sessionPagePathsLookup[sreId]['searchResult'];
		lookupSearchObj.startingRow = dat.startingRow;
		lookupSearchObj.endingRow = dat.endingRow;
		
		sessionPagePathsLookup.populateList(sreId, dat.pages);
		sessionPagePathsLookup.setOperatingState(sreId);
	},
	
	clearSearch: function() {
		
		var dat = this.id.split(':');
		var sreId = dat[0];
		
		util.setF(sreId + ':page_lookup:search_field', '');
		sessionPagePathsLookup[sreId]['isSearchMode'] = false;
		sessionPagePathsLookup.setLoadingState(sreId);
		sessionPagePathsLookup.loadPages(sreId, 1, 500);
	}
}
