//
// repFiltersUtil - used in reports and in scheduler
//
//

/* global
	globalFilter: false */

var repFiltersUtil = (function() {

	'use strict';

	function getIsValidFilterFields(queryFieldsDb, theFilterItem) {

		// This checks if the report field used in the filter item
		// actually exists in the queryFieldsDb.
		// Expressions are ignored, respectively assumed to be valid.

		// util.showObject(theFilterItem);
		var filterType = theFilterItem.filterType;
		var isValid = true;

//		console.log('getIsValidFilterFields() - filterType: ' + filterType);

		if (filterType === 'field') {

			var fieldName = theFilterItem.fieldName;
			isValid = typeof queryFieldsDb[util.h(fieldName)] !== 'undefined';
		}

//		console.log('getIsValidFilterFields() - isValid: ' + isValid);

		return isValid;
	}

	function getFilterItemAsString(theFilterItem) {

		// Returns a filterItem as string without isActive state.
		// This is used to check for existing filter items.

		var filterType = theFilterItem.filterType;
		var s = filterType;

		if (filterType == 'field') {
			s += theFilterItem.fieldName;
			s += theFilterItem.expressionType;
		}

		if (filterType == 'expression') {

			s += theFilterItem.label;
		}
		else {
			s += theFilterItem.isNegated;
		}

		s += theFilterItem.itemValue;

		return s;
	}

	function getFilterGroupId(theFilterGroup) {

		// Returns a filterGroup as string for comparison
//		util.showObject(theFilterGroup);

		var filterItems = theFilterGroup.items;

		var s = 'group_' + theFilterGroup.label;

		for (var i = 0, len = filterItems.length; i < len; i++) {
			s += getFilterItemAsString(filterItems[i]);
		}

		return s;
	}

	function getFilterItemDat(pathName, item, isItemInGroup) {

		var dat = '';
		var filterType = item.filterType;

		if (!isItemInGroup) {

			dat += pathName + '.is_active=' + item.isActive + '&';
		}

		dat += pathName + '.filter_type=' + filterType + '&';

		if (filterType != 'expression') {

			dat += pathName + '.is_negated=' + item.isNegated + '&';

            if (filterType == 'field') {

                dat += pathName + '.field_name=' + item.fieldName + '&';
                dat += pathName + '.expression_type=' + item.expressionType + '&';
            }
            else if (filterType == 'within_matches') {

                dat += pathName + '.within_field_name=' + encodeURIComponent(item.withinFieldName) + '&';
                dat += pathName + '.matches_field_name=' + encodeURIComponent(item.matchesFieldName) + '&';
            }
		}
		else {

			dat += pathName + '.label=' + encodeURIComponent(item.label) + '&';
		}

		dat += pathName + '.item_value=' + encodeURIComponent(item.itemValue) + '&';

		return dat;
	}

	function getGroupValuesByKey(filterItems, key, activeItemId) {

		// Creates an array of group labels or group names with all labels/names, except for activeItemId.
		// activeItemId is empty '' for new groups

		var a = [];

		for (var i = 0, len = filterItems.length; i < len; i++) {

			var item = filterItems[i];

			if (item.isGroup && item.id !== activeItemId) {

				a.push(item[key]);
			}
		}

		return a;
	}

	// Return global properties and methods
	return {
		getIsValidFilterFields: getIsValidFilterFields,
		getFilterItemAsString: getFilterItemAsString,
		getFilterGroupId: getFilterGroupId,
		getFilterItemDat: getFilterItemDat,
		getGroupValuesByKey: getGroupValuesByKey
	};

}());