/* global
	imgDb: false,
	langVar: false,
	util: false,
	YAHOO: false */



//
//	BusyPanel class
//

(function() {

	'use strict';

//	util.namespace('util');

	util.BusyPanel = function() {

		this.isBuild = false;
		this.isActive = false;
		this.mainElement = '';
		this.contentElementId = '';
	};

	util.BusyPanel.prototype = {

		showLoading: function() {
			this._show(langVar('lang_stats.btn.loading'));
		},

		showSaving: function() {
			this._show(langVar('lang_stats.btn.saving'));
		},

		showCustom: function(label) {
			this._show(label);
		},

		_show: function(label) {

			// label is allowed to be in HTML, so we use innerHTML

			var element;

			if (!this.isBuild) {
				this._build();
			}

			var contentElement = util.getE(this.contentElementId);
			contentElement.innerHTML = label;

			if (!this.isActive) {

				// Set the position before we display it
				element = this.mainElement;
				element.style.visibility = 'hidden';
				element.style.display = 'block';

				this._setPosition();

				element.style.visibility = 'visible';

				YAHOO.util.Event.addListener(window, 'resize', this._setPositionUponResize, this);

				this.isActive = true;
			}
			else {

				// progress panel is already displayed, just re-position
				this._setPosition();
			}
		},

		_setPositionUponResize: function(evt, self) {
			self._setPosition();
		},

		_setPosition: function() {

			var YD = YAHOO.util.Dom;

			var element = this.mainElement;
			var region = YD.getRegion(element);
			var elementWidth = region.width;

			var viewportWidth = YD.getViewportWidth();
			var viewportHeight = YD.getViewportHeight();

			element.style.left = Math.round(viewportWidth / 2 - elementWidth / 2) + 'px';
			element.style.top = Math.round(viewportHeight / 3) + 'px';
		},

		stop: function() {

			if (this.isActive) {
				YAHOO.util.Event.removeListener(window, 'resize', this._setPositionUponResize);
				this.mainElement.style.display = 'none';
				this.isActive = false;
			}
		},

		_build: function() {

			var mainElementId = util.getUniqueElementId();
			var contentElementId = mainElementId + ':content';
			var mainContentDiv = util.createE('div', {padding:'0'});
			var contentDiv = util.createE('div', {id:contentElementId, padding:'10px 16px'});

			var imgDat = imgDb.simpleProgress;
			var imgDiv = util.createE('div', {textAlign:'center', padding:'0px 16px 8px 16px'});
			var img = util.createE('img', {src:imgDat.src, width:imgDat.width, height:imgDat.height, title:'', alt:''});
			util.chainE([mainContentDiv, contentDiv, [imgDiv, img]]);

		//	var mainDiv = util.getRoundBox(mainElementId, 20, mainContentDiv);
			var mainDiv = util.createE('div', {id:mainElementId, className:'panel-20', display:'none'});
			util.chainE(mainDiv, mainContentDiv);

			mainDiv.style.zIndex = 1000;
			var bodyElements = document.getElementsByTagName('body');
			var bodyElement = bodyElements[0];
			bodyElement.appendChild(mainDiv);

			this.isBuild = true;
			this.mainElement = mainDiv;
			this.contentElementId = contentElementId;
		}
	};
}());