/* global
	util: false,
	YAHOO: false */


//
//	CommandLink (used for anchor buttons)
//

(function() {

	'use strict';

//	util.namespace('util');

	util.CommandLink = function(elementId, buttonEvent, defaultEnabled, options, contextObj /* optional */) {

		// This initializes a command link
		// options are
		// options.classNameEnabled
		// options.classNameDisabled

		var element = util.getE(elementId);
		this.element = element;
		this.buttonEvent = buttonEvent;
		this.isEnabled = defaultEnabled;
		this.classNameEnabled = options.classNameEnabled;
		this.classNameDisabled = options.classNameDisabled;
		this.contextObj = contextObj;

		// Set default state if the command link actually exists
		if (element !== null) {

			if (defaultEnabled) {

				element.className = this.classNameEnabled;

				if (contextObj == null) {

					YAHOO.util.Event.addListener(element, 'click', buttonEvent);
				}
				else {

					YAHOO.util.Event.addListener(element, 'click', buttonEvent, contextObj);
				}
			}
			else {

				element.className = this.classNameDisabled;
			}
		}
	};

	util.CommandLink.prototype = {

		enable: function(enableElement) {

			// If command link exists

			if (this.element !== null) {

				// The makeEnabled argument is optional
				var enableElement = enableElement !== null ? enableElement : true;

				var makeEnabled = typeof enableElement !== 'undefined' ? enableElement : true;

				// Only enable the button if it is not yet enabled
				if (makeEnabled) {

					if (!this.isEnabled) {

						var element = this.element;

						if (this.contextObj == null) {
							YAHOO.util.Event.addListener(element, 'click', this.buttonEvent);
						}
						else {
							YAHOO.util.Event.addListener(element, 'click', this.buttonEvent, this.contextObj);
						}

		//				YAHOO.util.Event.addListener(element, 'click', this.buttonEvent);
						element.className = this.classNameEnabled;
						this.isEnabled = true;
					}
				}
				else {

					this.disable();
				}
			}
		},

		disable: function() {

			// Don't disable the button if it is already disabled
			if (this.element !== null && this.isEnabled) {

				var element = this.element;
				YAHOO.util.Event.removeListener(element, 'click', this.buttonEvent);
				element.className = this.classNameDisabled;
				this.isEnabled = false;
			}
		}
	};

}());