/* global
	util: false,
	YAHOO: false */



//
//	navGroup class
//	This replaces util.dropDownMenu. It can be used for single menu items
//	with a drop down or multiple menu items with and without drop down.
//

(function() {

	'use strict';

//	util.namespace('util');

	util.NavGroup = function(o) {

		// o.containerId => the container element of one or more buttons
		// o.menuBaseIds => an array with one or more relevant menu baseId's, i.e.:
		// rc_nav_config => This is the baseId
		// rc_nav_config:btn => This is the button of the given baseId
		// rc_nav_config:menu => This is the ul menu of the given baseId
		//
		// o.events => optional events per baseId which are fired when
		// opening the corresponding menu.

		var YE = YAHOO.util.Event;
		var containerId = o.containerId;
		var menuBaseIds = o.menuBaseIds;
		var events = o.hasOwnProperty('events') ? o.events : {};

		this.btnClassName = o.hasOwnProperty('btnClassName') ? o.btnClassName : '';
		this.btnActiveClassName = o.hasOwnProperty('btnActiveClassName') ? o.btnActiveClassName : '';
		this.menuBaseIds = {};

		this.openedMenuBaseId = ''; // Any opened menu
		this.onNavbar = false; // True if the mouse cursor is above navigation bar
		this.onMenu = false; // True if the mouse cursor is above the opened menu
		this.eventCount = 0;

		var baseId;
		var btnElement;
		var menuElement;
		var numberOfDropDowns = 0;

		// Track the drop down menus which actually exist in the GUI.
		for (var i = 0, l = menuBaseIds.length; i < l; i++) {

			baseId = menuBaseIds[i];
			btnElement = util.getE(baseId + ':btn');
			menuElement = util.getE(baseId + ':menu');

			if (typeof btnElement !== 'undefined') {

				// Keep a reference to the button and menu element.
				this.menuBaseIds[baseId] = {};
				this.menuBaseIds[baseId].btn = btnElement;
				this.menuBaseIds[baseId].menu = menuElement;

				// Note, we also need to handle buttons without a menu for
				// the _hoverOnButton event because hovering over a simple button
				// must yet close any open menu of another button.

				YE.addListener(btnElement, 'mouseover', this._hoverOnButton, this);

				if (typeof menuElement !== 'undefined') {

					// Assign individual click events because the single delegate event
					// has a problem with the context object "self"
					YE.addListener(btnElement, 'click', this._toggleMenu, this);

					if (events.hasOwnProperty(baseId)) {

						this.menuBaseIds[baseId].event = events[baseId];
					}

					numberOfDropDowns = numberOfDropDowns + 1;
				}
			}
		}

	//	util.showObject(this.menuBaseIds);

		if (numberOfDropDowns > 0) {

			// Assign event to container element
			// YE.delegate(containerId, 'mouseover', this.moveInGroup, 'a', this);

			// Toggle menu - disabled because context object "self" does not work!
			// YE.delegate(containerId, 'click', this._toggleMenu, 'a', this);

			// This handles hovering over a button

			// This handles exiting the navbar
			YE.addListener(containerId, 'mouseenter', this._handleMouseenter, this);
			YE.addListener(containerId, 'mouseleave', this._handleMouseleave, this);
		}
	};

	util.NavGroup.prototype = {

		_getBaseId: function(elementId) {

			// This returns the baseId by removing the id suffix
			// :btn or :menu from the element id. Note,
			// baseId may contain colons as well, i.e.: re01:rows:btn,
			// where the baseId is 're01:rows'.

			var substringIndex = elementId.lastIndexOf(':');
			var baseId = elementId.substring(0, substringIndex);
			return baseId;
		},

		_toggleMenu: function(evt, self) {

			var id = this.id;
	//		console.log('toggleMenu fired: ' + id);

			if (id.indexOf(':') !== -1) {

				// Get the baseId
				var baseId = self._getBaseId(id);
				var openedMenuBaseId = self.openedMenuBaseId;

				// Handle already opened menu
				if (openedMenuBaseId === '') {

					// No menu is open yet, open it
					self._openMenu(baseId);
				}
				else if (openedMenuBaseId === baseId) {

					// Menu is open, close it
					self._closeMenu();
				}

				// Remove focus
				this.blur();
			}
		},

		_openMenu: function(baseId) {

	//		console.log('_openMenu of baseId: ' + baseId);

			// Position the menu
			var baseObj = this.menuBaseIds[baseId];
			var btnElement = baseObj.btn;
			var menuElement = baseObj.menu;

			// Note, there may be buttons without a menu, so we need to check if a menu exists

			if (menuElement) {

				util.positionAndShowDropDownElement(btnElement, menuElement);

				YAHOO.util.Event.addListener(menuElement, 'mouseenter', this._handleMouseenter, this);
				YAHOO.util.Event.addListener(menuElement, 'mouseleave', this._handleMouseleave, this);
				YAHOO.util.Event.addListener(menuElement, 'mouseup', this._closeMenuByClick, this);

				this._setButtonStyle(baseId, true);

				if (baseObj.hasOwnProperty('event')) {
					// Call defined event
					baseObj.event();
				}
			}

			// We also set openedMenuBaseId in case that the button
			// has no drop down to keep track that we are in open menu mode.
			this.openedMenuBaseId = baseId;
		},

		_closeMenu: function() {

	//		console.log('_closeMenu() fired');

			// This closes the current open menu
			var openedMenuBaseId = this.openedMenuBaseId;

			if (openedMenuBaseId !== '') {

				var menuElement = this.menuBaseIds[openedMenuBaseId].menu;

				if (menuElement) {

					YAHOO.util.Event.removeListener(menuElement, 'mouseenter', this._handleMouseenter);
					YAHOO.util.Event.removeListener(menuElement, 'mouseleave', this._handleMouseleave);
					YAHOO.util.Event.removeListener(menuElement, 'mouseup', this._closeMenuByClick);
					menuElement.style.display = 'none';
					this._setButtonStyle(openedMenuBaseId, false);
				}

				// openedMenuBaseId may also exist when the button
				// has no drop down to keep track that we are in open menu mode.
				this.openedMenuBaseId = '';
			}
		},

		_closeMenuByClick: function(evt, self) {

			// Clicked on menu item, close the menu upon left mouse click
			// when not clicking in input field such as in profiles drop down.

			var clickId = (!util.userAgent.isIE) ? evt.button : evt.button - 1;
			var element = evt.target || evt.srcElement;

	//		console.log('_closeMenuByClick: ' + evt.target.nodeName);
			var pattern = /^A|SPAN|LI$/;

			if (clickId === 0 && pattern.test(element.nodeName)) {

				self.onMenu = false;
				self._closeMenu();
			}
		},

		_setButtonStyle: function(baseId, isActive) {

			var btnElement = this.menuBaseIds[baseId].btn;
			btnElement.className = isActive ? this.btnActiveClassName : this.btnClassName;
		},

		_hoverOnButton: function(evt, self) {

	//		console.log('_hoverOnButton fired: ' + this.id);

			var openedMenuBaseId = self.openedMenuBaseId;

			// Hovered over a nav button. Take action only
			// if a menu is already open.
			if (openedMenuBaseId !== '') {

				var id = this.id;
				var baseId = self._getBaseId(id);

				if (baseId !== openedMenuBaseId) {

					// Close the open menu
					self._closeMenu();

					// Open menu of given baseId
					self._openMenu(baseId);
				}
			}
		},


		// Close menu when moving out of navigation area

		_handleMouseenter: function(evt, self) {

	//		console.log('_handleMouseenter fired: ' + this.id);
			self._handleMouseenterMouseleave(this.id, true);
		},

		_handleMouseleave:function(evt, self) {

	//		console.log('_handleMouseleave fired: ' + this.id);
			self._handleMouseenterMouseleave(this.id, false);
		},

		_handleMouseenterMouseleave: function(elementId, isMouseEnter) {

	//		console.log('_handleMouseenterMouseleave()');
	//		console.log('_handleMouseenterMouseleave() - elementId: ' + elementId);
	//		console.log('_handleMouseenterMouseleave() - isMouseEnter: ' + isMouseEnter);

			// Set mouse position state
			if (elementId === this.containerId) {
				this.onNavbar = isMouseEnter;
			}
			else {
				// Must have moved out of menu
				this.onMenu = isMouseEnter;
			}

			// Set eventCount
			var newEventCount = this.eventCount + 1;
			this.eventCount = newEventCount;

	//		console.log('_handleMouseenter newEventCount: ' + newEventCount);

			var self = this;
			setTimeout(function() {
				self._checkMousePositionState.call(self, newEventCount);
			}, 800);
		},

		_checkMousePositionState: function(eventCount) {

	//		console.log('_checkMousePositionState fired: ' + eventCount + ' ' + this.eventCount + ' ' + this.onNavbar + ' ' + this.onMenu);

			// Handle last event only
			if (this.openedMenuBaseId !== '' &&
				eventCount === this.eventCount &&
				!this.onNavbar && !this.onMenu) {

				// Moved mouse cursor out of navbar and out of open menu.
				// Close open menu.
	//			console.log('_checkMousePositionState CLOSE MENU');
				this._closeMenu();
			}
		}
	};

}());