//
// Sawmill Source Code
// 
// This source code is the intellectual property of Flowerfire,
// and is protected by federal trade secret laws.  Do not
// redistribute, modify, or use this source code, except to compile
// it, without the express written consent of Flowerfire.
//
// For more information, see http://www.sawmill.net/trade_secret.html
//
// The trial and full commercial licenses for Sawmill allow you
// to use the program, and to compile it from this source code,
// but you are not permitted to look at this source code.  Please
// do not attempt to use this source code for any purpose other 
// then compilation!



















































 const char *Sd640ae3b485d204b45d204ce21b3b26e[] = { "##\n", "## Language Module -- Administration\n", 
"##\n", "## This is the Administration section of the default English language module\n", "##\n", "##\n", 
"\n", "\n", "##\n", "## MAIN MENU\n", "##\n", "\n", "MAIN_MENU_TITLE                \"{PRODUCT_NAME} {VERSION}, Administrative Menu\"\n", 
"LIMITED_MAIN_MENU_TITLE        \"{PRODUCT_NAME} {VERSION}, User Menu\"\n", "\n", "\n", "# Administrative Menu Buttons\n", 
"QUICK_START_BUTTON              \"Quick Start\"\n", "CREATE_NEW_CONFIGURATION_BUTTON \"Create New Configuration\"\n", 
"CREATE_MANY_CONFIGURATIONS_BUTTON \"Create Many Configurations\"\n", "OPEN_CONFIGURATION_BUTTON       \"Open Configuration\"\n", 
"DELETE_CONFIGURATION_BUTTON     \"Delete Configuration\"\n", "ADMINISTRATION_BUTTON           \"Web Server Administration\"\n", 
"VIEW_DOCUMENTATION_BUTTON       \"View Documentation\"\n", "MODIFY_PREFERENCES_BUTTON       \"Edit Preferences\"\n", 
"SCHEDULING_BUTTON               \"Scheduling\"\n", "DEFAULT_CONFIG_BUTTON           \"Edit Default Configuration\"\n", 
"LICENSING_BUTTON                \"Licensing\"\n", "LOGOUT_BUTTON                   \"Log Out\"\n", 
"LOGIN_BUTTON                    \"Log In\"\n", "\n", "# User Menu Buttons\n", "VIEW_STATISTICS_FOR_BUTTON   \"View Statistics\"\n", 
"\n", "# Configuration selection prompts \n", "SELECT_CONFIG_TO_DELETE \"Please select the configuration to delete\"\n", 
"SELECT_CONFIG_TO_VIEW \"Please select the configuration to view statistics for\"\n", "SELECT_CONFIG_TO_OPEN \"Please select the configuration to open\"\n", 
"OPEN_BUTTON \"Open\"\n", "VIEW_BUTTON \"View\"\n", "\n", "# Menu page of configuration page\n", "CONFIGURATION_PAGE_TITLE  \"{PRODUCT_NAME} {VERSION}; Configuration page for {config_name}\"\n", 
"LICENSING_PAGE_TITLE      \"Licensing\"\n", "PREFERENCES_TITLE         \"{PRODUCT_NAME} {VERSION}; Preferences\"\n", 
"CONFIGURATION_OPTIONS_TITLE \"{PRODUCT_NAME} {VERSION}; Configuration options for {config_name}\"\n", 
"DATABASE_INFO_PAGE_TITLE  \"{PRODUCT_NAME} {VERSION}; Database information for {config_name}\"\n", 
"DEFAULT_CONFIGURATION_PAGE_TITLE  \"{PRODUCT_NAME} {VERSION}; Default Configuration\"\n", "VIEW_STATISTICS_BUTTON    \"View Statistics\"\n", 
"BUILD_DATABASE_BUTTON     \"Build Database From Log Source\"\n", "REBUILD_DATABASE_BUTTON   \"Rebuild Database From Log Source\"\n", 
"CONVERT_DATABASE_BUTTON   \"Convert 6.0/6.1 Database\"\n", "UPDATE_DATABASE_BUTTON    \"Update Database From Log Source\"\n", 
"EXPIRE_DATABASE_BUTTON    \"Expire Data From Database\"\n", "ADD_LOG_DATA_BUTTON       \"Add Other Log Data To Database...\"\n", 
"GENERATE_HTML_BUTTON      \"Generate HTML Files\"\n", "SEND_VIEW_BY_EMAIL_BUTTON \"Send View By Email\"\n", 
"DATABASE_INFO_BUTTON      \"Database Information\"\n", "SCAN_AND_SUMMARIZE_BUTTON \"Scan and Summarize Log Source\"\n", 
"EDIT_CONFIGURATION_OPTIONS_BUTTON \"Configuration Options...\"\n", "SAVE_CONFIGURATION_AS_BUTTON \"Save Configuration As...\"\n", 
"BACK_TO_ADMIN_MENU_BUTTON \"Back to Administrative Menu\"\n", "BACK_TO_CONFIG_MENU_BUTTON \"Back to Configuration Menu\"\n", 
"SAVE_BUTTON               \"Save\"\n", "\n", "\n", "FOR_MORE_INFORMATION_LABEL \"For more information\"\n", 
"\n", "# Configuration file comments\n", "AUTOGENERATED_CONFIG_FILE \"auto-generated configuration file\"\n", 
"CONFIGURATION_NAME_TEXT \"Configuration name\"\n", "CONFIG_FILE_CATEGORY_LABEL \"CATEGORY\"\n", "CONFIG_FILE_FORMAT_LABEL \"Format\"\n", 
"\n", "CLICK_TAB_BUTTON_SAVE_NOTE \"Note: clicking any tab, or this button, saves your changes.\"\n", 
"CLICK_BUTTON_SAVE_NOTE \"Note: clicking any button saves your changes.\"\n", "\n", "INDIVIDUAL_HITS_NO_DATETIME \"The individual hits view is not available because there is no date/time field in your database.\"\n", 
"\n", "LOGGED_OUT_MESSAGE \"You have logged out of {PRODUCT_NAME}.\"\n", "LOG_BACK_IN \"Log back in\"\n", 
"\n", "# Overview table labels\n", "OVERVIEW_NAME_LABEL                   \"Configuration name\"\n", 
"OVERVIEW_DBFIELDS_LABEL               \"Database fields\"\n", "OVERVIEW_DBBUILT_LABEL                \"Database built\"\n", 
"OVERVIEW_EARLIEST_ENTRY_LABEL         \"Earliest entry in database\"\n", "OVERVIEW_LATEST_ENTRY_LABEL           \"Latest entry in database\"\n", 
"OVERVIEW_LOG_SOURCE_MODIFIED_LABEL    \"Log source last modified\"\n", "OVERVIEW_TOTAL_DATABASE_SIZE_LABEL    \"Total database data size\"\n", 
"OVERVIEW_RESIDENT_DATABASE_SIZE_LABEL \"Resident database data size\"\n", "OVERVIEW_INDICES_SIZE_LABEL           \"Items indices size\"\n", 
"OVERVIEW_HIERARCHIES_SIZE_LABEL       \"Hierarchies size\"\n", "OVERVIEW_DIRECT_URL_LABEL             \"Direct URL to view statistics\"\n", 
"\n", "SCAN_LOG_ENTRIES          \"Number of entries in current Log Source\"\n", "SCAN_LOG_ENTRIES_ACCEPTED \"Entries accepted by the filters\"\n", 
"SCAN_LOG_FILES            \"Files in current Log Source\"\n", "SCAN_LOG_FIELD_DEPTH      \"Depth of {FIELD_NAME_{FIELD}} field in Log Source\"\n", 
"\n", "PREFERENCES_LABEL \"Preferences\"\n", "CONFIGURATION_PAGE_LABEL \"Configuration: {config_name}\"\n", 
"CONFIGURATION_OPTIONS_LABEL \"Configuration Options: {config_name}\"\n", "DEFAULT_CONFIGURATION_PAGE_LABEL \"Default Configuration\"\n", 
"\n", "# Variables for the Open Configuration page\n", "OPEN_CONFIG_TITLE   \"Open Configuration\"\n", 
"OPEN_CONFIG_LABEL   \"Please enter the name of the configuration to open:\"\n", "OPEN_CONFIG_BUTTON  \"Open Configuration\"\n", 
"\n", "# This appears in the menu menu when the trial period has expired\n", "TRIAL_PERIOD_EXPIRED  \"TRIAL PERIOD EXPIRED\"\n", 
"TRIAL_DAYS_REMAINING  \"{DAYS} days remaining in trial period\"\n", "\n", "\n", "# The names of the option categories\n", 
"CATEGORY_NAME_database        \"Database Options\"\n", "CATEGORY_NAME_statsviews      \"Statistics Views Options\"\n", 
"CATEGORY_NAME_statsfonts      \"Statistics Fonts Options\"\n", "CATEGORY_NAME_statsshow       \"Statistics Show/Hide Options\"\n", 
"CATEGORY_NAME_statsmisc       \"Statistics Miscellaneous Options\"\n", "CATEGORY_NAME_statssizes      \"Statistics Sizes and Dimensions Options\"\n", 
"CATEGORY_NAME_statscolors     \"Statistics Colors Options\"\n", "CATEGORY_NAME_filter          \"Log Filters\"\n", 
"CATEGORY_NAME_logformat       \"Log Format Options\"\n", "CATEGORY_NAME_logfield        \"Log Fields\"\n", 
"CATEGORY_NAME_logsource       \"Log Source Options\"\n", "CATEGORY_NAME_loginfo         \"Log Information Options\"\n", 
"CATEGORY_NAME_header          \"Header and Footer Options\"\n", "CATEGORY_NAME_security        \"Security Options\"\n", 
"CATEGORY_NAME_output          \"Output Options\"\n", "CATEGORY_NAME_network         \"Network Options\"\n", 
"CATEGORY_NAME_database_fields \"Database Fields\"\n", "CATEGORY_NAME_xrefs           \"Database Cross-referencing\"\n", 
"CATEGORY_NAME_structure       \"Database Structure Options\"\n", "CATEGORY_NAME_commandline     \"Command Line Only Options\"\n", 
"CATEGORY_NAME_internal        \"Internal Options\"\n", "CATEGORY_NAME_obsolete        \"Obsolete Options\"\n", 
"CATEGORY_NAME_global_server   \"Global Server Options\"\n", "CATEGORY_NAME_global_security \"Global Security Options\"\n", 
"CATEGORY_NAME_global_misc     \"Global Miscellaneous Options\"\n", "CATEGORY_NAME_menu            \"Menu\"\n", 
"CATEGORY_NAME_overview        \"Configuration Overview\"\n", "\n", "ALL_OPTIONS_LABEL \"All Options\"\n", 
"\n", "CATEGORY_NAME_SHORT_statsviews      \"Stats Views\"\n", "CATEGORY_NAME_SHORT_statsfonts      \"Stats Fonts\"\n", 
"CATEGORY_NAME_SHORT_statsshow       \"Stats Show/Hide\"\n", "CATEGORY_NAME_SHORT_statsmisc       \"Stats Misc\"\n", 
"CATEGORY_NAME_SHORT_statssizes      \"Stats Sizes\"\n", "CATEGORY_NAME_SHORT_statscolors     \"Stats Colors\"\n", 
"CATEGORY_NAME_SHORT_database        \"Database Params\"\n", "CATEGORY_NAME_SHORT_filter          \"Log Filters\"\n", 
"CATEGORY_NAME_SHORT_logformat       \"Log Format\"\n", "CATEGORY_NAME_SHORT_logfield        \"Log Fields\"\n", 
"CATEGORY_NAME_SHORT_logsource       \"Log Source\"\n", "CATEGORY_NAME_SHORT_loginfo         \"Log Info\"\n", 
"CATEGORY_NAME_SHORT_header          \"Header / Footer\"\n", "CATEGORY_NAME_SHORT_security        \"Security\"\n", 
"CATEGORY_NAME_SHORT_output          \"Output\"\n", "CATEGORY_NAME_SHORT_network         \"Network\"\n", 
"CATEGORY_NAME_SHORT_database_fields \"Database Fields\"\n", "CATEGORY_NAME_SHORT_xrefs           \"Database Xrefs\"\n", 
"CATEGORY_NAME_SHORT_structure       \"Database Structure\"\n", "CATEGORY_NAME_SHORT_commandline     \"Command Line\"\n", 
"CATEGORY_NAME_SHORT_internal        \"Internal\"\n", "CATEGORY_NAME_SHORT_obsolete        \"Obsolete\"\n", 
"CATEGORY_NAME_SHORT_global_server   \"Server\"\n", "CATEGORY_NAME_SHORT_global_security \"Security\"\n", 
"CATEGORY_NAME_SHORT_global_misc     \"Miscellaneous\"\n", "CATEGORY_NAME_SHORT_menu            \"Menu\"\n", 
"CATEGORY_NAME_SHORT_overview        \"Overview\"\n", "\n", "LOG_FIELD_TYPE_page page \n", "LOG_FIELD_TYPE_url URL \n", 
"LOG_FIELD_TYPE_date/time date/time \n", "LOG_FIELD_TYPE_date date \n", "LOG_FIELD_TYPE_time time \n", 
"LOG_FIELD_TYPE_host host \n", "LOG_FIELD_TYPE_agent agent \n", "LOG_FIELD_TYPE_size size \n", "LOG_FIELD_TYPE_response \"server response\"\n", 
"LOG_FIELD_TYPE_integer integer \n", "LOG_FIELD_TYPE_hierarchical \"generic hierarchical\"\n", "LOG_FIELD_TYPE_visitorid \"visitor ID\"\n", 
"LOG_FIELD_TYPE_flat \"generic non-hierarchical\" \n", "\n", "LOG_POSITION_TYPE_index_subindex \"by index/subindex:\" \n", 
"LOG_POSITION_TYPE_use_field_number \"use field number\" \n", "LOG_POSITION_TYPE_use_regular_expression \"from regular expression\" \n", 
"\n", "LOG_SOURCE_TYPE_local \"Get log files from local disk\"\n", "LOG_SOURCE_TYPE_ftp \"Get log files using FTP\"\n", 
"LOG_SOURCE_TYPE_http \"Get log files using HTTP\"\n", "LOG_SOURCE_TYPE_command \"Get log data from command output\"\n", 
"LOG_SOURCE_DESCRIPTION_local \"Log file(s) at {PARAM} on local disk\"\n", "LOG_SOURCE_DESCRIPTION_ftp \"Log file(s) at {PARAM} on FTP server {PARAM2} (log in as {PARAM3})\"\n", 
"LOG_SOURCE_DESCRIPTION_http \"Log file at {PARAM} on HTTP server {PARAM2}\"\n", "LOG_SOURCE_DESCRIPTION_command \"Log data generated by command `{PARAM}`\"\n", 
"USE_MULTIPLE_LOG_SOURCES \"Use Multiple Log Sources\"\n", "\n", "LOG_SOURCE_TYPE_LABEL \"Log source type\"\n", 
"LOG_SOURCE_PATHNAME_LABEL \"Pathname\"\n", "LOG_SOURCE_FTP_HOSTNAME_LABEL \"FTP server host, or URL\"\n", 
"LOG_SOURCE_HTTP_HOSTNAME_LABEL \"HTTP URL of log file\"\n", "LOG_SOURCE_USERNAME_LABEL \"FTP username\"\n", 
"LOG_SOURCE_PASSWORD_LABEL \"FTP password\"\n", "LOG_SOURCE_COMMAND_LABEL \"Command\"\n", "LOG_SOURCE_RECURSE_LABEL \"Process files in subdirectories\"\n", 
"LOG_SOURCE_REGEXP_LABEL \"Pattern (filename) is a regular expression\"\n", "\n", "LOG_SOURCE_FTP_HOST_EXAMPLE \"e.g. ftp.yoursite.com, ftp://site.com/logs/*.log, ftp://user:password@site.com/a.log\"\n", 
"LOG_SOURCE_FTP_PATHNAME_EXAMPLE \"e.g. /logs/access.log, logs/*.log\"\n", "LOG_SOURCE_HTTP_EXAMPLE \"e.g. http://www.site.com/logs/my.log; <font color=%22ff0000%22>wildcards not allowed; no passwords</font>; use FTP for multiple files or password-protected files.\"\n", 
"LOG_SOURCE_COMMAND_EXAMPLE \"e.g. xunzip -c /logs/access*.xz\"\n", "LOG_SOURCE_LOCAL_EXAMPLE\n", "  \"e.g.\n", 
"   {IFEQUAL:{PLATFORM}:Win32:THEN:\n", "     {QUOTE:C:\\logs\\access.log, C:\\logs\\*.log, \\\\host\\share\\dir\\ex*.log}:ELSE:\n", 
"     {IFEQUAL:{PLATFORM}:Macintosh:THEN:\n", "       {QUOTE:HardDrive:logs:access.log, Drive:My Logs:*.log}:ELSE:\n", 
"       /var/log/access.log, /home/http/logs/*.log}}\"\n", "\n", "PLEASE_WAIT \"Reading Log Data; Please Wait\"\n", 
"\n", "# Filter type names\n", "FILTER_TYPE_if_a_then_b_else_c \"If A is true, then do B; otherwise do C\"\n", 
"FILTER_TYPE_do_b \"Do B\"\n", "FILTER_TYPE_do_b_then_c \"Do B; then do C\"\n", "\n", "FILTER_VALUE1 \"value1\"\n", 
"FILTER_VALUE2 \"value2\"\n", "\n", "# Filter operation names\n", "FILTER_OP_equals \"value1 = value2\"\n", 
"FILTER_OP_not_equals \"value1 != value2\"\n", "FILTER_OP_contains \"value1 contains value2\"\n", "FILTER_OP_starts_with \"value1 starts with value2\"\n", 
"FILTER_OP_ends_with \"value1 ends with value2\"\n", "FILTER_OP_less_than \"value1 < value2\"\n", "FILTER_OP_greater_than \"value1 > value2\"\n", 
"FILTER_OP_greater_than_or_equal \"value1 >= value2\"\n", "FILTER_OP_less_than_or_equal \"value1 <= value2\"\n", 
"FILTER_OP_older_than \"value1 is older than value2 days\"\n", "FILTER_OP_and \"value1 is true and value2 is true\"\n", 
"FILTER_OP_or \"value1 is true or value2 is true\"\n", "FILTER_OP_matches_using_regexp \"value1 matches regular expression value2\"\n", 
"FILTER_OP_matches_using_wildcards \"value1 matches wildcard expression value2\"\n", "FILTER_OP_none \"(no operation)\"\n", 
"\n", "FILTER_OP_SHORT_equals \"=\"\n", "FILTER_OP_SHORT_not_equals \"!=\"\n", "FILTER_OP_SHORT_contains \"contains\"\n", 
"FILTER_OP_SHORT_starts_with \"starts with\"\n", "FILTER_OP_SHORT_ends_with \"ends with\"\n", "FILTER_OP_SHORT_less_than \"<\"\n", 
"FILTER_OP_SHORT_greater_than \">\"\n", "FILTER_OP_SHORT_greater_than_or_equal \">=\"\n", "FILTER_OP_SHORT_less_than_or_equal \"<=\"\n", 
"FILTER_OP_SHORT_older_than \"is older than\"\n", "FILTER_OP_SHORT_and \"and\"\n", "FILTER_OP_SHORT_or \"or\"\n", 
"FILTER_OP_SHORT_matches_using_regexp \"matches\"\n", "FILTER_OP_SHORT_matches_using_wildcards \"matches\"\n", 
"FILTER_OP_SHORT_none \"(no operation)\"\n", "\n", "FILTER_EXPRESSION_TYPE_entire_line \"entire line\"\n", 
"FILTER_EXPRESSION_TYPE_value \"this value:\"\n", "FILTER_EXPRESSION_TYPE_variable \"the value of this variable:\"\n", 
"FILTER_EXPRESSION_TYPE_regular_expression \"this regular expression:\"\n", "FILTER_EXPRESSION_TYPE_filter_number_result \"result of the following filter number:\"\n", 
"FILTER_EXPRESSION_TYPE_filter_number_accepts \"the following filter number accepts:\"\n", "FILTER_EXPRESSION_TYPE_filter_number_rejects \"the following filter number rejects:\"\n", 
"FILTER_EXPRESSION_TYPE_none \"(no expression)\"\n", "\n", "FILTER_STATEMENT_accept_as_hit \"accept as hit\"\n", 
"FILTER_STATEMENT_accept_as_page_view \"accept as page view\"\n", "FILTER_STATEMENT_reject \"reject\"\n", 
"FILTER_STATEMENT_replace_first \"replace first occurrence of value1 in field1 with value2\"\n", "FILTER_STATEMENT_replace_last \"replace last occurrence of value1 in field1 with value2\"\n", 
"FILTER_STATEMENT_replace_all \"replace all occurrences of value1 in field1 with value2\"\n", "FILTER_STATEMENT_replace_after \"replace everything after value1 in field1 with value2\"\n", 
"FILTER_STATEMENT_set_field \"set value of field field1 to value1\"\n", "FILTER_STATEMENT_set_field_from_command \"run command value1, and set field1 to the result\"\n", 
"FILTER_STATEMENT_set_fields_from_tcpip_server \"set all fields using a TCP/IP server at value1 (host:port), using delimiter value2\"\n", 
"FILTER_STATEMENT_copy_field \"copy value of field2 to field1\"\n", "FILTER_STATEMENT_add_suffix_to_field \"add value1 to end of field1 (as suffix)\"\n", 
"FILTER_STATEMENT_add_prefix_to_field \"add value1 to beginning of field1 (as prefix)\"\n", "FILTER_STATEMENT_concatenate \"concatenate value1, field1, value2, and field2 into field1\"\n", 
"FILTER_STATEMENT_set_variable \"set variable value2 to value\"\n", "FILTER_STATEMENT_add_numerically_to_variable \"add value1 to the value of variable value2 numerically\"\n", 
"FILTER_STATEMENT_dns_lookup \"look up the IP number in field1 using DNS\"\n", "FILTER_STATEMENT_convert_to_lowercase \"convert field1 to lowercase\"\n", 
"FILTER_STATEMENT_convert_to_uppercase \"convert field2 to uppercase\"\n", "FILTER_STATEMENT_copy_field_regexp \"match field2 with regular expression value1, and copy parenthesized section to field1\"\n", 
"FILTER_STATEMENT_convert_field_regexp \"match field2 with regular expression value1, and set field1 to value2 using variables\"\n", 
"FILTER_STATEMENT_rewrite_field_using_rules \"rewrite field2, using the rules file in value1, and put the result in field1\"\n", 
"FILTER_STATEMENT_collect_field_regexp \"match line with regex value1, and collect paren1 into field1 of paren2 entry\"\n", 
"FILTER_STATEMENT_collect_field_regexp2 \"match line with regex value1, and collect paren2 into field1 of paren1 entry\"\n", 
"FILTER_STATEMENT_collect_multiple_fields_regexp \n", "  \"match line with regex value1, and collect paren values into value2 fields\"\n", 
"FILTER_STATEMENT_collect_multiple_fields_regexp_listed \n", "  \"match line with regex value1, and collect name=value pairs in paren2 into paren1 entry\"\n", 
"FILTER_STATEMENT_accept_collected_entry \"accept collected entry value1\"\n", "FILTER_STATEMENT_accept_collected_entry_regexp \"match line with regular expression value1, and accept parenthesized section entry\"\n", 
"FILTER_STATEMENT_accept_multiple_fields_regexp \n", "  \"match line with regex value1, collect paren values into value2 fields, and accept\"\n", 
"FILTER_STATEMENT_goto_next_filter \"goto next filter\"\n", "FILTER_STATEMENT_goto_filter_number \"goto filter number specified by value1\"\n", 
"\n", "\n", "FILTER_DESCRIPTION_if_a_then_b_else_c \"if {FILTER_EXPRESSION_DESCRIPTION}<br>%0A    then {QUOTEVAR:FILTER_THEN_STATEMENT_DESCRIPTION}<br>%0A    otherwise {QUOTEVAR:FILTER_ELSE_STATEMENT_DESCRIPTION}\"\n", 
"FILTER_DESCRIPTION_do_b_then_c \"   {QUOTEVAR:FILTER_THEN_STATEMENT_DESCRIPTION}<br>%0A    then {QUOTEVAR:FILTER_ELSE_STATEMENT_DESCRIPTION}\"\n", 
"FILTER_DESCRIPTION_do_b \"   {QUOTEVAR:FILTER_THEN_STATEMENT_DESCRIPTION}\"\n", "\n", "FILTER_EXPRESSION_DESCRIPTION \"{QUOTEVAR:FILTER_LEFT_EXPRESSION_DESCRIPTION} {FILTER_OP_SHORT_{THIS_FILTER_EXPRESSION_OPERATOR}} {QUOTEVAR:FILTER_RIGHT_EXPRESSION_DESCRIPTION}\"\n", 
"\n", "# A friendly description of the left hand side of the boolean expression (A) part of the filter.\n", 
"FILTER_EXPRESSION_DESCRIPTION_entire_line \"the entire log entry line\"\n", "FILTER_EXPRESSION_DESCRIPTION_value \"%22{QUOTEVAR:THIS_EXPRESSION_VALUE}%22\"\n", 
"FILTER_EXPRESSION_DESCRIPTION_variable \"the value of the variable %22{QUOTEVAR:THIS_EXPRESSION_VALUE}%22\"\n", 
"FILTER_EXPRESSION_DESCRIPTION_regular_expression \"the regular expression %22{QUOTEVAR:THIS_EXPRESSION_VALUE}%22\"\n", 
"FILTER_EXPRESSION_DESCRIPTION_filter_number_result \"the result of filter {THIS_EXPRESSION_VALUE}\"\n", 
"FILTER_EXPRESSION_DESCRTIPION_filter_number_accepts \"filter {THIS_EXPRESSION_VALUE} accepts\"\n", 
"FILTER_EXPRESSION_DESCRIPTION_filter_number_rejects \"filter {THIS_EXPRESSION_VALUE} rejects\"\n", 
"FILTER_EXPRESSION_DESCRIPTION_field \"the {FIELD_NAME_{THIS_EXPRESSION_FIELD_TYPE}} field\"\n", "\n", 
"# A friendly description of the \"then\" (B) part of the filter.\n", "FILTER_STATEMENT_DESCRIPTION_accept_as_hit \"accept this log entry as a hit (and stop filtering)\"\n", 
"FILTER_STATEMENT_DESCRIPTION_accept_as_page_view \"accept this log entry as a page view (and stop filtering)\"\n", 
"FILTER_STATEMENT_DESCRIPTION_reject \"reject this log entry (and stop filtering)\"\n", "FILTER_STATEMENT_DESCRIPTION_replace_first \"replace the first occurrence of %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22 with %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM2}%22, in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_replace_last \"replace the last occurrence of %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22 with %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM2}%22, in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_replace_all \"replace all occurrences of %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22 with %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM2}%22, in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_set_field \"set the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field to %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22\"\n", 
"FILTER_STATEMENT_DESCRIPTION_replace_after \"replace everything after the first occurrence of %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22 with %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM2}%22, in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_set_field_from_command \"set the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field to the output of the command %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22\"\n", 
"FILTER_STATEMENT_DESCRIPTION_set_fields_from_tcpip_server \"set all fields using a TCP/IP server running at {QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1} (host:port), using %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM2}%22 as the field delimiter\"\n", 
"FILTER_STATEMENT_DESCRIPTION_copy_field \"copy the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM4}} field value to the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_copy_field_regexp \"match the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM4}} field value to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and copy parenthesized section to the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_concatenate \"concatenate %22{THIS_FILTER_STATEMENT_PARAM1}%22, the value of the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field, %22{THIS_FILTER_STATEMENT_PARAM2}%22, and the value of the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM4}} field, and put the result in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_dns_lookup \"look up the IP number in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field using DNS\"\n", 
"FILTER_STATEMENT_DESCRIPTION_convert_field_regexp \"match the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM4}} field value to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and if it matches set the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field to %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM2}%22, replacing variables.\"\n", 
"FILTER_STATEMENT_DESCRIPTION_rewrite_field_using_rules \"rewrite {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM4}} using the rules file at %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and put the result in the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field.\"\n", 
"FILTER_STATEMENT_DESCRIPTION_collect_field_regexp \"match the entire line to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and copy the first parenthesized section to the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field of the collected entry specified by the second parenthesized section\"\n", 
"FILTER_STATEMENT_DESCRIPTION_collect_field_regexp2 \"match the entire line to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and copy the second parenthesized section to the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field of the collected entry specified by the first parenthesized section\"\n", 
"FILTER_STATEMENT_DESCRIPTION_collect_multiple_fields_regexp \"match the entire line to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and copy the parenthesized sections in order to these fields\\: {THIS_FILTER_STATEMENT_PARAM2}, into the collected entry specified by *KEY*\"\n", 
"FILTER_STATEMENT_DESCRIPTION_collect_multiple_fields_regexp_listed \"match the entire line to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and set the fields in the collected entry specified by the first parenthesized section, according to the name=value pairs in the second parenthesized section, using the dividers specified in %22{THIS_FILTER_STATEMENT_PARAM2}%22\"\n", 
"FILTER_STATEMENT_DESCRIPTION_add_suffix_to_field \"add %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22 to the end of the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_accept_collected_entry \"accept the collected log entry specified by {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_accept_collected_entry_regexp \"match the entire line to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, and accept the collected log entry specified by the parenthesized section\"\n", 
"FILTER_STATEMENT_DESCRIPTION_accept_multiple_fields_regexp \"match the entire line to the regular expression %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22, copy the parenthesized sections in order to these fields\\: {THIS_FILTER_STATEMENT_PARAM2}, into the collected entry specified by *KEY*, and accept\"\n", 
"FILTER_STATEMENT_DESCRIPTION_add_prefix_to_field \"add %22{QUOTEVAR:THIS_FILTER_STATEMENT_PARAM1}%22 to the beginning of the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field\"\n", 
"FILTER_STATEMENT_DESCRIPTION_add_numerically_to_variable \"add %22{THIS_FILTER_STATEMENT_PARAM1}%22 to the value of the variable %22{THIS_FILTER_STATEMENT_PARAM2}%22\"\n", 
"FILTER_STATEMENT_DESCRIPTION_set_variable \"set variable %22{THIS_FILTER_STATEMENT_PARAM1}%22 to the value %22{THIS_FILTER_STATEMENT_PARAM2}%22\"\n", 
"FILTER_STATEMENT_DESCRIPTION_convert_to_lowercase \"convert the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field to lowercase\"\n", 
"FILTER_STATEMENT_DESCRIPTION_convert_to_uppercase \"convert the {FIELD_NAME_{THIS_FILTER_STATEMENT_PARAM3}} field to uppercase\"\n", 
"FILTER_STATEMENT_DESCRIPTION_goto_next_filter \"continue on to the next filter\"\n", "FILTER_STATEMENT_DESCRIPTION_goto_filter_number \"go to filter number {THIS_FILTER_STATEMENT_PARAM1}\"\n", 
"\n", "TREE_HELP_LABEL \"Click here for more information and examples\"\n", "LOG_FIELD_EDITOR_NOTE\n", 
"  \"This page displays the format of your log data.  Normally, you should <b>not</b>\n", "  change this--if {PRODUCT_NAME} has already detected your format, then this is set\n", 
"  correctly, and any changes you make will break it.  You should change the information on this page\n", 
"  <b>only</b> if you are creating your own custom log format.<p>\"\n", "\n", "TEXT_TYPE_table_text         \"Table text\"\n", 
"TEXT_TYPE_table_heading      \"Table heading\"\n", "TEXT_TYPE_table_average      \"Table average\"\n", 
"TEXT_TYPE_table_total        \"Table total\"\n", "TEXT_TYPE_instructions       \"Instructions\"\n", 
"TEXT_TYPE_menu_label         \"Menu label\"\n", "TEXT_TYPE_menu_contents      \"Menu contents\"\n", 
"TEXT_TYPE_pie_chart_label    \"Pie chart label\"\n", "TEXT_TYPE_filters_label      \"Filters label\"\n", 
"TEXT_TYPE_filters_text       \"Filters text\"\n", "TEXT_TYPE_subview_name       \"Subview name\"\n", 
"TEXT_TYPE_row_number         \"Row number\"\n", "TEXT_TYPE_toolbar            \"Toolbar\"\n", "TEXT_TYPE_infobar            \"Information bar\"\n", 
"TEXT_TYPE_label              \"Generic label\"\n", "TEXT_TYPE_value              \"Generic value\"\n", 
"TEXT_TYPE_overview_text      \"Overview text\"\n", "TEXT_TYPE_overview_view_link \"Overview view link\"\n", 
"TEXT_TYPE_text               \"Generic text\"\n", "TEXT_TYPE_notes              \"Notes\"\n", "TEXT_TYPE_path_text          \"Path text\"\n", 
"TEXT_TYPE_calendar_day       \"Calendar day\"\n", "TEXT_TYPE_calendar_month     \"Calendar month\"\n", 
"TEXT_TYPE_calendar_year      \"Calendar year\"\n", "TEXT_TYPE_title_bar          \"Title bar\"\n", 
"", "# Text used to generate log field info edit controls\n", "LOG_FIELD_NAME_LABEL \"Name Field Name\"\n", 
"LOG_FIELD_INDEX_LABEL Index\n", "LOG_FIELD_SUBINDEX_LABEL Subindex\n", "LOG_FIELD_HIERARCHY_DIVIDERS_LABEL \"Hierarchy Dividers\"\n", 
"LOG_FIELD_LEFT_RIGHT_LABEL \"Left-to-right hierarchy\"\n", "LOG_FIELD_LEADING_DIVIDER_LABEL \"Leading hierarchy divider\"\n", 
"LOG_FIELD_CASE_SENSITIVE_LABEL \"Case sensitive\"\n", "NO_DATABASE_FIELDS    \"(No database fields defined)\"\n", 
"VISITOR_ID_DESCRIPTION \"(internal field used to track visitor information)\"\n", "\n", "\n", "#\n", 
"SEND_VIEW_BY_EMAIL_TITLE \"Send View By Email\"\n", "SEND_VIEW_BY_EMAIL_TEXT \n", "  \"<p>The %22{view_to_send_by_email}%22 view has been sent by email to {view_email_address}.<p> \n", 
"  For details on customizing this, see [ssh], [vea], [ves], and [vtsbe].<p>\n", "  To return to the configuration page, use your browser's Back button.\n", 
"  Or you can now return to <a href=%22{PRODUCTEXE}%22>the Main Menu</a>.<p>\"\n", "\n", "SEND_VIEW_BY_EMAIL_COMMAND_LINE_TEXT \n", 
"  \"The %22{view_to_send_by_email}%22 view has been sent by email to {view_email_address}.\" \n", "\n", 
"# Progress bar labels\n", "PROGRESS_BAR_READING_COMMAND \"Reading output of command: {PARAM1}\"\n", 
"PROGRESS_BAR_READING_LOG_FILE \"Reading log file: {PARAM1}\"\n", "PROGRESS_BAR_READING_STDIN \"Reading log data from standard input stream\"\n", 
"PROGRESS_BAR_WRITING_DATABASE \"Consolidating and writing database\"\n", "PROGRESS_BAR_BUILDING_INDICES \"Building database indices\"\n", 
"PROGRESS_BAR_PREPARING_TO_CONSOLIDATE \"Preparing to consolidate database\"\n", "\n", "##\n", "## INTERVIEWS\n", 
"##\n", "\n", "# The names of the interviews\n", "INTERVIEW_NAME_createconfig \"Create Configuration\"\n", 
"INTERVIEW_NAME_createmanyconfigs \"Create Many Configuration (Batch Create)\"\n", "INTERVIEW_NAME_quickstart \"Quick Start\"\n", 
"INTERVIEW_NAME_verifydbdelete \"Verify Database Erase\"\n", "INTERVIEW_NAME_authenticate \"Authentication\"\n", 
"INTERVIEW_NAME_requirepassword \"Password Required\"\n", "INTERVIEW_NAME_requirepasswordc \"Password Required\"\n", 
"INTERVIEW_NAME_requireconfigpasswordc \"Configuration Password Required\"\n", "INTERVIEW_NAME_chooseinfodir \"Info {CAPITALIZE:{DIRECTORY_WORD}}\"\n", 
"INTERVIEW_NAME_chooseserverdir \"Temporary {CAPITALIZE:{DIRECTORY_WORD}}\"\n", "INTERVIEW_NAME_moveloganalysisinfo \"Move LogAnalysisInfoDirLoc\"\n", 
"INTERVIEW_NAME_preferences \"Preferences\"\n", "INTERVIEW_NAME_admin \"Administration\"\n", "INTERVIEW_NAME_choosepassword \"Choose Password\"\n", 
"INTERVIEW_NAME_saveexisting \"Save Configuration\"\n", "INTERVIEW_NAME_deleteconfig \"Delete Configuration\"\n", 
"\n", "# The names of the interview pages\n", "INTERVIEW_PAGE_NAME_start \"(Start of interview)\"\n", 
"INTERVIEW_PAGE_NAME_authenticate \"Please enter your username and password\"\n", "INTERVIEW_PAGE_NAME_password \"Please enter the {PRODUCT_NAME} password\"\n", 
"INTERVIEW_PAGE_NAME_passwordc \"This configuration requires a password\"\n", "INTERVIEW_PAGE_NAME_configpasswordc \"This configuration requires a password\"\n", 
"INTERVIEW_PAGE_NAME_passwordprefs \"Please enter the {PRODUCT_NAME} password\"\n", "INTERVIEW_PAGE_NAME_lp \"Where is the log data?\"\n", 
"INTERVIEW_PAGE_NAME_lff \"What is the format of your log data?\"\n", "INTERVIEW_PAGE_NAME_structure \"Please choose the level of detail for this configuration\"\n", 
"INTERVIEW_PAGE_NAME_configname \"Please name this configuration\"\n", "INTERVIEW_PAGE_NAME_options \"Please modify any other options you choose\"\n", 
"INTERVIEW_PAGE_NAME_loganalysisinfo \"Please create the LogAnalysisInfo {DIRECTORY_WORD}\"\n", "INTERVIEW_PAGE_NAME_sd \"Where can {PRODUCT_NAME} create/serve temporary images?\"\n", 
"INTERVIEW_PAGE_NAME_checksd \"Please verify that the Temporary {CAPITALIZE:{DIRECTORY_WORD}} is set correctly\"\n", 
"INTERVIEW_PAGE_NAME_moveloganalysisinfo \"Please move LogAnalysisInfoDirLoc to your CGI {DIRECTORY_WORD}\"\n", 
"INTERVIEW_PAGE_NAME_startupcomplete \"Installation and Startup are complete\"\n", "INTERVIEW_PAGE_NAME_choosepassword \"Please choose a {PRODUCT_NAME} password\"\n", 
"INTERVIEW_PAGE_NAME_adminpage \"Administrative Screen\"\n", "INTERVIEW_PAGE_NAME_verifydelete \"Please verify the deletion\"\n", 
"INTERVIEW_PAGE_NAME_configdeleted \"The configuration has been deleted\"\n", "INTERVIEW_PAGE_NAME_configcreated \"The configuration has been created\"\n", 
"INTERVIEW_PAGE_NAME_verifydbdelete \"Are you sure you want to destroy all data in the database?\"\n", 
"INTERVIEW_PAGE_NAME_createmanyconfigs \"Please describe the configurations to create\"\n", "INTERVIEW_PAGE_NAME_createdmanyconfigs \"Configurations created\"\n", 
"INTERVIEW_PAGE_NAME_done \"Done\"\n", "\n", "# The titles that appear at the top of interview pages\n", 
"INTERVIEW_PAGE_TITLE \"{INTERVIEW_PAGE_NAME_{INTERVIEW_PAGE}}\"\n", "\n", "# The names of the Next and Finish buttons\n", 
"NEXT_BUTTON 'Next >'\n", "BACK_BUTTON '< Back'\n", "ADMIN_MENU_BUTTON \"Admin Menu\"\n", "ADD_BUTTON 'Add >'\n", 
"FINISH_BUTTON Finish\n", "SAVE_BUTTON Save\n", "ADD_LOG_FINISH_BUTTON \"Add Data To Database Now\"\n", 
"\n", "# Browse... text\n", "BROWSE_BUTTON Browse...\n", "BROWSING_TITLE \"Browsing for %22{OPTION_LABEL_{BROWSE_FOR_COMMAND}}%22\"\n", 
"BROWSE_CONTENTS_OF_LABEL\n", "  \"Contents of \n", "  {IFEQUAL:{BROWSE_FOR_PATHNAME}:__top__:THEN:Top Level:ELSE:{BROWSE_FOR_PATHNAME}}\"\n", 
"BROWSE_UP_TO_TOP_LEVEL_BUTTON \"Up to top level\"\n", "BROWSE_UP_A_LEVEL_BUTTON \"Up a level\"\n", 
"BROWSE_NAME Name\n", "BROWSE_SIZE Size\n", "BROWSE_INSTRUCTIONS\n", "  \"{IFEQUAL:{IMAGES_AVAILABLE}:false:\n", 
"     THEN:\n", "       Items preceded by (D) are {PLURALIZE:{DIRECTORY_WORD}}; items preceded by (F) are files.\n", 
"     :ELSE:}\n", "    Click on a {DIRECTORY_WORD} to view its contents.<br>\n", "    Click the \n", 
"    {IFEQUAL:{IMAGES_AVAILABLE}:true:THEN:{GO_ICON}:ELSE:&gt;&gt;}\n", "    to the left of a file or {DIRECTORY_WORD} to use it as the %22{OPTION_LABEL_{BROWSE_FOR_COMMAND}}%22.<p>\"\n", 
"BROWSE_CREATE_BUTTON \"Create {DIRECTORY_WORD}\"\n", "BROWSE_GOTO_BUTTON \"Go to {DIRECTORY_WORD}\"\n", 
"\n", "\n", "# Buttons which appear below options tables \n", "RECOMPUTE_PAGE_WITH_THESE_OPTIONS_BUTTON \"Recompute Page With These Options\"\n", 
"SAVE_THESE_OPTIONS_BUTTON \"Save These Options\"\n", "\n", "# RGB and XYZ labels\n", "RED_LABEL Red\n", 
"GREEN_LABEL Green\n", "BLUE_LABEL Blue\n", "X_LABEL x\n", "Y_LABEL y\n", "Z_LABEL z\n", "\n", "# Text for the Database Structure and Filter category tables\n", 
"DELETE_BUTTON Delete\n", "SUPPRESS_ABOVE_LABEL \"Suppress levels above\"\n", "SUPPRESS_BELOW_LABEL \"Suppress levels below\"\n", 
"INCLUDE_LEAVES_LABEL \"Always include bottom-level items\"\n", "BASED_ON_LOG_FIELD \"Based on log field\"\n", 
"EDIT_LABEL Edit\n", "TYPE_LABEL \"Based On Log Field\"\n", "\n", "MATCHING_FILES \"Matching files for the current log source(s)\"\n", 
"NO_MATCHING_FILES \"No files match the current log source(s).\"\n", "\n", "UNABLE_TO_READ_BROWSE_DIR \"(unable to read contents)\"\n", 
"\n", "\n", "# Security mode text\n", "BROWSE_AND_MODIFY \"Browse and Modify\"\n", "BROWSE_AND_MODIFY_LIMITED \"Browse and Modify, Limited\"\n", 
"BROWSE_ONLY \"Browse Only\"\n", "\n", "ERROR_TITLE \"{PRODUCT_NAME} Error\"\n", "ERROR_IF_CORRECTED\n", 
"  \"If you have corrected the problem and/or would like to try again,\n", "  please use your browser's Back button to go back to the previous page.\n", 
"  You may also need to click your browser's Reload button on previous page to get it to reappear. \n", 
"  If you are having a problem you do not know how to correct, please \n", "  see [docs-troubleshooting], and if that doesn't help, contact \n", 
"  <a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a>.\"\n", "\n", "# Configuration status page text\n", 
"CONFIGURATION_STATUS_TITLE \"Configuration Status: {CONFIGURATION_STATUS_CONFIGNAME}\"\n", "EXPIRING_HITS_BEFORE \"Expiring hits before {PARAM1}\"\n", 
"DELETING_UNUSED_ITEMS \"Deleting unused items from database\"\n", "CONVERTING_DATABASE \"Converting database segments\"\n", 
"NETSCAPE_BUG_WARNING\n", "  \"<font size=2 color=#ff0000>Warning:\n", "  Versions of Netscape before 4.5 have a bug which \n", 
"  causes them to crash after receiving about 50 update pages like this one.\n", "  You appear to be running {BROWSER_TYPE} {BROWSER_VERSION}, which makes you vulnerable to this bug.\n", 
"  You can prevent this crash by upgrading to Netscape 4.5 or later, or\n", "  by using a multithreaded version of {PRODUCT_NAME} in web server mode, or by\n", 
"  setting the progress page interval large enough that less than\n", "  pages are generated, or by turning off progress pages.</font><p>\n", 
"  <center><font size=3 color=#ff0000><b>{PAGES_SENT} pages have been generated;\n", "  Netscape usually crashes around page 50.</b></font>\n</center><p>\"\n", 
"DETAILS_LABEL \"Processing Details\"\n", "DETAILS_APPEAR_NOTE \"(details will appear {PARAM} seconds after you click)\"\n", 
"DETAILS_DISAPPEAR_NOTE \"(details will disappear {PARAM} seconds after you click)\"\n", "CONFIGURATION_STATUS \"Configuration status: {CONFIGURATION_STATUS_CONFIGNAME}\"\n", 
"CONFIGURATION_IDLE \"(This configuration is idle)\"\n", "LOG_ENTRIES_PROCESSED_LABEL \"Log lines processed\"\n", 
"LOG_BYTES_PROCESSED_LABEL \"Log bytes processed\"\n", "LOG_ENTRIES_ACCEPTED_LABEL \"Log entries accepted\"\n", 
"TIME_ELAPSED_LABEL \"Time elapsed\"\n", "CONSOLIDATION_TIME_SPENT_LABEL \"Time spent consolidating database\"\n", 
"TIME_ELAPSED\n", "  \"{IFEQUAL:{HOURS_ELAPSED}:0:THEN::ELSE:\n", "      {IFEQUAL:{HOURS_ELAPSED}:1:THEN:1 hour, :ELSE:{HOURS_ELAPSED} hours, }}\n", 
"	{IFEQUAL:{MINUTES_ELAPSED}:0:THEN::ELSE:\n", "      {IFEQUAL:{MINUTES_ELAPSED}:1:THEN:1 minute, :ELSE:{MINUTES_ELAPSED} minutes, }}\n", 
"	{IFEQUAL:{SECONDS_ELAPSED}:0:THEN:0 seconds:ELSE:\n", "      {IFEQUAL:{SECONDS_ELAPSED}:1:THEN:1 second:ELSE:{SECONDS_ELAPSED} seconds}}\"\n", 
"AVERAGE_PROCESSING_SPEED_LABEL \"Average processing speed\"\n", "CURRENT_PROCESSING_SPEED_LABEL \"Current processing speed\"\n", 
"ENTRIES_BYTES_PER_SECOND_VALUE \"{ENTRIES_PER_SECOND} entries per second; {BYTES_PER_SECOND} per second\"\n", 
"ESTIMATED_TIME_REMAINING_LABEL \"Estimated time remaining\"\n", "TIME_REMAINING\n", "  \"{IFEQUAL:{HOURS_REMAINING}:0:THEN::ELSE:\n", 
"      {IFEQUAL:{HOURS_REMAINING}:1:THEN:1 hour, :ELSE:{HOURS_REMAINING} hours, }}\n", "	{IFEQUAL:{MINUTES_REMAINING}:0:THEN::ELSE:\n", 
"      {IFEQUAL:{MINUTES_REMAINING}:1:THEN:1 minute, :ELSE:{MINUTES_REMAINING} minutes, }}\n", "	{IFEQUAL:{SECONDS_REMAINING}:0:THEN:0 seconds:ELSE:\n", 
"      {IFEQUAL:{SECONDS_REMAINING}:1:THEN:1 second:ELSE:{SECONDS_REMAINING} seconds}}\"\n", "DNS_LOOKUPS_ATTEMPTED_LABEL \"DNS lookups attempted\"\n", 
"DNS_LOOKUPS_SUCCEEDED_NETWORK_LABEL \"DNS lookups succeeded (from network)\"\n", "DNS_LOOKUPS_SUCCEEDED_CACHE_LABEL \"DNS lookups succeeded (from cache)\"\n", 
"DNS_LOOKUPS_FAILED_LABEL \"DNS lookups failed\"\n", "DNS_LOOKUPS_TIMED_OUT_LABEL \"DNS lookups timed out\"\n", 
"MEMORY_USED_BY_WRITE_BUFFER \"Memory used by database write buffer\"\n", "DISK_USED_BY_WRITE_BUFFER \"Disk space used by database write buffer\"\n", 
"MEMORY_USED_BY_VISITOR_INFO \"Memory used by visitor lists\"\n", "MEMORY_USED_BY_LARGEST_SEGMENT \"Memory used by largest database segment\"\n", 
"MEMORY_USED_BY_FIELD_NAMES \"Memory used by {FIELD_NAME} index\"\n", "MORE_INFORMATION \"More information\"\n", 
"\n", "##\n", "## CONTENTS OF INTERVIEW PAGES\n", "##\n", "\n", "INTERVIEW_PAGE_CONTENTS_PASSWORD\n", 
"  \"Please enter the {PRODUCT_NAME} administrative password (see [docs-password]).<br>\"\n", "AUTOLOGON_CHECKBOX \"Remember my username and password\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_PASSWORDC\n", "  \"You need a password to access this configuration.  Please enter the {PRODUCT_NAME} password below.\"\n", 
"\n", "INTERVIEW_PAGE_CONTENTS_AUTHENTICATE \"\"\n", "INTERVIEW_PAGE_CONTENTS_authenticate_loggedout\n", 
"  \"You have logged out of {PRODUCT_NAME}.  To log back in, please enter your username and password below.\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_CONFIGPASSWORDC\n", "  \"You need a password to \n", "   {IFEQUAL:{CONFIGURATION_MODE}:create_database:\n", 
"      THEN:\n", "        create the database\n", "      :ELSE:\n", "        {IFEQUAL:{CONFIGURATION_MODE}:update_database:\n", 
"	  THEN:\n", "            update the database\n", "	  :ELSE:\n", "	    view the statistics}\n", "   }\n", 
"   for this configuration. Please enter this password below.\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_verifydelete\n", 
"  \"Please verify that you want to delete <b>{DELETE_CONFIG_NAME}</b> by entering the {PRODUCT_NAME} password below.\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_configdeleted\n", "  \"The configuration <b>{DELETE_CONFIG_NAME}</b> has been deleted.  Please click Finish to return to \n", 
"  <a href=%22{PRODUCTEXE}%22>the Main Menu</a>.\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_createmanyconfigs\n", 
"  \"Please choose the existing configuration you want to use as your template from the menu. \n", "  The new configurations will be created by copying that configuration.<p>\n", 
"  Then enter the names of your new configurations, one per line (hit return after each name) \n", "  in the field below (see [docs-multipleusers] for an example).\n", 
"  When you click Next, new configurations will be created using the \n", "  names you specified.  In addition, all occurrences of the template configuration's name in any \n", 
"  configuration option will be replace with the new configuration's name--for instance if the \n", 
"  template configuration is called template.com, the original log pathname is /www/template.com/logs, and\n", 
"  new configuration is named newconfig.com, then the log pathname in the new configuration will be \n", 
"  /www/newconfig.com/logs.<p>\n", "  You can optionally add a | (vertical bar) on any line after the configuration name, followed by\n", 
"  any configuration options (in command-line format)\n", "  you want changed in that configuration; for instance, typing %22<code>config1|-cvsp kitten -luin t</code>%22 \n", 
"  on a line will create a configuration called config1, and will set the password for that configuration \n", 
"  to %22kitten%22, and will turn on DNS lookup.  See [docs-options] and [docs-commandline]\n", "  for details on configuration options and command-line formatting.\"\n", 
"TEMPLATE_LABEL \"Template configuration\"\n", "CONFIGURATION_NAMES_LABEL \"New configuration names and options\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_createdmanyconfigs1\n", "  \"The following configurations have been created, based on the <b>{TEMPLATE_CONFIG_NAME}</b> configuration.\"\n", 
"INTERVIEW_PAGE_CONTENTS_createdmanyconfigs2\n", "  \"Please click Finish to return to the Administrative Menu.<p>\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_lp\n", "  \"Please specify where you would like {PRODUCT_NAME} to get your log data from.\"\n", 
"INTERVIEW_PAGE_CONTENTS_lp_rightcolumn\n", "  \"{IFEQUAL:{INTERVIEW}:addlogdata:\n", "   THEN:\n", 
"     This log data will be added immediately to the database when you click the button below.\n", "     The log data must be in the same format as the original Log Source you specified.\n", 
"   :ELSE:\n", "     This log data will be processed, stored in a database, and then used to display the statistics.\n", 
"  }\n", "  If you do not know what log files are, or you don't know where your server stores its log files,\n", 
"  please ask your web site's system administrator (technical support), or consult the web server documentation.\n", 
"  <p>\n", "  NOTE:\n", "  All of the log data must use the same format--you cannot analyze different log types in a single configuration.\n", 
"  If you want to analyze several types of log files \n", "  (e.g. referrer, agent, and access logs), you need to create a configuration for each type.<p>\n", 
"  {LOG_SOURCE_GZIP_COMMENT}\n", "  \"\n", "\n", "\n", "SHOW_EXAMPLES \"Show Log Source Examples\"\n", 
"SHOW_MATCHES \"Show Matching Files\"\n", "\n", "LSU_EXAMPLES_START\n", "\"Log source examples:<p>\n", 
"<ul>\n", "\"\n", "LSU_EXAMPLES_WINDOWS\n", "\"\n", "<b>C:%5Clogs%5Cweb.log</b>&nbsp;&nbsp;(a single log file named web.log in the %22logs%22 folder on the C: drive)<p>\n", 
"<b>C:%5Clogs%5C*</b>&nbsp;&nbsp;(all the files in the %22logs%22 folder on the C: drive)<p>\n", "<b>C:%5Clogs%5C*.log</b>&nbsp;&nbsp;(all the files whose names end with %22.log%22 in the %22logs%22 folder of the C: drive)<p>\n", 
"\"\n", "LSU_EXAMPLES_MAC\n", "\"\n", "<b>My Hard Drive:logs:web.log</b>&nbsp;&nbsp;(a single file named %22web.log%22 in the %22logs%22 folder of the %22My Hard Drive%22 disk)<p>\n", 
"<b>My Hard Drive:logs:*</b>&nbsp;&nbsp;(all the files in the %22logs%22 folder of the %22My Hard Drive%22 disk)<p>\n", 
"<b>My Hard Drive:logs:*.log</b>&nbsp;&nbsp;(all the files whose names end with %22.log%22 in the %22logs%22 folder of the %22My Hard Drive%22 disk)<p>\n", 
"\"\n", "LSU_EXAMPLES_UNIX\n", "\"\n", "<b>/var/logs/httpd/access.log</b>&nbsp;&nbsp;(a single log file)<p>\n", 
"<b>/var/logs/httpd/*</b>&nbsp;&nbsp;(all the files in the /var/logs/httpd directory)<p>\n", "<b>/var/logs/httpd/*.log</b>&nbsp;&nbsp;(all the files whose names with with .log in the /var/logs/httpd directory)<p>\n", 
"\"\n", "LSU_EXAMPLES_END\n", "\"\n", "<b>ftp://bob:crazy@ftp.myserver.com/logs/access.log</b>&nbsp;&nbsp;(a single file called access.log, in the logs directory of bob's home directory on the FTP site ftp.myserver.com, logging in as user bob with password %22crazy%22).<p>\n", 
"<b>ftp://ftp.myserver.com/mysite/access*.log</b>&nbsp;&nbsp;(all the files whose names start with %22access%22 and end with %22.log%22 in the %22mysite%22 directory of the FTP site ftp.myserver.com, logging in anonymously).<p>\n", 
"<b>ftp://bob:crazy@ftp.myserver.com:12345//mysite/access*.log</b>&nbsp;&nbsp;(all the files whose names start with %22access%22 and end with %22.log%22 in the %22/mysite%22 directory of the FTP site ftp.myserver.com (which is running FTP service on port 12345), logging in as user bob with password %22crazy%22).<p>\n", 
"<b>`/bin/bunzip2 -c /logs/*.bz2`</b>&nbsp;&nbsp;(UNIX; bunzips, on the fly, all the files ending with .bz2 in the /logs directory, and processes the uncompressed log data).<p>\n", 
"</ul>\n", "\"\n", "\n", "LOG_SOURCE_GZIP_COMMENT\n", "  \"Files with names ending in .gz, .bz2, or .zip will be uncompressed on the fly, leaving the original files compressed.\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_verifydbdelete\n", "  \"The database you are creating (<b>{DELETING_DATABASE}</b>) already exists.\n", 
"  If you continue, the current contents of the database will be <b>erased</b>,\n", "  and a new database will be created.\n", 
"  The {PRODUCT_NAME} database will be \n", "  erased if you click {NEXT_BUTTON}, not the log data itself-- \n", 
"  your log data will never be erased or changed by {PRODUCT_NAME}.\n", "  If you are sure that you want to do this, click {NEXT_BUTTON} now.  Otherwise, click your browser's Back button.\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_structure\n", "  \"The format of your log data is <b>{log_file_format}</b>.<p>\n", 
"    Please choose the information you want to track in your database.\n", "    The more information you track, \n", 
"    the longer {PRODUCT_NAME} will take to build your database, and the larger your database will be.\n", 
"    See [docs-dbdetail] for complete information about what these options mean.\"\n", "DETAIL_LEVEL \"Detail level\"\n", 
"XREF_DATETIME_TO_ALL_FIELDS \"Track all fields day-by-day (use calendar; allow expiration of data)\"\n", 
"TRACK_INDIVIDUAL_HOSTS \"Track hosts/IPs individually (rather than tracking only top-level domains)\"\n", 
"INCLUDE_BROKEN_LINKS_VIEW \"Include broken links (404s) view in statistics\"\n", "TRACK_SESSION_INFO \"Track session info (entry pages, exit pages, paths, etc.)\"\n", 
"\n", "INTERVIEW_PAGE_CONTENTS_NONE_MATCHING_lff\n", "  \"Your log data does not seem to be in any format {PRODUCT_NAME} knows about. \n", 
"  If you know the format of your log data, please select it in the list below.  The format you select below <i>must</i> \n", 
"  match the actual format of your log data; otherwise, the statistics will be garbled.<p>\"\n", "\n", 
"INTERVIEW_PAGE_CONTENTS_MULTIPLE_MATCHING_lff\n", "  \"Your log data matches more than one possible format, so {PRODUCT_NAME} cannot determine its format automatically. \n", 
"  Please select the format of your log data from the list below.  If you don't know, try choosing the first one \n", 
"  (even if it's not the right one, it won't damage anything-- the statistics will just be strange, and you can \n", 
"  come back and try another).<p>\"\n", "\n", "INTERVIEW_PAGE_CONTENTS_lff_bluecoatcustom\n", "  \"If your log format is a Blue Coat custom log format, choose BlueCoat Custom from \n", 
"  the menu, and enter the format string below.\"\n", "INTERVIEW_PAGE_CONTENTS_lff_apachecustom\n", 
"  \"If your log format is an Apache custom log format, \n", "  choose Apache Custom from the menu, and enter the format string below.\"\n", 
"\n", "INTERVIEW_PAGE_CONTENTS_lff_lower\n", "  \"If your log format is a common one, and does not appear in this list, please send mail to\n", 
"  <a href=mailto:{SUPPORT_EMAIL}>{SUPPORT_EMAIL}</a>, and we will add it.<p>\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_configname\n", 
"  \"{IFEQUAL:{INTERVIEW}:quickstart:\n", "     THEN:\n", "       Please choose a name for this new configuration, and click {SAVE_BUTTON} to save the configuration,\n", 
"       build the database, and view the statistics.\n", "     :ELSE:\n", "       Please choose a name for this new configuration, and click {SAVE_BUTTON} to save the configuration.\n", 
"    }\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_configcreated\n", "  \"A configuration called <b>{CONFIG_NAME}</b> has been created.<p>\n", 
"  {IFEQUAL:{CONFIG_INTERVIEW_TYPE}:browselog:\n", "    THEN:\n", "      You can access this configuration at any time from [docs-adminmenu],\n", 
"      to browse the current log data from the log source you specified.<p>\n", "      To view these statistics now, click View Statistics\n", 
"      below.<p>\n", "      <center>\n", "        <input type=submit name=browselog value=%22View Statistics\\\\: {CONFIG_NAME}%22>\n", 
"      </center><p>\n", "      You can also view these statistics at any time by \n", "      pointing your web browser to the following URL\\\\:<p>\n", 
"      <ul>\n", "        {FULLLINK:?rfcf+%22{CONFIG_NAME}%22+cm+vs}\n", "      </ul>\n", "      {IFEQUAL:{WARN_ABOUT_CGI_BIN}:true:THEN:{CGI-WARNING}:ELSE:}\n", 
"      Or click Finish to return to [docs-adminmenu]\n", "    :ELSE:\n", "      You can access this configuration at any time from [docs-adminmenu],\n", 
"      to create the database from scratch using the log source you specified, or to add the data\n", 
"      from the log source to the database, or to view the statistics from the database.\n", "      To build the database now, and view the statistics, click the \n", 
"      Create Database button\\\\:<p>\n", "      <center>\n", "        <input type=submit name=createdatabase value=%22Create Database\\\\: {CONFIG_NAME}%22>\n", 
"      </center><p>\n", "      You can also create the database, update the database, or view the statistics \n", 
"      at any time by pointing your web browser to one of the following URL\\\\:<p>\n", "      <ul>\n", 
"        <table border=0>\n", "          <tr><td align=right>Create Database\\\\:</td><td>\n", "            {FULLLINK:?rfcf+%22{CONFIG_NAME}%22+cm+cd}\n", 
"          </td></tr>\n", "          <tr><td align=right>Update Database\\\\:</td><td>\n", "            {FULLLINK:?rfcf+%22{CONFIG_NAME}%22+cm+ud}\n", 
"          </td></tr>\n", "          <tr><td align=right>View Statistics\\\\:</td><td>\n", "            {FULLLINK:?rfcf+%22{CONFIG_NAME}%22+cm+vs}\n", 
"          </td></tr>\n", "        </table>\n", "      </ul>\n", "      {IFEQUAL:{WARN_ABOUT_CGI_BIN}:true:THEN:{CGI-WARNING}:ELSE:}\n", 
"      Or click Finish to return to [docs-adminmenu].<p>\n", "  }\"\n", "CGI-WARNING\n", "  \"If {PRODUCT_NAME} is not in the cgi-bin {DIRECTORY_WORD} on your web server,\n", 
"  you may need to modify the /cgi-bin/ part of the URL; see also [cd].\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_loganalysisinfo_readonly\n", 
"  \"<font color=#ff0000>LogAnalysisInfo exists, but {PRODUCT_NAME} is not able to create files \n", 
"  in it.\n", "  Please adjust the permissions to allow {PRODUCT_NAME} to create files and {PLURALIZE:{DIRECTORY_WORD}} \n", 
"  in LogAnalysisInfo \n", "  {IFDEFINED:RUNNING_USERNAME:\n", "           ({PRODUCT_NAME} seems to be running as user %22{RUNNING_USERNAME}%22&152;please give that user write permissions to the LogAnalysisInfo {DIRECTORY_WORD})}.\n", 
"  </font><p>\"\n", "INTERVIEW_PAGE_CONTENTS_loganalysisinfo\n", "  \"{PRODUCT_NAME} stores configurations and other information\n", 
"  in a directory (folder) on your hard drive called LogAnalysisInfo. \n", "  It cannot create this folder itself because it does not have \n", 
"  write permission (the {PRODUCT_NAME} program is currently in a read-only {DIRECTORY_WORD}). \n", 
"  Please create a {DIRECTORY_WORD} called LogAnalysisInfo in the same folder as the {PRODUCT_NAME} program, \n", 
"  and make it writable by {PRODUCT_NAME}.<p>\n", "  <font size=-1>Note for expert users: if you want LogAnalysisInfo to be somewhere \n", 
"  other than the {DIRECTORY_WORD} containing the {PRODUCT_NAME} program, you can do that by \n", "  creating it somewhere else, and creating a text file called LogAnalysisInfoDirLoc, in the same \n", 
"  folder as {PRODUCT_NAME}, and making the contents of that file be the full pathname of \n", "  LogAnalysisInfo (see [docs-pathnames]).\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_sd\n", "  \"{PRODUCT_NAME} needs a local {DIRECTORY_WORD} where it can create files and\n", 
"  then refer to them from the web pages it generates.  This {DIRECTORY_WORD} must be\n", "  writable by {PRODUCT_NAME}, which is run by your web server as a CGI\n", 
"  program{IFDEFINED:RUNNING_USERNAME:\n", "           (it seems to be running as user %22{RUNNING_USERNAME}%22)},\n", 
"  and the {DIRECTORY_WORD} must also be accessible from your web browser as a URL--\n", "  it must be <b>inside your web server's root {DIRECTORY_WORD}</b>.\n", 
"  Please enter such a {DIRECTORY_WORD} below, first\n", "  as a local {DIRECTORY_WORD} pathname and then as a URL (see [docs-pathnames]).\n", 
"  You may either enter the location\n", "  of an existing {DIRECTORY_WORD} (which is writable by {PRODUCT_NAME}, running as a CGI program),\n", 
"  or you may enter the location of a {DIRECTORY_WORD} which does not yet exist, and let {PRODUCT_NAME}\n", 
"  create it for you (in which case you need to make sure {PRODUCT_NAME} has permission to create a directory there).\n", 
"  <p>\"\n", "INTERVIEW_PAGE_CONTENTS_sd_bottom\n", "  \"<p>\n", "  Note: See [docs-sdinfo] for more information on how to choose these values, including \n", 
"  information on specific platforms and web servers.\n", "  <p>\n", "  Note: When you click Next, {PRODUCT_NAME} will immediately try to create the\n", 
"  Temporary {CAPITALIZE:{DIRECTORY_WORD}} (if it doesn't already exist), and will try to create an image in it;\n", 
"  this image will be displayed on the next page as verification that the Temporary {CAPITALIZE:{DIRECTORY_WORD}}\n", 
"  information you have supplied here really works.  If you immediately get an error\n", "  when you click Next (something like\n", 
"  %22unable to create {DIRECTORY_WORD} xxxx,%22 or %22unable to create image file xxxx%22),\n", "  it probably means that the Temporary {CAPITALIZE:{DIRECTORY_WORD}} you have specified does not\n", 
"  exist and cannot be created, or that it exists and cannot be written in.<p>\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_checksd\n", 
"  \"<p>\n", "  {PRODUCT_NAME} has successfully found/created the Temporary {CAPITALIZE:{DIRECTORY_WORD}},\n", 
"  and has created a GIF image in it.  This image should appear\n", "  as a small {PRODUCT_NAME} logo above this paragraph.\n", 
"  <p>\n", "  {PRODUCT_NAME} created this image at <b>{PICTS_DIRECTORY}title.gif</b><p>\n", "  {PRODUCT_NAME} served this image as <b>{SERVER_URL}picts/title.gif</b><p>\n", 
"  <p>\n", "  If it does not appear, it is likely that the Temporary URL\n", "  was chosen incorrectly on the previous interview page (it does not match the Temporary {CAPITALIZE:{DIRECTORY_WORD}});\n", 
"  if this is the case, please go back (using your browser's Back button) and try again.\n", "  <p>\n", 
"  If the logo appeared correctly, then the Temporary {CAPITALIZE:{DIRECTORY_WORD}} and Temporary URL\n", 
"  are set correctly.  Please click Finish to continue.\"\n", "  \n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_passwordprefs\n", 
"  \"{PRODUCT_NAME} can only be configured by authorized users.  Please enter the {PRODUCT_NAME} password below.\"\n", 
"\n", "\n", "ADMINPAGE_SERVERRUNNING\n", "  \"{PRODUCT_NAME} is currently running in web server mode, on port {SERVER_PORT}.\"\n", 
"KILL_SERVER_BUTTON \"Kill the Server\"\n", "\n", "\n", "INTERVIEW_PAGE_CONTENTS_moveloganalysisinfo\n", 
"  \"Please move the file called <code>LogAnalysisInfoDirLoc</code> (which {PRODUCT_NAME} just created) from your\n", 
"  {PRODUCT_NAME} information {DIRECTORY_WORD} ({LOGANALYSISINFO_DIRECTORY})\n", "  to the {DIRECTORY_WORD} which contains {PRODUCT_NAME}.\n", 
"  {PRODUCT_NAME} cannot do this for you because it does not have permission to\n", "  create files in the {DIRECTORY_WORD} containing\n", 
"  it{IFDEFINED:RUNNING_USERNAME: (it currently appears to be running as user %22{RUNNING_USERNAME}%22)}.\n", 
"  After you have moved the file, click Finish to continue.<p>\"\n", "INTERVIEW_PAGE_CONTENTS_moveloganalysisinfo_failed\n", 
"  \"<b>Error: The file <code>LogAnalysisInfoDirLoc</code> cannot be found in the {DIRECTORY_WORD} containing {PRODUCT_NAME}.\n", 
"  Please move <code>{LOGANALYSISINFO_DIRECTORY}LogAnalysisInfoDirLoc</code> to that {DIRECTORY_WORD}, and click Finish again.</b>\"\n", 
"\n", "\n", "INTERVIEW_PAGE_CONTENTS_choosepassword\n", "  \"For security, many of {PRODUCT_NAME}'s options are protected by\n", 
"  a password.  Please choose this password now; you will need to enter it\n", "  whenever you want to perform any secure action in the future.\"\n", 
"CHOOSE_PASSWORD_LABEL\n", "  \"Please choose a password\"\n", "RETYPE_PASSWORD_LABEL\n", "  \"Please retype the password\"\n", 
"PASSWORD_LABEL\n", "  \"Password:\"\n", "CHOOSE_PASSWORD_QUICK_START_LABEL\n", "  \"Click Quick Start below for the fastest possible route to seeing your statistics.\n", 
"  Quick Start will ask where your logs are, what you want to track, and what you want\n", "  to call your statistics.  Then it will read your logs into a database and \n", 
"  show you your statistics immediately.  It's a good way to start using {PRODUCT_NAME}, \n", "  but if you'd rather go straight to the Administrative Menu ({PRODUCT_NAME}'s main menu, which also contains a link \n", 
"  to the full documentation), you can click Admin Menu below.\"\n", "\n", "# Units of time for the Scheduler\n", 
"SCHED_UNIT_NAME_month month\n", "SCHED_UNIT_NAME_weekday day\n", "SCHED_UNIT_NAME_monthday day\n", 
"SCHED_UNIT_NAME_hour hour\n", "SCHED_UNIT_NAME_minute minute\n", "SCHED_UNIT_NAME_second second\n", 
"\n", "EVERY_WEEKDAY \"every {WEEKDAY_{PARAM1}}\"\n", "\n", "ALL_CONFIGURATIONS \"all configurations\"\n", 
"SOME_CONFIGURATIONS \"configurations matching pattern:\"\n", "\n", "MUST_REBUILD_DATABASE \"Changes will not take effect until the database is rebuilt.\"\n", 
"SIZES_ARE_IN_PIXELS \"All sizes are in pixels.\"\n", "SIMULTANEOUS_LIMITS_TEXT \"\n", "  If you want to allow multiple kinds of filters to be active simultaneously,\n", 
"  check one or more boxes below.  The more boxes you check, the more space and \n", "  time your database will need-- you should not check more than you really need.\n", 
"  If you check them all, your database will take almost forever to build, and you \n", "  will probably run out of disk space before it's done.\"\n", 
"\n", "NUMBER_OF_BYTES \"Number of bytes\"\n", "\n", "\n", "CREATE_UPDATE_DATABASE_LOG_DESCRIPTION\n", 
"  \"{IFEQUAL:{CONFIGURATION_MODE}:create_database:THEN:Rebuilt database:ELSE:Updated database}.\n", 
"  ({LOG_SOURCE_DESCRIPTION}). Added {NUM_LOG_ENTRIES} entries.  Click <b>{VIEW_STATISTICS_BUTTON}</b> to see the statistics.\"\n", 
"CREATED_CONFIG_DESCRIPTION\n", "  \"Created configuration {config_name}.  Now click <b>{VIEW_STATISTICS_BUTTON}</b> to process the log data and view the results.\"\n", 
"CONVERTED_61_DATABASE_DESCRIPTION\n", "  \"Converted database for {config_name} from 6.0/6.1 format to 6.2 format.  The old database can now be deleted.\"\n", 
"GENERATED_HTML_FILES_DESCRIPTION\n", "  \"Generated static HTML files into the {DIRECTORY_WORD} <b>{PARAM1}</b>.  This {DIRECTORY_WORD} is self-contained and can be moved or browsed without using {PRODUCT_NAME}.\"\n", 
"\n", "LOG_SOURCE_DIRECTORY_DESCRIPTION \"All log files in the specified directory, whose filenames match the pattern, will be processed.\"\n", 
"LOG_SOURCE_FTP_DIRECTORY_DESCRIPTION \"All log files in the specified directory on the FTP site, whose filenames match the pattern, will be processed.\"\n", 
"\n", "SCHEDULER_TITLE \"{PRODUCT_NAME} Scheduler\"\n", "SCHEDULING_NOTE\n", "  \"Note: Scheduling will only work while {PRODUCT_NAME} is \n", 
"  running as a web server, or in scheduler mode; see [docs-scheduling].\"\n", "SCHEDULER_BUILD_DATABASE \"Build Database\"\n", 
"SCHEDULER_UPDATE_DATABASE \"Update Database\"\n", "SCHEDULER_EXPIRE_DATABASE \"Expire Database\"\n", 
"SCHEDULER_GENERATE_HTML_FILES \"Generate HTML Files\"\n", "SCHEDULER_SEND_VIEW_BY_EMAIL \"Send View By Email\"\n", 
"SCHEDULER_CONVERT_61_DATABASE \"Convert 6.0/6.1 Database\"\n", "SCHEDULER_CONFIGURATION_LABEL \"Configuration:\"\n", 
"SCHEDULER_WHEN_LABEL \"When:\"\n", "SCHEDULER_WHAT_TO_DO_LABEL \"What to do:\"\n", "ANY_UNIT_NAME \"any {UNIT_NAME}\"\n", 
"\n", "SCHEDULER_CONFIGURATION \"configuration %22{PARAM1}%22\"\n", "SCHEDULER_ALL_CONFIGURATIONS \"all configurations, in order\"\n", 
"SCHEDULER_SOME_CONFIGURATIONS \"configurations matching {PARAM1}, in order\"\n", "SCHEDULER_OPERATION_create_database \"Build database for {PARAM2}\"\n", 
"SCHEDULER_OPERATION_update_database \"Update database for {PARAM2}\"\n", "SCHEDULER_OPERATION_expire_database \"Expire database for {PARAM2}\"\n", 
"SCHEDULER_OPERATION_generate_html_files \"Generate HTML files for {PARAM2}\"\n", "SCHEDULER_OPERATION_send_view_by_email \"Send view by email for {PARAM2}\"\n", 
"\n", "# Subjects for action emails \n", "ACTION_create_database \"Build database for {PARAM2}\"\n", 
"ACTION_update_database \"Update database for {PARAM2}\"\n", "ACTION_expire_database \"Expire database for {PARAM2}\"\n", 
"ACTION_generate_html_files \"Generate HTML files for {PARAM2}\"\n", "ACTION_send_view_by_email \"Send view by email for {PARAM2}\"\n", 
"ACTION_EMAIL_SUBJECT \"{PRODUCT_NAME}: {ACTION_{PARAM1}}\"\n", "ACTION_ERROR_EMAIL_SUBJECT \"{PRODUCT_NAME}: ERROR: {ACTION_{PARAM1}}\"\n", 
"ACTION_EMAIL_CONTENTS \"{PRODUCT_NAME} has performed the following action:\n\n  {ACTION_{PARAM1}}\"\n", 
"ACTION_ERROR_EMAIL_CONTENTS \"{PRODUCT_NAME} encountered an error while performing the following action:\n\n  {ACTION_{PARAM1}}\"\n", 
"\n", "\n", "HELP_COMMAND_LINE_NAME \"Command line name\"\n", "HELP_COMMAND_LINE_SHORTCUT \"Command line shortcut\"\n", 
"HELP_COMMAND_CATEGORY \"Options category\"\n", "HELP_COMMAND_SHORT_DESCRIPTION \"Brief description\"\n", 
"HELP_COMMAND_LINE_FORMAT \"Command line format\"\n", "\n", "\n", "VIEW_OPTIONS_FILTERS \"Filters\"\n", 
"VIEW_OPTIONS_FILTERS_NO_DATABASE \"unavailable until database is built\"\n", "VIEW_OPTIONS_SORT_BY \"Sort\"\n", 
"VIEW_OPTIONS_SHOW_SUBVIEW \"Visible\"\n", "VIEW_OPTIONS_TYPE \"Type\"\n", "FIELDS_LISTED_ARE_IN_BUILT_DATABASE \n", 
"  \"The Type menu shows fields in the built database.  Rebuild to show recently added fields.\"\n", 
"OPTIONS_MENU_NOTE\n", "  \"Options menu items are parenthesized if hidden.  Select an item to change its visibility.\"\n", 
"VIEW_OPTIONS_SHOW_SUBVIEW_OFFLINE \"Visible offline\"\n", "VIEW_OPTIONS_MAX_ROWS \"Max rows\"\n", "VIEW_OPTIONS_MAX_ROWS_OFFLINE \"Max rows offline\"\n", 
"VIEW_OPTIONS_MAX_DEPTH_OFFLINE \"Max depth offline\"\n", "VIEW_OPTIONS_SHOW_HIDE \"Options\"\n", "\n", 
"BOOLEAN_VALUE \"Boolean value\"\n", "\n", "# Licensing\n", "LICENSE_LABEL \"License\"\n", "LICENSE_TYPE \"Type\"\n", 
"LICENSE_USERS \"Users\"\n", "LICENSE_EXPIRATION \"Expiration\"\n", "LICENSE_UNLIMITED \"unlimited\"\n", 
"NO_LICENSE_TEXT \n", "  \"<b>This copy of {PRODUCT_NAME} is not yet licensed</b><p>\n", "  Please enter your license in the field below, and click Add License.<p>\"\n", 
"30_DAY_TRIAL_BUTTON \"Try {PRODUCT_NAME} for 30 Days\"\n", "30_DAY_TRIAL_TEXT \n", "  \"If you don't have a license, you can still try {PRODUCT_NAME} for free for 30 days by clicking here:\"\n", 
"ADD_LICENSE_TEXT \"To add a license, enter the license in the field below, and click Add License.\"\n", 
"ADD_LICENSE_BUTTON \"Add License\"\n", "LICENSED_TEXT \"This copy of {PRODUCT_NAME} is licensed\"\n", 
"LICENSE_EXPIRED_TEXT \n", "  \", but all licenses have expired.<br>\n", "  To continue use {PRODUCT_NAME}, you need to get another license.</center><p>\"\n", 
"\n", "# Output of get_hits\n", "GET_HITS_HITS \"hits\"\n", "GET_HITS_BYTES \"bandwidth\"\n", "GET_HITS_PAGE_VIEWS \"page views\"\n", 
"GET_HITS_VISITORS \"visitors\"\n", "\n", "# Font information\n", "FONT_FACE Face\n", "FONT_SIZE Size\n", 
"FONT_BOLD Bold\n", "FONT_ITALICS Italics\n", "FONT_COLOR Color\n", "\n", "# Editor variables\n", "TREE_TYPE_LOG_FIELD \"log field\"\n", 
"TREE_TYPE_DATABASE_FIELD \"database field\"\n", "TREE_TYPE_LOG_FILTER \"log filter\"\n", "TREE_TYPE_LOG_PARSING_FILTER \"log parsing filter\"\n", 
"TREE_TYPE_SCHEDULED_ACTION \"scheduled action\"\n", "TREE_TYPE_VIEW \"view\"\n", "TREE_TYPE_SUBVIEW \"subview\"\n", 
"TREE_TYPE_LOG_SOURCE \"log source\"\n", "TREE_EDITOR_INSTRUCTIONS_CREATE_ONLY\n", "  \"(Click {DUPLICATE_GIF} to create a {OBJECTNAME}.)\"\n", 
"TREE_EDITOR_INSTRUCTIONS\n", "  \"{X_GIF} to delete;\n", "  &nbsp;{LOWER_GIF} to move it down (and move the one below it up);\n", 
"  &nbsp;&nbsp;{DUPLICATE_GIF} to duplicate/create;\n", "  {RIGHT_GIF} to edit.\"\n", "TREE_EDITOR_CREATE\n", 
"  \"Click here to create a new {OBJECTNAME}\"\n", "TREE_EDITOR_EXPAND_ALL\n", "  \"Click here to expand every {OBJECTNAME}\"\n", 
"TREE_EDITOR_COLLAPSE_ALL\n", "  \"Click here to collapse every {OBJECTNAME}\"\n", "TREE_EDITOR_FINAL_FILTER\n", 
"  \"accept this log entry as a page view (final filter)\"\n", "\n", "\n", "ALL_LOG_ENTRIES_REJECTED_TITLE \"No valid log entries found\"\n", 
"ALL_LOG_ENTRIES_REJECTED_TEXT\n", "  \"<font size=%22+2%22>{PRODUCT_NAME} did not find any valid log entries,\n", 
"  so the statistics are not available.</font><p>\n", "  There are several reasons \n", "  why this can happen:<p>\n", 
"  <ol>\n", "    <li> <b>Cause</b>: If you selected a log format manually, the format you selected \n", 
"         may not match the actual format of your log data.<br>\n", "         <b>Solution</b>:  Please make sure \n", 
"         you have chosen the correct log format.  If you are certain the log format you\n", "         selected was correct, please see the #2 below.<p>\n", 
"    <li> <b>Cause</b>: If {PRODUCT_NAME} detected your log format for you, there may be a bug in \n", 
"         {PRODUCT_NAME}'s support for this log format which is preventing it from \n", "         processing your log data correctly.<br>\n", 
"         <b>Solution:</b>: Please send your log file to \n", "         <a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a> \n", 
"         so we can investigate this problem.<p>\n", "    <li> <b>Cause</b>: Your log data may be empty, and contain no log entries at all.<br> \n", 
"         <b>Solution</b>: Please make sure there is at least one log entry in your log data \n", "         before viewing the statistics.<p>\n", 
"    <li> <b>Cause</b>: The log filters may be rejecting all the log entries.<br> \n", "         <b>Solution</b>: This shouldn't happen with the default filter set, \n", 
"         but it can happen if you make an error creating a new log filter, and that \n", "         filter ends up rejecting everything.  If you've created custom filters, \n", 
"         please review them (in the Filters tab of the Configuration Options) to make sure they are correct, \n", 
"         and see Debugging, below.<p>\n", "    <li> <b>Cause</b>: If you're using a custom log format, it may be set up incorrectly.<br>\n", 
"         <b>Solution</b>: This shouldn't happen with the built-in log formats (see #2 above if it does), \n", 
"         but it can happen if you make an error creating a custom log format. \n", "         If you're using a custom log format, please review it to make sure they are correct, \n", 
"         and see Debugging, below.<p>\n", "  </ol>\n", "  <b>Debugging</b>: It is possible to get a detailed report of what {PRODUCT_NAME} is doing as it processes your log, \n", 
"  useful for debugging filters and log format errors.  Run {PRODUCT_NAME} from the command line using the -v option \n", 
"  ([v]), for instance like this:\n", "  <pre>  {PRODUCTEXE} -rfcf myconfig -cm cd -v 7</pre>\n", "  and examine the output to see why {PRODUCT_NAME} is rejecting the log entries.<p>\n", 
"  If you still can't get {PRODUCT_NAME} to process your log format to work, please contact \n", "  <a href=%22mailto:{SUPPORT_EMAIL}%22>{SUPPORT_EMAIL}</a>.<p> \n", 
"  Click your browser's Back button to go back to where you were, or go back to \n", "  <a href=%22{PRODUCTEXE}%22>the Administrative Menu</a>.\"\n", 
"\n", "PROGRESS_PAGE_NOT_FOUND_TITLE \"Progress Page Not Found\"\n", "PROGRESS_PAGE_NOT_FOUND_TEXT \n", 
"  \"The progress page is not available.  This usually means that {PRODUCT_NAME} \n", "  terminated and restarted while it was performing a long operation. \n", 
"  Please use your browser's Back button to return to where you started the operation, \n", "  and try again.\"\n", 
0 };

